from datetime import datetime
from typing import IO

class BaseCache:
    def get(self, key: str) -> bytes | None: ...
    def set(self, key: str, value: bytes, expires: int | datetime | None = None) -> None: ...
    def delete(self, key: str) -> None: ...
    def close(self) -> None: ...

class SeparateBodyBaseCache(BaseCache):
    def set_body(self, key: str, body: bytes) -> None: ...
    def get_body(self, key: str) -> IO[bytes] | None: ...
