# Changelog

<!--next-version-placeholder-->

## v2.6.0 (2024-06-29)

### Feature

* Add q revo pro/p10 pro support ([#220](https://github.com/humbertogontijo/python-roborock/issues/220)) ([`5e6a2d6`](https://github.com/humbertogontijo/python-roborock/commit/5e6a2d6a7171da146efb3e59ddb3215c2a573507))

## v2.5.0 (2024-06-25)

### Feature

* Add some typing ([#219](https://github.com/humbertogontijo/python-roborock/issues/219)) ([`35d0900`](https://github.com/humbertogontijo/python-roborock/commit/35d09000b8d144cbaf935069952ea135950d0e78))

## v2.4.0 (2024-06-25)

### Feature

* Add some missing codes and make warnings only message once ([#218](https://github.com/humbertogontijo/python-roborock/issues/218)) ([`12361b5`](https://github.com/humbertogontijo/python-roborock/commit/12361b58e7a4d368281c4ffd9ac3d8e9d8155e62))

## v2.3.0 (2024-06-07)

### Feature

* Add warning in web requests if it fails to decode ([#215](https://github.com/humbertogontijo/python-roborock/issues/215)) ([`6ae69e9`](https://github.com/humbertogontijo/python-roborock/commit/6ae69e9bcba6a98736f2f480114922186f6ca458))

## v2.2.3 (2024-06-04)

### Fix

* S8 maxv has a wash and fill dock ([#213](https://github.com/humbertogontijo/python-roborock/issues/213)) ([`018fd05`](https://github.com/humbertogontijo/python-roborock/commit/018fd052360dffd238919e336943809720457c4e))

## v2.2.2 (2024-05-16)

### Fix

* Handle weird clean record response ([#206](https://github.com/humbertogontijo/python-roborock/issues/206)) ([`07ce71a`](https://github.com/humbertogontijo/python-roborock/commit/07ce71a2cd8085136952bd7639f6f4a2e273faf9))

## v2.2.1 (2024-05-11)

### Fix

* Add missing value "high = 203" to RoborockMopIntensityS8MaxVUltra ([#205](https://github.com/humbertogontijo/python-roborock/issues/205)) ([`886b0e6`](https://github.com/humbertogontijo/python-roborock/commit/886b0e6a8a4b98ff74964d59f4c8c0fbbf569688))

## v2.2.0 (2024-05-09)

### Feature

* Improve some typing ([#204](https://github.com/humbertogontijo/python-roborock/issues/204)) ([`7752db9`](https://github.com/humbertogontijo/python-roborock/commit/7752db9066fa49bb93a6268a491e2a0baa608cfc))

## v2.1.1 (2024-05-08)

### Fix

* Set roommapping when it is only one room ([#203](https://github.com/humbertogontijo/python-roborock/issues/203)) ([`26af66b`](https://github.com/humbertogontijo/python-roborock/commit/26af66bd5d8dbfa4c94a9add317ccc9ca9161510))

## v2.1.0 (2024-05-08)

### Feature

* Add s8_maxv_ultra info ([#202](https://github.com/humbertogontijo/python-roborock/issues/202)) ([`aaaf0f0`](https://github.com/humbertogontijo/python-roborock/commit/aaaf0f0c381924524a079f600de14db1cd61ed45))

## v2.0.0 (2024-04-11)

### Feature

* Add zeo support and fix some a01 weirdness ([#200](https://github.com/humbertogontijo/python-roborock/issues/200)) ([`e825ff5`](https://github.com/humbertogontijo/python-roborock/commit/e825ff5811516b4034e9b41769e5912c99cf0166))

### Breaking

* You must now specify what version api you want to use with clients. ([`e825ff5`](https://github.com/humbertogontijo/python-roborock/commit/e825ff5811516b4034e9b41769e5912c99cf0166))

## v1.0.0 (2024-04-09)

### Breaking

* You must now specify what version api you want to use with clients. ([`16b9e3e`](https://github.com/humbertogontijo/python-roborock/commit/16b9e3e8261db3ec38d6bc24661ecf40c6bb0870))

## v0.41.0 (2024-03-06)

### Feature

* Add v1 api ([#194](https://github.com/humbertogontijo/python-roborock/issues/194)) ([`9fb124e`](https://github.com/humbertogontijo/python-roborock/commit/9fb124ecdd0a979ff8f2c742eb4dd625b7e9292f))

## v0.40.0 (2024-03-03)

### Feature

* Add nonce to diagnostic data ([#195](https://github.com/humbertogontijo/python-roborock/issues/195)) ([`ceafcb6`](https://github.com/humbertogontijo/python-roborock/commit/ceafcb6e30c60f6f6ad3833ab73861c18413b806))

## v0.39.2 (2024-02-26)

### Fix

* Bump construct and add wm category ([#192](https://github.com/humbertogontijo/python-roborock/issues/192)) ([`2f18b35`](https://github.com/humbertogontijo/python-roborock/commit/2f18b35755776844e266c893b126a830622afd43))

## v0.39.1 (2024-01-24)

### Fix

* Remove problematic code ([#189](https://github.com/humbertogontijo/python-roborock/issues/189)) ([`a9e12ca`](https://github.com/humbertogontijo/python-roborock/commit/a9e12ca122b467d74e9cd29dc031802cf0f551bc))

## v0.39.0 (2024-01-03)

### Feature

* Add async_release ([#179](https://github.com/humbertogontijo/python-roborock/issues/179)) ([`ae58627`](https://github.com/humbertogontijo/python-roborock/commit/ae58627bda324c29090b7c4ab78776288a30a64d))

## v0.38.0 (2023-12-11)

### Feature

* Add information from product api ([#158](https://github.com/humbertogontijo/python-roborock/issues/158)) ([`22720ae`](https://github.com/humbertogontijo/python-roborock/commit/22720aee79e582328ae642e61d57dc2e3a92ec1c))

## v0.37.0 (2023-12-10)

### Feature

* House keeping, version bumping, doc fixes, doc improvements, v2 home data api ([#157](https://github.com/humbertogontijo/python-roborock/issues/157)) ([`f3ca9b4`](https://github.com/humbertogontijo/python-roborock/commit/f3ca9b45d3de3a15c57e134421d3abc11095bc22))

## v0.36.2 (2023-11-22)

### Fix

* Typing and error checking ([#149](https://github.com/humbertogontijo/python-roborock/issues/149)) ([`d94aa48`](https://github.com/humbertogontijo/python-roborock/commit/d94aa48c1e594f7f6cd1cff16da66169368fb86c))

## v0.36.1 (2023-11-08)

### Fix

* Typing for map ([#141](https://github.com/humbertogontijo/python-roborock/issues/141)) ([`64121ee`](https://github.com/humbertogontijo/python-roborock/commit/64121eee14e4f0ca24db664b0664aaac5c7332af))

## v0.36.0 (2023-11-07)

### Feature

* Update listeners ([#140](https://github.com/humbertogontijo/python-roborock/issues/140)) ([`5498596`](https://github.com/humbertogontijo/python-roborock/commit/549859669941e71c8d7ee09a0d4eea9564b4a12f))

## v0.35.4 (2023-11-03)

### Fix

* Mypy complaints ([#137](https://github.com/humbertogontijo/python-roborock/issues/137)) ([`752e320`](https://github.com/humbertogontijo/python-roborock/commit/752e320644449a83a724590628c4011b9d8bacb2))

## v0.35.3 (2023-10-29)

### Fix

* Typing and versioning ([#134](https://github.com/humbertogontijo/python-roborock/issues/134)) ([`e1dc545`](https://github.com/humbertogontijo/python-roborock/commit/e1dc545f20f2a163240eb72d831025cb2ff3ec7c))

## v0.35.2 (2023-10-29)

### Fix

* Error catch and typing ([#133](https://github.com/humbertogontijo/python-roborock/issues/133)) ([`171c302`](https://github.com/humbertogontijo/python-roborock/commit/171c30265664b0161db75695d2d30d8b45bbf5b3))

## v0.35.1 (2023-10-28)

### Fix

* Add s5 max mop code 207 ([#132](https://github.com/humbertogontijo/python-roborock/issues/132)) ([`adc7ae0`](https://github.com/humbertogontijo/python-roborock/commit/adc7ae0bbb75eb5be452efb62ca93de6a5211eef))

## v0.35.0 (2023-10-18)

### Feature

* **code_mappings:** Add error n53 cleaning tank full or blocked ([#130](https://github.com/humbertogontijo/python-roborock/issues/130)) ([`ebd57a0`](https://github.com/humbertogontijo/python-roborock/commit/ebd57a0b559c0dee605e30eaead58b8433347a84))

## v0.34.6 (2023-10-02)

### Fix

* Add missing 207 code ([#127](https://github.com/humbertogontijo/python-roborock/issues/127)) ([`87431a1`](https://github.com/humbertogontijo/python-roborock/commit/87431a1f155059a51b1b3e2c8867fe18cc476e16))

## v0.34.5 (2023-09-29)

### Fix

* Remove alexapy ([#126](https://github.com/humbertogontijo/python-roborock/issues/126)) ([`38ff4eb`](https://github.com/humbertogontijo/python-roborock/commit/38ff4eb90a1805ad599f61322d7c3547f465868b))

## v0.34.4 (2023-09-28)

### Fix

* Parsing potential list of clean record ([#125](https://github.com/humbertogontijo/python-roborock/issues/125)) ([`df7a920`](https://github.com/humbertogontijo/python-roborock/commit/df7a920a94a632d9653637e0111b3a955db49356))

## v0.34.3 (2023-09-24)

### Fix

* Add custom code for p10 ([#123](https://github.com/humbertogontijo/python-roborock/issues/123)) ([`8b57d50`](https://github.com/humbertogontijo/python-roborock/commit/8b57d50b0c898ca7d3df7cbdfe3682fd03cf649e))

## v0.34.2 (2023-09-21)

### Fix

* Make cache not global ([#122](https://github.com/humbertogontijo/python-roborock/issues/122)) ([`e119201`](https://github.com/humbertogontijo/python-roborock/commit/e119201f1c700d98e3322653440097c91ef4e14c))

## v0.34.1 (2023-09-19)

### Fix

* Status reworking ([#121](https://github.com/humbertogontijo/python-roborock/issues/121)) ([`8f4b7d3`](https://github.com/humbertogontijo/python-roborock/commit/8f4b7d376d5a475798782496ea52ac9674cb9ae7))

## v0.34.0 (2023-09-12)

### Feature

* Add datetime parsing in cleanrecord ([#119](https://github.com/humbertogontijo/python-roborock/issues/119)) ([`5e67fa6`](https://github.com/humbertogontijo/python-roborock/commit/5e67fa648478e573239c2f1dfc4b58c01cae1797))

## v0.33.2 (2023-09-06)

### Fix

* Add missing s5 codes ([#116](https://github.com/humbertogontijo/python-roborock/issues/116)) ([`4d56021`](https://github.com/humbertogontijo/python-roborock/commit/4d560216354fab4ab8b1d452dd6b29008b20d50a))

## v0.33.1 (2023-09-06)

### Fix

* Unknow values on HA component ([#117](https://github.com/humbertogontijo/python-roborock/issues/117)) ([`1323618`](https://github.com/humbertogontijo/python-roborock/commit/1323618c6c58bb6dcef5c7f5f2ca12e32969ba0f))

## v0.33.0 (2023-09-04)

### Feature

* Add q revo/p10 support ([#114](https://github.com/humbertogontijo/python-roborock/issues/114)) ([`b2237d9`](https://github.com/humbertogontijo/python-roborock/commit/b2237d97384d819cbcc62902bbcbb2c7dbe0072e))

## v0.32.4 (2023-08-30)

### Fix

* Refactor cache and call get_status after changing mop mode ([#105](https://github.com/humbertogontijo/python-roborock/issues/105)) ([`8bf70f4`](https://github.com/humbertogontijo/python-roborock/commit/8bf70f4f8b3cabe846bffdc3dd3300f9f621ae97))

## v0.32.3 (2023-08-05)

### Fix

* Resolve unawaited task errors on connect/disconnect ([#103](https://github.com/humbertogontijo/python-roborock/issues/103)) ([`1ad03be`](https://github.com/humbertogontijo/python-roborock/commit/1ad03befa84f9b729a0cc7553b794fe5344a22ce))

## v0.32.2 (2023-08-04)

### Fix

* Waiting queue ([`ff5376b`](https://github.com/humbertogontijo/python-roborock/commit/ff5376be3a4ff4eb90e33118db89214ef699dc6f))

## v0.32.1 (2023-08-04)

### Fix

* Remove coroutine warning ([`da83078`](https://github.com/humbertogontijo/python-roborock/commit/da83078f7ef8f333fa46b75603ce8a88bb97914d))

## v0.32.0 (2023-08-03)

### Feature

* Adding device_id to listeners and fixing race condition on connection, disconnection and messages ([`2bee8a1`](https://github.com/humbertogontijo/python-roborock/commit/2bee8a11ad30cd4a3c186a4c0a619838adc83a53))

## v0.31.1 (2023-08-02)

### Fix

* Add error code for invalid credentials ([#101](https://github.com/humbertogontijo/python-roborock/issues/101)) ([`703f48b`](https://github.com/humbertogontijo/python-roborock/commit/703f48b66cfd32d20e74eaa959a66cd736ca38c8))

## v0.31.0 (2023-07-31)

### Feature

* Add device name to logs ([#100](https://github.com/humbertogontijo/python-roborock/issues/100)) ([`7690d56`](https://github.com/humbertogontijo/python-roborock/commit/7690d5644181abb5fb7681d6c1764e2f8750c4b5))

## v0.30.3 (2023-07-31)

### Fix

* Adding no dustbin to docker errors ([`0e28628`](https://github.com/humbertogontijo/python-roborock/commit/0e286280edda21a3b95c656d5bc358cd4229d075))

## v0.30.2 (2023-07-21)

### Fix

* Possible solution for future invalid state ([`8ac4e72`](https://github.com/humbertogontijo/python-roborock/commit/8ac4e72372f26105423213bb85d4c33d7951af4d))

## v0.30.1 (2023-07-18)

### Fix

* Add missing s8 pro mop code and q revo dock ([#92](https://github.com/humbertogontijo/python-roborock/issues/92)) ([`5d75c3b`](https://github.com/humbertogontijo/python-roborock/commit/5d75c3b794db231e07f8b6693f2a96b132f737ce))

## v0.30.0 (2023-07-10)

### Feature

* Created strong foundation for docs ([#86](https://github.com/humbertogontijo/python-roborock/issues/86)) ([`ef88edd`](https://github.com/humbertogontijo/python-roborock/commit/ef88eddb8b582f5ad958d8135964e39ba6a05c91))

### Fix

* Add missing dock for s7 max ultra ([#88](https://github.com/humbertogontijo/python-roborock/issues/88)) ([`10aff22`](https://github.com/humbertogontijo/python-roborock/commit/10aff22bc1e6d17b1b6c2587ebefcfd1d9fb7be7))
* Listeners getting protocol data before it exists. ([#87](https://github.com/humbertogontijo/python-roborock/issues/87)) ([`3d68ea4`](https://github.com/humbertogontijo/python-roborock/commit/3d68ea4326da827f17a32b2b5645f1e1e43f3eca))

## v0.29.2 (2023-06-28)

### Fix

* Downgrade construct ([#84](https://github.com/humbertogontijo/python-roborock/issues/84)) ([`920f59f`](https://github.com/humbertogontijo/python-roborock/commit/920f59f1fad2790084ee001225bbaff2e21b3f91))

## v0.29.1 (2023-06-27)

### Fix

* Adding scene commands ([`fddbe50`](https://github.com/humbertogontijo/python-roborock/commit/fddbe508f177dc6bc336223007018f501709c995))

## v0.29.0 (2023-06-26)

### Feature

* Adding server timer and retry command compatibility ([`1a1565b`](https://github.com/humbertogontijo/python-roborock/commit/1a1565b1f2eb57fa373c9298dd2501a13914bb0a))

## v0.28.0 (2023-06-26)

### Feature

* Adding status and consumable listeners ([#83](https://github.com/humbertogontijo/python-roborock/issues/83)) ([`ebdbc90`](https://github.com/humbertogontijo/python-roborock/commit/ebdbc907f1f1a2a91ad10953ca6e70b91b9664dd))

## v0.27.2 (2023-06-22)

### Fix

* Cache concurrency ([`7dd3aa4`](https://github.com/humbertogontijo/python-roborock/commit/7dd3aa4933248ede6230a82e6d14e30e8009e27c))

## v0.27.1 (2023-06-22)

### Fix

* Improving cache and refactoring ([`e88854d`](https://github.com/humbertogontijo/python-roborock/commit/e88854d3c6c9109e9fbb4e8ecd3d0ee4ad5d53ff))

## v0.27.0 (2023-06-22)

### Feature

* Improving cache and refactoring ([#82](https://github.com/humbertogontijo/python-roborock/issues/82)) ([`e6d48af`](https://github.com/humbertogontijo/python-roborock/commit/e6d48af4e1c83fe79104d368918613ac0b332cbb))

## v0.26.2 (2023-06-21)

### Fix

* #81 - cli raising exception for diagnostic data ([`690b316`](https://github.com/humbertogontijo/python-roborock/commit/690b316de35c970454a45418682c82d752b81201))

## v0.26.1 (2023-06-20)

### Fix

* Changelog ([#80](https://github.com/humbertogontijo/python-roborock/issues/80)) ([`5c4928b`](https://github.com/humbertogontijo/python-roborock/commit/5c4928b2d414b9decc1a454348e38d29aeb505fa))

## v0.26.0 (2023-06-20)

### Feature

* Adding command cache ([#77](https://github.com/humbertogontijo/python-roborock/issues/77)) ([`505f5e4`](https://github.com/humbertogontijo/python-roborock/commit/505f5e45a56e98c248a38236ae3f02908583de12))

## v0.25.2 (2023-06-17)

### Fix

* Removing python 10 tests ([`46e258b`](https://github.com/humbertogontijo/python-roborock/commit/46e258bc495123c8e8325a731e353f3bc5ce3e0c))
* Downgrading construct version ([`d5148ce`](https://github.com/humbertogontijo/python-roborock/commit/d5148ce8fc553f73819a9f03c7688d53100bdcd9))
* Moving back to python 3.10 due to python-semantic-release incompatibility ([`8ab9352`](https://github.com/humbertogontijo/python-roborock/commit/8ab9352adb2cb82c24057bef3107b28d3a157087))

## v0.25.1 (2023-06-16)

### Fix

* Python-semantic-release python version ([`845da45`](https://github.com/humbertogontijo/python-roborock/commit/845da456a0d59765d08962fee007b63c8d0c50eb))

## v0.25.0 (2023-06-16)

We had some issues with semantic release and ended up skipping a few versions. 
25.0 contains a variety of fixes relating to taht + a few itmes that were not released with semantic release.

### Feature

* Bump python version ([`aae48b1`](https://github.com/humbertogontijo/python-roborock/commit/aae48b1395698136ca90b7fe7386a1b6ea8aaa9c))
* Adding valley_electricity_timer to props ([`0844067`](https://github.com/humbertogontijo/python-roborock/commit/08440670a7fb098f5f3954e2ad09f9a32e64a54e))

### Fix

* Remove python 10 from tests ([`31fc34c`](https://github.com/humbertogontijo/python-roborock/commit/31fc34c22ad9e5f06b588e6b283412902bd2959d))
* Semantic release ([#76](https://github.com/humbertogontijo/python-roborock/issues/76)) ([`224a566`](https://github.com/humbertogontijo/python-roborock/commit/224a5662d2dbdf47d5141554733a9b4aeaf8d4f2))
* Remove dnd timer and valley electricity from props ([#75](https://github.com/humbertogontijo/python-roborock/issues/75)) ([`2035af5`](https://github.com/humbertogontijo/python-roborock/commit/2035af5d524605fcbd0b87e20f256c1c61ca9c68))
* Device_prop update ([`b6d1ccc`](https://github.com/humbertogontijo/python-roborock/commit/b6d1ccc913cff1a7e25745867435146e9f748df7))
* Python-semantic-release ([`80e9c24`](https://github.com/humbertogontijo/python-roborock/commit/80e9c24a39f3147b0fbc0a5437631777ab52b027))

## v0.23.6 (2023-06-08)
### Fix
* Add datetime_time back ([#68](https://github.com/humbertogontijo/python-roborock/issues/68)) ([`a3461dd`](https://github.com/humbertogontijo/python-roborock/commit/a3461dd0a08702add2625df8616ba20d239805ce))

## v0.23.5 (2023-06-08)
### Fix
* Issue building roborock message ([`89e1f28`](https://github.com/humbertogontijo/python-roborock/commit/89e1f28461baaf03029679aed5f91200bb7dac4e))

## v0.23.4 (2023-06-06)
### Fix
* Adding method parse_datetime_to_roborock_datetime ([`64c8159`](https://github.com/humbertogontijo/python-roborock/commit/64c8159a9695374a4b0599a317418949bdd8f3fe))

## v0.23.3 (2023-06-05)
### Fix
* Parse_time_to_datetime method ([`d0fc149`](https://github.com/humbertogontijo/python-roborock/commit/d0fc1498e20217d28703455937f760ba45053c61))

## v0.23.2 (2023-06-05)
### Fix
* Parse_time_to_datetime method ([`bcbc211`](https://github.com/humbertogontijo/python-roborock/commit/bcbc2117dd306c21495c1f3364aa3205b3c5cfce))

## v0.23.1 (2023-06-05)
### Fix
* Parse_time_to_datetime method ([`1c39216`](https://github.com/humbertogontijo/python-roborock/commit/1c39216c0ee6a29d350d08adc5d662d8669f85cf))

## v0.23.0 (2023-06-05)
### Feature
* Add diagnostic data and extra containers ([#67](https://github.com/humbertogontijo/python-roborock/issues/67)) ([`59ef6f4`](https://github.com/humbertogontijo/python-roborock/commit/59ef6f4d5366859ba5d02ba66ec1aa2288564179))

### Fix
* Merging timer entities ([`22ff7f4`](https://github.com/humbertogontijo/python-roborock/commit/22ff7f451166bcfda360552e92d661d0520886ae))

## v0.22.0 (2023-06-05)
### Feature
* Adding type cast for send_command ([`4a0b709`](https://github.com/humbertogontijo/python-roborock/commit/4a0b70997080012e3059150da2b12fb47f6ef43a))

## v0.21.1 (2023-06-05)
### Fix
* Cli json serializing ([#66](https://github.com/humbertogontijo/python-roborock/issues/66)) ([`ab13b53`](https://github.com/humbertogontijo/python-roborock/commit/ab13b53a15822067112edda285c6feddf389a8b8))

## v0.21.0 (2023-06-04)
### Feature
* Add time datetime for valley ([#65](https://github.com/humbertogontijo/python-roborock/issues/65)) ([`c965862`](https://github.com/humbertogontijo/python-roborock/commit/c965862f5b8b1f4dfbc83738cdebc1e11122c387))

## v0.20.2 (2023-06-02)
### Fix
* S6MaxVStatus and minor changes ([`01f84ae`](https://github.com/humbertogontijo/python-roborock/commit/01f84ae741dd3c9fa3bc5932b718abebcc8e3f0f))

## v0.20.1 (2023-06-01)
### Fix
* S8 model name and adding api methods get_child_lock_status and get_sound_volume ([`a3b7cee`](https://github.com/humbertogontijo/python-roborock/commit/a3b7cee63a70746ac3db5e5cee37c5b507b99478))

## v0.20.0 (2023-05-31)
### Feature
* Adds code for duct blockage ([#64](https://github.com/humbertogontijo/python-roborock/issues/64)) ([`84dd5fb`](https://github.com/humbertogontijo/python-roborock/commit/84dd5fbdefebe4b33c6bae6879137847522b1bfb))

## v0.19.0 (2023-05-31)
### Feature
* Moving clean area to api ([#63](https://github.com/humbertogontijo/python-roborock/issues/63)) ([`7ade218`](https://github.com/humbertogontijo/python-roborock/commit/7ade218e3efd44159c6ad40cd88933385bbd1496))

## v0.18.10 (2023-05-30)
### Fix
* Dict with enum instead of value ([`9653c50`](https://github.com/humbertogontijo/python-roborock/commit/9653c50f31b03ce2d3d21e2042d5c194924f4aca))

## v0.18.9 (2023-05-28)
### Fix
* Mqtt reconnections ([`462d4e4`](https://github.com/humbertogontijo/python-roborock/commit/462d4e4a30372c143c9198c7008808ca11800af5))

## v0.18.8 (2023-05-28)
### Fix
* Improve device ping ([`56e4469`](https://github.com/humbertogontijo/python-roborock/commit/56e4469c95ac9255604025df99f0d6ac1940dd19))

## v0.18.7 (2023-05-27)
### Fix
* Change e2 fan codes ([#62](https://github.com/humbertogontijo/python-roborock/issues/62)) ([`7231f1e`](https://github.com/humbertogontijo/python-roborock/commit/7231f1efc412f93bfb5719091337536bcb6185d6))

## v0.18.6 (2023-05-19)
### Fix
* Consumables with time equals 0 ([`ccab5f0`](https://github.com/humbertogontijo/python-roborock/commit/ccab5f0724854ae27bbc51b9ee33f2a96ce709f1))

## v0.18.5 (2023-05-16)
### Fix
* Connection_lost ([`c2ba673`](https://github.com/humbertogontijo/python-roborock/commit/c2ba673f2c198bc78e75e1cf6fc9844e385e85bb))

## v0.18.4 (2023-05-16)
### Fix
* Minor fixes ([`e4a291d`](https://github.com/humbertogontijo/python-roborock/commit/e4a291dd2b011e5852c992dbb23068ef5dde0e52))

## v0.18.3 (2023-05-15)
### Fix
* Keep_alive_func ([`e4aeebc`](https://github.com/humbertogontijo/python-roborock/commit/e4aeebc16317a5c9fe3ffcd3bff89be1f2070dbb))

## v0.18.2 (2023-05-15)
### Fix
* Improving new protocols ([`08c6f95`](https://github.com/humbertogontijo/python-roborock/commit/08c6f9530b202d17ef80047c2d60836f9f9b8422))
* Adding hello command ([`dfa44ff`](https://github.com/humbertogontijo/python-roborock/commit/dfa44ff56a794f30e7c93d0a9a270f2a02da7e65))

## v0.18.1 (2023-05-15)
### Fix
* Type checks ([`58b3322`](https://github.com/humbertogontijo/python-roborock/commit/58b33225b50a221a5f3100055fe28461f5cff884))

## v0.18.0 (2023-05-15)
### Feature
* Keep connection alive ([`691b04b`](https://github.com/humbertogontijo/python-roborock/commit/691b04b0135a38cc6b150e284d96e217f18f7f46))

## v0.17.8 (2023-05-15)
### Fix
* Trying to fix connection leaks ([`a66482a`](https://github.com/humbertogontijo/python-roborock/commit/a66482a22cba9a6e7cc449c3f35acc1f230cd211))

## v0.17.7 (2023-05-15)
### Fix
* Ignoring get_room_mapping for int list response ([`c71d3b5`](https://github.com/humbertogontijo/python-roborock/commit/c71d3b549a8dd09d08d1d27cde6882298875269c))

## v0.17.6 (2023-05-13)
### Fix
* Using cache only a single time ([`1ebfb35`](https://github.com/humbertogontijo/python-roborock/commit/1ebfb35b9fe9ec50d4abeb60c695d33a37818768))

## v0.17.5 (2023-05-12)
### Fix
* Adding log for local disconnection ([`3001798`](https://github.com/humbertogontijo/python-roborock/commit/300179839ec6a25e4ab8172f2c11e8beb0ff17ce))

## v0.17.4 (2023-05-12)
### Fix
* Pycharm typing ([`12d7c0b`](https://github.com/humbertogontijo/python-roborock/commit/12d7c0b71bdeae90e9abbc6a16de3e07ebaa82da))

## v0.17.3 (2023-05-12)
### Fix
* Trigger new release ([`270a65c`](https://github.com/humbertogontijo/python-roborock/commit/270a65c24a847cdc58a630e6d6c8e296910de8ea))

## v0.17.2 (2023-05-11)
### Fix
* Fallback_cache func ([`8048d84`](https://github.com/humbertogontijo/python-roborock/commit/8048d843f669b06960967918570201498e4ae051))
* Adding fallback cache (to be tested) ([`0e214cd`](https://github.com/humbertogontijo/python-roborock/commit/0e214cd0633e9b9baca3323cc505a4f787aa08fb))

## v0.17.1 (2023-05-11)
### Fix
* Improving logs ([`cdd0ea7`](https://github.com/humbertogontijo/python-roborock/commit/cdd0ea75d4e336c8f918a79574fd7b642eaffeec))

## v0.17.0 (2023-05-11)
### Feature
* Dynamic calculated prefixes ([`d57a0a7`](https://github.com/humbertogontijo/python-roborock/commit/d57a0a7d31f851b6bf4381233a84187d19e5782f))

## v0.16.1 (2023-05-10)
### Fix
* Connection timeouts ([`36a7295`](https://github.com/humbertogontijo/python-roborock/commit/36a7295ce878dd0649505dd4a5b5ad662f0655fd))

## v0.16.0 (2023-05-10)
### Feature
* Adding pcap file parser to cli ([`798287a`](https://github.com/humbertogontijo/python-roborock/commit/798287a5100a3e973524aae6dd9404c0af354c11))

## v0.15.0 (2023-05-09)
### Feature
* Add docs ([#58](https://github.com/humbertogontijo/python-roborock/issues/58)) ([`959abe1`](https://github.com/humbertogontijo/python-roborock/commit/959abe1f3b2be0bfb8705d1bc1f9cbe966577540))

### Fix
* Add int for clean summary ([#57](https://github.com/humbertogontijo/python-roborock/issues/57)) ([`4257aa7`](https://github.com/humbertogontijo/python-roborock/commit/4257aa7888178703d1b38ed00c12ef932ca1e862))

## v0.14.1 (2023-05-09)
### Fix
* Add types for S8 ([#56](https://github.com/humbertogontijo/python-roborock/issues/56)) ([`125b6e7`](https://github.com/humbertogontijo/python-roborock/commit/125b6e728145fde39f49fa6b80168bb985f2cc43))

## v0.14.0 (2023-05-08)
### Feature
* Add more codes for status ([#55](https://github.com/humbertogontijo/python-roborock/issues/55)) ([`cddd765`](https://github.com/humbertogontijo/python-roborock/commit/cddd765aa15e31ae50db5a6b29ff6988050aa5cc))

## v0.13.4 (2023-05-05)
### Fix
* Command prefixes ([`65c5db8`](https://github.com/humbertogontijo/python-roborock/commit/65c5db834baadc4c1a61704bd2279c48dd0f6074))

## v0.13.3 (2023-05-05)
### Fix
* Roborock enum ([`ae0b93e`](https://github.com/humbertogontijo/python-roborock/commit/ae0b93ee0f0fc9c62c3f40b436ece209938e9e6c))

## v0.13.2 (2023-05-05)
### Fix
* Minor changes ([`522734a`](https://github.com/humbertogontijo/python-roborock/commit/522734a4bdcf6555feede24e3e97c6a3a98fa760))

## v0.13.1 (2023-05-05)
### Fix
* Adding app_start_collect_dust prefix ([`3124d7e`](https://github.com/humbertogontijo/python-roborock/commit/3124d7ea6277ec08d8e592448b2a4f8cb60fb7db))

## v0.13.0 (2023-05-05)
### Feature
* Add s4_max ([#54](https://github.com/humbertogontijo/python-roborock/issues/54)) ([`e7cfd15`](https://github.com/humbertogontijo/python-roborock/commit/e7cfd153b3c41215fd1c85d4968a14d1862c91b5))

## v0.12.1 (2023-05-05)
### Fix
* Changed incorrect s8 pro ultra string ([`c6a37a9`](https://github.com/humbertogontijo/python-roborock/commit/c6a37a97da9279af3a6a24dc0fd01770cdd9b3b1))

## v0.12.0 (2023-05-05)
### Feature
* Extending device status by device model ([#51](https://github.com/humbertogontijo/python-roborock/issues/51)) ([`8092b67`](https://github.com/humbertogontijo/python-roborock/commit/8092b67b8c9a380cca5178217fde3a61746fcf75))

## v0.11.0 (2023-05-04)
### Feature
* Add error check for invalid user agreement ([#49](https://github.com/humbertogontijo/python-roborock/issues/49)) ([`0374449`](https://github.com/humbertogontijo/python-roborock/commit/0374449d7280c93ceb772b7fbe009c6d19d0c462))

## v0.10.3 (2023-05-04)
### Fix
* Port already in use ([`e5d71d8`](https://github.com/humbertogontijo/python-roborock/commit/e5d71d88f5144c172482cd6ee71d9a5b01dbbe3f))

## v0.10.2 (2023-05-03)
### Fix
* Test errors ([`6a46515`](https://github.com/humbertogontijo/python-roborock/commit/6a465157bbf6fa15bc578a1c4b1dffa17a694a92))
* Change devices fan speed enum to lower case ([`c559d40`](https://github.com/humbertogontijo/python-roborock/commit/c559d40183e47ef8698651281ae8946a99cb897e))

## v0.10.1 (2023-05-03)
### Fix
* Allow discovering multiple devices ([`ada9e07`](https://github.com/humbertogontijo/python-roborock/commit/ada9e0723728b1d7e3ccd6dc37cbbe06a3c6a2cc))

## v0.10.0 (2023-05-03)
### Feature
* Add specific device functionality ([#46](https://github.com/humbertogontijo/python-roborock/issues/46)) ([`32abce5`](https://github.com/humbertogontijo/python-roborock/commit/32abce5d51d14aab9adef5b9560ceee534186b1a))

## v0.9.0 (2023-05-01)
### Feature
* Single device api and discovery method ([`5fef26d`](https://github.com/humbertogontijo/python-roborock/commit/5fef26d257433c12d38f6b19731018e54884a150))

## v0.8.3 (2023-04-28)
### Fix
* Add functionality for missing enum values ([#43](https://github.com/humbertogontijo/python-roborock/issues/43)) ([`49d77f8`](https://github.com/humbertogontijo/python-roborock/commit/49d77f8208a65cb0fb86ab7948138df0bf447e45))

## v0.8.2 (2023-04-27)
### Fix
* Using single device api ([`e689e8d`](https://github.com/humbertogontijo/python-roborock/commit/e689e8d141acff998fd524ace923621fc0f91d0c))

## v0.8.1 (2023-04-27)
### Fix
* Adding keepalive to local connection ([`8ff8d2f`](https://github.com/humbertogontijo/python-roborock/commit/8ff8d2f13fd85df96b3b334456799244ac878fbe))

## v0.8.0 (2023-04-27)
### Feature
* Added error check and deviceprop functionality for core ([#42](https://github.com/humbertogontijo/python-roborock/issues/42)) ([`746eec9`](https://github.com/humbertogontijo/python-roborock/commit/746eec99ae0b6115fea6277f51b546036f7b3f18))

## v0.7.8 (2023-04-26)
### Fix
* Local api failing to send message ([`4cc38fe`](https://github.com/humbertogontijo/python-roborock/commit/4cc38fe13df487296efda2a1e962c238e3d69168))

## v0.7.7 (2023-04-26)
### Fix
* Local api recover after command fail ([`cb11f14`](https://github.com/humbertogontijo/python-roborock/commit/cb11f14d7b771b31c77dafe6435bcd52527c16a8))

## v0.7.6 (2023-04-26)
### Fix
* Reset_consumable command prefix ([`a1a8c06`](https://github.com/humbertogontijo/python-roborock/commit/a1a8c06d369e33e4ebd42cf6f563b9727d0ce24e))

## v0.7.5 (2023-04-25)
### Fix
* Adding missing prefixes ([`66b1833`](https://github.com/humbertogontijo/python-roborock/commit/66b183385c96dd7ee395bff143f2d64ef8fb927a))

## v0.7.4 (2023-04-25)
### Fix
* Get_room_mapping ([`459119b`](https://github.com/humbertogontijo/python-roborock/commit/459119bee90513451bf10a1abeeccb75f3daa539))

## v0.7.3 (2023-04-25)
### Fix
* Added missing docks ([#40](https://github.com/humbertogontijo/python-roborock/issues/40)) ([`65a6cc4`](https://github.com/humbertogontijo/python-roborock/commit/65a6cc4fd19a30bc78f2c34b407d3d88e3aac2b1))

## v0.7.2 (2023-04-25)
### Fix
* Command prefixes ([`e792728`](https://github.com/humbertogontijo/python-roborock/commit/e7927288cc3059a1eced1a65b31f84190718aaf2))

## v0.7.1 (2023-04-25)
### Fix
* Command prefixes ([`156ac51`](https://github.com/humbertogontijo/python-roborock/commit/156ac5182d1a97c93ab16696099c8c099a19155d))

## v0.7.0 (2023-04-25)
### Feature
* Add room mapping ([#41](https://github.com/humbertogontijo/python-roborock/issues/41)) ([`aa3e6e4`](https://github.com/humbertogontijo/python-roborock/commit/aa3e6e442fbbb679c4eca68840c4d19f9c659fde))

## v0.6.17 (2023-04-25)
### Fix
* Removing non-needed classes ([`6ceedad`](https://github.com/humbertogontijo/python-roborock/commit/6ceedadf09c20c743c994b07489887e344cd3061))
* Adding multi_maps_list to device props ([`7ac0485`](https://github.com/humbertogontijo/python-roborock/commit/7ac0485c4a5bb43350c51331323c6773ff1c54fc))

## v0.6.16 (2023-04-22)
### Fix
* Improving local integration ([`7657617`](https://github.com/humbertogontijo/python-roborock/commit/7657617901d807908e5fd5c364700851b5108ab4))

## v0.6.15 (2023-04-21)
### Fix
* Get_clean_summary ([`ee81538`](https://github.com/humbertogontijo/python-roborock/commit/ee815380a8b70efbac65627fdd69fdf0bb75420e))

## v0.6.14 (2023-04-21)
### Fix
* Linting ([`fdb4484`](https://github.com/humbertogontijo/python-roborock/commit/fdb44840741cd6872f7defea70e8f118a9803099))
* Get_multi_map_list ([`cfaeb41`](https://github.com/humbertogontijo/python-roborock/commit/cfaeb419e188510ade5bc1506214c9b3d2afeb18))

## v0.6.13 (2023-04-20)
### Fix
* Check dock_type is not none ([#38](https://github.com/humbertogontijo/python-roborock/issues/38)) ([`84c95e3`](https://github.com/humbertogontijo/python-roborock/commit/84c95e3b3bebd940b9cc6cc06b73c1770605c765))

## v0.6.12 (2023-04-19)
### Fix
* Removed enum type check ([#37](https://github.com/humbertogontijo/python-roborock/issues/37)) ([`585238e`](https://github.com/humbertogontijo/python-roborock/commit/585238e505e685e14d867b19819815e7c3e19634))

## v0.6.11 (2023-04-18)
### Fix
* Lint ([`b0d8996`](https://github.com/humbertogontijo/python-roborock/commit/b0d8996d46c2a52f87a8c01eb50fd6aa7bd98ed8))

## v0.6.10 (2023-04-18)
### Fix
* Lint ([`5ae44e2`](https://github.com/humbertogontijo/python-roborock/commit/5ae44e247efca5e9b7958b887f6049f09ae2ced8))

## v0.6.9 (2023-04-18)
### Fix
* Lint ([`8499522`](https://github.com/humbertogontijo/python-roborock/commit/8499522e5fb44abad20af1cfb7a677ca4e03639f))

## v0.6.8 (2023-04-18)
### Fix
* Lint ([`20bf54b`](https://github.com/humbertogontijo/python-roborock/commit/20bf54b0a1834065584bdcb469a3123700c68f1d))

## v0.6.7 (2023-04-18)
### Fix
* Using asyncio future instead of queue ([`1ea5430`](https://github.com/humbertogontijo/python-roborock/commit/1ea5430197620dbd2dc87949e4326f24601f4ba8))

## v0.6.6 (2023-04-17)
### Fix
* Clean_summary for older devices ([`0a0c9e7`](https://github.com/humbertogontijo/python-roborock/commit/0a0c9e7c965c183df971e11bd597319c68c8f646))

## v0.6.5 (2023-04-13)
### Fix
* Exclude changelog.md from pre-commit ([#36](https://github.com/humbertogontijo/python-roborock/issues/36)) ([`b12c7a2`](https://github.com/humbertogontijo/python-roborock/commit/b12c7a229dfdbe0af182d6a120548100b0ca4140))

## v0.6.4 (2023-04-11)

### Fix

- Disconnect on timeout so next command can work ([`5ad397b`](https://github.com/humbertogontijo/python-roborock/commit/5ad397b3bbb4bc600888baba6c0cc15be9d17ef7))

## v0.6.3 (2023-04-11)

### Fix

- Semantic_release ([`63b249d`](https://github.com/humbertogontijo/python-roborock/commit/63b249d65d3fc40b048320e6596aedc40f588bf9))

## v0.6.2 (2023-04-11)

### Fix

- Error code nogo_zone_detected ([`722e4b5`](https://github.com/humbertogontijo/python-roborock/commit/722e4b5cfd0c4891adc506e9fe99740860027670))

## v0.6.1 (2023-04-10)

### Fix

- Trigger release ([`f1ce0ed`](https://github.com/humbertogontijo/python-roborock/commit/f1ce0ed55a254bccd8567b48974ff74dd9ec8b25))
- Trigger release ([`9a4462c`](https://github.com/humbertogontijo/python-roborock/commit/9a4462c800762393cc047085156acbe119cd0fe4))
- Trigger release ([`b7a664b`](https://github.com/humbertogontijo/python-roborock/commit/b7a664b15b7c5180d816de325537693f47c24860))
- Trigger release ([`9256849`](https://github.com/humbertogontijo/python-roborock/commit/9256849252f019f4fea2f59384bc0ea7c57adb5c))
- Lowercase true ([`774c3cc`](https://github.com/humbertogontijo/python-roborock/commit/774c3cc9765ee76a3a553ca6911751124ae7164c))
- Semantic release not updating changelong ([`eaf6e90`](https://github.com/humbertogontijo/python-roborock/commit/eaf6e90264b6ab69549da0e5bc3d17c4c0a2c07c))
