# Installation

Griffe is a Python package, so you can install it with your favorite Python package installer or dependency manager.

TIP: **[Griffe Insiders](insiders/index.md), a version with [*more features*](insiders/index.md#whats-in-it-for-me), is also available to sponsors :octicons-heart-fill-24:{ .heart .pulse }**

## Install as a tool & library

=== ":simple-python: pip"

    ```bash
    pip install griffe
    ```

    <div class="result" markdown>

    [pip](https://pip.pypa.io/en/stable/) is the main package installer for Python.
    
    </div>

=== ":simple-pdm: pdm"

    ```bash
    pdm add griffe
    ```

    <div class="result" markdown>

    [PDM](https://pdm-project.org/en/latest/) is an all-in-one solution for Python project management.

    </div>

=== ":simple-poetry: poetry"

    ```bash
    poetry add griffe
    ```

    <div class="result" markdown>

    [Poetry](https://python-poetry.org/) is an all-in-one solution for Python project management.

    </div>

=== ":simple-rye: rye"

    ```bash
    rye add griffe
    ```

    <div class="result" markdown>

    [Rye](https://rye.astral.sh/) is an all-in-one solution for Python project management, written in Rust.

    </div>

=== ":simple-ruff: uv"

    ```bash
    uv pip install griffe
    ```

    <div class="result" markdown>

    [uv](https://github.com/astral-sh/uv) is an ultra fast dependency resolver and package installer, written in Rust.

    </div>

## Install as a tool only

=== ":simple-python: pip"

    ```bash
    pip install --user griffe
    ```

    <div class="result" markdown>

    [pip](https://pip.pypa.io/en/stable/) is the main package installer for Python.
    
    </div>

=== ":simple-pipx: pipx"

    ```bash
    pipx install griffe
    ```

    <div class="result" markdown>

    [pipx](https://pipx.pypa.io/stable/) allows to install and run Python applications in isolated environments.

    </div>

=== ":simple-rye: rye"

    ```bash
    rye install griffe
    ```

    <div class="result" markdown>

    [Rye](https://rye.astral.sh/) is an all-in-one solution for Python project management, written in Rust.

    </div>
