# Changelog

## [Unreleased]

## [1.0.24] - 2023-06-04

### Changed
- Code cleanup with ruff (experiment)
- Update notes on IronPython

## [1.0.23] - 2023-04-23

### Added
- Option to use numba interface without IPython by disabling caching (set the environmental variable NUMBA_FUNCTION_CACHE_SIZE to 0 before loading fluids)

### Changed
- Internal cleanup

### Removed
- Dropped support for Python before 3.6

## [0.1.84] - 2020-08-01

### Added
- Finished adding Crane TP 410 sample problems
- Add basic type stubs generated by monkeytype
- Remove deprecated AvailableMethods argument in some functions
- Add prerelease.py script which checks the doctests, notebook output and runs monkeytype
- Add ability to specify the TANK class using two secondary variables, such as surface area and volume
- Add laminar flow data for flow meters by Hollingshead
- Improvements to numba interface, and enable caching for it
- Add several plastic pipe schedules
- Improve a few numerical issues
- '40D1527','80D1527', 'ABSD2680','PVCD2680', 'DR25C900','DR18C900','DR14C900', 'CIDR51C905','CIDR41C905','CIDR325C905','CIDR25C905','CIDR21C905','CIDR18C905','CIDR14C905', 'IPSDR21','IPSDR26','IPSDR325','IPSDR41', 'PS115F679','PS75F679','PS46F679', 'PVCD2665', '40D1785','80D1785','120D1785', 'DR135D2241','DR17D2241','DR21D2241','DR26D2241','DR325D2241','DR41D2241','DR64D2241', 'DR21D2241CTS','DR17D2241CTS','DR135D2241CTS','DR11D2241CTS', 'DR21D2241PIP','DR26D2241PIP','DR325D2241PIP','DR35D2241PIP','DR41D2241PIP','DR51D2241PIP','DR81D2241PIP', 'S40F441IPS','S80F441IPS','S40F441SI','S80F441SI' 'DR325F2619SI','DR26F2619SI','DR21F2619SI','DR17F2619SI','DR135F2619SI','DR11F2619SI','DR9F2619SI','DR73F2619SI','DR7F2619SI', 'DR325F2619IPS','DR26F2619IPS','DR21F2619IPS','DR17F2619IPS','DR135F2619IPS','DR11F2619IPS','DR9F2619IPS','DR73F2619IPS','DR7F2619IPS', 

### Fixed
- Fixed a bug where in the pint interface for units which were dimensionless, but had not had their dimensions cancelled out yet, the incorrect magnitude was passed to the underlying functions.

## [0.1.82] - 2020-06-14

### Added
- Expose C2K, K2C, F2C, C2F, F2K, K2F, C2R, K2R, F2R, R2C, R2K, R2F to public interface of fluids.core so they can be used with numba, fluids.vectorized
- Speed up some unit tests
- Add numba interface which offers speed boosts and allows interoperability with programs using numba
- Added methods friction_factor_methods, friction_factor_curved_methods, dP_packed_bed_methods, drag_sphere_methods, two_phase_dP_methods, gas_liquid_viscosity_methods, liquid_gas_voidage_methods to easily find which correlations are applicable to the a given parameter range.

### Removed
- The AvailableMethods argument in the functions which had it is now deprecated! Changing the return type of a function does not work with numba, and will limit the future ability of fluids to possibly provide typing information i.e. for MyPy. It is also considered bad practice by some, although it is quite popular and used in libraries like SciPy.


## [0.1.81] - 2020-06-06
### Added
- Updated solar_irradiation, solar_position, earthsun_distance, sunrise_sunset to take and return timezone information.

### Changed
- Updated tutorial with new results; almost all are small changes.
- Preliminary work on a numba interface.
- Tentative adaptive `quad` function implementation to perform integration fast with PyPy
- Misc try/excepts which allow the library to be loaded in micropython
- Misc try/excepts which allow the library to be loaded in IronPython

### Removed
- Nothing

### Fixed
- solar_irradiation, and solar_position incorrectly were assuming the timezone of the computer the calculation was run on. This has been remedied; the documentation has been updated to show the timezone now can be in either UTC time zone or with a time zone information provided.