# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, TYPE_CHECKING, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.storage import StorageManagementClient

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-storage
# USAGE
    python storage_account_set_blob_inventory_policy_include_delete_and_new_schema_for_hns_account.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = StorageManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="{subscription-id}",
    )

    response = client.blob_inventory_policies.create_or_update(
        resource_group_name="res7687",
        account_name="sto9699",
        blob_inventory_policy_name="default",
        properties={
            "properties": {
                "policy": {
                    "enabled": True,
                    "rules": [
                        {
                            "definition": {
                                "filters": {
                                    "blobTypes": ["blockBlob", "appendBlob", "pageBlob"],
                                    "excludePrefix": ["excludeprefix1", "excludeprefix2"],
                                    "includeBlobVersions": True,
                                    "includeDeleted": True,
                                    "includeSnapshots": True,
                                    "prefixMatch": ["inventoryprefix1", "inventoryprefix2"],
                                },
                                "format": "Csv",
                                "objectType": "Blob",
                                "schedule": "Daily",
                                "schemaFields": [
                                    "Name",
                                    "Creation-Time",
                                    "Last-Modified",
                                    "Content-Length",
                                    "Content-MD5",
                                    "BlobType",
                                    "AccessTier",
                                    "AccessTierChangeTime",
                                    "Snapshot",
                                    "VersionId",
                                    "IsCurrentVersion",
                                    "ContentType",
                                    "ContentEncoding",
                                    "ContentLanguage",
                                    "ContentCRC64",
                                    "CacheControl",
                                    "Metadata",
                                    "DeletionId",
                                    "Deleted",
                                    "DeletedTime",
                                    "RemainingRetentionDays",
                                ],
                            },
                            "destination": "container1",
                            "enabled": True,
                            "name": "inventoryPolicyRule1",
                        },
                        {
                            "definition": {
                                "format": "Parquet",
                                "objectType": "Container",
                                "schedule": "Weekly",
                                "schemaFields": [
                                    "Name",
                                    "Last-Modified",
                                    "Metadata",
                                    "LeaseStatus",
                                    "LeaseState",
                                    "LeaseDuration",
                                    "PublicAccess",
                                    "HasImmutabilityPolicy",
                                    "HasLegalHold",
                                    "Etag",
                                    "DefaultEncryptionScope",
                                    "DenyEncryptionScopeOverride",
                                    "ImmutableStorageWithVersioningEnabled",
                                    "Deleted",
                                    "Version",
                                    "DeletedTime",
                                    "RemainingRetentionDays",
                                ],
                            },
                            "destination": "container2",
                            "enabled": True,
                            "name": "inventoryPolicyRule2",
                        },
                    ],
                    "type": "Inventory",
                }
            }
        },
    )
    print(response)


# x-ms-original-file: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForHnsAccount.json
if __name__ == "__main__":
    main()
