# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Optional, Type, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ...operations._postgre_sql_management_client_operations import build_check_migration_name_availability_request
from .._vendor import PostgreSQLManagementClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class PostgreSQLManagementClientOperationsMixin(PostgreSQLManagementClientMixinABC):  # pylint: disable=name-too-long

    @overload
    async def check_migration_name_availability(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        parameters: _models.MigrationNameAvailabilityResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.MigrationNameAvailabilityResource:
        """Check migration name validity and availability.

        This method checks whether a proposed migration name is valid and available.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param parameters: The required parameters for checking if a migration name is available.
         Required.
        :type parameters:
         ~azure.mgmt.rdbms.postgresql_flexibleservers.models.MigrationNameAvailabilityResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: MigrationNameAvailabilityResource or the result of cls(response)
        :rtype: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.MigrationNameAvailabilityResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_migration_name_availability(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.MigrationNameAvailabilityResource:
        """Check migration name validity and availability.

        This method checks whether a proposed migration name is valid and available.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param parameters: The required parameters for checking if a migration name is available.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: MigrationNameAvailabilityResource or the result of cls(response)
        :rtype: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.MigrationNameAvailabilityResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def check_migration_name_availability(
        self,
        subscription_id: str,
        resource_group_name: str,
        target_db_server_name: str,
        parameters: Union[_models.MigrationNameAvailabilityResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.MigrationNameAvailabilityResource:
        """Check migration name validity and availability.

        This method checks whether a proposed migration name is valid and available.

        :param subscription_id: The subscription ID of the target database server. Required.
        :type subscription_id: str
        :param resource_group_name: The resource group name of the target database server. Required.
        :type resource_group_name: str
        :param target_db_server_name: The name of the target database server. Required.
        :type target_db_server_name: str
        :param parameters: The required parameters for checking if a migration name is available. Is
         either a MigrationNameAvailabilityResource type or a IO[bytes] type. Required.
        :type parameters:
         ~azure.mgmt.rdbms.postgresql_flexibleservers.models.MigrationNameAvailabilityResource or
         IO[bytes]
        :return: MigrationNameAvailabilityResource or the result of cls(response)
        :rtype: ~azure.mgmt.rdbms.postgresql_flexibleservers.models.MigrationNameAvailabilityResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MigrationNameAvailabilityResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "MigrationNameAvailabilityResource")

        _request = build_check_migration_name_availability_request(
            subscription_id=subscription_id,
            resource_group_name=resource_group_name,
            target_db_server_name=target_db_server_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MigrationNameAvailabilityResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
