# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import sys
from typing import Any, Callable, Dict, List, Optional, Type, TypeVar, cast

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async

from ...operations._operations import (
    build_weather_get_air_quality_daily_forecasts_request,
    build_weather_get_air_quality_hourly_forecasts_request,
    build_weather_get_current_air_quality_request,
    build_weather_get_current_conditions_request,
    build_weather_get_daily_forecast_request,
    build_weather_get_daily_historical_actuals_request,
    build_weather_get_daily_historical_normals_request,
    build_weather_get_daily_historical_records_request,
    build_weather_get_daily_indices_request,
    build_weather_get_hourly_forecast_request,
    build_weather_get_minute_forecast_request,
    build_weather_get_quarter_day_forecast_request,
    build_weather_get_severe_weather_alerts_request,
    build_weather_get_tropical_storm_active_request,
    build_weather_get_tropical_storm_forecast_request,
    build_weather_get_tropical_storm_locations_request,
    build_weather_get_weather_along_route_request,
    build_weather_search_tropical_storm_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class WeatherOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.maps.weather.aio.MapsWeatherClient`'s
        :attr:`weather` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_hourly_forecast(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        unit: Optional[str] = None,
        duration: Optional[int] = None,
        language: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get a detailed hourly weather forecast for up to 24 hours or a daily forecast for up to
        10 days.

        The ``Get Hourly Forecast`` API is an HTTP ``GET`` that Request detailed weather forecast by
        the hour for the next 1, 12, 24 (1 day), 72 (3 days), 120 (5 days), and 240 hours (10 days) for
        the given the given coordinate location.  The API returns details such as temperature,
        humidity, wind, precipitation, and ultraviolet (UV) index. For more information, see `Request
        hourly weather forecast data
        </azure/azure-maps/how-to-request-weather-data#request-hourly-weather-forecast-data>`__.

        If you are using the Gen1 S0 pricing tier, you can request hourly forecast for the next 1, 12,
        24 hours (1 day), and 72 hours (3 days). If you are using Gen1 S1 or Gen2 pricing tier, you can
        also request hourly forecast for the next 120 (5 days) and 240 hours (10 days).

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :keyword duration: Time frame of the returned weather forecast. By default, the forecast data
         for next hour will be returned. Available values are


         * ``1`` - Return forecast data for the next hour. Default value.
         * ``12`` - Return hourly forecast for next 12 hours.
         * ``24`` - Return hourly forecast for next 24 hours.
         * ``72`` - Return hourly forecast for next 72 hours (3 days).
         * ``120`` - Return hourly forecast for next 120 hours (5 days). Only available in S1 SKU.
         * ``240`` - Return hourly forecast for next 240 hours (10 days). Only available in S1 SKU.
           Default value is None.
        :paramtype duration: int
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "forecasts": [
                        {
                            "ceiling": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "cloudCover": 0,
                            "date": "2020-02-20 00:00:00",
                            "dewPoint": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "hasPrecipitation": bool,
                            "ice": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "iceProbability": 0,
                            "iconCode": 0,
                            "iconPhrase": "str",
                            "isDaylight": bool,
                            "precipitationProbability": 0,
                            "rain": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "rainProbability": 0,
                            "realFeelTemperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "relativeHumidity": 0,
                            "snow": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "snowProbability": 0,
                            "temperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "totalLiquid": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "uvIndex": 0,
                            "uvIndexPhrase": "str",
                            "visibility": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "wetBulbTemperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "wind": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "windGust": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_hourly_forecast_request(
            format=format,
            coordinates=coordinates,
            unit=unit,
            duration=duration,
            language=language,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_minute_forecast(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        interval: Optional[int] = None,
        language: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get a minute-by-minute forecast for the next 120 minutes in intervals of 1, 5 and 15
        minutes.

        The ``Get Minute Forecast`` API is an HTTP ``GET`` request that returns minute-by-minute
        forecasts for a given location for the next 120 minutes.  Users can request weather forecasts
        in intervals of 1, 5 and 15 minutes.  The response will include details such as the type of
        precipitation (including rain, snow, or a mixture of both), start time, and precipitation
        intensity value (dBZ). For more information, see `Request minute-by-minute weather forecast
        data
        </azure/azure-maps/how-to-request-weather-data#request-minute-by-minute-weather-forecast-data>`__.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword interval: Specifies time interval in minutes for the returned weather forecast.
         Supported values are


         * ``1`` -  Retrieve forecast for 1-minute intervals. Returned by default.
         * ``5`` - Retrieve forecasts for 5-minute intervals.
         * ``15`` - Retrieve forecasts for 15-minute intervals. Default value is None.
        :paramtype interval: int
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "intervalSummaries": [
                        {
                            "briefPhrase": "str",
                            "endMinute": 0,
                            "iconCode": 0,
                            "longPhrase": "str",
                            "shortPhrase": "str",
                            "startMinute": 0,
                            "totalMinutes": 0
                        }
                    ],
                    "intervals": [
                        {
                            "cloudCover": 0,
                            "color": {
                                "blue": 0,
                                "green": 0,
                                "hex": "str",
                                "red": 0
                            },
                            "dbz": 0.0,
                            "iconCode": 0,
                            "minute": 0,
                            "precipitationType": "str",
                            "shortPhrase": "str",
                            "simplifiedColor": {
                                "blue": 0,
                                "green": 0,
                                "hex": "str",
                                "red": 0
                            },
                            "startTime": "2020-02-20 00:00:00",
                            "threshold": "str"
                        }
                    ],
                    "summary": {
                        "briefPhrase": "str",
                        "briefPhrase60": "str",
                        "iconCode": 0,
                        "longPhrase": "str",
                        "shortPhrase": "str"
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_minute_forecast_request(
            format=format,
            coordinates=coordinates,
            interval=interval,
            language=language,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_quarter_day_forecast(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        unit: Optional[str] = None,
        duration: Optional[int] = None,
        language: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get a Quarter-Day Forecast for the next 1, 5, 10, or 15 days.

        The ``Get Quarter-Day Forecast`` API is an HTTP ``GET`` request that returns a detailed weather
        forecast by quarter-day for the next 1, 5, 10, or 15 days for a given location. Response data
        is presented by quarters of the day - morning, afternoon, evening, and overnight. Details such
        as temperature, humidity, wind, precipitation, and UV index are returned.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :keyword duration: Specifies for how many days the quester-day forecast responses are returned.
         Supported values are:


         * ``1`` - Return forecast data for the next day. Returned by default.
         * ``5`` - Return forecast data for the next 5 days.
         * ``10`` - Return forecast data for next 10 days.
         * ``15`` - Return forecast data for the next 15 days. Default value is None.
        :paramtype duration: int
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "forecasts": [
                        {
                            "cloudCover": 0,
                            "date": "2020-02-20 00:00:00",
                            "dewPoint": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "effectiveDate": "2020-02-20 00:00:00",
                            "hasPrecipitation": bool,
                            "ice": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "iconCode": 0,
                            "iconPhrase": "str",
                            "phrase": "str",
                            "precipitationIntensity": "str",
                            "precipitationProbability": 0,
                            "precipitationType": "str",
                            "quarter": 0,
                            "rain": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "realFeelTemperature": {
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "minimum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "relativeHumidity": 0,
                            "snow": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "temperature": {
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "minimum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "thunderstormProbability": 0,
                            "totalLiquid": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "visibility": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "wind": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "windGust": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_quarter_day_forecast_request(
            format=format,
            coordinates=coordinates,
            unit=unit,
            duration=duration,
            language=language,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_current_conditions(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        unit: Optional[str] = None,
        details: Optional[str] = None,
        duration: Optional[int] = None,
        language: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get current weather conditions.

        The ``Get Current Conditions`` API is an HTTP ``GET`` request that returns detailed current
        weather conditions such as precipitation, temperature and wind for a given coordinate location.
        Also, observations from the past 6 or 24 hours for a particular location can be retrieved. The
        basic information returned with The response includes details such as observation date and
        time, brief description of the weather conditions, weather icon, precipitation indicator flags,
        and temperature. Additional details such as RealFeel™ Temperature and UV index are also
        returned. For more information, see `Request real-time weather data
        </azure/azure-maps/how-to-request-weather-data#request-real-time-weather-data>`__.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :keyword details: Return full details for the current conditions. Available values are


         * ``true`` - Returns full details. By default all details are returned.
         * ``false`` - Returns a truncated version of the current condition data, which includes
           observation date time, weather phrase, icon code, precipitation indicator flag, and
           temperature. Default value is None.
        :paramtype details: str
        :keyword duration: Time frame of the returned weather conditions. By default, the most current
         weather conditions will be returned. Default value is 0. Supported values are:


         * ``0`` - Return the most current weather conditions.
         * ``6`` - Return weather conditions from past 6 hours.
         * ``24`` - Return weather conditions from past 24 hours. Default value is None.
        :paramtype duration: int
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "results": [
                        {
                            "apparentTemperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "ceiling": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "cloudCover": 0,
                            "dateTime": "2020-02-20 00:00:00",
                            "dewPoint": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "hasPrecipitation": bool,
                            "iconCode": 0,
                            "isDayTime": bool,
                            "obstructionsToVisibility": "str",
                            "pastTwentyFourHourTemperatureDeparture": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "phrase": "str",
                            "precipitationSummary": {
                                "pastEighteenHours": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "pastHour": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "pastNineHours": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "pastSixHours": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "pastThreeHours": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "pastTwelveHours": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "pastTwentyFourHours": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "pressure": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "pressureTendency": {
                                "code": "str",
                                "localizedDescription": "str"
                            },
                            "realFeelTemperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "realFeelTemperatureShade": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "relativeHumidity": 0,
                            "temperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "temperatureSummary": {
                                "pastSixHours": {
                                    "maximum": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    },
                                    "minimum": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                },
                                "pastTwelveHours": {
                                    "maximum": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    },
                                    "minimum": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                },
                                "pastTwentyFourHours": {
                                    "maximum": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    },
                                    "minimum": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                }
                            },
                            "uvIndex": 0,
                            "uvIndexPhrase": "str",
                            "visibility": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "wetBulbTemperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "wind": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "windChillTemperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "windGust": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_current_conditions_request(
            format=format,
            coordinates=coordinates,
            unit=unit,
            details=details,
            duration=duration,
            language=language,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_daily_forecast(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        unit: Optional[str] = None,
        duration: Optional[int] = None,
        language: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get a daily detailed weather forecast for the next 1, 5, 10, 15, 25, or 45 days.

        The ``Get Daily Forecast`` API is an HTTP ``GET`` request that returns detailed weather
        forecast such as temperature and wind by day for the next 1, 5, 10, 15, 25, or 45 days for a
        given coordinate location.  The response includes details such as temperature, wind,
        precipitation, air quality, and UV index. For more information, see `Request daily weather
        forecast data
        </azure/azure-maps/how-to-request-weather-data#request-daily-weather-forecast-data>`__.

        If you are using the Gen1 S0 pricing tier, you can request daily forecast for the next 1, 5,
        10, and 15 days. If you are using Gen1 S1 or Gen2 pricing tier, you can also request daily
        forecast for the next 25 days, and 45 days.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :keyword duration: Specifies for how many days the daily forecast responses are returned.
         Available values are


         * ``1`` - Return forecast data for the next day. Returned by default.
         * ``5`` - Return forecast data for the next 5 days.
         * ``10`` - Return forecast data for the next 10 days.
         * ``25`` - Return forecast data for the next 25 days. Only available in S1 SKU.
         * ``45`` - Return forecast data for the next 45 days. Only available in S1 SKU. Default value
           is None.
        :paramtype duration: int
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "forecasts": [
                        {
                            "airAndPollen": [
                                {
                                    "category": "str",
                                    "categoryValue": 0,
                                    "name": "str",
                                    "type": "str",
                                    "value": 0
                                }
                            ],
                            "date": "2020-02-20 00:00:00",
                            "day": {
                                "cloudCover": 0,
                                "hasPrecipitation": bool,
                                "hoursOfIce": 0.0,
                                "hoursOfPrecipitation": 0.0,
                                "hoursOfRain": 0.0,
                                "hoursOfSnow": 0.0,
                                "ice": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "iceProbability": 0,
                                "iconCode": 0,
                                "iconPhrase": "str",
                                "localSource": {
                                    "id": 0,
                                    "name": "str",
                                    "weatherCode": "str"
                                },
                                "longPhrase": "str",
                                "precipitationIntensity": "str",
                                "precipitationProbability": 0,
                                "precipitationType": "str",
                                "rain": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "rainProbability": 0,
                                "shortPhrase": "str",
                                "snow": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "snowProbability": 0,
                                "thunderstormProbability": 0,
                                "totalLiquid": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "wind": {
                                    "direction": {
                                        "degrees": 0,
                                        "localizedDescription": "str"
                                    },
                                    "speed": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                },
                                "windGust": {
                                    "direction": {
                                        "degrees": 0,
                                        "localizedDescription": "str"
                                    },
                                    "speed": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                }
                            },
                            "degreeDaySummary": {
                                "cooling": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "heating": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "hoursOfSun": 0.0,
                            "night": {
                                "cloudCover": 0,
                                "hasPrecipitation": bool,
                                "hoursOfIce": 0.0,
                                "hoursOfPrecipitation": 0.0,
                                "hoursOfRain": 0.0,
                                "hoursOfSnow": 0.0,
                                "ice": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "iceProbability": 0,
                                "iconCode": 0,
                                "iconPhrase": "str",
                                "localSource": {
                                    "id": 0,
                                    "name": "str",
                                    "weatherCode": "str"
                                },
                                "longPhrase": "str",
                                "precipitationIntensity": "str",
                                "precipitationProbability": 0,
                                "precipitationType": "str",
                                "rain": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "rainProbability": 0,
                                "shortPhrase": "str",
                                "snow": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "snowProbability": 0,
                                "thunderstormProbability": 0,
                                "totalLiquid": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "wind": {
                                    "direction": {
                                        "degrees": 0,
                                        "localizedDescription": "str"
                                    },
                                    "speed": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                },
                                "windGust": {
                                    "direction": {
                                        "degrees": 0,
                                        "localizedDescription": "str"
                                    },
                                    "speed": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                }
                            },
                            "realFeelTemperature": {
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "minimum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "realFeelTemperatureShade": {
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "minimum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "sources": [
                                "str"
                            ],
                            "temperature": {
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "minimum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            }
                        }
                    ],
                    "summary": {
                        "category": "str",
                        "endDate": "2020-02-20 00:00:00",
                        "phrase": "str",
                        "severity": 0,
                        "startDate": "2020-02-20 00:00:00"
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_daily_forecast_request(
            format=format,
            coordinates=coordinates,
            unit=unit,
            duration=duration,
            language=language,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_weather_along_route(
        self, format: str = "json", *, query: str, language: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Use to get a locationally precise, up-to-the-minute forecast that includes weather hazard
        assessments and notifications along a route.

        The ``Get Weather Along Route`` API is an HTTP ``GET`` request that returns hyper local (one
        kilometer or less), up-to-the-minute weather nowcasts, weather hazard assessments, and
        notifications along a route described as a sequence of waypoints.

        This includes a list of weather hazards affecting the waypoint or route, and the aggregated
        hazard index for each waypoint might be used to paint each portion of a route according to how
        safe it is for the driver. When submitting the waypoints, it is recommended to stay within, or
        close to, the distance that can be traveled within 120-mins or shortly after. Data is updated
        every five minutes.

        The service supplements Azure Maps `Route Service
        <https://docs.microsoft.com/rest/api/maps/route>`__ that allows you to first request a route
        between an origin and a destination and use that as an input for Weather Along Route endpoint.

        In addition, the service supports scenarios to generate weather notifications for waypoints
        that experience an increase in intensity of a weather hazard. For example, if the vehicle is
        expected to begin experiencing heavy rain as it reaches a waypoint, a weather notification for
        heavy rain will be generated for that waypoint allowing the end product to display a heavy rain
        notification before the driver reaches that waypoint.

        The trigger for when to display the notification for a waypoint could be based, for example,
        on a `geofence <https://docs.microsoft.com/azure/azure-maps/tutorial-iot-hub-maps>`__\\ , or
        selectable distance to the waypoint.

        The API covers all regions of the planet except latitudes above Greenland and Antarctica.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword query: Coordinates through which the route is calculated, separated by colon (:) and
         entered in chronological order. A minimum of two waypoints is required. A single API call may
         contain up to 60 waypoints.
         A waypoint indicates location, ETA, and optional heading: latitude,longitude,ETA,heading,
         where


         * ``Latitude`` - Latitude coordinate in decimal degrees.
         * ``Longitude`` - Longitude coordinate in decimal degrees.
         * ``ETA (estimated time of arrival)`` - The number of minutes from the present time that it
           will take for the vehicle to reach the waypoint. Allowed range is from 0.0 to 120.0 minutes.
         * ``Heading`` - An optional value indicating the vehicle heading as it passes the waypoint.
           Expressed in clockwise degrees relative to true north. This is issued to calculate sun glare as
           a driving hazard. Allowed range is from 0.0 to 360.0 degrees. If not provided, a heading will
           automatically be derived based on the position of neighboring waypoints.

         It is recommended to stay within, or close to, the distance that can be traveled within
         120-mins or shortly after. This way a more accurate assessment can be provided for the trip and
         prevent isolated events not being captured between waypoints.  Information can and should be
         updated along the route (especially for trips greater than 2 hours) to continuously pull new
         waypoints moving forward, but also to ensure that forecast information for content such as
         precipitation type and intensity is accurate as storms develop and dissipate over time.
         Required.
        :paramtype query: str
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "summary": {
                        "hazards": {
                            "hazardDetails": [
                                {
                                    "hazardCode": "str",
                                    "hazardIndex": 0,
                                    "shortPhrase": "str"
                                }
                            ],
                            "maxHazardIndex": 0
                        },
                        "iconCode": 0
                    },
                    "waypoints": [
                        {
                            "cloudCover": 0,
                            "hazards": {
                                "hazardDetails": [
                                    {
                                        "hazardCode": "str",
                                        "hazardIndex": 0,
                                        "shortPhrase": "str"
                                    }
                                ],
                                "maxHazardIndex": 0
                            },
                            "iconCode": 0,
                            "isDayTime": bool,
                            "lightningCount": 0,
                            "notifications": [
                                {
                                    "hazardCode": "str",
                                    "hazardIndex": 0,
                                    "shortPhrase": "str",
                                    "type": "str"
                                }
                            ],
                            "precipitation": {
                                "dbz": 0.0,
                                "type": "str"
                            },
                            "shortPhrase": "str",
                            "sunGlare": {
                                "calculatedVehicleHeading": 0,
                                "glareIndex": 0
                            },
                            "temperature": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "wind": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "windGust": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_weather_along_route_request(
            format=format,
            query=query,
            language=language,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_severe_weather_alerts(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        language: Optional[str] = None,
        details: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get information about severe weather conditions such as hurricanes, thunderstorms,
        flooding, lightning, heat waves or forest fires for a given location.

        Severe weather phenomenon can significantly impact our everyday life and business operations.
        For example, severe weather conditions such as tropical storms, high winds or flooding can
        close roads and force logistics companies to reroute their fleet causing delays in reaching
        destinations and breaking the cold chain of refrigerated food products.

        The ``Get Severe Weather Alerts`` API is an HTTP ``GET`` request that returns the severe
        weather alerts that are available worldwide from both official Government Meteorological
        Agencies and leading global to regional weather alert providers. The service can return details
        such as alert type, category, level and detailed description about the active severe alerts for
        the requested location, like hurricanes, thunderstorms, lightning, heat waves or forest fires.
        For more information, see `Request severe weather alerts
        </azure-maps/how-to-request-weather-data#request-severe-weather-alerts>`__.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :keyword details: Return full details for the severe weather alerts. Available values are


         * ``true`` - Returns full details. By default all details are returned.
         * ``false`` - Returns a truncated version of the alerts data, which excludes the area-specific
           full description of alert details (\\ ``alertDetails``\\ ). Default value is None.
        :paramtype details: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "results": [
                        {
                            "alertAreas": [
                                {
                                    "alertDetails": "str",
                                    "alertDetailsLanguageCode": "str",
                                    "endTime": "2020-02-20 00:00:00",
                                    "latestStatus": {
                                        "english": "str",
                                        "localized": "str"
                                    },
                                    "name": "str",
                                    "startTime": "2020-02-20 00:00:00",
                                    "summary": "str"
                                }
                            ],
                            "alertId": 0,
                            "category": "str",
                            "class": "str",
                            "countryCode": "str",
                            "description": {
                                "english": "str",
                                "localized": "str"
                            },
                            "disclaimer": "str",
                            "level": "str",
                            "priority": 0,
                            "source": "str",
                            "sourceId": 0
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_severe_weather_alerts_request(
            format=format,
            coordinates=coordinates,
            language=language,
            details=details,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_daily_indices(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        language: Optional[str] = None,
        duration: Optional[int] = None,
        index_id: Optional[int] = None,
        index_group_id: Optional[int] = None,
        **kwargs: Any
    ) -> JSON:
        """Use when you want to know if the weather conditions are optimal for a specific activity such as
        outdoor sporting activities, construction, or farming (results includes soil moisture
        information).

        The ``Get Daily Indices`` API is an HTTP ``GET`` request returns index values that provide
        guidance to help when planning future activities. For example, a health mobile application can
        notify users that today is good weather for running or for other outdoors activities like
        playing golf or flying a kite. Retail stores can optimize their digital marketing campaigns
        based on predicted index values. The service returns in daily indices values for current and
        next 5, 10 and 15 days starting from current day.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :keyword duration: Specifies for how many days the daily indices are returned. By default, the
         indices data for the current day will be returned. When requesting future indices data, the
         current day is included in the response as day 1. Available values are


         * ``1`` - Return daily index data for the current day. Default value.
         * ``5`` - Return 5 days of daily index data starting from the current day.
         * ``10`` - Return 10 days of daily index data starting from the current day.
         * ``15`` - Return 15 days of daily index data starting from the current day. Default value is
           None.
        :paramtype duration: int
        :keyword index_id: Numeric index identifier that can be used for restricting returned results
         to the corresponding index type. Cannot be paired with ``indexGroupId``. Please refer to
         `Weather services in Azure Maps
         </azure/azure-maps/weather-services-concepts#index-ids-and-index-groups-ids>`__ for details and
         to see the supported indices. Default value is None.
        :paramtype index_id: int
        :keyword index_group_id: Numeric index group identifier that can be used for restricting
         returned results to the corresponding subset of indices (index group). Cannot be paired with
         ``indexId``. Please refer to `Weather services in Azure Maps
         </azure/azure-maps/weather-services-concepts#index-ids-and-index-groups-ids>`__ for details and
         to see the supported index groups. Default value is None.
        :paramtype index_group_id: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "results": [
                        {
                            "ascending": bool,
                            "category": "str",
                            "categoryValue": 0,
                            "dateTime": "2020-02-20 00:00:00",
                            "description": "str",
                            "indexId": 0,
                            "indexName": "str",
                            "value": 0.0
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_daily_indices_request(
            format=format,
            coordinates=coordinates,
            language=language,
            duration=duration,
            index_id=index_id,
            index_group_id=index_group_id,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_tropical_storm_active(self, format: str = "json", **kwargs: Any) -> JSON:
        """Use to get a list of the active tropical storms issued by national weather forecasting
        agencies.

        The ``Get Tropical Storm Active`` API is an HTTP ``GET`` request that returns a list of all
        government-issued active tropical storms. Information about the tropical storms includes,
        government ID, basin ID, year of origin, name and if it is subtropical.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "basinId": "str",
                            "govId": 0,
                            "isActive": bool,
                            "isSubtropical": bool,
                            "name": "str",
                            "year": "str"
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_tropical_storm_active_request(
            format=format,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def search_tropical_storm(
        self,
        format: str = "json",
        *,
        year: int,
        basin_id: Optional[str] = None,
        government_storm_id: Optional[int] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get a list of storms issued by national weather forecasting agencies.

        The ``Get Tropical Storm Search`` API is an HTTP ``GET`` request that returns a list of
        government-issued tropical storms by year, basin ID, and government ID. Information about the
        tropical storms includes, government ID, basin ID, status, year, name and if it is subtropical.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword year: Year of the cyclone(s). Required.
        :paramtype year: int
        :keyword basin_id: Basin identifier. Known values are: "AL", "EP", "SI", "NI", "CP", "NP", and
         "SP". Default value is None.
        :paramtype basin_id: str
        :keyword government_storm_id: Government storm Id. Default value is None.
        :paramtype government_storm_id: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "basinId": "str",
                            "govId": 0,
                            "isActive": bool,
                            "isRetired": bool,
                            "isSubtropical": bool,
                            "name": "str",
                            "year": "str"
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_search_tropical_storm_request(
            format=format,
            year=year,
            basin_id=basin_id,
            government_storm_id=government_storm_id,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_tropical_storm_forecast(
        self,
        format: str = "json",
        *,
        year: int,
        basin_id: str,
        government_storm_id: int,
        unit: Optional[str] = None,
        include_details: bool = False,
        include_geometric_details: bool = False,
        include_window_geometry: bool = False,
        **kwargs: Any
    ) -> JSON:
        """Use to get a list of tropical storms forecasted by national weather forecasting agencies.

        The ``Get Tropical Storm Forecasts`` API is an HTTP ``GET`` request that returns individual
        government-issued tropical storm forecasts. Information about the forecasted tropical storms
        includes, location, status, date the forecast was created, window, wind speed and wind radii.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword year: Year of the cyclone(s). Required.
        :paramtype year: int
        :keyword basin_id: Basin identifier. Known values are: "AL", "EP", "SI", "NI", "CP", "NP", and
         "SP". Required.
        :paramtype basin_id: str
        :keyword government_storm_id: Government storm Id. Required.
        :paramtype government_storm_id: int
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :keyword include_details: When true, wind radii summary data is included in the response.
         Default value is False.
        :paramtype include_details: bool
        :keyword include_geometric_details: When true, wind radii summary data and geoJSON details are
         included in the response. Default value is False.
        :paramtype include_geometric_details: bool
        :keyword include_window_geometry: When true, window geometry data (geoJSON) is included in the
         response. Default value is False.
        :paramtype include_window_geometry: bool
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "dateTime": "str",
                            "initializedDateTime": "str",
                            "location": {
                                "latitude": 0.0,
                                "longitude": 0.0
                            },
                            "maxWindGust": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "status": "str",
                            "sustainedWind": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "windRadiiSummary": [
                                {
                                    "dateTime": "str",
                                    "radiiGeometry": geo_json_geometry,
                                    "radiusSectorData": [
                                        {
                                            "beginBearing": 0.0,
                                            "endBearing": 0.0,
                                            "range": 0.0
                                        }
                                    ],
                                    "windSpeed": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                }
                            ],
                            "window": {
                                "beginDateTime": "2020-02-20 00:00:00",
                                "beginStatus": "str",
                                "endDateTime": "2020-02-20 00:00:00",
                                "endStatus": "str",
                                "geometry": geo_json_geometry,
                                "left": {
                                    "latitude": 0.0,
                                    "longitude": 0.0
                                },
                                "right": {
                                    "latitude": 0.0,
                                    "longitude": 0.0
                                }
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_tropical_storm_forecast_request(
            format=format,
            year=year,
            basin_id=basin_id,
            government_storm_id=government_storm_id,
            unit=unit,
            include_details=include_details,
            include_geometric_details=include_geometric_details,
            include_window_geometry=include_window_geometry,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_tropical_storm_locations(
        self,
        format: str = "json",
        *,
        year: int,
        basin_id: str,
        government_storm_id: int,
        include_details: bool = False,
        include_geometric_details: bool = False,
        unit: Optional[str] = None,
        include_current_storm: bool = False,
        **kwargs: Any
    ) -> JSON:
        """Use to get the location of tropical storms from individual national weather forecasting
        agencies.

        The ``Get Tropical Storm Locations`` API is an HTTP ``GET`` request that returns the location
        of individual government-issued tropical storms. Information about the tropical storms
        includes, location coordinates, geometry, basin ID, date, wind details and wind radii.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword year: Year of the cyclone(s). Required.
        :paramtype year: int
        :keyword basin_id: Basin identifier. Known values are: "AL", "EP", "SI", "NI", "CP", "NP", and
         "SP". Required.
        :paramtype basin_id: str
        :keyword government_storm_id: Government storm Id. Required.
        :paramtype government_storm_id: int
        :keyword include_details: When true, wind radii summary data is included in the response.
         Default value is False.
        :paramtype include_details: bool
        :keyword include_geometric_details: When true, wind radii summary data and geoJSON details are
         included in the response. Default value is False.
        :paramtype include_geometric_details: bool
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :keyword include_current_storm: When true, return the current storm location. Default value is
         False.
        :paramtype include_current_storm: bool
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "dateTime": "str",
                            "hasTropicalPotential": bool,
                            "isPostTropical": bool,
                            "isSubtropical": bool,
                            "location": {
                                "latitude": 0.0,
                                "longitude": 0.0
                            },
                            "maxWindGust": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "minimumPressure": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "movement": {
                                "direction": {
                                    "degrees": 0,
                                    "localizedDescription": "str"
                                },
                                "speed": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "status": "str",
                            "sustainedWind": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "windRadiiSummary": [
                                {
                                    "dateTime": "str",
                                    "radiiGeometry": geo_json_geometry,
                                    "radiusSectorData": [
                                        {
                                            "beginBearing": 0.0,
                                            "endBearing": 0.0,
                                            "range": 0.0
                                        }
                                    ],
                                    "windSpeed": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    }
                                }
                            ]
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_tropical_storm_locations_request(
            format=format,
            year=year,
            basin_id=basin_id,
            government_storm_id=government_storm_id,
            include_details=include_details,
            include_geometric_details=include_geometric_details,
            unit=unit,
            include_current_storm=include_current_storm,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_current_air_quality(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        language: Optional[str] = None,
        include_pollutant_details: Optional[bool] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get current air quality information that includes potential risks and suggested
        precautions.

        The ``Get Current Air Quality`` API is an HTTP ``GET`` request that returns detailed
        information about the concentration of pollutants and overall status for current air quality,
        including pollution levels, air quality index values, the dominant pollutant, and a brief
        statement summarizing risk level and suggested precautions.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :keyword include_pollutant_details: Boolean value that returns detailed information about each
         pollutant. By default is True. Default value is None.
        :paramtype include_pollutant_details: bool
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "category": "str",
                            "categoryColor": "str",
                            "dateTime": "2020-02-20 00:00:00",
                            "description": "str",
                            "dominantPollutant": "str",
                            "globalIndex": 0.0,
                            "index": 0.0,
                            "pollutants": [
                                {
                                    "concentration": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    },
                                    "globalIndex": 0.0,
                                    "index": 0.0,
                                    "name": "str",
                                    "type": "str"
                                }
                            ]
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_current_air_quality_request(
            format=format,
            coordinates=coordinates,
            language=language,
            include_pollutant_details=include_pollutant_details,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_air_quality_daily_forecasts(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        language: Optional[str] = None,
        duration: int = 1,
        **kwargs: Any
    ) -> JSON:
        """Use to get daily air quality forecasts for the next one to seven days that include pollutant
        levels, potential risks and suggested precautions.

        The ``Get Air Quality Daily Forecasts`` API is an HTTP ``GET`` request that returns detailed
        information about the concentration of pollutants and overall status of forecasted daily air
        quality. The service can provide forecasted daily air quality information for the upcoming 1 to
        7 days, including pollution levels, air quality index values, the dominant pollutant, and a
        brief statement summarizing risk level and suggested precautions.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :keyword duration: Specifies for how many days from now we would like to know about the air
         quality. Available values are 1, 2, 3, 4, 5, 6, and 7. Default value is 1. Known values are: 1,
         2, 3, 4, 5, 6, and 7. Default value is 1.
        :paramtype duration: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "category": "str",
                            "categoryColor": "str",
                            "dateTime": "2020-02-20 00:00:00",
                            "description": "str",
                            "dominantPollutant": "str",
                            "globalIndex": 0.0,
                            "index": 0.0
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_air_quality_daily_forecasts_request(
            format=format,
            coordinates=coordinates,
            language=language,
            duration=duration,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_air_quality_hourly_forecasts(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        language: Optional[str] = None,
        duration: int = 1,
        include_pollutant_details: Optional[bool] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get hourly air quality forecasts for the next one to 96 hours that include pollutant
        levels, potential risks and suggested precautions.

        The ``Get Air Quality Hourly Forecasts`` API is an HTTP ``GET`` request that returns detailed
        information about the concentration of pollutants and overall status for forecasted upcoming
        hourly air quality. The service can provide forecasted hourly air quality information for the
        upcoming time spans of 1, 12, 24, 48, 72, and 96 hours, including pollution levels, air quality
        index values, the dominant pollutant, and a brief statement summarizing risk level and
        suggested precautions.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword language: Language in which search results should be returned. Should be one of
         supported IETF language tags, case insensitive. When data in specified language is not
         available for a specific field, default language is used.

         Please refer to `Supported Languages
         <https://docs.microsoft.com/azure/azure-maps/supported-languages>`__ for details. Default value
         is None.
        :paramtype language: str
        :keyword duration: Specifies for how many hours from now we would like to know about the air
         quality. Available values are 1, 12, 24, 48, 72, 96. Default value is 1 hour. Known values are:
         1, 12, 24, 48, 72, and 96. Default value is 1.
        :paramtype duration: int
        :keyword include_pollutant_details: Boolean value that returns detailed information about each
         pollutant. By default is True. Default value is None.
        :paramtype include_pollutant_details: bool
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "category": "str",
                            "categoryColor": "str",
                            "dateTime": "2020-02-20 00:00:00",
                            "description": "str",
                            "dominantPollutant": "str",
                            "globalIndex": 0.0,
                            "index": 0.0,
                            "pollutants": [
                                {
                                    "concentration": {
                                        "unit": "str",
                                        "unitType": 0,
                                        "value": 0.0
                                    },
                                    "globalIndex": 0.0,
                                    "index": 0.0,
                                    "name": "str",
                                    "type": "str"
                                }
                            ]
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_air_quality_hourly_forecasts_request(
            format=format,
            coordinates=coordinates,
            language=language,
            duration=duration,
            include_pollutant_details=include_pollutant_details,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_daily_historical_actuals(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        start_date: datetime.date,
        end_date: datetime.date,
        unit: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get climatology data such as past daily actual observed temperatures, precipitation,
        snowfall and snow depth.

        The ``Get Daily Historical Actuals`` API is an HTTP ``GET`` request that returns climatology
        data such as past daily actual observed temperatures, precipitation, snowfall, snow depth and
        cooling/heating degree day information, for the day at a given coordinate location. The data is
        requested for a specified date range, up to 31 days in a single API request. Generally,
        historical data may be available as far back as the last 5 to 40+ years, depending on the
        location.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword start_date: Start date in ISO 8601 format, for example, 2019-10-27. The date range
         supported is 1 to 31 calendar days, so be sure to specify a startDate and endDate that does not
         exceed a maximum of 31 days (i.e.: startDate=2012-01-01&endDate=2012-01-31). Required.
        :paramtype start_date: ~datetime.date
        :keyword end_date: End date in ISO 8601 format, for example, 2019-10-28. The date range
         supported is 1 to 31 calendar days, so be sure to specify a startDate and endDate that does not
         exceed a maximum of 31 days (i.e.: startDate=2012-01-01&endDate=2012-01-31). Required.
        :paramtype end_date: ~datetime.date
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "date": "2020-02-20 00:00:00",
                            "degreeDaySummary": {
                                "cooling": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "heating": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "precipitation": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "snowDepth": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "snowfall": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "temperature": {
                                "average": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "minimum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_daily_historical_actuals_request(
            format=format,
            coordinates=coordinates,
            start_date=start_date,
            end_date=end_date,
            unit=unit,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_daily_historical_records(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        start_date: datetime.date,
        end_date: datetime.date,
        unit: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get climatology data such as past daily record temperatures, precipitation and snowfall
        at a given location.

        The ``Get Daily Historical Records`` API is an HTTP ``GET`` request that returns climatology
        data such as past daily record temperatures, precipitation and snowfall at a given coordinate
        location. Availability of records data will vary by location. Generally, historical data may be
        available as far back as the last 5 to 40+ years, depending on the location.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword start_date: Start date in ISO 8601 format, for example, 2019-10-27. The date range
         supported is 1 to 31 calendar days, so be sure to specify a startDate and endDate that does not
         exceed a maximum of 31 days (i.e.: startDate=2012-01-01&endDate=2012-01-31). Required.
        :paramtype start_date: ~datetime.date
        :keyword end_date: End date in ISO 8601 format, for example, 2019-10-28. The date range
         supported is 1 to 31 calendar days, so be sure to specify a startDate and endDate that does not
         exceed a maximum of 31 days (i.e.: startDate=2012-01-01&endDate=2012-01-31). Required.
        :paramtype end_date: ~datetime.date
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "date": "2020-02-20 00:00:00",
                            "precipitation": {
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0,
                                    "year": 0
                                }
                            },
                            "snowfall": {
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0,
                                    "year": 0
                                }
                            },
                            "temperature": {
                                "average": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0,
                                    "year": 0
                                },
                                "minimum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0,
                                    "year": 0
                                }
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_daily_historical_records_request(
            format=format,
            coordinates=coordinates,
            start_date=start_date,
            end_date=end_date,
            unit=unit,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_daily_historical_normals(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        start_date: datetime.date,
        end_date: datetime.date,
        unit: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get climatology data such as past daily normal temperatures, precipitation and
        cooling/heating degree day information for a given location.

        The ``Get Daily Historical Normals`` API is an HTTP ``GET`` request that returns climatology
        data such as past daily normal temperatures, precipitation and cooling/heating degree day
        information for the day at a given coordinate location. The historical normals are a 30-year
        average for temperatures and precipitation for a specific location. As is standard practice in
        climatology, the 30-year average covers years 1991-2020, this data will be used for one decade
        and then will reset in the year 2030. Generally, historical data may be available as far back
        as the last 5 to 40+ years, depending on the location.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: The applicable query specified as a comma separated string composed by
         latitude followed by longitude e.g. "47.641268,-122.125679".

         Weather information is generally available for locations on land, bodies of water surrounded
         by land, and areas of the ocean that are within approximately 50 nautical miles of a coastline.
         Required.
        :paramtype coordinates: list[float]
        :keyword start_date: Start date in ISO 8601 format, for example, 2019-10-27. The date range
         supported is 1 to 31 calendar days, so be sure to specify a startDate and endDate that does not
         exceed a maximum of 31 days (i.e.: startDate=2012-01-01&endDate=2012-01-31). Required.
        :paramtype start_date: ~datetime.date
        :keyword end_date: End date in ISO 8601 format, for example, 2019-10-28. The date range
         supported is 1 to 31 calendar days, so be sure to specify a startDate and endDate that does not
         exceed a maximum of 31 days (i.e.: startDate=2012-01-01&endDate=2012-01-31). Required.
        :paramtype end_date: ~datetime.date
        :keyword unit: Specifies to return the data in either metric units or imperial units. Default
         value is metric. Known values are: "metric" and "imperial". Default value is None.
        :paramtype unit: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "nextLink": "str",
                    "results": [
                        {
                            "date": "2020-02-20 00:00:00",
                            "degreeDaySummary": {
                                "cooling": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "heating": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            },
                            "precipitation": {
                                "unit": "str",
                                "unitType": 0,
                                "value": 0.0
                            },
                            "temperature": {
                                "average": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "maximum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                },
                                "minimum": {
                                    "unit": "str",
                                    "unitType": 0,
                                    "value": 0.0
                                }
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_weather_get_daily_historical_normals_request(
            format=format,
            coordinates=coordinates,
            start_date=start_date,
            end_date=end_date,
            unit=unit,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore
