# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ApiEntityReference(_serialization.Model):
    """The API entity reference.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class BackupProperties(_serialization.Model):
    """Cloud Hsm Cluster backup information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_storage_resource_uri: Azure storage Resource Uri.
    :vartype azure_storage_resource_uri: str
    :ivar last_backup_date_time: Last Date Time that Customer Enabled Backup was taken.
    :vartype last_backup_date_time: ~datetime.datetime
    :ivar last_backup_status: Status of last backup.
    :vartype last_backup_status: str
    """

    _validation = {
        "last_backup_date_time": {"readonly": True},
        "last_backup_status": {"readonly": True},
    }

    _attribute_map = {
        "azure_storage_resource_uri": {"key": "azureStorageResourceUri", "type": "str"},
        "last_backup_date_time": {"key": "lastBackupDateTime", "type": "iso-8601"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
    }

    def __init__(self, *, azure_storage_resource_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword azure_storage_resource_uri: Azure storage Resource Uri.
        :paramtype azure_storage_resource_uri: str
        """
        super().__init__(**kwargs)
        self.azure_storage_resource_uri = azure_storage_resource_uri
        self.last_backup_date_time = None
        self.last_backup_status = None


class CHsmError(_serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class CloudHsmClusterResource(TrackedResource):
    """Cloud HSM Cluster Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSku
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "CloudHsmClusterSku"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.CloudHsmClusterSku"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSku
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.identity = identity


class CloudHsmCluster(CloudHsmClusterResource):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSku
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
    :ivar properties: Properties of the Cloud HSM Cluster.
    :vartype properties: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "CloudHsmClusterSku"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "properties": {"key": "properties", "type": "CloudHsmClusterProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.CloudHsmClusterSku"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        properties: Optional["_models.CloudHsmClusterProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSku
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
        :keyword properties: Properties of the Cloud HSM Cluster.
        :paramtype properties: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterProperties
        """
        super().__init__(tags=tags, location=location, sku=sku, identity=identity, **kwargs)
        self.properties = properties


class CloudHsmClusterError(_serialization.Model):
    """The Cloud HSM Cluster error details.

    :ivar error: Error details.
    :vartype error: ~azure.mgmt.hardwaresecuritymodules.models.CHsmError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "CHsmError"},
    }

    def __init__(self, *, error: Optional["_models.CHsmError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Error details.
        :paramtype error: ~azure.mgmt.hardwaresecuritymodules.models.CHsmError
        """
        super().__init__(**kwargs)
        self.error = error


class CloudHsmClusterListResult(_serialization.Model):
    """List of Cloud HSM Clusters.

    :ivar value: The list of Cloud HSM Clusters.
    :vartype value: list[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmCluster]
    :ivar next_link: The URL to get the next set of Cloud HSM Clusters.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudHsmCluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CloudHsmCluster"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of Cloud HSM Clusters.
        :paramtype value: list[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmCluster]
        :keyword next_link: The URL to get the next set of Cloud HSM Clusters.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudHsmClusterPatchParameters(_serialization.Model):
    """Patchable properties of the Cloud HSM Cluster.

    :ivar tags: The Cloud HSM Cluster's tags.
    :vartype tags: dict[str, str]
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSku
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
    :ivar properties: Properties of the Cloud HSM Cluster.
    :vartype properties:
     ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterPatchParametersProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "CloudHsmClusterSku"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "properties": {"key": "properties", "type": "CloudHsmClusterPatchParametersProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.CloudHsmClusterSku"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        properties: Optional["_models.CloudHsmClusterPatchParametersProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The Cloud HSM Cluster's tags.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSku
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
        :keyword properties: Properties of the Cloud HSM Cluster.
        :paramtype properties:
         ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterPatchParametersProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.identity = identity
        self.properties = properties


class CloudHsmClusterPatchParametersProperties(_serialization.Model):
    """Properties of the Cloud HSM Cluster.

    :ivar backup_properties: Cloud Hsm Cluster backup information.
    :vartype backup_properties: ~azure.mgmt.hardwaresecuritymodules.models.BackupProperties
    """

    _attribute_map = {
        "backup_properties": {"key": "backupProperties", "type": "BackupProperties"},
    }

    def __init__(self, *, backup_properties: Optional["_models.BackupProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword backup_properties: Cloud Hsm Cluster backup information.
        :paramtype backup_properties: ~azure.mgmt.hardwaresecuritymodules.models.BackupProperties
        """
        super().__init__(**kwargs)
        self.backup_properties = backup_properties


class CloudHsmClusterProperties(_serialization.Model):
    """Properties of a Cloud HSM Cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The Cloud HSM Cluster's provisioningState. Known values are:
     "Provisioning", "Succeeded", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.hardwaresecuritymodules.models.ProvisioningState
    :ivar auto_generated_domain_name_label_scope: The Cloud HSM Cluster's auto-generated Domain
     Name Label Scope.
    :vartype auto_generated_domain_name_label_scope: str
    :ivar security_domain: Security domain properties information for Cloud HSM cluster.
    :vartype security_domain:
     ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSecurityDomainProperties
    :ivar hsms: An array of Cloud HSM Cluster's HSMs.
    :vartype hsms: list[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmProperties]
    :ivar public_network_access: The Cloud HSM Cluster public network access.
    :vartype public_network_access: str
    :ivar private_endpoint_connections: List of private endpoint connection resources.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnection]
    :ivar status_message: Cloud HSM Cluster status message.
    :vartype status_message: str
    :ivar restore_properties: Cloud Hsm Cluster restore information.
    :vartype restore_properties: ~azure.mgmt.hardwaresecuritymodules.models.RestoreProperties
    :ivar backup_properties: Cloud Hsm Cluster backup information.
    :vartype backup_properties: ~azure.mgmt.hardwaresecuritymodules.models.BackupProperties
    """

    _validation = {
        "status_message": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "auto_generated_domain_name_label_scope": {"key": "autoGeneratedDomainNameLabelScope", "type": "str"},
        "security_domain": {"key": "securityDomain", "type": "CloudHsmClusterSecurityDomainProperties"},
        "hsms": {"key": "hsms", "type": "[CloudHsmProperties]"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "restore_properties": {"key": "restoreProperties", "type": "RestoreProperties"},
        "backup_properties": {"key": "backupProperties", "type": "BackupProperties"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        auto_generated_domain_name_label_scope: Optional[str] = None,
        security_domain: Optional["_models.CloudHsmClusterSecurityDomainProperties"] = None,
        hsms: Optional[List["_models.CloudHsmProperties"]] = None,
        public_network_access: Optional[str] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        restore_properties: Optional["_models.RestoreProperties"] = None,
        backup_properties: Optional["_models.BackupProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The Cloud HSM Cluster's provisioningState. Known values are:
         "Provisioning", "Succeeded", "Failed", "Deleting", and "Canceled".
        :paramtype provisioning_state: str or
         ~azure.mgmt.hardwaresecuritymodules.models.ProvisioningState
        :keyword auto_generated_domain_name_label_scope: The Cloud HSM Cluster's auto-generated Domain
         Name Label Scope.
        :paramtype auto_generated_domain_name_label_scope: str
        :keyword security_domain: Security domain properties information for Cloud HSM cluster.
        :paramtype security_domain:
         ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSecurityDomainProperties
        :keyword hsms: An array of Cloud HSM Cluster's HSMs.
        :paramtype hsms: list[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmProperties]
        :keyword public_network_access: The Cloud HSM Cluster public network access.
        :paramtype public_network_access: str
        :keyword private_endpoint_connections: List of private endpoint connection resources.
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnection]
        :keyword restore_properties: Cloud Hsm Cluster restore information.
        :paramtype restore_properties: ~azure.mgmt.hardwaresecuritymodules.models.RestoreProperties
        :keyword backup_properties: Cloud Hsm Cluster backup information.
        :paramtype backup_properties: ~azure.mgmt.hardwaresecuritymodules.models.BackupProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope
        self.security_domain = security_domain
        self.hsms = hsms
        self.public_network_access = public_network_access
        self.private_endpoint_connections = private_endpoint_connections
        self.status_message = None
        self.restore_properties = restore_properties
        self.backup_properties = backup_properties


class CloudHsmClusterSecurityDomainProperties(_serialization.Model):
    """Security domain properties information for Cloud HSM cluster.

    :ivar fips_state: FIPS state information for security domain.
    :vartype fips_state: int
    :ivar activation_status: status of security domain activation.
    :vartype activation_status: str
    """

    _attribute_map = {
        "fips_state": {"key": "fipsState", "type": "int"},
        "activation_status": {"key": "activationStatus", "type": "str"},
    }

    def __init__(
        self, *, fips_state: Optional[int] = None, activation_status: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword fips_state: FIPS state information for security domain.
        :paramtype fips_state: int
        :keyword activation_status: status of security domain activation.
        :paramtype activation_status: str
        """
        super().__init__(**kwargs)
        self.fips_state = fips_state
        self.activation_status = activation_status


class CloudHsmClusterSku(_serialization.Model):
    """Cloud Hsm Cluster SKU information.

    All required parameters must be populated in order to send to Azure.

    :ivar family: Sku family of the Cloud HSM Cluster. "B"
    :vartype family: str or ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSkuFamily
    :ivar name: Sku name of the Cloud HSM Cluster. Required. Known values are: "Standard_B1" and
     "Standard B10".
    :vartype name: str or ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSkuName
    :ivar capacity: Sku capacity.
    :vartype capacity: int
    """

    _validation = {
        "family": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "family": {"key": "family", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        family: Union[str, "_models.CloudHsmClusterSkuFamily"] = "B",
        name: Union[str, "_models.CloudHsmClusterSkuName"],
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword family: Sku family of the Cloud HSM Cluster. "B"
        :paramtype family: str or ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSkuFamily
        :keyword name: Sku name of the Cloud HSM Cluster. Required. Known values are: "Standard_B1" and
         "Standard B10".
        :paramtype name: str or ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSkuName
        :keyword capacity: Sku capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.family = family
        self.name = name
        self.capacity = capacity


class CloudHsmProperties(_serialization.Model):
    """The Cloud HSM Properties.

    :ivar fqdn: FQDN of the Cloud HSM.
    :vartype fqdn: str
    :ivar state: The Cloud HSM State.
    :vartype state: str
    :ivar state_message: The Cloud HSM State message.
    :vartype state_message: str
    """

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_message": {"key": "stateMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        fqdn: Optional[str] = None,
        state: Optional[str] = None,
        state_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword fqdn: FQDN of the Cloud HSM.
        :paramtype fqdn: str
        :keyword state: The Cloud HSM State.
        :paramtype state: str
        :keyword state_message: The Cloud HSM State message.
        :paramtype state_message: str
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.state = state
        self.state_message = state_message


class DedicatedHsmResource(_serialization.Model):
    """Dedicated HSM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The Azure Resource Manager resource ID for the dedicated HSM.
    :vartype id: str
    :ivar name: The name of the dedicated HSM.
    :vartype name: str
    :ivar type: The resource type of the dedicated HSM.
    :vartype type: str
    :ivar location: The supported Azure location where the dedicated HSM should be created.
     Required.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.hardwaresecuritymodules.models.Sku
    :ivar zones: The Dedicated Hsm zones.
    :vartype zones: list[str]
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "zones": {"key": "zones", "type": "[str]"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: Optional["_models.Sku"] = None,
        zones: Optional[List[str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the dedicated HSM should be created.
         Required.
        :paramtype location: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.hardwaresecuritymodules.models.Sku
        :keyword zones: The Dedicated Hsm zones.
        :paramtype zones: list[str]
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.sku = sku
        self.zones = zones
        self.tags = tags


class DedicatedHsm(DedicatedHsmResource):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The Azure Resource Manager resource ID for the dedicated HSM.
    :vartype id: str
    :ivar name: The name of the dedicated HSM.
    :vartype name: str
    :ivar type: The resource type of the dedicated HSM.
    :vartype type: str
    :ivar location: The supported Azure location where the dedicated HSM should be created.
     Required.
    :vartype location: str
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.hardwaresecuritymodules.models.Sku
    :ivar zones: The Dedicated Hsm zones.
    :vartype zones: list[str]
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemDataAutoGenerated
    :ivar properties: Properties of the dedicated HSM. Required.
    :vartype properties: ~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "zones": {"key": "zones", "type": "[str]"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemDataAutoGenerated"},
        "properties": {"key": "properties", "type": "DedicatedHsmProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.DedicatedHsmProperties",
        sku: Optional["_models.Sku"] = None,
        zones: Optional[List[str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The supported Azure location where the dedicated HSM should be created.
         Required.
        :paramtype location: str
        :keyword sku: SKU details.
        :paramtype sku: ~azure.mgmt.hardwaresecuritymodules.models.Sku
        :keyword zones: The Dedicated Hsm zones.
        :paramtype zones: list[str]
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the dedicated HSM. Required.
        :paramtype properties: ~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmProperties
        """
        super().__init__(location=location, sku=sku, zones=zones, tags=tags, **kwargs)
        self.system_data = None
        self.properties = properties


class DedicatedHsmError(_serialization.Model):
    """The error exception.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error detail of the operation if any.
    :vartype error: ~azure.mgmt.hardwaresecuritymodules.models.Error
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class DedicatedHsmListResult(_serialization.Model):
    """List of dedicated HSMs.

    :ivar value: The list of dedicated HSMs.
    :vartype value: list[~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsm]
    :ivar next_link: The URL to get the next set of dedicated hsms.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHsm]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DedicatedHsm"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of dedicated HSMs.
        :paramtype value: list[~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsm]
        :keyword next_link: The URL to get the next set of dedicated hsms.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DedicatedHsmOperation(_serialization.Model):
    """REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the Dedicated HSM Resource Provider Operation.
    :vartype name: str
    :ivar is_data_action: Gets or sets a value indicating whether it is a data plane action.
    :vartype is_data_action: bool
    :ivar origin: The origin of the operation.
    :vartype origin: str
    :ivar display: The display string.
    :vartype display: ~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmOperationDisplay
    """

    _validation = {
        "is_data_action": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "origin": {"key": "origin", "type": "str"},
        "display": {"key": "display", "type": "DedicatedHsmOperationDisplay"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        origin: Optional[str] = None,
        display: Optional["_models.DedicatedHsmOperationDisplay"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the Dedicated HSM Resource Provider Operation.
        :paramtype name: str
        :keyword origin: The origin of the operation.
        :paramtype origin: str
        :keyword display: The display string.
        :paramtype display: ~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmOperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = None
        self.origin = origin
        self.display = display


class DedicatedHsmOperationDisplay(_serialization.Model):
    """The display string.

    :ivar provider: The Resource Provider of the operation.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: The object that represents the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The Resource Provider of the operation.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: The object that represents the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class DedicatedHsmOperationListResult(_serialization.Model):
    """Result of the request to list Dedicated HSM Provider operations. It contains a list of
    operations.

    :ivar value: List of Dedicated HSM Resource Provider operations.
    :vartype value: list[~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmOperation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHsmOperation]"},
    }

    def __init__(self, *, value: Optional[List["_models.DedicatedHsmOperation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Dedicated HSM Resource Provider operations.
        :paramtype value: list[~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmOperation]
        """
        super().__init__(**kwargs)
        self.value = value


class DedicatedHsmPatchParameters(_serialization.Model):
    """Patchable properties of the dedicated HSM.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class DedicatedHsmProperties(_serialization.Model):
    """Properties of the dedicated hsm.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_profile: Specifies the network interfaces of the dedicated hsm.
    :vartype network_profile: ~azure.mgmt.hardwaresecuritymodules.models.NetworkProfile
    :ivar management_network_profile: Specifies the management network interfaces of the dedicated
     hsm.
    :vartype management_network_profile: ~azure.mgmt.hardwaresecuritymodules.models.NetworkProfile
    :ivar stamp_id: This field will be used when RP does not support Availability zones.
    :vartype stamp_id: str
    :ivar status_message: Resource Status Message.
    :vartype status_message: str
    :ivar provisioning_state: Provisioning state. Known values are: "Succeeded", "Provisioning",
     "Allocating", "Connecting", "Failed", "CheckingQuota", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.hardwaresecuritymodules.models.JsonWebKeyType
    """

    _validation = {
        "status_message": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "network_profile": {"key": "networkProfile", "type": "NetworkProfile"},
        "management_network_profile": {"key": "managementNetworkProfile", "type": "NetworkProfile"},
        "stamp_id": {"key": "stampId", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_profile: Optional["_models.NetworkProfile"] = None,
        management_network_profile: Optional["_models.NetworkProfile"] = None,
        stamp_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_profile: Specifies the network interfaces of the dedicated hsm.
        :paramtype network_profile: ~azure.mgmt.hardwaresecuritymodules.models.NetworkProfile
        :keyword management_network_profile: Specifies the management network interfaces of the
         dedicated hsm.
        :paramtype management_network_profile:
         ~azure.mgmt.hardwaresecuritymodules.models.NetworkProfile
        :keyword stamp_id: This field will be used when RP does not support Availability zones.
        :paramtype stamp_id: str
        """
        super().__init__(**kwargs)
        self.network_profile = network_profile
        self.management_network_profile = management_network_profile
        self.stamp_id = stamp_id
        self.status_message = None
        self.provisioning_state = None


class EndpointDependency(_serialization.Model):
    """A domain name that dedicated hsm services are reaching at.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The Ports and Protocols used when connecting to domainName.
    :vartype endpoint_details: list[~azure.mgmt.hardwaresecuritymodules.models.EndpointDetail]
    """

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["_models.EndpointDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain_name: The domain name of the dependency.
        :paramtype domain_name: str
        :keyword endpoint_details: The Ports and Protocols used when connecting to domainName.
        :paramtype endpoint_details: list[~azure.mgmt.hardwaresecuritymodules.models.EndpointDetail]
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(_serialization.Model):
    """Connect information from the dedicated hsm service to a single endpoint.

    :ivar ip_address: An IP Address that Domain Name currently resolves to.
    :vartype ip_address: str
    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar protocol: The protocol used for connection.
    :vartype protocol: str
    :ivar description: Description of the detail.
    :vartype description: str
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "protocol": {"key": "protocol", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_address: An IP Address that Domain Name currently resolves to.
        :paramtype ip_address: str
        :keyword port: The port an endpoint is connected to.
        :paramtype port: int
        :keyword protocol: The protocol used for connection.
        :paramtype protocol: str
        :keyword description: Description of the detail.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.protocol = protocol
        self.description = description


class Error(_serialization.Model):
    """The key vault server error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: Contains more specific error that narrows down the cause. May be null.
    :vartype inner_error: ~azure.mgmt.hardwaresecuritymodules.models.Error
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "inner_error": {"key": "innererror", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.hardwaresecuritymodules.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.hardwaresecuritymodules.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NetworkInterface(_serialization.Model):
    """The network interface definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    :ivar private_ip_address: Private Ip address of the interface.
    :vartype private_ip_address: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "private_ip_address": {"key": "privateIpAddress", "type": "str"},
    }

    def __init__(self, *, private_ip_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword private_ip_address: Private Ip address of the interface.
        :paramtype private_ip_address: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.private_ip_address = private_ip_address


class NetworkProfile(_serialization.Model):
    """The network profile definition.

    :ivar subnet: Specifies the identifier of the subnet.
    :vartype subnet: ~azure.mgmt.hardwaresecuritymodules.models.ApiEntityReference
    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the dedicated HSM.
    :vartype network_interfaces: list[~azure.mgmt.hardwaresecuritymodules.models.NetworkInterface]
    """

    _attribute_map = {
        "subnet": {"key": "subnet", "type": "ApiEntityReference"},
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterface]"},
    }

    def __init__(
        self,
        *,
        subnet: Optional["_models.ApiEntityReference"] = None,
        network_interfaces: Optional[List["_models.NetworkInterface"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet: Specifies the identifier of the subnet.
        :paramtype subnet: ~azure.mgmt.hardwaresecuritymodules.models.ApiEntityReference
        :keyword network_interfaces: Specifies the list of resource Ids for the network interfaces
         associated with the dedicated HSM.
        :paramtype network_interfaces:
         list[~azure.mgmt.hardwaresecuritymodules.models.NetworkInterface]
        """
        super().__init__(**kwargs)
        self.subnet = subnet
        self.network_interfaces = network_interfaces


class OutboundEnvironmentEndpoint(_serialization.Model):
    """Egress endpoints which dedicated hsm service connects to for common purpose.

    :ivar category: The category of endpoints accessed by the dedicated hsm service, e.g.
     azure-resource-management, apiserver, etc.
    :vartype category: str
    :ivar endpoints: The endpoints that dedicated hsm service connects to.
    :vartype endpoints: list[~azure.mgmt.hardwaresecuritymodules.models.EndpointDependency]
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["_models.EndpointDependency"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: The category of endpoints accessed by the dedicated hsm service, e.g.
         azure-resource-management, apiserver, etc.
        :paramtype category: str
        :keyword endpoints: The endpoints that dedicated hsm service connects to.
        :paramtype endpoints: list[~azure.mgmt.hardwaresecuritymodules.models.EndpointDependency]
        """
        super().__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointCollection(_serialization.Model):
    """Collection of OutboundEnvironmentEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.hardwaresecuritymodules.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.OutboundEnvironmentEndpoint"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.hardwaresecuritymodules.models.OutboundEnvironmentEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateEndpoint(_serialization.Model):
    """The private endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for private endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class PrivateEndpointConnection(ProxyResource):
    """The private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties:
     ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnectionProperties
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Resource properties.
        :paramtype properties:
         ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnectionProperties
        :keyword etag: Modified whenever there is a change in the state of private endpoint connection.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.etag = etag


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connections associated with the specified resource.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnection]
    :ivar next_link: The URL to get the next set of private endpoint connections.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnection]
        :keyword next_link: The URL to get the next set of private endpoint connections.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateEndpointConnectionProperties(_serialization.Model):
    """Properties of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.hardwaresecuritymodules.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", "Failed", "Updating", "InternalError",
     and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnectionProvisioningState
    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    """

    _validation = {
        "private_link_service_connection_state": {"required": True},
        "provisioning_state": {"readonly": True},
        "group_ids": {"readonly": True},
    }

    _attribute_map = {
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint resource.
        :paramtype private_endpoint: ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider. Required.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.hardwaresecuritymodules.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None
        self.group_ids = None


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.hardwaresecuritymodules.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PrivateLinkResourceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Resource properties.
        :paramtype properties: ~azure.mgmt.hardwaresecuritymodules.models.PrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.hardwaresecuritymodules.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.hardwaresecuritymodules.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResourceProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ResourceListResult(_serialization.Model):
    """List of dedicated HSM resources.

    :ivar value: The list of dedicated HSM resources.
    :vartype value: list[~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmResource]
    :ivar next_link: The URL to get the next set of dedicated HSM resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHsmResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DedicatedHsmResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of dedicated HSM resources.
        :paramtype value: list[~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmResource]
        :keyword next_link: The URL to get the next set of dedicated HSM resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RestoreProperties(_serialization.Model):
    """Cloud Hsm Cluster restore information.

    :ivar foldername: Directory name in Azure Storage Blob where the backup is stored.
    :vartype foldername: str
    :ivar azure_storage_resource_uri: Azure Blob storage container Uri.
    :vartype azure_storage_resource_uri: str
    """

    _attribute_map = {
        "foldername": {"key": "foldername", "type": "str"},
        "azure_storage_resource_uri": {"key": "azureStorageResourceUri", "type": "str"},
    }

    def __init__(
        self, *, foldername: Optional[str] = None, azure_storage_resource_uri: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword foldername: Directory name in Azure Storage Blob where the backup is stored.
        :paramtype foldername: str
        :keyword azure_storage_resource_uri: Azure Blob storage container Uri.
        :paramtype azure_storage_resource_uri: str
        """
        super().__init__(**kwargs)
        self.foldername = foldername
        self.azure_storage_resource_uri = azure_storage_resource_uri


class Sku(_serialization.Model):
    """SKU of the dedicated HSM.

    :ivar name: SKU of the dedicated HSM. Known values are: "SafeNet Luna Network HSM A790",
     "payShield10K_LMK1_CPS60", "payShield10K_LMK1_CPS250", "payShield10K_LMK1_CPS2500",
     "payShield10K_LMK2_CPS60", "payShield10K_LMK2_CPS250", and "payShield10K_LMK2_CPS2500".
    :vartype name: str or ~azure.mgmt.hardwaresecuritymodules.models.SkuName
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.SkuName"]] = None, **kwargs: Any) -> None:
        """
        :keyword name: SKU of the dedicated HSM. Known values are: "SafeNet Luna Network HSM A790",
         "payShield10K_LMK1_CPS60", "payShield10K_LMK1_CPS250", "payShield10K_LMK1_CPS2500",
         "payShield10K_LMK2_CPS60", "payShield10K_LMK2_CPS250", and "payShield10K_LMK2_CPS2500".
        :paramtype name: str or ~azure.mgmt.hardwaresecuritymodules.models.SkuName
        """
        super().__init__(**kwargs)
        self.name = name


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hardwaresecuritymodules.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hardwaresecuritymodules.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.hardwaresecuritymodules.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.hardwaresecuritymodules.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class SystemDataAutoGenerated(_serialization.Model):
    """Metadata pertaining to creation and last modification of dedicated hsm resource.

    :ivar created_by: The identity that created dedicated hsm resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created dedicated hsm resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hardwaresecuritymodules.models.IdentityType
    :ivar created_at: The timestamp of dedicated hsm resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified dedicated hsm resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified dedicated hsm resource.
     Known values are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hardwaresecuritymodules.models.IdentityType
    :ivar last_modified_at: The timestamp of dedicated hsm resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created dedicated hsm resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created dedicated hsm resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.hardwaresecuritymodules.models.IdentityType
        :keyword created_at: The timestamp of dedicated hsm resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified dedicated hsm resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified dedicated hsm resource.
         Known values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.hardwaresecuritymodules.models.IdentityType
        :keyword last_modified_at: The timestamp of dedicated hsm resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
