# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class ElasticSan(TrackedResource):
    """Response for ElasticSan request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of ElasticSan. Required.
    :vartype properties: ~azure.mgmt.elasticsan.models.ElasticSanProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ElasticSanProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.ElasticSanProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Properties of ElasticSan. Required.
        :paramtype properties: ~azure.mgmt.elasticsan.models.ElasticSanProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class ElasticSanList(_serialization.Model):
    """List of Elastic Sans.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of Elastic San objects.
    :vartype value: list[~azure.mgmt.elasticsan.models.ElasticSan]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ElasticSan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ElasticSan"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of Elastic San objects.
        :paramtype value: list[~azure.mgmt.elasticsan.models.ElasticSan]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ElasticSanProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Elastic San response properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar sku: resource sku. Required.
    :vartype sku: ~azure.mgmt.elasticsan.models.Sku
    :ivar availability_zones: Logical zone for Elastic San resource; example: ["1"].
    :vartype availability_zones: list[str]
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar base_size_ti_b: Base size of the Elastic San appliance in TiB. Required.
    :vartype base_size_ti_b: int
    :ivar extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB. Required.
    :vartype extended_capacity_size_ti_b: int
    :ivar total_volume_size_gi_b: Total size of the provisioned Volumes in GiB.
    :vartype total_volume_size_gi_b: int
    :ivar volume_group_count: Total number of volume groups in this Elastic San appliance.
    :vartype volume_group_count: int
    :ivar total_iops: Total Provisioned IOPS of the Elastic San appliance.
    :vartype total_iops: int
    :ivar total_m_bps: Total Provisioned MBps Elastic San appliance.
    :vartype total_m_bps: int
    :ivar total_size_ti_b: Total size of the Elastic San appliance in TB.
    :vartype total_size_ti_b: int
    :ivar private_endpoint_connections: The list of Private Endpoint Connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.elasticsan.models.PrivateEndpointConnection]
    :ivar public_network_access: Allow or disallow public network access to ElasticSan. Value is
     optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
     "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.elasticsan.models.PublicNetworkAccess
    """

    _validation = {
        "sku": {"required": True},
        "provisioning_state": {"readonly": True},
        "base_size_ti_b": {"required": True},
        "extended_capacity_size_ti_b": {"required": True},
        "total_volume_size_gi_b": {"readonly": True},
        "volume_group_count": {"readonly": True},
        "total_iops": {"readonly": True},
        "total_m_bps": {"readonly": True},
        "total_size_ti_b": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "base_size_ti_b": {"key": "baseSizeTiB", "type": "int"},
        "extended_capacity_size_ti_b": {"key": "extendedCapacitySizeTiB", "type": "int"},
        "total_volume_size_gi_b": {"key": "totalVolumeSizeGiB", "type": "int"},
        "volume_group_count": {"key": "volumeGroupCount", "type": "int"},
        "total_iops": {"key": "totalIops", "type": "int"},
        "total_m_bps": {"key": "totalMBps", "type": "int"},
        "total_size_ti_b": {"key": "totalSizeTiB", "type": "int"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        base_size_ti_b: int,
        extended_capacity_size_ti_b: int,
        availability_zones: Optional[List[str]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: resource sku. Required.
        :paramtype sku: ~azure.mgmt.elasticsan.models.Sku
        :keyword availability_zones: Logical zone for Elastic San resource; example: ["1"].
        :paramtype availability_zones: list[str]
        :keyword base_size_ti_b: Base size of the Elastic San appliance in TiB. Required.
        :paramtype base_size_ti_b: int
        :keyword extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB.
         Required.
        :paramtype extended_capacity_size_ti_b: int
        :keyword public_network_access: Allow or disallow public network access to ElasticSan. Value is
         optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
         "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.elasticsan.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.availability_zones = availability_zones
        self.provisioning_state = None
        self.base_size_ti_b = base_size_ti_b
        self.extended_capacity_size_ti_b = extended_capacity_size_ti_b
        self.total_volume_size_gi_b = None
        self.volume_group_count = None
        self.total_iops = None
        self.total_m_bps = None
        self.total_size_ti_b = None
        self.private_endpoint_connections = None
        self.public_network_access = public_network_access


class ElasticSanUpdate(_serialization.Model):
    """Response for ElasticSan update request.

    :ivar properties: Properties of ElasticSan.
    :vartype properties: ~azure.mgmt.elasticsan.models.ElasticSanUpdateProperties
    :ivar tags: Update tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ElasticSanUpdateProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ElasticSanUpdateProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of ElasticSan.
        :paramtype properties: ~azure.mgmt.elasticsan.models.ElasticSanUpdateProperties
        :keyword tags: Update tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class ElasticSanUpdateProperties(_serialization.Model):
    """Elastic San update properties.

    :ivar base_size_ti_b: Base size of the Elastic San appliance in TiB.
    :vartype base_size_ti_b: int
    :ivar extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB.
    :vartype extended_capacity_size_ti_b: int
    :ivar public_network_access: Allow or disallow public network access to ElasticSan Account.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.elasticsan.models.PublicNetworkAccess
    """

    _attribute_map = {
        "base_size_ti_b": {"key": "baseSizeTiB", "type": "int"},
        "extended_capacity_size_ti_b": {"key": "extendedCapacitySizeTiB", "type": "int"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        base_size_ti_b: Optional[int] = None,
        extended_capacity_size_ti_b: Optional[int] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword base_size_ti_b: Base size of the Elastic San appliance in TiB.
        :paramtype base_size_ti_b: int
        :keyword extended_capacity_size_ti_b: Extended size of the Elastic San appliance in TiB.
        :paramtype extended_capacity_size_ti_b: int
        :keyword public_network_access: Allow or disallow public network access to ElasticSan Account.
         Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.elasticsan.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.base_size_ti_b = base_size_ti_b
        self.extended_capacity_size_ti_b = extended_capacity_size_ti_b
        self.public_network_access = public_network_access


class EncryptionIdentity(_serialization.Model):
    """Encryption identity for the volume group.

    :ivar encryption_user_assigned_identity: Resource identifier of the UserAssigned identity to be
     associated with server-side encryption on the volume group.
    :vartype encryption_user_assigned_identity: str
    """

    _attribute_map = {
        "encryption_user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(self, *, encryption_user_assigned_identity: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword encryption_user_assigned_identity: Resource identifier of the UserAssigned identity to
         be associated with server-side encryption on the volume group.
        :paramtype encryption_user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.encryption_user_assigned_identity = encryption_user_assigned_identity


class EncryptionProperties(_serialization.Model):
    """The encryption settings on the volume group.

    :ivar key_vault_properties: Properties provided by key vault.
    :vartype key_vault_properties: ~azure.mgmt.elasticsan.models.KeyVaultProperties
    :ivar encryption_identity: The identity to be used with service-side encryption at rest.
    :vartype encryption_identity: ~azure.mgmt.elasticsan.models.EncryptionIdentity
    """

    _attribute_map = {
        "key_vault_properties": {"key": "keyVaultProperties", "type": "KeyVaultProperties"},
        "encryption_identity": {"key": "identity", "type": "EncryptionIdentity"},
    }

    def __init__(
        self,
        *,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        encryption_identity: Optional["_models.EncryptionIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_properties: Properties provided by key vault.
        :paramtype key_vault_properties: ~azure.mgmt.elasticsan.models.KeyVaultProperties
        :keyword encryption_identity: The identity to be used with service-side encryption at rest.
        :paramtype encryption_identity: ~azure.mgmt.elasticsan.models.EncryptionIdentity
        """
        super().__init__(**kwargs)
        self.key_vault_properties = key_vault_properties
        self.encryption_identity = encryption_identity


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.elasticsan.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.elasticsan.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.elasticsan.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.elasticsan.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Required. Known values are: "None", "SystemAssigned", and
     "UserAssigned".
    :vartype type: str or ~azure.mgmt.elasticsan.models.IdentityType
    :ivar user_assigned_identities: Gets or sets a list of key value pairs that describe the set of
     User Assigned identities that will be used with this volume group. The key is the ARM resource
     identifier of the identity.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.elasticsan.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.IdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. Required. Known values are: "None", "SystemAssigned", and
         "UserAssigned".
        :paramtype type: str or ~azure.mgmt.elasticsan.models.IdentityType
        :keyword user_assigned_identities: Gets or sets a list of key value pairs that describe the set
         of User Assigned identities that will be used with this volume group. The key is the ARM
         resource identifier of the identity.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.elasticsan.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class IscsiTargetInfo(_serialization.Model):
    """Iscsi target information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_iqn: iSCSI Target IQN (iSCSI Qualified Name); example:
     "iqn.2005-03.org.iscsi:server".
    :vartype target_iqn: str
    :ivar target_portal_hostname: iSCSI Target Portal Host Name.
    :vartype target_portal_hostname: str
    :ivar target_portal_port: iSCSI Target Portal Port.
    :vartype target_portal_port: int
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar status: Operational status of the iSCSI Target. Known values are: "Invalid", "Unknown",
     "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped (deallocated)".
    :vartype status: str or ~azure.mgmt.elasticsan.models.OperationalStatus
    """

    _validation = {
        "target_iqn": {"readonly": True},
        "target_portal_hostname": {"readonly": True},
        "target_portal_port": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "target_iqn": {"key": "targetIqn", "type": "str"},
        "target_portal_hostname": {"key": "targetPortalHostname", "type": "str"},
        "target_portal_port": {"key": "targetPortalPort", "type": "int"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[Union[str, "_models.OperationalStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword status: Operational status of the iSCSI Target. Known values are: "Invalid",
         "Unknown", "Healthy", "Unhealthy", "Updating", "Running", "Stopped", and "Stopped
         (deallocated)".
        :paramtype status: str or ~azure.mgmt.elasticsan.models.OperationalStatus
        """
        super().__init__(**kwargs)
        self.target_iqn = None
        self.target_portal_hostname = None
        self.target_portal_port = None
        self.provisioning_state = None
        self.status = status


class KeyVaultProperties(_serialization.Model):
    """Properties of key vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: The name of KeyVault key.
    :vartype key_name: str
    :ivar key_version: The version of KeyVault key.
    :vartype key_version: str
    :ivar key_vault_uri: The Uri of KeyVault.
    :vartype key_vault_uri: str
    :ivar current_versioned_key_identifier: The object identifier of the current versioned Key
     Vault Key in use.
    :vartype current_versioned_key_identifier: str
    :ivar last_key_rotation_timestamp: Timestamp of last rotation of the Key Vault Key.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    :ivar current_versioned_key_expiration_timestamp: This is a read only property that represents
     the expiration time of the current version of the customer managed key used for encryption.
    :vartype current_versioned_key_expiration_timestamp: ~datetime.datetime
    """

    _validation = {
        "current_versioned_key_identifier": {"readonly": True},
        "last_key_rotation_timestamp": {"readonly": True},
        "current_versioned_key_expiration_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "current_versioned_key_identifier": {"key": "currentVersionedKeyIdentifier", "type": "str"},
        "last_key_rotation_timestamp": {"key": "lastKeyRotationTimestamp", "type": "iso-8601"},
        "current_versioned_key_expiration_timestamp": {
            "key": "currentVersionedKeyExpirationTimestamp",
            "type": "iso-8601",
        },
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_name: The name of KeyVault key.
        :paramtype key_name: str
        :keyword key_version: The version of KeyVault key.
        :paramtype key_version: str
        :keyword key_vault_uri: The Uri of KeyVault.
        :paramtype key_vault_uri: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri
        self.current_versioned_key_identifier = None
        self.last_key_rotation_timestamp = None
        self.current_versioned_key_expiration_timestamp = None


class ManagedByInfo(_serialization.Model):
    """Parent resource information.

    :ivar resource_id: Resource ID of the resource managing the volume, this is a restricted field
     and can only be set for internal use.
    :vartype resource_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: Resource ID of the resource managing the volume, this is a restricted
         field and can only be set for internal use.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id


class NetworkRuleSet(_serialization.Model):
    """A set of rules governing the network accessibility.

    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.elasticsan.models.VirtualNetworkRule]
    """

    _attribute_map = {
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[VirtualNetworkRule]"},
    }

    def __init__(
        self, *, virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword virtual_network_rules: The list of virtual network rules.
        :paramtype virtual_network_rules: list[~azure.mgmt.elasticsan.models.VirtualNetworkRule]
        """
        super().__init__(**kwargs)
        self.virtual_network_rules = virtual_network_rules


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.elasticsan.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.elasticsan.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.elasticsan.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.elasticsan.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.elasticsan.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpoint(_serialization.Model):
    """Response for PrivateEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """Response for PrivateEndpoint Connection object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar properties: Private Endpoint Connection Properties. Required.
    :vartype properties: ~azure.mgmt.elasticsan.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
    }

    def __init__(self, *, properties: "_models.PrivateEndpointConnectionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Private Endpoint Connection Properties. Required.
        :paramtype properties: ~azure.mgmt.elasticsan.models.PrivateEndpointConnectionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connections associated with SAN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.elasticsan.models.PrivateEndpointConnection]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.elasticsan.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateEndpointConnectionProperties(_serialization.Model):
    """Response for PrivateEndpoint connection properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: Provisioning State of Private Endpoint connection resource. Known
     values are: "Invalid", "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating",
     and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar private_endpoint: Private Endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.elasticsan.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Private Link Service Connection State. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.elasticsan.models.PrivateLinkServiceConnectionState
    :ivar group_ids: List of resources private endpoint is mapped.
    :vartype group_ids: list[str]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "private_link_service_connection_state": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "group_ids": {"key": "groupIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private Endpoint resource.
        :paramtype private_endpoint: ~azure.mgmt.elasticsan.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Private Link Service Connection State.
         Required.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.elasticsan.models.PrivateLinkServiceConnectionState
        :keyword group_ids: List of resources private endpoint is mapped.
        :paramtype group_ids: list[str]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.group_ids = group_ids


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.elasticsan.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PrivateLinkResourceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Resource properties.
        :paramtype properties: ~azure.mgmt.elasticsan.models.PrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.elasticsan.models.PrivateLinkResource]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.elasticsan.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateLinkResourceProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkServiceConnectionState(_serialization.Model):
    """Response for Private Link Service Connection state.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", "Failed", and "Rejected".
    :vartype status: str or ~azure.mgmt.elasticsan.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", "Failed", and "Rejected".
        :paramtype status: str or ~azure.mgmt.elasticsan.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    """


class Sku(_serialization.Model):
    """The SKU name. Required for account creation; optional for update.

    All required parameters must be populated in order to send to server.

    :ivar name: The sku name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
    :vartype name: str or ~azure.mgmt.elasticsan.models.SkuName
    :ivar tier: The sku tier. "Premium"
    :vartype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
        :paramtype name: str or ~azure.mgmt.elasticsan.models.SkuName
        :keyword tier: The sku tier. "Premium"
        :paramtype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class SKUCapability(_serialization.Model):
    """The capability information in the specified SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of capability.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class SkuInformation(_serialization.Model):
    """ElasticSAN SKU and its properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Sku Name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
    :vartype name: str or ~azure.mgmt.elasticsan.models.SkuName
    :ivar tier: Sku Tier. "Premium"
    :vartype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar location_info: Availability of the SKU for the location/zone.
    :vartype location_info: list[~azure.mgmt.elasticsan.models.SkuLocationInfo]
    :ivar capabilities: The capability information in the specified SKU.
    :vartype capabilities: list[~azure.mgmt.elasticsan.models.SKUCapability]
    """

    _validation = {
        "name": {"required": True},
        "resource_type": {"readonly": True},
        "locations": {"readonly": True},
        "location_info": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[SkuLocationInfo]"},
        "capabilities": {"key": "capabilities", "type": "[SKUCapability]"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Sku Name. Required. Known values are: "Premium_LRS" and "Premium_ZRS".
        :paramtype name: str or ~azure.mgmt.elasticsan.models.SkuName
        :keyword tier: Sku Tier. "Premium"
        :paramtype tier: str or ~azure.mgmt.elasticsan.models.SkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.resource_type = None
        self.locations = None
        self.location_info = None
        self.capabilities = None


class SkuInformationList(_serialization.Model):
    """List of SKU Information objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ResourceType Sku.
    :vartype value: list[~azure.mgmt.elasticsan.models.SkuInformation]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuInformation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SkuLocationInfo(_serialization.Model):
    """The location info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: The location.
    :vartype location: str
    :ivar zones: The zones.
    :vartype zones: list[str]
    """

    _validation = {
        "location": {"readonly": True},
        "zones": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location = None
        self.zones = None


class Snapshot(ProxyResource):
    """Response for Volume Snapshot request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar properties: Properties of Volume Snapshot. Required.
    :vartype properties: ~azure.mgmt.elasticsan.models.SnapshotProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SnapshotProperties"},
    }

    def __init__(self, *, properties: "_models.SnapshotProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of Volume Snapshot. Required.
        :paramtype properties: ~azure.mgmt.elasticsan.models.SnapshotProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SnapshotCreationData(_serialization.Model):
    """Data used when creating a volume snapshot.

    All required parameters must be populated in order to send to server.

    :ivar source_id: Fully qualified resource ID of the volume. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}".  # pylint: disable=line-too-long
     Required.
    :vartype source_id: str
    """

    _validation = {
        "source_id": {"required": True},
    }

    _attribute_map = {
        "source_id": {"key": "sourceId", "type": "str"},
    }

    def __init__(self, *, source_id: str, **kwargs: Any) -> None:
        """
        :keyword source_id: Fully qualified resource ID of the volume. E.g.
         "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}".  # pylint: disable=line-too-long
         Required.
        :paramtype source_id: str
        """
        super().__init__(**kwargs)
        self.source_id = source_id


class SnapshotList(_serialization.Model):
    """List of Snapshots.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of Snapshot objects.
    :vartype value: list[~azure.mgmt.elasticsan.models.Snapshot]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Snapshot]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Snapshot"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of Snapshot objects.
        :paramtype value: list[~azure.mgmt.elasticsan.models.Snapshot]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SnapshotProperties(_serialization.Model):
    """Properties for Snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar creation_data: Data used when creating a volume snapshot. Required.
    :vartype creation_data: ~azure.mgmt.elasticsan.models.SnapshotCreationData
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar source_volume_size_gi_b: Size of Source Volume.
    :vartype source_volume_size_gi_b: int
    :ivar volume_name: Source Volume Name of a snapshot.
    :vartype volume_name: str
    """

    _validation = {
        "creation_data": {"required": True},
        "provisioning_state": {"readonly": True},
        "source_volume_size_gi_b": {"readonly": True},
        "volume_name": {"readonly": True},
    }

    _attribute_map = {
        "creation_data": {"key": "creationData", "type": "SnapshotCreationData"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "source_volume_size_gi_b": {"key": "sourceVolumeSizeGiB", "type": "int"},
        "volume_name": {"key": "volumeName", "type": "str"},
    }

    def __init__(self, *, creation_data: "_models.SnapshotCreationData", **kwargs: Any) -> None:
        """
        :keyword creation_data: Data used when creating a volume snapshot. Required.
        :paramtype creation_data: ~azure.mgmt.elasticsan.models.SnapshotCreationData
        """
        super().__init__(**kwargs)
        self.creation_data = creation_data
        self.provisioning_state = None
        self.source_volume_size_gi_b = None
        self.volume_name = None


class SourceCreationData(_serialization.Model):
    """Data source used when creating the volume.

    :ivar create_source: This enumerates the possible sources of a volume creation. Known values
     are: "None", "VolumeSnapshot", "DiskSnapshot", "Disk", and "DiskRestorePoint".
    :vartype create_source: str or ~azure.mgmt.elasticsan.models.VolumeCreateOption
    :ivar source_id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype source_id: str
    """

    _attribute_map = {
        "create_source": {"key": "createSource", "type": "str"},
        "source_id": {"key": "sourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        create_source: Optional[Union[str, "_models.VolumeCreateOption"]] = None,
        source_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword create_source: This enumerates the possible sources of a volume creation. Known values
         are: "None", "VolumeSnapshot", "DiskSnapshot", "Disk", and "DiskRestorePoint".
        :paramtype create_source: str or ~azure.mgmt.elasticsan.models.VolumeCreateOption
        :keyword source_id: Fully qualified resource ID for the resource. E.g.
         "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
        :paramtype source_id: str
        """
        super().__init__(**kwargs)
        self.create_source = create_source
        self.source_id = source_id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.elasticsan.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """UserAssignedIdentity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VirtualNetworkRule(_serialization.Model):
    """Virtual Network rule.

    All required parameters must be populated in order to send to server.

    :ivar virtual_network_resource_id: Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.  # pylint: disable=line-too-long
     Required.
    :vartype virtual_network_resource_id: str
    :ivar action: The action of virtual network rule. "Allow"
    :vartype action: str or ~azure.mgmt.elasticsan.models.Action
    """

    _validation = {
        "virtual_network_resource_id": {"required": True},
    }

    _attribute_map = {
        "virtual_network_resource_id": {"key": "id", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self, *, virtual_network_resource_id: str, action: Union[str, "_models.Action"] = "Allow", **kwargs: Any
    ) -> None:
        """
        :keyword virtual_network_resource_id: Resource ID of a subnet, for example:
         /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.  # pylint: disable=line-too-long
         Required.
        :paramtype virtual_network_resource_id: str
        :keyword action: The action of virtual network rule. "Allow"
        :paramtype action: str or ~azure.mgmt.elasticsan.models.Action
        """
        super().__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id
        self.action = action


class Volume(ProxyResource):
    """Response for Volume request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar properties: Properties of Volume. Required.
    :vartype properties: ~azure.mgmt.elasticsan.models.VolumeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "VolumeProperties"},
    }

    def __init__(self, *, properties: "_models.VolumeProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of Volume. Required.
        :paramtype properties: ~azure.mgmt.elasticsan.models.VolumeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class VolumeGroup(ProxyResource):
    """Response for Volume Group request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.elasticsan.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.elasticsan.models.Identity
    :ivar properties: Properties of VolumeGroup.
    :vartype properties: ~azure.mgmt.elasticsan.models.VolumeGroupProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "Identity"},
        "properties": {"key": "properties", "type": "VolumeGroupProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.Identity"] = None,
        properties: Optional["_models.VolumeGroupProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.elasticsan.models.Identity
        :keyword properties: Properties of VolumeGroup.
        :paramtype properties: ~azure.mgmt.elasticsan.models.VolumeGroupProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.properties = properties


class VolumeGroupList(_serialization.Model):
    """List of Volume Groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of Volume Groups objects.
    :vartype value: list[~azure.mgmt.elasticsan.models.VolumeGroup]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VolumeGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VolumeGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of Volume Groups objects.
        :paramtype value: list[~azure.mgmt.elasticsan.models.VolumeGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VolumeGroupProperties(_serialization.Model):
    """VolumeGroup response properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    :ivar protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
    :vartype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
    :ivar encryption: Type of encryption. Known values are: "EncryptionAtRestWithPlatformKey" and
     "EncryptionAtRestWithCustomerManagedKey".
    :vartype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
    :ivar encryption_properties: Encryption Properties describing Key Vault and Identity
     information.
    :vartype encryption_properties: ~azure.mgmt.elasticsan.models.EncryptionProperties
    :ivar network_acls: A collection of rules governing the accessibility from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
    :ivar private_endpoint_connections: The list of Private Endpoint Connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.elasticsan.models.PrivateEndpointConnection]
    :ivar enforce_data_integrity_check_for_iscsi: A boolean indicating whether or not Data
     Integrity Check is enabled.
    :vartype enforce_data_integrity_check_for_iscsi: bool
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "protocol_type": {"key": "protocolType", "type": "str"},
        "encryption": {"key": "encryption", "type": "str"},
        "encryption_properties": {"key": "encryptionProperties", "type": "EncryptionProperties"},
        "network_acls": {"key": "networkAcls", "type": "NetworkRuleSet"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
        "enforce_data_integrity_check_for_iscsi": {"key": "enforceDataIntegrityCheckForIscsi", "type": "bool"},
    }

    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.StorageTargetType"]] = None,
        encryption: Optional[Union[str, "_models.EncryptionType"]] = None,
        encryption_properties: Optional["_models.EncryptionProperties"] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        enforce_data_integrity_check_for_iscsi: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
        :paramtype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
        :keyword encryption: Type of encryption. Known values are: "EncryptionAtRestWithPlatformKey"
         and "EncryptionAtRestWithCustomerManagedKey".
        :paramtype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
        :keyword encryption_properties: Encryption Properties describing Key Vault and Identity
         information.
        :paramtype encryption_properties: ~azure.mgmt.elasticsan.models.EncryptionProperties
        :keyword network_acls: A collection of rules governing the accessibility from specific network
         locations.
        :paramtype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
        :keyword enforce_data_integrity_check_for_iscsi: A boolean indicating whether or not Data
         Integrity Check is enabled.
        :paramtype enforce_data_integrity_check_for_iscsi: bool
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.protocol_type = protocol_type
        self.encryption = encryption
        self.encryption_properties = encryption_properties
        self.network_acls = network_acls
        self.private_endpoint_connections = None
        self.enforce_data_integrity_check_for_iscsi = enforce_data_integrity_check_for_iscsi


class VolumeGroupUpdate(_serialization.Model):
    """Volume Group request.

    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.elasticsan.models.Identity
    :ivar properties: Properties of VolumeGroup.
    :vartype properties: ~azure.mgmt.elasticsan.models.VolumeGroupUpdateProperties
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "Identity"},
        "properties": {"key": "properties", "type": "VolumeGroupUpdateProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.Identity"] = None,
        properties: Optional["_models.VolumeGroupUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.elasticsan.models.Identity
        :keyword properties: Properties of VolumeGroup.
        :paramtype properties: ~azure.mgmt.elasticsan.models.VolumeGroupUpdateProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.properties = properties


class VolumeGroupUpdateProperties(_serialization.Model):
    """VolumeGroup response properties.

    :ivar protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
    :vartype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
    :ivar encryption: Type of encryption. Known values are: "EncryptionAtRestWithPlatformKey" and
     "EncryptionAtRestWithCustomerManagedKey".
    :vartype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
    :ivar encryption_properties: Encryption Properties describing Key Vault and Identity
     information.
    :vartype encryption_properties: ~azure.mgmt.elasticsan.models.EncryptionProperties
    :ivar network_acls: A collection of rules governing the accessibility from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
    :ivar enforce_data_integrity_check_for_iscsi: A boolean indicating whether or not Data
     Integrity Check is enabled.
    :vartype enforce_data_integrity_check_for_iscsi: bool
    """

    _attribute_map = {
        "protocol_type": {"key": "protocolType", "type": "str"},
        "encryption": {"key": "encryption", "type": "str"},
        "encryption_properties": {"key": "encryptionProperties", "type": "EncryptionProperties"},
        "network_acls": {"key": "networkAcls", "type": "NetworkRuleSet"},
        "enforce_data_integrity_check_for_iscsi": {"key": "enforceDataIntegrityCheckForIscsi", "type": "bool"},
    }

    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.StorageTargetType"]] = None,
        encryption: Optional[Union[str, "_models.EncryptionType"]] = None,
        encryption_properties: Optional["_models.EncryptionProperties"] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        enforce_data_integrity_check_for_iscsi: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol_type: Type of storage target. Known values are: "Iscsi" and "None".
        :paramtype protocol_type: str or ~azure.mgmt.elasticsan.models.StorageTargetType
        :keyword encryption: Type of encryption. Known values are: "EncryptionAtRestWithPlatformKey"
         and "EncryptionAtRestWithCustomerManagedKey".
        :paramtype encryption: str or ~azure.mgmt.elasticsan.models.EncryptionType
        :keyword encryption_properties: Encryption Properties describing Key Vault and Identity
         information.
        :paramtype encryption_properties: ~azure.mgmt.elasticsan.models.EncryptionProperties
        :keyword network_acls: A collection of rules governing the accessibility from specific network
         locations.
        :paramtype network_acls: ~azure.mgmt.elasticsan.models.NetworkRuleSet
        :keyword enforce_data_integrity_check_for_iscsi: A boolean indicating whether or not Data
         Integrity Check is enabled.
        :paramtype enforce_data_integrity_check_for_iscsi: bool
        """
        super().__init__(**kwargs)
        self.protocol_type = protocol_type
        self.encryption = encryption
        self.encryption_properties = encryption_properties
        self.network_acls = network_acls
        self.enforce_data_integrity_check_for_iscsi = enforce_data_integrity_check_for_iscsi


class VolumeList(_serialization.Model):
    """List of Volumes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of Volume objects.
    :vartype value: list[~azure.mgmt.elasticsan.models.Volume]
    :ivar next_link: URI to fetch the next section of the paginated response.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Volume]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Volume"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of Volume objects.
        :paramtype value: list[~azure.mgmt.elasticsan.models.Volume]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VolumeProperties(_serialization.Model):
    """Volume response properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar volume_id: Unique Id of the volume in GUID format.
    :vartype volume_id: str
    :ivar creation_data: State of the operation on the resource.
    :vartype creation_data: ~azure.mgmt.elasticsan.models.SourceCreationData
    :ivar size_gi_b: Volume size. Required.
    :vartype size_gi_b: int
    :ivar storage_target: Storage target information.
    :vartype storage_target: ~azure.mgmt.elasticsan.models.IscsiTargetInfo
    :ivar managed_by: Parent resource information.
    :vartype managed_by: ~azure.mgmt.elasticsan.models.ManagedByInfo
    :ivar provisioning_state: State of the operation on the resource. Known values are: "Invalid",
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.elasticsan.models.ProvisioningStates
    """

    _validation = {
        "volume_id": {"readonly": True},
        "size_gi_b": {"required": True},
        "storage_target": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "volume_id": {"key": "volumeId", "type": "str"},
        "creation_data": {"key": "creationData", "type": "SourceCreationData"},
        "size_gi_b": {"key": "sizeGiB", "type": "int"},
        "storage_target": {"key": "storageTarget", "type": "IscsiTargetInfo"},
        "managed_by": {"key": "managedBy", "type": "ManagedByInfo"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        size_gi_b: int,
        creation_data: Optional["_models.SourceCreationData"] = None,
        managed_by: Optional["_models.ManagedByInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword creation_data: State of the operation on the resource.
        :paramtype creation_data: ~azure.mgmt.elasticsan.models.SourceCreationData
        :keyword size_gi_b: Volume size. Required.
        :paramtype size_gi_b: int
        :keyword managed_by: Parent resource information.
        :paramtype managed_by: ~azure.mgmt.elasticsan.models.ManagedByInfo
        """
        super().__init__(**kwargs)
        self.volume_id = None
        self.creation_data = creation_data
        self.size_gi_b = size_gi_b
        self.storage_target = None
        self.managed_by = managed_by
        self.provisioning_state = None


class VolumeUpdate(_serialization.Model):
    """Response for Volume request.

    :ivar properties: Properties of Volume.
    :vartype properties: ~azure.mgmt.elasticsan.models.VolumeUpdateProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "VolumeUpdateProperties"},
    }

    def __init__(self, *, properties: Optional["_models.VolumeUpdateProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of Volume.
        :paramtype properties: ~azure.mgmt.elasticsan.models.VolumeUpdateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class VolumeUpdateProperties(_serialization.Model):
    """Volume response properties.

    :ivar size_gi_b: Volume size.
    :vartype size_gi_b: int
    :ivar managed_by: Parent resource information.
    :vartype managed_by: ~azure.mgmt.elasticsan.models.ManagedByInfo
    """

    _attribute_map = {
        "size_gi_b": {"key": "sizeGiB", "type": "int"},
        "managed_by": {"key": "managedBy", "type": "ManagedByInfo"},
    }

    def __init__(
        self, *, size_gi_b: Optional[int] = None, managed_by: Optional["_models.ManagedByInfo"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword size_gi_b: Volume size.
        :paramtype size_gi_b: int
        :keyword managed_by: Parent resource information.
        :paramtype managed_by: ~azure.mgmt.elasticsan.models.ManagedByInfo
        """
        super().__init__(**kwargs)
        self.size_gi_b = size_gi_b
        self.managed_by = managed_by
