# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datafactory.aio import DataFactoryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataFactoryManagementTriggersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataFactoryManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_factory(self, resource_group):
        response = self.client.triggers.list_by_factory(
            resource_group_name=resource_group.name,
            factory_name="str",
            api_version="2018-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_query_by_factory(self, resource_group):
        response = await self.client.triggers.query_by_factory(
            resource_group_name=resource_group.name,
            factory_name="str",
            filter_parameters={"continuationToken": "str", "parentTriggerName": "str"},
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_create_or_update(self, resource_group):
        response = await self.client.triggers.create_or_update(
            resource_group_name=resource_group.name,
            factory_name="str",
            trigger_name="str",
            trigger={"properties": "trigger", "etag": "str", "id": "str", "name": "str", "type": "str"},
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.triggers.get(
            resource_group_name=resource_group.name,
            factory_name="str",
            trigger_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete(self, resource_group):
        response = await self.client.triggers.delete(
            resource_group_name=resource_group.name,
            factory_name="str",
            trigger_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_subscribe_to_events(self, resource_group):
        response = await (
            await self.client.triggers.begin_subscribe_to_events(
                resource_group_name=resource_group.name,
                factory_name="str",
                trigger_name="str",
                api_version="2018-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_event_subscription_status(self, resource_group):
        response = await self.client.triggers.get_event_subscription_status(
            resource_group_name=resource_group.name,
            factory_name="str",
            trigger_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_unsubscribe_from_events(self, resource_group):
        response = await (
            await self.client.triggers.begin_unsubscribe_from_events(
                resource_group_name=resource_group.name,
                factory_name="str",
                trigger_name="str",
                api_version="2018-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_start(self, resource_group):
        response = await (
            await self.client.triggers.begin_start(
                resource_group_name=resource_group.name,
                factory_name="str",
                trigger_name="str",
                api_version="2018-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_stop(self, resource_group):
        response = await (
            await self.client.triggers.begin_stop(
                resource_group_name=resource_group.name,
                factory_name="str",
                trigger_name="str",
                api_version="2018-06-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
