# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datafactory import DataFactoryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataFactoryManagementDataFlowDebugSessionOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataFactoryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create(self, resource_group):
        response = self.client.data_flow_debug_session.begin_create(
            resource_group_name=resource_group.name,
            factory_name="str",
            request={
                "computeType": "str",
                "coreCount": 0,
                "integrationRuntime": {"properties": "integration_runtime", "name": "str"},
                "timeToLive": 0,
            },
            api_version="2018-06-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_query_by_factory(self, resource_group):
        response = self.client.data_flow_debug_session.query_by_factory(
            resource_group_name=resource_group.name,
            factory_name="str",
            api_version="2018-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_add_data_flow(self, resource_group):
        response = self.client.data_flow_debug_session.add_data_flow(
            resource_group_name=resource_group.name,
            factory_name="str",
            request={
                "dataFlow": {"properties": "data_flow", "name": "str"},
                "dataFlows": [{"properties": "data_flow", "name": "str"}],
                "datasets": [{"properties": "dataset", "name": "str"}],
                "debugSettings": {
                    "datasetParameters": {},
                    "parameters": {"str": {}},
                    "sourceSettings": [{"rowLimit": 0, "sourceName": "str"}],
                },
                "linkedServices": [{"properties": "linked_service", "name": "str"}],
                "sessionId": "str",
                "staging": {
                    "folderPath": {},
                    "linkedService": {"referenceName": "str", "type": "str", "parameters": {"str": {}}},
                },
            },
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.data_flow_debug_session.delete(
            resource_group_name=resource_group.name,
            factory_name="str",
            request={"sessionId": "str"},
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_execute_command(self, resource_group):
        response = self.client.data_flow_debug_session.begin_execute_command(
            resource_group_name=resource_group.name,
            factory_name="str",
            request={
                "command": "str",
                "commandPayload": {"streamName": "str", "columns": ["str"], "expression": "str", "rowLimits": 0},
                "sessionId": "str",
            },
            api_version="2018-06-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
