# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cosmosdb.aio import CosmosDBManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCosmosDBManagementSqlResourcesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CosmosDBManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_sql_databases(self, resource_group):
        response = self.client.sql_resources.list_sql_databases(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_database(self, resource_group):
        response = await self.client.sql_resources.get_sql_database(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_sql_database(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_create_update_sql_database(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                create_update_sql_database_parameters={
                    "resource": {
                        "id": "str",
                        "createMode": "Default",
                        "restoreParameters": {
                            "restoreSource": "str",
                            "restoreTimestampInUtc": "2020-02-20 00:00:00",
                            "restoreWithTtlDisabled": bool,
                        },
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_sql_database(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_delete_sql_database(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_database_throughput(self, resource_group):
        response = await self.client.sql_resources.get_sql_database_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update_sql_database_throughput(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_update_sql_database_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                update_throughput_parameters={
                    "resource": {
                        "autoscaleSettings": {
                            "maxThroughput": 0,
                            "autoUpgradePolicy": {"throughputPolicy": {"incrementPercent": 0, "isEnabled": bool}},
                            "targetMaxThroughput": 0,
                        },
                        "instantMaximumThroughput": "str",
                        "minimumThroughput": "str",
                        "offerReplacePending": "str",
                        "softAllowedMaximumThroughput": "str",
                        "throughput": 0,
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_sql_database_to_autoscale(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_migrate_sql_database_to_autoscale(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_sql_database_to_manual_throughput(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_migrate_sql_database_to_manual_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_client_encryption_keys(self, resource_group):
        response = self.client.sql_resources.list_client_encryption_keys(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_client_encryption_key(self, resource_group):
        response = await self.client.sql_resources.get_client_encryption_key(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            client_encryption_key_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_client_encryption_key(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_create_update_client_encryption_key(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                client_encryption_key_name="str",
                create_update_client_encryption_key_parameters={
                    "resource": {
                        "encryptionAlgorithm": "str",
                        "id": "str",
                        "keyWrapMetadata": {"algorithm": "str", "name": "str", "type": "str", "value": "str"},
                        "wrappedDataEncryptionKey": bytes("bytes", encoding="utf-8"),
                    }
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_sql_containers(self, resource_group):
        response = self.client.sql_resources.list_sql_containers(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_container(self, resource_group):
        response = await self.client.sql_resources.get_sql_container(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            container_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_sql_container(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_create_update_sql_container(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                create_update_sql_container_parameters={
                    "resource": {
                        "id": "str",
                        "analyticalStorageTtl": 0,
                        "clientEncryptionPolicy": {
                            "includedPaths": [
                                {
                                    "clientEncryptionKeyId": "str",
                                    "encryptionAlgorithm": "str",
                                    "encryptionType": "str",
                                    "path": "str",
                                }
                            ],
                            "policyFormatVersion": 0,
                        },
                        "computedProperties": [{"name": "str", "query": "str"}],
                        "conflictResolutionPolicy": {
                            "conflictResolutionPath": "str",
                            "conflictResolutionProcedure": "str",
                            "mode": "LastWriterWins",
                        },
                        "createMode": "Default",
                        "defaultTtl": 0,
                        "indexingPolicy": {
                            "automatic": bool,
                            "compositeIndexes": [[{"order": "str", "path": "str"}]],
                            "excludedPaths": [{"path": "str"}],
                            "includedPaths": [
                                {"indexes": [{"dataType": "String", "kind": "Hash", "precision": 0}], "path": "str"}
                            ],
                            "indexingMode": "consistent",
                            "spatialIndexes": [{"path": "str", "types": ["str"]}],
                        },
                        "materializedViewDefinition": {
                            "definition": "str",
                            "sourceCollectionId": "str",
                            "sourceCollectionRid": "str",
                        },
                        "partitionKey": {"kind": "Hash", "paths": ["str"], "systemKey": bool, "version": 0},
                        "restoreParameters": {
                            "restoreSource": "str",
                            "restoreTimestampInUtc": "2020-02-20 00:00:00",
                            "restoreWithTtlDisabled": bool,
                        },
                        "uniqueKeyPolicy": {"uniqueKeys": [{"paths": ["str"]}]},
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_sql_container(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_delete_sql_container(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_sql_database_partition_merge(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_sql_database_partition_merge(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                merge_parameters={"isDryRun": bool},
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_list_sql_container_partition_merge(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_list_sql_container_partition_merge(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                merge_parameters={"isDryRun": bool},
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_container_throughput(self, resource_group):
        response = await self.client.sql_resources.get_sql_container_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            container_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update_sql_container_throughput(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_update_sql_container_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                update_throughput_parameters={
                    "resource": {
                        "autoscaleSettings": {
                            "maxThroughput": 0,
                            "autoUpgradePolicy": {"throughputPolicy": {"incrementPercent": 0, "isEnabled": bool}},
                            "targetMaxThroughput": 0,
                        },
                        "instantMaximumThroughput": "str",
                        "minimumThroughput": "str",
                        "offerReplacePending": "str",
                        "softAllowedMaximumThroughput": "str",
                        "throughput": 0,
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_sql_container_to_autoscale(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_migrate_sql_container_to_autoscale(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_sql_container_to_manual_throughput(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_migrate_sql_container_to_manual_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_sql_database_retrieve_throughput_distribution(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_sql_database_retrieve_throughput_distribution(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                retrieve_throughput_parameters={
                    "resource": {"physicalPartitionIds": [{"id": "str"}]},
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_sql_database_redistribute_throughput(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_sql_database_redistribute_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                redistribute_throughput_parameters={
                    "resource": {
                        "sourcePhysicalPartitionThroughputInfo": [{"id": "str", "throughput": 0.0}],
                        "targetPhysicalPartitionThroughputInfo": [{"id": "str", "throughput": 0.0}],
                        "throughputPolicy": "str",
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_sql_container_retrieve_throughput_distribution(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_sql_container_retrieve_throughput_distribution(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                retrieve_throughput_parameters={
                    "resource": {"physicalPartitionIds": [{"id": "str"}]},
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_sql_container_redistribute_throughput(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_sql_container_redistribute_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                redistribute_throughput_parameters={
                    "resource": {
                        "sourcePhysicalPartitionThroughputInfo": [{"id": "str", "throughput": 0.0}],
                        "targetPhysicalPartitionThroughputInfo": [{"id": "str", "throughput": 0.0}],
                        "throughputPolicy": "str",
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_sql_stored_procedures(self, resource_group):
        response = self.client.sql_resources.list_sql_stored_procedures(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            container_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_stored_procedure(self, resource_group):
        response = await self.client.sql_resources.get_sql_stored_procedure(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            container_name="str",
            stored_procedure_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_sql_stored_procedure(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_create_update_sql_stored_procedure(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                stored_procedure_name="str",
                create_update_sql_stored_procedure_parameters={
                    "resource": {"id": "str", "body": "str"},
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_sql_stored_procedure(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_delete_sql_stored_procedure(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                stored_procedure_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_sql_user_defined_functions(self, resource_group):
        response = self.client.sql_resources.list_sql_user_defined_functions(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            container_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_user_defined_function(self, resource_group):
        response = await self.client.sql_resources.get_sql_user_defined_function(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            container_name="str",
            user_defined_function_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_sql_user_defined_function(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_create_update_sql_user_defined_function(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                user_defined_function_name="str",
                create_update_sql_user_defined_function_parameters={
                    "resource": {"id": "str", "body": "str"},
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_sql_user_defined_function(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_delete_sql_user_defined_function(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                user_defined_function_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_sql_triggers(self, resource_group):
        response = self.client.sql_resources.list_sql_triggers(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            container_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_trigger(self, resource_group):
        response = await self.client.sql_resources.get_sql_trigger(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            container_name="str",
            trigger_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_sql_trigger(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_create_update_sql_trigger(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                trigger_name="str",
                create_update_sql_trigger_parameters={
                    "resource": {"id": "str", "body": "str", "triggerOperation": "str", "triggerType": "str"},
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_sql_trigger(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_delete_sql_trigger(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                trigger_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_role_definition(self, resource_group):
        response = await self.client.sql_resources.get_sql_role_definition(
            role_definition_id="str",
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_sql_role_definition(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_create_update_sql_role_definition(
                role_definition_id="str",
                resource_group_name=resource_group.name,
                account_name="str",
                create_update_sql_role_definition_parameters={
                    "assignableScopes": ["str"],
                    "permissions": [{"dataActions": ["str"], "notDataActions": ["str"]}],
                    "roleName": "str",
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_sql_role_definition(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_delete_sql_role_definition(
                role_definition_id="str",
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_sql_role_definitions(self, resource_group):
        response = self.client.sql_resources.list_sql_role_definitions(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_sql_role_assignment(self, resource_group):
        response = await self.client.sql_resources.get_sql_role_assignment(
            role_assignment_id="str",
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_sql_role_assignment(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_create_update_sql_role_assignment(
                role_assignment_id="str",
                resource_group_name=resource_group.name,
                account_name="str",
                create_update_sql_role_assignment_parameters={
                    "principalId": "str",
                    "roleDefinitionId": "str",
                    "scope": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_sql_role_assignment(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_delete_sql_role_assignment(
                role_assignment_id="str",
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_sql_role_assignments(self, resource_group):
        response = self.client.sql_resources.list_sql_role_assignments(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_retrieve_continuous_backup_information(self, resource_group):
        response = await (
            await self.client.sql_resources.begin_retrieve_continuous_backup_information(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                container_name="str",
                location={"location": "str"},
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
