# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cosmosdb.aio import CosmosDBManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCosmosDBManagementMongoDBResourcesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CosmosDBManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_mongo_db_databases(self, resource_group):
        response = self.client.mongo_db_resources.list_mongo_db_databases(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_mongo_db_database(self, resource_group):
        response = await self.client.mongo_db_resources.get_mongo_db_database(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_mongo_db_database(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_create_update_mongo_db_database(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                create_update_mongo_db_database_parameters={
                    "resource": {
                        "id": "str",
                        "createMode": "Default",
                        "restoreParameters": {
                            "restoreSource": "str",
                            "restoreTimestampInUtc": "2020-02-20 00:00:00",
                            "restoreWithTtlDisabled": bool,
                        },
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_mongo_db_database(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_delete_mongo_db_database(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_mongo_db_database_throughput(self, resource_group):
        response = await self.client.mongo_db_resources.get_mongo_db_database_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update_mongo_db_database_throughput(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_update_mongo_db_database_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                update_throughput_parameters={
                    "resource": {
                        "autoscaleSettings": {
                            "maxThroughput": 0,
                            "autoUpgradePolicy": {"throughputPolicy": {"incrementPercent": 0, "isEnabled": bool}},
                            "targetMaxThroughput": 0,
                        },
                        "instantMaximumThroughput": "str",
                        "minimumThroughput": "str",
                        "offerReplacePending": "str",
                        "softAllowedMaximumThroughput": "str",
                        "throughput": 0,
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_mongo_db_database_to_autoscale(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_migrate_mongo_db_database_to_autoscale(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_mongo_db_database_to_manual_throughput(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_migrate_mongo_db_database_to_manual_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_mongo_db_database_retrieve_throughput_distribution(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_mongo_db_database_retrieve_throughput_distribution(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                retrieve_throughput_parameters={
                    "resource": {"physicalPartitionIds": [{"id": "str"}]},
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_mongo_db_database_redistribute_throughput(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_mongo_db_database_redistribute_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                redistribute_throughput_parameters={
                    "resource": {
                        "sourcePhysicalPartitionThroughputInfo": [{"id": "str", "throughput": 0.0}],
                        "targetPhysicalPartitionThroughputInfo": [{"id": "str", "throughput": 0.0}],
                        "throughputPolicy": "str",
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_mongo_db_container_retrieve_throughput_distribution(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_mongo_db_container_retrieve_throughput_distribution(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                retrieve_throughput_parameters={
                    "resource": {"physicalPartitionIds": [{"id": "str"}]},
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_mongo_db_container_redistribute_throughput(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_mongo_db_container_redistribute_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                redistribute_throughput_parameters={
                    "resource": {
                        "sourcePhysicalPartitionThroughputInfo": [{"id": "str", "throughput": 0.0}],
                        "targetPhysicalPartitionThroughputInfo": [{"id": "str", "throughput": 0.0}],
                        "throughputPolicy": "str",
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_mongo_db_collections(self, resource_group):
        response = self.client.mongo_db_resources.list_mongo_db_collections(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_mongo_db_collection(self, resource_group):
        response = await self.client.mongo_db_resources.get_mongo_db_collection(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            collection_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_mongo_db_collection(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_create_update_mongo_db_collection(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                create_update_mongo_db_collection_parameters={
                    "resource": {
                        "id": "str",
                        "analyticalStorageTtl": 0,
                        "createMode": "Default",
                        "indexes": [{"key": {"keys": ["str"]}, "options": {"expireAfterSeconds": 0, "unique": bool}}],
                        "restoreParameters": {
                            "restoreSource": "str",
                            "restoreTimestampInUtc": "2020-02-20 00:00:00",
                            "restoreWithTtlDisabled": bool,
                        },
                        "shardKey": {"str": "str"},
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_mongo_db_collection(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_delete_mongo_db_collection(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_mongo_db_database_partition_merge(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_mongo_db_database_partition_merge(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                merge_parameters={"isDryRun": bool},
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_list_mongo_db_collection_partition_merge(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_list_mongo_db_collection_partition_merge(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                merge_parameters={"isDryRun": bool},
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_mongo_db_collection_throughput(self, resource_group):
        response = await self.client.mongo_db_resources.get_mongo_db_collection_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            collection_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update_mongo_db_collection_throughput(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_update_mongo_db_collection_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                update_throughput_parameters={
                    "resource": {
                        "autoscaleSettings": {
                            "maxThroughput": 0,
                            "autoUpgradePolicy": {"throughputPolicy": {"incrementPercent": 0, "isEnabled": bool}},
                            "targetMaxThroughput": 0,
                        },
                        "instantMaximumThroughput": "str",
                        "minimumThroughput": "str",
                        "offerReplacePending": "str",
                        "softAllowedMaximumThroughput": "str",
                        "throughput": 0,
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_mongo_db_collection_to_autoscale(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_migrate_mongo_db_collection_to_autoscale(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_mongo_db_collection_to_manual_throughput(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_migrate_mongo_db_collection_to_manual_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_mongo_role_definition(self, resource_group):
        response = await self.client.mongo_db_resources.get_mongo_role_definition(
            mongo_role_definition_id="str",
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_mongo_role_definition(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_create_update_mongo_role_definition(
                mongo_role_definition_id="str",
                resource_group_name=resource_group.name,
                account_name="str",
                create_update_mongo_role_definition_parameters={
                    "databaseName": "str",
                    "privileges": [{"actions": ["str"], "resource": {"collection": "str", "db": "str"}}],
                    "roleName": "str",
                    "roles": [{"db": "str", "role": "str"}],
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_mongo_role_definition(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_delete_mongo_role_definition(
                mongo_role_definition_id="str",
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_mongo_role_definitions(self, resource_group):
        response = self.client.mongo_db_resources.list_mongo_role_definitions(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_mongo_user_definition(self, resource_group):
        response = await self.client.mongo_db_resources.get_mongo_user_definition(
            mongo_user_definition_id="str",
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_mongo_user_definition(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_create_update_mongo_user_definition(
                mongo_user_definition_id="str",
                resource_group_name=resource_group.name,
                account_name="str",
                create_update_mongo_user_definition_parameters={
                    "customData": "str",
                    "databaseName": "str",
                    "mechanisms": "str",
                    "password": "str",
                    "roles": [{"db": "str", "role": "str"}],
                    "userName": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_mongo_user_definition(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_delete_mongo_user_definition(
                mongo_user_definition_id="str",
                resource_group_name=resource_group.name,
                account_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_mongo_user_definitions(self, resource_group):
        response = self.client.mongo_db_resources.list_mongo_user_definitions(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_retrieve_continuous_backup_information(self, resource_group):
        response = await (
            await self.client.mongo_db_resources.begin_retrieve_continuous_backup_information(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                collection_name="str",
                location={"location": "str"},
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
