# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cosmosdb.aio import CosmosDBManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCosmosDBManagementGremlinResourcesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CosmosDBManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_gremlin_databases(self, resource_group):
        response = self.client.gremlin_resources.list_gremlin_databases(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_gremlin_database(self, resource_group):
        response = await self.client.gremlin_resources.get_gremlin_database(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_gremlin_database(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_create_update_gremlin_database(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                create_update_gremlin_database_parameters={
                    "resource": {
                        "id": "str",
                        "createMode": "Default",
                        "restoreParameters": {
                            "restoreSource": "str",
                            "restoreTimestampInUtc": "2020-02-20 00:00:00",
                            "restoreWithTtlDisabled": bool,
                        },
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_gremlin_database(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_delete_gremlin_database(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_gremlin_database_throughput(self, resource_group):
        response = await self.client.gremlin_resources.get_gremlin_database_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update_gremlin_database_throughput(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_update_gremlin_database_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                update_throughput_parameters={
                    "resource": {
                        "autoscaleSettings": {
                            "maxThroughput": 0,
                            "autoUpgradePolicy": {"throughputPolicy": {"incrementPercent": 0, "isEnabled": bool}},
                            "targetMaxThroughput": 0,
                        },
                        "instantMaximumThroughput": "str",
                        "minimumThroughput": "str",
                        "offerReplacePending": "str",
                        "softAllowedMaximumThroughput": "str",
                        "throughput": 0,
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_gremlin_database_to_autoscale(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_migrate_gremlin_database_to_autoscale(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_gremlin_database_to_manual_throughput(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_migrate_gremlin_database_to_manual_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_gremlin_graphs(self, resource_group):
        response = self.client.gremlin_resources.list_gremlin_graphs(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_gremlin_graph(self, resource_group):
        response = await self.client.gremlin_resources.get_gremlin_graph(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            graph_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_update_gremlin_graph(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_create_update_gremlin_graph(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                graph_name="str",
                create_update_gremlin_graph_parameters={
                    "resource": {
                        "id": "str",
                        "analyticalStorageTtl": 0,
                        "conflictResolutionPolicy": {
                            "conflictResolutionPath": "str",
                            "conflictResolutionProcedure": "str",
                            "mode": "LastWriterWins",
                        },
                        "createMode": "Default",
                        "defaultTtl": 0,
                        "indexingPolicy": {
                            "automatic": bool,
                            "compositeIndexes": [[{"order": "str", "path": "str"}]],
                            "excludedPaths": [{"path": "str"}],
                            "includedPaths": [
                                {"indexes": [{"dataType": "String", "kind": "Hash", "precision": 0}], "path": "str"}
                            ],
                            "indexingMode": "consistent",
                            "spatialIndexes": [{"path": "str", "types": ["str"]}],
                        },
                        "partitionKey": {"kind": "Hash", "paths": ["str"], "systemKey": bool, "version": 0},
                        "restoreParameters": {
                            "restoreSource": "str",
                            "restoreTimestampInUtc": "2020-02-20 00:00:00",
                            "restoreWithTtlDisabled": bool,
                        },
                        "uniqueKeyPolicy": {"uniqueKeys": [{"paths": ["str"]}]},
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_gremlin_graph(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_delete_gremlin_graph(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                graph_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_gremlin_graph_throughput(self, resource_group):
        response = await self.client.gremlin_resources.get_gremlin_graph_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            database_name="str",
            graph_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update_gremlin_graph_throughput(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_update_gremlin_graph_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                graph_name="str",
                update_throughput_parameters={
                    "resource": {
                        "autoscaleSettings": {
                            "maxThroughput": 0,
                            "autoUpgradePolicy": {"throughputPolicy": {"incrementPercent": 0, "isEnabled": bool}},
                            "targetMaxThroughput": 0,
                        },
                        "instantMaximumThroughput": "str",
                        "minimumThroughput": "str",
                        "offerReplacePending": "str",
                        "softAllowedMaximumThroughput": "str",
                        "throughput": 0,
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_gremlin_graph_to_autoscale(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_migrate_gremlin_graph_to_autoscale(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                graph_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_migrate_gremlin_graph_to_manual_throughput(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_migrate_gremlin_graph_to_manual_throughput(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                graph_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_retrieve_continuous_backup_information(self, resource_group):
        response = await (
            await self.client.gremlin_resources.begin_retrieve_continuous_backup_information(
                resource_group_name=resource_group.name,
                account_name="str",
                database_name="str",
                graph_name="str",
                location={"location": "str"},
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
