# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CancelOperationsRequest(_model_base.Model):
    """This is the request to cancel running operations in scheduled actions using the operation ids.

    All required parameters must be populated in order to send to server.

    :ivar operation_ids: The list of operation ids to cancel operations on. Required.
    :vartype operation_ids: list[str]
    :ivar correlationid: Correlationid item. Required.
    :vartype correlationid: str
    """

    operation_ids: List[str] = rest_field(name="operationIds")
    """The list of operation ids to cancel operations on. Required."""
    correlationid: str = rest_field()
    """Correlationid item. Required."""

    @overload
    def __init__(
        self,
        *,
        operation_ids: List[str],
        correlationid: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CancelOperationsResponse(_model_base.Model):
    """This is the response from a cancel operations request.


    :ivar results: An array of resource operations that were successfully cancelled. Required.
    :vartype results: list[~azure.mgmt.computeschedule.models.ResourceOperation]
    """

    results: List["_models.ResourceOperation"] = rest_field()
    """An array of resource operations that were successfully cancelled. Required."""

    @overload
    def __init__(
        self,
        *,
        results: List["_models.ResourceOperation"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DeallocateResourceOperationResponse(_model_base.Model):
    """The response from a deallocate request.


    :ivar description: The description of the operation response. Required.
    :vartype description: str
    :ivar type: The type of resources used in the deallocate request eg virtual machines. Required.
    :vartype type: str
    :ivar location: The location of the deallocate request eg westus. Required.
    :vartype location: str
    :ivar results: The results from the deallocate request if no errors exist.
    :vartype results: list[~azure.mgmt.computeschedule.models.ResourceOperation]
    """

    description: str = rest_field()
    """The description of the operation response. Required."""
    type: str = rest_field()
    """The type of resources used in the deallocate request eg virtual machines. Required."""
    location: str = rest_field(visibility=["read", "create"])
    """The location of the deallocate request eg westus. Required."""
    results: Optional[List["_models.ResourceOperation"]] = rest_field()
    """The results from the deallocate request if no errors exist."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        type: str,
        location: str,
        results: Optional[List["_models.ResourceOperation"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.computeschedule.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.computeschedule.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.computeschedule.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExecuteDeallocateRequest(_model_base.Model):
    """The ExecuteDeallocateRequest request for executeDeallocate operations.

    All required parameters must be populated in order to send to server.

    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computeschedule.models.ExecutionParameters
    :ivar resources: The resources for the request. Required.
    :vartype resources: ~azure.mgmt.computeschedule.models.Resources
    :ivar correlationid: Correlationid item. Required.
    :vartype correlationid: str
    """

    execution_parameters: "_models.ExecutionParameters" = rest_field(name="executionParameters")
    """The execution parameters for the request. Required."""
    resources: "_models.Resources" = rest_field()
    """The resources for the request. Required."""
    correlationid: str = rest_field()
    """Correlationid item. Required."""

    @overload
    def __init__(
        self,
        *,
        execution_parameters: "_models.ExecutionParameters",
        resources: "_models.Resources",
        correlationid: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExecuteHibernateRequest(_model_base.Model):
    """The ExecuteHibernateRequest request for executeHibernate operations.

    All required parameters must be populated in order to send to server.

    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computeschedule.models.ExecutionParameters
    :ivar resources: The resources for the request. Required.
    :vartype resources: ~azure.mgmt.computeschedule.models.Resources
    :ivar correlationid: Correlationid item. Required.
    :vartype correlationid: str
    """

    execution_parameters: "_models.ExecutionParameters" = rest_field(name="executionParameters")
    """The execution parameters for the request. Required."""
    resources: "_models.Resources" = rest_field()
    """The resources for the request. Required."""
    correlationid: str = rest_field()
    """Correlationid item. Required."""

    @overload
    def __init__(
        self,
        *,
        execution_parameters: "_models.ExecutionParameters",
        resources: "_models.Resources",
        correlationid: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExecuteStartRequest(_model_base.Model):
    """The ExecuteStartRequest request for executeStart operations.

    All required parameters must be populated in order to send to server.

    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computeschedule.models.ExecutionParameters
    :ivar resources: The resources for the request. Required.
    :vartype resources: ~azure.mgmt.computeschedule.models.Resources
    :ivar correlationid: Correlationid item. Required.
    :vartype correlationid: str
    """

    execution_parameters: "_models.ExecutionParameters" = rest_field(name="executionParameters")
    """The execution parameters for the request. Required."""
    resources: "_models.Resources" = rest_field()
    """The resources for the request. Required."""
    correlationid: str = rest_field()
    """Correlationid item. Required."""

    @overload
    def __init__(
        self,
        *,
        execution_parameters: "_models.ExecutionParameters",
        resources: "_models.Resources",
        correlationid: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExecutionParameters(_model_base.Model):
    """Extra details needed to run the user's request.

    :ivar optimization_preference: Details that could optimize the user's request. Known values
     are: "Cost", "Availability", and "CostAvailabilityBalanced".
    :vartype optimization_preference: str or
     ~azure.mgmt.computeschedule.models.OptimizationPreference
    :ivar retry_policy: Retry policy the user can pass.
    :vartype retry_policy: ~azure.mgmt.computeschedule.models.RetryPolicy
    """

    optimization_preference: Optional[Union[str, "_models.OptimizationPreference"]] = rest_field(
        name="optimizationPreference"
    )
    """Details that could optimize the user's request. Known values are: \"Cost\", \"Availability\",
     and \"CostAvailabilityBalanced\"."""
    retry_policy: Optional["_models.RetryPolicy"] = rest_field(name="retryPolicy")
    """Retry policy the user can pass."""

    @overload
    def __init__(
        self,
        *,
        optimization_preference: Optional[Union[str, "_models.OptimizationPreference"]] = None,
        retry_policy: Optional["_models.RetryPolicy"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GetOperationErrorsRequest(_model_base.Model):
    """This is the request to get errors per vm operations.

    All required parameters must be populated in order to send to server.

    :ivar operation_ids: The list of operation ids to query errors of. Required.
    :vartype operation_ids: list[str]
    """

    operation_ids: List[str] = rest_field(name="operationIds")
    """The list of operation ids to query errors of. Required."""

    @overload
    def __init__(
        self,
        *,
        operation_ids: List[str],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GetOperationErrorsResponse(_model_base.Model):
    """This is the response from a get operations errors request.


    :ivar results: An array of operationids and their corresponding errors if any. Required.
    :vartype results: list[~azure.mgmt.computeschedule.models.OperationErrorsResult]
    """

    results: List["_models.OperationErrorsResult"] = rest_field()
    """An array of operationids and their corresponding errors if any. Required."""

    @overload
    def __init__(
        self,
        *,
        results: List["_models.OperationErrorsResult"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GetOperationStatusRequest(_model_base.Model):
    """This is the request to get operation status using operationids.

    All required parameters must be populated in order to send to server.

    :ivar operation_ids: The list of operation ids to get the status of. Required.
    :vartype operation_ids: list[str]
    :ivar correlationid: Correlationid item. Required.
    :vartype correlationid: str
    """

    operation_ids: List[str] = rest_field(name="operationIds")
    """The list of operation ids to get the status of. Required."""
    correlationid: str = rest_field()
    """Correlationid item. Required."""

    @overload
    def __init__(
        self,
        *,
        operation_ids: List[str],
        correlationid: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class GetOperationStatusResponse(_model_base.Model):
    """This is the response from a get operations status request.


    :ivar results: An array of resource operations based on their operation ids. Required.
    :vartype results: list[~azure.mgmt.computeschedule.models.ResourceOperation]
    """

    results: List["_models.ResourceOperation"] = rest_field()
    """An array of resource operations based on their operation ids. Required."""

    @overload
    def __init__(
        self,
        *,
        results: List["_models.ResourceOperation"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class HibernateResourceOperationResponse(_model_base.Model):
    """The response from a Hibernate request.


    :ivar description: The description of the operation response. Required.
    :vartype description: str
    :ivar type: The type of resources used in the Hibernate request eg virtual machines. Required.
    :vartype type: str
    :ivar location: The location of the Hibernate request eg westus. Required.
    :vartype location: str
    :ivar results: The results from the Hibernate request if no errors exist.
    :vartype results: list[~azure.mgmt.computeschedule.models.ResourceOperation]
    """

    description: str = rest_field()
    """The description of the operation response. Required."""
    type: str = rest_field()
    """The type of resources used in the Hibernate request eg virtual machines. Required."""
    location: str = rest_field(visibility=["read", "create"])
    """The location of the Hibernate request eg westus. Required."""
    results: Optional[List["_models.ResourceOperation"]] = rest_field()
    """The results from the Hibernate request if no errors exist."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        type: str,
        location: str,
        results: Optional[List["_models.ResourceOperation"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.computeschedule.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.computeschedule.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.computeschedule.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OperationErrorDetails(_model_base.Model):
    """This defines a list of operation errors associated with a unique operationId.


    :ivar error_code: The error code of the operation. Required.
    :vartype error_code: str
    :ivar error_details: The error details of the operation. Required.
    :vartype error_details: ~datetime.datetime
    :ivar time_stamp: The timestamp of the error occurence. Required.
    :vartype time_stamp: ~datetime.datetime
    :ivar crp_operation_id: CRP operationid of the operation for deeper analysis. Required.
    :vartype crp_operation_id: str
    """

    error_code: str = rest_field(name="errorCode")
    """The error code of the operation. Required."""
    error_details: datetime.datetime = rest_field(name="errorDetails", format="rfc3339")
    """The error details of the operation. Required."""
    time_stamp: datetime.datetime = rest_field(name="timeStamp", format="rfc3339")
    """The timestamp of the error occurence. Required."""
    crp_operation_id: str = rest_field(name="crpOperationId")
    """CRP operationid of the operation for deeper analysis. Required."""

    @overload
    def __init__(
        self,
        *,
        error_code: str,
        error_details: datetime.datetime,
        time_stamp: datetime.datetime,
        crp_operation_id: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationErrorsResult(_model_base.Model):
    """This is the first level of operation errors from the request when clients get errors per vm
    operation.

    :ivar operation_id: The operationId identifying a vm operation.
    :vartype operation_id: str
    :ivar creation_time: The creation time of the error result.
    :vartype creation_time: ~datetime.datetime
    :ivar activation_time: The activation time of a vm operation.
    :vartype activation_time: ~datetime.datetime
    :ivar completed_at: The completion time of the operation if the operation was completed.
    :vartype completed_at: ~datetime.datetime
    :ivar operation_errors: A list of errors associated with the operationid.
    :vartype operation_errors: list[~azure.mgmt.computeschedule.models.OperationErrorDetails]
    :ivar request_error_code: Request level error code.
    :vartype request_error_code: str
    :ivar request_error_details: Request level error details.
    :vartype request_error_details: str
    """

    operation_id: Optional[str] = rest_field(name="operationId")
    """The operationId identifying a vm operation."""
    creation_time: Optional[datetime.datetime] = rest_field(name="creationTime", format="rfc3339")
    """The creation time of the error result."""
    activation_time: Optional[datetime.datetime] = rest_field(name="activationTime", format="rfc3339")
    """The activation time of a vm operation."""
    completed_at: Optional[datetime.datetime] = rest_field(name="completedAt", format="rfc3339")
    """The completion time of the operation if the operation was completed."""
    operation_errors: Optional[List["_models.OperationErrorDetails"]] = rest_field(name="operationErrors")
    """A list of errors associated with the operationid."""
    request_error_code: Optional[str] = rest_field(name="requestErrorCode")
    """Request level error code."""
    request_error_details: Optional[str] = rest_field(name="requestErrorDetails")
    """Request level error details."""

    @overload
    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        activation_time: Optional[datetime.datetime] = None,
        completed_at: Optional[datetime.datetime] = None,
        operation_errors: Optional[List["_models.OperationErrorDetails"]] = None,
        request_error_code: Optional[str] = None,
        request_error_details: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceOperation(_model_base.Model):
    """High level response from an operation on a resource.

    :ivar resource_id: Unique identifier for the resource involved in the operation, eg ArmId.
    :vartype resource_id: str
    :ivar error_code: Resource level error code if it exists.
    :vartype error_code: str
    :ivar error_details: Resource level error details if they exist.
    :vartype error_details: str
    :ivar operation: Details of the operation performed on a resource.
    :vartype operation: ~azure.mgmt.computeschedule.models.ResourceOperationDetails
    """

    resource_id: Optional[str] = rest_field(name="resourceId")
    """Unique identifier for the resource involved in the operation, eg ArmId."""
    error_code: Optional[str] = rest_field(name="errorCode")
    """Resource level error code if it exists."""
    error_details: Optional[str] = rest_field(name="errorDetails")
    """Resource level error details if they exist."""
    operation: Optional["_models.ResourceOperationDetails"] = rest_field()
    """Details of the operation performed on a resource."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        error_code: Optional[str] = None,
        error_details: Optional[str] = None,
        operation: Optional["_models.ResourceOperationDetails"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceOperationDetails(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The details of a response from an operation on a resource.


    :ivar operation_id: Operation identifier for the unique operation. Required.
    :vartype operation_id: str
    :ivar resource_id: Unique identifier for the resource involved in the operation, eg ArmId.
     Required.
    :vartype resource_id: str
    :ivar op_type: Type of operation performed on the resources. Required. Known values are:
     "Unknown", "Start", "Deallocate", and "Hibernate".
    :vartype op_type: str or ~azure.mgmt.computeschedule.models.ResourceOperationType
    :ivar subscription_id: Subscription id attached to the request. Required.
    :vartype subscription_id: str
    :ivar deadline: Deadline for the operation. Required.
    :vartype deadline: ~datetime.datetime
    :ivar deadline_type: Type of deadline of the operation. Required. Known values are: "Unknown",
     "InitiateAt", and "CompleteBy".
    :vartype deadline_type: str or ~azure.mgmt.computeschedule.models.DeadlineType
    :ivar state: Current state of the operation. Required. Known values are: "Unknown",
     "PendingScheduling", "Scheduled", "PendingExecution", "Executing", "Succeeded", "Failed",
     "Cancelled", and "Blocked".
    :vartype state: str or ~azure.mgmt.computeschedule.models.OperationState
    :ivar time_zone: Timezone for the operation.
    :vartype time_zone: str
    :ivar resource_operation_error: Operation level errors if they exist.
    :vartype resource_operation_error: ~azure.mgmt.computeschedule.models.ResourceOperationError
    :ivar completed_at: Time the operation was complete if errors are null.
    :vartype completed_at: ~datetime.datetime
    :ivar retry_policy: Retry policy the user can pass.
    :vartype retry_policy: ~azure.mgmt.computeschedule.models.RetryPolicy
    """

    operation_id: str = rest_field(name="operationId")
    """Operation identifier for the unique operation. Required."""
    resource_id: str = rest_field(name="resourceId")
    """Unique identifier for the resource involved in the operation, eg ArmId. Required."""
    op_type: Union[str, "_models.ResourceOperationType"] = rest_field(name="opType")
    """Type of operation performed on the resources. Required. Known values are: \"Unknown\",
     \"Start\", \"Deallocate\", and \"Hibernate\"."""
    subscription_id: str = rest_field(name="subscriptionId")
    """Subscription id attached to the request. Required."""
    deadline: datetime.datetime = rest_field(format="rfc3339")
    """Deadline for the operation. Required."""
    deadline_type: Union[str, "_models.DeadlineType"] = rest_field(name="deadlineType")
    """Type of deadline of the operation. Required. Known values are: \"Unknown\", \"InitiateAt\", and
     \"CompleteBy\"."""
    state: Union[str, "_models.OperationState"] = rest_field()
    """Current state of the operation. Required. Known values are: \"Unknown\", \"PendingScheduling\",
     \"Scheduled\", \"PendingExecution\", \"Executing\", \"Succeeded\", \"Failed\", \"Cancelled\",
     and \"Blocked\"."""
    time_zone: Optional[str] = rest_field(name="timeZone")
    """Timezone for the operation."""
    resource_operation_error: Optional["_models.ResourceOperationError"] = rest_field(name="resourceOperationError")
    """Operation level errors if they exist."""
    completed_at: Optional[datetime.datetime] = rest_field(name="completedAt", format="rfc3339")
    """Time the operation was complete if errors are null."""
    retry_policy: Optional["_models.RetryPolicy"] = rest_field(name="retryPolicy")
    """Retry policy the user can pass."""

    @overload
    def __init__(
        self,
        *,
        operation_id: str,
        resource_id: str,
        op_type: Union[str, "_models.ResourceOperationType"],
        subscription_id: str,
        deadline: datetime.datetime,
        deadline_type: Union[str, "_models.DeadlineType"],
        state: Union[str, "_models.OperationState"],
        time_zone: Optional[str] = None,
        resource_operation_error: Optional["_models.ResourceOperationError"] = None,
        completed_at: Optional[datetime.datetime] = None,
        retry_policy: Optional["_models.RetryPolicy"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ResourceOperationError(_model_base.Model):
    """These describe errors that occur at the resource level.


    :ivar error_code: Code for the error eg 404, 500. Required.
    :vartype error_code: str
    :ivar error_details: Detailed message about the error. Required.
    :vartype error_details: str
    """

    error_code: str = rest_field(name="errorCode")
    """Code for the error eg 404, 500. Required."""
    error_details: str = rest_field(name="errorDetails")
    """Detailed message about the error. Required."""

    @overload
    def __init__(
        self,
        *,
        error_code: str,
        error_details: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Resources(_model_base.Model):
    """The resources needed for the user request.

    All required parameters must be populated in order to send to server.

    :ivar ids: The resource ids used for the request. Required.
    :vartype ids: list[str]
    """

    ids: List[str] = rest_field()
    """The resource ids used for the request. Required."""

    @overload
    def __init__(
        self,
        *,
        ids: List[str],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RetryPolicy(_model_base.Model):
    """The retry policy for the user request.

    :ivar retry_count: Retry count for user request.
    :vartype retry_count: int
    :ivar retry_window_in_minutes: Retry window in minutes for user request.
    :vartype retry_window_in_minutes: int
    """

    retry_count: Optional[int] = rest_field(name="retryCount")
    """Retry count for user request."""
    retry_window_in_minutes: Optional[int] = rest_field(name="retryWindowInMinutes")
    """Retry window in minutes for user request."""

    @overload
    def __init__(
        self,
        *,
        retry_count: Optional[int] = None,
        retry_window_in_minutes: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Schedule(_model_base.Model):
    """The schedule details for the user request.

    All required parameters must be populated in order to send to server.

    :ivar dead_line: The deadline for the operation. Required.
    :vartype dead_line: ~datetime.datetime
    :ivar time_zone: The timezone for the operation. Required.
    :vartype time_zone: str
    :ivar deadline_type: The deadlinetype of the operation, this can either be InitiateAt or
     CompleteBy. Required. Known values are: "Unknown", "InitiateAt", and "CompleteBy".
    :vartype deadline_type: str or ~azure.mgmt.computeschedule.models.DeadlineType
    """

    dead_line: datetime.datetime = rest_field(name="deadLine", format="rfc3339")
    """The deadline for the operation. Required."""
    time_zone: str = rest_field(name="timeZone")
    """The timezone for the operation. Required."""
    deadline_type: Union[str, "_models.DeadlineType"] = rest_field(name="deadlineType")
    """The deadlinetype of the operation, this can either be InitiateAt or CompleteBy. Required. Known
     values are: \"Unknown\", \"InitiateAt\", and \"CompleteBy\"."""

    @overload
    def __init__(
        self,
        *,
        dead_line: datetime.datetime,
        time_zone: str,
        deadline_type: Union[str, "_models.DeadlineType"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StartResourceOperationResponse(_model_base.Model):
    """The response from a start request.


    :ivar description: The description of the operation response. Required.
    :vartype description: str
    :ivar type: The type of resources used in the start request eg virtual machines. Required.
    :vartype type: str
    :ivar location: The location of the start request eg westus. Required.
    :vartype location: str
    :ivar results: The results from the start request if no errors exist.
    :vartype results: list[~azure.mgmt.computeschedule.models.ResourceOperation]
    """

    description: str = rest_field()
    """The description of the operation response. Required."""
    type: str = rest_field()
    """The type of resources used in the start request eg virtual machines. Required."""
    location: str = rest_field(visibility=["read", "create"])
    """The location of the start request eg westus. Required."""
    results: Optional[List["_models.ResourceOperation"]] = rest_field()
    """The results from the start request if no errors exist."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        type: str,
        location: str,
        results: Optional[List["_models.ResourceOperation"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SubmitDeallocateRequest(_model_base.Model):
    """The deallocate request for resources.

    All required parameters must be populated in order to send to server.

    :ivar schedule: The schedule for the request. Required.
    :vartype schedule: ~azure.mgmt.computeschedule.models.Schedule
    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computeschedule.models.ExecutionParameters
    :ivar resources: The resources for the request. Required.
    :vartype resources: ~azure.mgmt.computeschedule.models.Resources
    :ivar correlationid: Correlationid item. Required.
    :vartype correlationid: str
    """

    schedule: "_models.Schedule" = rest_field()
    """The schedule for the request. Required."""
    execution_parameters: "_models.ExecutionParameters" = rest_field(name="executionParameters")
    """The execution parameters for the request. Required."""
    resources: "_models.Resources" = rest_field()
    """The resources for the request. Required."""
    correlationid: str = rest_field()
    """Correlationid item. Required."""

    @overload
    def __init__(
        self,
        *,
        schedule: "_models.Schedule",
        execution_parameters: "_models.ExecutionParameters",
        resources: "_models.Resources",
        correlationid: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SubmitHibernateRequest(_model_base.Model):
    """This is the request for hibernate.

    All required parameters must be populated in order to send to server.

    :ivar schedule: The schedule for the request. Required.
    :vartype schedule: ~azure.mgmt.computeschedule.models.Schedule
    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computeschedule.models.ExecutionParameters
    :ivar resources: The resources for the request. Required.
    :vartype resources: ~azure.mgmt.computeschedule.models.Resources
    :ivar correlationid: Correlationid item. Required.
    :vartype correlationid: str
    """

    schedule: "_models.Schedule" = rest_field()
    """The schedule for the request. Required."""
    execution_parameters: "_models.ExecutionParameters" = rest_field(name="executionParameters")
    """The execution parameters for the request. Required."""
    resources: "_models.Resources" = rest_field()
    """The resources for the request. Required."""
    correlationid: str = rest_field()
    """Correlationid item. Required."""

    @overload
    def __init__(
        self,
        *,
        schedule: "_models.Schedule",
        execution_parameters: "_models.ExecutionParameters",
        resources: "_models.Resources",
        correlationid: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SubmitStartRequest(_model_base.Model):
    """This is the request for start.

    All required parameters must be populated in order to send to server.

    :ivar schedule: The schedule for the request. Required.
    :vartype schedule: ~azure.mgmt.computeschedule.models.Schedule
    :ivar execution_parameters: The execution parameters for the request. Required.
    :vartype execution_parameters: ~azure.mgmt.computeschedule.models.ExecutionParameters
    :ivar resources: The resources for the request. Required.
    :vartype resources: ~azure.mgmt.computeschedule.models.Resources
    :ivar correlationid: Correlationid item. Required.
    :vartype correlationid: str
    """

    schedule: "_models.Schedule" = rest_field()
    """The schedule for the request. Required."""
    execution_parameters: "_models.ExecutionParameters" = rest_field(name="executionParameters")
    """The execution parameters for the request. Required."""
    resources: "_models.Resources" = rest_field()
    """The resources for the request. Required."""
    correlationid: str = rest_field()
    """Correlationid item. Required."""

    @overload
    def __init__(
        self,
        *,
        schedule: "_models.Schedule",
        execution_parameters: "_models.ExecutionParameters",
        resources: "_models.Resources",
        correlationid: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
