# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.web.aio import WebSiteManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebSiteManagementDiagnosticsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebSiteManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_hosting_environment_detector_responses(self, resource_group):
        response = self.client.diagnostics.list_hosting_environment_detector_responses(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_hosting_environment_detector_response(self, resource_group):
        response = await self.client.diagnostics.get_hosting_environment_detector_response(
            resource_group_name=resource_group.name,
            name="str",
            detector_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_detector_responses(self, resource_group):
        response = self.client.diagnostics.list_site_detector_responses(
            resource_group_name=resource_group.name,
            site_name="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_site_detector_response(self, resource_group):
        response = await self.client.diagnostics.get_site_detector_response(
            resource_group_name=resource_group.name,
            site_name="str",
            detector_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_diagnostic_categories(self, resource_group):
        response = self.client.diagnostics.list_site_diagnostic_categories(
            resource_group_name=resource_group.name,
            site_name="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_site_diagnostic_category(self, resource_group):
        response = await self.client.diagnostics.get_site_diagnostic_category(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_analyses(self, resource_group):
        response = self.client.diagnostics.list_site_analyses(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_site_analysis(self, resource_group):
        response = await self.client.diagnostics.get_site_analysis(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            analysis_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_execute_site_analysis(self, resource_group):
        response = await self.client.diagnostics.execute_site_analysis(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            analysis_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_detectors(self, resource_group):
        response = self.client.diagnostics.list_site_detectors(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_site_detector(self, resource_group):
        response = await self.client.diagnostics.get_site_detector(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            detector_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_execute_site_detector(self, resource_group):
        response = await self.client.diagnostics.execute_site_detector(
            resource_group_name=resource_group.name,
            site_name="str",
            detector_name="str",
            diagnostic_category="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_detector_responses_slot(self, resource_group):
        response = self.client.diagnostics.list_site_detector_responses_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            slot="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_site_detector_response_slot(self, resource_group):
        response = await self.client.diagnostics.get_site_detector_response_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            detector_name="str",
            slot="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_diagnostic_categories_slot(self, resource_group):
        response = self.client.diagnostics.list_site_diagnostic_categories_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            slot="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_site_diagnostic_category_slot(self, resource_group):
        response = await self.client.diagnostics.get_site_diagnostic_category_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            slot="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_analyses_slot(self, resource_group):
        response = self.client.diagnostics.list_site_analyses_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            slot="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_site_analysis_slot(self, resource_group):
        response = await self.client.diagnostics.get_site_analysis_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            analysis_name="str",
            slot="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_execute_site_analysis_slot(self, resource_group):
        response = await self.client.diagnostics.execute_site_analysis_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            analysis_name="str",
            slot="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_detectors_slot(self, resource_group):
        response = self.client.diagnostics.list_site_detectors_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            slot="str",
            api_version="2023-12-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_site_detector_slot(self, resource_group):
        response = await self.client.diagnostics.get_site_detector_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            diagnostic_category="str",
            detector_name="str",
            slot="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_execute_site_detector_slot(self, resource_group):
        response = await self.client.diagnostics.execute_site_detector_slot(
            resource_group_name=resource_group.name,
            site_name="str",
            detector_name="str",
            diagnostic_category="str",
            slot="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...
