# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models




class AddressSpace(_serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual
    network.

    :ivar address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :vartype address_prefixes: list[str]
    """

    _attribute_map = {
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
    }

    def __init__(self, *, address_prefixes: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword address_prefixes: A list of address blocks reserved for this virtual network in CIDR
         notation.
        :paramtype address_prefixes: list[str]
        """
        super().__init__(**kwargs)
        self.address_prefixes = address_prefixes

class Resource(_serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags

class ApplicationGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar identity: The identity of the application gateway, if configured.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar sku: SKU of the application gateway resource.
    :vartype sku: ~azure.mgmt.network.models.ApplicationGatewaySku
    :ivar ssl_policy: SSL policy of the application gateway resource.
    :vartype ssl_policy: ~azure.mgmt.network.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway resource. Known values
     are: "Stopped", "Starting", "Running", and "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.models.ApplicationGatewayOperationalState
    :ivar gateway_ip_configurations: Subnets of the application gateway resource. For default
     limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype gateway_ip_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayIPConfiguration]
    :ivar authentication_certificates: Authentication certificates of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype authentication_certificates:
     list[~azure.mgmt.network.models.ApplicationGatewayAuthenticationCertificate]
    :ivar trusted_root_certificates: Trusted Root certificates of the application gateway resource.
     For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype trusted_root_certificates:
     list[~azure.mgmt.network.models.ApplicationGatewayTrustedRootCertificate]
    :ivar trusted_client_certificates: Trusted client certificates of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype trusted_client_certificates:
     list[~azure.mgmt.network.models.ApplicationGatewayTrustedClientCertificate]
    :ivar ssl_certificates: SSL certificates of the application gateway resource. For default
     limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype ssl_certificates:
     list[~azure.mgmt.network.models.ApplicationGatewaySslCertificate]
    :ivar frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
     For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayFrontendIPConfiguration]
    :ivar frontend_ports: Frontend ports of the application gateway resource. For default limits,
     see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype frontend_ports:
     list[~azure.mgmt.network.models.ApplicationGatewayFrontendPort]
    :ivar probes: Probes of the application gateway resource.
    :vartype probes: list[~azure.mgmt.network.models.ApplicationGatewayProbe]
    :ivar backend_address_pools: Backend address pool of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype backend_address_pools:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool]
    :ivar backend_http_settings_collection: Backend http settings of the application gateway
     resource. For default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendHttpSettings]
    :ivar backend_settings_collection: Backend settings of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype backend_settings_collection:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendSettings]
    :ivar http_listeners: Http listeners of the application gateway resource. For default limits,
     see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype http_listeners:
     list[~azure.mgmt.network.models.ApplicationGatewayHttpListener]
    :ivar listeners: Listeners of the application gateway resource. For default limits, see
     `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype listeners: list[~azure.mgmt.network.models.ApplicationGatewayListener]
    :ivar ssl_profiles: SSL profiles of the application gateway resource. For default limits, see
     `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype ssl_profiles:
     list[~azure.mgmt.network.models.ApplicationGatewaySslProfile]
    :ivar url_path_maps: URL path map of the application gateway resource. For default limits, see
     `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype url_path_maps:
     list[~azure.mgmt.network.models.ApplicationGatewayUrlPathMap]
    :ivar request_routing_rules: Request routing rules of the application gateway resource.
    :vartype request_routing_rules:
     list[~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRule]
    :ivar routing_rules: Routing rules of the application gateway resource.
    :vartype routing_rules:
     list[~azure.mgmt.network.models.ApplicationGatewayRoutingRule]
    :ivar rewrite_rule_sets: Rewrite rules for the application gateway resource.
    :vartype rewrite_rule_sets:
     list[~azure.mgmt.network.models.ApplicationGatewayRewriteRuleSet]
    :ivar redirect_configurations: Redirect configurations of the application gateway resource. For
     default limits, see `Application Gateway limits
     <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
    :vartype redirect_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayRedirectConfiguration]
    :ivar web_application_firewall_configuration: Web application firewall configuration.
    :vartype web_application_firewall_configuration:
     ~azure.mgmt.network.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :ivar firewall_policy: Reference to the FirewallPolicy resource.
    :vartype firewall_policy: ~azure.mgmt.network.models.SubResource
    :ivar enable_http2: Whether HTTP2 is enabled on the application gateway resource.
    :vartype enable_http2: bool
    :ivar enable_fips: Whether FIPS is enabled on the application gateway resource.
    :vartype enable_fips: bool
    :ivar autoscale_configuration: Autoscale Configuration.
    :vartype autoscale_configuration:
     ~azure.mgmt.network.models.ApplicationGatewayAutoscaleConfiguration
    :ivar private_link_configurations: PrivateLink configurations on application gateway.
    :vartype private_link_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayPrivateLinkConfiguration]
    :ivar private_endpoint_connections: Private Endpoint connections on application gateway.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.network.models.ApplicationGatewayPrivateEndpointConnection]
    :ivar resource_guid: The resource GUID property of the application gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application gateway resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar custom_error_configurations: Custom error configurations of the application gateway
     resource.
    :vartype custom_error_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayCustomError]
    :ivar force_firewall_policy_association: If true, associates a firewall policy with an
     application gateway regardless whether the policy differs from the WAF Config.
    :vartype force_firewall_policy_association: bool
    :ivar load_distribution_policies: Load distribution policies of the application gateway
     resource.
    :vartype load_distribution_policies:
     list[~azure.mgmt.network.models.ApplicationGatewayLoadDistributionPolicy]
    :ivar global_configuration: Global Configuration.
    :vartype global_configuration:
     ~azure.mgmt.network.models.ApplicationGatewayGlobalConfiguration
    :ivar default_predefined_ssl_policy: The default predefined SSL Policy applied on the
     application gateway resource. Known values are: "AppGwSslPolicy20150501",
     "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101", and
     "AppGwSslPolicy20220101S".
    :vartype default_predefined_ssl_policy: str or
     ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "operational_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "default_predefined_ssl_policy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "sku": {"key": "properties.sku", "type": "ApplicationGatewaySku"},
        "ssl_policy": {"key": "properties.sslPolicy", "type": "ApplicationGatewaySslPolicy"},
        "operational_state": {"key": "properties.operationalState", "type": "str"},
        "gateway_ip_configurations": {
            "key": "properties.gatewayIPConfigurations",
            "type": "[ApplicationGatewayIPConfiguration]",
        },
        "authentication_certificates": {
            "key": "properties.authenticationCertificates",
            "type": "[ApplicationGatewayAuthenticationCertificate]",
        },
        "trusted_root_certificates": {
            "key": "properties.trustedRootCertificates",
            "type": "[ApplicationGatewayTrustedRootCertificate]",
        },
        "trusted_client_certificates": {
            "key": "properties.trustedClientCertificates",
            "type": "[ApplicationGatewayTrustedClientCertificate]",
        },
        "ssl_certificates": {"key": "properties.sslCertificates", "type": "[ApplicationGatewaySslCertificate]"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[ApplicationGatewayFrontendIPConfiguration]",
        },
        "frontend_ports": {"key": "properties.frontendPorts", "type": "[ApplicationGatewayFrontendPort]"},
        "probes": {"key": "properties.probes", "type": "[ApplicationGatewayProbe]"},
        "backend_address_pools": {
            "key": "properties.backendAddressPools",
            "type": "[ApplicationGatewayBackendAddressPool]",
        },
        "backend_http_settings_collection": {
            "key": "properties.backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHttpSettings]",
        },
        "backend_settings_collection": {
            "key": "properties.backendSettingsCollection",
            "type": "[ApplicationGatewayBackendSettings]",
        },
        "http_listeners": {"key": "properties.httpListeners", "type": "[ApplicationGatewayHttpListener]"},
        "listeners": {"key": "properties.listeners", "type": "[ApplicationGatewayListener]"},
        "ssl_profiles": {"key": "properties.sslProfiles", "type": "[ApplicationGatewaySslProfile]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[ApplicationGatewayUrlPathMap]"},
        "request_routing_rules": {
            "key": "properties.requestRoutingRules",
            "type": "[ApplicationGatewayRequestRoutingRule]",
        },
        "routing_rules": {"key": "properties.routingRules", "type": "[ApplicationGatewayRoutingRule]"},
        "rewrite_rule_sets": {"key": "properties.rewriteRuleSets", "type": "[ApplicationGatewayRewriteRuleSet]"},
        "redirect_configurations": {
            "key": "properties.redirectConfigurations",
            "type": "[ApplicationGatewayRedirectConfiguration]",
        },
        "web_application_firewall_configuration": {
            "key": "properties.webApplicationFirewallConfiguration",
            "type": "ApplicationGatewayWebApplicationFirewallConfiguration",
        },
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
        "enable_http2": {"key": "properties.enableHttp2", "type": "bool"},
        "enable_fips": {"key": "properties.enableFips", "type": "bool"},
        "autoscale_configuration": {
            "key": "properties.autoscaleConfiguration",
            "type": "ApplicationGatewayAutoscaleConfiguration",
        },
        "private_link_configurations": {
            "key": "properties.privateLinkConfigurations",
            "type": "[ApplicationGatewayPrivateLinkConfiguration]",
        },
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[ApplicationGatewayPrivateEndpointConnection]",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "custom_error_configurations": {
            "key": "properties.customErrorConfigurations",
            "type": "[ApplicationGatewayCustomError]",
        },
        "force_firewall_policy_association": {"key": "properties.forceFirewallPolicyAssociation", "type": "bool"},
        "load_distribution_policies": {
            "key": "properties.loadDistributionPolicies",
            "type": "[ApplicationGatewayLoadDistributionPolicy]",
        },
        "global_configuration": {
            "key": "properties.globalConfiguration",
            "type": "ApplicationGatewayGlobalConfiguration",
        },
        "default_predefined_ssl_policy": {"key": "properties.defaultPredefinedSslPolicy", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        sku: Optional["_models.ApplicationGatewaySku"] = None,
        ssl_policy: Optional["_models.ApplicationGatewaySslPolicy"] = None,
        gateway_ip_configurations: Optional[List["_models.ApplicationGatewayIPConfiguration"]] = None,
        authentication_certificates: Optional[List["_models.ApplicationGatewayAuthenticationCertificate"]] = None,
        trusted_root_certificates: Optional[List["_models.ApplicationGatewayTrustedRootCertificate"]] = None,
        trusted_client_certificates: Optional[List["_models.ApplicationGatewayTrustedClientCertificate"]] = None,
        ssl_certificates: Optional[List["_models.ApplicationGatewaySslCertificate"]] = None,
        frontend_ip_configurations: Optional[List["_models.ApplicationGatewayFrontendIPConfiguration"]] = None,
        frontend_ports: Optional[List["_models.ApplicationGatewayFrontendPort"]] = None,
        probes: Optional[List["_models.ApplicationGatewayProbe"]] = None,
        backend_address_pools: Optional[List["_models.ApplicationGatewayBackendAddressPool"]] = None,
        backend_http_settings_collection: Optional[List["_models.ApplicationGatewayBackendHttpSettings"]] = None,
        backend_settings_collection: Optional[List["_models.ApplicationGatewayBackendSettings"]] = None,
        http_listeners: Optional[List["_models.ApplicationGatewayHttpListener"]] = None,
        listeners: Optional[List["_models.ApplicationGatewayListener"]] = None,
        ssl_profiles: Optional[List["_models.ApplicationGatewaySslProfile"]] = None,
        url_path_maps: Optional[List["_models.ApplicationGatewayUrlPathMap"]] = None,
        request_routing_rules: Optional[List["_models.ApplicationGatewayRequestRoutingRule"]] = None,
        routing_rules: Optional[List["_models.ApplicationGatewayRoutingRule"]] = None,
        rewrite_rule_sets: Optional[List["_models.ApplicationGatewayRewriteRuleSet"]] = None,
        redirect_configurations: Optional[List["_models.ApplicationGatewayRedirectConfiguration"]] = None,
        web_application_firewall_configuration: Optional[
            "_models.ApplicationGatewayWebApplicationFirewallConfiguration"
        ] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        enable_http2: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        autoscale_configuration: Optional["_models.ApplicationGatewayAutoscaleConfiguration"] = None,
        private_link_configurations: Optional[List["_models.ApplicationGatewayPrivateLinkConfiguration"]] = None,
        custom_error_configurations: Optional[List["_models.ApplicationGatewayCustomError"]] = None,
        force_firewall_policy_association: Optional[bool] = None,
        load_distribution_policies: Optional[List["_models.ApplicationGatewayLoadDistributionPolicy"]] = None,
        global_configuration: Optional["_models.ApplicationGatewayGlobalConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword identity: The identity of the application gateway, if configured.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword sku: SKU of the application gateway resource.
        :paramtype sku: ~azure.mgmt.network.models.ApplicationGatewaySku
        :keyword ssl_policy: SSL policy of the application gateway resource.
        :paramtype ssl_policy: ~azure.mgmt.network.models.ApplicationGatewaySslPolicy
        :keyword gateway_ip_configurations: Subnets of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype gateway_ip_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayIPConfiguration]
        :keyword authentication_certificates: Authentication certificates of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype authentication_certificates:
         list[~azure.mgmt.network.models.ApplicationGatewayAuthenticationCertificate]
        :keyword trusted_root_certificates: Trusted Root certificates of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype trusted_root_certificates:
         list[~azure.mgmt.network.models.ApplicationGatewayTrustedRootCertificate]
        :keyword trusted_client_certificates: Trusted client certificates of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype trusted_client_certificates:
         list[~azure.mgmt.network.models.ApplicationGatewayTrustedClientCertificate]
        :keyword ssl_certificates: SSL certificates of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype ssl_certificates:
         list[~azure.mgmt.network.models.ApplicationGatewaySslCertificate]
        :keyword frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
         For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayFrontendIPConfiguration]
        :keyword frontend_ports: Frontend ports of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype frontend_ports:
         list[~azure.mgmt.network.models.ApplicationGatewayFrontendPort]
        :keyword probes: Probes of the application gateway resource.
        :paramtype probes: list[~azure.mgmt.network.models.ApplicationGatewayProbe]
        :keyword backend_address_pools: Backend address pool of the application gateway resource. For
         default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool]
        :keyword backend_http_settings_collection: Backend http settings of the application gateway
         resource. For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendHttpSettings]
        :keyword backend_settings_collection: Backend settings of the application gateway resource. For
         default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype backend_settings_collection:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendSettings]
        :keyword http_listeners: Http listeners of the application gateway resource. For default
         limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype http_listeners:
         list[~azure.mgmt.network.models.ApplicationGatewayHttpListener]
        :keyword listeners: Listeners of the application gateway resource. For default limits, see
         `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype listeners: list[~azure.mgmt.network.models.ApplicationGatewayListener]
        :keyword ssl_profiles: SSL profiles of the application gateway resource. For default limits,
         see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype ssl_profiles:
         list[~azure.mgmt.network.models.ApplicationGatewaySslProfile]
        :keyword url_path_maps: URL path map of the application gateway resource. For default limits,
         see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype url_path_maps:
         list[~azure.mgmt.network.models.ApplicationGatewayUrlPathMap]
        :keyword request_routing_rules: Request routing rules of the application gateway resource.
        :paramtype request_routing_rules:
         list[~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRule]
        :keyword routing_rules: Routing rules of the application gateway resource.
        :paramtype routing_rules:
         list[~azure.mgmt.network.models.ApplicationGatewayRoutingRule]
        :keyword rewrite_rule_sets: Rewrite rules for the application gateway resource.
        :paramtype rewrite_rule_sets:
         list[~azure.mgmt.network.models.ApplicationGatewayRewriteRuleSet]
        :keyword redirect_configurations: Redirect configurations of the application gateway resource.
         For default limits, see `Application Gateway limits
         <https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits>`_.
        :paramtype redirect_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayRedirectConfiguration]
        :keyword web_application_firewall_configuration: Web application firewall configuration.
        :paramtype web_application_firewall_configuration:
         ~azure.mgmt.network.models.ApplicationGatewayWebApplicationFirewallConfiguration
        :keyword firewall_policy: Reference to the FirewallPolicy resource.
        :paramtype firewall_policy: ~azure.mgmt.network.models.SubResource
        :keyword enable_http2: Whether HTTP2 is enabled on the application gateway resource.
        :paramtype enable_http2: bool
        :keyword enable_fips: Whether FIPS is enabled on the application gateway resource.
        :paramtype enable_fips: bool
        :keyword autoscale_configuration: Autoscale Configuration.
        :paramtype autoscale_configuration:
         ~azure.mgmt.network.models.ApplicationGatewayAutoscaleConfiguration
        :keyword private_link_configurations: PrivateLink configurations on application gateway.
        :paramtype private_link_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayPrivateLinkConfiguration]
        :keyword custom_error_configurations: Custom error configurations of the application gateway
         resource.
        :paramtype custom_error_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayCustomError]
        :keyword force_firewall_policy_association: If true, associates a firewall policy with an
         application gateway regardless whether the policy differs from the WAF Config.
        :paramtype force_firewall_policy_association: bool
        :keyword load_distribution_policies: Load distribution policies of the application gateway
         resource.
        :paramtype load_distribution_policies:
         list[~azure.mgmt.network.models.ApplicationGatewayLoadDistributionPolicy]
        :keyword global_configuration: Global Configuration.
        :paramtype global_configuration:
         ~azure.mgmt.network.models.ApplicationGatewayGlobalConfiguration
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.zones = zones
        self.identity = identity
        self.sku = sku
        self.ssl_policy = ssl_policy
        self.operational_state = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.trusted_client_certificates = trusted_client_certificates
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.backend_settings_collection = backend_settings_collection
        self.http_listeners = http_listeners
        self.listeners = listeners
        self.ssl_profiles = ssl_profiles
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.routing_rules = routing_rules
        self.rewrite_rule_sets = rewrite_rule_sets
        self.redirect_configurations = redirect_configurations
        self.web_application_firewall_configuration = web_application_firewall_configuration
        self.firewall_policy = firewall_policy
        self.enable_http2 = enable_http2
        self.enable_fips = enable_fips
        self.autoscale_configuration = autoscale_configuration
        self.private_link_configurations = private_link_configurations
        self.private_endpoint_connections = None
        self.resource_guid = None
        self.provisioning_state = None
        self.custom_error_configurations = custom_error_configurations
        self.force_firewall_policy_association = force_firewall_policy_association
        self.load_distribution_policies = load_distribution_policies
        self.global_configuration = global_configuration
        self.default_predefined_ssl_policy = None

class ApplicationGatewayBackendAddress(_serialization.Model):
    """Backend address of an application gateway.

    :ivar fqdn: Fully qualified domain name (FQDN).
    :vartype fqdn: str
    :ivar ip_address: IP address.
    :vartype ip_address: str
    """

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(self, *, fqdn: Optional[str] = None, ip_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword fqdn: Fully qualified domain name (FQDN).
        :paramtype fqdn: str
        :keyword ip_address: IP address.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_address = ip_address

class SubResource(_serialization.Model):
    """Reference to another subresource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the backend address pool that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar backend_ip_configurations: Collection of references to IPs defined in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.models.NetworkInterfaceIPConfiguration]
    :ivar backend_addresses: Backend addresses.
    :vartype backend_addresses:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendAddress]
    :ivar provisioning_state: The provisioning state of the backend address pool resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "backend_ip_configurations": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "backend_addresses": {"key": "properties.backendAddresses", "type": "[ApplicationGatewayBackendAddress]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        backend_addresses: Optional[List["_models.ApplicationGatewayBackendAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the backend address pool that is unique within an Application Gateway.
        :paramtype name: str
        :keyword backend_addresses: Backend addresses.
        :paramtype backend_addresses:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendAddress]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.backend_ip_configurations = None
        self.backend_addresses = backend_addresses
        self.provisioning_state = None

class ApplicationGatewayBackendHttpSettings(SubResource):  # pylint: disable=too-many-instance-attributes
    """Backend address pool settings of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the backend http settings that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: The destination port on the backend.
    :vartype port: int
    :ivar protocol: The protocol used to communicate with the backend. Known values are: "Http",
     "Https", "Tcp", and "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar cookie_based_affinity: Cookie based affinity. Known values are: "Enabled" and "Disabled".
    :vartype cookie_based_affinity: str or
     ~azure.mgmt.network.models.ApplicationGatewayCookieBasedAffinity
    :ivar request_timeout: Request timeout in seconds. Application Gateway will fail the request if
     response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :vartype request_timeout: int
    :ivar probe: Probe resource of an application gateway.
    :vartype probe: ~azure.mgmt.network.models.SubResource
    :ivar authentication_certificates: Array of references to application gateway authentication
     certificates.
    :vartype authentication_certificates: list[~azure.mgmt.network.models.SubResource]
    :ivar trusted_root_certificates: Array of references to application gateway trusted root
     certificates.
    :vartype trusted_root_certificates: list[~azure.mgmt.network.models.SubResource]
    :ivar connection_draining: Connection draining of the backend http settings resource.
    :vartype connection_draining:
     ~azure.mgmt.network.models.ApplicationGatewayConnectionDraining
    :ivar host_name: Host header to be sent to the backend servers.
    :vartype host_name: str
    :ivar pick_host_name_from_backend_address: Whether to pick host header should be picked from
     the host name of the backend server. Default value is false.
    :vartype pick_host_name_from_backend_address: bool
    :ivar affinity_cookie_name: Cookie name to use for the affinity cookie.
    :vartype affinity_cookie_name: str
    :ivar probe_enabled: Whether the probe is enabled. Default value is false.
    :vartype probe_enabled: bool
    :ivar path: Path which should be used as a prefix for all HTTP requests. Null means no path
     will be prefixed. Default value is null.
    :vartype path: str
    :ivar provisioning_state: The provisioning state of the backend HTTP settings resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "cookie_based_affinity": {"key": "properties.cookieBasedAffinity", "type": "str"},
        "request_timeout": {"key": "properties.requestTimeout", "type": "int"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "authentication_certificates": {"key": "properties.authenticationCertificates", "type": "[SubResource]"},
        "trusted_root_certificates": {"key": "properties.trustedRootCertificates", "type": "[SubResource]"},
        "connection_draining": {"key": "properties.connectionDraining", "type": "ApplicationGatewayConnectionDraining"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "pick_host_name_from_backend_address": {"key": "properties.pickHostNameFromBackendAddress", "type": "bool"},
        "affinity_cookie_name": {"key": "properties.affinityCookieName", "type": "str"},
        "probe_enabled": {"key": "properties.probeEnabled", "type": "bool"},
        "path": {"key": "properties.path", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        cookie_based_affinity: Optional[Union[str, "_models.ApplicationGatewayCookieBasedAffinity"]] = None,
        request_timeout: Optional[int] = None,
        probe: Optional["_models.SubResource"] = None,
        authentication_certificates: Optional[List["_models.SubResource"]] = None,
        trusted_root_certificates: Optional[List["_models.SubResource"]] = None,
        connection_draining: Optional["_models.ApplicationGatewayConnectionDraining"] = None,
        host_name: Optional[str] = None,
        pick_host_name_from_backend_address: Optional[bool] = None,
        affinity_cookie_name: Optional[str] = None,
        probe_enabled: Optional[bool] = None,
        path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the backend http settings that is unique within an Application Gateway.
        :paramtype name: str
        :keyword port: The destination port on the backend.
        :paramtype port: int
        :keyword protocol: The protocol used to communicate with the backend. Known values are: "Http",
         "Https", "Tcp", and "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword cookie_based_affinity: Cookie based affinity. Known values are: "Enabled" and
         "Disabled".
        :paramtype cookie_based_affinity: str or
         ~azure.mgmt.network.models.ApplicationGatewayCookieBasedAffinity
        :keyword request_timeout: Request timeout in seconds. Application Gateway will fail the request
         if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
         seconds.
        :paramtype request_timeout: int
        :keyword probe: Probe resource of an application gateway.
        :paramtype probe: ~azure.mgmt.network.models.SubResource
        :keyword authentication_certificates: Array of references to application gateway authentication
         certificates.
        :paramtype authentication_certificates:
         list[~azure.mgmt.network.models.SubResource]
        :keyword trusted_root_certificates: Array of references to application gateway trusted root
         certificates.
        :paramtype trusted_root_certificates: list[~azure.mgmt.network.models.SubResource]
        :keyword connection_draining: Connection draining of the backend http settings resource.
        :paramtype connection_draining:
         ~azure.mgmt.network.models.ApplicationGatewayConnectionDraining
        :keyword host_name: Host header to be sent to the backend servers.
        :paramtype host_name: str
        :keyword pick_host_name_from_backend_address: Whether to pick host header should be picked from
         the host name of the backend server. Default value is false.
        :paramtype pick_host_name_from_backend_address: bool
        :keyword affinity_cookie_name: Cookie name to use for the affinity cookie.
        :paramtype affinity_cookie_name: str
        :keyword probe_enabled: Whether the probe is enabled. Default value is false.
        :paramtype probe_enabled: bool
        :keyword path: Path which should be used as a prefix for all HTTP requests. Null means no path
         will be prefixed. Default value is null.
        :paramtype path: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.connection_draining = connection_draining
        self.host_name = host_name
        self.pick_host_name_from_backend_address = pick_host_name_from_backend_address
        self.affinity_cookie_name = affinity_cookie_name
        self.probe_enabled = probe_enabled
        self.path = path
        self.provisioning_state = None

class ApplicationGatewayFrontendIPConfiguration(SubResource):  # pylint: disable=name-too-long
    """Frontend IP configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the frontend IP configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.models.IPAllocationMethod
    :ivar subnet: Reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar public_ip_address: Reference to the PublicIP resource.
    :vartype public_ip_address: ~azure.mgmt.network.models.SubResource
    :ivar private_link_configuration: Reference to the application gateway private link
     configuration.
    :vartype private_link_configuration: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "private_link_configuration": {"key": "properties.privateLinkConfiguration", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        private_link_configuration: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the frontend IP configuration that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.models.IPAllocationMethod
        :keyword subnet: Reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword public_ip_address: Reference to the PublicIP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.models.SubResource
        :keyword private_link_configuration: Reference to the application gateway private link
         configuration.
        :paramtype private_link_configuration: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.private_link_configuration = private_link_configuration
        self.provisioning_state = None

class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the frontend port that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar port: Frontend port.
    :vartype port: int
    :ivar provisioning_state: The provisioning state of the frontend port resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the frontend port that is unique within an Application Gateway.
        :paramtype name: str
        :keyword port: Frontend port.
        :paramtype port: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.port = port
        self.provisioning_state = None

class ApplicationGatewayHttpListener(SubResource):  # pylint: disable=too-many-instance-attributes
    """Http listener of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the HTTP listener that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
    :ivar frontend_port: Frontend port resource of an application gateway.
    :vartype frontend_port: ~azure.mgmt.network.models.SubResource
    :ivar protocol: Protocol of the HTTP listener. Known values are: "Http", "Https", "Tcp", and
     "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar host_name: Host name of HTTP listener.
    :vartype host_name: str
    :ivar ssl_certificate: SSL certificate resource of an application gateway.
    :vartype ssl_certificate: ~azure.mgmt.network.models.SubResource
    :ivar ssl_profile: SSL profile resource of the application gateway.
    :vartype ssl_profile: ~azure.mgmt.network.models.SubResource
    :ivar require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :vartype require_server_name_indication: bool
    :ivar provisioning_state: The provisioning state of the HTTP listener resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar custom_error_configurations: Custom error configurations of the HTTP listener.
    :vartype custom_error_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayCustomError]
    :ivar firewall_policy: Reference to the FirewallPolicy resource.
    :vartype firewall_policy: ~azure.mgmt.network.models.SubResource
    :ivar host_names: List of Host names for HTTP Listener that allows special wildcard characters
     as well.
    :vartype host_names: list[str]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "frontend_port": {"key": "properties.frontendPort", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "ssl_certificate": {"key": "properties.sslCertificate", "type": "SubResource"},
        "ssl_profile": {"key": "properties.sslProfile", "type": "SubResource"},
        "require_server_name_indication": {"key": "properties.requireServerNameIndication", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "custom_error_configurations": {
            "key": "properties.customErrorConfigurations",
            "type": "[ApplicationGatewayCustomError]",
        },
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        frontend_port: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host_name: Optional[str] = None,
        ssl_certificate: Optional["_models.SubResource"] = None,
        ssl_profile: Optional["_models.SubResource"] = None,
        require_server_name_indication: Optional[bool] = None,
        custom_error_configurations: Optional[List["_models.ApplicationGatewayCustomError"]] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        host_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the HTTP listener that is unique within an Application Gateway.
        :paramtype name: str
        :keyword frontend_ip_configuration: Frontend IP configuration resource of an application
         gateway.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
        :keyword frontend_port: Frontend port resource of an application gateway.
        :paramtype frontend_port: ~azure.mgmt.network.models.SubResource
        :keyword protocol: Protocol of the HTTP listener. Known values are: "Http", "Https", "Tcp", and
         "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword host_name: Host name of HTTP listener.
        :paramtype host_name: str
        :keyword ssl_certificate: SSL certificate resource of an application gateway.
        :paramtype ssl_certificate: ~azure.mgmt.network.models.SubResource
        :keyword ssl_profile: SSL profile resource of the application gateway.
        :paramtype ssl_profile: ~azure.mgmt.network.models.SubResource
        :keyword require_server_name_indication: Applicable only if protocol is https. Enables SNI for
         multi-hosting.
        :paramtype require_server_name_indication: bool
        :keyword custom_error_configurations: Custom error configurations of the HTTP listener.
        :paramtype custom_error_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayCustomError]
        :keyword firewall_policy: Reference to the FirewallPolicy resource.
        :paramtype firewall_policy: ~azure.mgmt.network.models.SubResource
        :keyword host_names: List of Host names for HTTP Listener that allows special wildcard
         characters as well.
        :paramtype host_names: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.ssl_profile = ssl_profile
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state = None
        self.custom_error_configurations = custom_error_configurations
        self.firewall_policy = firewall_policy
        self.host_names = host_names

class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration
    is allowed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the IP configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar subnet: Reference to the subnet resource. A subnet from where application gateway gets
     its private address.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the application gateway IP configuration
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the IP configuration that is unique within an Application Gateway.
        :paramtype name: str
        :keyword subnet: Reference to the subnet resource. A subnet from where application gateway gets
         its private address.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.subnet = subnet
        self.provisioning_state = None

class ApplicationGatewayListResult(_serialization.Model):
    """Response for ListApplicationGateways API service call.

    :ivar value: List of an application gateways in a resource group.
    :vartype value: list[~azure.mgmt.network.models.ApplicationGateway]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of an application gateways in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationGateway]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ApplicationGatewayPathRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Path rule of URL path map of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the path rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar paths: Path rules of URL path map.
    :vartype paths: list[str]
    :ivar backend_address_pool: Backend address pool resource of URL path map path rule.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar backend_http_settings: Backend http settings resource of URL path map path rule.
    :vartype backend_http_settings: ~azure.mgmt.network.models.SubResource
    :ivar redirect_configuration: Redirect configuration resource of URL path map path rule.
    :vartype redirect_configuration: ~azure.mgmt.network.models.SubResource
    :ivar rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
    :vartype rewrite_rule_set: ~azure.mgmt.network.models.SubResource
    :ivar load_distribution_policy: Load Distribution Policy resource of URL path map path rule.
    :vartype load_distribution_policy: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the path rule resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar firewall_policy: Reference to the FirewallPolicy resource.
    :vartype firewall_policy: ~azure.mgmt.network.models.SubResource
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "paths": {"key": "properties.paths", "type": "[str]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "redirect_configuration": {"key": "properties.redirectConfiguration", "type": "SubResource"},
        "rewrite_rule_set": {"key": "properties.rewriteRuleSet", "type": "SubResource"},
        "load_distribution_policy": {"key": "properties.loadDistributionPolicy", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        paths: Optional[List[str]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        redirect_configuration: Optional["_models.SubResource"] = None,
        rewrite_rule_set: Optional["_models.SubResource"] = None,
        load_distribution_policy: Optional["_models.SubResource"] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the path rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword paths: Path rules of URL path map.
        :paramtype paths: list[str]
        :keyword backend_address_pool: Backend address pool resource of URL path map path rule.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword backend_http_settings: Backend http settings resource of URL path map path rule.
        :paramtype backend_http_settings: ~azure.mgmt.network.models.SubResource
        :keyword redirect_configuration: Redirect configuration resource of URL path map path rule.
        :paramtype redirect_configuration: ~azure.mgmt.network.models.SubResource
        :keyword rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
        :paramtype rewrite_rule_set: ~azure.mgmt.network.models.SubResource
        :keyword load_distribution_policy: Load Distribution Policy resource of URL path map path rule.
        :paramtype load_distribution_policy: ~azure.mgmt.network.models.SubResource
        :keyword firewall_policy: Reference to the FirewallPolicy resource.
        :paramtype firewall_policy: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.paths = paths
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.redirect_configuration = redirect_configuration
        self.rewrite_rule_set = rewrite_rule_set
        self.load_distribution_policy = load_distribution_policy
        self.provisioning_state = None
        self.firewall_policy = firewall_policy

class ApplicationGatewayProbe(SubResource):  # pylint: disable=too-many-instance-attributes
    """Probe of the application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the probe that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar protocol: The protocol used for the probe. Known values are: "Http", "Https", "Tcp", and
     "Tls".
    :vartype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
    :ivar host: Host name to send the probe to.
    :vartype host: str
    :ivar path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :vartype path: str
    :ivar interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :vartype interval: int
    :ivar timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :vartype timeout: int
    :ivar unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :vartype unhealthy_threshold: int
    :ivar pick_host_name_from_backend_http_settings: Whether the host header should be picked from
     the backend http settings. Default value is false.
    :vartype pick_host_name_from_backend_http_settings: bool
    :ivar pick_host_name_from_backend_settings: Whether the server name indication should be picked
     from the backend settings for Tls protocol. Default value is false.
    :vartype pick_host_name_from_backend_settings: bool
    :ivar min_servers: Minimum number of servers that are always marked healthy. Default value is
     0.
    :vartype min_servers: int
    :ivar match: Criterion for classifying a healthy probe response.
    :vartype match:
     ~azure.mgmt.network.models.ApplicationGatewayProbeHealthResponseMatch
    :ivar provisioning_state: The provisioning state of the probe resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar port: Custom port which will be used for probing the backend servers. The valid value
     ranges from 1 to 65535. In case not set, port from http settings will be used. This property is
     valid for Basic, Standard_v2 and WAF_v2 only.
    :vartype port: int
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "port": {"maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host": {"key": "properties.host", "type": "str"},
        "path": {"key": "properties.path", "type": "str"},
        "interval": {"key": "properties.interval", "type": "int"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "unhealthy_threshold": {"key": "properties.unhealthyThreshold", "type": "int"},
        "pick_host_name_from_backend_http_settings": {
            "key": "properties.pickHostNameFromBackendHttpSettings",
            "type": "bool",
        },
        "pick_host_name_from_backend_settings": {"key": "properties.pickHostNameFromBackendSettings", "type": "bool"},
        "min_servers": {"key": "properties.minServers", "type": "int"},
        "match": {"key": "properties.match", "type": "ApplicationGatewayProbeHealthResponseMatch"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        interval: Optional[int] = None,
        timeout: Optional[int] = None,
        unhealthy_threshold: Optional[int] = None,
        pick_host_name_from_backend_http_settings: Optional[bool] = None,
        pick_host_name_from_backend_settings: Optional[bool] = None,
        min_servers: Optional[int] = None,
        match: Optional["_models.ApplicationGatewayProbeHealthResponseMatch"] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the probe that is unique within an Application Gateway.
        :paramtype name: str
        :keyword protocol: The protocol used for the probe. Known values are: "Http", "Https", "Tcp",
         and "Tls".
        :paramtype protocol: str or ~azure.mgmt.network.models.ApplicationGatewayProtocol
        :keyword host: Host name to send the probe to.
        :paramtype host: str
        :keyword path: Relative path of probe. Valid path starts from '/'. Probe is sent to
         :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
        :paramtype path: str
        :keyword interval: The probing interval in seconds. This is the time interval between two
         consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :paramtype interval: int
        :keyword timeout: The probe timeout in seconds. Probe marked as failed if valid response is not
         received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :paramtype timeout: int
        :keyword unhealthy_threshold: The probe retry count. Backend server is marked down after
         consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
         to 20.
        :paramtype unhealthy_threshold: int
        :keyword pick_host_name_from_backend_http_settings: Whether the host header should be picked
         from the backend http settings. Default value is false.
        :paramtype pick_host_name_from_backend_http_settings: bool
        :keyword pick_host_name_from_backend_settings: Whether the server name indication should be
         picked from the backend settings for Tls protocol. Default value is false.
        :paramtype pick_host_name_from_backend_settings: bool
        :keyword min_servers: Minimum number of servers that are always marked healthy. Default value
         is 0.
        :paramtype min_servers: int
        :keyword match: Criterion for classifying a healthy probe response.
        :paramtype match:
         ~azure.mgmt.network.models.ApplicationGatewayProbeHealthResponseMatch
        :keyword port: Custom port which will be used for probing the backend servers. The valid value
         ranges from 1 to 65535. In case not set, port from http settings will be used. This property is
         valid for Basic, Standard_v2 and WAF_v2 only.
        :paramtype port: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.protocol = protocol
        self.host = host
        self.path = path
        self.interval = interval
        self.timeout = timeout
        self.unhealthy_threshold = unhealthy_threshold
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.pick_host_name_from_backend_settings = pick_host_name_from_backend_settings
        self.min_servers = min_servers
        self.match = match
        self.provisioning_state = None
        self.port = port

class ApplicationGatewayRequestRoutingRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Request routing rule of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the request routing rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
    :vartype rule_type: str or
     ~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRuleType
    :ivar priority: Priority of the request routing rule.
    :vartype priority: int
    :ivar backend_address_pool: Backend address pool resource of the application gateway.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar backend_http_settings: Backend http settings resource of the application gateway.
    :vartype backend_http_settings: ~azure.mgmt.network.models.SubResource
    :ivar http_listener: Http listener resource of the application gateway.
    :vartype http_listener: ~azure.mgmt.network.models.SubResource
    :ivar url_path_map: URL path map resource of the application gateway.
    :vartype url_path_map: ~azure.mgmt.network.models.SubResource
    :ivar rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
    :vartype rewrite_rule_set: ~azure.mgmt.network.models.SubResource
    :ivar redirect_configuration: Redirect configuration resource of the application gateway.
    :vartype redirect_configuration: ~azure.mgmt.network.models.SubResource
    :ivar load_distribution_policy: Load Distribution Policy resource of the application gateway.
    :vartype load_distribution_policy: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the request routing rule resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "priority": {"maximum": 20000, "minimum": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "http_listener": {"key": "properties.httpListener", "type": "SubResource"},
        "url_path_map": {"key": "properties.urlPathMap", "type": "SubResource"},
        "rewrite_rule_set": {"key": "properties.rewriteRuleSet", "type": "SubResource"},
        "redirect_configuration": {"key": "properties.redirectConfiguration", "type": "SubResource"},
        "load_distribution_policy": {"key": "properties.loadDistributionPolicy", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.ApplicationGatewayRequestRoutingRuleType"]] = None,
        priority: Optional[int] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        http_listener: Optional["_models.SubResource"] = None,
        url_path_map: Optional["_models.SubResource"] = None,
        rewrite_rule_set: Optional["_models.SubResource"] = None,
        redirect_configuration: Optional["_models.SubResource"] = None,
        load_distribution_policy: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the request routing rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rule_type: Rule type. Known values are: "Basic" and "PathBasedRouting".
        :paramtype rule_type: str or
         ~azure.mgmt.network.models.ApplicationGatewayRequestRoutingRuleType
        :keyword priority: Priority of the request routing rule.
        :paramtype priority: int
        :keyword backend_address_pool: Backend address pool resource of the application gateway.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword backend_http_settings: Backend http settings resource of the application gateway.
        :paramtype backend_http_settings: ~azure.mgmt.network.models.SubResource
        :keyword http_listener: Http listener resource of the application gateway.
        :paramtype http_listener: ~azure.mgmt.network.models.SubResource
        :keyword url_path_map: URL path map resource of the application gateway.
        :paramtype url_path_map: ~azure.mgmt.network.models.SubResource
        :keyword rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
        :paramtype rewrite_rule_set: ~azure.mgmt.network.models.SubResource
        :keyword redirect_configuration: Redirect configuration resource of the application gateway.
        :paramtype redirect_configuration: ~azure.mgmt.network.models.SubResource
        :keyword load_distribution_policy: Load Distribution Policy resource of the application
         gateway.
        :paramtype load_distribution_policy: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.rule_type = rule_type
        self.priority = priority
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.rewrite_rule_set = rewrite_rule_set
        self.redirect_configuration = redirect_configuration
        self.load_distribution_policy = load_distribution_policy
        self.provisioning_state = None

class ApplicationGatewaySku(_serialization.Model):
    """SKU of an application gateway.

    :ivar name: Name of an application gateway SKU. Known values are: "Standard_Small",
     "Standard_Medium", "Standard_Large", "WAF_Medium", "WAF_Large", "Standard_v2", "WAF_v2", and
     "Basic".
    :vartype name: str or ~azure.mgmt.network.models.ApplicationGatewaySkuName
    :ivar tier: Tier of an application gateway. Known values are: "Standard", "WAF", "Standard_v2",
     "WAF_v2", and "Basic".
    :vartype tier: str or ~azure.mgmt.network.models.ApplicationGatewayTier
    :ivar capacity: Capacity (instance count) of an application gateway.
    :vartype capacity: int
    :ivar family: Family of an application gateway SKU. Known values are: "Generation_1" and
     "Generation_2".
    :vartype family: str or ~azure.mgmt.network.models.ApplicationGatewaySkuFamily
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.ApplicationGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.ApplicationGatewayTier"]] = None,
        capacity: Optional[int] = None,
        family: Optional[Union[str, "_models.ApplicationGatewaySkuFamily"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of an application gateway SKU. Known values are: "Standard_Small",
         "Standard_Medium", "Standard_Large", "WAF_Medium", "WAF_Large", "Standard_v2", "WAF_v2", and
         "Basic".
        :paramtype name: str or ~azure.mgmt.network.models.ApplicationGatewaySkuName
        :keyword tier: Tier of an application gateway. Known values are: "Standard", "WAF",
         "Standard_v2", "WAF_v2", and "Basic".
        :paramtype tier: str or ~azure.mgmt.network.models.ApplicationGatewayTier
        :keyword capacity: Capacity (instance count) of an application gateway.
        :paramtype capacity: int
        :keyword family: Family of an application gateway SKU. Known values are: "Generation_1" and
         "Generation_2".
        :paramtype family: str or ~azure.mgmt.network.models.ApplicationGatewaySkuFamily
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity
        self.family = family

class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the SSL certificate that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :vartype data: str
    :ivar password: Password for the pfx file specified in data. Only applicable in PUT request.
    :vartype password: str
    :ivar public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :vartype public_cert_data: str
    :ivar key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :vartype key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the SSL certificate resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "public_cert_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "key_vault_secret_id": {"key": "properties.keyVaultSecretId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        key_vault_secret_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the SSL certificate that is unique within an Application Gateway.
        :paramtype name: str
        :keyword data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :paramtype data: str
        :keyword password: Password for the pfx file specified in data. Only applicable in PUT request.
        :paramtype password: str
        :keyword key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
         'Certificate' object stored in KeyVault.
        :paramtype key_vault_secret_id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.data = data
        self.password = password
        self.public_cert_data = None
        self.key_vault_secret_id = key_vault_secret_id
        self.provisioning_state = None

class ApplicationGatewayUrlPathMap(SubResource):  # pylint: disable=too-many-instance-attributes
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the URL path map that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar default_backend_address_pool: Default backend address pool resource of URL path map.
    :vartype default_backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar default_backend_http_settings: Default backend http settings resource of URL path map.
    :vartype default_backend_http_settings: ~azure.mgmt.network.models.SubResource
    :ivar default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
    :vartype default_rewrite_rule_set: ~azure.mgmt.network.models.SubResource
    :ivar default_redirect_configuration: Default redirect configuration resource of URL path map.
    :vartype default_redirect_configuration: ~azure.mgmt.network.models.SubResource
    :ivar default_load_distribution_policy: Default Load Distribution Policy resource of URL path
     map.
    :vartype default_load_distribution_policy: ~azure.mgmt.network.models.SubResource
    :ivar path_rules: Path rule of URL path map resource.
    :vartype path_rules: list[~azure.mgmt.network.models.ApplicationGatewayPathRule]
    :ivar provisioning_state: The provisioning state of the URL path map resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "default_backend_address_pool": {"key": "properties.defaultBackendAddressPool", "type": "SubResource"},
        "default_backend_http_settings": {"key": "properties.defaultBackendHttpSettings", "type": "SubResource"},
        "default_rewrite_rule_set": {"key": "properties.defaultRewriteRuleSet", "type": "SubResource"},
        "default_redirect_configuration": {"key": "properties.defaultRedirectConfiguration", "type": "SubResource"},
        "default_load_distribution_policy": {"key": "properties.defaultLoadDistributionPolicy", "type": "SubResource"},
        "path_rules": {"key": "properties.pathRules", "type": "[ApplicationGatewayPathRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        default_backend_address_pool: Optional["_models.SubResource"] = None,
        default_backend_http_settings: Optional["_models.SubResource"] = None,
        default_rewrite_rule_set: Optional["_models.SubResource"] = None,
        default_redirect_configuration: Optional["_models.SubResource"] = None,
        default_load_distribution_policy: Optional["_models.SubResource"] = None,
        path_rules: Optional[List["_models.ApplicationGatewayPathRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the URL path map that is unique within an Application Gateway.
        :paramtype name: str
        :keyword default_backend_address_pool: Default backend address pool resource of URL path map.
        :paramtype default_backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword default_backend_http_settings: Default backend http settings resource of URL path map.
        :paramtype default_backend_http_settings: ~azure.mgmt.network.models.SubResource
        :keyword default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
        :paramtype default_rewrite_rule_set: ~azure.mgmt.network.models.SubResource
        :keyword default_redirect_configuration: Default redirect configuration resource of URL path
         map.
        :paramtype default_redirect_configuration: ~azure.mgmt.network.models.SubResource
        :keyword default_load_distribution_policy: Default Load Distribution Policy resource of URL
         path map.
        :paramtype default_load_distribution_policy: ~azure.mgmt.network.models.SubResource
        :keyword path_rules: Path rule of URL path map resource.
        :paramtype path_rules: list[~azure.mgmt.network.models.ApplicationGatewayPathRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.default_backend_address_pool = default_backend_address_pool
        self.default_backend_http_settings = default_backend_http_settings
        self.default_rewrite_rule_set = default_rewrite_rule_set
        self.default_redirect_configuration = default_redirect_configuration
        self.default_load_distribution_policy = default_load_distribution_policy
        self.path_rules = path_rules
        self.provisioning_state = None

class AuthorizationListResult(_serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to
    an ExpressRouteCircuit.

    :ivar value: The authorizations in an ExpressRoute Circuit.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitAuthorization]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitAuthorization]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitAuthorization"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The authorizations in an ExpressRoute Circuit.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitAuthorization]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class AzureAsyncOperationResult(_serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating
    whether it has succeeded, is in progress, or has failed. Note that this status is distinct from
    the HTTP status code returned for the Get Operation Status operation itself. If the
    asynchronous operation succeeded, the response body includes the HTTP status code for the
    successful request. If the asynchronous operation failed, the response body includes the HTTP
    status code for the failed request and error information regarding the failure.

    :ivar status: Status of the Azure async operation. Known values are: "InProgress", "Succeeded",
     and "Failed".
    :vartype status: str or ~azure.mgmt.network.models.NetworkOperationStatus
    :ivar error: Details of the error occurred during specified asynchronous operation.
    :vartype error: ~azure.mgmt.network.models.Error
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.NetworkOperationStatus"]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the Azure async operation. Known values are: "InProgress",
         "Succeeded", and "Failed".
        :paramtype status: str or ~azure.mgmt.network.models.NetworkOperationStatus
        :keyword error: Details of the error occurred during specified asynchronous operation.
        :paramtype error: ~azure.mgmt.network.models.Error
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error

class BackendAddressPool(SubResource):  # pylint: disable=too-many-instance-attributes
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of backend address pools
     used by the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar location: The location of the backend address pool.
    :vartype location: str
    :ivar tunnel_interfaces: An array of gateway load balancer tunnel interfaces.
    :vartype tunnel_interfaces:
     list[~azure.mgmt.network.models.GatewayLoadBalancerTunnelInterface]
    :ivar load_balancer_backend_addresses: An array of backend addresses.
    :vartype load_balancer_backend_addresses:
     list[~azure.mgmt.network.models.LoadBalancerBackendAddress]
    :ivar backend_ip_configurations: An array of references to IP addresses defined in network
     interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: An array of references to load balancing rules that use this
     backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar outbound_rule: A reference to an outbound rule that uses this backend address pool.
    :vartype outbound_rule: ~azure.mgmt.network.models.SubResource
    :ivar outbound_rules: An array of references to outbound rules that use this backend address
     pool.
    :vartype outbound_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar inbound_nat_rules: An array of references to inbound NAT rules that use this backend
     address pool.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar provisioning_state: The provisioning state of the backend address pool resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar drain_period_in_seconds: Amount of seconds Load Balancer waits for before sending RESET
     to client and backend address.
    :vartype drain_period_in_seconds: int
    :ivar virtual_network: A reference to a virtual network.
    :vartype virtual_network: ~azure.mgmt.network.models.SubResource
    :ivar sync_mode: Backend address synchronous mode for the backend pool. Known values are:
     "Automatic" and "Manual".
    :vartype sync_mode: str or ~azure.mgmt.network.models.SyncMode
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "backend_ip_configurations": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "outbound_rule": {"readonly": True},
        "outbound_rules": {"readonly": True},
        "inbound_nat_rules": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "tunnel_interfaces": {"key": "properties.tunnelInterfaces", "type": "[GatewayLoadBalancerTunnelInterface]"},
        "load_balancer_backend_addresses": {
            "key": "properties.loadBalancerBackendAddresses",
            "type": "[LoadBalancerBackendAddress]",
        },
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "outbound_rule": {"key": "properties.outboundRule", "type": "SubResource"},
        "outbound_rules": {"key": "properties.outboundRules", "type": "[SubResource]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "drain_period_in_seconds": {"key": "properties.drainPeriodInSeconds", "type": "int"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "SubResource"},
        "sync_mode": {"key": "properties.syncMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        location: Optional[str] = None,
        tunnel_interfaces: Optional[List["_models.GatewayLoadBalancerTunnelInterface"]] = None,
        load_balancer_backend_addresses: Optional[List["_models.LoadBalancerBackendAddress"]] = None,
        drain_period_in_seconds: Optional[int] = None,
        virtual_network: Optional["_models.SubResource"] = None,
        sync_mode: Optional[Union[str, "_models.SyncMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of backend address pools
         used by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword location: The location of the backend address pool.
        :paramtype location: str
        :keyword tunnel_interfaces: An array of gateway load balancer tunnel interfaces.
        :paramtype tunnel_interfaces:
         list[~azure.mgmt.network.models.GatewayLoadBalancerTunnelInterface]
        :keyword load_balancer_backend_addresses: An array of backend addresses.
        :paramtype load_balancer_backend_addresses:
         list[~azure.mgmt.network.models.LoadBalancerBackendAddress]
        :keyword drain_period_in_seconds: Amount of seconds Load Balancer waits for before sending
         RESET to client and backend address.
        :paramtype drain_period_in_seconds: int
        :keyword virtual_network: A reference to a virtual network.
        :paramtype virtual_network: ~azure.mgmt.network.models.SubResource
        :keyword sync_mode: Backend address synchronous mode for the backend pool. Known values are:
         "Automatic" and "Manual".
        :paramtype sync_mode: str or ~azure.mgmt.network.models.SyncMode
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.location = location
        self.tunnel_interfaces = tunnel_interfaces
        self.load_balancer_backend_addresses = load_balancer_backend_addresses
        self.backend_ip_configurations = None
        self.load_balancing_rules = None
        self.outbound_rule = None
        self.outbound_rules = None
        self.inbound_nat_rules = None
        self.provisioning_state = None
        self.drain_period_in_seconds = drain_period_in_seconds
        self.virtual_network = virtual_network
        self.sync_mode = sync_mode

class BgpSettings(_serialization.Model):
    """BGP settings details.

    :ivar asn: The BGP speaker's ASN.
    :vartype asn: int
    :ivar bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
    :vartype bgp_peering_address: str
    :ivar peer_weight: The weight added to routes learned from this BGP speaker.
    :vartype peer_weight: int
    :ivar bgp_peering_addresses: BGP peering address with IP configuration ID for virtual network
     gateway.
    :vartype bgp_peering_addresses:
     list[~azure.mgmt.network.models.IPConfigurationBgpPeeringAddress]
    """

    _validation = {
        "asn": {"maximum": 4294967295, "minimum": 0},
    }

    _attribute_map = {
        "asn": {"key": "asn", "type": "int"},
        "bgp_peering_address": {"key": "bgpPeeringAddress", "type": "str"},
        "peer_weight": {"key": "peerWeight", "type": "int"},
        "bgp_peering_addresses": {"key": "bgpPeeringAddresses", "type": "[IPConfigurationBgpPeeringAddress]"},
    }

    def __init__(
        self,
        *,
        asn: Optional[int] = None,
        bgp_peering_address: Optional[str] = None,
        peer_weight: Optional[int] = None,
        bgp_peering_addresses: Optional[List["_models.IPConfigurationBgpPeeringAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword asn: The BGP speaker's ASN.
        :paramtype asn: int
        :keyword bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        :paramtype bgp_peering_address: str
        :keyword peer_weight: The weight added to routes learned from this BGP speaker.
        :paramtype peer_weight: int
        :keyword bgp_peering_addresses: BGP peering address with IP configuration ID for virtual
         network gateway.
        :paramtype bgp_peering_addresses:
         list[~azure.mgmt.network.models.IPConfigurationBgpPeeringAddress]
        """
        super().__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address
        self.peer_weight = peer_weight
        self.bgp_peering_addresses = bgp_peering_addresses

class ConnectionResetSharedKey(_serialization.Model):
    """The virtual network connection reset shared key.

    All required parameters must be populated in order to send to server.

    :ivar key_length: The virtual network connection reset shared key length, should between 1 and
     128. Required.
    :vartype key_length: int
    """

    _validation = {
        "key_length": {"required": True, "maximum": 128, "minimum": 1},
    }

    _attribute_map = {
        "key_length": {"key": "keyLength", "type": "int"},
    }

    def __init__(self, *, key_length: int, **kwargs: Any) -> None:
        """
        :keyword key_length: The virtual network connection reset shared key length, should between 1
         and 128. Required.
        :paramtype key_length: int
        """
        super().__init__(**kwargs)
        self.key_length = key_length

class ConnectionSharedKey(SubResource):
    """Response for GetConnectionSharedKey API service call.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar value: The virtual network connection shared key value. Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, value: str, id: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword value: The virtual network connection shared key value. Required.
        :paramtype value: str
        """
        super().__init__(id=id, **kwargs)
        self.value = value

class ConnectionSharedKeyResult(SubResource):
    """SharedKey Resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar properties: Properties of the shared key.
    :vartype properties: ~azure.mgmt.network.models.SharedKeyProperties
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "properties": {"key": "properties", "type": "SharedKeyProperties"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        properties: Optional["_models.SharedKeyProperties"] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword properties: Properties of the shared key.
        :paramtype properties: ~azure.mgmt.network.models.SharedKeyProperties
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        """
        super().__init__(id=id, **kwargs)
        self.properties = properties
        self.name = name
        self.type = None

class DhcpOptions(_serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network.
    Standard DHCP option for a subnet overrides VNET DHCP options.

    :ivar dns_servers: The list of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword dns_servers: The list of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers

class DnsNameAvailabilityResult(_serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :ivar available: Domain availability (True/False).
    :vartype available: bool
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
    }

    def __init__(self, *, available: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword available: Domain availability (True/False).
        :paramtype available: bool
        """
        super().__init__(**kwargs)
        self.available = available

class Error(_serialization.Model):
    """Common error representation.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: Error details.
    :vartype details: list[~azure.mgmt.network.models.ErrorDetails]
    :ivar inner_error: Inner error message.
    :vartype inner_error: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetails]"},
        "inner_error": {"key": "innerError", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorDetails"]] = None,
        inner_error: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword details: Error details.
        :paramtype details: list[~azure.mgmt.network.models.ErrorDetails]
        :keyword inner_error: Inner error message.
        :paramtype inner_error: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error

class ErrorDetails(_serialization.Model):
    """Common error details representation.

    :ivar code: Error code.
    :vartype code: str
    :ivar target: Error target.
    :vartype target: str
    :ivar message: Error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword message: Error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message

class ExpressRouteCircuit(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU.
    :vartype sku: ~azure.mgmt.network.models.ExpressRouteCircuitSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allow_classic_operations: Allow classic operations.
    :vartype allow_classic_operations: bool
    :ivar circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :vartype circuit_provisioning_state: str
    :ivar service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
     "Deprovisioning".
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.models.ServiceProviderProvisioningState
    :ivar authorizations: The list of authorizations.
    :vartype authorizations:
     list[~azure.mgmt.network.models.ExpressRouteCircuitAuthorization]
    :ivar peerings: The list of peerings.
    :vartype peerings: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
    :ivar service_key: The ServiceKey.
    :vartype service_key: str
    :ivar service_provider_notes: The ServiceProviderNotes.
    :vartype service_provider_notes: str
    :ivar service_provider_properties: The ServiceProviderProperties.
    :vartype service_provider_properties:
     ~azure.mgmt.network.models.ExpressRouteCircuitServiceProviderProperties
    :ivar express_route_port: The reference to the ExpressRoutePort resource when the circuit is
     provisioned on an ExpressRoutePort resource.
    :vartype express_route_port: ~azure.mgmt.network.models.SubResource
    :ivar bandwidth_in_gbps: The bandwidth of the circuit when the circuit is provisioned on an
     ExpressRoutePort resource.
    :vartype bandwidth_in_gbps: float
    :ivar stag: The identifier of the circuit traffic. Outer tag for QinQ encapsulation.
    :vartype stag: int
    :ivar provisioning_state: The provisioning state of the express route circuit resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar global_reach_enabled: Flag denoting global reach status.
    :vartype global_reach_enabled: bool
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar authorization_status: The authorization status of the Circuit.
    :vartype authorization_status: str
    :ivar enable_direct_port_rate_limit: Flag denoting rate-limiting status of the ExpressRoute
     direct-port circuit.
    :vartype enable_direct_port_rate_limit: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "stag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "authorization_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ExpressRouteCircuitSku"},
        "etag": {"key": "etag", "type": "str"},
        "allow_classic_operations": {"key": "properties.allowClassicOperations", "type": "bool"},
        "circuit_provisioning_state": {"key": "properties.circuitProvisioningState", "type": "str"},
        "service_provider_provisioning_state": {"key": "properties.serviceProviderProvisioningState", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[ExpressRouteCircuitAuthorization]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "service_key": {"key": "properties.serviceKey", "type": "str"},
        "service_provider_notes": {"key": "properties.serviceProviderNotes", "type": "str"},
        "service_provider_properties": {
            "key": "properties.serviceProviderProperties",
            "type": "ExpressRouteCircuitServiceProviderProperties",
        },
        "express_route_port": {"key": "properties.expressRoutePort", "type": "SubResource"},
        "bandwidth_in_gbps": {"key": "properties.bandwidthInGbps", "type": "float"},
        "stag": {"key": "properties.stag", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "global_reach_enabled": {"key": "properties.globalReachEnabled", "type": "bool"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "authorization_status": {"key": "properties.authorizationStatus", "type": "str"},
        "enable_direct_port_rate_limit": {"key": "properties.enableDirectPortRateLimit", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ExpressRouteCircuitSku"] = None,
        allow_classic_operations: Optional[bool] = None,
        circuit_provisioning_state: Optional[str] = None,
        service_provider_provisioning_state: Optional[Union[str, "_models.ServiceProviderProvisioningState"]] = None,
        authorizations: Optional[List["_models.ExpressRouteCircuitAuthorization"]] = None,
        peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        service_key: Optional[str] = None,
        service_provider_notes: Optional[str] = None,
        service_provider_properties: Optional["_models.ExpressRouteCircuitServiceProviderProperties"] = None,
        express_route_port: Optional["_models.SubResource"] = None,
        bandwidth_in_gbps: Optional[float] = None,
        gateway_manager_etag: Optional[str] = None,
        global_reach_enabled: Optional[bool] = None,
        authorization_key: Optional[str] = None,
        enable_direct_port_rate_limit: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU.
        :paramtype sku: ~azure.mgmt.network.models.ExpressRouteCircuitSku
        :keyword allow_classic_operations: Allow classic operations.
        :paramtype allow_classic_operations: bool
        :keyword circuit_provisioning_state: The CircuitProvisioningState state of the resource.
        :paramtype circuit_provisioning_state: str
        :keyword service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
         resource. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
         "Deprovisioning".
        :paramtype service_provider_provisioning_state: str or
         ~azure.mgmt.network.models.ServiceProviderProvisioningState
        :keyword authorizations: The list of authorizations.
        :paramtype authorizations:
         list[~azure.mgmt.network.models.ExpressRouteCircuitAuthorization]
        :keyword peerings: The list of peerings.
        :paramtype peerings: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
        :keyword service_key: The ServiceKey.
        :paramtype service_key: str
        :keyword service_provider_notes: The ServiceProviderNotes.
        :paramtype service_provider_notes: str
        :keyword service_provider_properties: The ServiceProviderProperties.
        :paramtype service_provider_properties:
         ~azure.mgmt.network.models.ExpressRouteCircuitServiceProviderProperties
        :keyword express_route_port: The reference to the ExpressRoutePort resource when the circuit is
         provisioned on an ExpressRoutePort resource.
        :paramtype express_route_port: ~azure.mgmt.network.models.SubResource
        :keyword bandwidth_in_gbps: The bandwidth of the circuit when the circuit is provisioned on an
         ExpressRoutePort resource.
        :paramtype bandwidth_in_gbps: float
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword global_reach_enabled: Flag denoting global reach status.
        :paramtype global_reach_enabled: bool
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword enable_direct_port_rate_limit: Flag denoting rate-limiting status of the ExpressRoute
         direct-port circuit.
        :paramtype enable_direct_port_rate_limit: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = None
        self.allow_classic_operations = allow_classic_operations
        self.circuit_provisioning_state = circuit_provisioning_state
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.authorizations = authorizations
        self.peerings = peerings
        self.service_key = service_key
        self.service_provider_notes = service_provider_notes
        self.service_provider_properties = service_provider_properties
        self.express_route_port = express_route_port
        self.bandwidth_in_gbps = bandwidth_in_gbps
        self.stag = None
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.global_reach_enabled = global_reach_enabled
        self.authorization_key = authorization_key
        self.authorization_status = None
        self.enable_direct_port_rate_limit = enable_direct_port_rate_limit

class ExpressRouteCircuitArpTable(_serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :ivar age: Entry age in minutes.
    :vartype age: int
    :ivar interface: Interface address.
    :vartype interface: str
    :ivar ip_address: The IP address.
    :vartype ip_address: str
    :ivar mac_address: The MAC address.
    :vartype mac_address: str
    """

    _attribute_map = {
        "age": {"key": "age", "type": "int"},
        "interface": {"key": "interface", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        age: Optional[int] = None,
        interface: Optional[str] = None,
        ip_address: Optional[str] = None,
        mac_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword age: Entry age in minutes.
        :paramtype age: int
        :keyword interface: Interface address.
        :paramtype interface: str
        :keyword ip_address: The IP address.
        :paramtype ip_address: str
        :keyword mac_address: The MAC address.
        :paramtype mac_address: str
        """
        super().__init__(**kwargs)
        self.age = age
        self.interface = interface
        self.ip_address = ip_address
        self.mac_address = mac_address

class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar authorization_use_status: The authorization use status. Known values are: "Available" and
     "InUse".
    :vartype authorization_use_status: str or
     ~azure.mgmt.network.models.AuthorizationUseStatus
    :ivar connection_resource_uri: The reference to the ExpressRoute connection resource using the
     authorization.
    :vartype connection_resource_uri: str
    :ivar provisioning_state: The provisioning state of the authorization resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "connection_resource_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "authorization_use_status": {"key": "properties.authorizationUseStatus", "type": "str"},
        "connection_resource_uri": {"key": "properties.connectionResourceUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        authorization_key: Optional[str] = None,
        authorization_use_status: Optional[Union[str, "_models.AuthorizationUseStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword authorization_key: The authorization key.
        :paramtype authorization_key: str
        :keyword authorization_use_status: The authorization use status. Known values are: "Available"
         and "InUse".
        :paramtype authorization_use_status: str or
         ~azure.mgmt.network.models.AuthorizationUseStatus
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.authorization_key = authorization_key
        self.authorization_use_status = authorization_use_status
        self.connection_resource_uri = None
        self.provisioning_state = None

class ExpressRouteCircuitListResult(_serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :ivar value: A list of ExpressRouteCircuits in a resource group.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuit]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuit]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuit"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ExpressRouteCircuits in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuit]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRouteCircuitPeering(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peering in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar peering_type: The peering type. Known values are: "AzurePublicPeering",
     "AzurePrivatePeering", and "MicrosoftPeering".
    :vartype peering_type: str or ~azure.mgmt.network.models.ExpressRoutePeeringType
    :ivar state: The peering state. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :ivar shared_key: The shared key.
    :vartype shared_key: str
    :ivar vlan_id: The VLAN ID.
    :vartype vlan_id: int
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
    :ivar stats: The peering stats of express route circuit.
    :vartype stats: ~azure.mgmt.network.models.ExpressRouteCircuitStats
    :ivar provisioning_state: The provisioning state of the express route circuit peering resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :ivar route_filter: The reference to the RouteFilter resource.
    :vartype route_filter: ~azure.mgmt.network.models.SubResource
    :ivar ipv6_peering_config: The IPv6 peering configuration.
    :vartype ipv6_peering_config:
     ~azure.mgmt.network.models.Ipv6ExpressRouteCircuitPeeringConfig
    :ivar express_route_connection: The ExpressRoute connection.
    :vartype express_route_connection:
     ~azure.mgmt.network.models.ExpressRouteConnectionId
    :ivar connections: The list of circuit connections associated with Azure Private Peering for
     this circuit.
    :vartype connections:
     list[~azure.mgmt.network.models.ExpressRouteCircuitConnection]
    :ivar peered_connections: The list of peered circuit connections associated with Azure Private
     Peering for this circuit.
    :vartype peered_connections:
     list[~azure.mgmt.network.models.PeerExpressRouteCircuitConnection]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "last_modified_by": {"readonly": True},
        "peered_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "peering_type": {"key": "properties.peeringType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_asn": {"key": "properties.azureASN", "type": "int"},
        "peer_asn": {"key": "properties.peerASN", "type": "int"},
        "primary_peer_address_prefix": {"key": "properties.primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "properties.secondaryPeerAddressPrefix", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "microsoft_peering_config": {
            "key": "properties.microsoftPeeringConfig",
            "type": "ExpressRouteCircuitPeeringConfig",
        },
        "stats": {"key": "properties.stats", "type": "ExpressRouteCircuitStats"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "str"},
        "route_filter": {"key": "properties.routeFilter", "type": "SubResource"},
        "ipv6_peering_config": {"key": "properties.ipv6PeeringConfig", "type": "Ipv6ExpressRouteCircuitPeeringConfig"},
        "express_route_connection": {"key": "properties.expressRouteConnection", "type": "ExpressRouteConnectionId"},
        "connections": {"key": "properties.connections", "type": "[ExpressRouteCircuitConnection]"},
        "peered_connections": {"key": "properties.peeredConnections", "type": "[PeerExpressRouteCircuitConnection]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peering_type: Optional[Union[str, "_models.ExpressRoutePeeringType"]] = None,
        state: Optional[Union[str, "_models.ExpressRoutePeeringState"]] = None,
        azure_asn: Optional[int] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        primary_azure_port: Optional[str] = None,
        secondary_azure_port: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        stats: Optional["_models.ExpressRouteCircuitStats"] = None,
        gateway_manager_etag: Optional[str] = None,
        route_filter: Optional["_models.SubResource"] = None,
        ipv6_peering_config: Optional["_models.Ipv6ExpressRouteCircuitPeeringConfig"] = None,
        express_route_connection: Optional["_models.ExpressRouteConnectionId"] = None,
        connections: Optional[List["_models.ExpressRouteCircuitConnection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword peering_type: The peering type. Known values are: "AzurePublicPeering",
         "AzurePrivatePeering", and "MicrosoftPeering".
        :paramtype peering_type: str or ~azure.mgmt.network.models.ExpressRoutePeeringType
        :keyword state: The peering state. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.models.ExpressRoutePeeringState
        :keyword azure_asn: The Azure ASN.
        :paramtype azure_asn: int
        :keyword peer_asn: The peer ASN.
        :paramtype peer_asn: int
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword primary_azure_port: The primary port.
        :paramtype primary_azure_port: str
        :keyword secondary_azure_port: The secondary port.
        :paramtype secondary_azure_port: str
        :keyword shared_key: The shared key.
        :paramtype shared_key: str
        :keyword vlan_id: The VLAN ID.
        :paramtype vlan_id: int
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
        :keyword stats: The peering stats of express route circuit.
        :paramtype stats: ~azure.mgmt.network.models.ExpressRouteCircuitStats
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword route_filter: The reference to the RouteFilter resource.
        :paramtype route_filter: ~azure.mgmt.network.models.SubResource
        :keyword ipv6_peering_config: The IPv6 peering configuration.
        :paramtype ipv6_peering_config:
         ~azure.mgmt.network.models.Ipv6ExpressRouteCircuitPeeringConfig
        :keyword express_route_connection: The ExpressRoute connection.
        :paramtype express_route_connection:
         ~azure.mgmt.network.models.ExpressRouteConnectionId
        :keyword connections: The list of circuit connections associated with Azure Private Peering for
         this circuit.
        :paramtype connections:
         list[~azure.mgmt.network.models.ExpressRouteCircuitConnection]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = azure_asn
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = primary_azure_port
        self.secondary_azure_port = secondary_azure_port
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.stats = stats
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by = None
        self.route_filter = route_filter
        self.ipv6_peering_config = ipv6_peering_config
        self.express_route_connection = express_route_connection
        self.connections = connections
        self.peered_connections = None

class ExpressRouteCircuitPeeringConfig(_serialization.Model):
    """Specifies the peering configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar advertised_public_prefixes: The reference to AdvertisedPublicPrefixes.
    :vartype advertised_public_prefixes: list[str]
    :ivar advertised_communities: The communities of bgp peering. Specified for microsoft peering.
    :vartype advertised_communities: list[str]
    :ivar advertised_public_prefixes_state: The advertised public prefix state of the Peering
     resource. Known values are: "NotConfigured", "Configuring", "Configured", and
     "ValidationNeeded".
    :vartype advertised_public_prefixes_state: str or
     ~azure.mgmt.network.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :ivar legacy_mode: The legacy mode of the peering.
    :vartype legacy_mode: int
    :ivar customer_asn: The CustomerASN of the peering.
    :vartype customer_asn: int
    :ivar routing_registry_name: The RoutingRegistryName of the configuration.
    :vartype routing_registry_name: str
    """

    _validation = {
        "advertised_public_prefixes_state": {"readonly": True},
    }

    _attribute_map = {
        "advertised_public_prefixes": {"key": "advertisedPublicPrefixes", "type": "[str]"},
        "advertised_communities": {"key": "advertisedCommunities", "type": "[str]"},
        "advertised_public_prefixes_state": {"key": "advertisedPublicPrefixesState", "type": "str"},
        "legacy_mode": {"key": "legacyMode", "type": "int"},
        "customer_asn": {"key": "customerASN", "type": "int"},
        "routing_registry_name": {"key": "routingRegistryName", "type": "str"},
    }

    def __init__(
        self,
        *,
        advertised_public_prefixes: Optional[List[str]] = None,
        advertised_communities: Optional[List[str]] = None,
        legacy_mode: Optional[int] = None,
        customer_asn: Optional[int] = None,
        routing_registry_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword advertised_public_prefixes: The reference to AdvertisedPublicPrefixes.
        :paramtype advertised_public_prefixes: list[str]
        :keyword advertised_communities: The communities of bgp peering. Specified for microsoft
         peering.
        :paramtype advertised_communities: list[str]
        :keyword legacy_mode: The legacy mode of the peering.
        :paramtype legacy_mode: int
        :keyword customer_asn: The CustomerASN of the peering.
        :paramtype customer_asn: int
        :keyword routing_registry_name: The RoutingRegistryName of the configuration.
        :paramtype routing_registry_name: str
        """
        super().__init__(**kwargs)
        self.advertised_public_prefixes = advertised_public_prefixes
        self.advertised_communities = advertised_communities
        self.advertised_public_prefixes_state = None
        self.legacy_mode = legacy_mode
        self.customer_asn = customer_asn
        self.routing_registry_name = routing_registry_name

class ExpressRouteCircuitPeeringListResult(_serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an
    ExpressRouteCircuit.

    :ivar value: The peerings in an express route circuit.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The peerings in an express route circuit.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRouteCircuitRoutesTable(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar network: IP address of a network entity.
    :vartype network: str
    :ivar next_hop: NextHop address.
    :vartype next_hop: str
    :ivar loc_prf: Local preference value as set with the set local-preference route-map
     configuration command.
    :vartype loc_prf: str
    :ivar weight: Route Weight.
    :vartype weight: int
    :ivar path: Autonomous system paths to the destination network.
    :vartype path: str
    """

    _attribute_map = {
        "network": {"key": "network", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "loc_prf": {"key": "locPrf", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        network: Optional[str] = None,
        next_hop: Optional[str] = None,
        loc_prf: Optional[str] = None,
        weight: Optional[int] = None,
        path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network: IP address of a network entity.
        :paramtype network: str
        :keyword next_hop: NextHop address.
        :paramtype next_hop: str
        :keyword loc_prf: Local preference value as set with the set local-preference route-map
         configuration command.
        :paramtype loc_prf: str
        :keyword weight: Route Weight.
        :paramtype weight: int
        :keyword path: Autonomous system paths to the destination network.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.network = network
        self.next_hop = next_hop
        self.loc_prf = loc_prf
        self.weight = weight
        self.path = path

class ExpressRouteCircuitServiceProviderProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :ivar service_provider_name: The serviceProviderName.
    :vartype service_provider_name: str
    :ivar peering_location: The peering location.
    :vartype peering_location: str
    :ivar bandwidth_in_mbps: The BandwidthInMbps.
    :vartype bandwidth_in_mbps: int
    """

    _attribute_map = {
        "service_provider_name": {"key": "serviceProviderName", "type": "str"},
        "peering_location": {"key": "peeringLocation", "type": "str"},
        "bandwidth_in_mbps": {"key": "bandwidthInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_provider_name: Optional[str] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_provider_name: The serviceProviderName.
        :paramtype service_provider_name: str
        :keyword peering_location: The peering location.
        :paramtype peering_location: str
        :keyword bandwidth_in_mbps: The BandwidthInMbps.
        :paramtype bandwidth_in_mbps: int
        """
        super().__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps

class ExpressRouteCircuitSku(_serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar tier: The tier of the SKU. Known values are: "Standard", "Premium", "Basic", and "Local".
    :vartype tier: str or ~azure.mgmt.network.models.ExpressRouteCircuitSkuTier
    :ivar family: The family of the SKU. Known values are: "UnlimitedData" and "MeteredData".
    :vartype family: str or ~azure.mgmt.network.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "_models.ExpressRouteCircuitSkuTier"]] = None,
        family: Optional[Union[str, "_models.ExpressRouteCircuitSkuFamily"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU.
        :paramtype name: str
        :keyword tier: The tier of the SKU. Known values are: "Standard", "Premium", "Basic", and
         "Local".
        :paramtype tier: str or ~azure.mgmt.network.models.ExpressRouteCircuitSkuTier
        :keyword family: The family of the SKU. Known values are: "UnlimitedData" and "MeteredData".
        :paramtype family: str or ~azure.mgmt.network.models.ExpressRouteCircuitSkuFamily
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family

class ExpressRouteCircuitStats(_serialization.Model):
    """Contains stats associated with the peering.

    :ivar primarybytes_in: The Primary BytesIn of the peering.
    :vartype primarybytes_in: int
    :ivar primarybytes_out: The primary BytesOut of the peering.
    :vartype primarybytes_out: int
    :ivar secondarybytes_in: The secondary BytesIn of the peering.
    :vartype secondarybytes_in: int
    :ivar secondarybytes_out: The secondary BytesOut of the peering.
    :vartype secondarybytes_out: int
    """

    _attribute_map = {
        "primarybytes_in": {"key": "primarybytesIn", "type": "int"},
        "primarybytes_out": {"key": "primarybytesOut", "type": "int"},
        "secondarybytes_in": {"key": "secondarybytesIn", "type": "int"},
        "secondarybytes_out": {"key": "secondarybytesOut", "type": "int"},
    }

    def __init__(
        self,
        *,
        primarybytes_in: Optional[int] = None,
        primarybytes_out: Optional[int] = None,
        secondarybytes_in: Optional[int] = None,
        secondarybytes_out: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primarybytes_in: The Primary BytesIn of the peering.
        :paramtype primarybytes_in: int
        :keyword primarybytes_out: The primary BytesOut of the peering.
        :paramtype primarybytes_out: int
        :keyword secondarybytes_in: The secondary BytesIn of the peering.
        :paramtype secondarybytes_in: int
        :keyword secondarybytes_out: The secondary BytesOut of the peering.
        :paramtype secondarybytes_out: int
        """
        super().__init__(**kwargs)
        self.primarybytes_in = primarybytes_in
        self.primarybytes_out = primarybytes_out
        self.secondarybytes_in = secondarybytes_in
        self.secondarybytes_out = secondarybytes_out

class ExpressRouteCircuitsArpTableListResult(_serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :ivar value: A list of the ARP tables.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitArpTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitArpTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitArpTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of the ARP tables.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitArpTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRouteCircuitsRoutesTableListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: The list of routes table.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitRoutesTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitRoutesTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of routes table.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitRoutesTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRouteCircuitsStatsListResult(_serialization.Model):
    """Response for ListStats from Express Route Circuits Api service call.

    :ivar value: Gets List of Stats.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitStats]
    :ivar next_link: Gets the URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitStats]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitStats"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets List of Stats.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitStats]
        :keyword next_link: Gets the URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar peering_locations: A list of peering locations.
    :vartype peering_locations: list[str]
    :ivar bandwidths_offered: A list of bandwidths offered.
    :vartype bandwidths_offered:
     list[~azure.mgmt.network.models.ExpressRouteServiceProviderBandwidthsOffered]
    :ivar provisioning_state: The provisioning state of the express route service provider
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "peering_locations": {"key": "properties.peeringLocations", "type": "[str]"},
        "bandwidths_offered": {
            "key": "properties.bandwidthsOffered",
            "type": "[ExpressRouteServiceProviderBandwidthsOffered]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        peering_locations: Optional[List[str]] = None,
        bandwidths_offered: Optional[List["_models.ExpressRouteServiceProviderBandwidthsOffered"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword peering_locations: A list of peering locations.
        :paramtype peering_locations: list[str]
        :keyword bandwidths_offered: A list of bandwidths offered.
        :paramtype bandwidths_offered:
         list[~azure.mgmt.network.models.ExpressRouteServiceProviderBandwidthsOffered]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_locations = peering_locations
        self.bandwidths_offered = bandwidths_offered
        self.provisioning_state = None

class ExpressRouteServiceProviderBandwidthsOffered(_serialization.Model):  # pylint: disable=name-too-long
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :ivar offer_name: The OfferName.
    :vartype offer_name: str
    :ivar value_in_mbps: The ValueInMbps.
    :vartype value_in_mbps: int
    """

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_mbps": {"key": "valueInMbps", "type": "int"},
    }

    def __init__(self, *, offer_name: Optional[str] = None, value_in_mbps: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword offer_name: The OfferName.
        :paramtype offer_name: str
        :keyword value_in_mbps: The ValueInMbps.
        :paramtype value_in_mbps: int
        """
        super().__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps

class ExpressRouteServiceProviderListResult(_serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :ivar value: A list of ExpressRouteResourceProvider resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteServiceProvider]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteServiceProvider]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteServiceProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ExpressRouteResourceProvider resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteServiceProvider]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class FrontendIPConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """Frontend IP address of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of frontend IP
     configurations used by the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar inbound_nat_rules: An array of references to inbound rules that use this frontend IP.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar inbound_nat_pools: An array of references to inbound pools that use this frontend IP.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.models.SubResource]
    :ivar outbound_rules: An array of references to outbound rules that use this frontend IP.
    :vartype outbound_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar load_balancing_rules: An array of references to load balancing rules that use this
     frontend IP.
    :vartype load_balancing_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The Private IP allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.models.IPAllocationMethod
    :ivar private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6. Default
     is taken as IPv4. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
    :ivar subnet: The reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar public_ip_address: The reference to the Public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
    :ivar public_ip_prefix: The reference to the Public IP Prefix resource.
    :vartype public_ip_prefix: ~azure.mgmt.network.models.SubResource
    :ivar gateway_load_balancer: The reference to gateway load balancer frontend IP.
    :vartype gateway_load_balancer: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "inbound_nat_rules": {"readonly": True},
        "inbound_nat_pools": {"readonly": True},
        "outbound_rules": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[SubResource]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[SubResource]"},
        "outbound_rules": {"key": "properties.outboundRules", "type": "[SubResource]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "gateway_load_balancer": {"key": "properties.gatewayLoadBalancer", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        zones: Optional[List[str]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        gateway_load_balancer: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of frontend IP
         configurations used by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The Private IP allocation method. Known values are:
         "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.models.IPAllocationMethod
        :keyword private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6.
         Default is taken as IPv4. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
        :keyword subnet: The reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        :keyword public_ip_address: The reference to the Public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
        :keyword public_ip_prefix: The reference to the Public IP Prefix resource.
        :paramtype public_ip_prefix: ~azure.mgmt.network.models.SubResource
        :keyword gateway_load_balancer: The reference to gateway load balancer frontend IP.
        :paramtype gateway_load_balancer: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.zones = zones
        self.inbound_nat_rules = None
        self.inbound_nat_pools = None
        self.outbound_rules = None
        self.load_balancing_rules = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.public_ip_prefix = public_ip_prefix
        self.gateway_load_balancer = gateway_load_balancer
        self.provisioning_state = None

class IPConfiguration(SubResource):
    """IP configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.models.IPAllocationMethod
    :ivar subnet: The reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar public_ip_address: The reference to the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
    :ivar provisioning_state: The provisioning state of the IP configuration resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.models.IPAllocationMethod
        :keyword subnet: The reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        :keyword public_ip_address: The reference to the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None

class InboundNatPool(SubResource):  # pylint: disable=too-many-instance-attributes
    """Inbound NAT pool of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of inbound NAT pools used by
     the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
    :ivar protocol: The reference to the transport protocol used by the inbound NAT pool. Known
     values are: "Udp", "Tcp", and "All".
    :vartype protocol: str or ~azure.mgmt.network.models.TransportProtocol
    :ivar frontend_port_range_start: The first port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65534.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The last port number in the range of external ports that will be
     used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :vartype frontend_port_range_end: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar provisioning_state: The provisioning state of the inbound NAT pool resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port_range_start": {"key": "properties.frontendPortRangeStart", "type": "int"},
        "frontend_port_range_end": {"key": "properties.frontendPortRangeEnd", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        enable_tcp_reset: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of inbound NAT pools used
         by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
        :keyword protocol: The reference to the transport protocol used by the inbound NAT pool. Known
         values are: "Udp", "Tcp", and "All".
        :paramtype protocol: str or ~azure.mgmt.network.models.TransportProtocol
        :keyword frontend_port_range_start: The first port number in the range of external ports that
         will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
         range between 1 and 65534.
        :paramtype frontend_port_range_start: int
        :keyword frontend_port_range_end: The last port number in the range of external ports that will
         be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
         between 1 and 65535.
        :paramtype frontend_port_range_end: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 1 and 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.protocol = protocol
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.provisioning_state = None

class InboundNatRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Inbound NAT rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of inbound NAT rules used by
     the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backend IP.
    :vartype backend_ip_configuration:
     ~azure.mgmt.network.models.NetworkInterfaceIPConfiguration
    :ivar protocol: The reference to the transport protocol used by the load balancing rule. Known
     values are: "Udp", "Tcp", and "All".
    :vartype protocol: str or ~azure.mgmt.network.models.TransportProtocol
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :vartype frontend_port: int
    :ivar backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar frontend_port_range_start: The port range start for the external endpoint. This property
     is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule
     port mappings will be created for each backend address from BackendAddressPool. Acceptable
     values range from 1 to 65534.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The port range end for the external endpoint. This property is
     used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule
     port mappings will be created for each backend address from BackendAddressPool. Acceptable
     values range from 1 to 65534.
    :vartype frontend_port_range_end: int
    :ivar backend_address_pool: A reference to backendAddressPool resource.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the inbound NAT rule resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "backend_ip_configuration": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_ip_configuration": {
            "key": "properties.backendIPConfiguration",
            "type": "NetworkInterfaceIPConfiguration",
        },
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "frontend_port_range_start": {"key": "properties.frontendPortRangeStart", "type": "int"},
        "frontend_port_range_end": {"key": "properties.frontendPortRangeEnd", "type": "int"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        enable_tcp_reset: Optional[bool] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of inbound NAT rules used
         by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
        :keyword protocol: The reference to the transport protocol used by the load balancing rule.
         Known values are: "Udp", "Tcp", and "All".
        :paramtype protocol: str or ~azure.mgmt.network.models.TransportProtocol
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :paramtype frontend_port: int
        :keyword backend_port: The port used for the internal endpoint. Acceptable values range from 1
         to 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        :keyword frontend_port_range_start: The port range start for the external endpoint. This
         property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound
         NAT rule port mappings will be created for each backend address from BackendAddressPool.
         Acceptable values range from 1 to 65534.
        :paramtype frontend_port_range_start: int
        :keyword frontend_port_range_end: The port range end for the external endpoint. This property
         is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT
         rule port mappings will be created for each backend address from BackendAddressPool. Acceptable
         values range from 1 to 65534.
        :paramtype frontend_port_range_end: int
        :keyword backend_address_pool: A reference to backendAddressPool resource.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_ip_configuration = None
        self.protocol = protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = None

class LoadBalancer(Resource):  # pylint: disable=too-many-instance-attributes
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the load balancer.
    :vartype extended_location: ~azure.mgmt.network.models.ExtendedLocation
    :ivar sku: The load balancer SKU.
    :vartype sku: ~azure.mgmt.network.models.LoadBalancerSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configurations: Object representing the frontend IPs to be used for the load
     balancer.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.models.FrontendIPConfiguration]
    :ivar backend_address_pools: Collection of backend address pools used by a load balancer.
    :vartype backend_address_pools: list[~azure.mgmt.network.models.BackendAddressPool]
    :ivar load_balancing_rules: Object collection representing the load balancing rules Gets the
     provisioning.
    :vartype load_balancing_rules: list[~azure.mgmt.network.models.LoadBalancingRule]
    :ivar probes: Collection of probe objects used in the load balancer.
    :vartype probes: list[~azure.mgmt.network.models.Probe]
    :ivar inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
     inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
     pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
     associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
     reference individual inbound NAT rules.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.models.InboundNatRule]
    :ivar inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
     port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
     each NIC associated with the Load Balancer using an external port from this range. Defining an
     Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules.
     Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an inbound NAT pool. They have to reference
     individual inbound NAT rules.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.models.InboundNatPool]
    :ivar outbound_rules: The outbound rules.
    :vartype outbound_rules: list[~azure.mgmt.network.models.OutboundRule]
    :ivar resource_guid: The resource GUID property of the load balancer resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the load balancer resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "sku": {"key": "sku", "type": "LoadBalancerSku"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[FrontendIPConfiguration]",
        },
        "backend_address_pools": {"key": "properties.backendAddressPools", "type": "[BackendAddressPool]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[LoadBalancingRule]"},
        "probes": {"key": "properties.probes", "type": "[Probe]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[InboundNatRule]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[InboundNatPool]"},
        "outbound_rules": {"key": "properties.outboundRules", "type": "[OutboundRule]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        sku: Optional["_models.LoadBalancerSku"] = None,
        frontend_ip_configurations: Optional[List["_models.FrontendIPConfiguration"]] = None,
        backend_address_pools: Optional[List["_models.BackendAddressPool"]] = None,
        load_balancing_rules: Optional[List["_models.LoadBalancingRule"]] = None,
        probes: Optional[List["_models.Probe"]] = None,
        inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None,
        inbound_nat_pools: Optional[List["_models.InboundNatPool"]] = None,
        outbound_rules: Optional[List["_models.OutboundRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the load balancer.
        :paramtype extended_location: ~azure.mgmt.network.models.ExtendedLocation
        :keyword sku: The load balancer SKU.
        :paramtype sku: ~azure.mgmt.network.models.LoadBalancerSku
        :keyword frontend_ip_configurations: Object representing the frontend IPs to be used for the
         load balancer.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.models.FrontendIPConfiguration]
        :keyword backend_address_pools: Collection of backend address pools used by a load balancer.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.models.BackendAddressPool]
        :keyword load_balancing_rules: Object collection representing the load balancing rules Gets the
         provisioning.
        :paramtype load_balancing_rules: list[~azure.mgmt.network.models.LoadBalancingRule]
        :keyword probes: Collection of probe objects used in the load balancer.
        :paramtype probes: list[~azure.mgmt.network.models.Probe]
        :keyword inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
         inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
         pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
         associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
         reference individual inbound NAT rules.
        :paramtype inbound_nat_rules: list[~azure.mgmt.network.models.InboundNatRule]
        :keyword inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
         port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
         each NIC associated with the Load Balancer using an external port from this range. Defining an
         Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules.
         Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
         individual virtual machines cannot reference an inbound NAT pool. They have to reference
         individual inbound NAT rules.
        :paramtype inbound_nat_pools: list[~azure.mgmt.network.models.InboundNatPool]
        :keyword outbound_rules: The outbound rules.
        :paramtype outbound_rules: list[~azure.mgmt.network.models.OutboundRule]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.sku = sku
        self.etag = None
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_rules = outbound_rules
        self.resource_guid = None
        self.provisioning_state = None

class LoadBalancerListResult(_serialization.Model):
    """Response for ListLoadBalancers API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancers in a resource group.
    :vartype value: list[~azure.mgmt.network.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancer"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of load balancers in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.LoadBalancer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class LoadBalancingRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """A load balancing rule for a load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of load balancing rules used
     by the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
    :ivar backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar backend_address_pools: An array of references to pool of DIPs.
    :vartype backend_address_pools: list[~azure.mgmt.network.models.SubResource]
    :ivar probe: The reference to the load balancer probe used by the load balancing rule.
    :vartype probe: ~azure.mgmt.network.models.SubResource
    :ivar protocol: The reference to the transport protocol used by the load balancing rule. Known
     values are: "Udp", "Tcp", and "All".
    :vartype protocol: str or ~azure.mgmt.network.models.TransportProtocol
    :ivar load_distribution: The load distribution policy for this rule. Known values are:
     "Default", "SourceIP", and "SourceIPProtocol".
    :vartype load_distribution: str or ~azure.mgmt.network.models.LoadDistribution
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0
     enables "Any Port".
    :vartype frontend_port: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 0 and 65535. Note that value 0 enables "Any Port".
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the
     publicIP address specified in the frontend of the load balancing rule.
    :vartype disable_outbound_snat: bool
    :ivar provisioning_state: The provisioning state of the load balancing rule resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_address_pools": {"key": "properties.backendAddressPools", "type": "[SubResource]"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "load_distribution": {"key": "properties.loadDistribution", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "disable_outbound_snat": {"key": "properties.disableOutboundSnat", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_address_pools: Optional[List["_models.SubResource"]] = None,
        probe: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        load_distribution: Optional[Union[str, "_models.LoadDistribution"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        enable_tcp_reset: Optional[bool] = None,
        disable_outbound_snat: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of load balancing rules
         used by the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.models.SubResource
        :keyword backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword backend_address_pools: An array of references to pool of DIPs.
        :paramtype backend_address_pools: list[~azure.mgmt.network.models.SubResource]
        :keyword probe: The reference to the load balancer probe used by the load balancing rule.
        :paramtype probe: ~azure.mgmt.network.models.SubResource
        :keyword protocol: The reference to the transport protocol used by the load balancing rule.
         Known values are: "Udp", "Tcp", and "All".
        :paramtype protocol: str or ~azure.mgmt.network.models.TransportProtocol
        :keyword load_distribution: The load distribution policy for this rule. Known values are:
         "Default", "SourceIP", and "SourceIPProtocol".
        :paramtype load_distribution: str or ~azure.mgmt.network.models.LoadDistribution
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0
         enables "Any Port".
        :paramtype frontend_port: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 0 and 65535. Note that value 0 enables "Any Port".
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        :keyword disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the
         publicIP address specified in the frontend of the load balancing rule.
        :paramtype disable_outbound_snat: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_address_pool = backend_address_pool
        self.backend_address_pools = backend_address_pools
        self.probe = probe
        self.protocol = protocol
        self.load_distribution = load_distribution
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.disable_outbound_snat = disable_outbound_snat
        self.provisioning_state = None

class LocalNetworkGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar local_network_address_space: Local network site address space.
    :vartype local_network_address_space: ~azure.mgmt.network.models.AddressSpace
    :ivar gateway_ip_address: IP address of local network gateway.
    :vartype gateway_ip_address: str
    :ivar fqdn: FQDN of local network gateway.
    :vartype fqdn: str
    :ivar bgp_settings: Local network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.models.BgpSettings
    :ivar resource_guid: The resource GUID property of the local network gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the local network gateway resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "local_network_address_space": {"key": "properties.localNetworkAddressSpace", "type": "AddressSpace"},
        "gateway_ip_address": {"key": "properties.gatewayIpAddress", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        local_network_address_space: Optional["_models.AddressSpace"] = None,
        gateway_ip_address: Optional[str] = None,
        fqdn: Optional[str] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword local_network_address_space: Local network site address space.
        :paramtype local_network_address_space: ~azure.mgmt.network.models.AddressSpace
        :keyword gateway_ip_address: IP address of local network gateway.
        :paramtype gateway_ip_address: str
        :keyword fqdn: FQDN of local network gateway.
        :paramtype fqdn: str
        :keyword bgp_settings: Local network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.models.BgpSettings
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.local_network_address_space = local_network_address_space
        self.gateway_ip_address = gateway_ip_address
        self.fqdn = fqdn
        self.bgp_settings = bgp_settings
        self.resource_guid = None
        self.provisioning_state = None

class LocalNetworkGatewayListResult(_serialization.Model):
    """Response for ListLocalNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of local network gateways that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.models.LocalNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LocalNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LocalNetworkGateway"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of local network gateways that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.LocalNetworkGateway]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class NetworkInterface(Resource):  # pylint: disable=too-many-instance-attributes
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the network interface.
    :vartype extended_location: ~azure.mgmt.network.models.ExtendedLocation
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_machine: The reference to a virtual machine.
    :vartype virtual_machine: ~azure.mgmt.network.models.SubResource
    :ivar network_security_group: The reference to the NetworkSecurityGroup resource.
    :vartype network_security_group: ~azure.mgmt.network.models.NetworkSecurityGroup
    :ivar private_endpoint: A reference to the private endpoint to which the network interface is
     linked.
    :vartype private_endpoint: ~azure.mgmt.network.models.PrivateEndpoint
    :ivar ip_configurations: A list of IPConfigurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.network.models.NetworkInterfaceIPConfiguration]
    :ivar tap_configurations: A list of TapConfigurations of the network interface.
    :vartype tap_configurations:
     list[~azure.mgmt.network.models.NetworkInterfaceTapConfiguration]
    :ivar dns_settings: The DNS settings in network interface.
    :vartype dns_settings: ~azure.mgmt.network.models.NetworkInterfaceDnsSettings
    :ivar mac_address: The MAC address of the network interface.
    :vartype mac_address: str
    :ivar primary: Whether this is a primary network interface on a virtual machine.
    :vartype primary: bool
    :ivar vnet_encryption_supported: Whether the virtual machine this nic is attached to supports
     encryption.
    :vartype vnet_encryption_supported: bool
    :ivar enable_accelerated_networking: If the network interface is configured for accelerated
     networking. Not applicable to VM sizes which require accelerated networking.
    :vartype enable_accelerated_networking: bool
    :ivar disable_tcp_state_tracking: Indicates whether to disable tcp state tracking.
    :vartype disable_tcp_state_tracking: bool
    :ivar enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
     interface.
    :vartype enable_ip_forwarding: bool
    :ivar hosted_workloads: A list of references to linked BareMetal resources.
    :vartype hosted_workloads: list[str]
    :ivar dscp_configuration: A reference to the dscp configuration to which the network interface
     is linked.
    :vartype dscp_configuration: ~azure.mgmt.network.models.SubResource
    :ivar resource_guid: The resource GUID property of the network interface resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network interface resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar workload_type: WorkloadType of the NetworkInterface for BareMetal resources.
    :vartype workload_type: str
    :ivar nic_type: Type of Network Interface resource. Known values are: "Standard" and "Elastic".
    :vartype nic_type: str or ~azure.mgmt.network.models.NetworkInterfaceNicType
    :ivar private_link_service: Privatelinkservice of the network interface resource.
    :vartype private_link_service: ~azure.mgmt.network.models.PrivateLinkService
    :ivar migration_phase: Migration phase of Network Interface resource. Known values are: "None",
     "Prepare", "Commit", "Abort", and "Committed".
    :vartype migration_phase: str or
     ~azure.mgmt.network.models.NetworkInterfaceMigrationPhase
    :ivar auxiliary_mode: Auxiliary mode of Network Interface resource. Known values are: "None",
     "MaxConnections", "Floating", and "AcceleratedConnections".
    :vartype auxiliary_mode: str or
     ~azure.mgmt.network.models.NetworkInterfaceAuxiliaryMode
    :ivar auxiliary_sku: Auxiliary sku of Network Interface resource. Known values are: "None",
     "A1", "A2", "A4", and "A8".
    :vartype auxiliary_sku: str or
     ~azure.mgmt.network.models.NetworkInterfaceAuxiliarySku
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "virtual_machine": {"readonly": True},
        "private_endpoint": {"readonly": True},
        "tap_configurations": {"readonly": True},
        "mac_address": {"readonly": True},
        "primary": {"readonly": True},
        "vnet_encryption_supported": {"readonly": True},
        "hosted_workloads": {"readonly": True},
        "dscp_configuration": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_machine": {"key": "properties.virtualMachine", "type": "SubResource"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "NetworkSecurityGroup"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[NetworkInterfaceIPConfiguration]"},
        "tap_configurations": {"key": "properties.tapConfigurations", "type": "[NetworkInterfaceTapConfiguration]"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "NetworkInterfaceDnsSettings"},
        "mac_address": {"key": "properties.macAddress", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "vnet_encryption_supported": {"key": "properties.vnetEncryptionSupported", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "disable_tcp_state_tracking": {"key": "properties.disableTcpStateTracking", "type": "bool"},
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "hosted_workloads": {"key": "properties.hostedWorkloads", "type": "[str]"},
        "dscp_configuration": {"key": "properties.dscpConfiguration", "type": "SubResource"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "workload_type": {"key": "properties.workloadType", "type": "str"},
        "nic_type": {"key": "properties.nicType", "type": "str"},
        "private_link_service": {"key": "properties.privateLinkService", "type": "PrivateLinkService"},
        "migration_phase": {"key": "properties.migrationPhase", "type": "str"},
        "auxiliary_mode": {"key": "properties.auxiliaryMode", "type": "str"},
        "auxiliary_sku": {"key": "properties.auxiliarySku", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        network_security_group: Optional["_models.NetworkSecurityGroup"] = None,
        ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        dns_settings: Optional["_models.NetworkInterfaceDnsSettings"] = None,
        enable_accelerated_networking: Optional[bool] = None,
        disable_tcp_state_tracking: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        workload_type: Optional[str] = None,
        nic_type: Optional[Union[str, "_models.NetworkInterfaceNicType"]] = None,
        private_link_service: Optional["_models.PrivateLinkService"] = None,
        migration_phase: Optional[Union[str, "_models.NetworkInterfaceMigrationPhase"]] = None,
        auxiliary_mode: Optional[Union[str, "_models.NetworkInterfaceAuxiliaryMode"]] = None,
        auxiliary_sku: Optional[Union[str, "_models.NetworkInterfaceAuxiliarySku"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the network interface.
        :paramtype extended_location: ~azure.mgmt.network.models.ExtendedLocation
        :keyword network_security_group: The reference to the NetworkSecurityGroup resource.
        :paramtype network_security_group: ~azure.mgmt.network.models.NetworkSecurityGroup
        :keyword ip_configurations: A list of IPConfigurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.models.NetworkInterfaceIPConfiguration]
        :keyword dns_settings: The DNS settings in network interface.
        :paramtype dns_settings: ~azure.mgmt.network.models.NetworkInterfaceDnsSettings
        :keyword enable_accelerated_networking: If the network interface is configured for accelerated
         networking. Not applicable to VM sizes which require accelerated networking.
        :paramtype enable_accelerated_networking: bool
        :keyword disable_tcp_state_tracking: Indicates whether to disable tcp state tracking.
        :paramtype disable_tcp_state_tracking: bool
        :keyword enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
         interface.
        :paramtype enable_ip_forwarding: bool
        :keyword workload_type: WorkloadType of the NetworkInterface for BareMetal resources.
        :paramtype workload_type: str
        :keyword nic_type: Type of Network Interface resource. Known values are: "Standard" and
         "Elastic".
        :paramtype nic_type: str or ~azure.mgmt.network.models.NetworkInterfaceNicType
        :keyword private_link_service: Privatelinkservice of the network interface resource.
        :paramtype private_link_service: ~azure.mgmt.network.models.PrivateLinkService
        :keyword migration_phase: Migration phase of Network Interface resource. Known values are:
         "None", "Prepare", "Commit", "Abort", and "Committed".
        :paramtype migration_phase: str or
         ~azure.mgmt.network.models.NetworkInterfaceMigrationPhase
        :keyword auxiliary_mode: Auxiliary mode of Network Interface resource. Known values are:
         "None", "MaxConnections", "Floating", and "AcceleratedConnections".
        :paramtype auxiliary_mode: str or
         ~azure.mgmt.network.models.NetworkInterfaceAuxiliaryMode
        :keyword auxiliary_sku: Auxiliary sku of Network Interface resource. Known values are: "None",
         "A1", "A2", "A4", and "A8".
        :paramtype auxiliary_sku: str or
         ~azure.mgmt.network.models.NetworkInterfaceAuxiliarySku
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.etag = None
        self.virtual_machine = None
        self.network_security_group = network_security_group
        self.private_endpoint = None
        self.ip_configurations = ip_configurations
        self.tap_configurations = None
        self.dns_settings = dns_settings
        self.mac_address = None
        self.primary = None
        self.vnet_encryption_supported = None
        self.enable_accelerated_networking = enable_accelerated_networking
        self.disable_tcp_state_tracking = disable_tcp_state_tracking
        self.enable_ip_forwarding = enable_ip_forwarding
        self.hosted_workloads = None
        self.dscp_configuration = None
        self.resource_guid = None
        self.provisioning_state = None
        self.workload_type = workload_type
        self.nic_type = nic_type
        self.private_link_service = private_link_service
        self.migration_phase = migration_phase
        self.auxiliary_mode = auxiliary_mode
        self.auxiliary_sku = auxiliary_sku

class NetworkInterfaceDnsSettings(_serialization.Model):
    """DNS settings of a network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure
     provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be
     the only value in dnsServers collection.
    :vartype dns_servers: list[str]
    :ivar applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
     this list will have the union of all DNS servers from all NICs that are part of the
     Availability Set. This property is what is configured on each of those VMs.
    :vartype applied_dns_servers: list[str]
    :ivar internal_dns_name_label: Relative DNS name for this NIC used for internal communications
     between VMs in the same virtual network.
    :vartype internal_dns_name_label: str
    :ivar internal_fqdn: Fully qualified DNS name supporting internal communications between VMs in
     the same virtual network.
    :vartype internal_fqdn: str
    :ivar internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS entry
     is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the
     VM name with the value of internalDomainNameSuffix.
    :vartype internal_domain_name_suffix: str
    """

    _validation = {
        "applied_dns_servers": {"readonly": True},
        "internal_fqdn": {"readonly": True},
        "internal_domain_name_suffix": {"readonly": True},
    }

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
        "applied_dns_servers": {"key": "appliedDnsServers", "type": "[str]"},
        "internal_dns_name_label": {"key": "internalDnsNameLabel", "type": "str"},
        "internal_fqdn": {"key": "internalFqdn", "type": "str"},
        "internal_domain_name_suffix": {"key": "internalDomainNameSuffix", "type": "str"},
    }

    def __init__(
        self, *, dns_servers: Optional[List[str]] = None, internal_dns_name_label: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to
         azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it
         must be the only value in dnsServers collection.
        :paramtype dns_servers: list[str]
        :keyword internal_dns_name_label: Relative DNS name for this NIC used for internal
         communications between VMs in the same virtual network.
        :paramtype internal_dns_name_label: str
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers
        self.applied_dns_servers = None
        self.internal_dns_name_label = internal_dns_name_label
        self.internal_fqdn = None
        self.internal_domain_name_suffix = None

class NetworkInterfaceIPConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """IPConfiguration in a network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar gateway_load_balancer: The reference to gateway load balancer frontend IP.
    :vartype gateway_load_balancer: ~azure.mgmt.network.models.SubResource
    :ivar virtual_network_taps: The reference to Virtual Network Taps.
    :vartype virtual_network_taps: list[~azure.mgmt.network.models.VirtualNetworkTap]
    :ivar application_gateway_backend_address_pools: The reference to
     ApplicationGatewayBackendAddressPool resource.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool]
    :ivar load_balancer_backend_address_pools: The reference to LoadBalancerBackendAddressPool
     resource.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.network.models.BackendAddressPool]
    :ivar load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
    :vartype load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.models.InboundNatRule]
    :ivar private_ip_address: Private IP address of the IP configuration. It can be a single IP
     address or a CIDR block in the format :code:`<address>`/:code:`<prefix-length>`.
    :vartype private_ip_address: str
    :ivar private_ip_address_prefix_length: The private IP address prefix length. If specified and
     the allocation method is dynamic, the service will allocate a CIDR block instead of a single IP
     address.
    :vartype private_ip_address_prefix_length: int
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.models.IPAllocationMethod
    :ivar private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6.
     Default is IPv4. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
    :ivar subnet: Subnet bound to the IP configuration.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar primary: Whether this is a primary customer address on the network interface.
    :vartype primary: bool
    :ivar public_ip_address: Public IP address bound to the IP configuration.
    :vartype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
    :ivar application_security_groups: Application security groups in which the IP configuration is
     included.
    :vartype application_security_groups:
     list[~azure.mgmt.network.models.ApplicationSecurityGroup]
    :ivar provisioning_state: The provisioning state of the network interface IP configuration.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar private_link_connection_properties: PrivateLinkConnection properties for the network
     interface.
    :vartype private_link_connection_properties:
     ~azure.mgmt.network.models.NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties
    """

    _validation = {
        "etag": {"readonly": True},
        "private_ip_address_prefix_length": {"maximum": 128, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "private_link_connection_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "gateway_load_balancer": {"key": "properties.gatewayLoadBalancer", "type": "SubResource"},
        "virtual_network_taps": {"key": "properties.virtualNetworkTaps", "type": "[VirtualNetworkTap]"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[ApplicationGatewayBackendAddressPool]",
        },
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[BackendAddressPool]",
        },
        "load_balancer_inbound_nat_rules": {
            "key": "properties.loadBalancerInboundNatRules",
            "type": "[InboundNatRule]",
        },
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_address_prefix_length": {"key": "properties.privateIPAddressPrefixLength", "type": "int"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "application_security_groups": {
            "key": "properties.applicationSecurityGroups",
            "type": "[ApplicationSecurityGroup]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_link_connection_properties": {
            "key": "properties.privateLinkConnectionProperties",
            "type": "NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        gateway_load_balancer: Optional["_models.SubResource"] = None,
        virtual_network_taps: Optional[List["_models.VirtualNetworkTap"]] = None,
        application_gateway_backend_address_pools: Optional[
            List["_models.ApplicationGatewayBackendAddressPool"]
        ] = None,
        load_balancer_backend_address_pools: Optional[List["_models.BackendAddressPool"]] = None,
        load_balancer_inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_address_prefix_length: Optional[int] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        primary: Optional[bool] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        application_security_groups: Optional[List["_models.ApplicationSecurityGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword gateway_load_balancer: The reference to gateway load balancer frontend IP.
        :paramtype gateway_load_balancer: ~azure.mgmt.network.models.SubResource
        :keyword virtual_network_taps: The reference to Virtual Network Taps.
        :paramtype virtual_network_taps: list[~azure.mgmt.network.models.VirtualNetworkTap]
        :keyword application_gateway_backend_address_pools: The reference to
         ApplicationGatewayBackendAddressPool resource.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool]
        :keyword load_balancer_backend_address_pools: The reference to LoadBalancerBackendAddressPool
         resource.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.network.models.BackendAddressPool]
        :keyword load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
        :paramtype load_balancer_inbound_nat_rules:
         list[~azure.mgmt.network.models.InboundNatRule]
        :keyword private_ip_address: Private IP address of the IP configuration. It can be a single IP
         address or a CIDR block in the format :code:`<address>`/:code:`<prefix-length>`.
        :paramtype private_ip_address: str
        :keyword private_ip_address_prefix_length: The private IP address prefix length. If specified
         and the allocation method is dynamic, the service will allocate a CIDR block instead of a
         single IP address.
        :paramtype private_ip_address_prefix_length: int
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.models.IPAllocationMethod
        :keyword private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6.
         Default is IPv4. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
        :keyword subnet: Subnet bound to the IP configuration.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        :keyword primary: Whether this is a primary customer address on the network interface.
        :paramtype primary: bool
        :keyword public_ip_address: Public IP address bound to the IP configuration.
        :paramtype public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
        :keyword application_security_groups: Application security groups in which the IP configuration
         is included.
        :paramtype application_security_groups:
         list[~azure.mgmt.network.models.ApplicationSecurityGroup]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = type
        self.gateway_load_balancer = gateway_load_balancer
        self.virtual_network_taps = virtual_network_taps
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_address_prefix_length = private_ip_address_prefix_length
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address = public_ip_address
        self.application_security_groups = application_security_groups
        self.provisioning_state = None
        self.private_link_connection_properties = None

class NetworkInterfaceListResult(_serialization.Model):
    """Response for the ListNetworkInterface API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of network interfaces in a resource group.
    :vartype value: list[~azure.mgmt.network.models.NetworkInterface]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterface]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkInterface"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of network interfaces in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.NetworkInterface]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class NetworkSecurityGroup(Resource):  # pylint: disable=too-many-instance-attributes
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar flush_connection: When enabled, flows created from Network Security Group connections
     will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
    :vartype flush_connection: bool
    :ivar security_rules: A collection of security rules of the network security group.
    :vartype security_rules: list[~azure.mgmt.network.models.SecurityRule]
    :ivar default_security_rules: The default security rules of network security group.
    :vartype default_security_rules: list[~azure.mgmt.network.models.SecurityRule]
    :ivar network_interfaces: A collection of references to network interfaces.
    :vartype network_interfaces: list[~azure.mgmt.network.models.NetworkInterface]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.models.Subnet]
    :ivar flow_logs: A collection of references to flow log resources.
    :vartype flow_logs: list[~azure.mgmt.network.models.FlowLog]
    :ivar resource_guid: The resource GUID property of the network security group resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network security group resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "default_security_rules": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "subnets": {"readonly": True},
        "flow_logs": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "flush_connection": {"key": "properties.flushConnection", "type": "bool"},
        "security_rules": {"key": "properties.securityRules", "type": "[SecurityRule]"},
        "default_security_rules": {"key": "properties.defaultSecurityRules", "type": "[SecurityRule]"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "flow_logs": {"key": "properties.flowLogs", "type": "[FlowLog]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        flush_connection: Optional[bool] = None,
        security_rules: Optional[List["_models.SecurityRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword flush_connection: When enabled, flows created from Network Security Group connections
         will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
        :paramtype flush_connection: bool
        :keyword security_rules: A collection of security rules of the network security group.
        :paramtype security_rules: list[~azure.mgmt.network.models.SecurityRule]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.flush_connection = flush_connection
        self.security_rules = security_rules
        self.default_security_rules = None
        self.network_interfaces = None
        self.subnets = None
        self.flow_logs = None
        self.resource_guid = None
        self.provisioning_state = None

class NetworkSecurityGroupListResult(_serialization.Model):
    """Response for ListNetworkSecurityGroups API service call.

    :ivar value: A list of NetworkSecurityGroup resources.
    :vartype value: list[~azure.mgmt.network.models.NetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkSecurityGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of NetworkSecurityGroup resources.
        :paramtype value: list[~azure.mgmt.network.models.NetworkSecurityGroup]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class OutboundNatRule(SubResource):
    """Outbound NAT pool of the load balancer.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :vartype allocated_outbound_ports: int
    :ivar frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :vartype frontend_ip_configurations: list[~azure.mgmt.network.models.SubResource]
    :ivar backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "allocated_outbound_ports": {"key": "properties.allocatedOutboundPorts", "type": "int"},
        "frontend_ip_configurations": {"key": "properties.frontendIPConfigurations", "type": "[SubResource]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allocated_outbound_ports: Optional[int] = None,
        frontend_ip_configurations: Optional[List["_models.SubResource"]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :paramtype allocated_outbound_ports: int
        :keyword frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :paramtype frontend_ip_configurations: list[~azure.mgmt.network.models.SubResource]
        :keyword backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.allocated_outbound_ports = allocated_outbound_ports
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = provisioning_state

class Probe(SubResource):  # pylint: disable=too-many-instance-attributes
    """A load balancer probe.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of probes used by the load
     balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar load_balancing_rules: The load balancer rules that use this probe.
    :vartype load_balancing_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar protocol: The protocol of the end point. If 'Tcp' is specified, a received ACK is
     required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response
     from the specifies URI is required for the probe to be successful. Known values are: "Http",
     "Tcp", and "Https".
    :vartype protocol: str or ~azure.mgmt.network.models.ProbeProtocol
    :ivar port: The port for communicating the probe. Possible values range from 1 to 65535,
     inclusive.
    :vartype port: int
    :ivar interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint
     for health status. Typically, the interval is slightly less than half the allocated timeout
     period (in seconds) which allows two full probes before taking the instance out of rotation.
     The default value is 15, the minimum value is 5.
    :vartype interval_in_seconds: int
    :ivar no_healthy_backends_behavior: Determines how new connections are handled by the load
     balancer when all backend instances are probed down. Known values are: "AllProbedDown" and
     "AllProbedUp".
    :vartype no_healthy_backends_behavior: str or
     ~azure.mgmt.network.models.ProbeNoHealthyBackendsBehavior
    :ivar number_of_probes: The number of probes where if no response, will result in stopping
     further traffic from being delivered to the endpoint. This values allows endpoints to be taken
     out of rotation faster or slower than the typical times used in Azure.
    :vartype number_of_probes: int
    :ivar probe_threshold: The number of consecutive successful or failed probes in order to allow
     or deny traffic from being delivered to this endpoint. After failing the number of consecutive
     probes equal to this value, the endpoint will be taken out of rotation and require the same
     number of successful consecutive probes to be placed back in rotation.
    :vartype probe_threshold: int
    :ivar request_path: The URI used for requesting health status from the VM. Path is required if
     a protocol is set to http. Otherwise, it is not allowed. There is no default value.
    :vartype request_path: str
    :ivar provisioning_state: The provisioning state of the probe resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "load_balancing_rules": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "interval_in_seconds": {"key": "properties.intervalInSeconds", "type": "int"},
        "no_healthy_backends_behavior": {"key": "properties.noHealthyBackendsBehavior", "type": "str"},
        "number_of_probes": {"key": "properties.numberOfProbes", "type": "int"},
        "probe_threshold": {"key": "properties.probeThreshold", "type": "int"},
        "request_path": {"key": "properties.requestPath", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.ProbeProtocol"]] = None,
        port: Optional[int] = None,
        interval_in_seconds: Optional[int] = None,
        no_healthy_backends_behavior: Optional[Union[str, "_models.ProbeNoHealthyBackendsBehavior"]] = None,
        number_of_probes: Optional[int] = None,
        probe_threshold: Optional[int] = None,
        request_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of probes used by the
         load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword protocol: The protocol of the end point. If 'Tcp' is specified, a received ACK is
         required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response
         from the specifies URI is required for the probe to be successful. Known values are: "Http",
         "Tcp", and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.models.ProbeProtocol
        :keyword port: The port for communicating the probe. Possible values range from 1 to 65535,
         inclusive.
        :paramtype port: int
        :keyword interval_in_seconds: The interval, in seconds, for how frequently to probe the
         endpoint for health status. Typically, the interval is slightly less than half the allocated
         timeout period (in seconds) which allows two full probes before taking the instance out of
         rotation. The default value is 15, the minimum value is 5.
        :paramtype interval_in_seconds: int
        :keyword no_healthy_backends_behavior: Determines how new connections are handled by the load
         balancer when all backend instances are probed down. Known values are: "AllProbedDown" and
         "AllProbedUp".
        :paramtype no_healthy_backends_behavior: str or
         ~azure.mgmt.network.models.ProbeNoHealthyBackendsBehavior
        :keyword number_of_probes: The number of probes where if no response, will result in stopping
         further traffic from being delivered to the endpoint. This values allows endpoints to be taken
         out of rotation faster or slower than the typical times used in Azure.
        :paramtype number_of_probes: int
        :keyword probe_threshold: The number of consecutive successful or failed probes in order to
         allow or deny traffic from being delivered to this endpoint. After failing the number of
         consecutive probes equal to this value, the endpoint will be taken out of rotation and require
         the same number of successful consecutive probes to be placed back in rotation.
        :paramtype probe_threshold: int
        :keyword request_path: The URI used for requesting health status from the VM. Path is required
         if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        :paramtype request_path: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.load_balancing_rules = None
        self.protocol = protocol
        self.port = port
        self.interval_in_seconds = interval_in_seconds
        self.no_healthy_backends_behavior = no_healthy_backends_behavior
        self.number_of_probes = number_of_probes
        self.probe_threshold = probe_threshold
        self.request_path = request_path
        self.provisioning_state = None

class PublicIPAddress(Resource):  # pylint: disable=too-many-instance-attributes
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the public ip address.
    :vartype extended_location: ~azure.mgmt.network.models.ExtendedLocation
    :ivar sku: The public IP address SKU.
    :vartype sku: ~azure.mgmt.network.models.PublicIPAddressSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar public_ip_allocation_method: The public IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype public_ip_allocation_method: str or
     ~azure.mgmt.network.models.IPAllocationMethod
    :ivar public_ip_address_version: The public IP address version. Known values are: "IPv4" and
     "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
    :ivar ip_configuration: The IP configuration associated with the public IP address.
    :vartype ip_configuration: ~azure.mgmt.network.models.IPConfiguration
    :ivar dns_settings: The FQDN of the DNS record associated with the public IP address.
    :vartype dns_settings: ~azure.mgmt.network.models.PublicIPAddressDnsSettings
    :ivar ddos_settings: The DDoS protection custom policy associated with the public IP address.
    :vartype ddos_settings: ~azure.mgmt.network.models.DdosSettings
    :ivar ip_tags: The list of tags associated with the public IP address.
    :vartype ip_tags: list[~azure.mgmt.network.models.IpTag]
    :ivar ip_address: The IP address associated with the public IP address resource.
    :vartype ip_address: str
    :ivar public_ip_prefix: The Public IP Prefix this Public IP Address should be allocated from.
    :vartype public_ip_prefix: ~azure.mgmt.network.models.SubResource
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar resource_guid: The resource GUID property of the public IP address resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP address resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar service_public_ip_address: The service public IP address of the public IP address
     resource.
    :vartype service_public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
    :ivar nat_gateway: The NatGateway for the Public IP address.
    :vartype nat_gateway: ~azure.mgmt.network.models.NatGateway
    :ivar migration_phase: Migration phase of Public IP Address. Known values are: "None",
     "Prepare", "Commit", "Abort", and "Committed".
    :vartype migration_phase: str or
     ~azure.mgmt.network.models.PublicIPAddressMigrationPhase
    :ivar linked_public_ip_address: The linked public IP address of the public IP address resource.
    :vartype linked_public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
    :ivar delete_option: Specify what happens to the public IP address when the VM using it is
     deleted. Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.network.models.DeleteOptions
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "ip_configuration": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "sku": {"key": "sku", "type": "PublicIPAddressSku"},
        "etag": {"key": "etag", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "public_ip_allocation_method": {"key": "properties.publicIPAllocationMethod", "type": "str"},
        "public_ip_address_version": {"key": "properties.publicIPAddressVersion", "type": "str"},
        "ip_configuration": {"key": "properties.ipConfiguration", "type": "IPConfiguration"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "PublicIPAddressDnsSettings"},
        "ddos_settings": {"key": "properties.ddosSettings", "type": "DdosSettings"},
        "ip_tags": {"key": "properties.ipTags", "type": "[IpTag]"},
        "ip_address": {"key": "properties.ipAddress", "type": "str"},
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "service_public_ip_address": {"key": "properties.servicePublicIPAddress", "type": "PublicIPAddress"},
        "nat_gateway": {"key": "properties.natGateway", "type": "NatGateway"},
        "migration_phase": {"key": "properties.migrationPhase", "type": "str"},
        "linked_public_ip_address": {"key": "properties.linkedPublicIPAddress", "type": "PublicIPAddress"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        sku: Optional["_models.PublicIPAddressSku"] = None,
        zones: Optional[List[str]] = None,
        public_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        dns_settings: Optional["_models.PublicIPAddressDnsSettings"] = None,
        ddos_settings: Optional["_models.DdosSettings"] = None,
        ip_tags: Optional[List["_models.IpTag"]] = None,
        ip_address: Optional[str] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        service_public_ip_address: Optional["_models.PublicIPAddress"] = None,
        nat_gateway: Optional["_models.NatGateway"] = None,
        migration_phase: Optional[Union[str, "_models.PublicIPAddressMigrationPhase"]] = None,
        linked_public_ip_address: Optional["_models.PublicIPAddress"] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the public ip address.
        :paramtype extended_location: ~azure.mgmt.network.models.ExtendedLocation
        :keyword sku: The public IP address SKU.
        :paramtype sku: ~azure.mgmt.network.models.PublicIPAddressSku
        :keyword zones: A list of availability zones denoting the IP allocated for the resource needs
         to come from.
        :paramtype zones: list[str]
        :keyword public_ip_allocation_method: The public IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype public_ip_allocation_method: str or
         ~azure.mgmt.network.models.IPAllocationMethod
        :keyword public_ip_address_version: The public IP address version. Known values are: "IPv4" and
         "IPv6".
        :paramtype public_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
        :keyword dns_settings: The FQDN of the DNS record associated with the public IP address.
        :paramtype dns_settings: ~azure.mgmt.network.models.PublicIPAddressDnsSettings
        :keyword ddos_settings: The DDoS protection custom policy associated with the public IP
         address.
        :paramtype ddos_settings: ~azure.mgmt.network.models.DdosSettings
        :keyword ip_tags: The list of tags associated with the public IP address.
        :paramtype ip_tags: list[~azure.mgmt.network.models.IpTag]
        :keyword ip_address: The IP address associated with the public IP address resource.
        :paramtype ip_address: str
        :keyword public_ip_prefix: The Public IP Prefix this Public IP Address should be allocated
         from.
        :paramtype public_ip_prefix: ~azure.mgmt.network.models.SubResource
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword service_public_ip_address: The service public IP address of the public IP address
         resource.
        :paramtype service_public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
        :keyword nat_gateway: The NatGateway for the Public IP address.
        :paramtype nat_gateway: ~azure.mgmt.network.models.NatGateway
        :keyword migration_phase: Migration phase of Public IP Address. Known values are: "None",
         "Prepare", "Commit", "Abort", and "Committed".
        :paramtype migration_phase: str or
         ~azure.mgmt.network.models.PublicIPAddressMigrationPhase
        :keyword linked_public_ip_address: The linked public IP address of the public IP address
         resource.
        :paramtype linked_public_ip_address: ~azure.mgmt.network.models.PublicIPAddress
        :keyword delete_option: Specify what happens to the public IP address when the VM using it is
         deleted. Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.network.models.DeleteOptions
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.sku = sku
        self.etag = None
        self.zones = zones
        self.public_ip_allocation_method = public_ip_allocation_method
        self.public_ip_address_version = public_ip_address_version
        self.ip_configuration = None
        self.dns_settings = dns_settings
        self.ddos_settings = ddos_settings
        self.ip_tags = ip_tags
        self.ip_address = ip_address
        self.public_ip_prefix = public_ip_prefix
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.resource_guid = None
        self.provisioning_state = None
        self.service_public_ip_address = service_public_ip_address
        self.nat_gateway = nat_gateway
        self.migration_phase = migration_phase
        self.linked_public_ip_address = linked_public_ip_address
        self.delete_option = delete_option

class PublicIPAddressDnsSettings(_serialization.Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :ivar domain_name_label: The domain name label. The concatenation of the domain name label and
     the regionalized DNS zone make up the fully qualified domain name associated with the public IP
     address. If a domain name label is specified, an A DNS record is created for the public IP in
     the Microsoft Azure DNS system.
    :vartype domain_name_label: str
    :ivar domain_name_label_scope: The domain name label scope. If a domain name label and a domain
     name label scope are specified, an A DNS record is created for the public IP in the Microsoft
     Azure DNS system with a hashed value includes in FQDN. Known values are: "TenantReuse",
     "SubscriptionReuse", "ResourceGroupReuse", and "NoReuse".
    :vartype domain_name_label_scope: str or
     ~azure.mgmt.network.models.PublicIpAddressDnsSettingsDomainNameLabelScope
    :ivar fqdn: The Fully Qualified Domain Name of the A DNS record associated with the public IP.
     This is the concatenation of the domainNameLabel and the regionalized DNS zone.
    :vartype fqdn: str
    :ivar reverse_fqdn: The reverse FQDN. A user-visible, fully qualified domain name that resolves
     to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created
     pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
    :vartype reverse_fqdn: str
    """

    _attribute_map = {
        "domain_name_label": {"key": "domainNameLabel", "type": "str"},
        "domain_name_label_scope": {"key": "domainNameLabelScope", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "reverse_fqdn": {"key": "reverseFqdn", "type": "str"},
    }

    def __init__(
        self,
        *,
        domain_name_label: Optional[str] = None,
        domain_name_label_scope: Optional[Union[str, "_models.PublicIpAddressDnsSettingsDomainNameLabelScope"]] = None,
        fqdn: Optional[str] = None,
        reverse_fqdn: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain_name_label: The domain name label. The concatenation of the domain name label
         and the regionalized DNS zone make up the fully qualified domain name associated with the
         public IP address. If a domain name label is specified, an A DNS record is created for the
         public IP in the Microsoft Azure DNS system.
        :paramtype domain_name_label: str
        :keyword domain_name_label_scope: The domain name label scope. If a domain name label and a
         domain name label scope are specified, an A DNS record is created for the public IP in the
         Microsoft Azure DNS system with a hashed value includes in FQDN. Known values are:
         "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse", and "NoReuse".
        :paramtype domain_name_label_scope: str or
         ~azure.mgmt.network.models.PublicIpAddressDnsSettingsDomainNameLabelScope
        :keyword fqdn: The Fully Qualified Domain Name of the A DNS record associated with the public
         IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :paramtype fqdn: str
        :keyword reverse_fqdn: The reverse FQDN. A user-visible, fully qualified domain name that
         resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is
         created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        :paramtype reverse_fqdn: str
        """
        super().__init__(**kwargs)
        self.domain_name_label = domain_name_label
        self.domain_name_label_scope = domain_name_label_scope
        self.fqdn = fqdn
        self.reverse_fqdn = reverse_fqdn

class PublicIPAddressListResult(_serialization.Model):
    """Response for ListPublicIpAddresses API service call.

    :ivar value: A list of public IP addresses that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.models.PublicIPAddress]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PublicIPAddress]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PublicIPAddress"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of public IP addresses that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.PublicIPAddress]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class Route(SubResource):
    """Route resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar address_prefix: The destination CIDR to which the route applies.
    :vartype address_prefix: str
    :ivar next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
     "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.models.RouteNextHopType
    :ivar next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :vartype next_hop_ip_address: str
    :ivar provisioning_state: The provisioning state of the route resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar has_bgp_override: A value indicating whether this route overrides overlapping BGP routes
     regardless of LPM.
    :vartype has_bgp_override: bool
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "has_bgp_override": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "next_hop_type": {"key": "properties.nextHopType", "type": "str"},
        "next_hop_ip_address": {"key": "properties.nextHopIpAddress", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "has_bgp_override": {"key": "properties.hasBgpOverride", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        address_prefix: Optional[str] = None,
        next_hop_type: Optional[Union[str, "_models.RouteNextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword type: The type of the resource.
        :paramtype type: str
        :keyword address_prefix: The destination CIDR to which the route applies.
        :paramtype address_prefix: str
        :keyword next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
         "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.models.RouteNextHopType
        :keyword next_hop_ip_address: The IP address packets should be forwarded to. Next hop values
         are only allowed in routes where the next hop type is VirtualAppliance.
        :paramtype next_hop_ip_address: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = type
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.provisioning_state = None
        self.has_bgp_override = None

class RouteListResult(_serialization.Model):
    """Response for the ListRoute API service call.

    :ivar value: A list of routes in a resource group.
    :vartype value: list[~azure.mgmt.network.models.Route]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Route]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Route"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of routes in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.Route]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class RouteTable(Resource):  # pylint: disable=too-many-instance-attributes
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar routes: Collection of routes contained within a route table.
    :vartype routes: list[~azure.mgmt.network.models.Route]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.models.Subnet]
    :ivar disable_bgp_route_propagation: Whether to disable the routes learned by BGP on that route
     table. True means disable.
    :vartype disable_bgp_route_propagation: bool
    :ivar provisioning_state: The provisioning state of the route table resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: The resource GUID property of the route table.
    :vartype resource_guid: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "subnets": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "routes": {"key": "properties.routes", "type": "[Route]"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "disable_bgp_route_propagation": {"key": "properties.disableBgpRoutePropagation", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        routes: Optional[List["_models.Route"]] = None,
        disable_bgp_route_propagation: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword routes: Collection of routes contained within a route table.
        :paramtype routes: list[~azure.mgmt.network.models.Route]
        :keyword disable_bgp_route_propagation: Whether to disable the routes learned by BGP on that
         route table. True means disable.
        :paramtype disable_bgp_route_propagation: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.routes = routes
        self.subnets = None
        self.disable_bgp_route_propagation = disable_bgp_route_propagation
        self.provisioning_state = None
        self.resource_guid = None

class RouteTableListResult(_serialization.Model):
    """Response for the ListRouteTable API service call.

    :ivar value: A list of route tables in a resource group.
    :vartype value: list[~azure.mgmt.network.models.RouteTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteTable"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of route tables in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.RouteTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class SecurityRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Network security rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "*", and "Ah".
    :vartype protocol: str or ~azure.mgmt.network.models.SecurityRuleProtocol
    :ivar source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :vartype source_port_range: str
    :ivar destination_port_range: The destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :vartype destination_port_range: str
    :ivar source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :vartype source_address_prefix: str
    :ivar source_address_prefixes: The CIDR or source IP ranges.
    :vartype source_address_prefixes: list[str]
    :ivar source_application_security_groups: The application security group specified as source.
    :vartype source_application_security_groups:
     list[~azure.mgmt.network.models.ApplicationSecurityGroup]
    :ivar destination_address_prefix: The destination address prefix. CIDR or destination IP range.
     Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
     'AzureLoadBalancer' and 'Internet' can also be used.
    :vartype destination_address_prefix: str
    :ivar destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :vartype destination_address_prefixes: list[str]
    :ivar destination_application_security_groups: The application security group specified as
     destination.
    :vartype destination_application_security_groups:
     list[~azure.mgmt.network.models.ApplicationSecurityGroup]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: The network traffic is allowed or denied. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.models.SecurityRuleAccess
    :ivar priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityRuleDirection
    :ivar provisioning_state: The provisioning state of the security rule resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "source_port_range": {"key": "properties.sourcePortRange", "type": "str"},
        "destination_port_range": {"key": "properties.destinationPortRange", "type": "str"},
        "source_address_prefix": {"key": "properties.sourceAddressPrefix", "type": "str"},
        "source_address_prefixes": {"key": "properties.sourceAddressPrefixes", "type": "[str]"},
        "source_application_security_groups": {
            "key": "properties.sourceApplicationSecurityGroups",
            "type": "[ApplicationSecurityGroup]",
        },
        "destination_address_prefix": {"key": "properties.destinationAddressPrefix", "type": "str"},
        "destination_address_prefixes": {"key": "properties.destinationAddressPrefixes", "type": "[str]"},
        "destination_application_security_groups": {
            "key": "properties.destinationApplicationSecurityGroups",
            "type": "[ApplicationSecurityGroup]",
        },
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        source_application_security_groups: Optional[List["_models.ApplicationSecurityGroup"]] = None,
        destination_address_prefix: Optional[str] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        destination_application_security_groups: Optional[List["_models.ApplicationSecurityGroup"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityRuleDirection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword type: The type of the resource.
        :paramtype type: str
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "*", and "Ah".
        :paramtype protocol: str or ~azure.mgmt.network.models.SecurityRuleProtocol
        :keyword source_port_range: The source port or range. Integer or range between 0 and 65535.
         Asterisk '*' can also be used to match all ports.
        :paramtype source_port_range: str
        :keyword destination_port_range: The destination port or range. Integer or range between 0 and
         65535. Asterisk '*' can also be used to match all ports.
        :paramtype destination_port_range: str
        :keyword source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
         match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
         can also be used. If this is an ingress rule, specifies where network traffic originates from.
        :paramtype source_address_prefix: str
        :keyword source_address_prefixes: The CIDR or source IP ranges.
        :paramtype source_address_prefixes: list[str]
        :keyword source_application_security_groups: The application security group specified as
         source.
        :paramtype source_application_security_groups:
         list[~azure.mgmt.network.models.ApplicationSecurityGroup]
        :keyword destination_address_prefix: The destination address prefix. CIDR or destination IP
         range. Asterisk '*' can also be used to match all source IPs. Default tags such as
         'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        :paramtype destination_address_prefix: str
        :keyword destination_address_prefixes: The destination address prefixes. CIDR or destination IP
         ranges.
        :paramtype destination_address_prefixes: list[str]
        :keyword destination_application_security_groups: The application security group specified as
         destination.
        :paramtype destination_application_security_groups:
         list[~azure.mgmt.network.models.ApplicationSecurityGroup]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: The network traffic is allowed or denied. Known values are: "Allow" and
         "Deny".
        :paramtype access: str or ~azure.mgmt.network.models.SecurityRuleAccess
        :keyword priority: The priority of the rule. The value can be between 100 and 4096. The
         priority number must be unique for each rule in the collection. The lower the priority number,
         the higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: The direction of the rule. The direction specifies if rule will be
         evaluated on incoming or outgoing traffic. Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.models.SecurityRuleDirection
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = type
        self.description = description
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_address_prefix = source_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.source_application_security_groups = source_application_security_groups
        self.destination_address_prefix = destination_address_prefix
        self.destination_address_prefixes = destination_address_prefixes
        self.destination_application_security_groups = destination_application_security_groups
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None

class SecurityRuleListResult(_serialization.Model):
    """Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a
    network security group.

    :ivar value: The security rules in a network security group.
    :vartype value: list[~azure.mgmt.network.models.SecurityRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SecurityRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The security rules in a network security group.
        :paramtype value: list[~azure.mgmt.network.models.SecurityRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class Subnet(SubResource):  # pylint: disable=too-many-instance-attributes
    """Subnet in a virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar address_prefix: The address prefix for the subnet.
    :vartype address_prefix: str
    :ivar address_prefixes: List of address prefixes for the subnet.
    :vartype address_prefixes: list[str]
    :ivar network_security_group: The reference to the NetworkSecurityGroup resource.
    :vartype network_security_group: ~azure.mgmt.network.models.NetworkSecurityGroup
    :ivar route_table: The reference to the RouteTable resource.
    :vartype route_table: ~azure.mgmt.network.models.RouteTable
    :ivar nat_gateway: Nat gateway associated with this subnet.
    :vartype nat_gateway: ~azure.mgmt.network.models.SubResource
    :ivar service_endpoints: An array of service endpoints.
    :vartype service_endpoints:
     list[~azure.mgmt.network.models.ServiceEndpointPropertiesFormat]
    :ivar service_endpoint_policies: An array of service endpoint policies.
    :vartype service_endpoint_policies:
     list[~azure.mgmt.network.models.ServiceEndpointPolicy]
    :ivar private_endpoints: An array of references to private endpoints.
    :vartype private_endpoints: list[~azure.mgmt.network.models.PrivateEndpoint]
    :ivar ip_configurations: An array of references to the network interface IP configurations
     using subnet.
    :vartype ip_configurations: list[~azure.mgmt.network.models.IPConfiguration]
    :ivar ip_configuration_profiles: Array of IP configuration profiles which reference this
     subnet.
    :vartype ip_configuration_profiles:
     list[~azure.mgmt.network.models.IPConfigurationProfile]
    :ivar ip_allocations: Array of IpAllocation which reference this subnet.
    :vartype ip_allocations: list[~azure.mgmt.network.models.SubResource]
    :ivar resource_navigation_links: An array of references to the external resources using subnet.
    :vartype resource_navigation_links:
     list[~azure.mgmt.network.models.ResourceNavigationLink]
    :ivar service_association_links: An array of references to services injecting into this subnet.
    :vartype service_association_links:
     list[~azure.mgmt.network.models.ServiceAssociationLink]
    :ivar delegations: An array of references to the delegations on the subnet.
    :vartype delegations: list[~azure.mgmt.network.models.Delegation]
    :ivar purpose: A read-only string identifying the intention of use for this subnet based on
     delegations and other user-defined properties.
    :vartype purpose: str
    :ivar provisioning_state: The provisioning state of the subnet resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar private_endpoint_network_policies: Enable or Disable apply network policies on private
     end point in the subnet. Known values are: "Enabled", "Disabled",
     "NetworkSecurityGroupEnabled", and "RouteTableEnabled".
    :vartype private_endpoint_network_policies: str or
     ~azure.mgmt.network.models.VirtualNetworkPrivateEndpointNetworkPolicies
    :ivar private_link_service_network_policies: Enable or Disable apply network policies on
     private link service in the subnet. Known values are: "Enabled" and "Disabled".
    :vartype private_link_service_network_policies: str or
     ~azure.mgmt.network.models.VirtualNetworkPrivateLinkServiceNetworkPolicies
    :ivar application_gateway_ip_configurations: Application gateway IP configurations of virtual
     network resource.
    :vartype application_gateway_ip_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayIPConfiguration]
    :ivar sharing_scope: Set this property to Tenant to allow sharing subnet with other
     subscriptions in your AAD tenant. This property can only be set if defaultOutboundAccess is set
     to false, both properties can only be set if subnet is empty. Known values are: "Tenant" and
     "DelegatedServices".
    :vartype sharing_scope: str or ~azure.mgmt.network.models.SharingScope
    :ivar default_outbound_access: Set this property to false to disable default outbound
     connectivity for all VMs in the subnet. This property can only be set at the time of subnet
     creation and cannot be updated for an existing subnet.
    :vartype default_outbound_access: bool
    """

    _validation = {
        "etag": {"readonly": True},
        "private_endpoints": {"readonly": True},
        "ip_configurations": {"readonly": True},
        "ip_configuration_profiles": {"readonly": True},
        "resource_navigation_links": {"readonly": True},
        "service_association_links": {"readonly": True},
        "purpose": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "address_prefixes": {"key": "properties.addressPrefixes", "type": "[str]"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "NetworkSecurityGroup"},
        "route_table": {"key": "properties.routeTable", "type": "RouteTable"},
        "nat_gateway": {"key": "properties.natGateway", "type": "SubResource"},
        "service_endpoints": {"key": "properties.serviceEndpoints", "type": "[ServiceEndpointPropertiesFormat]"},
        "service_endpoint_policies": {"key": "properties.serviceEndpointPolicies", "type": "[ServiceEndpointPolicy]"},
        "private_endpoints": {"key": "properties.privateEndpoints", "type": "[PrivateEndpoint]"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[IPConfiguration]"},
        "ip_configuration_profiles": {"key": "properties.ipConfigurationProfiles", "type": "[IPConfigurationProfile]"},
        "ip_allocations": {"key": "properties.ipAllocations", "type": "[SubResource]"},
        "resource_navigation_links": {"key": "properties.resourceNavigationLinks", "type": "[ResourceNavigationLink]"},
        "service_association_links": {"key": "properties.serviceAssociationLinks", "type": "[ServiceAssociationLink]"},
        "delegations": {"key": "properties.delegations", "type": "[Delegation]"},
        "purpose": {"key": "properties.purpose", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_network_policies": {"key": "properties.privateEndpointNetworkPolicies", "type": "str"},
        "private_link_service_network_policies": {"key": "properties.privateLinkServiceNetworkPolicies", "type": "str"},
        "application_gateway_ip_configurations": {
            "key": "properties.applicationGatewayIPConfigurations",
            "type": "[ApplicationGatewayIPConfiguration]",
        },
        "sharing_scope": {"key": "properties.sharingScope", "type": "str"},
        "default_outbound_access": {"key": "properties.defaultOutboundAccess", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        address_prefix: Optional[str] = None,
        address_prefixes: Optional[List[str]] = None,
        network_security_group: Optional["_models.NetworkSecurityGroup"] = None,
        route_table: Optional["_models.RouteTable"] = None,
        nat_gateway: Optional["_models.SubResource"] = None,
        service_endpoints: Optional[List["_models.ServiceEndpointPropertiesFormat"]] = None,
        service_endpoint_policies: Optional[List["_models.ServiceEndpointPolicy"]] = None,
        ip_allocations: Optional[List["_models.SubResource"]] = None,
        delegations: Optional[List["_models.Delegation"]] = None,
        private_endpoint_network_policies: Union[
            str, "_models.VirtualNetworkPrivateEndpointNetworkPolicies"
        ] = "Disabled",
        private_link_service_network_policies: Union[
            str, "_models.VirtualNetworkPrivateLinkServiceNetworkPolicies"
        ] = "Enabled",
        application_gateway_ip_configurations: Optional[List["_models.ApplicationGatewayIPConfiguration"]] = None,
        sharing_scope: Optional[Union[str, "_models.SharingScope"]] = None,
        default_outbound_access: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword address_prefix: The address prefix for the subnet.
        :paramtype address_prefix: str
        :keyword address_prefixes: List of address prefixes for the subnet.
        :paramtype address_prefixes: list[str]
        :keyword network_security_group: The reference to the NetworkSecurityGroup resource.
        :paramtype network_security_group: ~azure.mgmt.network.models.NetworkSecurityGroup
        :keyword route_table: The reference to the RouteTable resource.
        :paramtype route_table: ~azure.mgmt.network.models.RouteTable
        :keyword nat_gateway: Nat gateway associated with this subnet.
        :paramtype nat_gateway: ~azure.mgmt.network.models.SubResource
        :keyword service_endpoints: An array of service endpoints.
        :paramtype service_endpoints:
         list[~azure.mgmt.network.models.ServiceEndpointPropertiesFormat]
        :keyword service_endpoint_policies: An array of service endpoint policies.
        :paramtype service_endpoint_policies:
         list[~azure.mgmt.network.models.ServiceEndpointPolicy]
        :keyword ip_allocations: Array of IpAllocation which reference this subnet.
        :paramtype ip_allocations: list[~azure.mgmt.network.models.SubResource]
        :keyword delegations: An array of references to the delegations on the subnet.
        :paramtype delegations: list[~azure.mgmt.network.models.Delegation]
        :keyword private_endpoint_network_policies: Enable or Disable apply network policies on private
         end point in the subnet. Known values are: "Enabled", "Disabled",
         "NetworkSecurityGroupEnabled", and "RouteTableEnabled".
        :paramtype private_endpoint_network_policies: str or
         ~azure.mgmt.network.models.VirtualNetworkPrivateEndpointNetworkPolicies
        :keyword private_link_service_network_policies: Enable or Disable apply network policies on
         private link service in the subnet. Known values are: "Enabled" and "Disabled".
        :paramtype private_link_service_network_policies: str or
         ~azure.mgmt.network.models.VirtualNetworkPrivateLinkServiceNetworkPolicies
        :keyword application_gateway_ip_configurations: Application gateway IP configurations of
         virtual network resource.
        :paramtype application_gateway_ip_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayIPConfiguration]
        :keyword sharing_scope: Set this property to Tenant to allow sharing subnet with other
         subscriptions in your AAD tenant. This property can only be set if defaultOutboundAccess is set
         to false, both properties can only be set if subnet is empty. Known values are: "Tenant" and
         "DelegatedServices".
        :paramtype sharing_scope: str or ~azure.mgmt.network.models.SharingScope
        :keyword default_outbound_access: Set this property to false to disable default outbound
         connectivity for all VMs in the subnet. This property can only be set at the time of subnet
         creation and cannot be updated for an existing subnet.
        :paramtype default_outbound_access: bool
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = type
        self.address_prefix = address_prefix
        self.address_prefixes = address_prefixes
        self.network_security_group = network_security_group
        self.route_table = route_table
        self.nat_gateway = nat_gateway
        self.service_endpoints = service_endpoints
        self.service_endpoint_policies = service_endpoint_policies
        self.private_endpoints = None
        self.ip_configurations = None
        self.ip_configuration_profiles = None
        self.ip_allocations = ip_allocations
        self.resource_navigation_links = None
        self.service_association_links = None
        self.delegations = delegations
        self.purpose = None
        self.provisioning_state = None
        self.private_endpoint_network_policies = private_endpoint_network_policies
        self.private_link_service_network_policies = private_link_service_network_policies
        self.application_gateway_ip_configurations = application_gateway_ip_configurations
        self.sharing_scope = sharing_scope
        self.default_outbound_access = default_outbound_access

class SubnetListResult(_serialization.Model):
    """Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual
    network.

    :ivar value: The subnets in a virtual network.
    :vartype value: list[~azure.mgmt.network.models.Subnet]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Subnet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Subnet"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The subnets in a virtual network.
        :paramtype value: list[~azure.mgmt.network.models.Subnet]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class Usage(_serialization.Model):
    """The network resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource identifier.
    :vartype id: str
    :ivar unit: An enum describing the unit of measurement. Required. "Count"
    :vartype unit: str or ~azure.mgmt.network.models.UsageUnit
    :ivar current_value: The current value of the usage. Required.
    :vartype current_value: int
    :ivar limit: The limit of usage. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.network.models.UsageName
    """

    _validation = {
        "id": {"readonly": True},
        "unit": {"required": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    def __init__(
        self,
        *,
        unit: Union[str, "_models.UsageUnit"],
        current_value: int,
        limit: int,
        name: "_models.UsageName",
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: An enum describing the unit of measurement. Required. "Count"
        :paramtype unit: str or ~azure.mgmt.network.models.UsageUnit
        :keyword current_value: The current value of the usage. Required.
        :paramtype current_value: int
        :keyword limit: The limit of usage. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.network.models.UsageName
        """
        super().__init__(**kwargs)
        self.id = None
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name

class UsageName(_serialization.Model):
    """The usage names.

    :ivar value: A string describing the resource name.
    :vartype value: str
    :ivar localized_value: A localized string describing the resource name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A string describing the resource name.
        :paramtype value: str
        :keyword localized_value: A localized string describing the resource name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value

class UsagesListResult(_serialization.Model):
    """The list usages operation response.

    :ivar value: The list network resource usages.
    :vartype value: list[~azure.mgmt.network.models.Usage]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Usage"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list network resource usages.
        :paramtype value: list[~azure.mgmt.network.models.Usage]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualNetwork(Resource):  # pylint: disable=too-many-instance-attributes
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the virtual network.
    :vartype extended_location: ~azure.mgmt.network.models.ExtendedLocation
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_space: The AddressSpace that contains an array of IP address ranges that can be
     used by subnets.
    :vartype address_space: ~azure.mgmt.network.models.AddressSpace
    :ivar dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
     deployed in the virtual network.
    :vartype dhcp_options: ~azure.mgmt.network.models.DhcpOptions
    :ivar flow_timeout_in_minutes: The FlowTimeout value (in minutes) for the Virtual Network.
    :vartype flow_timeout_in_minutes: int
    :ivar subnets: A list of subnets in a Virtual Network.
    :vartype subnets: list[~azure.mgmt.network.models.Subnet]
    :ivar virtual_network_peerings: A list of peerings in a Virtual Network.
    :vartype virtual_network_peerings:
     list[~azure.mgmt.network.models.VirtualNetworkPeering]
    :ivar resource_guid: The resourceGuid property of the Virtual Network resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar enable_ddos_protection: Indicates if DDoS protection is enabled for all the protected
     resources in the virtual network. It requires a DDoS protection plan associated with the
     resource.
    :vartype enable_ddos_protection: bool
    :ivar enable_vm_protection: Indicates if VM protection is enabled for all the subnets in the
     virtual network.
    :vartype enable_vm_protection: bool
    :ivar ddos_protection_plan: The DDoS protection plan associated with the virtual network.
    :vartype ddos_protection_plan: ~azure.mgmt.network.models.SubResource
    :ivar bgp_communities: Bgp Communities sent over ExpressRoute with each route corresponding to
     a prefix in this VNET.
    :vartype bgp_communities: ~azure.mgmt.network.models.VirtualNetworkBgpCommunities
    :ivar encryption: Indicates if encryption is enabled on virtual network and if VM without
     encryption is allowed in encrypted VNet.
    :vartype encryption: ~azure.mgmt.network.models.VirtualNetworkEncryption
    :ivar ip_allocations: Array of IpAllocation which reference this VNET.
    :vartype ip_allocations: list[~azure.mgmt.network.models.SubResource]
    :ivar flow_logs: A collection of references to flow log resources.
    :vartype flow_logs: list[~azure.mgmt.network.models.FlowLog]
    :ivar private_endpoint_v_net_policies: Private Endpoint VNet Policies. Known values are:
     "Disabled" and "Basic".
    :vartype private_endpoint_v_net_policies: str or
     ~azure.mgmt.network.models.PrivateEndpointVNetPolicies
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "flow_logs": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "etag": {"key": "etag", "type": "str"},
        "address_space": {"key": "properties.addressSpace", "type": "AddressSpace"},
        "dhcp_options": {"key": "properties.dhcpOptions", "type": "DhcpOptions"},
        "flow_timeout_in_minutes": {"key": "properties.flowTimeoutInMinutes", "type": "int"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "virtual_network_peerings": {"key": "properties.virtualNetworkPeerings", "type": "[VirtualNetworkPeering]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "enable_ddos_protection": {"key": "properties.enableDdosProtection", "type": "bool"},
        "enable_vm_protection": {"key": "properties.enableVmProtection", "type": "bool"},
        "ddos_protection_plan": {"key": "properties.ddosProtectionPlan", "type": "SubResource"},
        "bgp_communities": {"key": "properties.bgpCommunities", "type": "VirtualNetworkBgpCommunities"},
        "encryption": {"key": "properties.encryption", "type": "VirtualNetworkEncryption"},
        "ip_allocations": {"key": "properties.ipAllocations", "type": "[SubResource]"},
        "flow_logs": {"key": "properties.flowLogs", "type": "[FlowLog]"},
        "private_endpoint_v_net_policies": {"key": "properties.privateEndpointVNetPolicies", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        address_space: Optional["_models.AddressSpace"] = None,
        dhcp_options: Optional["_models.DhcpOptions"] = None,
        flow_timeout_in_minutes: Optional[int] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        virtual_network_peerings: Optional[List["_models.VirtualNetworkPeering"]] = None,
        enable_ddos_protection: bool = False,
        enable_vm_protection: bool = False,
        ddos_protection_plan: Optional["_models.SubResource"] = None,
        bgp_communities: Optional["_models.VirtualNetworkBgpCommunities"] = None,
        encryption: Optional["_models.VirtualNetworkEncryption"] = None,
        ip_allocations: Optional[List["_models.SubResource"]] = None,
        private_endpoint_v_net_policies: Optional[Union[str, "_models.PrivateEndpointVNetPolicies"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the virtual network.
        :paramtype extended_location: ~azure.mgmt.network.models.ExtendedLocation
        :keyword address_space: The AddressSpace that contains an array of IP address ranges that can
         be used by subnets.
        :paramtype address_space: ~azure.mgmt.network.models.AddressSpace
        :keyword dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
         deployed in the virtual network.
        :paramtype dhcp_options: ~azure.mgmt.network.models.DhcpOptions
        :keyword flow_timeout_in_minutes: The FlowTimeout value (in minutes) for the Virtual Network.
        :paramtype flow_timeout_in_minutes: int
        :keyword subnets: A list of subnets in a Virtual Network.
        :paramtype subnets: list[~azure.mgmt.network.models.Subnet]
        :keyword virtual_network_peerings: A list of peerings in a Virtual Network.
        :paramtype virtual_network_peerings:
         list[~azure.mgmt.network.models.VirtualNetworkPeering]
        :keyword enable_ddos_protection: Indicates if DDoS protection is enabled for all the protected
         resources in the virtual network. It requires a DDoS protection plan associated with the
         resource.
        :paramtype enable_ddos_protection: bool
        :keyword enable_vm_protection: Indicates if VM protection is enabled for all the subnets in the
         virtual network.
        :paramtype enable_vm_protection: bool
        :keyword ddos_protection_plan: The DDoS protection plan associated with the virtual network.
        :paramtype ddos_protection_plan: ~azure.mgmt.network.models.SubResource
        :keyword bgp_communities: Bgp Communities sent over ExpressRoute with each route corresponding
         to a prefix in this VNET.
        :paramtype bgp_communities: ~azure.mgmt.network.models.VirtualNetworkBgpCommunities
        :keyword encryption: Indicates if encryption is enabled on virtual network and if VM without
         encryption is allowed in encrypted VNet.
        :paramtype encryption: ~azure.mgmt.network.models.VirtualNetworkEncryption
        :keyword ip_allocations: Array of IpAllocation which reference this VNET.
        :paramtype ip_allocations: list[~azure.mgmt.network.models.SubResource]
        :keyword private_endpoint_v_net_policies: Private Endpoint VNet Policies. Known values are:
         "Disabled" and "Basic".
        :paramtype private_endpoint_v_net_policies: str or
         ~azure.mgmt.network.models.PrivateEndpointVNetPolicies
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.etag = None
        self.address_space = address_space
        self.dhcp_options = dhcp_options
        self.flow_timeout_in_minutes = flow_timeout_in_minutes
        self.subnets = subnets
        self.virtual_network_peerings = virtual_network_peerings
        self.resource_guid = None
        self.provisioning_state = None
        self.enable_ddos_protection = enable_ddos_protection
        self.enable_vm_protection = enable_vm_protection
        self.ddos_protection_plan = ddos_protection_plan
        self.bgp_communities = bgp_communities
        self.encryption = encryption
        self.ip_allocations = ip_allocations
        self.flow_logs = None
        self.private_endpoint_v_net_policies = private_endpoint_v_net_policies

class VirtualNetworkGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of type local virtual network gateway.
    :vartype extended_location: ~azure.mgmt.network.models.ExtendedLocation
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar identity: The identity of the virtual network gateway, if configured.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar auto_scale_configuration: Autoscale configuration for virutal network gateway.
    :vartype auto_scale_configuration:
     ~azure.mgmt.network.models.VirtualNetworkGatewayAutoScaleConfiguration
    :ivar ip_configurations: IP configurations for virtual network gateway.
    :vartype ip_configurations:
     list[~azure.mgmt.network.models.VirtualNetworkGatewayIPConfiguration]
    :ivar gateway_type: The type of this virtual network gateway. Known values are: "Vpn",
     "ExpressRoute", and "LocalGateway".
    :vartype gateway_type: str or ~azure.mgmt.network.models.VirtualNetworkGatewayType
    :ivar vpn_type: The type of this virtual network gateway. Known values are: "PolicyBased" and
     "RouteBased".
    :vartype vpn_type: str or ~azure.mgmt.network.models.VpnType
    :ivar vpn_gateway_generation: The generation for this VirtualNetworkGateway. Must be None if
     gatewayType is not VPN. Known values are: "None", "Generation1", and "Generation2".
    :vartype vpn_gateway_generation: str or
     ~azure.mgmt.network.models.VpnGatewayGeneration
    :ivar enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
    :vartype enable_bgp: bool
    :ivar enable_private_ip_address: Whether private IP needs to be enabled on this gateway for
     connections or not.
    :vartype enable_private_ip_address: bool
    :ivar active: ActiveActive flag.
    :vartype active: bool
    :ivar disable_ip_sec_replay_protection: disableIPSecReplayProtection flag.
    :vartype disable_ip_sec_replay_protection: bool
    :ivar gateway_default_site: The reference to the LocalNetworkGateway resource which represents
     local network site having default routes. Assign Null value in case of removing existing
     default site setting.
    :vartype gateway_default_site: ~azure.mgmt.network.models.SubResource
    :ivar sku: The reference to the VirtualNetworkGatewaySku resource which represents the SKU
     selected for Virtual network gateway.
    :vartype sku: ~azure.mgmt.network.models.VirtualNetworkGatewaySku
    :ivar vpn_client_configuration: The reference to the VpnClientConfiguration resource which
     represents the P2S VpnClient configurations.
    :vartype vpn_client_configuration:
     ~azure.mgmt.network.models.VpnClientConfiguration
    :ivar virtual_network_gateway_policy_groups: The reference to the
     VirtualNetworkGatewayPolicyGroup resource which represents the available
     VirtualNetworkGatewayPolicyGroup for the gateway.
    :vartype virtual_network_gateway_policy_groups:
     list[~azure.mgmt.network.models.VirtualNetworkGatewayPolicyGroup]
    :ivar bgp_settings: Virtual network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.models.BgpSettings
    :ivar custom_routes: The reference to the address space resource which represents the custom
     routes address space specified by the customer for virtual network gateway and VpnClient.
    :vartype custom_routes: ~azure.mgmt.network.models.AddressSpace
    :ivar resource_guid: The resource GUID property of the virtual network gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar enable_dns_forwarding: Whether dns forwarding is enabled or not.
    :vartype enable_dns_forwarding: bool
    :ivar inbound_dns_forwarding_endpoint: The IP address allocated by the gateway to which dns
     requests can be sent.
    :vartype inbound_dns_forwarding_endpoint: str
    :ivar v_net_extended_location_resource_id: Customer vnet resource id. VirtualNetworkGateway of
     type local gateway is associated with the customer vnet.
    :vartype v_net_extended_location_resource_id: str
    :ivar nat_rules: NatRules for virtual network gateway.
    :vartype nat_rules: list[~azure.mgmt.network.models.VirtualNetworkGatewayNatRule]
    :ivar enable_bgp_route_translation_for_nat: EnableBgpRouteTranslationForNat flag.
    :vartype enable_bgp_route_translation_for_nat: bool
    :ivar allow_virtual_wan_traffic: Configures this gateway to accept traffic from remote Virtual
     WAN networks.
    :vartype allow_virtual_wan_traffic: bool
    :ivar allow_remote_vnet_traffic: Configure this gateway to accept traffic from other Azure
     Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
    :vartype allow_remote_vnet_traffic: bool
    :ivar admin_state: Property to indicate if the Express Route Gateway serves traffic when there
     are multiple Express Route Gateways in the vnet. Known values are: "Enabled" and "Disabled".
    :vartype admin_state: str or ~azure.mgmt.network.models.AdminState
    :ivar resiliency_model: Property to indicate if the Express Route Gateway has resiliency model
     of MultiHomed or SingleHomed. Known values are: "SingleHomed" and "MultiHomed".
    :vartype resiliency_model: str or ~azure.mgmt.network.models.ResiliencyModel
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "inbound_dns_forwarding_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "etag": {"key": "etag", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "auto_scale_configuration": {
            "key": "properties.autoScaleConfiguration",
            "type": "VirtualNetworkGatewayAutoScaleConfiguration",
        },
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VirtualNetworkGatewayIPConfiguration]"},
        "gateway_type": {"key": "properties.gatewayType", "type": "str"},
        "vpn_type": {"key": "properties.vpnType", "type": "str"},
        "vpn_gateway_generation": {"key": "properties.vpnGatewayGeneration", "type": "str"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "enable_private_ip_address": {"key": "properties.enablePrivateIpAddress", "type": "bool"},
        "active": {"key": "properties.activeActive", "type": "bool"},
        "disable_ip_sec_replay_protection": {"key": "properties.disableIPSecReplayProtection", "type": "bool"},
        "gateway_default_site": {"key": "properties.gatewayDefaultSite", "type": "SubResource"},
        "sku": {"key": "properties.sku", "type": "VirtualNetworkGatewaySku"},
        "vpn_client_configuration": {"key": "properties.vpnClientConfiguration", "type": "VpnClientConfiguration"},
        "virtual_network_gateway_policy_groups": {
            "key": "properties.virtualNetworkGatewayPolicyGroups",
            "type": "[VirtualNetworkGatewayPolicyGroup]",
        },
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "custom_routes": {"key": "properties.customRoutes", "type": "AddressSpace"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "enable_dns_forwarding": {"key": "properties.enableDnsForwarding", "type": "bool"},
        "inbound_dns_forwarding_endpoint": {"key": "properties.inboundDnsForwardingEndpoint", "type": "str"},
        "v_net_extended_location_resource_id": {"key": "properties.vNetExtendedLocationResourceId", "type": "str"},
        "nat_rules": {"key": "properties.natRules", "type": "[VirtualNetworkGatewayNatRule]"},
        "enable_bgp_route_translation_for_nat": {"key": "properties.enableBgpRouteTranslationForNat", "type": "bool"},
        "allow_virtual_wan_traffic": {"key": "properties.allowVirtualWanTraffic", "type": "bool"},
        "allow_remote_vnet_traffic": {"key": "properties.allowRemoteVnetTraffic", "type": "bool"},
        "admin_state": {"key": "properties.adminState", "type": "str"},
        "resiliency_model": {"key": "properties.resiliencyModel", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        auto_scale_configuration: Optional["_models.VirtualNetworkGatewayAutoScaleConfiguration"] = None,
        ip_configurations: Optional[List["_models.VirtualNetworkGatewayIPConfiguration"]] = None,
        gateway_type: Optional[Union[str, "_models.VirtualNetworkGatewayType"]] = None,
        vpn_type: Optional[Union[str, "_models.VpnType"]] = None,
        vpn_gateway_generation: Optional[Union[str, "_models.VpnGatewayGeneration"]] = None,
        enable_bgp: Optional[bool] = None,
        enable_private_ip_address: Optional[bool] = None,
        active: Optional[bool] = None,
        disable_ip_sec_replay_protection: Optional[bool] = None,
        gateway_default_site: Optional["_models.SubResource"] = None,
        sku: Optional["_models.VirtualNetworkGatewaySku"] = None,
        vpn_client_configuration: Optional["_models.VpnClientConfiguration"] = None,
        virtual_network_gateway_policy_groups: Optional[List["_models.VirtualNetworkGatewayPolicyGroup"]] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        custom_routes: Optional["_models.AddressSpace"] = None,
        enable_dns_forwarding: Optional[bool] = None,
        v_net_extended_location_resource_id: Optional[str] = None,
        nat_rules: Optional[List["_models.VirtualNetworkGatewayNatRule"]] = None,
        enable_bgp_route_translation_for_nat: Optional[bool] = None,
        allow_virtual_wan_traffic: Optional[bool] = None,
        allow_remote_vnet_traffic: Optional[bool] = None,
        admin_state: Optional[Union[str, "_models.AdminState"]] = None,
        resiliency_model: Optional[Union[str, "_models.ResiliencyModel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of type local virtual network gateway.
        :paramtype extended_location: ~azure.mgmt.network.models.ExtendedLocation
        :keyword identity: The identity of the virtual network gateway, if configured.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword auto_scale_configuration: Autoscale configuration for virutal network gateway.
        :paramtype auto_scale_configuration:
         ~azure.mgmt.network.models.VirtualNetworkGatewayAutoScaleConfiguration
        :keyword ip_configurations: IP configurations for virtual network gateway.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.models.VirtualNetworkGatewayIPConfiguration]
        :keyword gateway_type: The type of this virtual network gateway. Known values are: "Vpn",
         "ExpressRoute", and "LocalGateway".
        :paramtype gateway_type: str or
         ~azure.mgmt.network.models.VirtualNetworkGatewayType
        :keyword vpn_type: The type of this virtual network gateway. Known values are: "PolicyBased"
         and "RouteBased".
        :paramtype vpn_type: str or ~azure.mgmt.network.models.VpnType
        :keyword vpn_gateway_generation: The generation for this VirtualNetworkGateway. Must be None if
         gatewayType is not VPN. Known values are: "None", "Generation1", and "Generation2".
        :paramtype vpn_gateway_generation: str or
         ~azure.mgmt.network.models.VpnGatewayGeneration
        :keyword enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
        :paramtype enable_bgp: bool
        :keyword enable_private_ip_address: Whether private IP needs to be enabled on this gateway for
         connections or not.
        :paramtype enable_private_ip_address: bool
        :keyword active: ActiveActive flag.
        :paramtype active: bool
        :keyword disable_ip_sec_replay_protection: disableIPSecReplayProtection flag.
        :paramtype disable_ip_sec_replay_protection: bool
        :keyword gateway_default_site: The reference to the LocalNetworkGateway resource which
         represents local network site having default routes. Assign Null value in case of removing
         existing default site setting.
        :paramtype gateway_default_site: ~azure.mgmt.network.models.SubResource
        :keyword sku: The reference to the VirtualNetworkGatewaySku resource which represents the SKU
         selected for Virtual network gateway.
        :paramtype sku: ~azure.mgmt.network.models.VirtualNetworkGatewaySku
        :keyword vpn_client_configuration: The reference to the VpnClientConfiguration resource which
         represents the P2S VpnClient configurations.
        :paramtype vpn_client_configuration:
         ~azure.mgmt.network.models.VpnClientConfiguration
        :keyword virtual_network_gateway_policy_groups: The reference to the
         VirtualNetworkGatewayPolicyGroup resource which represents the available
         VirtualNetworkGatewayPolicyGroup for the gateway.
        :paramtype virtual_network_gateway_policy_groups:
         list[~azure.mgmt.network.models.VirtualNetworkGatewayPolicyGroup]
        :keyword bgp_settings: Virtual network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.models.BgpSettings
        :keyword custom_routes: The reference to the address space resource which represents the custom
         routes address space specified by the customer for virtual network gateway and VpnClient.
        :paramtype custom_routes: ~azure.mgmt.network.models.AddressSpace
        :keyword enable_dns_forwarding: Whether dns forwarding is enabled or not.
        :paramtype enable_dns_forwarding: bool
        :keyword v_net_extended_location_resource_id: Customer vnet resource id. VirtualNetworkGateway
         of type local gateway is associated with the customer vnet.
        :paramtype v_net_extended_location_resource_id: str
        :keyword nat_rules: NatRules for virtual network gateway.
        :paramtype nat_rules: list[~azure.mgmt.network.models.VirtualNetworkGatewayNatRule]
        :keyword enable_bgp_route_translation_for_nat: EnableBgpRouteTranslationForNat flag.
        :paramtype enable_bgp_route_translation_for_nat: bool
        :keyword allow_virtual_wan_traffic: Configures this gateway to accept traffic from remote
         Virtual WAN networks.
        :paramtype allow_virtual_wan_traffic: bool
        :keyword allow_remote_vnet_traffic: Configure this gateway to accept traffic from other Azure
         Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
        :paramtype allow_remote_vnet_traffic: bool
        :keyword admin_state: Property to indicate if the Express Route Gateway serves traffic when
         there are multiple Express Route Gateways in the vnet. Known values are: "Enabled" and
         "Disabled".
        :paramtype admin_state: str or ~azure.mgmt.network.models.AdminState
        :keyword resiliency_model: Property to indicate if the Express Route Gateway has resiliency
         model of MultiHomed or SingleHomed. Known values are: "SingleHomed" and "MultiHomed".
        :paramtype resiliency_model: str or ~azure.mgmt.network.models.ResiliencyModel
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.etag = None
        self.identity = identity
        self.auto_scale_configuration = auto_scale_configuration
        self.ip_configurations = ip_configurations
        self.gateway_type = gateway_type
        self.vpn_type = vpn_type
        self.vpn_gateway_generation = vpn_gateway_generation
        self.enable_bgp = enable_bgp
        self.enable_private_ip_address = enable_private_ip_address
        self.active = active
        self.disable_ip_sec_replay_protection = disable_ip_sec_replay_protection
        self.gateway_default_site = gateway_default_site
        self.sku = sku
        self.vpn_client_configuration = vpn_client_configuration
        self.virtual_network_gateway_policy_groups = virtual_network_gateway_policy_groups
        self.bgp_settings = bgp_settings
        self.custom_routes = custom_routes
        self.resource_guid = None
        self.provisioning_state = None
        self.enable_dns_forwarding = enable_dns_forwarding
        self.inbound_dns_forwarding_endpoint = None
        self.v_net_extended_location_resource_id = v_net_extended_location_resource_id
        self.nat_rules = nat_rules
        self.enable_bgp_route_translation_for_nat = enable_bgp_route_translation_for_nat
        self.allow_virtual_wan_traffic = allow_virtual_wan_traffic
        self.allow_remote_vnet_traffic = allow_remote_vnet_traffic
        self.admin_state = admin_state
        self.resiliency_model = resiliency_model

class VirtualNetworkGatewayConnection(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar virtual_network_gateway1: The reference to virtual network gateway resource. Required.
    :vartype virtual_network_gateway1: ~azure.mgmt.network.models.VirtualNetworkGateway
    :ivar virtual_network_gateway2: The reference to virtual network gateway resource.
    :vartype virtual_network_gateway2: ~azure.mgmt.network.models.VirtualNetworkGateway
    :ivar local_network_gateway2: The reference to local network gateway resource.
    :vartype local_network_gateway2: ~azure.mgmt.network.models.LocalNetworkGateway
    :ivar ingress_nat_rules: List of ingress NatRules.
    :vartype ingress_nat_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar egress_nat_rules: List of egress NatRules.
    :vartype egress_nat_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar connection_type: Gateway connection type. Required. Known values are: "IPsec",
     "Vnet2Vnet", "ExpressRoute", and "VPNClient".
    :vartype connection_type: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionType
    :ivar connection_protocol: Connection protocol used for this connection. Known values are:
     "IKEv2" and "IKEv1".
    :vartype connection_protocol: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionProtocol
    :ivar routing_weight: The routing weight.
    :vartype routing_weight: int
    :ivar dpd_timeout_seconds: The dead peer detection timeout of this connection in seconds.
    :vartype dpd_timeout_seconds: int
    :ivar connection_mode: The connection mode for this connection. Known values are: "Default",
     "ResponderOnly", and "InitiatorOnly".
    :vartype connection_mode: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionMode
    :ivar shared_key: The IPSec shared key.
    :vartype shared_key: str
    :ivar connection_status: Virtual Network Gateway connection status. Known values are:
     "Unknown", "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar peer: The reference to peerings resource.
    :vartype peer: ~azure.mgmt.network.models.SubResource
    :ivar enable_bgp: EnableBgp flag.
    :vartype enable_bgp: bool
    :ivar gateway_custom_bgp_ip_addresses: GatewayCustomBgpIpAddresses to be used for virtual
     network gateway Connection.
    :vartype gateway_custom_bgp_ip_addresses:
     list[~azure.mgmt.network.models.GatewayCustomBgpIpAddressIpConfiguration]
    :ivar use_local_azure_ip_address: Use private local Azure IP for the connection.
    :vartype use_local_azure_ip_address: bool
    :ivar use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :vartype use_policy_based_traffic_selectors: bool
    :ivar ipsec_policies: The IPSec Policies to be considered by this connection.
    :vartype ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
    :ivar traffic_selector_policies: The Traffic Selector Policies to be considered by this
     connection.
    :vartype traffic_selector_policies:
     list[~azure.mgmt.network.models.TrafficSelectorPolicy]
    :ivar resource_guid: The resource GUID property of the virtual network gateway connection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
    :vartype express_route_gateway_bypass: bool
    :ivar enable_private_link_fast_path: Bypass the ExpressRoute gateway when accessing
     private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
    :vartype enable_private_link_fast_path: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "virtual_network_gateway1": {"required": True},
        "connection_type": {"required": True},
        "connection_status": {"readonly": True},
        "tunnel_connection_status": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "virtual_network_gateway1": {"key": "properties.virtualNetworkGateway1", "type": "VirtualNetworkGateway"},
        "virtual_network_gateway2": {"key": "properties.virtualNetworkGateway2", "type": "VirtualNetworkGateway"},
        "local_network_gateway2": {"key": "properties.localNetworkGateway2", "type": "LocalNetworkGateway"},
        "ingress_nat_rules": {"key": "properties.ingressNatRules", "type": "[SubResource]"},
        "egress_nat_rules": {"key": "properties.egressNatRules", "type": "[SubResource]"},
        "connection_type": {"key": "properties.connectionType", "type": "str"},
        "connection_protocol": {"key": "properties.connectionProtocol", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "dpd_timeout_seconds": {"key": "properties.dpdTimeoutSeconds", "type": "int"},
        "connection_mode": {"key": "properties.connectionMode", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "tunnel_connection_status": {"key": "properties.tunnelConnectionStatus", "type": "[TunnelConnectionHealth]"},
        "egress_bytes_transferred": {"key": "properties.egressBytesTransferred", "type": "int"},
        "ingress_bytes_transferred": {"key": "properties.ingressBytesTransferred", "type": "int"},
        "peer": {"key": "properties.peer", "type": "SubResource"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "gateway_custom_bgp_ip_addresses": {
            "key": "properties.gatewayCustomBgpIpAddresses",
            "type": "[GatewayCustomBgpIpAddressIpConfiguration]",
        },
        "use_local_azure_ip_address": {"key": "properties.useLocalAzureIpAddress", "type": "bool"},
        "use_policy_based_traffic_selectors": {"key": "properties.usePolicyBasedTrafficSelectors", "type": "bool"},
        "ipsec_policies": {"key": "properties.ipsecPolicies", "type": "[IpsecPolicy]"},
        "traffic_selector_policies": {"key": "properties.trafficSelectorPolicies", "type": "[TrafficSelectorPolicy]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "express_route_gateway_bypass": {"key": "properties.expressRouteGatewayBypass", "type": "bool"},
        "enable_private_link_fast_path": {"key": "properties.enablePrivateLinkFastPath", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        virtual_network_gateway1: "_models.VirtualNetworkGateway",
        connection_type: Union[str, "_models.VirtualNetworkGatewayConnectionType"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway2: Optional["_models.VirtualNetworkGateway"] = None,
        local_network_gateway2: Optional["_models.LocalNetworkGateway"] = None,
        ingress_nat_rules: Optional[List["_models.SubResource"]] = None,
        egress_nat_rules: Optional[List["_models.SubResource"]] = None,
        connection_protocol: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionProtocol"]] = None,
        routing_weight: Optional[int] = None,
        dpd_timeout_seconds: Optional[int] = None,
        connection_mode: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionMode"]] = None,
        shared_key: Optional[str] = None,
        peer: Optional["_models.SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        gateway_custom_bgp_ip_addresses: Optional[List["_models.GatewayCustomBgpIpAddressIpConfiguration"]] = None,
        use_local_azure_ip_address: Optional[bool] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        traffic_selector_policies: Optional[List["_models.TrafficSelectorPolicy"]] = None,
        express_route_gateway_bypass: Optional[bool] = None,
        enable_private_link_fast_path: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword virtual_network_gateway1: The reference to virtual network gateway resource. Required.
        :paramtype virtual_network_gateway1:
         ~azure.mgmt.network.models.VirtualNetworkGateway
        :keyword virtual_network_gateway2: The reference to virtual network gateway resource.
        :paramtype virtual_network_gateway2:
         ~azure.mgmt.network.models.VirtualNetworkGateway
        :keyword local_network_gateway2: The reference to local network gateway resource.
        :paramtype local_network_gateway2: ~azure.mgmt.network.models.LocalNetworkGateway
        :keyword ingress_nat_rules: List of ingress NatRules.
        :paramtype ingress_nat_rules: list[~azure.mgmt.network.models.SubResource]
        :keyword egress_nat_rules: List of egress NatRules.
        :paramtype egress_nat_rules: list[~azure.mgmt.network.models.SubResource]
        :keyword connection_type: Gateway connection type. Required. Known values are: "IPsec",
         "Vnet2Vnet", "ExpressRoute", and "VPNClient".
        :paramtype connection_type: str or
         ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionType
        :keyword connection_protocol: Connection protocol used for this connection. Known values are:
         "IKEv2" and "IKEv1".
        :paramtype connection_protocol: str or
         ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionProtocol
        :keyword routing_weight: The routing weight.
        :paramtype routing_weight: int
        :keyword dpd_timeout_seconds: The dead peer detection timeout of this connection in seconds.
        :paramtype dpd_timeout_seconds: int
        :keyword connection_mode: The connection mode for this connection. Known values are: "Default",
         "ResponderOnly", and "InitiatorOnly".
        :paramtype connection_mode: str or
         ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionMode
        :keyword shared_key: The IPSec shared key.
        :paramtype shared_key: str
        :keyword peer: The reference to peerings resource.
        :paramtype peer: ~azure.mgmt.network.models.SubResource
        :keyword enable_bgp: EnableBgp flag.
        :paramtype enable_bgp: bool
        :keyword gateway_custom_bgp_ip_addresses: GatewayCustomBgpIpAddresses to be used for virtual
         network gateway Connection.
        :paramtype gateway_custom_bgp_ip_addresses:
         list[~azure.mgmt.network.models.GatewayCustomBgpIpAddressIpConfiguration]
        :keyword use_local_azure_ip_address: Use private local Azure IP for the connection.
        :paramtype use_local_azure_ip_address: bool
        :keyword use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :paramtype use_policy_based_traffic_selectors: bool
        :keyword ipsec_policies: The IPSec Policies to be considered by this connection.
        :paramtype ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
        :keyword traffic_selector_policies: The Traffic Selector Policies to be considered by this
         connection.
        :paramtype traffic_selector_policies:
         list[~azure.mgmt.network.models.TrafficSelectorPolicy]
        :keyword express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
        :paramtype express_route_gateway_bypass: bool
        :keyword enable_private_link_fast_path: Bypass the ExpressRoute gateway when accessing
         private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
        :paramtype enable_private_link_fast_path: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.ingress_nat_rules = ingress_nat_rules
        self.egress_nat_rules = egress_nat_rules
        self.connection_type = connection_type
        self.connection_protocol = connection_protocol
        self.routing_weight = routing_weight
        self.dpd_timeout_seconds = dpd_timeout_seconds
        self.connection_mode = connection_mode
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.gateway_custom_bgp_ip_addresses = gateway_custom_bgp_ip_addresses
        self.use_local_azure_ip_address = use_local_azure_ip_address
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.traffic_selector_policies = traffic_selector_policies
        self.resource_guid = None
        self.provisioning_state = None
        self.express_route_gateway_bypass = express_route_gateway_bypass
        self.enable_private_link_fast_path = enable_private_link_fast_path

class VirtualNetworkGatewayConnectionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for the ListVirtualNetworkGatewayConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :vartype value: list[~azure.mgmt.network.models.VirtualNetworkGatewayConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGatewayConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetworkGatewayConnection"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
         group.
        :paramtype value: list[~azure.mgmt.network.models.VirtualNetworkGatewayConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_allocation_method: The private IP address allocation method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.models.IPAllocationMethod
    :ivar subnet: The reference to the subnet resource.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar public_ip_address: The reference to the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.models.SubResource
    :ivar private_ip_address: Private IP Address for this gateway.
    :vartype private_ip_address: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway IP
     configuration resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "private_ip_address": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword private_ip_allocation_method: The private IP address allocation method. Known values
         are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.models.IPAllocationMethod
        :keyword subnet: The reference to the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword public_ip_address: The reference to the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.private_ip_address = None
        self.provisioning_state = None

class VirtualNetworkGatewayListResult(_serialization.Model):
    """Response for the ListVirtualNetworkGateways API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of VirtualNetworkGateway resources that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.models.VirtualNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualNetworkGateway"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of VirtualNetworkGateway resources that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.VirtualNetworkGateway]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class VirtualNetworkGatewaySku(_serialization.Model):
    """VirtualNetworkGatewaySku details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gateway SKU name. Known values are: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
     "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", "ErGw3AZ", and "ErGwScale".
    :vartype name: str or ~azure.mgmt.network.models.VirtualNetworkGatewaySkuName
    :ivar tier: Gateway SKU tier. Known values are: "Basic", "HighPerformance", "Standard",
     "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
     "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", "ErGw3AZ", and "ErGwScale".
    :vartype tier: str or ~azure.mgmt.network.models.VirtualNetworkGatewaySkuTier
    :ivar capacity: The capacity.
    :vartype capacity: int
    """

    _validation = {
        "capacity": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.VirtualNetworkGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.VirtualNetworkGatewaySkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gateway SKU name. Known values are: "Basic", "HighPerformance", "Standard",
         "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
         "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", "ErGw3AZ", and "ErGwScale".
        :paramtype name: str or ~azure.mgmt.network.models.VirtualNetworkGatewaySkuName
        :keyword tier: Gateway SKU tier. Known values are: "Basic", "HighPerformance", "Standard",
         "UltraPerformance", "VpnGw1", "VpnGw2", "VpnGw3", "VpnGw4", "VpnGw5", "VpnGw1AZ", "VpnGw2AZ",
         "VpnGw3AZ", "VpnGw4AZ", "VpnGw5AZ", "ErGw1AZ", "ErGw2AZ", "ErGw3AZ", and "ErGwScale".
        :paramtype tier: str or ~azure.mgmt.network.models.VirtualNetworkGatewaySkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = None

class VirtualNetworkListResult(_serialization.Model):
    """Response for the ListVirtualNetworks API service call.

    :ivar value: A list of VirtualNetwork resources in a resource group.
    :vartype value: list[~azure.mgmt.network.models.VirtualNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetwork"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of VirtualNetwork resources in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.VirtualNetwork]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VpnClientConfiguration(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """VpnClientConfiguration for P2S client.

    :ivar vpn_client_address_pool: The reference to the address space resource which represents
     Address space for P2S VpnClient.
    :vartype vpn_client_address_pool: ~azure.mgmt.network.models.AddressSpace
    :ivar vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
    :vartype vpn_client_root_certificates:
     list[~azure.mgmt.network.models.VpnClientRootCertificate]
    :ivar vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network gateway.
    :vartype vpn_client_revoked_certificates:
     list[~azure.mgmt.network.models.VpnClientRevokedCertificate]
    :ivar vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
    :vartype vpn_client_protocols: list[str or
     ~azure.mgmt.network.models.VpnClientProtocol]
    :ivar vpn_authentication_types: VPN authentication types for the virtual network gateway..
    :vartype vpn_authentication_types: list[str or
     ~azure.mgmt.network.models.VpnAuthenticationType]
    :ivar vpn_client_ipsec_policies: VpnClientIpsecPolicies for virtual network gateway P2S client.
    :vartype vpn_client_ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
    :ivar radius_server_address: The radius server address property of the VirtualNetworkGateway
     resource for vpn client connection.
    :vartype radius_server_address: str
    :ivar radius_server_secret: The radius secret property of the VirtualNetworkGateway resource
     for vpn client connection.
    :vartype radius_server_secret: str
    :ivar radius_servers: The radiusServers property for multiple radius server configuration.
    :vartype radius_servers: list[~azure.mgmt.network.models.RadiusServer]
    :ivar aad_tenant: The AADTenant property of the VirtualNetworkGateway resource for vpn client
     connection used for AAD authentication.
    :vartype aad_tenant: str
    :ivar aad_audience: The AADAudience property of the VirtualNetworkGateway resource for vpn
     client connection used for AAD authentication.
    :vartype aad_audience: str
    :ivar aad_issuer: The AADIssuer property of the VirtualNetworkGateway resource for vpn client
     connection used for AAD authentication.
    :vartype aad_issuer: str
    :ivar vng_client_connection_configurations: per ip address pool connection policy for virtual
     network gateway P2S client.
    :vartype vng_client_connection_configurations:
     list[~azure.mgmt.network.models.VngClientConnectionConfiguration]
    """

    _attribute_map = {
        "vpn_client_address_pool": {"key": "vpnClientAddressPool", "type": "AddressSpace"},
        "vpn_client_root_certificates": {"key": "vpnClientRootCertificates", "type": "[VpnClientRootCertificate]"},
        "vpn_client_revoked_certificates": {
            "key": "vpnClientRevokedCertificates",
            "type": "[VpnClientRevokedCertificate]",
        },
        "vpn_client_protocols": {"key": "vpnClientProtocols", "type": "[str]"},
        "vpn_authentication_types": {"key": "vpnAuthenticationTypes", "type": "[str]"},
        "vpn_client_ipsec_policies": {"key": "vpnClientIpsecPolicies", "type": "[IpsecPolicy]"},
        "radius_server_address": {"key": "radiusServerAddress", "type": "str"},
        "radius_server_secret": {"key": "radiusServerSecret", "type": "str"},
        "radius_servers": {"key": "radiusServers", "type": "[RadiusServer]"},
        "aad_tenant": {"key": "aadTenant", "type": "str"},
        "aad_audience": {"key": "aadAudience", "type": "str"},
        "aad_issuer": {"key": "aadIssuer", "type": "str"},
        "vng_client_connection_configurations": {
            "key": "vngClientConnectionConfigurations",
            "type": "[VngClientConnectionConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        vpn_client_address_pool: Optional["_models.AddressSpace"] = None,
        vpn_client_root_certificates: Optional[List["_models.VpnClientRootCertificate"]] = None,
        vpn_client_revoked_certificates: Optional[List["_models.VpnClientRevokedCertificate"]] = None,
        vpn_client_protocols: Optional[List[Union[str, "_models.VpnClientProtocol"]]] = None,
        vpn_authentication_types: Optional[List[Union[str, "_models.VpnAuthenticationType"]]] = None,
        vpn_client_ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        radius_server_address: Optional[str] = None,
        radius_server_secret: Optional[str] = None,
        radius_servers: Optional[List["_models.RadiusServer"]] = None,
        aad_tenant: Optional[str] = None,
        aad_audience: Optional[str] = None,
        aad_issuer: Optional[str] = None,
        vng_client_connection_configurations: Optional[List["_models.VngClientConnectionConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vpn_client_address_pool: The reference to the address space resource which represents
         Address space for P2S VpnClient.
        :paramtype vpn_client_address_pool: ~azure.mgmt.network.models.AddressSpace
        :keyword vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
        :paramtype vpn_client_root_certificates:
         list[~azure.mgmt.network.models.VpnClientRootCertificate]
        :keyword vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network
         gateway.
        :paramtype vpn_client_revoked_certificates:
         list[~azure.mgmt.network.models.VpnClientRevokedCertificate]
        :keyword vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
        :paramtype vpn_client_protocols: list[str or
         ~azure.mgmt.network.models.VpnClientProtocol]
        :keyword vpn_authentication_types: VPN authentication types for the virtual network gateway..
        :paramtype vpn_authentication_types: list[str or
         ~azure.mgmt.network.models.VpnAuthenticationType]
        :keyword vpn_client_ipsec_policies: VpnClientIpsecPolicies for virtual network gateway P2S
         client.
        :paramtype vpn_client_ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
        :keyword radius_server_address: The radius server address property of the VirtualNetworkGateway
         resource for vpn client connection.
        :paramtype radius_server_address: str
        :keyword radius_server_secret: The radius secret property of the VirtualNetworkGateway resource
         for vpn client connection.
        :paramtype radius_server_secret: str
        :keyword radius_servers: The radiusServers property for multiple radius server configuration.
        :paramtype radius_servers: list[~azure.mgmt.network.models.RadiusServer]
        :keyword aad_tenant: The AADTenant property of the VirtualNetworkGateway resource for vpn
         client connection used for AAD authentication.
        :paramtype aad_tenant: str
        :keyword aad_audience: The AADAudience property of the VirtualNetworkGateway resource for vpn
         client connection used for AAD authentication.
        :paramtype aad_audience: str
        :keyword aad_issuer: The AADIssuer property of the VirtualNetworkGateway resource for vpn
         client connection used for AAD authentication.
        :paramtype aad_issuer: str
        :keyword vng_client_connection_configurations: per ip address pool connection policy for
         virtual network gateway P2S client.
        :paramtype vng_client_connection_configurations:
         list[~azure.mgmt.network.models.VngClientConnectionConfiguration]
        """
        super().__init__(**kwargs)
        self.vpn_client_address_pool = vpn_client_address_pool
        self.vpn_client_root_certificates = vpn_client_root_certificates
        self.vpn_client_revoked_certificates = vpn_client_revoked_certificates
        self.vpn_client_protocols = vpn_client_protocols
        self.vpn_authentication_types = vpn_authentication_types
        self.vpn_client_ipsec_policies = vpn_client_ipsec_policies
        self.radius_server_address = radius_server_address
        self.radius_server_secret = radius_server_secret
        self.radius_servers = radius_servers
        self.aad_tenant = aad_tenant
        self.aad_audience = aad_audience
        self.aad_issuer = aad_issuer
        self.vng_client_connection_configurations = vng_client_connection_configurations

class VpnClientParameters(_serialization.Model):
    """Vpn Client Parameters for package generation.

    :ivar processor_architecture: VPN client Processor Architecture. Known values are: "Amd64" and
     "X86".
    :vartype processor_architecture: str or
     ~azure.mgmt.network.models.ProcessorArchitecture
    :ivar authentication_method: VPN client authentication method. Known values are: "EAPTLS" and
     "EAPMSCHAPv2".
    :vartype authentication_method: str or
     ~azure.mgmt.network.models.AuthenticationMethod
    :ivar radius_server_auth_certificate: The public certificate data for the radius server
     authentication certificate as a Base-64 encoded string. Required only if external radius
     authentication has been configured with EAPTLS authentication.
    :vartype radius_server_auth_certificate: str
    :ivar client_root_certificates: A list of client root certificates public certificate data
     encoded as Base-64 strings. Optional parameter for external radius based authentication with
     EAPTLS.
    :vartype client_root_certificates: list[str]
    """

    _attribute_map = {
        "processor_architecture": {"key": "processorArchitecture", "type": "str"},
        "authentication_method": {"key": "authenticationMethod", "type": "str"},
        "radius_server_auth_certificate": {"key": "radiusServerAuthCertificate", "type": "str"},
        "client_root_certificates": {"key": "clientRootCertificates", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        processor_architecture: Optional[Union[str, "_models.ProcessorArchitecture"]] = None,
        authentication_method: Optional[Union[str, "_models.AuthenticationMethod"]] = None,
        radius_server_auth_certificate: Optional[str] = None,
        client_root_certificates: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword processor_architecture: VPN client Processor Architecture. Known values are: "Amd64"
         and "X86".
        :paramtype processor_architecture: str or
         ~azure.mgmt.network.models.ProcessorArchitecture
        :keyword authentication_method: VPN client authentication method. Known values are: "EAPTLS"
         and "EAPMSCHAPv2".
        :paramtype authentication_method: str or
         ~azure.mgmt.network.models.AuthenticationMethod
        :keyword radius_server_auth_certificate: The public certificate data for the radius server
         authentication certificate as a Base-64 encoded string. Required only if external radius
         authentication has been configured with EAPTLS authentication.
        :paramtype radius_server_auth_certificate: str
        :keyword client_root_certificates: A list of client root certificates public certificate data
         encoded as Base-64 strings. Optional parameter for external radius based authentication with
         EAPTLS.
        :paramtype client_root_certificates: list[str]
        """
        super().__init__(**kwargs)
        self.processor_architecture = processor_architecture
        self.authentication_method = authentication_method
        self.radius_server_auth_certificate = radius_server_auth_certificate
        self.client_root_certificates = client_root_certificates

class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar thumbprint: The revoked VPN client certificate thumbprint.
    :vartype thumbprint: str
    :ivar provisioning_state: The provisioning state of the VPN client revoked certificate
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword thumbprint: The revoked VPN client certificate thumbprint.
        :paramtype thumbprint: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.thumbprint = thumbprint
        self.provisioning_state = None

class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar public_cert_data: The certificate public data. Required.
    :vartype public_cert_data: str
    :ivar provisioning_state: The provisioning state of the VPN client root certificate resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "public_cert_data": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_cert_data: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword public_cert_data: The certificate public data. Required.
        :paramtype public_cert_data: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.public_cert_data = public_cert_data
        self.provisioning_state = None

class ApplicationGatewayAuthenticationCertificate(SubResource):  # pylint: disable=name-too-long
    """Authentication certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the authentication certificate that is unique within an Application
     Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Certificate public data.
    :vartype data: str
    :ivar provisioning_state: The provisioning state of the authentication certificate resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the authentication certificate that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword data: Certificate public data.
        :paramtype data: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.data = data
        self.provisioning_state = None

class ApplicationGatewayAvailableSslOptions(Resource):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar predefined_policies: List of available Ssl predefined policy.
    :vartype predefined_policies: list[~azure.mgmt.network.models.SubResource]
    :ivar default_policy: Name of the Ssl predefined policy applied by default to application
     gateway. Known values are: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401",
     "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101", and "AppGwSslPolicy20220101S".
    :vartype default_policy: str or
     ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
    :ivar available_cipher_suites: List of available Ssl cipher suites.
    :vartype available_cipher_suites: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
    :ivar available_protocols: List of available Ssl protocols.
    :vartype available_protocols: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslProtocol]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "predefined_policies": {"key": "properties.predefinedPolicies", "type": "[SubResource]"},
        "default_policy": {"key": "properties.defaultPolicy", "type": "str"},
        "available_cipher_suites": {"key": "properties.availableCipherSuites", "type": "[str]"},
        "available_protocols": {"key": "properties.availableProtocols", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        predefined_policies: Optional[List["_models.SubResource"]] = None,
        default_policy: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None,
        available_cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        available_protocols: Optional[List[Union[str, "_models.ApplicationGatewaySslProtocol"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword predefined_policies: List of available Ssl predefined policy.
        :paramtype predefined_policies: list[~azure.mgmt.network.models.SubResource]
        :keyword default_policy: Name of the Ssl predefined policy applied by default to application
         gateway. Known values are: "AppGwSslPolicy20150501", "AppGwSslPolicy20170401",
         "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101", and "AppGwSslPolicy20220101S".
        :paramtype default_policy: str or
         ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
        :keyword available_cipher_suites: List of available Ssl cipher suites.
        :paramtype available_cipher_suites: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
        :keyword available_protocols: List of available Ssl protocols.
        :paramtype available_protocols: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslProtocol]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.predefined_policies = predefined_policies
        self.default_policy = default_policy
        self.available_cipher_suites = available_cipher_suites
        self.available_protocols = available_protocols

class ApplicationGatewayAvailableSslPredefinedPolicies(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    :ivar value: List of available Ssl predefined policy.
    :vartype value:
     list[~azure.mgmt.network.models.ApplicationGatewaySslPredefinedPolicy]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewaySslPredefinedPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationGatewaySslPredefinedPolicy"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of available Ssl predefined policy.
        :paramtype value:
         list[~azure.mgmt.network.models.ApplicationGatewaySslPredefinedPolicy]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ApplicationGatewayAvailableWafRuleSetsResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ApplicationGatewayAvailableWafRuleSets API service call.

    :ivar value: The list of application gateway rule sets.
    :vartype value: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleSet]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGatewayFirewallRuleSet]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ApplicationGatewayFirewallRuleSet"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of application gateway rule sets.
        :paramtype value:
         list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleSet]
        """
        super().__init__(**kwargs)
        self.value = value

class ApplicationGatewayBackendHealth(_serialization.Model):
    """Response for ApplicationGatewayBackendHealth API service call.

    :ivar backend_address_pools: A list of ApplicationGatewayBackendHealthPool resources.
    :vartype backend_address_pools:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthPool]
    """

    _attribute_map = {
        "backend_address_pools": {"key": "backendAddressPools", "type": "[ApplicationGatewayBackendHealthPool]"},
    }

    def __init__(
        self,
        *,
        backend_address_pools: Optional[List["_models.ApplicationGatewayBackendHealthPool"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backend_address_pools: A list of ApplicationGatewayBackendHealthPool resources.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthPool]
        """
        super().__init__(**kwargs)
        self.backend_address_pools = backend_address_pools

class ApplicationGatewayBackendHealthHttpSettings(_serialization.Model):  # pylint: disable=name-too-long
    """Application gateway BackendHealthHttp settings.

    :ivar backend_http_settings: Reference to an ApplicationGatewayBackendHttpSettings resource.
    :vartype backend_http_settings:
     ~azure.mgmt.network.models.ApplicationGatewayBackendHttpSettings
    :ivar servers: List of ApplicationGatewayBackendHealthServer resources.
    :vartype servers:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthServer]
    """

    _attribute_map = {
        "backend_http_settings": {"key": "backendHttpSettings", "type": "ApplicationGatewayBackendHttpSettings"},
        "servers": {"key": "servers", "type": "[ApplicationGatewayBackendHealthServer]"},
    }

    def __init__(
        self,
        *,
        backend_http_settings: Optional["_models.ApplicationGatewayBackendHttpSettings"] = None,
        servers: Optional[List["_models.ApplicationGatewayBackendHealthServer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backend_http_settings: Reference to an ApplicationGatewayBackendHttpSettings resource.
        :paramtype backend_http_settings:
         ~azure.mgmt.network.models.ApplicationGatewayBackendHttpSettings
        :keyword servers: List of ApplicationGatewayBackendHealthServer resources.
        :paramtype servers:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthServer]
        """
        super().__init__(**kwargs)
        self.backend_http_settings = backend_http_settings
        self.servers = servers

class ApplicationGatewayBackendHealthPool(_serialization.Model):
    """Application gateway BackendHealth pool.

    :ivar backend_address_pool: Reference to an ApplicationGatewayBackendAddressPool resource.
    :vartype backend_address_pool:
     ~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool
    :ivar backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
     resources.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthHttpSettings]
    """

    _attribute_map = {
        "backend_address_pool": {"key": "backendAddressPool", "type": "ApplicationGatewayBackendAddressPool"},
        "backend_http_settings_collection": {
            "key": "backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHealthHttpSettings]",
        },
    }

    def __init__(
        self,
        *,
        backend_address_pool: Optional["_models.ApplicationGatewayBackendAddressPool"] = None,
        backend_http_settings_collection: Optional[List["_models.ApplicationGatewayBackendHealthHttpSettings"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backend_address_pool: Reference to an ApplicationGatewayBackendAddressPool resource.
        :paramtype backend_address_pool:
         ~azure.mgmt.network.models.ApplicationGatewayBackendAddressPool
        :keyword backend_http_settings_collection: List of ApplicationGatewayBackendHealthHttpSettings
         resources.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.models.ApplicationGatewayBackendHealthHttpSettings]
        """
        super().__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings_collection = backend_http_settings_collection

class ApplicationGatewayBackendHealthServer(_serialization.Model):
    """Application gateway backendhealth http settings.

    :ivar address: IP address or FQDN of backend server.
    :vartype address: str
    :ivar ip_configuration: Reference to IP configuration of backend server.
    :vartype ip_configuration:
     ~azure.mgmt.network.models.NetworkInterfaceIPConfiguration
    :ivar health: Health of backend server. Known values are: "Unknown", "Up", "Down", "Partial",
     and "Draining".
    :vartype health: str or
     ~azure.mgmt.network.models.ApplicationGatewayBackendHealthServerHealth
    :ivar health_probe_log: Health Probe Log.
    :vartype health_probe_log: str
    """

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "ip_configuration": {"key": "ipConfiguration", "type": "NetworkInterfaceIPConfiguration"},
        "health": {"key": "health", "type": "str"},
        "health_probe_log": {"key": "healthProbeLog", "type": "str"},
    }

    def __init__(
        self,
        *,
        address: Optional[str] = None,
        ip_configuration: Optional["_models.NetworkInterfaceIPConfiguration"] = None,
        health: Optional[Union[str, "_models.ApplicationGatewayBackendHealthServerHealth"]] = None,
        health_probe_log: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address: IP address or FQDN of backend server.
        :paramtype address: str
        :keyword ip_configuration: Reference to IP configuration of backend server.
        :paramtype ip_configuration:
         ~azure.mgmt.network.models.NetworkInterfaceIPConfiguration
        :keyword health: Health of backend server. Known values are: "Unknown", "Up", "Down",
         "Partial", and "Draining".
        :paramtype health: str or
         ~azure.mgmt.network.models.ApplicationGatewayBackendHealthServerHealth
        :keyword health_probe_log: Health Probe Log.
        :paramtype health_probe_log: str
        """
        super().__init__(**kwargs)
        self.address = address
        self.ip_configuration = ip_configuration
        self.health = health
        self.health_probe_log = health_probe_log

class ApplicationGatewayConnectionDraining(_serialization.Model):
    """Connection draining allows open connections to a backend server to be active for a specified
    time after the backend server got removed from the configuration.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether connection draining is enabled or not. Required.
    :vartype enabled: bool
    :ivar drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable
     values are from 1 second to 3600 seconds. Required.
    :vartype drain_timeout_in_sec: int
    """

    _validation = {
        "enabled": {"required": True},
        "drain_timeout_in_sec": {"required": True, "maximum": 3600, "minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "drain_timeout_in_sec": {"key": "drainTimeoutInSec", "type": "int"},
    }

    def __init__(self, *, enabled: bool, drain_timeout_in_sec: int, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether connection draining is enabled or not. Required.
        :paramtype enabled: bool
        :keyword drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable
         values are from 1 second to 3600 seconds. Required.
        :paramtype drain_timeout_in_sec: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.drain_timeout_in_sec = drain_timeout_in_sec

class ApplicationGatewayFirewallDisabledRuleGroup(_serialization.Model):  # pylint: disable=name-too-long
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to server.

    :ivar rule_group_name: The name of the rule group that will be disabled. Required.
    :vartype rule_group_name: str
    :ivar rules: The list of rules that will be disabled. If null, all rules of the rule group will
     be disabled.
    :vartype rules: list[int]
    """

    _validation = {
        "rule_group_name": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "rules": {"key": "rules", "type": "[int]"},
    }

    def __init__(self, *, rule_group_name: str, rules: Optional[List[int]] = None, **kwargs: Any) -> None:
        """
        :keyword rule_group_name: The name of the rule group that will be disabled. Required.
        :paramtype rule_group_name: str
        :keyword rules: The list of rules that will be disabled. If null, all rules of the rule group
         will be disabled.
        :paramtype rules: list[int]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules

class ApplicationGatewayFirewallRule(_serialization.Model):
    """A web application firewall rule.

    All required parameters must be populated in order to send to server.

    :ivar rule_id: The identifier of the web application firewall rule. Required.
    :vartype rule_id: int
    :ivar rule_id_string: The string representation of the web application firewall rule
     identifier.
    :vartype rule_id_string: str
    :ivar state: The string representation of the web application firewall rule state. Known values
     are: "Enabled" and "Disabled".
    :vartype state: str or
     ~azure.mgmt.network.models.ApplicationGatewayWafRuleStateTypes
    :ivar action: The string representation of the web application firewall rule action. Known
     values are: "None", "AnomalyScoring", "Allow", "Block", and "Log".
    :vartype action: str or
     ~azure.mgmt.network.models.ApplicationGatewayWafRuleActionTypes
    :ivar sensitivity: The string representation of the web application firewall rule sensitivity.
     Known values are: "None", "Low", "Medium", and "High".
    :vartype sensitivity: str or
     ~azure.mgmt.network.models.ApplicationGatewayWafRuleSensitivityTypes
    :ivar description: The description of the web application firewall rule.
    :vartype description: str
    """

    _validation = {
        "rule_id": {"required": True},
    }

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "int"},
        "rule_id_string": {"key": "ruleIdString", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "sensitivity": {"key": "sensitivity", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        rule_id: int,
        rule_id_string: Optional[str] = None,
        state: Optional[Union[str, "_models.ApplicationGatewayWafRuleStateTypes"]] = None,
        action: Optional[Union[str, "_models.ApplicationGatewayWafRuleActionTypes"]] = None,
        sensitivity: Optional[Union[str, "_models.ApplicationGatewayWafRuleSensitivityTypes"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_id: The identifier of the web application firewall rule. Required.
        :paramtype rule_id: int
        :keyword rule_id_string: The string representation of the web application firewall rule
         identifier.
        :paramtype rule_id_string: str
        :keyword state: The string representation of the web application firewall rule state. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or
         ~azure.mgmt.network.models.ApplicationGatewayWafRuleStateTypes
        :keyword action: The string representation of the web application firewall rule action. Known
         values are: "None", "AnomalyScoring", "Allow", "Block", and "Log".
        :paramtype action: str or
         ~azure.mgmt.network.models.ApplicationGatewayWafRuleActionTypes
        :keyword sensitivity: The string representation of the web application firewall rule
         sensitivity. Known values are: "None", "Low", "Medium", and "High".
        :paramtype sensitivity: str or
         ~azure.mgmt.network.models.ApplicationGatewayWafRuleSensitivityTypes
        :keyword description: The description of the web application firewall rule.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.rule_id_string = rule_id_string
        self.state = state
        self.action = action
        self.sensitivity = sensitivity
        self.description = description

class ApplicationGatewayFirewallRuleGroup(_serialization.Model):
    """A web application firewall rule group.

    All required parameters must be populated in order to send to server.

    :ivar rule_group_name: The name of the web application firewall rule group. Required.
    :vartype rule_group_name: str
    :ivar description: The description of the web application firewall rule group.
    :vartype description: str
    :ivar rules: The rules of the web application firewall rule group. Required.
    :vartype rules: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRule]
    """

    _validation = {
        "rule_group_name": {"required": True},
        "rules": {"required": True},
    }

    _attribute_map = {
        "rule_group_name": {"key": "ruleGroupName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rules": {"key": "rules", "type": "[ApplicationGatewayFirewallRule]"},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: List["_models.ApplicationGatewayFirewallRule"],
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_group_name: The name of the web application firewall rule group. Required.
        :paramtype rule_group_name: str
        :keyword description: The description of the web application firewall rule group.
        :paramtype description: str
        :keyword rules: The rules of the web application firewall rule group. Required.
        :paramtype rules: list[~azure.mgmt.network.models.ApplicationGatewayFirewallRule]
        """
        super().__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.description = description
        self.rules = rules

class ApplicationGatewayFirewallRuleSet(Resource):
    """A web application firewall rule set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the web application firewall rule set.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar rule_set_type: The type of the web application firewall rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the web application firewall rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: The rule groups of the web application firewall rule set.
    :vartype rule_groups:
     list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleGroup]
    :ivar tiers: Tier of an application gateway that support the rule set.
    :vartype tiers: list[str or ~azure.mgmt.network.models.ApplicationGatewayTierTypes]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rule_set_type": {"key": "properties.ruleSetType", "type": "str"},
        "rule_set_version": {"key": "properties.ruleSetVersion", "type": "str"},
        "rule_groups": {"key": "properties.ruleGroups", "type": "[ApplicationGatewayFirewallRuleGroup]"},
        "tiers": {"key": "properties.tiers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        rule_set_type: Optional[str] = None,
        rule_set_version: Optional[str] = None,
        rule_groups: Optional[List["_models.ApplicationGatewayFirewallRuleGroup"]] = None,
        tiers: Optional[List[Union[str, "_models.ApplicationGatewayTierTypes"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rule_set_type: The type of the web application firewall rule set.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the web application firewall rule set type.
        :paramtype rule_set_version: str
        :keyword rule_groups: The rule groups of the web application firewall rule set.
        :paramtype rule_groups:
         list[~azure.mgmt.network.models.ApplicationGatewayFirewallRuleGroup]
        :keyword tiers: Tier of an application gateway that support the rule set.
        :paramtype tiers: list[str or
         ~azure.mgmt.network.models.ApplicationGatewayTierTypes]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_groups = rule_groups
        self.tiers = tiers

class ApplicationGatewayProbeHealthResponseMatch(_serialization.Model):  # pylint: disable=name-too-long
    """Application gateway probe health response match.

    :ivar body: Body that must be contained in the health response. Default value is empty.
    :vartype body: str
    :ivar status_codes: Allowed ranges of healthy status codes. Default range of healthy status
     codes is 200-399.
    :vartype status_codes: list[str]
    """

    _attribute_map = {
        "body": {"key": "body", "type": "str"},
        "status_codes": {"key": "statusCodes", "type": "[str]"},
    }

    def __init__(self, *, body: Optional[str] = None, status_codes: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword body: Body that must be contained in the health response. Default value is empty.
        :paramtype body: str
        :keyword status_codes: Allowed ranges of healthy status codes. Default range of healthy status
         codes is 200-399.
        :paramtype status_codes: list[str]
        """
        super().__init__(**kwargs)
        self.body = body
        self.status_codes = status_codes

class ApplicationGatewayRedirectConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """Redirect configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the redirect configuration that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar redirect_type: HTTP redirection type. Known values are: "Permanent", "Found", "SeeOther",
     and "Temporary".
    :vartype redirect_type: str or
     ~azure.mgmt.network.models.ApplicationGatewayRedirectType
    :ivar target_listener: Reference to a listener to redirect the request to.
    :vartype target_listener: ~azure.mgmt.network.models.SubResource
    :ivar target_url: Url to redirect the request to.
    :vartype target_url: str
    :ivar include_path: Include path in the redirected url.
    :vartype include_path: bool
    :ivar include_query_string: Include query string in the redirected url.
    :vartype include_query_string: bool
    :ivar request_routing_rules: Request routing specifying redirect configuration.
    :vartype request_routing_rules: list[~azure.mgmt.network.models.SubResource]
    :ivar url_path_maps: Url path maps specifying default redirect configuration.
    :vartype url_path_maps: list[~azure.mgmt.network.models.SubResource]
    :ivar path_rules: Path rules specifying redirect configuration.
    :vartype path_rules: list[~azure.mgmt.network.models.SubResource]
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "redirect_type": {"key": "properties.redirectType", "type": "str"},
        "target_listener": {"key": "properties.targetListener", "type": "SubResource"},
        "target_url": {"key": "properties.targetUrl", "type": "str"},
        "include_path": {"key": "properties.includePath", "type": "bool"},
        "include_query_string": {"key": "properties.includeQueryString", "type": "bool"},
        "request_routing_rules": {"key": "properties.requestRoutingRules", "type": "[SubResource]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[SubResource]"},
        "path_rules": {"key": "properties.pathRules", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        redirect_type: Optional[Union[str, "_models.ApplicationGatewayRedirectType"]] = None,
        target_listener: Optional["_models.SubResource"] = None,
        target_url: Optional[str] = None,
        include_path: Optional[bool] = None,
        include_query_string: Optional[bool] = None,
        request_routing_rules: Optional[List["_models.SubResource"]] = None,
        url_path_maps: Optional[List["_models.SubResource"]] = None,
        path_rules: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the redirect configuration that is unique within an Application Gateway.
        :paramtype name: str
        :keyword redirect_type: HTTP redirection type. Known values are: "Permanent", "Found",
         "SeeOther", and "Temporary".
        :paramtype redirect_type: str or
         ~azure.mgmt.network.models.ApplicationGatewayRedirectType
        :keyword target_listener: Reference to a listener to redirect the request to.
        :paramtype target_listener: ~azure.mgmt.network.models.SubResource
        :keyword target_url: Url to redirect the request to.
        :paramtype target_url: str
        :keyword include_path: Include path in the redirected url.
        :paramtype include_path: bool
        :keyword include_query_string: Include query string in the redirected url.
        :paramtype include_query_string: bool
        :keyword request_routing_rules: Request routing specifying redirect configuration.
        :paramtype request_routing_rules: list[~azure.mgmt.network.models.SubResource]
        :keyword url_path_maps: Url path maps specifying default redirect configuration.
        :paramtype url_path_maps: list[~azure.mgmt.network.models.SubResource]
        :keyword path_rules: Path rules specifying redirect configuration.
        :paramtype path_rules: list[~azure.mgmt.network.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.redirect_type = redirect_type
        self.target_listener = target_listener
        self.target_url = target_url
        self.include_path = include_path
        self.include_query_string = include_query_string
        self.request_routing_rules = request_routing_rules
        self.url_path_maps = url_path_maps
        self.path_rules = path_rules

class ApplicationGatewaySslPolicy(_serialization.Model):
    """Application Gateway Ssl policy.

    :ivar disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
    :vartype disabled_ssl_protocols: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslProtocol]
    :ivar policy_type: Type of Ssl Policy. Known values are: "Predefined", "Custom", and
     "CustomV2".
    :vartype policy_type: str or
     ~azure.mgmt.network.models.ApplicationGatewaySslPolicyType
    :ivar policy_name: Name of Ssl predefined policy. Known values are: "AppGwSslPolicy20150501",
     "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S", "AppGwSslPolicy20220101", and
     "AppGwSslPolicy20220101S".
    :vartype policy_name: str or
     ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
    :ivar cipher_suites: Ssl cipher suites to be enabled in the specified order to application
     gateway.
    :vartype cipher_suites: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
    :ivar min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Known values are: "TLSv1_0", "TLSv1_1", "TLSv1_2", and "TLSv1_3".
    :vartype min_protocol_version: str or
     ~azure.mgmt.network.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        "disabled_ssl_protocols": {"key": "disabledSslProtocols", "type": "[str]"},
        "policy_type": {"key": "policyType", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "cipher_suites": {"key": "cipherSuites", "type": "[str]"},
        "min_protocol_version": {"key": "minProtocolVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        disabled_ssl_protocols: Optional[List[Union[str, "_models.ApplicationGatewaySslProtocol"]]] = None,
        policy_type: Optional[Union[str, "_models.ApplicationGatewaySslPolicyType"]] = None,
        policy_name: Optional[Union[str, "_models.ApplicationGatewaySslPolicyName"]] = None,
        cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "_models.ApplicationGatewaySslProtocol"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
        :paramtype disabled_ssl_protocols: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslProtocol]
        :keyword policy_type: Type of Ssl Policy. Known values are: "Predefined", "Custom", and
         "CustomV2".
        :paramtype policy_type: str or
         ~azure.mgmt.network.models.ApplicationGatewaySslPolicyType
        :keyword policy_name: Name of Ssl predefined policy. Known values are:
         "AppGwSslPolicy20150501", "AppGwSslPolicy20170401", "AppGwSslPolicy20170401S",
         "AppGwSslPolicy20220101", and "AppGwSslPolicy20220101S".
        :paramtype policy_name: str or
         ~azure.mgmt.network.models.ApplicationGatewaySslPolicyName
        :keyword cipher_suites: Ssl cipher suites to be enabled in the specified order to application
         gateway.
        :paramtype cipher_suites: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
        :keyword min_protocol_version: Minimum version of Ssl protocol to be supported on application
         gateway. Known values are: "TLSv1_0", "TLSv1_1", "TLSv1_2", and "TLSv1_3".
        :paramtype min_protocol_version: str or
         ~azure.mgmt.network.models.ApplicationGatewaySslProtocol
        """
        super().__init__(**kwargs)
        self.disabled_ssl_protocols = disabled_ssl_protocols
        self.policy_type = policy_type
        self.policy_name = policy_name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version

class ApplicationGatewaySslPredefinedPolicy(SubResource):
    """An Ssl predefined policy.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the Ssl predefined policy.
    :vartype name: str
    :ivar cipher_suites: Ssl cipher suites to be enabled in the specified order for application
     gateway.
    :vartype cipher_suites: list[str or
     ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
    :ivar min_protocol_version: Minimum version of Ssl protocol to be supported on application
     gateway. Known values are: "TLSv1_0", "TLSv1_1", "TLSv1_2", and "TLSv1_3".
    :vartype min_protocol_version: str or
     ~azure.mgmt.network.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "cipher_suites": {"key": "properties.cipherSuites", "type": "[str]"},
        "min_protocol_version": {"key": "properties.minProtocolVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        cipher_suites: Optional[List[Union[str, "_models.ApplicationGatewaySslCipherSuite"]]] = None,
        min_protocol_version: Optional[Union[str, "_models.ApplicationGatewaySslProtocol"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the Ssl predefined policy.
        :paramtype name: str
        :keyword cipher_suites: Ssl cipher suites to be enabled in the specified order for application
         gateway.
        :paramtype cipher_suites: list[str or
         ~azure.mgmt.network.models.ApplicationGatewaySslCipherSuite]
        :keyword min_protocol_version: Minimum version of Ssl protocol to be supported on application
         gateway. Known values are: "TLSv1_0", "TLSv1_1", "TLSv1_2", and "TLSv1_3".
        :paramtype min_protocol_version: str or
         ~azure.mgmt.network.models.ApplicationGatewaySslProtocol
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version

class ApplicationGatewayWebApplicationFirewallConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether the web application firewall is enabled or not. Required.
    :vartype enabled: bool
    :ivar firewall_mode: Web application firewall mode. Required. Known values are: "Detection" and
     "Prevention".
    :vartype firewall_mode: str or
     ~azure.mgmt.network.models.ApplicationGatewayFirewallMode
    :ivar rule_set_type: The type of the web application firewall rule set. Possible values are:
     'OWASP'. Required.
    :vartype rule_set_type: str
    :ivar rule_set_version: The version of the rule set type. Required.
    :vartype rule_set_version: str
    :ivar disabled_rule_groups: The disabled rule groups.
    :vartype disabled_rule_groups:
     list[~azure.mgmt.network.models.ApplicationGatewayFirewallDisabledRuleGroup]
    :ivar request_body_check: Whether allow WAF to check request Body.
    :vartype request_body_check: bool
    :ivar max_request_body_size: Maximum request body size for WAF.
    :vartype max_request_body_size: int
    :ivar max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
    :vartype max_request_body_size_in_kb: int
    :ivar file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
    :vartype file_upload_limit_in_mb: int
    :ivar exclusions: The exclusion list.
    :vartype exclusions:
     list[~azure.mgmt.network.models.ApplicationGatewayFirewallExclusion]
    """

    _validation = {
        "enabled": {"required": True},
        "firewall_mode": {"required": True},
        "rule_set_type": {"required": True},
        "rule_set_version": {"required": True},
        "max_request_body_size": {"maximum": 128, "minimum": 8},
        "max_request_body_size_in_kb": {"maximum": 128, "minimum": 8},
        "file_upload_limit_in_mb": {"minimum": 0},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "firewall_mode": {"key": "firewallMode", "type": "str"},
        "rule_set_type": {"key": "ruleSetType", "type": "str"},
        "rule_set_version": {"key": "ruleSetVersion", "type": "str"},
        "disabled_rule_groups": {"key": "disabledRuleGroups", "type": "[ApplicationGatewayFirewallDisabledRuleGroup]"},
        "request_body_check": {"key": "requestBodyCheck", "type": "bool"},
        "max_request_body_size": {"key": "maxRequestBodySize", "type": "int"},
        "max_request_body_size_in_kb": {"key": "maxRequestBodySizeInKb", "type": "int"},
        "file_upload_limit_in_mb": {"key": "fileUploadLimitInMb", "type": "int"},
        "exclusions": {"key": "exclusions", "type": "[ApplicationGatewayFirewallExclusion]"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        firewall_mode: Union[str, "_models.ApplicationGatewayFirewallMode"],
        rule_set_type: str,
        rule_set_version: str,
        disabled_rule_groups: Optional[List["_models.ApplicationGatewayFirewallDisabledRuleGroup"]] = None,
        request_body_check: Optional[bool] = None,
        max_request_body_size: Optional[int] = None,
        max_request_body_size_in_kb: Optional[int] = None,
        file_upload_limit_in_mb: Optional[int] = None,
        exclusions: Optional[List["_models.ApplicationGatewayFirewallExclusion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether the web application firewall is enabled or not. Required.
        :paramtype enabled: bool
        :keyword firewall_mode: Web application firewall mode. Required. Known values are: "Detection"
         and "Prevention".
        :paramtype firewall_mode: str or
         ~azure.mgmt.network.models.ApplicationGatewayFirewallMode
        :keyword rule_set_type: The type of the web application firewall rule set. Possible values are:
         'OWASP'. Required.
        :paramtype rule_set_type: str
        :keyword rule_set_version: The version of the rule set type. Required.
        :paramtype rule_set_version: str
        :keyword disabled_rule_groups: The disabled rule groups.
        :paramtype disabled_rule_groups:
         list[~azure.mgmt.network.models.ApplicationGatewayFirewallDisabledRuleGroup]
        :keyword request_body_check: Whether allow WAF to check request Body.
        :paramtype request_body_check: bool
        :keyword max_request_body_size: Maximum request body size for WAF.
        :paramtype max_request_body_size: int
        :keyword max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :paramtype max_request_body_size_in_kb: int
        :keyword file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :paramtype file_upload_limit_in_mb: int
        :keyword exclusions: The exclusion list.
        :paramtype exclusions:
         list[~azure.mgmt.network.models.ApplicationGatewayFirewallExclusion]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.firewall_mode = firewall_mode
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.disabled_rule_groups = disabled_rule_groups
        self.request_body_check = request_body_check
        self.max_request_body_size = max_request_body_size
        self.max_request_body_size_in_kb = max_request_body_size_in_kb
        self.file_upload_limit_in_mb = file_upload_limit_in_mb
        self.exclusions = exclusions

class ApplicationSecurityGroup(Resource):
    """An application security group in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the application security group resource. It
     uniquely identifies a resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application security group resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None

class ApplicationSecurityGroupListResult(_serialization.Model):
    """A list of application security groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of application security groups.
    :vartype value: list[~azure.mgmt.network.models.ApplicationSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ApplicationSecurityGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of application security groups.
        :paramtype value: list[~azure.mgmt.network.models.ApplicationSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class Availability(_serialization.Model):
    """Availability of the metric.

    :ivar time_grain: The time grain of the availability.
    :vartype time_grain: str
    :ivar retention: The retention of the availability.
    :vartype retention: str
    :ivar blob_duration: Duration of the availability blob.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        retention: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_grain: The time grain of the availability.
        :paramtype time_grain: str
        :keyword retention: The retention of the availability.
        :paramtype retention: str
        :keyword blob_duration: Duration of the availability blob.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention
        self.blob_duration = blob_duration

class AvailableProvidersList(_serialization.Model):
    """List of available countries with details.

    All required parameters must be populated in order to send to server.

    :ivar countries: List of available countries. Required.
    :vartype countries: list[~azure.mgmt.network.models.AvailableProvidersListCountry]
    """

    _validation = {
        "countries": {"required": True},
    }

    _attribute_map = {
        "countries": {"key": "countries", "type": "[AvailableProvidersListCountry]"},
    }

    def __init__(self, *, countries: List["_models.AvailableProvidersListCountry"], **kwargs: Any) -> None:
        """
        :keyword countries: List of available countries. Required.
        :paramtype countries:
         list[~azure.mgmt.network.models.AvailableProvidersListCountry]
        """
        super().__init__(**kwargs)
        self.countries = countries

class AvailableProvidersListCity(_serialization.Model):
    """City or town details.

    :ivar city_name: The city or town name.
    :vartype city_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    """

    _attribute_map = {
        "city_name": {"key": "cityName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
    }

    def __init__(
        self, *, city_name: Optional[str] = None, providers: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword city_name: The city or town name.
        :paramtype city_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        """
        super().__init__(**kwargs)
        self.city_name = city_name
        self.providers = providers

class AvailableProvidersListCountry(_serialization.Model):
    """Country details.

    :ivar country_name: The country name.
    :vartype country_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    :ivar states: List of available states in the country.
    :vartype states: list[~azure.mgmt.network.models.AvailableProvidersListState]
    """

    _attribute_map = {
        "country_name": {"key": "countryName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
        "states": {"key": "states", "type": "[AvailableProvidersListState]"},
    }

    def __init__(
        self,
        *,
        country_name: Optional[str] = None,
        providers: Optional[List[str]] = None,
        states: Optional[List["_models.AvailableProvidersListState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword country_name: The country name.
        :paramtype country_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        :keyword states: List of available states in the country.
        :paramtype states: list[~azure.mgmt.network.models.AvailableProvidersListState]
        """
        super().__init__(**kwargs)
        self.country_name = country_name
        self.providers = providers
        self.states = states

class AvailableProvidersListParameters(_serialization.Model):
    """Constraints that determine the list of available Internet service providers.

    :ivar azure_locations: A list of Azure regions.
    :vartype azure_locations: list[str]
    :ivar country: The country for available providers list.
    :vartype country: str
    :ivar state: The state for available providers list.
    :vartype state: str
    :ivar city: The city or town for available providers list.
    :vartype city: str
    """

    _attribute_map = {
        "azure_locations": {"key": "azureLocations", "type": "[str]"},
        "country": {"key": "country", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_locations: Optional[List[str]] = None,
        country: Optional[str] = None,
        state: Optional[str] = None,
        city: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_locations: A list of Azure regions.
        :paramtype azure_locations: list[str]
        :keyword country: The country for available providers list.
        :paramtype country: str
        :keyword state: The state for available providers list.
        :paramtype state: str
        :keyword city: The city or town for available providers list.
        :paramtype city: str
        """
        super().__init__(**kwargs)
        self.azure_locations = azure_locations
        self.country = country
        self.state = state
        self.city = city

class AvailableProvidersListState(_serialization.Model):
    """State details.

    :ivar state_name: The state name.
    :vartype state_name: str
    :ivar providers: A list of Internet service providers.
    :vartype providers: list[str]
    :ivar cities: List of available cities or towns in the state.
    :vartype cities: list[~azure.mgmt.network.models.AvailableProvidersListCity]
    """

    _attribute_map = {
        "state_name": {"key": "stateName", "type": "str"},
        "providers": {"key": "providers", "type": "[str]"},
        "cities": {"key": "cities", "type": "[AvailableProvidersListCity]"},
    }

    def __init__(
        self,
        *,
        state_name: Optional[str] = None,
        providers: Optional[List[str]] = None,
        cities: Optional[List["_models.AvailableProvidersListCity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state_name: The state name.
        :paramtype state_name: str
        :keyword providers: A list of Internet service providers.
        :paramtype providers: list[str]
        :keyword cities: List of available cities or towns in the state.
        :paramtype cities: list[~azure.mgmt.network.models.AvailableProvidersListCity]
        """
        super().__init__(**kwargs)
        self.state_name = state_name
        self.providers = providers
        self.cities = cities

class AzureReachabilityReport(_serialization.Model):
    """Azure reachability report details.

    All required parameters must be populated in order to send to server.

    :ivar aggregation_level: The aggregation level of Azure reachability report. Can be Country,
     State or City. Required.
    :vartype aggregation_level: str
    :ivar provider_location: Parameters that define a geographic location. Required.
    :vartype provider_location:
     ~azure.mgmt.network.models.AzureReachabilityReportLocation
    :ivar reachability_report: List of Azure reachability report items. Required.
    :vartype reachability_report:
     list[~azure.mgmt.network.models.AzureReachabilityReportItem]
    """

    _validation = {
        "aggregation_level": {"required": True},
        "provider_location": {"required": True},
        "reachability_report": {"required": True},
    }

    _attribute_map = {
        "aggregation_level": {"key": "aggregationLevel", "type": "str"},
        "provider_location": {"key": "providerLocation", "type": "AzureReachabilityReportLocation"},
        "reachability_report": {"key": "reachabilityReport", "type": "[AzureReachabilityReportItem]"},
    }

    def __init__(
        self,
        *,
        aggregation_level: str,
        provider_location: "_models.AzureReachabilityReportLocation",
        reachability_report: List["_models.AzureReachabilityReportItem"],
        **kwargs: Any
    ) -> None:
        """
        :keyword aggregation_level: The aggregation level of Azure reachability report. Can be Country,
         State or City. Required.
        :paramtype aggregation_level: str
        :keyword provider_location: Parameters that define a geographic location. Required.
        :paramtype provider_location:
         ~azure.mgmt.network.models.AzureReachabilityReportLocation
        :keyword reachability_report: List of Azure reachability report items. Required.
        :paramtype reachability_report:
         list[~azure.mgmt.network.models.AzureReachabilityReportItem]
        """
        super().__init__(**kwargs)
        self.aggregation_level = aggregation_level
        self.provider_location = provider_location
        self.reachability_report = reachability_report

class AzureReachabilityReportItem(_serialization.Model):
    """Azure reachability report details for a given provider location.

    :ivar provider: The Internet service provider.
    :vartype provider: str
    :ivar azure_location: The Azure region.
    :vartype azure_location: str
    :ivar latencies: List of latency details for each of the time series.
    :vartype latencies:
     list[~azure.mgmt.network.models.AzureReachabilityReportLatencyInfo]
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "azure_location": {"key": "azureLocation", "type": "str"},
        "latencies": {"key": "latencies", "type": "[AzureReachabilityReportLatencyInfo]"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        azure_location: Optional[str] = None,
        latencies: Optional[List["_models.AzureReachabilityReportLatencyInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The Internet service provider.
        :paramtype provider: str
        :keyword azure_location: The Azure region.
        :paramtype azure_location: str
        :keyword latencies: List of latency details for each of the time series.
        :paramtype latencies:
         list[~azure.mgmt.network.models.AzureReachabilityReportLatencyInfo]
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.azure_location = azure_location
        self.latencies = latencies

class AzureReachabilityReportLatencyInfo(_serialization.Model):
    """Details on latency for a time series.

    :ivar time_stamp: The time stamp.
    :vartype time_stamp: ~datetime.datetime
    :ivar score: The relative latency score between 1 and 100, higher values indicating a faster
     connection.
    :vartype score: int
    """

    _validation = {
        "score": {"maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
        "score": {"key": "score", "type": "int"},
    }

    def __init__(
        self, *, time_stamp: Optional[datetime.datetime] = None, score: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword time_stamp: The time stamp.
        :paramtype time_stamp: ~datetime.datetime
        :keyword score: The relative latency score between 1 and 100, higher values indicating a faster
         connection.
        :paramtype score: int
        """
        super().__init__(**kwargs)
        self.time_stamp = time_stamp
        self.score = score

class AzureReachabilityReportLocation(_serialization.Model):
    """Parameters that define a geographic location.

    All required parameters must be populated in order to send to server.

    :ivar country: The name of the country. Required.
    :vartype country: str
    :ivar state: The name of the state.
    :vartype state: str
    :ivar city: The name of the city or town.
    :vartype city: str
    """

    _validation = {
        "country": {"required": True},
    }

    _attribute_map = {
        "country": {"key": "country", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "city": {"key": "city", "type": "str"},
    }

    def __init__(self, *, country: str, state: Optional[str] = None, city: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword country: The name of the country. Required.
        :paramtype country: str
        :keyword state: The name of the state.
        :paramtype state: str
        :keyword city: The name of the city or town.
        :paramtype city: str
        """
        super().__init__(**kwargs)
        self.country = country
        self.state = state
        self.city = city

class AzureReachabilityReportParameters(_serialization.Model):
    """Geographic and time constraints for Azure reachability report.

    All required parameters must be populated in order to send to server.

    :ivar provider_location: Parameters that define a geographic location. Required.
    :vartype provider_location:
     ~azure.mgmt.network.models.AzureReachabilityReportLocation
    :ivar providers: List of Internet service providers.
    :vartype providers: list[str]
    :ivar azure_locations: Optional Azure regions to scope the query to.
    :vartype azure_locations: list[str]
    :ivar start_time: The start time for the Azure reachability report. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time for the Azure reachability report. Required.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "provider_location": {"required": True},
        "start_time": {"required": True},
        "end_time": {"required": True},
    }

    _attribute_map = {
        "provider_location": {"key": "providerLocation", "type": "AzureReachabilityReportLocation"},
        "providers": {"key": "providers", "type": "[str]"},
        "azure_locations": {"key": "azureLocations", "type": "[str]"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        provider_location: "_models.AzureReachabilityReportLocation",
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        providers: Optional[List[str]] = None,
        azure_locations: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider_location: Parameters that define a geographic location. Required.
        :paramtype provider_location:
         ~azure.mgmt.network.models.AzureReachabilityReportLocation
        :keyword providers: List of Internet service providers.
        :paramtype providers: list[str]
        :keyword azure_locations: Optional Azure regions to scope the query to.
        :paramtype azure_locations: list[str]
        :keyword start_time: The start time for the Azure reachability report. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time for the Azure reachability report. Required.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.provider_location = provider_location
        self.providers = providers
        self.azure_locations = azure_locations
        self.start_time = start_time
        self.end_time = end_time

class BGPCommunity(_serialization.Model):
    """Contains bgp community information offered in Service Community resources.

    :ivar service_supported_region: The region which the service support. e.g. For O365, region is
     Global.
    :vartype service_supported_region: str
    :ivar community_name: The name of the bgp community. e.g. Skype.
    :vartype community_name: str
    :ivar community_value: The value of the bgp community. For more information:
     https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
    :vartype community_value: str
    :ivar community_prefixes: The prefixes that the bgp community contains.
    :vartype community_prefixes: list[str]
    :ivar is_authorized_to_use: Customer is authorized to use bgp community or not.
    :vartype is_authorized_to_use: bool
    :ivar service_group: The service group of the bgp community contains.
    :vartype service_group: str
    """

    _attribute_map = {
        "service_supported_region": {"key": "serviceSupportedRegion", "type": "str"},
        "community_name": {"key": "communityName", "type": "str"},
        "community_value": {"key": "communityValue", "type": "str"},
        "community_prefixes": {"key": "communityPrefixes", "type": "[str]"},
        "is_authorized_to_use": {"key": "isAuthorizedToUse", "type": "bool"},
        "service_group": {"key": "serviceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_supported_region: Optional[str] = None,
        community_name: Optional[str] = None,
        community_value: Optional[str] = None,
        community_prefixes: Optional[List[str]] = None,
        is_authorized_to_use: Optional[bool] = None,
        service_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_supported_region: The region which the service support. e.g. For O365, region
         is Global.
        :paramtype service_supported_region: str
        :keyword community_name: The name of the bgp community. e.g. Skype.
        :paramtype community_name: str
        :keyword community_value: The value of the bgp community. For more information:
         https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
        :paramtype community_value: str
        :keyword community_prefixes: The prefixes that the bgp community contains.
        :paramtype community_prefixes: list[str]
        :keyword is_authorized_to_use: Customer is authorized to use bgp community or not.
        :paramtype is_authorized_to_use: bool
        :keyword service_group: The service group of the bgp community contains.
        :paramtype service_group: str
        """
        super().__init__(**kwargs)
        self.service_supported_region = service_supported_region
        self.community_name = community_name
        self.community_value = community_value
        self.community_prefixes = community_prefixes
        self.is_authorized_to_use = is_authorized_to_use
        self.service_group = service_group

class BgpPeerStatus(_serialization.Model):
    """BGP peer status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The virtual network gateway's local address.
    :vartype local_address: str
    :ivar neighbor: The remote BGP peer.
    :vartype neighbor: str
    :ivar asn: The autonomous system number of the remote BGP peer.
    :vartype asn: int
    :ivar state: The BGP peer state. Known values are: "Unknown", "Stopped", "Idle", "Connecting",
     and "Connected".
    :vartype state: str or ~azure.mgmt.network.models.BgpPeerState
    :ivar connected_duration: For how long the peering has been up.
    :vartype connected_duration: str
    :ivar routes_received: The number of routes learned from this peer.
    :vartype routes_received: int
    :ivar messages_sent: The number of BGP messages sent.
    :vartype messages_sent: int
    :ivar messages_received: The number of BGP messages received.
    :vartype messages_received: int
    """

    _validation = {
        "local_address": {"readonly": True},
        "neighbor": {"readonly": True},
        "asn": {"readonly": True, "maximum": 4294967295, "minimum": 0},
        "state": {"readonly": True},
        "connected_duration": {"readonly": True},
        "routes_received": {"readonly": True},
        "messages_sent": {"readonly": True},
        "messages_received": {"readonly": True},
    }

    _attribute_map = {
        "local_address": {"key": "localAddress", "type": "str"},
        "neighbor": {"key": "neighbor", "type": "str"},
        "asn": {"key": "asn", "type": "int"},
        "state": {"key": "state", "type": "str"},
        "connected_duration": {"key": "connectedDuration", "type": "str"},
        "routes_received": {"key": "routesReceived", "type": "int"},
        "messages_sent": {"key": "messagesSent", "type": "int"},
        "messages_received": {"key": "messagesReceived", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.local_address = None
        self.neighbor = None
        self.asn = None
        self.state = None
        self.connected_duration = None
        self.routes_received = None
        self.messages_sent = None
        self.messages_received = None

class BgpPeerStatusListResult(_serialization.Model):
    """Response for list BGP peer status API service call.

    :ivar value: List of BGP peers.
    :vartype value: list[~azure.mgmt.network.models.BgpPeerStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BgpPeerStatus]"},
    }

    def __init__(self, *, value: Optional[List["_models.BgpPeerStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of BGP peers.
        :paramtype value: list[~azure.mgmt.network.models.BgpPeerStatus]
        """
        super().__init__(**kwargs)
        self.value = value

class BgpServiceCommunity(Resource):
    """Service Community Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar service_name: The name of the bgp community. e.g. Skype.
    :vartype service_name: str
    :ivar bgp_communities: A list of bgp communities.
    :vartype bgp_communities: list[~azure.mgmt.network.models.BGPCommunity]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "service_name": {"key": "properties.serviceName", "type": "str"},
        "bgp_communities": {"key": "properties.bgpCommunities", "type": "[BGPCommunity]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        service_name: Optional[str] = None,
        bgp_communities: Optional[List["_models.BGPCommunity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword service_name: The name of the bgp community. e.g. Skype.
        :paramtype service_name: str
        :keyword bgp_communities: A list of bgp communities.
        :paramtype bgp_communities: list[~azure.mgmt.network.models.BGPCommunity]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.service_name = service_name
        self.bgp_communities = bgp_communities

class BgpServiceCommunityListResult(_serialization.Model):
    """Response for the ListServiceCommunity API service call.

    :ivar value: A list of service community resources.
    :vartype value: list[~azure.mgmt.network.models.BgpServiceCommunity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BgpServiceCommunity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.BgpServiceCommunity"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of service community resources.
        :paramtype value: list[~azure.mgmt.network.models.BgpServiceCommunity]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ConnectionMonitor(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Parameters that define the operation to create a connection monitor.

    :ivar location: Connection monitor location.
    :vartype location: str
    :ivar tags: Connection monitor tags.
    :vartype tags: dict[str, str]
    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar endpoints: List of connection monitor endpoints.
    :vartype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
    :ivar test_configurations: List of connection monitor test configurations.
    :vartype test_configurations:
     list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
    :ivar test_groups: List of connection monitor test groups.
    :vartype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
    :ivar outputs: List of connection monitor outputs.
    :vartype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
    :ivar notes: Optional notes to be associated with the connection monitor.
    :vartype notes: str
    """

    _validation = {
        "monitoring_interval_in_seconds": {"maximum": 1800, "minimum": 30},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "properties.destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "properties.autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "properties.monitoringIntervalInSeconds", "type": "int"},
        "endpoints": {"key": "properties.endpoints", "type": "[ConnectionMonitorEndpoint]"},
        "test_configurations": {"key": "properties.testConfigurations", "type": "[ConnectionMonitorTestConfiguration]"},
        "test_groups": {"key": "properties.testGroups", "type": "[ConnectionMonitorTestGroup]"},
        "outputs": {"key": "properties.outputs", "type": "[ConnectionMonitorOutput]"},
        "notes": {"key": "properties.notes", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        endpoints: Optional[List["_models.ConnectionMonitorEndpoint"]] = None,
        test_configurations: Optional[List["_models.ConnectionMonitorTestConfiguration"]] = None,
        test_groups: Optional[List["_models.ConnectionMonitorTestGroup"]] = None,
        outputs: Optional[List["_models.ConnectionMonitorOutput"]] = None,
        notes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Connection monitor location.
        :paramtype location: str
        :keyword tags: Connection monitor tags.
        :paramtype tags: dict[str, str]
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword endpoints: List of connection monitor endpoints.
        :paramtype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
        :keyword test_configurations: List of connection monitor test configurations.
        :paramtype test_configurations:
         list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
        :keyword test_groups: List of connection monitor test groups.
        :paramtype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
        :keyword outputs: List of connection monitor outputs.
        :paramtype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
        :keyword notes: Optional notes to be associated with the connection monitor.
        :paramtype notes: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.endpoints = endpoints
        self.test_configurations = test_configurations
        self.test_groups = test_groups
        self.outputs = outputs
        self.notes = notes

class ConnectionMonitorDestination(_serialization.Model):
    """Describes the destination of connection monitor.

    :ivar resource_id: The ID of the resource used as the destination by connection monitor.
    :vartype resource_id: str
    :ivar address: Address of the connection monitor destination (IP or domain name).
    :vartype address: str
    :ivar port: The destination port used by connection monitor.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        address: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The ID of the resource used as the destination by connection monitor.
        :paramtype resource_id: str
        :keyword address: Address of the connection monitor destination (IP or domain name).
        :paramtype address: str
        :keyword port: The destination port used by connection monitor.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port

class ConnectionMonitorListResult(_serialization.Model):
    """List of connection monitors.

    :ivar value: Information about connection monitors.
    :vartype value: list[~azure.mgmt.network.models.ConnectionMonitorResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectionMonitorResult]"},
    }

    def __init__(self, *, value: Optional[List["_models.ConnectionMonitorResult"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Information about connection monitors.
        :paramtype value: list[~azure.mgmt.network.models.ConnectionMonitorResult]
        """
        super().__init__(**kwargs)
        self.value = value

class ConnectionMonitorParameters(_serialization.Model):
    """Parameters that define the operation to create a connection monitor.

    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar endpoints: List of connection monitor endpoints.
    :vartype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
    :ivar test_configurations: List of connection monitor test configurations.
    :vartype test_configurations:
     list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
    :ivar test_groups: List of connection monitor test groups.
    :vartype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
    :ivar outputs: List of connection monitor outputs.
    :vartype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
    :ivar notes: Optional notes to be associated with the connection monitor.
    :vartype notes: str
    """

    _validation = {
        "monitoring_interval_in_seconds": {"maximum": 1800, "minimum": 30},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "monitoringIntervalInSeconds", "type": "int"},
        "endpoints": {"key": "endpoints", "type": "[ConnectionMonitorEndpoint]"},
        "test_configurations": {"key": "testConfigurations", "type": "[ConnectionMonitorTestConfiguration]"},
        "test_groups": {"key": "testGroups", "type": "[ConnectionMonitorTestGroup]"},
        "outputs": {"key": "outputs", "type": "[ConnectionMonitorOutput]"},
        "notes": {"key": "notes", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        endpoints: Optional[List["_models.ConnectionMonitorEndpoint"]] = None,
        test_configurations: Optional[List["_models.ConnectionMonitorTestConfiguration"]] = None,
        test_groups: Optional[List["_models.ConnectionMonitorTestGroup"]] = None,
        outputs: Optional[List["_models.ConnectionMonitorOutput"]] = None,
        notes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword endpoints: List of connection monitor endpoints.
        :paramtype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
        :keyword test_configurations: List of connection monitor test configurations.
        :paramtype test_configurations:
         list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
        :keyword test_groups: List of connection monitor test groups.
        :paramtype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
        :keyword outputs: List of connection monitor outputs.
        :paramtype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
        :keyword notes: Optional notes to be associated with the connection monitor.
        :paramtype notes: str
        """
        super().__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.endpoints = endpoints
        self.test_configurations = test_configurations
        self.test_groups = test_groups
        self.outputs = outputs
        self.notes = notes

class ConnectionMonitorQueryResult(_serialization.Model):
    """List of connection states snapshots.

    :ivar source_status: Status of connection monitor source. Known values are: "Unknown",
     "Active", and "Inactive".
    :vartype source_status: str or
     ~azure.mgmt.network.models.ConnectionMonitorSourceStatus
    :ivar states: Information about connection states.
    :vartype states: list[~azure.mgmt.network.models.ConnectionStateSnapshot]
    """

    _attribute_map = {
        "source_status": {"key": "sourceStatus", "type": "str"},
        "states": {"key": "states", "type": "[ConnectionStateSnapshot]"},
    }

    def __init__(
        self,
        *,
        source_status: Optional[Union[str, "_models.ConnectionMonitorSourceStatus"]] = None,
        states: Optional[List["_models.ConnectionStateSnapshot"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_status: Status of connection monitor source. Known values are: "Unknown",
         "Active", and "Inactive".
        :paramtype source_status: str or
         ~azure.mgmt.network.models.ConnectionMonitorSourceStatus
        :keyword states: Information about connection states.
        :paramtype states: list[~azure.mgmt.network.models.ConnectionStateSnapshot]
        """
        super().__init__(**kwargs)
        self.source_status = source_status
        self.states = states

class ConnectionMonitorResult(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Information about the connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the connection monitor.
    :vartype name: str
    :ivar id: ID of the connection monitor.
    :vartype id: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Connection monitor type.
    :vartype type: str
    :ivar location: Connection monitor location.
    :vartype location: str
    :ivar tags: Connection monitor tags.
    :vartype tags: dict[str, str]
    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar endpoints: List of connection monitor endpoints.
    :vartype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
    :ivar test_configurations: List of connection monitor test configurations.
    :vartype test_configurations:
     list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
    :ivar test_groups: List of connection monitor test groups.
    :vartype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
    :ivar outputs: List of connection monitor outputs.
    :vartype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
    :ivar notes: Optional notes to be associated with the connection monitor.
    :vartype notes: str
    :ivar provisioning_state: The provisioning state of the connection monitor. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar start_time: The date and time when the connection monitor was started.
    :vartype start_time: ~datetime.datetime
    :ivar monitoring_status: The monitoring status of the connection monitor.
    :vartype monitoring_status: str
    :ivar connection_monitor_type: Type of connection monitor. Known values are: "MultiEndpoint"
     and "SingleSourceDestination".
    :vartype connection_monitor_type: str or
     ~azure.mgmt.network.models.ConnectionMonitorType
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "monitoring_interval_in_seconds": {"maximum": 1800, "minimum": 30},
        "provisioning_state": {"readonly": True},
        "start_time": {"readonly": True},
        "monitoring_status": {"readonly": True},
        "connection_monitor_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "properties.destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "properties.autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "properties.monitoringIntervalInSeconds", "type": "int"},
        "endpoints": {"key": "properties.endpoints", "type": "[ConnectionMonitorEndpoint]"},
        "test_configurations": {"key": "properties.testConfigurations", "type": "[ConnectionMonitorTestConfiguration]"},
        "test_groups": {"key": "properties.testGroups", "type": "[ConnectionMonitorTestGroup]"},
        "outputs": {"key": "properties.outputs", "type": "[ConnectionMonitorOutput]"},
        "notes": {"key": "properties.notes", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "monitoring_status": {"key": "properties.monitoringStatus", "type": "str"},
        "connection_monitor_type": {"key": "properties.connectionMonitorType", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        endpoints: Optional[List["_models.ConnectionMonitorEndpoint"]] = None,
        test_configurations: Optional[List["_models.ConnectionMonitorTestConfiguration"]] = None,
        test_groups: Optional[List["_models.ConnectionMonitorTestGroup"]] = None,
        outputs: Optional[List["_models.ConnectionMonitorOutput"]] = None,
        notes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Connection monitor location.
        :paramtype location: str
        :keyword tags: Connection monitor tags.
        :paramtype tags: dict[str, str]
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword endpoints: List of connection monitor endpoints.
        :paramtype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
        :keyword test_configurations: List of connection monitor test configurations.
        :paramtype test_configurations:
         list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
        :keyword test_groups: List of connection monitor test groups.
        :paramtype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
        :keyword outputs: List of connection monitor outputs.
        :paramtype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
        :keyword notes: Optional notes to be associated with the connection monitor.
        :paramtype notes: str
        """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = None
        self.type = None
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.endpoints = endpoints
        self.test_configurations = test_configurations
        self.test_groups = test_groups
        self.outputs = outputs
        self.notes = notes
        self.provisioning_state = None
        self.start_time = None
        self.monitoring_status = None
        self.connection_monitor_type = None

class ConnectionMonitorResultProperties(ConnectionMonitorParameters):  # pylint: disable=too-many-instance-attributes
    """Describes the properties of a connection monitor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source: Describes the source of connection monitor.
    :vartype source: ~azure.mgmt.network.models.ConnectionMonitorSource
    :ivar destination: Describes the destination of connection monitor.
    :vartype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
    :ivar auto_start: Determines if the connection monitor will start automatically once created.
    :vartype auto_start: bool
    :ivar monitoring_interval_in_seconds: Monitoring interval in seconds.
    :vartype monitoring_interval_in_seconds: int
    :ivar endpoints: List of connection monitor endpoints.
    :vartype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
    :ivar test_configurations: List of connection monitor test configurations.
    :vartype test_configurations:
     list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
    :ivar test_groups: List of connection monitor test groups.
    :vartype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
    :ivar outputs: List of connection monitor outputs.
    :vartype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
    :ivar notes: Optional notes to be associated with the connection monitor.
    :vartype notes: str
    :ivar provisioning_state: The provisioning state of the connection monitor. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar start_time: The date and time when the connection monitor was started.
    :vartype start_time: ~datetime.datetime
    :ivar monitoring_status: The monitoring status of the connection monitor.
    :vartype monitoring_status: str
    :ivar connection_monitor_type: Type of connection monitor. Known values are: "MultiEndpoint"
     and "SingleSourceDestination".
    :vartype connection_monitor_type: str or
     ~azure.mgmt.network.models.ConnectionMonitorType
    """

    _validation = {
        "monitoring_interval_in_seconds": {"maximum": 1800, "minimum": 30},
        "provisioning_state": {"readonly": True},
        "start_time": {"readonly": True},
        "monitoring_status": {"readonly": True},
        "connection_monitor_type": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectionMonitorSource"},
        "destination": {"key": "destination", "type": "ConnectionMonitorDestination"},
        "auto_start": {"key": "autoStart", "type": "bool"},
        "monitoring_interval_in_seconds": {"key": "monitoringIntervalInSeconds", "type": "int"},
        "endpoints": {"key": "endpoints", "type": "[ConnectionMonitorEndpoint]"},
        "test_configurations": {"key": "testConfigurations", "type": "[ConnectionMonitorTestConfiguration]"},
        "test_groups": {"key": "testGroups", "type": "[ConnectionMonitorTestGroup]"},
        "outputs": {"key": "outputs", "type": "[ConnectionMonitorOutput]"},
        "notes": {"key": "notes", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "monitoring_status": {"key": "monitoringStatus", "type": "str"},
        "connection_monitor_type": {"key": "connectionMonitorType", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.ConnectionMonitorSource"] = None,
        destination: Optional["_models.ConnectionMonitorDestination"] = None,
        auto_start: bool = True,
        monitoring_interval_in_seconds: int = 60,
        endpoints: Optional[List["_models.ConnectionMonitorEndpoint"]] = None,
        test_configurations: Optional[List["_models.ConnectionMonitorTestConfiguration"]] = None,
        test_groups: Optional[List["_models.ConnectionMonitorTestGroup"]] = None,
        outputs: Optional[List["_models.ConnectionMonitorOutput"]] = None,
        notes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Describes the source of connection monitor.
        :paramtype source: ~azure.mgmt.network.models.ConnectionMonitorSource
        :keyword destination: Describes the destination of connection monitor.
        :paramtype destination: ~azure.mgmt.network.models.ConnectionMonitorDestination
        :keyword auto_start: Determines if the connection monitor will start automatically once
         created.
        :paramtype auto_start: bool
        :keyword monitoring_interval_in_seconds: Monitoring interval in seconds.
        :paramtype monitoring_interval_in_seconds: int
        :keyword endpoints: List of connection monitor endpoints.
        :paramtype endpoints: list[~azure.mgmt.network.models.ConnectionMonitorEndpoint]
        :keyword test_configurations: List of connection monitor test configurations.
        :paramtype test_configurations:
         list[~azure.mgmt.network.models.ConnectionMonitorTestConfiguration]
        :keyword test_groups: List of connection monitor test groups.
        :paramtype test_groups: list[~azure.mgmt.network.models.ConnectionMonitorTestGroup]
        :keyword outputs: List of connection monitor outputs.
        :paramtype outputs: list[~azure.mgmt.network.models.ConnectionMonitorOutput]
        :keyword notes: Optional notes to be associated with the connection monitor.
        :paramtype notes: str
        """
        super().__init__(
            source=source,
            destination=destination,
            auto_start=auto_start,
            monitoring_interval_in_seconds=monitoring_interval_in_seconds,
            endpoints=endpoints,
            test_configurations=test_configurations,
            test_groups=test_groups,
            outputs=outputs,
            notes=notes,
            **kwargs
        )
        self.provisioning_state = None
        self.start_time = None
        self.monitoring_status = None
        self.connection_monitor_type = None

class ConnectionMonitorSource(_serialization.Model):
    """Describes the source of connection monitor.

    All required parameters must be populated in order to send to server.

    :ivar resource_id: The ID of the resource used as the source by connection monitor. Required.
    :vartype resource_id: str
    :ivar port: The source port used by connection monitor.
    :vartype port: int
    """

    _validation = {
        "resource_id": {"required": True},
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, resource_id: str, port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The ID of the resource used as the source by connection monitor.
         Required.
        :paramtype resource_id: str
        :keyword port: The source port used by connection monitor.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port

class ConnectionStateSnapshot(_serialization.Model):
    """Connection state snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar connection_state: The connection state. Known values are: "Reachable", "Unreachable", and
     "Unknown".
    :vartype connection_state: str or ~azure.mgmt.network.models.ConnectionState
    :ivar start_time: The start time of the connection snapshot.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the connection snapshot.
    :vartype end_time: ~datetime.datetime
    :ivar evaluation_state: Connectivity analysis evaluation state. Known values are: "NotStarted",
     "InProgress", and "Completed".
    :vartype evaluation_state: str or ~azure.mgmt.network.models.EvaluationState
    :ivar avg_latency_in_ms: Average latency in ms.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in ms.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in ms.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: The number of sent probes.
    :vartype probes_sent: int
    :ivar probes_failed: The number of failed probes.
    :vartype probes_failed: int
    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.models.ConnectivityHop]
    """

    _validation = {
        "avg_latency_in_ms": {"maximum": 4294967295, "minimum": 0},
        "min_latency_in_ms": {"maximum": 4294967295, "minimum": 0},
        "max_latency_in_ms": {"maximum": 4294967295, "minimum": 0},
        "probes_sent": {"maximum": 4294967295, "minimum": 0},
        "probes_failed": {"maximum": 4294967295, "minimum": 0},
        "hops": {"readonly": True},
    }

    _attribute_map = {
        "connection_state": {"key": "connectionState", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "evaluation_state": {"key": "evaluationState", "type": "str"},
        "avg_latency_in_ms": {"key": "avgLatencyInMs", "type": "int"},
        "min_latency_in_ms": {"key": "minLatencyInMs", "type": "int"},
        "max_latency_in_ms": {"key": "maxLatencyInMs", "type": "int"},
        "probes_sent": {"key": "probesSent", "type": "int"},
        "probes_failed": {"key": "probesFailed", "type": "int"},
        "hops": {"key": "hops", "type": "[ConnectivityHop]"},
    }

    def __init__(
        self,
        *,
        connection_state: Optional[Union[str, "_models.ConnectionState"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        evaluation_state: Optional[Union[str, "_models.EvaluationState"]] = None,
        avg_latency_in_ms: Optional[int] = None,
        min_latency_in_ms: Optional[int] = None,
        max_latency_in_ms: Optional[int] = None,
        probes_sent: Optional[int] = None,
        probes_failed: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword connection_state: The connection state. Known values are: "Reachable", "Unreachable",
         and "Unknown".
        :paramtype connection_state: str or ~azure.mgmt.network.models.ConnectionState
        :keyword start_time: The start time of the connection snapshot.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the connection snapshot.
        :paramtype end_time: ~datetime.datetime
        :keyword evaluation_state: Connectivity analysis evaluation state. Known values are:
         "NotStarted", "InProgress", and "Completed".
        :paramtype evaluation_state: str or ~azure.mgmt.network.models.EvaluationState
        :keyword avg_latency_in_ms: Average latency in ms.
        :paramtype avg_latency_in_ms: int
        :keyword min_latency_in_ms: Minimum latency in ms.
        :paramtype min_latency_in_ms: int
        :keyword max_latency_in_ms: Maximum latency in ms.
        :paramtype max_latency_in_ms: int
        :keyword probes_sent: The number of sent probes.
        :paramtype probes_sent: int
        :keyword probes_failed: The number of failed probes.
        :paramtype probes_failed: int
        """
        super().__init__(**kwargs)
        self.connection_state = connection_state
        self.start_time = start_time
        self.end_time = end_time
        self.evaluation_state = evaluation_state
        self.avg_latency_in_ms = avg_latency_in_ms
        self.min_latency_in_ms = min_latency_in_ms
        self.max_latency_in_ms = max_latency_in_ms
        self.probes_sent = probes_sent
        self.probes_failed = probes_failed
        self.hops = None

class ConnectivityDestination(_serialization.Model):
    """Parameters that define destination of connection.

    :ivar resource_id: The ID of the resource to which a connection attempt will be made.
    :vartype resource_id: str
    :ivar address: The IP address or URI the resource to which a connection attempt will be made.
    :vartype address: str
    :ivar port: Port on which check connectivity will be performed.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        address: Optional[str] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The ID of the resource to which a connection attempt will be made.
        :paramtype resource_id: str
        :keyword address: The IP address or URI the resource to which a connection attempt will be
         made.
        :paramtype address: str
        :keyword port: Port on which check connectivity will be performed.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port

class ConnectivityHop(_serialization.Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar previous_hop_ids: List of previous hop identifiers.
    :vartype previous_hop_ids: list[str]
    :ivar links: List of hop links.
    :vartype links: list[~azure.mgmt.network.models.HopLink]
    :ivar previous_links: List of previous hop links.
    :vartype previous_links: list[~azure.mgmt.network.models.HopLink]
    :ivar issues: List of issues.
    :vartype issues: list[~azure.mgmt.network.models.ConnectivityIssue]
    """

    _validation = {
        "type": {"readonly": True},
        "id": {"readonly": True},
        "address": {"readonly": True},
        "resource_id": {"readonly": True},
        "next_hop_ids": {"readonly": True},
        "previous_hop_ids": {"readonly": True},
        "links": {"readonly": True},
        "previous_links": {"readonly": True},
        "issues": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "next_hop_ids": {"key": "nextHopIds", "type": "[str]"},
        "previous_hop_ids": {"key": "previousHopIds", "type": "[str]"},
        "links": {"key": "links", "type": "[HopLink]"},
        "previous_links": {"key": "previousLinks", "type": "[HopLink]"},
        "issues": {"key": "issues", "type": "[ConnectivityIssue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.id = None
        self.address = None
        self.resource_id = None
        self.next_hop_ids = None
        self.previous_hop_ids = None
        self.links = None
        self.previous_links = None
        self.issues = None

class ConnectivityInformation(_serialization.Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops: list[~azure.mgmt.network.models.ConnectivityHop]
    :ivar connection_status: The connection status. Known values are: "Unknown", "Connected",
     "Disconnected", and "Degraded".
    :vartype connection_status: str or ~azure.mgmt.network.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: int
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: int
    """

    _validation = {
        "hops": {"readonly": True},
        "connection_status": {"readonly": True},
        "avg_latency_in_ms": {"readonly": True},
        "min_latency_in_ms": {"readonly": True},
        "max_latency_in_ms": {"readonly": True},
        "probes_sent": {"readonly": True},
        "probes_failed": {"readonly": True},
    }

    _attribute_map = {
        "hops": {"key": "hops", "type": "[ConnectivityHop]"},
        "connection_status": {"key": "connectionStatus", "type": "str"},
        "avg_latency_in_ms": {"key": "avgLatencyInMs", "type": "int"},
        "min_latency_in_ms": {"key": "minLatencyInMs", "type": "int"},
        "max_latency_in_ms": {"key": "maxLatencyInMs", "type": "int"},
        "probes_sent": {"key": "probesSent", "type": "int"},
        "probes_failed": {"key": "probesFailed", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.hops = None
        self.connection_status = None
        self.avg_latency_in_ms = None
        self.min_latency_in_ms = None
        self.max_latency_in_ms = None
        self.probes_sent = None
        self.probes_failed = None

class ConnectivityIssue(_serialization.Model):
    """Information about an issue encountered in the process of checking for connectivity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the issue. Known values are: "Local", "Inbound", and "Outbound".
    :vartype origin: str or ~azure.mgmt.network.models.Origin
    :ivar severity: The severity of the issue. Known values are: "Error" and "Warning".
    :vartype severity: str or ~azure.mgmt.network.models.Severity
    :ivar type: The type of issue. Known values are: "Unknown", "AgentStopped", "GuestFirewall",
     "DnsResolution", "SocketBind", "NetworkSecurityRule", "UserDefinedRoute", "PortThrottled", and
     "Platform".
    :vartype type: str or ~azure.mgmt.network.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        "origin": {"readonly": True},
        "severity": {"readonly": True},
        "type": {"readonly": True},
        "context": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "context": {"key": "context", "type": "[{str}]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.severity = None
        self.type = None
        self.context = None

class ConnectivityParameters(_serialization.Model):
    """Parameters that determine how the connectivity check will be performed.

    All required parameters must be populated in order to send to server.

    :ivar source: The source of the connection. Required.
    :vartype source: ~azure.mgmt.network.models.ConnectivitySource
    :ivar destination: The destination of connection. Required.
    :vartype destination: ~azure.mgmt.network.models.ConnectivityDestination
    :ivar protocol: Network protocol. Known values are: "Tcp", "Http", "Https", and "Icmp".
    :vartype protocol: str or ~azure.mgmt.network.models.Protocol
    :ivar protocol_configuration: Configuration of the protocol.
    :vartype protocol_configuration: ~azure.mgmt.network.models.ProtocolConfiguration
    :ivar preferred_ip_version: Preferred IP version of the connection. Known values are: "IPv4"
     and "IPv6".
    :vartype preferred_ip_version: str or ~azure.mgmt.network.models.IPVersion
    """

    _validation = {
        "source": {"required": True},
        "destination": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ConnectivitySource"},
        "destination": {"key": "destination", "type": "ConnectivityDestination"},
        "protocol": {"key": "protocol", "type": "str"},
        "protocol_configuration": {"key": "protocolConfiguration", "type": "ProtocolConfiguration"},
        "preferred_ip_version": {"key": "preferredIPVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: "_models.ConnectivitySource",
        destination: "_models.ConnectivityDestination",
        protocol: Optional[Union[str, "_models.Protocol"]] = None,
        protocol_configuration: Optional["_models.ProtocolConfiguration"] = None,
        preferred_ip_version: Optional[Union[str, "_models.IPVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: The source of the connection. Required.
        :paramtype source: ~azure.mgmt.network.models.ConnectivitySource
        :keyword destination: The destination of connection. Required.
        :paramtype destination: ~azure.mgmt.network.models.ConnectivityDestination
        :keyword protocol: Network protocol. Known values are: "Tcp", "Http", "Https", and "Icmp".
        :paramtype protocol: str or ~azure.mgmt.network.models.Protocol
        :keyword protocol_configuration: Configuration of the protocol.
        :paramtype protocol_configuration: ~azure.mgmt.network.models.ProtocolConfiguration
        :keyword preferred_ip_version: Preferred IP version of the connection. Known values are: "IPv4"
         and "IPv6".
        :paramtype preferred_ip_version: str or ~azure.mgmt.network.models.IPVersion
        """
        super().__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.protocol = protocol
        self.protocol_configuration = protocol_configuration
        self.preferred_ip_version = preferred_ip_version

class ConnectivitySource(_serialization.Model):
    """Parameters that define the source of the connection.

    All required parameters must be populated in order to send to server.

    :ivar resource_id: The ID of the resource from which a connectivity check will be initiated.
     Required.
    :vartype resource_id: str
    :ivar port: The source port from which a connectivity check will be performed.
    :vartype port: int
    """

    _validation = {
        "resource_id": {"required": True},
        "port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, resource_id: str, port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The ID of the resource from which a connectivity check will be initiated.
         Required.
        :paramtype resource_id: str
        :keyword port: The source port from which a connectivity check will be performed.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port

class Dimension(_serialization.Model):
    """Dimension of the metric.

    :ivar name: The name of the dimension.
    :vartype name: str
    :ivar display_name: The display name of the dimension.
    :vartype display_name: str
    :ivar internal_name: The internal name of the dimension.
    :vartype internal_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the dimension.
        :paramtype name: str
        :keyword display_name: The display name of the dimension.
        :paramtype display_name: str
        :keyword internal_name: The internal name of the dimension.
        :paramtype internal_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name

class EffectiveNetworkSecurityGroup(_serialization.Model):
    """Effective network security group.

    :ivar network_security_group: The ID of network security group that is applied.
    :vartype network_security_group: ~azure.mgmt.network.models.SubResource
    :ivar association: Associated resources.
    :vartype association:
     ~azure.mgmt.network.models.EffectiveNetworkSecurityGroupAssociation
    :ivar effective_security_rules: A collection of effective security rules.
    :vartype effective_security_rules:
     list[~azure.mgmt.network.models.EffectiveNetworkSecurityRule]
    :ivar tag_map: Mapping of tags to list of IP Addresses included within the tag.
    :vartype tag_map: str
    """

    _attribute_map = {
        "network_security_group": {"key": "networkSecurityGroup", "type": "SubResource"},
        "association": {"key": "association", "type": "EffectiveNetworkSecurityGroupAssociation"},
        "effective_security_rules": {"key": "effectiveSecurityRules", "type": "[EffectiveNetworkSecurityRule]"},
        "tag_map": {"key": "tagMap", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_security_group: Optional["_models.SubResource"] = None,
        association: Optional["_models.EffectiveNetworkSecurityGroupAssociation"] = None,
        effective_security_rules: Optional[List["_models.EffectiveNetworkSecurityRule"]] = None,
        tag_map: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_security_group: The ID of network security group that is applied.
        :paramtype network_security_group: ~azure.mgmt.network.models.SubResource
        :keyword association: Associated resources.
        :paramtype association:
         ~azure.mgmt.network.models.EffectiveNetworkSecurityGroupAssociation
        :keyword effective_security_rules: A collection of effective security rules.
        :paramtype effective_security_rules:
         list[~azure.mgmt.network.models.EffectiveNetworkSecurityRule]
        :keyword tag_map: Mapping of tags to list of IP Addresses included within the tag.
        :paramtype tag_map: str
        """
        super().__init__(**kwargs)
        self.network_security_group = network_security_group
        self.association = association
        self.effective_security_rules = effective_security_rules
        self.tag_map = tag_map

class EffectiveNetworkSecurityGroupAssociation(_serialization.Model):
    """The effective network security group association.

    :ivar network_manager: The ID of the Azure network manager if assigned.
    :vartype network_manager: ~azure.mgmt.network.models.SubResource
    :ivar subnet: The ID of the subnet if assigned.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar network_interface: The ID of the network interface if assigned.
    :vartype network_interface: ~azure.mgmt.network.models.SubResource
    """

    _attribute_map = {
        "network_manager": {"key": "networkManager", "type": "SubResource"},
        "subnet": {"key": "subnet", "type": "SubResource"},
        "network_interface": {"key": "networkInterface", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        network_manager: Optional["_models.SubResource"] = None,
        subnet: Optional["_models.SubResource"] = None,
        network_interface: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_manager: The ID of the Azure network manager if assigned.
        :paramtype network_manager: ~azure.mgmt.network.models.SubResource
        :keyword subnet: The ID of the subnet if assigned.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword network_interface: The ID of the network interface if assigned.
        :paramtype network_interface: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(**kwargs)
        self.network_manager = network_manager
        self.subnet = subnet
        self.network_interface = network_interface

class EffectiveNetworkSecurityGroupListResult(_serialization.Model):
    """Response for list effective network security groups API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of effective network security groups.
    :vartype value: list[~azure.mgmt.network.models.EffectiveNetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveNetworkSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.EffectiveNetworkSecurityGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of effective network security groups.
        :paramtype value: list[~azure.mgmt.network.models.EffectiveNetworkSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class EffectiveNetworkSecurityRule(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Effective network security rules.

    :ivar name: The name of the security rule specified by the user (if created by the user).
    :vartype name: str
    :ivar protocol: The network protocol this rule applies to. Known values are: "Tcp", "Udp", and
     "All".
    :vartype protocol: str or ~azure.mgmt.network.models.EffectiveSecurityRuleProtocol
    :ivar source_port_range: The source port or range.
    :vartype source_port_range: str
    :ivar destination_port_range: The destination port or range.
    :vartype destination_port_range: str
    :ivar source_port_ranges: The source port ranges. Expected values include a single integer
     between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges. Expected values include a single
     integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
    :vartype destination_port_ranges: list[str]
    :ivar source_address_prefix: The source address prefix.
    :vartype source_address_prefix: str
    :ivar destination_address_prefix: The destination address prefix.
    :vartype destination_address_prefix: str
    :ivar source_address_prefixes: The source address prefixes. Expected values include CIDR IP
     ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
     asterisk (*).
    :vartype source_address_prefixes: list[str]
    :ivar destination_address_prefixes: The destination address prefixes. Expected values include
     CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and
     the asterisk (*).
    :vartype destination_address_prefixes: list[str]
    :ivar expanded_source_address_prefix: The expanded source address prefix.
    :vartype expanded_source_address_prefix: list[str]
    :ivar expanded_destination_address_prefix: Expanded destination address prefix.
    :vartype expanded_destination_address_prefix: list[str]
    :ivar access: Whether network traffic is allowed or denied. Known values are: "Allow" and
     "Deny".
    :vartype access: str or ~azure.mgmt.network.models.SecurityRuleAccess
    :ivar priority: The priority of the rule.
    :vartype priority: int
    :ivar direction: The direction of the rule. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.SecurityRuleDirection
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "source_port_range": {"key": "sourcePortRange", "type": "str"},
        "destination_port_range": {"key": "destinationPortRange", "type": "str"},
        "source_port_ranges": {"key": "sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "destinationPortRanges", "type": "[str]"},
        "source_address_prefix": {"key": "sourceAddressPrefix", "type": "str"},
        "destination_address_prefix": {"key": "destinationAddressPrefix", "type": "str"},
        "source_address_prefixes": {"key": "sourceAddressPrefixes", "type": "[str]"},
        "destination_address_prefixes": {"key": "destinationAddressPrefixes", "type": "[str]"},
        "expanded_source_address_prefix": {"key": "expandedSourceAddressPrefix", "type": "[str]"},
        "expanded_destination_address_prefix": {"key": "expandedDestinationAddressPrefix", "type": "[str]"},
        "access": {"key": "access", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "direction": {"key": "direction", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        protocol: Optional[Union[str, "_models.EffectiveSecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        expanded_source_address_prefix: Optional[List[str]] = None,
        expanded_destination_address_prefix: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityRuleDirection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the security rule specified by the user (if created by the user).
        :paramtype name: str
        :keyword protocol: The network protocol this rule applies to. Known values are: "Tcp", "Udp",
         and "All".
        :paramtype protocol: str or
         ~azure.mgmt.network.models.EffectiveSecurityRuleProtocol
        :keyword source_port_range: The source port or range.
        :paramtype source_port_range: str
        :keyword destination_port_range: The destination port or range.
        :paramtype destination_port_range: str
        :keyword source_port_ranges: The source port ranges. Expected values include a single integer
         between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges. Expected values include a single
         integer between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
        :paramtype destination_port_ranges: list[str]
        :keyword source_address_prefix: The source address prefix.
        :paramtype source_address_prefix: str
        :keyword destination_address_prefix: The destination address prefix.
        :paramtype destination_address_prefix: str
        :keyword source_address_prefixes: The source address prefixes. Expected values include CIDR IP
         ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the
         asterisk (*).
        :paramtype source_address_prefixes: list[str]
        :keyword destination_address_prefixes: The destination address prefixes. Expected values
         include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System
         Tags, and the asterisk (*).
        :paramtype destination_address_prefixes: list[str]
        :keyword expanded_source_address_prefix: The expanded source address prefix.
        :paramtype expanded_source_address_prefix: list[str]
        :keyword expanded_destination_address_prefix: Expanded destination address prefix.
        :paramtype expanded_destination_address_prefix: list[str]
        :keyword access: Whether network traffic is allowed or denied. Known values are: "Allow" and
         "Deny".
        :paramtype access: str or ~azure.mgmt.network.models.SecurityRuleAccess
        :keyword priority: The priority of the rule.
        :paramtype priority: int
        :keyword direction: The direction of the rule. Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.models.SecurityRuleDirection
        """
        super().__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefixes = destination_address_prefixes
        self.expanded_source_address_prefix = expanded_source_address_prefix
        self.expanded_destination_address_prefix = expanded_destination_address_prefix
        self.access = access
        self.priority = priority
        self.direction = direction

class EffectiveRoute(_serialization.Model):
    """Effective Route.

    :ivar name: The name of the user defined route. This is optional.
    :vartype name: str
    :ivar disable_bgp_route_propagation: If true, on-premises routes are not propagated to the
     network interfaces in the subnet.
    :vartype disable_bgp_route_propagation: bool
    :ivar source: Who created the route. Known values are: "Unknown", "User",
     "VirtualNetworkGateway", and "Default".
    :vartype source: str or ~azure.mgmt.network.models.EffectiveRouteSource
    :ivar state: The value of effective route. Known values are: "Active" and "Invalid".
    :vartype state: str or ~azure.mgmt.network.models.EffectiveRouteState
    :ivar address_prefix: The address prefixes of the effective routes in CIDR notation.
    :vartype address_prefix: list[str]
    :ivar next_hop_ip_address: The IP address of the next hop of the effective route.
    :vartype next_hop_ip_address: list[str]
    :ivar next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
     "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.models.RouteNextHopType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "disable_bgp_route_propagation": {"key": "disableBgpRoutePropagation", "type": "bool"},
        "source": {"key": "source", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "address_prefix": {"key": "addressPrefix", "type": "[str]"},
        "next_hop_ip_address": {"key": "nextHopIpAddress", "type": "[str]"},
        "next_hop_type": {"key": "nextHopType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disable_bgp_route_propagation: Optional[bool] = None,
        source: Optional[Union[str, "_models.EffectiveRouteSource"]] = None,
        state: Optional[Union[str, "_models.EffectiveRouteState"]] = None,
        address_prefix: Optional[List[str]] = None,
        next_hop_ip_address: Optional[List[str]] = None,
        next_hop_type: Optional[Union[str, "_models.RouteNextHopType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the user defined route. This is optional.
        :paramtype name: str
        :keyword disable_bgp_route_propagation: If true, on-premises routes are not propagated to the
         network interfaces in the subnet.
        :paramtype disable_bgp_route_propagation: bool
        :keyword source: Who created the route. Known values are: "Unknown", "User",
         "VirtualNetworkGateway", and "Default".
        :paramtype source: str or ~azure.mgmt.network.models.EffectiveRouteSource
        :keyword state: The value of effective route. Known values are: "Active" and "Invalid".
        :paramtype state: str or ~azure.mgmt.network.models.EffectiveRouteState
        :keyword address_prefix: The address prefixes of the effective routes in CIDR notation.
        :paramtype address_prefix: list[str]
        :keyword next_hop_ip_address: The IP address of the next hop of the effective route.
        :paramtype next_hop_ip_address: list[str]
        :keyword next_hop_type: The type of Azure hop the packet should be sent to. Known values are:
         "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.models.RouteNextHopType
        """
        super().__init__(**kwargs)
        self.name = name
        self.disable_bgp_route_propagation = disable_bgp_route_propagation
        self.source = source
        self.state = state
        self.address_prefix = address_prefix
        self.next_hop_ip_address = next_hop_ip_address
        self.next_hop_type = next_hop_type

class EffectiveRouteListResult(_serialization.Model):
    """Response for list effective route API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of effective routes.
    :vartype value: list[~azure.mgmt.network.models.EffectiveRoute]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveRoute]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.EffectiveRoute"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of effective routes.
        :paramtype value: list[~azure.mgmt.network.models.EffectiveRoute]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class EndpointServiceResult(SubResource):
    """Endpoint service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the endpoint service.
    :vartype name: str
    :ivar type: Type of the endpoint service.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.type = None

class EndpointServicesListResult(_serialization.Model):
    """Response for the ListAvailableEndpointServices API service call.

    :ivar value: List of available endpoint services in a region.
    :vartype value: list[~azure.mgmt.network.models.EndpointServiceResult]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EndpointServiceResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EndpointServiceResult"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of available endpoint services in a region.
        :paramtype value: list[~azure.mgmt.network.models.EndpointServiceResult]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRouteCircuitRoutesTableSummary(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    :ivar neighbor: IP address of the neighbor.
    :vartype neighbor: str
    :ivar v: BGP version number spoken to the neighbor.
    :vartype v: int
    :ivar as_property: Autonomous system number.
    :vartype as_property: int
    :ivar up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :vartype up_down: str
    :ivar state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
     been received from a neighbor or peer group.
    :vartype state_pfx_rcd: str
    """

    _attribute_map = {
        "neighbor": {"key": "neighbor", "type": "str"},
        "v": {"key": "v", "type": "int"},
        "as_property": {"key": "as", "type": "int"},
        "up_down": {"key": "upDown", "type": "str"},
        "state_pfx_rcd": {"key": "statePfxRcd", "type": "str"},
    }

    def __init__(
        self,
        *,
        neighbor: Optional[str] = None,
        v: Optional[int] = None,
        as_property: Optional[int] = None,
        up_down: Optional[str] = None,
        state_pfx_rcd: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword neighbor: IP address of the neighbor.
        :paramtype neighbor: str
        :keyword v: BGP version number spoken to the neighbor.
        :paramtype v: int
        :keyword as_property: Autonomous system number.
        :paramtype as_property: int
        :keyword up_down: The length of time that the BGP session has been in the Established state, or
         the current status if not in the Established state.
        :paramtype up_down: str
        :keyword state_pfx_rcd: Current state of the BGP session, and the number of prefixes that have
         been received from a neighbor or peer group.
        :paramtype state_pfx_rcd: str
        """
        super().__init__(**kwargs)
        self.neighbor = neighbor
        self.v = v
        self.as_property = as_property
        self.up_down = up_down
        self.state_pfx_rcd = state_pfx_rcd

class ExpressRouteCircuitsRoutesTableSummaryListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: A list of the routes table.
    :vartype value:
     list[~azure.mgmt.network.models.ExpressRouteCircuitRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTableSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitRoutesTableSummary"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of the routes table.
        :paramtype value:
         list[~azure.mgmt.network.models.ExpressRouteCircuitRoutesTableSummary]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class FlowLogInformation(_serialization.Model):
    """Information on the configuration of flow log and traffic analytics (optional) .

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The ID of the resource to configure for flow log and traffic
     analytics (optional) . Required.
    :vartype target_resource_id: str
    :ivar flow_analytics_configuration: Parameters that define the configuration of traffic
     analytics.
    :vartype flow_analytics_configuration:
     ~azure.mgmt.network.models.TrafficAnalyticsProperties
    :ivar identity: FlowLog resource Managed Identity.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar storage_id: ID of the storage account which is used to store the flow log. Required.
    :vartype storage_id: str
    :ivar enabled_filtering_criteria: Optional field to filter network traffic logs based on SrcIP,
     SrcPort, DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified, all
     network traffic will be logged.
    :vartype enabled_filtering_criteria: str
    :ivar enabled: Flag to enable/disable flow logging. Required.
    :vartype enabled: bool
    :ivar retention_policy: Parameters that define the retention policy for flow log.
    :vartype retention_policy: ~azure.mgmt.network.models.RetentionPolicyParameters
    :ivar format: Parameters that define the flow log format.
    :vartype format: ~azure.mgmt.network.models.FlowLogFormatParameters
    """

    _validation = {
        "target_resource_id": {"required": True},
        "storage_id": {"required": True},
        "enabled": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "flow_analytics_configuration": {"key": "flowAnalyticsConfiguration", "type": "TrafficAnalyticsProperties"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "storage_id": {"key": "properties.storageId", "type": "str"},
        "enabled_filtering_criteria": {"key": "properties.enabledFilteringCriteria", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "retention_policy": {"key": "properties.retentionPolicy", "type": "RetentionPolicyParameters"},
        "format": {"key": "properties.format", "type": "FlowLogFormatParameters"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        storage_id: str,
        enabled: bool,
        flow_analytics_configuration: Optional["_models.TrafficAnalyticsProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        enabled_filtering_criteria: Optional[str] = None,
        retention_policy: Optional["_models.RetentionPolicyParameters"] = None,
        format: Optional["_models.FlowLogFormatParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_id: The ID of the resource to configure for flow log and traffic
         analytics (optional) . Required.
        :paramtype target_resource_id: str
        :keyword flow_analytics_configuration: Parameters that define the configuration of traffic
         analytics.
        :paramtype flow_analytics_configuration:
         ~azure.mgmt.network.models.TrafficAnalyticsProperties
        :keyword identity: FlowLog resource Managed Identity.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword storage_id: ID of the storage account which is used to store the flow log. Required.
        :paramtype storage_id: str
        :keyword enabled_filtering_criteria: Optional field to filter network traffic logs based on
         SrcIP, SrcPort, DstIP, DstPort, Protocol, Encryption, Direction and Action. If not specified,
         all network traffic will be logged.
        :paramtype enabled_filtering_criteria: str
        :keyword enabled: Flag to enable/disable flow logging. Required.
        :paramtype enabled: bool
        :keyword retention_policy: Parameters that define the retention policy for flow log.
        :paramtype retention_policy: ~azure.mgmt.network.models.RetentionPolicyParameters
        :keyword format: Parameters that define the flow log format.
        :paramtype format: ~azure.mgmt.network.models.FlowLogFormatParameters
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.flow_analytics_configuration = flow_analytics_configuration
        self.identity = identity
        self.storage_id = storage_id
        self.enabled_filtering_criteria = enabled_filtering_criteria
        self.enabled = enabled
        self.retention_policy = retention_policy
        self.format = format

class FlowLogStatusParameters(_serialization.Model):
    """Parameters that define a resource to query flow log and traffic analytics (optional) status.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The target resource where getting the flow log and traffic analytics
     (optional) status. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs: Any) -> None:
        """
        :keyword target_resource_id: The target resource where getting the flow log and traffic
         analytics (optional) status. Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id

class GatewayRoute(_serialization.Model):
    """Gateway routing details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar local_address: The gateway's local address.
    :vartype local_address: str
    :ivar network: The route's network prefix.
    :vartype network: str
    :ivar next_hop: The route's next hop.
    :vartype next_hop: str
    :ivar source_peer: The peer this route was learned from.
    :vartype source_peer: str
    :ivar origin: The source this route was learned from.
    :vartype origin: str
    :ivar as_path: The route's AS path sequence.
    :vartype as_path: str
    :ivar weight: The route's weight.
    :vartype weight: int
    """

    _validation = {
        "local_address": {"readonly": True},
        "network": {"readonly": True},
        "next_hop": {"readonly": True},
        "source_peer": {"readonly": True},
        "origin": {"readonly": True},
        "as_path": {"readonly": True},
        "weight": {"readonly": True},
    }

    _attribute_map = {
        "local_address": {"key": "localAddress", "type": "str"},
        "network": {"key": "network", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "str"},
        "source_peer": {"key": "sourcePeer", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "as_path": {"key": "asPath", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.local_address = None
        self.network = None
        self.next_hop = None
        self.source_peer = None
        self.origin = None
        self.as_path = None
        self.weight = None

class GatewayRouteListResult(_serialization.Model):
    """List of virtual network gateway routes.

    :ivar value: List of gateway routes.
    :vartype value: list[~azure.mgmt.network.models.GatewayRoute]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GatewayRoute]"},
    }

    def __init__(self, *, value: Optional[List["_models.GatewayRoute"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of gateway routes.
        :paramtype value: list[~azure.mgmt.network.models.GatewayRoute]
        """
        super().__init__(**kwargs)
        self.value = value

class IPAddressAvailabilityResult(_serialization.Model):
    """Response for CheckIPAddressAvailability API service call.

    :ivar available: Private IP address availability.
    :vartype available: bool
    :ivar available_ip_addresses: Contains other available private IP addresses if the asked for
     address is taken.
    :vartype available_ip_addresses: list[str]
    :ivar is_platform_reserved: Private IP address platform reserved.
    :vartype is_platform_reserved: bool
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
        "available_ip_addresses": {"key": "availableIPAddresses", "type": "[str]"},
        "is_platform_reserved": {"key": "isPlatformReserved", "type": "bool"},
    }

    def __init__(
        self,
        *,
        available: Optional[bool] = None,
        available_ip_addresses: Optional[List[str]] = None,
        is_platform_reserved: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available: Private IP address availability.
        :paramtype available: bool
        :keyword available_ip_addresses: Contains other available private IP addresses if the asked for
         address is taken.
        :paramtype available_ip_addresses: list[str]
        :keyword is_platform_reserved: Private IP address platform reserved.
        :paramtype is_platform_reserved: bool
        """
        super().__init__(**kwargs)
        self.available = available
        self.available_ip_addresses = available_ip_addresses
        self.is_platform_reserved = is_platform_reserved

class InboundNatRuleListResult(_serialization.Model):
    """Response for ListInboundNatRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of inbound NAT rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.models.InboundNatRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InboundNatRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.InboundNatRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of inbound NAT rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.models.InboundNatRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class IpsecPolicy(_serialization.Model):
    """An IPSec Policy configuration for a virtual network gateway connection.

    All required parameters must be populated in order to send to server.

    :ivar sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) lifetime in seconds for a site to site VPN tunnel. Required.
    :vartype sa_life_time_seconds: int
    :ivar sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) payload size in KB for a site to site VPN tunnel. Required.
    :vartype sa_data_size_kilobytes: int
    :ivar ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
     are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
     "GCMAES256".
    :vartype ipsec_encryption: str or ~azure.mgmt.network.models.IpsecEncryption
    :ivar ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values are:
     "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
    :vartype ipsec_integrity: str or ~azure.mgmt.network.models.IpsecIntegrity
    :ivar ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values are:
     "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", and "GCMAES128".
    :vartype ike_encryption: str or ~azure.mgmt.network.models.IkeEncryption
    :ivar ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
     "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", and "GCMAES128".
    :vartype ike_integrity: str or ~azure.mgmt.network.models.IkeIntegrity
    :ivar dh_group: The DH Group used in IKE Phase 1 for initial SA. Required. Known values are:
     "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
     "DHGroup24".
    :vartype dh_group: str or ~azure.mgmt.network.models.DhGroup
    :ivar pfs_group: The Pfs Group used in IKE Phase 2 for new child SA. Required. Known values
     are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", and "PFSMM".
    :vartype pfs_group: str or ~azure.mgmt.network.models.PfsGroup
    """

    _validation = {
        "sa_life_time_seconds": {"required": True},
        "sa_data_size_kilobytes": {"required": True},
        "ipsec_encryption": {"required": True},
        "ipsec_integrity": {"required": True},
        "ike_encryption": {"required": True},
        "ike_integrity": {"required": True},
        "dh_group": {"required": True},
        "pfs_group": {"required": True},
    }

    _attribute_map = {
        "sa_life_time_seconds": {"key": "saLifeTimeSeconds", "type": "int"},
        "sa_data_size_kilobytes": {"key": "saDataSizeKilobytes", "type": "int"},
        "ipsec_encryption": {"key": "ipsecEncryption", "type": "str"},
        "ipsec_integrity": {"key": "ipsecIntegrity", "type": "str"},
        "ike_encryption": {"key": "ikeEncryption", "type": "str"},
        "ike_integrity": {"key": "ikeIntegrity", "type": "str"},
        "dh_group": {"key": "dhGroup", "type": "str"},
        "pfs_group": {"key": "pfsGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        sa_life_time_seconds: int,
        sa_data_size_kilobytes: int,
        ipsec_encryption: Union[str, "_models.IpsecEncryption"],
        ipsec_integrity: Union[str, "_models.IpsecIntegrity"],
        ike_encryption: Union[str, "_models.IkeEncryption"],
        ike_integrity: Union[str, "_models.IkeIntegrity"],
        dh_group: Union[str, "_models.DhGroup"],
        pfs_group: Union[str, "_models.PfsGroup"],
        **kwargs: Any
    ) -> None:
        """
        :keyword sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase
         2 SA) lifetime in seconds for a site to site VPN tunnel. Required.
        :paramtype sa_life_time_seconds: int
        :keyword sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or
         Phase 2 SA) payload size in KB for a site to site VPN tunnel. Required.
        :paramtype sa_data_size_kilobytes: int
        :keyword ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
         are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
         "GCMAES256".
        :paramtype ipsec_encryption: str or ~azure.mgmt.network.models.IpsecEncryption
        :keyword ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values
         are: "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
        :paramtype ipsec_integrity: str or ~azure.mgmt.network.models.IpsecIntegrity
        :keyword ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values
         are: "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", and "GCMAES128".
        :paramtype ike_encryption: str or ~azure.mgmt.network.models.IkeEncryption
        :keyword ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
         "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", and "GCMAES128".
        :paramtype ike_integrity: str or ~azure.mgmt.network.models.IkeIntegrity
        :keyword dh_group: The DH Group used in IKE Phase 1 for initial SA. Required. Known values are:
         "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
         "DHGroup24".
        :paramtype dh_group: str or ~azure.mgmt.network.models.DhGroup
        :keyword pfs_group: The Pfs Group used in IKE Phase 2 for new child SA. Required. Known values
         are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", and "PFSMM".
        :paramtype pfs_group: str or ~azure.mgmt.network.models.PfsGroup
        """
        super().__init__(**kwargs)
        self.sa_life_time_seconds = sa_life_time_seconds
        self.sa_data_size_kilobytes = sa_data_size_kilobytes
        self.ipsec_encryption = ipsec_encryption
        self.ipsec_integrity = ipsec_integrity
        self.ike_encryption = ike_encryption
        self.ike_integrity = ike_integrity
        self.dh_group = dh_group
        self.pfs_group = pfs_group

class Ipv6ExpressRouteCircuitPeeringConfig(_serialization.Model):
    """Contains IPv6 peering config.

    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
    :ivar route_filter: The reference to the RouteFilter resource.
    :vartype route_filter: ~azure.mgmt.network.models.SubResource
    :ivar state: The state of peering. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.models.ExpressRouteCircuitPeeringState
    """

    _attribute_map = {
        "primary_peer_address_prefix": {"key": "primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "secondaryPeerAddressPrefix", "type": "str"},
        "microsoft_peering_config": {"key": "microsoftPeeringConfig", "type": "ExpressRouteCircuitPeeringConfig"},
        "route_filter": {"key": "routeFilter", "type": "SubResource"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        route_filter: Optional["_models.SubResource"] = None,
        state: Optional[Union[str, "_models.ExpressRouteCircuitPeeringState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
        :keyword route_filter: The reference to the RouteFilter resource.
        :paramtype route_filter: ~azure.mgmt.network.models.SubResource
        :keyword state: The state of peering. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.models.ExpressRouteCircuitPeeringState
        """
        super().__init__(**kwargs)
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.microsoft_peering_config = microsoft_peering_config
        self.route_filter = route_filter
        self.state = state

class LoadBalancerBackendAddressPoolListResult(_serialization.Model):
    """Response for ListBackendAddressPool API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of backend address pools in a load balancer.
    :vartype value: list[~azure.mgmt.network.models.BackendAddressPool]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BackendAddressPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.BackendAddressPool"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of backend address pools in a load balancer.
        :paramtype value: list[~azure.mgmt.network.models.BackendAddressPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class LoadBalancerFrontendIPConfigurationListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListFrontendIPConfiguration API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of frontend IP configurations in a load balancer.
    :vartype value: list[~azure.mgmt.network.models.FrontendIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FrontendIPConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.FrontendIPConfiguration"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of frontend IP configurations in a load balancer.
        :paramtype value: list[~azure.mgmt.network.models.FrontendIPConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class LoadBalancerLoadBalancingRuleListResult(_serialization.Model):
    """Response for ListLoadBalancingRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancing rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.models.LoadBalancingRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancingRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancingRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of load balancing rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.models.LoadBalancingRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class LoadBalancerProbeListResult(_serialization.Model):
    """Response for ListProbe API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of probes in a load balancer.
    :vartype value: list[~azure.mgmt.network.models.Probe]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Probe]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Probe"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of probes in a load balancer.
        :paramtype value: list[~azure.mgmt.network.models.Probe]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class LoadBalancerSku(_serialization.Model):
    """SKU of a load balancer.

    :ivar name: Name of a load balancer SKU. Known values are: "Basic", "Standard", and "Gateway".
    :vartype name: str or ~azure.mgmt.network.models.LoadBalancerSkuName
    :ivar tier: Tier of a load balancer SKU. Known values are: "Regional", "Global", and "Global".
    :vartype tier: str or ~azure.mgmt.network.models.LoadBalancerSkuTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.LoadBalancerSkuName"]] = None,
        tier: Optional[Union[str, "_models.LoadBalancerSkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of a load balancer SKU. Known values are: "Basic", "Standard", and
         "Gateway".
        :paramtype name: str or ~azure.mgmt.network.models.LoadBalancerSkuName
        :keyword tier: Tier of a load balancer SKU. Known values are: "Regional", "Global", and
         "Global".
        :paramtype tier: str or ~azure.mgmt.network.models.LoadBalancerSkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier

class LogSpecification(_serialization.Model):
    """Description of logging specification.

    :ivar name: The name of the specification.
    :vartype name: str
    :ivar display_name: The display name of the specification.
    :vartype display_name: str
    :ivar blob_duration: Duration of the blob.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the specification.
        :paramtype name: str
        :keyword display_name: The display name of the specification.
        :paramtype display_name: str
        :keyword blob_duration: Duration of the blob.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration

class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Description of metrics specification.

    :ivar name: The name of the metric.
    :vartype name: str
    :ivar display_name: The display name of the metric.
    :vartype display_name: str
    :ivar display_description: The description of the metric.
    :vartype display_description: str
    :ivar unit: Units the metric to be displayed in.
    :vartype unit: str
    :ivar aggregation_type: The aggregation type.
    :vartype aggregation_type: str
    :ivar availabilities: List of availability.
    :vartype availabilities: list[~azure.mgmt.network.models.Availability]
    :ivar enable_regional_mdm_account: Whether regional MDM account enabled.
    :vartype enable_regional_mdm_account: bool
    :ivar fill_gap_with_zero: Whether gaps would be filled with zeros.
    :vartype fill_gap_with_zero: bool
    :ivar metric_filter_pattern: Pattern for the filter of the metric.
    :vartype metric_filter_pattern: str
    :ivar dimensions: List of dimensions.
    :vartype dimensions: list[~azure.mgmt.network.models.Dimension]
    :ivar is_internal: Whether the metric is internal.
    :vartype is_internal: bool
    :ivar source_mdm_account: The source MDM account.
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace: The source MDM namespace.
    :vartype source_mdm_namespace: str
    :ivar resource_id_dimension_name_override: The resource Id dimension name override.
    :vartype resource_id_dimension_name_override: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[Availability]"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "bool"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "metric_filter_pattern": {"key": "metricFilterPattern", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "is_internal": {"key": "isInternal", "type": "bool"},
        "source_mdm_account": {"key": "sourceMdmAccount", "type": "str"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
        "resource_id_dimension_name_override": {"key": "resourceIdDimensionNameOverride", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        availabilities: Optional[List["_models.Availability"]] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        fill_gap_with_zero: Optional[bool] = None,
        metric_filter_pattern: Optional[str] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        is_internal: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the metric.
        :paramtype name: str
        :keyword display_name: The display name of the metric.
        :paramtype display_name: str
        :keyword display_description: The description of the metric.
        :paramtype display_description: str
        :keyword unit: Units the metric to be displayed in.
        :paramtype unit: str
        :keyword aggregation_type: The aggregation type.
        :paramtype aggregation_type: str
        :keyword availabilities: List of availability.
        :paramtype availabilities: list[~azure.mgmt.network.models.Availability]
        :keyword enable_regional_mdm_account: Whether regional MDM account enabled.
        :paramtype enable_regional_mdm_account: bool
        :keyword fill_gap_with_zero: Whether gaps would be filled with zeros.
        :paramtype fill_gap_with_zero: bool
        :keyword metric_filter_pattern: Pattern for the filter of the metric.
        :paramtype metric_filter_pattern: str
        :keyword dimensions: List of dimensions.
        :paramtype dimensions: list[~azure.mgmt.network.models.Dimension]
        :keyword is_internal: Whether the metric is internal.
        :paramtype is_internal: bool
        :keyword source_mdm_account: The source MDM account.
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace: The source MDM namespace.
        :paramtype source_mdm_namespace: str
        :keyword resource_id_dimension_name_override: The resource Id dimension name override.
        :paramtype resource_id_dimension_name_override: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.availabilities = availabilities
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.fill_gap_with_zero = fill_gap_with_zero
        self.metric_filter_pattern = metric_filter_pattern
        self.dimensions = dimensions
        self.is_internal = is_internal
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.resource_id_dimension_name_override = resource_id_dimension_name_override

class NetworkInterfaceAssociation(_serialization.Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Network interface ID.
    :vartype id: str
    :ivar security_rules: Collection of custom security rules.
    :vartype security_rules: list[~azure.mgmt.network.models.SecurityRule]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rules": {"key": "securityRules", "type": "[SecurityRule]"},
    }

    def __init__(self, *, security_rules: Optional[List["_models.SecurityRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword security_rules: Collection of custom security rules.
        :paramtype security_rules: list[~azure.mgmt.network.models.SecurityRule]
        """
        super().__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules

class NetworkInterfaceIPConfigurationListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of ip configurations.
    :vartype value: list[~azure.mgmt.network.models.NetworkInterfaceIPConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterfaceIPConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ip configurations.
        :paramtype value: list[~azure.mgmt.network.models.NetworkInterfaceIPConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class NetworkInterfaceLoadBalancerListResult(_serialization.Model):
    """Response for list ip configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of load balancers.
    :vartype value: list[~azure.mgmt.network.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.LoadBalancer"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of load balancers.
        :paramtype value: list[~azure.mgmt.network.models.LoadBalancer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class NetworkWatcher(Resource):
    """Network watcher in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the network watcher resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.provisioning_state = None

class NetworkWatcherListResult(_serialization.Model):
    """Response for ListNetworkWatchers API service call.

    :ivar value: List of network watcher resources.
    :vartype value: list[~azure.mgmt.network.models.NetworkWatcher]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkWatcher]"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkWatcher"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of network watcher resources.
        :paramtype value: list[~azure.mgmt.network.models.NetworkWatcher]
        """
        super().__init__(**kwargs)
        self.value = value

class NextHopParameters(_serialization.Model):
    """Parameters that define the source and destination endpoint.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The resource identifier of the target resource against which the
     action is to be performed. Required.
    :vartype target_resource_id: str
    :ivar source_ip_address: The source IP address. Required.
    :vartype source_ip_address: str
    :ivar destination_ip_address: The destination IP address. Required.
    :vartype destination_ip_address: str
    :ivar target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is enabled
     on any of the nics, then this parameter must be specified. Otherwise optional).
    :vartype target_nic_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "source_ip_address": {"required": True},
        "destination_ip_address": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "source_ip_address": {"key": "sourceIPAddress", "type": "str"},
        "destination_ip_address": {"key": "destinationIPAddress", "type": "str"},
        "target_nic_resource_id": {"key": "targetNicResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        source_ip_address: str,
        destination_ip_address: str,
        target_nic_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_id: The resource identifier of the target resource against which the
         action is to be performed. Required.
        :paramtype target_resource_id: str
        :keyword source_ip_address: The source IP address. Required.
        :paramtype source_ip_address: str
        :keyword destination_ip_address: The destination IP address. Required.
        :paramtype destination_ip_address: str
        :keyword target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
         enabled on any of the nics, then this parameter must be specified. Otherwise optional).
        :paramtype target_nic_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.source_ip_address = source_ip_address
        self.destination_ip_address = destination_ip_address
        self.target_nic_resource_id = target_nic_resource_id

class NextHopResult(_serialization.Model):
    """The information about next hop from the specified VM.

    :ivar next_hop_type: Next hop type. Known values are: "Internet", "VirtualAppliance",
     "VirtualNetworkGateway", "VnetLocal", "HyperNetGateway", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.models.NextHopType
    :ivar next_hop_ip_address: Next hop IP Address.
    :vartype next_hop_ip_address: str
    :ivar route_table_id: The resource identifier for the route table associated with the route
     being returned. If the route being returned does not correspond to any user created routes then
     this field will be the string 'System Route'.
    :vartype route_table_id: str
    """

    _attribute_map = {
        "next_hop_type": {"key": "nextHopType", "type": "str"},
        "next_hop_ip_address": {"key": "nextHopIpAddress", "type": "str"},
        "route_table_id": {"key": "routeTableId", "type": "str"},
    }

    def __init__(
        self,
        *,
        next_hop_type: Optional[Union[str, "_models.NextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        route_table_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_hop_type: Next hop type. Known values are: "Internet", "VirtualAppliance",
         "VirtualNetworkGateway", "VnetLocal", "HyperNetGateway", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.models.NextHopType
        :keyword next_hop_ip_address: Next hop IP Address.
        :paramtype next_hop_ip_address: str
        :keyword route_table_id: The resource identifier for the route table associated with the route
         being returned. If the route being returned does not correspond to any user created routes then
         this field will be the string 'System Route'.
        :paramtype route_table_id: str
        """
        super().__init__(**kwargs)
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.route_table_id = route_table_id

class Operation(_serialization.Model):
    """Network REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.network.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar service_specification: Specification of the service.
    :vartype service_specification:
     ~azure.mgmt.network.models.OperationPropertiesFormatServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {
            "key": "properties.serviceSpecification",
            "type": "OperationPropertiesFormatServiceSpecification",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.OperationPropertiesFormatServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.network.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword service_specification: Specification of the service.
        :paramtype service_specification:
         ~azure.mgmt.network.models.OperationPropertiesFormatServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification

class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Network.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Type of the operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft Network.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Type of the operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description

class OperationListResult(_serialization.Model):
    """Result of the request to list Network operations. It contains a list of operations and a URL
    link to get the next set of results.

    :ivar value: List of Network operations supported by the Network resource provider.
    :vartype value: list[~azure.mgmt.network.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Network operations supported by the Network resource provider.
        :paramtype value: list[~azure.mgmt.network.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class OperationPropertiesFormatServiceSpecification(_serialization.Model):  # pylint: disable=name-too-long
    """Specification of the service.

    :ivar metric_specifications: Operation service specification.
    :vartype metric_specifications:
     list[~azure.mgmt.network.models.MetricSpecification]
    :ivar log_specifications: Operation log specification.
    :vartype log_specifications: list[~azure.mgmt.network.models.LogSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications: Operation service specification.
        :paramtype metric_specifications:
         list[~azure.mgmt.network.models.MetricSpecification]
        :keyword log_specifications: Operation log specification.
        :paramtype log_specifications: list[~azure.mgmt.network.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications

class PacketCapture(_serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to server.

    :ivar target: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are
     currently supported. Required.
    :vartype target: str
    :ivar scope: A list of AzureVMSS instances which can be included or excluded to run packet
     capture. If both included and excluded are empty, then the packet capture will run on all
     instances of AzureVMSS.
    :vartype scope: ~azure.mgmt.network.models.PacketCaptureMachineScope
    :ivar target_type: Target type of the resource provided. Known values are: "AzureVM" and
     "AzureVMSS".
    :vartype target_type: str or ~azure.mgmt.network.models.PacketCaptureTargetType
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: The storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.models.PacketCaptureStorageLocation
    :ivar filters: A list of packet capture filters.
    :vartype filters: list[~azure.mgmt.network.models.PacketCaptureFilter]
    :ivar continuous_capture: This continuous capture is a nullable boolean, which can hold 'null',
     'true' or 'false' value. If we do not pass this parameter, it would be consider as 'null',
     default value is 'null'.
    :vartype continuous_capture: bool
    :ivar capture_settings: The capture setting holds the 'FileCount', 'FileSizeInBytes',
     'SessionTimeLimitInSeconds' values.
    :vartype capture_settings: ~azure.mgmt.network.models.PacketCaptureSettings
    """

    _validation = {
        "target": {"required": True},
        "bytes_to_capture_per_packet": {"maximum": 4294967295, "minimum": 0},
        "total_bytes_per_session": {"maximum": 4294967295, "minimum": 0},
        "time_limit_in_seconds": {"maximum": 18000, "minimum": 0},
        "storage_location": {"required": True},
    }

    _attribute_map = {
        "target": {"key": "properties.target", "type": "str"},
        "scope": {"key": "properties.scope", "type": "PacketCaptureMachineScope"},
        "target_type": {"key": "properties.targetType", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "properties.bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "properties.totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "properties.timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "properties.storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "properties.filters", "type": "[PacketCaptureFilter]"},
        "continuous_capture": {"key": "properties.continuousCapture", "type": "bool"},
        "capture_settings": {"key": "properties.captureSettings", "type": "PacketCaptureSettings"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        scope: Optional["_models.PacketCaptureMachineScope"] = None,
        target_type: Optional[Union[str, "_models.PacketCaptureTargetType"]] = None,
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        continuous_capture: Optional[bool] = None,
        capture_settings: Optional["_models.PacketCaptureSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are
         currently supported. Required.
        :paramtype target: str
        :keyword scope: A list of AzureVMSS instances which can be included or excluded to run packet
         capture. If both included and excluded are empty, then the packet capture will run on all
         instances of AzureVMSS.
        :paramtype scope: ~azure.mgmt.network.models.PacketCaptureMachineScope
        :keyword target_type: Target type of the resource provided. Known values are: "AzureVM" and
         "AzureVMSS".
        :paramtype target_type: str or ~azure.mgmt.network.models.PacketCaptureTargetType
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: The storage location for a packet capture session. Required.
        :paramtype storage_location:
         ~azure.mgmt.network.models.PacketCaptureStorageLocation
        :keyword filters: A list of packet capture filters.
        :paramtype filters: list[~azure.mgmt.network.models.PacketCaptureFilter]
        :keyword continuous_capture: This continuous capture is a nullable boolean, which can hold
         'null', 'true' or 'false' value. If we do not pass this parameter, it would be consider as
         'null', default value is 'null'.
        :paramtype continuous_capture: bool
        :keyword capture_settings: The capture setting holds the 'FileCount', 'FileSizeInBytes',
         'SessionTimeLimitInSeconds' values.
        :paramtype capture_settings: ~azure.mgmt.network.models.PacketCaptureSettings
        """
        super().__init__(**kwargs)
        self.target = target
        self.scope = scope
        self.target_type = target_type
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters
        self.continuous_capture = continuous_capture
        self.capture_settings = capture_settings

class PacketCaptureFilter(_serialization.Model):
    """Filter that is applied to packet capture request. Multiple filters can be applied.

    :ivar protocol: Protocol to be filtered on. Known values are: "TCP", "UDP", and "Any".
    :vartype protocol: str or ~azure.mgmt.network.models.PcProtocol
    :ivar local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :vartype local_ip_address: str
    :ivar remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
     address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
     supported. Default = null.
    :vartype remote_ip_address: str
    :ivar local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :vartype local_port: str
    :ivar remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85"
     for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
     ranges with multiple entries not currently supported. Default = null.
    :vartype remote_port: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "local_ip_address": {"key": "localIPAddress", "type": "str"},
        "remote_ip_address": {"key": "remoteIPAddress", "type": "str"},
        "local_port": {"key": "localPort", "type": "str"},
        "remote_port": {"key": "remotePort", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Union[str, "_models.PcProtocol"] = "Any",
        local_ip_address: Optional[str] = None,
        remote_ip_address: Optional[str] = None,
        local_port: Optional[str] = None,
        remote_port: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol: Protocol to be filtered on. Known values are: "TCP", "UDP", and "Any".
        :paramtype protocol: str or ~azure.mgmt.network.models.PcProtocol
        :keyword local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single
         address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries.
         Multiple ranges not currently supported. Mixing ranges with multiple entries not currently
         supported. Default = null.
        :paramtype local_ip_address: str
        :keyword remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for
         single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple
         entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not
         currently supported. Default = null.
        :paramtype remote_ip_address: str
        :keyword local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85"
         for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing
         ranges with multiple entries not currently supported. Default = null.
        :paramtype local_port: str
        :keyword remote_port: Remote port to be filtered on. Notation: "80" for single port
         entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently
         supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :paramtype remote_port: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.local_port = local_port
        self.remote_port = remote_port

class PacketCaptureListResult(_serialization.Model):
    """List of packet capture sessions.

    :ivar value: Information about packet capture sessions.
    :vartype value: list[~azure.mgmt.network.models.PacketCaptureResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PacketCaptureResult]"},
    }

    def __init__(self, *, value: Optional[List["_models.PacketCaptureResult"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Information about packet capture sessions.
        :paramtype value: list[~azure.mgmt.network.models.PacketCaptureResult]
        """
        super().__init__(**kwargs)
        self.value = value

class PacketCaptureParameters(_serialization.Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to server.

    :ivar target: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are
     currently supported. Required.
    :vartype target: str
    :ivar scope: A list of AzureVMSS instances which can be included or excluded to run packet
     capture. If both included and excluded are empty, then the packet capture will run on all
     instances of AzureVMSS.
    :vartype scope: ~azure.mgmt.network.models.PacketCaptureMachineScope
    :ivar target_type: Target type of the resource provided. Known values are: "AzureVM" and
     "AzureVMSS".
    :vartype target_type: str or ~azure.mgmt.network.models.PacketCaptureTargetType
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: The storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.models.PacketCaptureStorageLocation
    :ivar filters: A list of packet capture filters.
    :vartype filters: list[~azure.mgmt.network.models.PacketCaptureFilter]
    :ivar continuous_capture: This continuous capture is a nullable boolean, which can hold 'null',
     'true' or 'false' value. If we do not pass this parameter, it would be consider as 'null',
     default value is 'null'.
    :vartype continuous_capture: bool
    :ivar capture_settings: The capture setting holds the 'FileCount', 'FileSizeInBytes',
     'SessionTimeLimitInSeconds' values.
    :vartype capture_settings: ~azure.mgmt.network.models.PacketCaptureSettings
    """

    _validation = {
        "target": {"required": True},
        "bytes_to_capture_per_packet": {"maximum": 4294967295, "minimum": 0},
        "total_bytes_per_session": {"maximum": 4294967295, "minimum": 0},
        "time_limit_in_seconds": {"maximum": 18000, "minimum": 0},
        "storage_location": {"required": True},
    }

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
        "scope": {"key": "scope", "type": "PacketCaptureMachineScope"},
        "target_type": {"key": "targetType", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "filters", "type": "[PacketCaptureFilter]"},
        "continuous_capture": {"key": "continuousCapture", "type": "bool"},
        "capture_settings": {"key": "captureSettings", "type": "PacketCaptureSettings"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        scope: Optional["_models.PacketCaptureMachineScope"] = None,
        target_type: Optional[Union[str, "_models.PacketCaptureTargetType"]] = None,
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        continuous_capture: Optional[bool] = None,
        capture_settings: Optional["_models.PacketCaptureSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are
         currently supported. Required.
        :paramtype target: str
        :keyword scope: A list of AzureVMSS instances which can be included or excluded to run packet
         capture. If both included and excluded are empty, then the packet capture will run on all
         instances of AzureVMSS.
        :paramtype scope: ~azure.mgmt.network.models.PacketCaptureMachineScope
        :keyword target_type: Target type of the resource provided. Known values are: "AzureVM" and
         "AzureVMSS".
        :paramtype target_type: str or ~azure.mgmt.network.models.PacketCaptureTargetType
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: The storage location for a packet capture session. Required.
        :paramtype storage_location:
         ~azure.mgmt.network.models.PacketCaptureStorageLocation
        :keyword filters: A list of packet capture filters.
        :paramtype filters: list[~azure.mgmt.network.models.PacketCaptureFilter]
        :keyword continuous_capture: This continuous capture is a nullable boolean, which can hold
         'null', 'true' or 'false' value. If we do not pass this parameter, it would be consider as
         'null', default value is 'null'.
        :paramtype continuous_capture: bool
        :keyword capture_settings: The capture setting holds the 'FileCount', 'FileSizeInBytes',
         'SessionTimeLimitInSeconds' values.
        :paramtype capture_settings: ~azure.mgmt.network.models.PacketCaptureSettings
        """
        super().__init__(**kwargs)
        self.target = target
        self.scope = scope
        self.target_type = target_type
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters
        self.continuous_capture = continuous_capture
        self.capture_settings = capture_settings

class PacketCaptureQueryStatusResult(_serialization.Model):
    """Status of packet capture session.

    :ivar name: The name of the packet capture resource.
    :vartype name: str
    :ivar id: The ID of the packet capture resource.
    :vartype id: str
    :ivar capture_start_time: The start time of the packet capture session.
    :vartype capture_start_time: ~datetime.datetime
    :ivar packet_capture_status: The status of the packet capture session. Known values are:
     "NotStarted", "Running", "Stopped", "Error", and "Unknown".
    :vartype packet_capture_status: str or ~azure.mgmt.network.models.PcStatus
    :ivar stop_reason: The reason the current packet capture session was stopped.
    :vartype stop_reason: str
    :ivar packet_capture_error: List of errors of packet capture session.
    :vartype packet_capture_error: list[str or ~azure.mgmt.network.models.PcError]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "capture_start_time": {"key": "captureStartTime", "type": "iso-8601"},
        "packet_capture_status": {"key": "packetCaptureStatus", "type": "str"},
        "stop_reason": {"key": "stopReason", "type": "str"},
        "packet_capture_error": {"key": "packetCaptureError", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        capture_start_time: Optional[datetime.datetime] = None,
        packet_capture_status: Optional[Union[str, "_models.PcStatus"]] = None,
        stop_reason: Optional[str] = None,
        packet_capture_error: Optional[List[Union[str, "_models.PcError"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the packet capture resource.
        :paramtype name: str
        :keyword id: The ID of the packet capture resource.
        :paramtype id: str
        :keyword capture_start_time: The start time of the packet capture session.
        :paramtype capture_start_time: ~datetime.datetime
        :keyword packet_capture_status: The status of the packet capture session. Known values are:
         "NotStarted", "Running", "Stopped", "Error", and "Unknown".
        :paramtype packet_capture_status: str or ~azure.mgmt.network.models.PcStatus
        :keyword stop_reason: The reason the current packet capture session was stopped.
        :paramtype stop_reason: str
        :keyword packet_capture_error: List of errors of packet capture session.
        :paramtype packet_capture_error: list[str or ~azure.mgmt.network.models.PcError]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.capture_start_time = capture_start_time
        self.packet_capture_status = packet_capture_status
        self.stop_reason = stop_reason
        self.packet_capture_error = packet_capture_error

class PacketCaptureResult(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Information about packet capture session.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the packet capture session.
    :vartype name: str
    :ivar id: ID of the packet capture operation.
    :vartype id: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar target: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are
     currently supported.
    :vartype target: str
    :ivar scope: A list of AzureVMSS instances which can be included or excluded to run packet
     capture. If both included and excluded are empty, then the packet capture will run on all
     instances of AzureVMSS.
    :vartype scope: ~azure.mgmt.network.models.PacketCaptureMachineScope
    :ivar target_type: Target type of the resource provided. Known values are: "AzureVM" and
     "AzureVMSS".
    :vartype target_type: str or ~azure.mgmt.network.models.PacketCaptureTargetType
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: The storage location for a packet capture session.
    :vartype storage_location: ~azure.mgmt.network.models.PacketCaptureStorageLocation
    :ivar filters: A list of packet capture filters.
    :vartype filters: list[~azure.mgmt.network.models.PacketCaptureFilter]
    :ivar continuous_capture: This continuous capture is a nullable boolean, which can hold 'null',
     'true' or 'false' value. If we do not pass this parameter, it would be consider as 'null',
     default value is 'null'.
    :vartype continuous_capture: bool
    :ivar capture_settings: The capture setting holds the 'FileCount', 'FileSizeInBytes',
     'SessionTimeLimitInSeconds' values.
    :vartype capture_settings: ~azure.mgmt.network.models.PacketCaptureSettings
    :ivar provisioning_state: The provisioning state of the packet capture session. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "etag": {"readonly": True},
        "bytes_to_capture_per_packet": {"maximum": 4294967295, "minimum": 0},
        "total_bytes_per_session": {"maximum": 4294967295, "minimum": 0},
        "time_limit_in_seconds": {"maximum": 18000, "minimum": 0},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "target": {"key": "properties.target", "type": "str"},
        "scope": {"key": "properties.scope", "type": "PacketCaptureMachineScope"},
        "target_type": {"key": "properties.targetType", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "properties.bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "properties.totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "properties.timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "properties.storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "properties.filters", "type": "[PacketCaptureFilter]"},
        "continuous_capture": {"key": "properties.continuousCapture", "type": "bool"},
        "capture_settings": {"key": "properties.captureSettings", "type": "PacketCaptureSettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        target: Optional[str] = None,
        scope: Optional["_models.PacketCaptureMachineScope"] = None,
        target_type: Optional[Union[str, "_models.PacketCaptureTargetType"]] = None,
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        storage_location: Optional["_models.PacketCaptureStorageLocation"] = None,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        continuous_capture: Optional[bool] = None,
        capture_settings: Optional["_models.PacketCaptureSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are
         currently supported.
        :paramtype target: str
        :keyword scope: A list of AzureVMSS instances which can be included or excluded to run packet
         capture. If both included and excluded are empty, then the packet capture will run on all
         instances of AzureVMSS.
        :paramtype scope: ~azure.mgmt.network.models.PacketCaptureMachineScope
        :keyword target_type: Target type of the resource provided. Known values are: "AzureVM" and
         "AzureVMSS".
        :paramtype target_type: str or ~azure.mgmt.network.models.PacketCaptureTargetType
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: The storage location for a packet capture session.
        :paramtype storage_location:
         ~azure.mgmt.network.models.PacketCaptureStorageLocation
        :keyword filters: A list of packet capture filters.
        :paramtype filters: list[~azure.mgmt.network.models.PacketCaptureFilter]
        :keyword continuous_capture: This continuous capture is a nullable boolean, which can hold
         'null', 'true' or 'false' value. If we do not pass this parameter, it would be consider as
         'null', default value is 'null'.
        :paramtype continuous_capture: bool
        :keyword capture_settings: The capture setting holds the 'FileCount', 'FileSizeInBytes',
         'SessionTimeLimitInSeconds' values.
        :paramtype capture_settings: ~azure.mgmt.network.models.PacketCaptureSettings
        """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = None
        self.target = target
        self.scope = scope
        self.target_type = target_type
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters
        self.continuous_capture = continuous_capture
        self.capture_settings = capture_settings
        self.provisioning_state = None

class PacketCaptureResultProperties(PacketCaptureParameters):  # pylint: disable=too-many-instance-attributes
    """The properties of a packet capture session.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar target: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are
     currently supported. Required.
    :vartype target: str
    :ivar scope: A list of AzureVMSS instances which can be included or excluded to run packet
     capture. If both included and excluded are empty, then the packet capture will run on all
     instances of AzureVMSS.
    :vartype scope: ~azure.mgmt.network.models.PacketCaptureMachineScope
    :ivar target_type: Target type of the resource provided. Known values are: "AzureVM" and
     "AzureVMSS".
    :vartype target_type: str or ~azure.mgmt.network.models.PacketCaptureTargetType
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar storage_location: The storage location for a packet capture session. Required.
    :vartype storage_location: ~azure.mgmt.network.models.PacketCaptureStorageLocation
    :ivar filters: A list of packet capture filters.
    :vartype filters: list[~azure.mgmt.network.models.PacketCaptureFilter]
    :ivar continuous_capture: This continuous capture is a nullable boolean, which can hold 'null',
     'true' or 'false' value. If we do not pass this parameter, it would be consider as 'null',
     default value is 'null'.
    :vartype continuous_capture: bool
    :ivar capture_settings: The capture setting holds the 'FileCount', 'FileSizeInBytes',
     'SessionTimeLimitInSeconds' values.
    :vartype capture_settings: ~azure.mgmt.network.models.PacketCaptureSettings
    :ivar provisioning_state: The provisioning state of the packet capture session. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "target": {"required": True},
        "bytes_to_capture_per_packet": {"maximum": 4294967295, "minimum": 0},
        "total_bytes_per_session": {"maximum": 4294967295, "minimum": 0},
        "time_limit_in_seconds": {"maximum": 18000, "minimum": 0},
        "storage_location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "target": {"key": "target", "type": "str"},
        "scope": {"key": "scope", "type": "PacketCaptureMachineScope"},
        "target_type": {"key": "targetType", "type": "str"},
        "bytes_to_capture_per_packet": {"key": "bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "timeLimitInSeconds", "type": "int"},
        "storage_location": {"key": "storageLocation", "type": "PacketCaptureStorageLocation"},
        "filters": {"key": "filters", "type": "[PacketCaptureFilter]"},
        "continuous_capture": {"key": "continuousCapture", "type": "bool"},
        "capture_settings": {"key": "captureSettings", "type": "PacketCaptureSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        target: str,
        storage_location: "_models.PacketCaptureStorageLocation",
        scope: Optional["_models.PacketCaptureMachineScope"] = None,
        target_type: Optional[Union[str, "_models.PacketCaptureTargetType"]] = None,
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 1073741824,
        time_limit_in_seconds: int = 18000,
        filters: Optional[List["_models.PacketCaptureFilter"]] = None,
        continuous_capture: Optional[bool] = None,
        capture_settings: Optional["_models.PacketCaptureSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are
         currently supported. Required.
        :paramtype target: str
        :keyword scope: A list of AzureVMSS instances which can be included or excluded to run packet
         capture. If both included and excluded are empty, then the packet capture will run on all
         instances of AzureVMSS.
        :paramtype scope: ~azure.mgmt.network.models.PacketCaptureMachineScope
        :keyword target_type: Target type of the resource provided. Known values are: "AzureVM" and
         "AzureVMSS".
        :paramtype target_type: str or ~azure.mgmt.network.models.PacketCaptureTargetType
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        :keyword storage_location: The storage location for a packet capture session. Required.
        :paramtype storage_location:
         ~azure.mgmt.network.models.PacketCaptureStorageLocation
        :keyword filters: A list of packet capture filters.
        :paramtype filters: list[~azure.mgmt.network.models.PacketCaptureFilter]
        :keyword continuous_capture: This continuous capture is a nullable boolean, which can hold
         'null', 'true' or 'false' value. If we do not pass this parameter, it would be consider as
         'null', default value is 'null'.
        :paramtype continuous_capture: bool
        :keyword capture_settings: The capture setting holds the 'FileCount', 'FileSizeInBytes',
         'SessionTimeLimitInSeconds' values.
        :paramtype capture_settings: ~azure.mgmt.network.models.PacketCaptureSettings
        """
        super().__init__(
            target=target,
            scope=scope,
            target_type=target_type,
            bytes_to_capture_per_packet=bytes_to_capture_per_packet,
            total_bytes_per_session=total_bytes_per_session,
            time_limit_in_seconds=time_limit_in_seconds,
            storage_location=storage_location,
            filters=filters,
            continuous_capture=continuous_capture,
            capture_settings=capture_settings,
            **kwargs
        )
        self.provisioning_state = None

class PacketCaptureStorageLocation(_serialization.Model):
    """The storage location for a packet capture session.

    :ivar storage_id: The ID of the storage account to save the packet capture session. Required if
     no localPath or filePath is provided.
    :vartype storage_id: str
    :ivar storage_path: The URI of the storage path to save the packet capture. Must be a
     well-formed URI describing the location to save the packet capture.
    :vartype storage_path: str
    :ivar file_path: This path is invalid if 'Continuous Capture' is provided with 'true' or
     'false'. A valid local path on the targeting VM. Must include the name of the capture file
     (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID
     is provided, otherwise optional.
    :vartype file_path: str
    :ivar local_path: This path is valid if 'Continuous Capture' is provided with 'true' or 'false'
     and required if no storage ID is provided, otherwise optional. Must include the name of the
     capture file (*.cap). For linux virtual machine it must start with /var/captures.
    :vartype local_path: str
    """

    _attribute_map = {
        "storage_id": {"key": "storageId", "type": "str"},
        "storage_path": {"key": "storagePath", "type": "str"},
        "file_path": {"key": "filePath", "type": "str"},
        "local_path": {"key": "localPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_id: Optional[str] = None,
        storage_path: Optional[str] = None,
        file_path: Optional[str] = None,
        local_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_id: The ID of the storage account to save the packet capture session. Required
         if no localPath or filePath is provided.
        :paramtype storage_id: str
        :keyword storage_path: The URI of the storage path to save the packet capture. Must be a
         well-formed URI describing the location to save the packet capture.
        :paramtype storage_path: str
        :keyword file_path: This path is invalid if 'Continuous Capture' is provided with 'true' or
         'false'. A valid local path on the targeting VM. Must include the name of the capture file
         (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID
         is provided, otherwise optional.
        :paramtype file_path: str
        :keyword local_path: This path is valid if 'Continuous Capture' is provided with 'true' or
         'false' and required if no storage ID is provided, otherwise optional. Must include the name of
         the capture file (*.cap). For linux virtual machine it must start with /var/captures.
        :paramtype local_path: str
        """
        super().__init__(**kwargs)
        self.storage_id = storage_id
        self.storage_path = storage_path
        self.file_path = file_path
        self.local_path = local_path

class PatchRouteFilter(SubResource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar rules: Collection of RouteFilterRules contained within a route filter.
    :vartype rules: list[~azure.mgmt.network.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit peerings.
    :vartype peerings: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
    :ivar ipv6_peerings: A collection of references to express route circuit ipv6 peerings.
    :vartype ipv6_peerings: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the route filter resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "peerings": {"readonly": True},
        "ipv6_peerings": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "rules": {"key": "properties.rules", "type": "[RouteFilterRule]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "ipv6_peerings": {"key": "properties.ipv6Peerings", "type": "[ExpressRouteCircuitPeering]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        rules: Optional[List["_models.RouteFilterRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rules: Collection of RouteFilterRules contained within a route filter.
        :paramtype rules: list[~azure.mgmt.network.models.RouteFilterRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.etag = None
        self.type = None
        self.tags = tags
        self.rules = rules
        self.peerings = None
        self.ipv6_peerings = None
        self.provisioning_state = None

class PatchRouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar access: The access type of the rule. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.models.Access
    :ivar route_filter_rule_type: The rule type of the rule. "Community"
    :vartype route_filter_rule_type: str or
     ~azure.mgmt.network.models.RouteFilterRuleType
    :ivar communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :vartype communities: list[str]
    :ivar provisioning_state: The provisioning state of the route filter rule resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "access": {"key": "properties.access", "type": "str"},
        "route_filter_rule_type": {"key": "properties.routeFilterRuleType", "type": "str"},
        "communities": {"key": "properties.communities", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        access: Optional[Union[str, "_models.Access"]] = None,
        route_filter_rule_type: Optional[Union[str, "_models.RouteFilterRuleType"]] = None,
        communities: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword access: The access type of the rule. Known values are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.models.Access
        :keyword route_filter_rule_type: The rule type of the rule. "Community"
        :paramtype route_filter_rule_type: str or
         ~azure.mgmt.network.models.RouteFilterRuleType
        :keyword communities: The collection for bgp community values to filter on. e.g.
         ['12076:5010','12076:5020'].
        :paramtype communities: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = None
        self.etag = None
        self.access = access
        self.route_filter_rule_type = route_filter_rule_type
        self.communities = communities
        self.provisioning_state = None

class PublicIPAddressSku(_serialization.Model):
    """SKU of a public IP address.

    :ivar name: Name of a public IP address SKU. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.network.models.PublicIPAddressSkuName
    :ivar tier: Tier of a public IP address SKU. Known values are: "Regional", "Global", and
     "Global".
    :vartype tier: str or ~azure.mgmt.network.models.PublicIPAddressSkuTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.PublicIPAddressSkuName"]] = None,
        tier: Optional[Union[str, "_models.PublicIPAddressSkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of a public IP address SKU. Known values are: "Basic" and "Standard".
        :paramtype name: str or ~azure.mgmt.network.models.PublicIPAddressSkuName
        :keyword tier: Tier of a public IP address SKU. Known values are: "Regional", "Global", and
         "Global".
        :paramtype tier: str or ~azure.mgmt.network.models.PublicIPAddressSkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier

class QueryTroubleshootingParameters(_serialization.Model):
    """Parameters that define the resource to query the troubleshooting result.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The target resource ID to query the troubleshooting result. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs: Any) -> None:
        """
        :keyword target_resource_id: The target resource ID to query the troubleshooting result.
         Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id

class ResourceNavigationLink(SubResource):
    """ResourceNavigationLink resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar linked_resource_type: Resource type of the linked resource.
    :vartype linked_resource_type: str
    :ivar link: Link to the external resource.
    :vartype link: str
    :ivar provisioning_state: The provisioning state of the resource navigation link resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "linked_resource_type": {"key": "properties.linkedResourceType", "type": "str"},
        "link": {"key": "properties.link", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        linked_resource_type: Optional[str] = None,
        link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword linked_resource_type: Resource type of the linked resource.
        :paramtype linked_resource_type: str
        :keyword link: Link to the external resource.
        :paramtype link: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.linked_resource_type = linked_resource_type
        self.link = link
        self.provisioning_state = None

class RetentionPolicyParameters(_serialization.Model):
    """Parameters that define the retention policy for flow log.

    :ivar days: Number of days to retain flow log records.
    :vartype days: int
    :ivar enabled: Flag to enable/disable retention.
    :vartype enabled: bool
    """

    _attribute_map = {
        "days": {"key": "days", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, days: int = 0, enabled: bool = False, **kwargs: Any) -> None:
        """
        :keyword days: Number of days to retain flow log records.
        :paramtype days: int
        :keyword enabled: Flag to enable/disable retention.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.days = days
        self.enabled = enabled

class RouteFilter(Resource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rules: Collection of RouteFilterRules contained within a route filter.
    :vartype rules: list[~azure.mgmt.network.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit peerings.
    :vartype peerings: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
    :ivar ipv6_peerings: A collection of references to express route circuit ipv6 peerings.
    :vartype ipv6_peerings: list[~azure.mgmt.network.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the route filter resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "peerings": {"readonly": True},
        "ipv6_peerings": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "rules": {"key": "properties.rules", "type": "[RouteFilterRule]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "ipv6_peerings": {"key": "properties.ipv6Peerings", "type": "[ExpressRouteCircuitPeering]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        rules: Optional[List["_models.RouteFilterRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword rules: Collection of RouteFilterRules contained within a route filter.
        :paramtype rules: list[~azure.mgmt.network.models.RouteFilterRule]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.rules = rules
        self.peerings = None
        self.ipv6_peerings = None
        self.provisioning_state = None

class RouteFilterListResult(_serialization.Model):
    """Response for the ListRouteFilters API service call.

    :ivar value: A list of route filters in a resource group.
    :vartype value: list[~azure.mgmt.network.models.RouteFilter]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteFilter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteFilter"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of route filters in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.RouteFilter]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class RouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar access: The access type of the rule. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.models.Access
    :ivar route_filter_rule_type: The rule type of the rule. "Community"
    :vartype route_filter_rule_type: str or
     ~azure.mgmt.network.models.RouteFilterRuleType
    :ivar communities: The collection for bgp community values to filter on. e.g.
     ['12076:5010','12076:5020'].
    :vartype communities: list[str]
    :ivar provisioning_state: The provisioning state of the route filter rule resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "access": {"key": "properties.access", "type": "str"},
        "route_filter_rule_type": {"key": "properties.routeFilterRuleType", "type": "str"},
        "communities": {"key": "properties.communities", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        location: Optional[str] = None,
        access: Optional[Union[str, "_models.Access"]] = None,
        route_filter_rule_type: Optional[Union[str, "_models.RouteFilterRuleType"]] = None,
        communities: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword access: The access type of the rule. Known values are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.models.Access
        :keyword route_filter_rule_type: The rule type of the rule. "Community"
        :paramtype route_filter_rule_type: str or
         ~azure.mgmt.network.models.RouteFilterRuleType
        :keyword communities: The collection for bgp community values to filter on. e.g.
         ['12076:5010','12076:5020'].
        :paramtype communities: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.etag = None
        self.access = access
        self.route_filter_rule_type = route_filter_rule_type
        self.communities = communities
        self.provisioning_state = None

class RouteFilterRuleListResult(_serialization.Model):
    """Response for the ListRouteFilterRules API service call.

    :ivar value: A list of RouteFilterRules in a resource group.
    :vartype value: list[~azure.mgmt.network.models.RouteFilterRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteFilterRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteFilterRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of RouteFilterRules in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.RouteFilterRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class SecurityGroupNetworkInterface(_serialization.Model):
    """Network interface and all its associated security rules.

    :ivar id: ID of the network interface.
    :vartype id: str
    :ivar security_rule_associations: All security rules associated with the network interface.
    :vartype security_rule_associations:
     ~azure.mgmt.network.models.SecurityRuleAssociations
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rule_associations": {"key": "securityRuleAssociations", "type": "SecurityRuleAssociations"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        security_rule_associations: Optional["_models.SecurityRuleAssociations"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: ID of the network interface.
        :paramtype id: str
        :keyword security_rule_associations: All security rules associated with the network interface.
        :paramtype security_rule_associations:
         ~azure.mgmt.network.models.SecurityRuleAssociations
        """
        super().__init__(**kwargs)
        self.id = id
        self.security_rule_associations = security_rule_associations

class SecurityGroupViewParameters(_serialization.Model):
    """Parameters that define the VM to check security groups for.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: ID of the target VM. Required.
    :vartype target_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, **kwargs: Any) -> None:
        """
        :keyword target_resource_id: ID of the target VM. Required.
        :paramtype target_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id

class SecurityGroupViewResult(_serialization.Model):
    """The information about security rules applied to the specified VM.

    :ivar network_interfaces: List of network interfaces on the specified VM.
    :vartype network_interfaces:
     list[~azure.mgmt.network.models.SecurityGroupNetworkInterface]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[SecurityGroupNetworkInterface]"},
    }

    def __init__(
        self, *, network_interfaces: Optional[List["_models.SecurityGroupNetworkInterface"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: List of network interfaces on the specified VM.
        :paramtype network_interfaces:
         list[~azure.mgmt.network.models.SecurityGroupNetworkInterface]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces

class SecurityRuleAssociations(_serialization.Model):
    """All security rules associated with the network interface.

    :ivar network_interface_association: Network interface and it's custom security rules.
    :vartype network_interface_association:
     ~azure.mgmt.network.models.NetworkInterfaceAssociation
    :ivar subnet_association: Subnet and it's custom security rules.
    :vartype subnet_association: ~azure.mgmt.network.models.SubnetAssociation
    :ivar default_security_rules: Collection of default security rules of the network security
     group.
    :vartype default_security_rules: list[~azure.mgmt.network.models.SecurityRule]
    :ivar effective_security_rules: Collection of effective security rules.
    :vartype effective_security_rules:
     list[~azure.mgmt.network.models.EffectiveNetworkSecurityRule]
    """

    _attribute_map = {
        "network_interface_association": {"key": "networkInterfaceAssociation", "type": "NetworkInterfaceAssociation"},
        "subnet_association": {"key": "subnetAssociation", "type": "SubnetAssociation"},
        "default_security_rules": {"key": "defaultSecurityRules", "type": "[SecurityRule]"},
        "effective_security_rules": {"key": "effectiveSecurityRules", "type": "[EffectiveNetworkSecurityRule]"},
    }

    def __init__(
        self,
        *,
        network_interface_association: Optional["_models.NetworkInterfaceAssociation"] = None,
        subnet_association: Optional["_models.SubnetAssociation"] = None,
        default_security_rules: Optional[List["_models.SecurityRule"]] = None,
        effective_security_rules: Optional[List["_models.EffectiveNetworkSecurityRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interface_association: Network interface and it's custom security rules.
        :paramtype network_interface_association:
         ~azure.mgmt.network.models.NetworkInterfaceAssociation
        :keyword subnet_association: Subnet and it's custom security rules.
        :paramtype subnet_association: ~azure.mgmt.network.models.SubnetAssociation
        :keyword default_security_rules: Collection of default security rules of the network security
         group.
        :paramtype default_security_rules: list[~azure.mgmt.network.models.SecurityRule]
        :keyword effective_security_rules: Collection of effective security rules.
        :paramtype effective_security_rules:
         list[~azure.mgmt.network.models.EffectiveNetworkSecurityRule]
        """
        super().__init__(**kwargs)
        self.network_interface_association = network_interface_association
        self.subnet_association = subnet_association
        self.default_security_rules = default_security_rules
        self.effective_security_rules = effective_security_rules

class ServiceEndpointPropertiesFormat(_serialization.Model):
    """The service endpoint properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service: The type of the endpoint service.
    :vartype service: str
    :ivar network_identifier: SubResource as network identifier.
    :vartype network_identifier: ~azure.mgmt.network.models.SubResource
    :ivar locations: A list of locations.
    :vartype locations: list[str]
    :ivar provisioning_state: The provisioning state of the service endpoint resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "service": {"key": "service", "type": "str"},
        "network_identifier": {"key": "networkIdentifier", "type": "SubResource"},
        "locations": {"key": "locations", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        service: Optional[str] = None,
        network_identifier: Optional["_models.SubResource"] = None,
        locations: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service: The type of the endpoint service.
        :paramtype service: str
        :keyword network_identifier: SubResource as network identifier.
        :paramtype network_identifier: ~azure.mgmt.network.models.SubResource
        :keyword locations: A list of locations.
        :paramtype locations: list[str]
        """
        super().__init__(**kwargs)
        self.service = service
        self.network_identifier = network_identifier
        self.locations = locations
        self.provisioning_state = None

class SubnetAssociation(_serialization.Model):
    """Subnet and it's custom security rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Subnet ID.
    :vartype id: str
    :ivar security_rules: Collection of custom security rules.
    :vartype security_rules: list[~azure.mgmt.network.models.SecurityRule]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "security_rules": {"key": "securityRules", "type": "[SecurityRule]"},
    }

    def __init__(self, *, security_rules: Optional[List["_models.SecurityRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword security_rules: Collection of custom security rules.
        :paramtype security_rules: list[~azure.mgmt.network.models.SecurityRule]
        """
        super().__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules

class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags

class Topology(_serialization.Model):
    """Topology of the specified resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: GUID representing the operation id.
    :vartype id: str
    :ivar created_date_time: The datetime when the topology was initially created for the resource
     group.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_modified: The datetime when the topology was last modified.
    :vartype last_modified: ~datetime.datetime
    :ivar resources: A list of topology resources.
    :vartype resources: list[~azure.mgmt.network.models.TopologyResource]
    """

    _validation = {
        "id": {"readonly": True},
        "created_date_time": {"readonly": True},
        "last_modified": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "last_modified": {"key": "lastModified", "type": "iso-8601"},
        "resources": {"key": "resources", "type": "[TopologyResource]"},
    }

    def __init__(self, *, resources: Optional[List["_models.TopologyResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword resources: A list of topology resources.
        :paramtype resources: list[~azure.mgmt.network.models.TopologyResource]
        """
        super().__init__(**kwargs)
        self.id = None
        self.created_date_time = None
        self.last_modified = None
        self.resources = resources

class TopologyAssociation(_serialization.Model):
    """Resources that have an association with the parent resource.

    :ivar name: The name of the resource that is associated with the parent resource.
    :vartype name: str
    :ivar resource_id: The ID of the resource that is associated with the parent resource.
    :vartype resource_id: str
    :ivar association_type: The association type of the child resource to the parent resource.
     Known values are: "Associated" and "Contains".
    :vartype association_type: str or ~azure.mgmt.network.models.AssociationType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "association_type": {"key": "associationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        resource_id: Optional[str] = None,
        association_type: Optional[Union[str, "_models.AssociationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the resource that is associated with the parent resource.
        :paramtype name: str
        :keyword resource_id: The ID of the resource that is associated with the parent resource.
        :paramtype resource_id: str
        :keyword association_type: The association type of the child resource to the parent resource.
         Known values are: "Associated" and "Contains".
        :paramtype association_type: str or ~azure.mgmt.network.models.AssociationType
        """
        super().__init__(**kwargs)
        self.name = name
        self.resource_id = resource_id
        self.association_type = association_type

class TopologyParameters(_serialization.Model):
    """Parameters that define the representation of topology.

    :ivar target_resource_group_name: The name of the target resource group to perform topology on.
    :vartype target_resource_group_name: str
    :ivar target_virtual_network: The reference to the Virtual Network resource.
    :vartype target_virtual_network: ~azure.mgmt.network.models.SubResource
    :ivar target_subnet: The reference to the Subnet resource.
    :vartype target_subnet: ~azure.mgmt.network.models.SubResource
    """

    _attribute_map = {
        "target_resource_group_name": {"key": "targetResourceGroupName", "type": "str"},
        "target_virtual_network": {"key": "targetVirtualNetwork", "type": "SubResource"},
        "target_subnet": {"key": "targetSubnet", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        target_resource_group_name: Optional[str] = None,
        target_virtual_network: Optional["_models.SubResource"] = None,
        target_subnet: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_group_name: The name of the target resource group to perform topology
         on.
        :paramtype target_resource_group_name: str
        :keyword target_virtual_network: The reference to the Virtual Network resource.
        :paramtype target_virtual_network: ~azure.mgmt.network.models.SubResource
        :keyword target_subnet: The reference to the Subnet resource.
        :paramtype target_subnet: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(**kwargs)
        self.target_resource_group_name = target_resource_group_name
        self.target_virtual_network = target_virtual_network
        self.target_subnet = target_subnet

class TopologyResource(_serialization.Model):
    """The network resource topology information for the given resource group.

    :ivar name: Name of the resource.
    :vartype name: str
    :ivar id: ID of the resource.
    :vartype id: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar associations: Holds the associations the resource has with other resources in the
     resource group.
    :vartype associations: list[~azure.mgmt.network.models.TopologyAssociation]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "associations": {"key": "associations", "type": "[TopologyAssociation]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        associations: Optional[List["_models.TopologyAssociation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword id: ID of the resource.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword associations: Holds the associations the resource has with other resources in the
         resource group.
        :paramtype associations: list[~azure.mgmt.network.models.TopologyAssociation]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.location = location
        self.associations = associations

class TroubleshootingDetails(_serialization.Model):
    """Information gained from troubleshooting of specified resource.

    :ivar id: The id of the get troubleshoot operation.
    :vartype id: str
    :ivar reason_type: Reason type of failure.
    :vartype reason_type: str
    :ivar summary: A summary of troubleshooting.
    :vartype summary: str
    :ivar detail: Details on troubleshooting results.
    :vartype detail: str
    :ivar recommended_actions: List of recommended actions.
    :vartype recommended_actions:
     list[~azure.mgmt.network.models.TroubleshootingRecommendedActions]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "reason_type": {"key": "reasonType", "type": "str"},
        "summary": {"key": "summary", "type": "str"},
        "detail": {"key": "detail", "type": "str"},
        "recommended_actions": {"key": "recommendedActions", "type": "[TroubleshootingRecommendedActions]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        reason_type: Optional[str] = None,
        summary: Optional[str] = None,
        detail: Optional[str] = None,
        recommended_actions: Optional[List["_models.TroubleshootingRecommendedActions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id of the get troubleshoot operation.
        :paramtype id: str
        :keyword reason_type: Reason type of failure.
        :paramtype reason_type: str
        :keyword summary: A summary of troubleshooting.
        :paramtype summary: str
        :keyword detail: Details on troubleshooting results.
        :paramtype detail: str
        :keyword recommended_actions: List of recommended actions.
        :paramtype recommended_actions:
         list[~azure.mgmt.network.models.TroubleshootingRecommendedActions]
        """
        super().__init__(**kwargs)
        self.id = id
        self.reason_type = reason_type
        self.summary = summary
        self.detail = detail
        self.recommended_actions = recommended_actions

class TroubleshootingParameters(_serialization.Model):
    """Parameters that define the resource to troubleshoot.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The target resource to troubleshoot. Required.
    :vartype target_resource_id: str
    :ivar storage_id: The ID for the storage account to save the troubleshoot result. Required.
    :vartype storage_id: str
    :ivar storage_path: The path to the blob to save the troubleshoot result in. Required.
    :vartype storage_path: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "storage_id": {"required": True},
        "storage_path": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "storage_id": {"key": "properties.storageId", "type": "str"},
        "storage_path": {"key": "properties.storagePath", "type": "str"},
    }

    def __init__(self, *, target_resource_id: str, storage_id: str, storage_path: str, **kwargs: Any) -> None:
        """
        :keyword target_resource_id: The target resource to troubleshoot. Required.
        :paramtype target_resource_id: str
        :keyword storage_id: The ID for the storage account to save the troubleshoot result. Required.
        :paramtype storage_id: str
        :keyword storage_path: The path to the blob to save the troubleshoot result in. Required.
        :paramtype storage_path: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.storage_id = storage_id
        self.storage_path = storage_path

class TroubleshootingRecommendedActions(_serialization.Model):
    """Recommended actions based on discovered issues.

    :ivar action_id: ID of the recommended action.
    :vartype action_id: str
    :ivar action_text: Description of recommended actions.
    :vartype action_text: str
    :ivar action_uri: The uri linking to a documentation for the recommended troubleshooting
     actions.
    :vartype action_uri: str
    :ivar action_uri_text: The information from the URI for the recommended troubleshooting
     actions.
    :vartype action_uri_text: str
    """

    _attribute_map = {
        "action_id": {"key": "actionId", "type": "str"},
        "action_text": {"key": "actionText", "type": "str"},
        "action_uri": {"key": "actionUri", "type": "str"},
        "action_uri_text": {"key": "actionUriText", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_id: Optional[str] = None,
        action_text: Optional[str] = None,
        action_uri: Optional[str] = None,
        action_uri_text: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_id: ID of the recommended action.
        :paramtype action_id: str
        :keyword action_text: Description of recommended actions.
        :paramtype action_text: str
        :keyword action_uri: The uri linking to a documentation for the recommended troubleshooting
         actions.
        :paramtype action_uri: str
        :keyword action_uri_text: The information from the URI for the recommended troubleshooting
         actions.
        :paramtype action_uri_text: str
        """
        super().__init__(**kwargs)
        self.action_id = action_id
        self.action_text = action_text
        self.action_uri = action_uri
        self.action_uri_text = action_uri_text

class TroubleshootingResult(_serialization.Model):
    """Troubleshooting information gained from specified resource.

    :ivar start_time: The start time of the troubleshooting.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the troubleshooting.
    :vartype end_time: ~datetime.datetime
    :ivar code: The result code of the troubleshooting.
    :vartype code: str
    :ivar results: Information from troubleshooting.
    :vartype results: list[~azure.mgmt.network.models.TroubleshootingDetails]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "code": {"key": "code", "type": "str"},
        "results": {"key": "results", "type": "[TroubleshootingDetails]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        code: Optional[str] = None,
        results: Optional[List["_models.TroubleshootingDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: The start time of the troubleshooting.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the troubleshooting.
        :paramtype end_time: ~datetime.datetime
        :keyword code: The result code of the troubleshooting.
        :paramtype code: str
        :keyword results: Information from troubleshooting.
        :paramtype results: list[~azure.mgmt.network.models.TroubleshootingDetails]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.code = code
        self.results = results

class TunnelConnectionHealth(_serialization.Model):
    """VirtualNetworkGatewayConnection properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tunnel: Tunnel name.
    :vartype tunnel: str
    :ivar connection_status: Virtual Network Gateway connection status. Known values are:
     "Unknown", "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionStatus
    :ivar ingress_bytes_transferred: The Ingress Bytes Transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar egress_bytes_transferred: The Egress Bytes Transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar last_connection_established_utc_time: The time at which connection was established in Utc
     format.
    :vartype last_connection_established_utc_time: str
    """

    _validation = {
        "tunnel": {"readonly": True},
        "connection_status": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "last_connection_established_utc_time": {"readonly": True},
    }

    _attribute_map = {
        "tunnel": {"key": "tunnel", "type": "str"},
        "connection_status": {"key": "connectionStatus", "type": "str"},
        "ingress_bytes_transferred": {"key": "ingressBytesTransferred", "type": "int"},
        "egress_bytes_transferred": {"key": "egressBytesTransferred", "type": "int"},
        "last_connection_established_utc_time": {"key": "lastConnectionEstablishedUtcTime", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.tunnel = None
        self.connection_status = None
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.last_connection_established_utc_time = None

class VerificationIPFlowParameters(_serialization.Model):
    """Parameters that define the IP flow to be verified.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The ID of the target resource to perform next-hop on. Required.
    :vartype target_resource_id: str
    :ivar direction: The direction of the packet represented as a 5-tuple. Required. Known values
     are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.Direction
    :ivar protocol: Protocol to be verified on. Required. Known values are: "TCP" and "UDP".
    :vartype protocol: str or ~azure.mgmt.network.models.IpFlowProtocol
    :ivar local_port: The local port. Acceptable values are a single integer in the range
     (0-65535). Support for * for the source port, which depends on the direction. Required.
    :vartype local_port: str
    :ivar remote_port: The remote port. Acceptable values are a single integer in the range
     (0-65535). Support for * for the source port, which depends on the direction. Required.
    :vartype remote_port: str
    :ivar local_ip_address: The local IP address. Acceptable values are valid IPv4 addresses.
     Required.
    :vartype local_ip_address: str
    :ivar remote_ip_address: The remote IP address. Acceptable values are valid IPv4 addresses.
     Required.
    :vartype remote_ip_address: str
    :ivar target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is enabled
     on any of them, then this parameter must be specified. Otherwise optional).
    :vartype target_nic_resource_id: str
    """

    _validation = {
        "target_resource_id": {"required": True},
        "direction": {"required": True},
        "protocol": {"required": True},
        "local_port": {"required": True},
        "remote_port": {"required": True},
        "local_ip_address": {"required": True},
        "remote_ip_address": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "direction": {"key": "direction", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "local_port": {"key": "localPort", "type": "str"},
        "remote_port": {"key": "remotePort", "type": "str"},
        "local_ip_address": {"key": "localIPAddress", "type": "str"},
        "remote_ip_address": {"key": "remoteIPAddress", "type": "str"},
        "target_nic_resource_id": {"key": "targetNicResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        direction: Union[str, "_models.Direction"],
        protocol: Union[str, "_models.IpFlowProtocol"],
        local_port: str,
        remote_port: str,
        local_ip_address: str,
        remote_ip_address: str,
        target_nic_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_id: The ID of the target resource to perform next-hop on. Required.
        :paramtype target_resource_id: str
        :keyword direction: The direction of the packet represented as a 5-tuple. Required. Known
         values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.models.Direction
        :keyword protocol: Protocol to be verified on. Required. Known values are: "TCP" and "UDP".
        :paramtype protocol: str or ~azure.mgmt.network.models.IpFlowProtocol
        :keyword local_port: The local port. Acceptable values are a single integer in the range
         (0-65535). Support for * for the source port, which depends on the direction. Required.
        :paramtype local_port: str
        :keyword remote_port: The remote port. Acceptable values are a single integer in the range
         (0-65535). Support for * for the source port, which depends on the direction. Required.
        :paramtype remote_port: str
        :keyword local_ip_address: The local IP address. Acceptable values are valid IPv4 addresses.
         Required.
        :paramtype local_ip_address: str
        :keyword remote_ip_address: The remote IP address. Acceptable values are valid IPv4 addresses.
         Required.
        :paramtype remote_ip_address: str
        :keyword target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP forwarding is
         enabled on any of them, then this parameter must be specified. Otherwise optional).
        :paramtype target_nic_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.direction = direction
        self.protocol = protocol
        self.local_port = local_port
        self.remote_port = remote_port
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.target_nic_resource_id = target_nic_resource_id

class VerificationIPFlowResult(_serialization.Model):
    """Results of IP flow verification on the target resource.

    :ivar access: Indicates whether the traffic is allowed or denied. Known values are: "Allow" and
     "Deny".
    :vartype access: str or ~azure.mgmt.network.models.Access
    :ivar rule_name: Name of the rule. If input is not matched against any security rule, it is not
     displayed.
    :vartype rule_name: str
    """

    _attribute_map = {
        "access": {"key": "access", "type": "str"},
        "rule_name": {"key": "ruleName", "type": "str"},
    }

    def __init__(
        self, *, access: Optional[Union[str, "_models.Access"]] = None, rule_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword access: Indicates whether the traffic is allowed or denied. Known values are: "Allow"
         and "Deny".
        :paramtype access: str or ~azure.mgmt.network.models.Access
        :keyword rule_name: Name of the rule. If input is not matched against any security rule, it is
         not displayed.
        :paramtype rule_name: str
        """
        super().__init__(**kwargs)
        self.access = access
        self.rule_name = rule_name

class VirtualNetworkConnectionGatewayReference(_serialization.Model):
    """A reference to VirtualNetworkGateway or LocalNetworkGateway resource.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of VirtualNetworkGateway or LocalNetworkGateway resource. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of VirtualNetworkGateway or LocalNetworkGateway resource. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class VirtualNetworkGatewayConnectionListEntity(Resource):  # pylint: disable=too-many-instance-attributes,name-too-long
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar virtual_network_gateway1: The reference to virtual network gateway resource. Required.
    :vartype virtual_network_gateway1:
     ~azure.mgmt.network.models.VirtualNetworkConnectionGatewayReference
    :ivar virtual_network_gateway2: The reference to virtual network gateway resource.
    :vartype virtual_network_gateway2:
     ~azure.mgmt.network.models.VirtualNetworkConnectionGatewayReference
    :ivar local_network_gateway2: The reference to local network gateway resource.
    :vartype local_network_gateway2:
     ~azure.mgmt.network.models.VirtualNetworkConnectionGatewayReference
    :ivar connection_type: Gateway connection type. Required. Known values are: "IPsec",
     "Vnet2Vnet", "ExpressRoute", and "VPNClient".
    :vartype connection_type: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionType
    :ivar connection_protocol: Connection protocol used for this connection. Known values are:
     "IKEv2" and "IKEv1".
    :vartype connection_protocol: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionProtocol
    :ivar routing_weight: The routing weight.
    :vartype routing_weight: int
    :ivar connection_mode: The connection mode for this connection. Known values are: "Default",
     "ResponderOnly", and "InitiatorOnly".
    :vartype connection_mode: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionMode
    :ivar shared_key: The IPSec shared key.
    :vartype shared_key: str
    :ivar connection_status: Virtual Network Gateway connection status. Known values are:
     "Unknown", "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar peer: The reference to peerings resource.
    :vartype peer: ~azure.mgmt.network.models.SubResource
    :ivar enable_bgp: EnableBgp flag.
    :vartype enable_bgp: bool
    :ivar gateway_custom_bgp_ip_addresses: GatewayCustomBgpIpAddresses to be used for virtual
     network gateway Connection.
    :vartype gateway_custom_bgp_ip_addresses:
     list[~azure.mgmt.network.models.GatewayCustomBgpIpAddressIpConfiguration]
    :ivar use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :vartype use_policy_based_traffic_selectors: bool
    :ivar ipsec_policies: The IPSec Policies to be considered by this connection.
    :vartype ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
    :ivar traffic_selector_policies: The Traffic Selector Policies to be considered by this
     connection.
    :vartype traffic_selector_policies:
     list[~azure.mgmt.network.models.TrafficSelectorPolicy]
    :ivar resource_guid: The resource GUID property of the virtual network gateway connection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network gateway connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
    :vartype express_route_gateway_bypass: bool
    :ivar enable_private_link_fast_path: Bypass the ExpressRoute gateway when accessing
     private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
    :vartype enable_private_link_fast_path: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "virtual_network_gateway1": {"required": True},
        "connection_type": {"required": True},
        "connection_status": {"readonly": True},
        "tunnel_connection_status": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "virtual_network_gateway1": {
            "key": "properties.virtualNetworkGateway1",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "virtual_network_gateway2": {
            "key": "properties.virtualNetworkGateway2",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "local_network_gateway2": {
            "key": "properties.localNetworkGateway2",
            "type": "VirtualNetworkConnectionGatewayReference",
        },
        "connection_type": {"key": "properties.connectionType", "type": "str"},
        "connection_protocol": {"key": "properties.connectionProtocol", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "connection_mode": {"key": "properties.connectionMode", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "tunnel_connection_status": {"key": "properties.tunnelConnectionStatus", "type": "[TunnelConnectionHealth]"},
        "egress_bytes_transferred": {"key": "properties.egressBytesTransferred", "type": "int"},
        "ingress_bytes_transferred": {"key": "properties.ingressBytesTransferred", "type": "int"},
        "peer": {"key": "properties.peer", "type": "SubResource"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "gateway_custom_bgp_ip_addresses": {
            "key": "properties.gatewayCustomBgpIpAddresses",
            "type": "[GatewayCustomBgpIpAddressIpConfiguration]",
        },
        "use_policy_based_traffic_selectors": {"key": "properties.usePolicyBasedTrafficSelectors", "type": "bool"},
        "ipsec_policies": {"key": "properties.ipsecPolicies", "type": "[IpsecPolicy]"},
        "traffic_selector_policies": {"key": "properties.trafficSelectorPolicies", "type": "[TrafficSelectorPolicy]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "express_route_gateway_bypass": {"key": "properties.expressRouteGatewayBypass", "type": "bool"},
        "enable_private_link_fast_path": {"key": "properties.enablePrivateLinkFastPath", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        virtual_network_gateway1: "_models.VirtualNetworkConnectionGatewayReference",
        connection_type: Union[str, "_models.VirtualNetworkGatewayConnectionType"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway2: Optional["_models.VirtualNetworkConnectionGatewayReference"] = None,
        local_network_gateway2: Optional["_models.VirtualNetworkConnectionGatewayReference"] = None,
        connection_protocol: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionProtocol"]] = None,
        routing_weight: Optional[int] = None,
        connection_mode: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionMode"]] = None,
        shared_key: Optional[str] = None,
        peer: Optional["_models.SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        gateway_custom_bgp_ip_addresses: Optional[List["_models.GatewayCustomBgpIpAddressIpConfiguration"]] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        traffic_selector_policies: Optional[List["_models.TrafficSelectorPolicy"]] = None,
        express_route_gateway_bypass: Optional[bool] = None,
        enable_private_link_fast_path: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword virtual_network_gateway1: The reference to virtual network gateway resource. Required.
        :paramtype virtual_network_gateway1:
         ~azure.mgmt.network.models.VirtualNetworkConnectionGatewayReference
        :keyword virtual_network_gateway2: The reference to virtual network gateway resource.
        :paramtype virtual_network_gateway2:
         ~azure.mgmt.network.models.VirtualNetworkConnectionGatewayReference
        :keyword local_network_gateway2: The reference to local network gateway resource.
        :paramtype local_network_gateway2:
         ~azure.mgmt.network.models.VirtualNetworkConnectionGatewayReference
        :keyword connection_type: Gateway connection type. Required. Known values are: "IPsec",
         "Vnet2Vnet", "ExpressRoute", and "VPNClient".
        :paramtype connection_type: str or
         ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionType
        :keyword connection_protocol: Connection protocol used for this connection. Known values are:
         "IKEv2" and "IKEv1".
        :paramtype connection_protocol: str or
         ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionProtocol
        :keyword routing_weight: The routing weight.
        :paramtype routing_weight: int
        :keyword connection_mode: The connection mode for this connection. Known values are: "Default",
         "ResponderOnly", and "InitiatorOnly".
        :paramtype connection_mode: str or
         ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionMode
        :keyword shared_key: The IPSec shared key.
        :paramtype shared_key: str
        :keyword peer: The reference to peerings resource.
        :paramtype peer: ~azure.mgmt.network.models.SubResource
        :keyword enable_bgp: EnableBgp flag.
        :paramtype enable_bgp: bool
        :keyword gateway_custom_bgp_ip_addresses: GatewayCustomBgpIpAddresses to be used for virtual
         network gateway Connection.
        :paramtype gateway_custom_bgp_ip_addresses:
         list[~azure.mgmt.network.models.GatewayCustomBgpIpAddressIpConfiguration]
        :keyword use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :paramtype use_policy_based_traffic_selectors: bool
        :keyword ipsec_policies: The IPSec Policies to be considered by this connection.
        :paramtype ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
        :keyword traffic_selector_policies: The Traffic Selector Policies to be considered by this
         connection.
        :paramtype traffic_selector_policies:
         list[~azure.mgmt.network.models.TrafficSelectorPolicy]
        :keyword express_route_gateway_bypass: Bypass ExpressRoute Gateway for data forwarding.
        :paramtype express_route_gateway_bypass: bool
        :keyword enable_private_link_fast_path: Bypass the ExpressRoute gateway when accessing
         private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
        :paramtype enable_private_link_fast_path: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.connection_protocol = connection_protocol
        self.routing_weight = routing_weight
        self.connection_mode = connection_mode
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.gateway_custom_bgp_ip_addresses = gateway_custom_bgp_ip_addresses
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.traffic_selector_policies = traffic_selector_policies
        self.resource_guid = None
        self.provisioning_state = None
        self.express_route_gateway_bypass = express_route_gateway_bypass
        self.enable_private_link_fast_path = enable_private_link_fast_path

class VirtualNetworkGatewayListConnectionsResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for the VirtualNetworkGatewayListConnections API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :vartype value:
     list[~azure.mgmt.network.models.VirtualNetworkGatewayConnectionListEntity]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGatewayConnectionListEntity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetworkGatewayConnectionListEntity"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of VirtualNetworkGatewayConnection resources that exists in a resource
         group.
        :paramtype value:
         list[~azure.mgmt.network.models.VirtualNetworkGatewayConnectionListEntity]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class VirtualNetworkListUsageResult(_serialization.Model):
    """Response for the virtual networks GetUsage API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: VirtualNetwork usage stats.
    :vartype value: list[~azure.mgmt.network.models.VirtualNetworkUsage]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkUsage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link

class VirtualNetworkPeering(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peerings in a virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar allow_virtual_network_access: Whether the VMs in the local virtual network space would be
     able to access the VMs in remote virtual network space.
    :vartype allow_virtual_network_access: bool
    :ivar allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local virtual
     network will be allowed/disallowed in remote virtual network.
    :vartype allow_forwarded_traffic: bool
    :ivar allow_gateway_transit: If gateway links can be used in remote virtual networking to link
     to this virtual network.
    :vartype allow_gateway_transit: bool
    :ivar use_remote_gateways: If remote gateways can be used on this virtual network. If the flag
     is set to true, and allowGatewayTransit on remote peering is also true, virtual network will
     use gateways of remote virtual network for transit. Only one peering can have this flag set to
     true. This flag cannot be set if virtual network already has a gateway.
    :vartype use_remote_gateways: bool
    :ivar remote_virtual_network: The reference to the remote virtual network. The remote virtual
     network can be in the same or different region (preview). See here to register for the preview
     and learn more
     (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
    :vartype remote_virtual_network: ~azure.mgmt.network.models.SubResource
    :ivar local_address_space: The local address space of the local virtual network that is peered.
    :vartype local_address_space: ~azure.mgmt.network.models.AddressSpace
    :ivar local_virtual_network_address_space: The current local address space of the local virtual
     network that is peered.
    :vartype local_virtual_network_address_space:
     ~azure.mgmt.network.models.AddressSpace
    :ivar remote_address_space: The reference to the address space peered with the remote virtual
     network.
    :vartype remote_address_space: ~azure.mgmt.network.models.AddressSpace
    :ivar remote_virtual_network_address_space: The reference to the current address space of the
     remote virtual network.
    :vartype remote_virtual_network_address_space:
     ~azure.mgmt.network.models.AddressSpace
    :ivar remote_bgp_communities: The reference to the remote virtual network's Bgp Communities.
    :vartype remote_bgp_communities:
     ~azure.mgmt.network.models.VirtualNetworkBgpCommunities
    :ivar remote_virtual_network_encryption: The reference to the remote virtual network's
     encryption.
    :vartype remote_virtual_network_encryption:
     ~azure.mgmt.network.models.VirtualNetworkEncryption
    :ivar peering_state: The status of the virtual network peering. Known values are: "Initiated",
     "Connected", and "Disconnected".
    :vartype peering_state: str or
     ~azure.mgmt.network.models.VirtualNetworkPeeringState
    :ivar peering_sync_level: The peering sync status of the virtual network peering. Known values
     are: "FullyInSync", "RemoteNotInSync", "LocalNotInSync", and "LocalAndRemoteNotInSync".
    :vartype peering_sync_level: str or
     ~azure.mgmt.network.models.VirtualNetworkPeeringLevel
    :ivar provisioning_state: The provisioning state of the virtual network peering resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar do_not_verify_remote_gateways: If we need to verify the provisioning state of the remote
     gateway.
    :vartype do_not_verify_remote_gateways: bool
    :ivar resource_guid: The resourceGuid property of the Virtual Network peering resource.
    :vartype resource_guid: str
    :ivar peer_complete_vnets: Whether complete virtual network address space is peered.
    :vartype peer_complete_vnets: bool
    :ivar enable_only_i_pv6_peering: Whether only Ipv6 address space is peered for subnet peering.
    :vartype enable_only_i_pv6_peering: bool
    :ivar local_subnet_names: List of local subnet names that are subnet peered with remote virtual
     network.
    :vartype local_subnet_names: list[str]
    :ivar remote_subnet_names: List of remote subnet names from remote virtual network that are
     subnet peered.
    :vartype remote_subnet_names: list[str]
    """

    _validation = {
        "etag": {"readonly": True},
        "remote_virtual_network_encryption": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "allow_virtual_network_access": {"key": "properties.allowVirtualNetworkAccess", "type": "bool"},
        "allow_forwarded_traffic": {"key": "properties.allowForwardedTraffic", "type": "bool"},
        "allow_gateway_transit": {"key": "properties.allowGatewayTransit", "type": "bool"},
        "use_remote_gateways": {"key": "properties.useRemoteGateways", "type": "bool"},
        "remote_virtual_network": {"key": "properties.remoteVirtualNetwork", "type": "SubResource"},
        "local_address_space": {"key": "properties.localAddressSpace", "type": "AddressSpace"},
        "local_virtual_network_address_space": {
            "key": "properties.localVirtualNetworkAddressSpace",
            "type": "AddressSpace",
        },
        "remote_address_space": {"key": "properties.remoteAddressSpace", "type": "AddressSpace"},
        "remote_virtual_network_address_space": {
            "key": "properties.remoteVirtualNetworkAddressSpace",
            "type": "AddressSpace",
        },
        "remote_bgp_communities": {"key": "properties.remoteBgpCommunities", "type": "VirtualNetworkBgpCommunities"},
        "remote_virtual_network_encryption": {
            "key": "properties.remoteVirtualNetworkEncryption",
            "type": "VirtualNetworkEncryption",
        },
        "peering_state": {"key": "properties.peeringState", "type": "str"},
        "peering_sync_level": {"key": "properties.peeringSyncLevel", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "do_not_verify_remote_gateways": {"key": "properties.doNotVerifyRemoteGateways", "type": "bool"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "peer_complete_vnets": {"key": "properties.peerCompleteVnets", "type": "bool"},
        "enable_only_i_pv6_peering": {"key": "properties.enableOnlyIPv6Peering", "type": "bool"},
        "local_subnet_names": {"key": "properties.localSubnetNames", "type": "[str]"},
        "remote_subnet_names": {"key": "properties.remoteSubnetNames", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        allow_virtual_network_access: Optional[bool] = None,
        allow_forwarded_traffic: Optional[bool] = None,
        allow_gateway_transit: Optional[bool] = None,
        use_remote_gateways: Optional[bool] = None,
        remote_virtual_network: Optional["_models.SubResource"] = None,
        local_address_space: Optional["_models.AddressSpace"] = None,
        local_virtual_network_address_space: Optional["_models.AddressSpace"] = None,
        remote_address_space: Optional["_models.AddressSpace"] = None,
        remote_virtual_network_address_space: Optional["_models.AddressSpace"] = None,
        remote_bgp_communities: Optional["_models.VirtualNetworkBgpCommunities"] = None,
        peering_state: Optional[Union[str, "_models.VirtualNetworkPeeringState"]] = None,
        peering_sync_level: Optional[Union[str, "_models.VirtualNetworkPeeringLevel"]] = None,
        do_not_verify_remote_gateways: Optional[bool] = None,
        peer_complete_vnets: Optional[bool] = None,
        enable_only_i_pv6_peering: Optional[bool] = None,
        local_subnet_names: Optional[List[str]] = None,
        remote_subnet_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword allow_virtual_network_access: Whether the VMs in the local virtual network space would
         be able to access the VMs in remote virtual network space.
        :paramtype allow_virtual_network_access: bool
        :keyword allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local
         virtual network will be allowed/disallowed in remote virtual network.
        :paramtype allow_forwarded_traffic: bool
        :keyword allow_gateway_transit: If gateway links can be used in remote virtual networking to
         link to this virtual network.
        :paramtype allow_gateway_transit: bool
        :keyword use_remote_gateways: If remote gateways can be used on this virtual network. If the
         flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network
         will use gateways of remote virtual network for transit. Only one peering can have this flag
         set to true. This flag cannot be set if virtual network already has a gateway.
        :paramtype use_remote_gateways: bool
        :keyword remote_virtual_network: The reference to the remote virtual network. The remote
         virtual network can be in the same or different region (preview). See here to register for the
         preview and learn more
         (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
        :paramtype remote_virtual_network: ~azure.mgmt.network.models.SubResource
        :keyword local_address_space: The local address space of the local virtual network that is
         peered.
        :paramtype local_address_space: ~azure.mgmt.network.models.AddressSpace
        :keyword local_virtual_network_address_space: The current local address space of the local
         virtual network that is peered.
        :paramtype local_virtual_network_address_space:
         ~azure.mgmt.network.models.AddressSpace
        :keyword remote_address_space: The reference to the address space peered with the remote
         virtual network.
        :paramtype remote_address_space: ~azure.mgmt.network.models.AddressSpace
        :keyword remote_virtual_network_address_space: The reference to the current address space of
         the remote virtual network.
        :paramtype remote_virtual_network_address_space:
         ~azure.mgmt.network.models.AddressSpace
        :keyword remote_bgp_communities: The reference to the remote virtual network's Bgp Communities.
        :paramtype remote_bgp_communities:
         ~azure.mgmt.network.models.VirtualNetworkBgpCommunities
        :keyword peering_state: The status of the virtual network peering. Known values are:
         "Initiated", "Connected", and "Disconnected".
        :paramtype peering_state: str or
         ~azure.mgmt.network.models.VirtualNetworkPeeringState
        :keyword peering_sync_level: The peering sync status of the virtual network peering. Known
         values are: "FullyInSync", "RemoteNotInSync", "LocalNotInSync", and "LocalAndRemoteNotInSync".
        :paramtype peering_sync_level: str or
         ~azure.mgmt.network.models.VirtualNetworkPeeringLevel
        :keyword do_not_verify_remote_gateways: If we need to verify the provisioning state of the
         remote gateway.
        :paramtype do_not_verify_remote_gateways: bool
        :keyword peer_complete_vnets: Whether complete virtual network address space is peered.
        :paramtype peer_complete_vnets: bool
        :keyword enable_only_i_pv6_peering: Whether only Ipv6 address space is peered for subnet
         peering.
        :paramtype enable_only_i_pv6_peering: bool
        :keyword local_subnet_names: List of local subnet names that are subnet peered with remote
         virtual network.
        :paramtype local_subnet_names: list[str]
        :keyword remote_subnet_names: List of remote subnet names from remote virtual network that are
         subnet peered.
        :paramtype remote_subnet_names: list[str]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = type
        self.allow_virtual_network_access = allow_virtual_network_access
        self.allow_forwarded_traffic = allow_forwarded_traffic
        self.allow_gateway_transit = allow_gateway_transit
        self.use_remote_gateways = use_remote_gateways
        self.remote_virtual_network = remote_virtual_network
        self.local_address_space = local_address_space
        self.local_virtual_network_address_space = local_virtual_network_address_space
        self.remote_address_space = remote_address_space
        self.remote_virtual_network_address_space = remote_virtual_network_address_space
        self.remote_bgp_communities = remote_bgp_communities
        self.remote_virtual_network_encryption = None
        self.peering_state = peering_state
        self.peering_sync_level = peering_sync_level
        self.provisioning_state = None
        self.do_not_verify_remote_gateways = do_not_verify_remote_gateways
        self.resource_guid = None
        self.peer_complete_vnets = peer_complete_vnets
        self.enable_only_i_pv6_peering = enable_only_i_pv6_peering
        self.local_subnet_names = local_subnet_names
        self.remote_subnet_names = remote_subnet_names

class VirtualNetworkPeeringListResult(_serialization.Model):
    """Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual
    network.

    :ivar value: The peerings in a virtual network.
    :vartype value: list[~azure.mgmt.network.models.VirtualNetworkPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualNetworkPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The peerings in a virtual network.
        :paramtype value: list[~azure.mgmt.network.models.VirtualNetworkPeering]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualNetworkUsage(_serialization.Model):
    """Usage details for subnet.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_value: Indicates number of IPs used from the Subnet.
    :vartype current_value: float
    :ivar id: Subnet identifier.
    :vartype id: str
    :ivar limit: Indicates the size of the subnet.
    :vartype limit: float
    :ivar name: The name containing common and localized value for usage.
    :vartype name: ~azure.mgmt.network.models.VirtualNetworkUsageName
    :ivar unit: Usage units. Returns 'Count'.
    :vartype unit: str
    """

    _validation = {
        "current_value": {"readonly": True},
        "id": {"readonly": True},
        "limit": {"readonly": True},
        "name": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "current_value": {"key": "currentValue", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "limit": {"key": "limit", "type": "float"},
        "name": {"key": "name", "type": "VirtualNetworkUsageName"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.current_value = None
        self.id = None
        self.limit = None
        self.name = None
        self.unit = None

class VirtualNetworkUsageName(_serialization.Model):
    """Usage strings container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar localized_value: Localized subnet size and usage string.
    :vartype localized_value: str
    :ivar value: Subnet size and usage string.
    :vartype value: str
    """

    _validation = {
        "localized_value": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "localized_value": {"key": "localizedValue", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.localized_value = None
        self.value = None

class VpnDeviceScriptParameters(_serialization.Model):
    """Vpn device configuration script generation parameters.

    :ivar vendor: The vendor for the vpn device.
    :vartype vendor: str
    :ivar device_family: The device family for the vpn device.
    :vartype device_family: str
    :ivar firmware_version: The firmware version for the vpn device.
    :vartype firmware_version: str
    """

    _attribute_map = {
        "vendor": {"key": "vendor", "type": "str"},
        "device_family": {"key": "deviceFamily", "type": "str"},
        "firmware_version": {"key": "firmwareVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        vendor: Optional[str] = None,
        device_family: Optional[str] = None,
        firmware_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vendor: The vendor for the vpn device.
        :paramtype vendor: str
        :keyword device_family: The device family for the vpn device.
        :paramtype device_family: str
        :keyword firmware_version: The firmware version for the vpn device.
        :paramtype firmware_version: str
        """
        super().__init__(**kwargs)
        self.vendor = vendor
        self.device_family = device_family
        self.firmware_version = firmware_version

class ApplicationGatewayAutoscaleBounds(_serialization.Model):
    """Application Gateway autoscale bounds on number of Application Gateway instance.

    All required parameters must be populated in order to send to server.

    :ivar min: Lower bound on number of Application Gateway instances. Required.
    :vartype min: int
    :ivar max: Upper bound on number of Application Gateway instances. Required.
    :vartype max: int
    """

    _validation = {
        "min": {"required": True},
        "max": {"required": True},
    }

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: int,  # pylint: disable=redefined-builtin
        max: int,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword min: Lower bound on number of Application Gateway instances. Required.
        :paramtype min: int
        :keyword max: Upper bound on number of Application Gateway instances. Required.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max

class ApplicationGatewayAutoscaleConfiguration(_serialization.Model):
    """Application Gateway autoscale configuration.

    All required parameters must be populated in order to send to server.

    :ivar min_capacity: Lower bound on number of Application Gateway capacity. Required.
    :vartype min_capacity: int
    :ivar max_capacity: Upper bound on number of Application Gateway capacity.
    :vartype max_capacity: int
    """

    _validation = {
        "min_capacity": {"required": True, "minimum": 0},
        "max_capacity": {"minimum": 2},
    }

    _attribute_map = {
        "min_capacity": {"key": "minCapacity", "type": "int"},
        "max_capacity": {"key": "maxCapacity", "type": "int"},
    }

    def __init__(self, *, min_capacity: int, max_capacity: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword min_capacity: Lower bound on number of Application Gateway capacity. Required.
        :paramtype min_capacity: int
        :keyword max_capacity: Upper bound on number of Application Gateway capacity.
        :paramtype max_capacity: int
        """
        super().__init__(**kwargs)
        self.min_capacity = min_capacity
        self.max_capacity = max_capacity

class AzureFirewall(Resource):  # pylint: disable=too-many-instance-attributes
    """Azure Firewall resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar application_rule_collections: Collection of application rule collections used by Azure
     Firewall.
    :vartype application_rule_collections:
     list[~azure.mgmt.network.models.AzureFirewallApplicationRuleCollection]
    :ivar nat_rule_collections: Collection of NAT rule collections used by Azure Firewall.
    :vartype nat_rule_collections:
     list[~azure.mgmt.network.models.AzureFirewallNatRuleCollection]
    :ivar network_rule_collections: Collection of network rule collections used by Azure Firewall.
    :vartype network_rule_collections:
     list[~azure.mgmt.network.models.AzureFirewallNetworkRuleCollection]
    :ivar ip_configurations: IP configuration of the Azure Firewall resource.
    :vartype ip_configurations:
     list[~azure.mgmt.network.models.AzureFirewallIPConfiguration]
    :ivar management_ip_configuration: IP configuration of the Azure Firewall used for management
     traffic.
    :vartype management_ip_configuration:
     ~azure.mgmt.network.models.AzureFirewallIPConfiguration
    :ivar provisioning_state: The provisioning state of the Azure firewall resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar threat_intel_mode: The operation mode for Threat Intelligence. Known values are: "Alert",
     "Deny", and "Off".
    :vartype threat_intel_mode: str or
     ~azure.mgmt.network.models.AzureFirewallThreatIntelMode
    :ivar virtual_hub: The virtualHub to which the firewall belongs.
    :vartype virtual_hub: ~azure.mgmt.network.models.SubResource
    :ivar firewall_policy: The firewallPolicy associated with this azure firewall.
    :vartype firewall_policy: ~azure.mgmt.network.models.SubResource
    :ivar hub_ip_addresses: IP addresses associated with AzureFirewall.
    :vartype hub_ip_addresses: ~azure.mgmt.network.models.HubIPAddresses
    :ivar ip_groups: IpGroups associated with AzureFirewall.
    :vartype ip_groups: list[~azure.mgmt.network.models.AzureFirewallIpGroups]
    :ivar sku: The Azure Firewall Resource SKU.
    :vartype sku: ~azure.mgmt.network.models.AzureFirewallSku
    :ivar additional_properties: The additional properties used to further config this azure
     firewall.
    :vartype additional_properties: dict[str, str]
    :ivar autoscale_configuration: Properties to provide a custom autoscale configuration to this
     azure firewall.
    :vartype autoscale_configuration:
     ~azure.mgmt.network.models.AzureFirewallAutoscaleConfiguration
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "ip_groups": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "etag": {"key": "etag", "type": "str"},
        "application_rule_collections": {
            "key": "properties.applicationRuleCollections",
            "type": "[AzureFirewallApplicationRuleCollection]",
        },
        "nat_rule_collections": {"key": "properties.natRuleCollections", "type": "[AzureFirewallNatRuleCollection]"},
        "network_rule_collections": {
            "key": "properties.networkRuleCollections",
            "type": "[AzureFirewallNetworkRuleCollection]",
        },
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[AzureFirewallIPConfiguration]"},
        "management_ip_configuration": {
            "key": "properties.managementIpConfiguration",
            "type": "AzureFirewallIPConfiguration",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "threat_intel_mode": {"key": "properties.threatIntelMode", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "SubResource"},
        "firewall_policy": {"key": "properties.firewallPolicy", "type": "SubResource"},
        "hub_ip_addresses": {"key": "properties.hubIPAddresses", "type": "HubIPAddresses"},
        "ip_groups": {"key": "properties.ipGroups", "type": "[AzureFirewallIpGroups]"},
        "sku": {"key": "properties.sku", "type": "AzureFirewallSku"},
        "additional_properties": {"key": "properties.additionalProperties", "type": "{str}"},
        "autoscale_configuration": {
            "key": "properties.autoscaleConfiguration",
            "type": "AzureFirewallAutoscaleConfiguration",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        application_rule_collections: Optional[List["_models.AzureFirewallApplicationRuleCollection"]] = None,
        nat_rule_collections: Optional[List["_models.AzureFirewallNatRuleCollection"]] = None,
        network_rule_collections: Optional[List["_models.AzureFirewallNetworkRuleCollection"]] = None,
        ip_configurations: Optional[List["_models.AzureFirewallIPConfiguration"]] = None,
        management_ip_configuration: Optional["_models.AzureFirewallIPConfiguration"] = None,
        threat_intel_mode: Optional[Union[str, "_models.AzureFirewallThreatIntelMode"]] = None,
        virtual_hub: Optional["_models.SubResource"] = None,
        firewall_policy: Optional["_models.SubResource"] = None,
        hub_ip_addresses: Optional["_models.HubIPAddresses"] = None,
        sku: Optional["_models.AzureFirewallSku"] = None,
        additional_properties: Optional[Dict[str, str]] = None,
        autoscale_configuration: Optional["_models.AzureFirewallAutoscaleConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword application_rule_collections: Collection of application rule collections used by Azure
         Firewall.
        :paramtype application_rule_collections:
         list[~azure.mgmt.network.models.AzureFirewallApplicationRuleCollection]
        :keyword nat_rule_collections: Collection of NAT rule collections used by Azure Firewall.
        :paramtype nat_rule_collections:
         list[~azure.mgmt.network.models.AzureFirewallNatRuleCollection]
        :keyword network_rule_collections: Collection of network rule collections used by Azure
         Firewall.
        :paramtype network_rule_collections:
         list[~azure.mgmt.network.models.AzureFirewallNetworkRuleCollection]
        :keyword ip_configurations: IP configuration of the Azure Firewall resource.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.models.AzureFirewallIPConfiguration]
        :keyword management_ip_configuration: IP configuration of the Azure Firewall used for
         management traffic.
        :paramtype management_ip_configuration:
         ~azure.mgmt.network.models.AzureFirewallIPConfiguration
        :keyword threat_intel_mode: The operation mode for Threat Intelligence. Known values are:
         "Alert", "Deny", and "Off".
        :paramtype threat_intel_mode: str or
         ~azure.mgmt.network.models.AzureFirewallThreatIntelMode
        :keyword virtual_hub: The virtualHub to which the firewall belongs.
        :paramtype virtual_hub: ~azure.mgmt.network.models.SubResource
        :keyword firewall_policy: The firewallPolicy associated with this azure firewall.
        :paramtype firewall_policy: ~azure.mgmt.network.models.SubResource
        :keyword hub_ip_addresses: IP addresses associated with AzureFirewall.
        :paramtype hub_ip_addresses: ~azure.mgmt.network.models.HubIPAddresses
        :keyword sku: The Azure Firewall Resource SKU.
        :paramtype sku: ~azure.mgmt.network.models.AzureFirewallSku
        :keyword additional_properties: The additional properties used to further config this azure
         firewall.
        :paramtype additional_properties: dict[str, str]
        :keyword autoscale_configuration: Properties to provide a custom autoscale configuration to
         this azure firewall.
        :paramtype autoscale_configuration:
         ~azure.mgmt.network.models.AzureFirewallAutoscaleConfiguration
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.zones = zones
        self.etag = None
        self.application_rule_collections = application_rule_collections
        self.nat_rule_collections = nat_rule_collections
        self.network_rule_collections = network_rule_collections
        self.ip_configurations = ip_configurations
        self.management_ip_configuration = management_ip_configuration
        self.provisioning_state = None
        self.threat_intel_mode = threat_intel_mode
        self.virtual_hub = virtual_hub
        self.firewall_policy = firewall_policy
        self.hub_ip_addresses = hub_ip_addresses
        self.ip_groups = None
        self.sku = sku
        self.additional_properties = additional_properties
        self.autoscale_configuration = autoscale_configuration

class AzureFirewallApplicationRule(_serialization.Model):
    """Properties of an application rule.

    :ivar name: Name of the application rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar protocols: Array of ApplicationRuleProtocols.
    :vartype protocols:
     list[~azure.mgmt.network.models.AzureFirewallApplicationRuleProtocol]
    :ivar target_fqdns: List of FQDNs for this rule.
    :vartype target_fqdns: list[str]
    :ivar fqdn_tags: List of FQDN Tags for this rule.
    :vartype fqdn_tags: list[str]
    :ivar source_ip_groups: List of source IpGroups for this rule.
    :vartype source_ip_groups: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[AzureFirewallApplicationRuleProtocol]"},
        "target_fqdns": {"key": "targetFqdns", "type": "[str]"},
        "fqdn_tags": {"key": "fqdnTags", "type": "[str]"},
        "source_ip_groups": {"key": "sourceIpGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        source_addresses: Optional[List[str]] = None,
        protocols: Optional[List["_models.AzureFirewallApplicationRuleProtocol"]] = None,
        target_fqdns: Optional[List[str]] = None,
        fqdn_tags: Optional[List[str]] = None,
        source_ip_groups: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the application rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword protocols: Array of ApplicationRuleProtocols.
        :paramtype protocols:
         list[~azure.mgmt.network.models.AzureFirewallApplicationRuleProtocol]
        :keyword target_fqdns: List of FQDNs for this rule.
        :paramtype target_fqdns: list[str]
        :keyword fqdn_tags: List of FQDN Tags for this rule.
        :paramtype fqdn_tags: list[str]
        :keyword source_ip_groups: List of source IpGroups for this rule.
        :paramtype source_ip_groups: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.source_addresses = source_addresses
        self.protocols = protocols
        self.target_fqdns = target_fqdns
        self.fqdn_tags = fqdn_tags
        self.source_ip_groups = source_ip_groups

class AzureFirewallApplicationRuleCollection(SubResource):
    """Application rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the application rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a rule collection.
    :vartype action: ~azure.mgmt.network.models.AzureFirewallRCAction
    :ivar rules: Collection of rules used by a application rule collection.
    :vartype rules: list[~azure.mgmt.network.models.AzureFirewallApplicationRule]
    :ivar provisioning_state: The provisioning state of the application rule collection resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallApplicationRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallRCAction"] = None,
        rules: Optional[List["_models.AzureFirewallApplicationRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the application rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a rule collection.
        :paramtype action: ~azure.mgmt.network.models.AzureFirewallRCAction
        :keyword rules: Collection of rules used by a application rule collection.
        :paramtype rules: list[~azure.mgmt.network.models.AzureFirewallApplicationRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None

class AzureFirewallApplicationRuleProtocol(_serialization.Model):
    """Properties of the application rule protocol.

    :ivar protocol_type: Protocol type. Known values are: "Http", "Https", and "Mssql".
    :vartype protocol_type: str or
     ~azure.mgmt.network.models.AzureFirewallApplicationRuleProtocolType
    :ivar port: Port number for the protocol, cannot be greater than 64000. This field is optional.
    :vartype port: int
    """

    _validation = {
        "port": {"maximum": 64000, "minimum": 0},
    }

    _attribute_map = {
        "protocol_type": {"key": "protocolType", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(
        self,
        *,
        protocol_type: Optional[Union[str, "_models.AzureFirewallApplicationRuleProtocolType"]] = None,
        port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol_type: Protocol type. Known values are: "Http", "Https", and "Mssql".
        :paramtype protocol_type: str or
         ~azure.mgmt.network.models.AzureFirewallApplicationRuleProtocolType
        :keyword port: Port number for the protocol, cannot be greater than 64000. This field is
         optional.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.protocol_type = protocol_type
        self.port = port

class AzureFirewallIPConfiguration(SubResource):
    """IP configuration of an Azure Firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar private_ip_address: The Firewall Internal Load Balancer IP to be used as the next hop in
     User Defined Routes.
    :vartype private_ip_address: str
    :ivar subnet: Reference to the subnet resource. This resource must be named
     'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
    :vartype subnet: ~azure.mgmt.network.models.SubResource
    :ivar public_ip_address: Reference to the PublicIP resource. This field is a mandatory input if
     subnet is not null.
    :vartype public_ip_address: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the Azure firewall IP configuration
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "private_ip_address": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword subnet: Reference to the subnet resource. This resource must be named
         'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
        :paramtype subnet: ~azure.mgmt.network.models.SubResource
        :keyword public_ip_address: Reference to the PublicIP resource. This field is a mandatory input
         if subnet is not null.
        :paramtype public_ip_address: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.private_ip_address = None
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None

class AzureFirewallListResult(_serialization.Model):
    """Response for ListAzureFirewalls API service call.

    :ivar value: List of Azure Firewalls in a resource group.
    :vartype value: list[~azure.mgmt.network.models.AzureFirewall]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureFirewall]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureFirewall"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Azure Firewalls in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.AzureFirewall]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class AzureFirewallNetworkRule(_serialization.Model):
    """Properties of the network rule.

    :ivar name: Name of the network rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar protocols: Array of AzureFirewallNetworkRuleProtocols.
    :vartype protocols: list[str or
     ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol]
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses.
    :vartype destination_addresses: list[str]
    :ivar destination_ports: List of destination ports.
    :vartype destination_ports: list[str]
    :ivar destination_fqdns: List of destination FQDNs.
    :vartype destination_fqdns: list[str]
    :ivar source_ip_groups: List of source IpGroups for this rule.
    :vartype source_ip_groups: list[str]
    :ivar destination_ip_groups: List of destination IpGroups for this rule.
    :vartype destination_ip_groups: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "protocols": {"key": "protocols", "type": "[str]"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
        "destination_fqdns": {"key": "destinationFqdns", "type": "[str]"},
        "source_ip_groups": {"key": "sourceIpGroups", "type": "[str]"},
        "destination_ip_groups": {"key": "destinationIpGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        protocols: Optional[List[Union[str, "_models.AzureFirewallNetworkRuleProtocol"]]] = None,
        source_addresses: Optional[List[str]] = None,
        destination_addresses: Optional[List[str]] = None,
        destination_ports: Optional[List[str]] = None,
        destination_fqdns: Optional[List[str]] = None,
        source_ip_groups: Optional[List[str]] = None,
        destination_ip_groups: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the network rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword protocols: Array of AzureFirewallNetworkRuleProtocols.
        :paramtype protocols: list[str or
         ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol]
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses.
        :paramtype destination_addresses: list[str]
        :keyword destination_ports: List of destination ports.
        :paramtype destination_ports: list[str]
        :keyword destination_fqdns: List of destination FQDNs.
        :paramtype destination_fqdns: list[str]
        :keyword source_ip_groups: List of source IpGroups for this rule.
        :paramtype source_ip_groups: list[str]
        :keyword destination_ip_groups: List of destination IpGroups for this rule.
        :paramtype destination_ip_groups: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.protocols = protocols
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.destination_fqdns = destination_fqdns
        self.source_ip_groups = source_ip_groups
        self.destination_ip_groups = destination_ip_groups

class AzureFirewallNetworkRuleCollection(SubResource):
    """Network rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the network rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a rule collection.
    :vartype action: ~azure.mgmt.network.models.AzureFirewallRCAction
    :ivar rules: Collection of rules used by a network rule collection.
    :vartype rules: list[~azure.mgmt.network.models.AzureFirewallNetworkRule]
    :ivar provisioning_state: The provisioning state of the network rule collection resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallNetworkRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallRCAction"] = None,
        rules: Optional[List["_models.AzureFirewallNetworkRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the network rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a rule collection.
        :paramtype action: ~azure.mgmt.network.models.AzureFirewallRCAction
        :keyword rules: Collection of rules used by a network rule collection.
        :paramtype rules: list[~azure.mgmt.network.models.AzureFirewallNetworkRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None

class AzureFirewallRCAction(_serialization.Model):
    """Properties of the AzureFirewallRCAction.

    :ivar type: The type of action. Known values are: "Allow" and "Deny".
    :vartype type: str or ~azure.mgmt.network.models.AzureFirewallRCActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.AzureFirewallRCActionType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of action. Known values are: "Allow" and "Deny".
        :paramtype type: str or ~azure.mgmt.network.models.AzureFirewallRCActionType
        """
        super().__init__(**kwargs)
        self.type = type

class DdosProtectionPlan(_serialization.Model):
    """A DDoS protection plan in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the DDoS protection plan resource. It
     uniquely identifies the resource, even if the user changes its name or migrate the resource
     across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS protection plan resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar public_ip_addresses: The list of public IPs associated with the DDoS protection plan
     resource. This list is read-only.
    :vartype public_ip_addresses: list[~azure.mgmt.network.models.SubResource]
    :ivar virtual_networks: The list of virtual networks associated with the DDoS protection plan
     resource. This list is read-only.
    :vartype virtual_networks: list[~azure.mgmt.network.models.SubResource]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "public_ip_addresses": {"readonly": True},
        "virtual_networks": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "public_ip_addresses": {"key": "properties.publicIPAddresses", "type": "[SubResource]"},
        "virtual_networks": {"key": "properties.virtualNetworks", "type": "[SubResource]"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None
        self.public_ip_addresses = None
        self.virtual_networks = None

class DdosProtectionPlanListResult(_serialization.Model):
    """A list of DDoS protection plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of DDoS protection plans.
    :vartype value: list[~azure.mgmt.network.models.DdosProtectionPlan]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DdosProtectionPlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DdosProtectionPlan"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of DDoS protection plans.
        :paramtype value: list[~azure.mgmt.network.models.DdosProtectionPlan]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class DeviceProperties(_serialization.Model):
    """List of properties of the device.

    :ivar device_vendor: Name of the device Vendor.
    :vartype device_vendor: str
    :ivar device_model: Model of the device.
    :vartype device_model: str
    :ivar link_speed_in_mbps: Link speed.
    :vartype link_speed_in_mbps: int
    """

    _attribute_map = {
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_model": {"key": "deviceModel", "type": "str"},
        "link_speed_in_mbps": {"key": "linkSpeedInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        device_vendor: Optional[str] = None,
        device_model: Optional[str] = None,
        link_speed_in_mbps: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_vendor: Name of the device Vendor.
        :paramtype device_vendor: str
        :keyword device_model: Model of the device.
        :paramtype device_model: str
        :keyword link_speed_in_mbps: Link speed.
        :paramtype link_speed_in_mbps: int
        """
        super().__init__(**kwargs)
        self.device_vendor = device_vendor
        self.device_model = device_model
        self.link_speed_in_mbps = link_speed_in_mbps

class ExpressRouteCircuitConnection(SubResource):  # pylint: disable=too-many-instance-attributes
    """Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the circuit initiating connection.
    :vartype express_route_circuit_peering: ~azure.mgmt.network.models.SubResource
    :ivar peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
     Resource of the peered circuit.
    :vartype peer_express_route_circuit_peering: ~azure.mgmt.network.models.SubResource
    :ivar address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
    :vartype address_prefix: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar ipv6_circuit_connection_config: IPv6 Address PrefixProperties of the express route
     circuit connection.
    :vartype ipv6_circuit_connection_config:
     ~azure.mgmt.network.models.Ipv6CircuitConnectionConfig
    :ivar circuit_connection_status: Express Route Circuit connection state. Known values are:
     "Connected", "Connecting", and "Disconnected".
    :vartype circuit_connection_status: str or
     ~azure.mgmt.network.models.CircuitConnectionStatus
    :ivar provisioning_state: The provisioning state of the express route circuit connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "circuit_connection_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "express_route_circuit_peering": {"key": "properties.expressRouteCircuitPeering", "type": "SubResource"},
        "peer_express_route_circuit_peering": {
            "key": "properties.peerExpressRouteCircuitPeering",
            "type": "SubResource",
        },
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "ipv6_circuit_connection_config": {
            "key": "properties.ipv6CircuitConnectionConfig",
            "type": "Ipv6CircuitConnectionConfig",
        },
        "circuit_connection_status": {"key": "properties.circuitConnectionStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        express_route_circuit_peering: Optional["_models.SubResource"] = None,
        peer_express_route_circuit_peering: Optional["_models.SubResource"] = None,
        address_prefix: Optional[str] = None,
        authorization_key: Optional[str] = None,
        ipv6_circuit_connection_config: Optional["_models.Ipv6CircuitConnectionConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword express_route_circuit_peering: Reference to Express Route Circuit Private Peering
         Resource of the circuit initiating connection.
        :paramtype express_route_circuit_peering: ~azure.mgmt.network.models.SubResource
        :keyword peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering
         Resource of the peered circuit.
        :paramtype peer_express_route_circuit_peering:
         ~azure.mgmt.network.models.SubResource
        :keyword address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
        :paramtype address_prefix: str
        :keyword authorization_key: The authorization key.
        :paramtype authorization_key: str
        :keyword ipv6_circuit_connection_config: IPv6 Address PrefixProperties of the express route
         circuit connection.
        :paramtype ipv6_circuit_connection_config:
         ~azure.mgmt.network.models.Ipv6CircuitConnectionConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.express_route_circuit_peering = express_route_circuit_peering
        self.peer_express_route_circuit_peering = peer_express_route_circuit_peering
        self.address_prefix = address_prefix
        self.authorization_key = authorization_key
        self.ipv6_circuit_connection_config = ipv6_circuit_connection_config
        self.circuit_connection_status = None
        self.provisioning_state = None

class ExpressRouteCircuitReference(_serialization.Model):
    """Reference to an express route circuit.

    :ivar id: Corresponding Express Route Circuit Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Corresponding Express Route Circuit Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class ExpressRouteCrossConnection(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRouteCrossConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar primary_azure_port: The name of the primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The name of the secondary port.
    :vartype secondary_azure_port: str
    :ivar s_tag: The identifier of the circuit traffic.
    :vartype s_tag: int
    :ivar peering_location: The peering location of the ExpressRoute circuit.
    :vartype peering_location: str
    :ivar bandwidth_in_mbps: The circuit bandwidth In Mbps.
    :vartype bandwidth_in_mbps: int
    :ivar express_route_circuit: The ExpressRouteCircuit.
    :vartype express_route_circuit:
     ~azure.mgmt.network.models.ExpressRouteCircuitReference
    :ivar service_provider_provisioning_state: The provisioning state of the circuit in the
     connectivity provider system. Known values are: "NotProvisioned", "Provisioning",
     "Provisioned", and "Deprovisioning".
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.models.ServiceProviderProvisioningState
    :ivar service_provider_notes: Additional read only notes set by the connectivity provider.
    :vartype service_provider_notes: str
    :ivar provisioning_state: The provisioning state of the express route cross connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar peerings: The list of peerings.
    :vartype peerings:
     list[~azure.mgmt.network.models.ExpressRouteCrossConnectionPeering]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "primary_azure_port": {"readonly": True},
        "secondary_azure_port": {"readonly": True},
        "s_tag": {"readonly": True},
        "peering_location": {"readonly": True},
        "bandwidth_in_mbps": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "s_tag": {"key": "properties.sTag", "type": "int"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "bandwidth_in_mbps": {"key": "properties.bandwidthInMbps", "type": "int"},
        "express_route_circuit": {"key": "properties.expressRouteCircuit", "type": "ExpressRouteCircuitReference"},
        "service_provider_provisioning_state": {"key": "properties.serviceProviderProvisioningState", "type": "str"},
        "service_provider_notes": {"key": "properties.serviceProviderNotes", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCrossConnectionPeering]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        express_route_circuit: Optional["_models.ExpressRouteCircuitReference"] = None,
        service_provider_provisioning_state: Optional[Union[str, "_models.ServiceProviderProvisioningState"]] = None,
        service_provider_notes: Optional[str] = None,
        peerings: Optional[List["_models.ExpressRouteCrossConnectionPeering"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword express_route_circuit: The ExpressRouteCircuit.
        :paramtype express_route_circuit:
         ~azure.mgmt.network.models.ExpressRouteCircuitReference
        :keyword service_provider_provisioning_state: The provisioning state of the circuit in the
         connectivity provider system. Known values are: "NotProvisioned", "Provisioning",
         "Provisioned", and "Deprovisioning".
        :paramtype service_provider_provisioning_state: str or
         ~azure.mgmt.network.models.ServiceProviderProvisioningState
        :keyword service_provider_notes: Additional read only notes set by the connectivity provider.
        :paramtype service_provider_notes: str
        :keyword peerings: The list of peerings.
        :paramtype peerings:
         list[~azure.mgmt.network.models.ExpressRouteCrossConnectionPeering]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.s_tag = None
        self.peering_location = None
        self.bandwidth_in_mbps = None
        self.express_route_circuit = express_route_circuit
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.service_provider_notes = service_provider_notes
        self.provisioning_state = None
        self.peerings = peerings

class ExpressRouteCrossConnectionListResult(_serialization.Model):
    """Response for ListExpressRouteCrossConnection API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of ExpressRouteCrossConnection resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCrossConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ExpressRouteCrossConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of ExpressRouteCrossConnection resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCrossConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class ExpressRouteCrossConnectionPeering(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peering in an ExpressRoute Cross Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar peering_type: The peering type. Known values are: "AzurePublicPeering",
     "AzurePrivatePeering", and "MicrosoftPeering".
    :vartype peering_type: str or ~azure.mgmt.network.models.ExpressRoutePeeringType
    :ivar state: The peering state. Known values are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :ivar shared_key: The shared key.
    :vartype shared_key: str
    :ivar vlan_id: The VLAN ID.
    :vartype vlan_id: int
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
    :ivar provisioning_state: The provisioning state of the express route cross connection peering
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar gateway_manager_etag: The GatewayManager Etag.
    :vartype gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :ivar ipv6_peering_config: The IPv6 peering configuration.
    :vartype ipv6_peering_config:
     ~azure.mgmt.network.models.Ipv6ExpressRouteCircuitPeeringConfig
    """

    _validation = {
        "etag": {"readonly": True},
        "azure_asn": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "primary_azure_port": {"readonly": True},
        "secondary_azure_port": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "last_modified_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "peering_type": {"key": "properties.peeringType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_asn": {"key": "properties.azureASN", "type": "int"},
        "peer_asn": {"key": "properties.peerASN", "type": "int"},
        "primary_peer_address_prefix": {"key": "properties.primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "properties.secondaryPeerAddressPrefix", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "microsoft_peering_config": {
            "key": "properties.microsoftPeeringConfig",
            "type": "ExpressRouteCircuitPeeringConfig",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "gateway_manager_etag": {"key": "properties.gatewayManagerEtag", "type": "str"},
        "last_modified_by": {"key": "properties.lastModifiedBy", "type": "str"},
        "ipv6_peering_config": {"key": "properties.ipv6PeeringConfig", "type": "Ipv6ExpressRouteCircuitPeeringConfig"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        peering_type: Optional[Union[str, "_models.ExpressRoutePeeringType"]] = None,
        state: Optional[Union[str, "_models.ExpressRoutePeeringState"]] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        gateway_manager_etag: Optional[str] = None,
        ipv6_peering_config: Optional["_models.Ipv6ExpressRouteCircuitPeeringConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword peering_type: The peering type. Known values are: "AzurePublicPeering",
         "AzurePrivatePeering", and "MicrosoftPeering".
        :paramtype peering_type: str or ~azure.mgmt.network.models.ExpressRoutePeeringType
        :keyword state: The peering state. Known values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.models.ExpressRoutePeeringState
        :keyword peer_asn: The peer ASN.
        :paramtype peer_asn: int
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword shared_key: The shared key.
        :paramtype shared_key: str
        :keyword vlan_id: The VLAN ID.
        :paramtype vlan_id: int
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.models.ExpressRouteCircuitPeeringConfig
        :keyword gateway_manager_etag: The GatewayManager Etag.
        :paramtype gateway_manager_etag: str
        :keyword ipv6_peering_config: The IPv6 peering configuration.
        :paramtype ipv6_peering_config:
         ~azure.mgmt.network.models.Ipv6ExpressRouteCircuitPeeringConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = None
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by = None
        self.ipv6_peering_config = ipv6_peering_config

class ExpressRouteCrossConnectionPeeringList(_serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an
    ExpressRouteCrossConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The peerings in an express route cross connection.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCrossConnectionPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnectionPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExpressRouteCrossConnectionPeering"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The peerings in an express route cross connection.
        :paramtype value:
         list[~azure.mgmt.network.models.ExpressRouteCrossConnectionPeering]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class ExpressRouteCrossConnectionRoutesTableSummary(_serialization.Model):  # pylint: disable=name-too-long
    """The routes table associated with the ExpressRouteCircuit.

    :ivar neighbor: IP address of Neighbor router.
    :vartype neighbor: str
    :ivar asn: Autonomous system number.
    :vartype asn: int
    :ivar up_down: The length of time that the BGP session has been in the Established state, or
     the current status if not in the Established state.
    :vartype up_down: str
    :ivar state_or_prefixes_received: Current state of the BGP session, and the number of prefixes
     that have been received from a neighbor or peer group.
    :vartype state_or_prefixes_received: str
    """

    _attribute_map = {
        "neighbor": {"key": "neighbor", "type": "str"},
        "asn": {"key": "asn", "type": "int"},
        "up_down": {"key": "upDown", "type": "str"},
        "state_or_prefixes_received": {"key": "stateOrPrefixesReceived", "type": "str"},
    }

    def __init__(
        self,
        *,
        neighbor: Optional[str] = None,
        asn: Optional[int] = None,
        up_down: Optional[str] = None,
        state_or_prefixes_received: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword neighbor: IP address of Neighbor router.
        :paramtype neighbor: str
        :keyword asn: Autonomous system number.
        :paramtype asn: int
        :keyword up_down: The length of time that the BGP session has been in the Established state, or
         the current status if not in the Established state.
        :paramtype up_down: str
        :keyword state_or_prefixes_received: Current state of the BGP session, and the number of
         prefixes that have been received from a neighbor or peer group.
        :paramtype state_or_prefixes_received: str
        """
        super().__init__(**kwargs)
        self.neighbor = neighbor
        self.asn = asn
        self.up_down = up_down
        self.state_or_prefixes_received = state_or_prefixes_received

class ExpressRouteCrossConnectionsRoutesTableSummaryListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for ListRoutesTable associated with the Express Route Cross Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of the routes table.
    :vartype value:
     list[~azure.mgmt.network.models.ExpressRouteCrossConnectionRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCrossConnectionRoutesTableSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExpressRouteCrossConnectionRoutesTableSummary"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of the routes table.
        :paramtype value:
         list[~azure.mgmt.network.models.ExpressRouteCrossConnectionRoutesTableSummary]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class GetVpnSitesConfigurationRequest(_serialization.Model):
    """List of Vpn-Sites.

    All required parameters must be populated in order to send to server.

    :ivar vpn_sites: List of resource-ids of the vpn-sites for which config is to be downloaded.
    :vartype vpn_sites: list[str]
    :ivar output_blob_sas_url: The sas-url to download the configurations for vpn-sites. Required.
    :vartype output_blob_sas_url: str
    """

    _validation = {
        "output_blob_sas_url": {"required": True},
    }

    _attribute_map = {
        "vpn_sites": {"key": "vpnSites", "type": "[str]"},
        "output_blob_sas_url": {"key": "outputBlobSasUrl", "type": "str"},
    }

    def __init__(self, *, output_blob_sas_url: str, vpn_sites: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword vpn_sites: List of resource-ids of the vpn-sites for which config is to be downloaded.
        :paramtype vpn_sites: list[str]
        :keyword output_blob_sas_url: The sas-url to download the configurations for vpn-sites.
         Required.
        :paramtype output_blob_sas_url: str
        """
        super().__init__(**kwargs)
        self.vpn_sites = vpn_sites
        self.output_blob_sas_url = output_blob_sas_url

class HTTPConfiguration(_serialization.Model):
    """HTTP configuration of the connectivity check.

    :ivar method: HTTP method. "Get"
    :vartype method: str or ~azure.mgmt.network.models.HTTPMethod
    :ivar headers: List of HTTP headers.
    :vartype headers: list[~azure.mgmt.network.models.HTTPHeader]
    :ivar valid_status_codes: Valid status codes.
    :vartype valid_status_codes: list[int]
    """

    _attribute_map = {
        "method": {"key": "method", "type": "str"},
        "headers": {"key": "headers", "type": "[HTTPHeader]"},
        "valid_status_codes": {"key": "validStatusCodes", "type": "[int]"},
    }

    def __init__(
        self,
        *,
        method: Optional[Union[str, "_models.HTTPMethod"]] = None,
        headers: Optional[List["_models.HTTPHeader"]] = None,
        valid_status_codes: Optional[List[int]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword method: HTTP method. "Get"
        :paramtype method: str or ~azure.mgmt.network.models.HTTPMethod
        :keyword headers: List of HTTP headers.
        :paramtype headers: list[~azure.mgmt.network.models.HTTPHeader]
        :keyword valid_status_codes: Valid status codes.
        :paramtype valid_status_codes: list[int]
        """
        super().__init__(**kwargs)
        self.method = method
        self.headers = headers
        self.valid_status_codes = valid_status_codes

class HTTPHeader(_serialization.Model):
    """The HTTP header.

    :ivar name: The name in HTTP header.
    :vartype name: str
    :ivar value: The value in HTTP header.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name in HTTP header.
        :paramtype name: str
        :keyword value: The value in HTTP header.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value

class HubVirtualNetworkConnection(SubResource):
    """HubVirtualNetworkConnection Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar remote_virtual_network: Reference to the remote virtual network.
    :vartype remote_virtual_network: ~azure.mgmt.network.models.SubResource
    :ivar allow_hub_to_remote_vnet_transit: Deprecated: VirtualHub to RemoteVnet transit to enabled
     or not.
    :vartype allow_hub_to_remote_vnet_transit: bool
    :ivar allow_remote_vnet_to_use_hub_vnet_gateways: Deprecated: Allow RemoteVnet to use Virtual
     Hub's gateways.
    :vartype allow_remote_vnet_to_use_hub_vnet_gateways: bool
    :ivar enable_internet_security: Enable internet security.
    :vartype enable_internet_security: bool
    :ivar routing_configuration: The Routing Configuration indicating the associated and propagated
     route tables on this connection.
    :vartype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
    :ivar provisioning_state: The provisioning state of the hub virtual network connection
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "remote_virtual_network": {"key": "properties.remoteVirtualNetwork", "type": "SubResource"},
        "allow_hub_to_remote_vnet_transit": {"key": "properties.allowHubToRemoteVnetTransit", "type": "bool"},
        "allow_remote_vnet_to_use_hub_vnet_gateways": {
            "key": "properties.allowRemoteVnetToUseHubVnetGateways",
            "type": "bool",
        },
        "enable_internet_security": {"key": "properties.enableInternetSecurity", "type": "bool"},
        "routing_configuration": {"key": "properties.routingConfiguration", "type": "RoutingConfiguration"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        remote_virtual_network: Optional["_models.SubResource"] = None,
        allow_hub_to_remote_vnet_transit: Optional[bool] = None,
        allow_remote_vnet_to_use_hub_vnet_gateways: Optional[bool] = None,
        enable_internet_security: Optional[bool] = None,
        routing_configuration: Optional["_models.RoutingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword remote_virtual_network: Reference to the remote virtual network.
        :paramtype remote_virtual_network: ~azure.mgmt.network.models.SubResource
        :keyword allow_hub_to_remote_vnet_transit: Deprecated: VirtualHub to RemoteVnet transit to
         enabled or not.
        :paramtype allow_hub_to_remote_vnet_transit: bool
        :keyword allow_remote_vnet_to_use_hub_vnet_gateways: Deprecated: Allow RemoteVnet to use
         Virtual Hub's gateways.
        :paramtype allow_remote_vnet_to_use_hub_vnet_gateways: bool
        :keyword enable_internet_security: Enable internet security.
        :paramtype enable_internet_security: bool
        :keyword routing_configuration: The Routing Configuration indicating the associated and
         propagated route tables on this connection.
        :paramtype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.remote_virtual_network = remote_virtual_network
        self.allow_hub_to_remote_vnet_transit = allow_hub_to_remote_vnet_transit
        self.allow_remote_vnet_to_use_hub_vnet_gateways = allow_remote_vnet_to_use_hub_vnet_gateways
        self.enable_internet_security = enable_internet_security
        self.routing_configuration = routing_configuration
        self.provisioning_state = None

class IpTag(_serialization.Model):
    """Contains the IpTag associated with the object.

    :ivar ip_tag_type: The IP tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: The value of the IP tag associated with the public IP. Example: SQL.
    :vartype tag: str
    """

    _attribute_map = {
        "ip_tag_type": {"key": "ipTagType", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
    }

    def __init__(self, *, ip_tag_type: Optional[str] = None, tag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_tag_type: The IP tag type. Example: FirstPartyUsage.
        :paramtype ip_tag_type: str
        :keyword tag: The value of the IP tag associated with the public IP. Example: SQL.
        :paramtype tag: str
        """
        super().__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag

class ListHubVirtualNetworkConnectionsResult(_serialization.Model):
    """List of HubVirtualNetworkConnections and a URL nextLink to get the next set of results.

    :ivar value: List of HubVirtualNetworkConnections.
    :vartype value: list[~azure.mgmt.network.models.HubVirtualNetworkConnection]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[HubVirtualNetworkConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.HubVirtualNetworkConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of HubVirtualNetworkConnections.
        :paramtype value: list[~azure.mgmt.network.models.HubVirtualNetworkConnection]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ListVirtualHubsResult(_serialization.Model):
    """Result of the request to list VirtualHubs. It contains a list of VirtualHubs and a URL nextLink
    to get the next set of results.

    :ivar value: List of VirtualHubs.
    :vartype value: list[~azure.mgmt.network.models.VirtualHub]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualHub]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualHub"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of VirtualHubs.
        :paramtype value: list[~azure.mgmt.network.models.VirtualHub]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ListVirtualWANsResult(_serialization.Model):
    """Result of the request to list VirtualWANs. It contains a list of VirtualWANs and a URL nextLink
    to get the next set of results.

    :ivar value: List of VirtualWANs.
    :vartype value: list[~azure.mgmt.network.models.VirtualWAN]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualWAN]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualWAN"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of VirtualWANs.
        :paramtype value: list[~azure.mgmt.network.models.VirtualWAN]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ListVpnConnectionsResult(_serialization.Model):
    """Result of the request to list all vpn connections to a virtual wan vpn gateway. It contains a
    list of Vpn Connections and a URL nextLink to get the next set of results.

    :ivar value: List of Vpn Connections.
    :vartype value: list[~azure.mgmt.network.models.VpnConnection]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VpnConnection"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Vpn Connections.
        :paramtype value: list[~azure.mgmt.network.models.VpnConnection]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ListVpnGatewaysResult(_serialization.Model):
    """Result of the request to list VpnGateways. It contains a list of VpnGateways and a URL nextLink
    to get the next set of results.

    :ivar value: List of VpnGateways.
    :vartype value: list[~azure.mgmt.network.models.VpnGateway]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VpnGateway"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of VpnGateways.
        :paramtype value: list[~azure.mgmt.network.models.VpnGateway]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ListVpnSitesResult(_serialization.Model):
    """Result of the request to list VpnSites. It contains a list of VpnSites and a URL nextLink to
    get the next set of results.

    :ivar value: List of VpnSites.
    :vartype value: list[~azure.mgmt.network.models.VpnSite]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VpnSite]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VpnSite"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of VpnSites.
        :paramtype value: list[~azure.mgmt.network.models.VpnSite]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class Policies(_serialization.Model):
    """Policies for vpn gateway.

    :ivar allow_branch_to_branch_traffic: True if branch to branch traffic is allowed.
    :vartype allow_branch_to_branch_traffic: bool
    :ivar allow_vnet_to_vnet_traffic: True if Vnet to Vnet traffic is allowed.
    :vartype allow_vnet_to_vnet_traffic: bool
    """

    _attribute_map = {
        "allow_branch_to_branch_traffic": {"key": "allowBranchToBranchTraffic", "type": "bool"},
        "allow_vnet_to_vnet_traffic": {"key": "allowVnetToVnetTraffic", "type": "bool"},
    }

    def __init__(
        self,
        *,
        allow_branch_to_branch_traffic: Optional[bool] = None,
        allow_vnet_to_vnet_traffic: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow_branch_to_branch_traffic: True if branch to branch traffic is allowed.
        :paramtype allow_branch_to_branch_traffic: bool
        :keyword allow_vnet_to_vnet_traffic: True if Vnet to Vnet traffic is allowed.
        :paramtype allow_vnet_to_vnet_traffic: bool
        """
        super().__init__(**kwargs)
        self.allow_branch_to_branch_traffic = allow_branch_to_branch_traffic
        self.allow_vnet_to_vnet_traffic = allow_vnet_to_vnet_traffic

class ProtocolConfiguration(_serialization.Model):
    """Configuration of the protocol.

    :ivar http_configuration: HTTP configuration of the connectivity check.
    :vartype http_configuration: ~azure.mgmt.network.models.HTTPConfiguration
    """

    _attribute_map = {
        "http_configuration": {"key": "HTTPConfiguration", "type": "HTTPConfiguration"},
    }

    def __init__(self, *, http_configuration: Optional["_models.HTTPConfiguration"] = None, **kwargs: Any) -> None:
        """
        :keyword http_configuration: HTTP configuration of the connectivity check.
        :paramtype http_configuration: ~azure.mgmt.network.models.HTTPConfiguration
        """
        super().__init__(**kwargs)
        self.http_configuration = http_configuration

class TrafficAnalyticsConfigurationProperties(_serialization.Model):
    """Parameters that define the configuration of traffic analytics.

    :ivar enabled: Flag to enable/disable traffic analytics.
    :vartype enabled: bool
    :ivar workspace_id: The resource guid of the attached workspace.
    :vartype workspace_id: str
    :ivar workspace_region: The location of the attached workspace.
    :vartype workspace_region: str
    :ivar workspace_resource_id: Resource Id of the attached workspace.
    :vartype workspace_resource_id: str
    :ivar traffic_analytics_interval: The interval in minutes which would decide how frequently TA
     service should do flow analytics.
    :vartype traffic_analytics_interval: int
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "workspace_region": {"key": "workspaceRegion", "type": "str"},
        "workspace_resource_id": {"key": "workspaceResourceId", "type": "str"},
        "traffic_analytics_interval": {"key": "trafficAnalyticsInterval", "type": "int"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workspace_id: Optional[str] = None,
        workspace_region: Optional[str] = None,
        workspace_resource_id: Optional[str] = None,
        traffic_analytics_interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Flag to enable/disable traffic analytics.
        :paramtype enabled: bool
        :keyword workspace_id: The resource guid of the attached workspace.
        :paramtype workspace_id: str
        :keyword workspace_region: The location of the attached workspace.
        :paramtype workspace_region: str
        :keyword workspace_resource_id: Resource Id of the attached workspace.
        :paramtype workspace_resource_id: str
        :keyword traffic_analytics_interval: The interval in minutes which would decide how frequently
         TA service should do flow analytics.
        :paramtype traffic_analytics_interval: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workspace_id = workspace_id
        self.workspace_region = workspace_region
        self.workspace_resource_id = workspace_resource_id
        self.traffic_analytics_interval = traffic_analytics_interval

class TrafficAnalyticsProperties(_serialization.Model):
    """Parameters that define the configuration of traffic analytics.

    :ivar network_watcher_flow_analytics_configuration: Parameters that define the configuration of
     traffic analytics.
    :vartype network_watcher_flow_analytics_configuration:
     ~azure.mgmt.network.models.TrafficAnalyticsConfigurationProperties
    """

    _attribute_map = {
        "network_watcher_flow_analytics_configuration": {
            "key": "networkWatcherFlowAnalyticsConfiguration",
            "type": "TrafficAnalyticsConfigurationProperties",
        },
    }

    def __init__(
        self,
        *,
        network_watcher_flow_analytics_configuration: Optional[
            "_models.TrafficAnalyticsConfigurationProperties"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_watcher_flow_analytics_configuration: Parameters that define the configuration
         of traffic analytics.
        :paramtype network_watcher_flow_analytics_configuration:
         ~azure.mgmt.network.models.TrafficAnalyticsConfigurationProperties
        """
        super().__init__(**kwargs)
        self.network_watcher_flow_analytics_configuration = network_watcher_flow_analytics_configuration

class VirtualHub(Resource):  # pylint: disable=too-many-instance-attributes
    """VirtualHub Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Kind of service virtual hub. This is metadata used for the Azure portal experience
     for Route Server.
    :vartype kind: str
    :ivar virtual_wan: The VirtualWAN to which the VirtualHub belongs.
    :vartype virtual_wan: ~azure.mgmt.network.models.SubResource
    :ivar vpn_gateway: The VpnGateway associated with this VirtualHub.
    :vartype vpn_gateway: ~azure.mgmt.network.models.SubResource
    :ivar p2_s_vpn_gateway: The P2SVpnGateway associated with this VirtualHub.
    :vartype p2_s_vpn_gateway: ~azure.mgmt.network.models.SubResource
    :ivar express_route_gateway: The expressRouteGateway associated with this VirtualHub.
    :vartype express_route_gateway: ~azure.mgmt.network.models.SubResource
    :ivar azure_firewall: The azureFirewall associated with this VirtualHub.
    :vartype azure_firewall: ~azure.mgmt.network.models.SubResource
    :ivar security_partner_provider: The securityPartnerProvider associated with this VirtualHub.
    :vartype security_partner_provider: ~azure.mgmt.network.models.SubResource
    :ivar address_prefix: Address-prefix for this VirtualHub.
    :vartype address_prefix: str
    :ivar route_table: The routeTable associated with this virtual hub.
    :vartype route_table: ~azure.mgmt.network.models.VirtualHubRouteTable
    :ivar provisioning_state: The provisioning state of the virtual hub resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar security_provider_name: The Security Provider name.
    :vartype security_provider_name: str
    :ivar virtual_hub_route_table_v2_s: List of all virtual hub route table v2s associated with
     this VirtualHub.
    :vartype virtual_hub_route_table_v2_s:
     list[~azure.mgmt.network.models.VirtualHubRouteTableV2]
    :ivar sku: The sku of this VirtualHub.
    :vartype sku: str
    :ivar routing_state: The routing state. Known values are: "None", "Provisioned",
     "Provisioning", and "Failed".
    :vartype routing_state: str or ~azure.mgmt.network.models.RoutingState
    :ivar bgp_connections: List of references to Bgp Connections.
    :vartype bgp_connections: list[~azure.mgmt.network.models.SubResource]
    :ivar ip_configurations: List of references to IpConfigurations.
    :vartype ip_configurations: list[~azure.mgmt.network.models.SubResource]
    :ivar route_maps: List of references to RouteMaps.
    :vartype route_maps: list[~azure.mgmt.network.models.SubResource]
    :ivar virtual_router_asn: VirtualRouter ASN.
    :vartype virtual_router_asn: int
    :ivar virtual_router_ips: VirtualRouter IPs.
    :vartype virtual_router_ips: list[str]
    :ivar allow_branch_to_branch_traffic: Flag to control transit for VirtualRouter hub.
    :vartype allow_branch_to_branch_traffic: bool
    :ivar preferred_routing_gateway: The preferred gateway to route on-prem traffic. Known values
     are: "ExpressRoute", "VpnGateway", and "None".
    :vartype preferred_routing_gateway: str or
     ~azure.mgmt.network.models.PreferredRoutingGateway
    :ivar hub_routing_preference: The hubRoutingPreference of this VirtualHub. Known values are:
     "ExpressRoute", "VpnGateway", and "ASPath".
    :vartype hub_routing_preference: str or
     ~azure.mgmt.network.models.HubRoutingPreference
    :ivar virtual_router_auto_scale_configuration: The VirtualHub Router autoscale configuration.
    :vartype virtual_router_auto_scale_configuration:
     ~azure.mgmt.network.models.VirtualRouterAutoScaleConfiguration
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "routing_state": {"readonly": True},
        "bgp_connections": {"readonly": True},
        "ip_configurations": {"readonly": True},
        "route_maps": {"readonly": True},
        "virtual_router_asn": {"maximum": 4294967295, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "virtual_wan": {"key": "properties.virtualWan", "type": "SubResource"},
        "vpn_gateway": {"key": "properties.vpnGateway", "type": "SubResource"},
        "p2_s_vpn_gateway": {"key": "properties.p2SVpnGateway", "type": "SubResource"},
        "express_route_gateway": {"key": "properties.expressRouteGateway", "type": "SubResource"},
        "azure_firewall": {"key": "properties.azureFirewall", "type": "SubResource"},
        "security_partner_provider": {"key": "properties.securityPartnerProvider", "type": "SubResource"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "route_table": {"key": "properties.routeTable", "type": "VirtualHubRouteTable"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "security_provider_name": {"key": "properties.securityProviderName", "type": "str"},
        "virtual_hub_route_table_v2_s": {
            "key": "properties.virtualHubRouteTableV2s",
            "type": "[VirtualHubRouteTableV2]",
        },
        "sku": {"key": "properties.sku", "type": "str"},
        "routing_state": {"key": "properties.routingState", "type": "str"},
        "bgp_connections": {"key": "properties.bgpConnections", "type": "[SubResource]"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[SubResource]"},
        "route_maps": {"key": "properties.routeMaps", "type": "[SubResource]"},
        "virtual_router_asn": {"key": "properties.virtualRouterAsn", "type": "int"},
        "virtual_router_ips": {"key": "properties.virtualRouterIps", "type": "[str]"},
        "allow_branch_to_branch_traffic": {"key": "properties.allowBranchToBranchTraffic", "type": "bool"},
        "preferred_routing_gateway": {"key": "properties.preferredRoutingGateway", "type": "str"},
        "hub_routing_preference": {"key": "properties.hubRoutingPreference", "type": "str"},
        "virtual_router_auto_scale_configuration": {
            "key": "properties.virtualRouterAutoScaleConfiguration",
            "type": "VirtualRouterAutoScaleConfiguration",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_wan: Optional["_models.SubResource"] = None,
        vpn_gateway: Optional["_models.SubResource"] = None,
        p2_s_vpn_gateway: Optional["_models.SubResource"] = None,
        express_route_gateway: Optional["_models.SubResource"] = None,
        azure_firewall: Optional["_models.SubResource"] = None,
        security_partner_provider: Optional["_models.SubResource"] = None,
        address_prefix: Optional[str] = None,
        route_table: Optional["_models.VirtualHubRouteTable"] = None,
        security_provider_name: Optional[str] = None,
        virtual_hub_route_table_v2_s: Optional[List["_models.VirtualHubRouteTableV2"]] = None,
        sku: Optional[str] = None,
        virtual_router_asn: Optional[int] = None,
        virtual_router_ips: Optional[List[str]] = None,
        allow_branch_to_branch_traffic: Optional[bool] = None,
        preferred_routing_gateway: Optional[Union[str, "_models.PreferredRoutingGateway"]] = None,
        hub_routing_preference: Optional[Union[str, "_models.HubRoutingPreference"]] = None,
        virtual_router_auto_scale_configuration: Optional["_models.VirtualRouterAutoScaleConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_wan: The VirtualWAN to which the VirtualHub belongs.
        :paramtype virtual_wan: ~azure.mgmt.network.models.SubResource
        :keyword vpn_gateway: The VpnGateway associated with this VirtualHub.
        :paramtype vpn_gateway: ~azure.mgmt.network.models.SubResource
        :keyword p2_s_vpn_gateway: The P2SVpnGateway associated with this VirtualHub.
        :paramtype p2_s_vpn_gateway: ~azure.mgmt.network.models.SubResource
        :keyword express_route_gateway: The expressRouteGateway associated with this VirtualHub.
        :paramtype express_route_gateway: ~azure.mgmt.network.models.SubResource
        :keyword azure_firewall: The azureFirewall associated with this VirtualHub.
        :paramtype azure_firewall: ~azure.mgmt.network.models.SubResource
        :keyword security_partner_provider: The securityPartnerProvider associated with this
         VirtualHub.
        :paramtype security_partner_provider: ~azure.mgmt.network.models.SubResource
        :keyword address_prefix: Address-prefix for this VirtualHub.
        :paramtype address_prefix: str
        :keyword route_table: The routeTable associated with this virtual hub.
        :paramtype route_table: ~azure.mgmt.network.models.VirtualHubRouteTable
        :keyword security_provider_name: The Security Provider name.
        :paramtype security_provider_name: str
        :keyword virtual_hub_route_table_v2_s: List of all virtual hub route table v2s associated with
         this VirtualHub.
        :paramtype virtual_hub_route_table_v2_s:
         list[~azure.mgmt.network.models.VirtualHubRouteTableV2]
        :keyword sku: The sku of this VirtualHub.
        :paramtype sku: str
        :keyword virtual_router_asn: VirtualRouter ASN.
        :paramtype virtual_router_asn: int
        :keyword virtual_router_ips: VirtualRouter IPs.
        :paramtype virtual_router_ips: list[str]
        :keyword allow_branch_to_branch_traffic: Flag to control transit for VirtualRouter hub.
        :paramtype allow_branch_to_branch_traffic: bool
        :keyword preferred_routing_gateway: The preferred gateway to route on-prem traffic. Known
         values are: "ExpressRoute", "VpnGateway", and "None".
        :paramtype preferred_routing_gateway: str or
         ~azure.mgmt.network.models.PreferredRoutingGateway
        :keyword hub_routing_preference: The hubRoutingPreference of this VirtualHub. Known values are:
         "ExpressRoute", "VpnGateway", and "ASPath".
        :paramtype hub_routing_preference: str or
         ~azure.mgmt.network.models.HubRoutingPreference
        :keyword virtual_router_auto_scale_configuration: The VirtualHub Router autoscale
         configuration.
        :paramtype virtual_router_auto_scale_configuration:
         ~azure.mgmt.network.models.VirtualRouterAutoScaleConfiguration
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.kind = None
        self.virtual_wan = virtual_wan
        self.vpn_gateway = vpn_gateway
        self.p2_s_vpn_gateway = p2_s_vpn_gateway
        self.express_route_gateway = express_route_gateway
        self.azure_firewall = azure_firewall
        self.security_partner_provider = security_partner_provider
        self.address_prefix = address_prefix
        self.route_table = route_table
        self.provisioning_state = None
        self.security_provider_name = security_provider_name
        self.virtual_hub_route_table_v2_s = virtual_hub_route_table_v2_s
        self.sku = sku
        self.routing_state = None
        self.bgp_connections = None
        self.ip_configurations = None
        self.route_maps = None
        self.virtual_router_asn = virtual_router_asn
        self.virtual_router_ips = virtual_router_ips
        self.allow_branch_to_branch_traffic = allow_branch_to_branch_traffic
        self.preferred_routing_gateway = preferred_routing_gateway
        self.hub_routing_preference = hub_routing_preference
        self.virtual_router_auto_scale_configuration = virtual_router_auto_scale_configuration

class VirtualWAN(Resource):  # pylint: disable=too-many-instance-attributes
    """VirtualWAN Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar disable_vpn_encryption: Vpn encryption to be disabled or not.
    :vartype disable_vpn_encryption: bool
    :ivar virtual_hubs: List of VirtualHubs in the VirtualWAN.
    :vartype virtual_hubs: list[~azure.mgmt.network.models.SubResource]
    :ivar vpn_sites: List of VpnSites in the VirtualWAN.
    :vartype vpn_sites: list[~azure.mgmt.network.models.SubResource]
    :ivar allow_branch_to_branch_traffic: True if branch to branch traffic is allowed.
    :vartype allow_branch_to_branch_traffic: bool
    :ivar allow_vnet_to_vnet_traffic: True if Vnet to Vnet traffic is allowed.
    :vartype allow_vnet_to_vnet_traffic: bool
    :ivar office365_local_breakout_category: The office local breakout category. Known values are:
     "Optimize", "OptimizeAndAllow", "All", and "None".
    :vartype office365_local_breakout_category: str or
     ~azure.mgmt.network.models.OfficeTrafficCategory
    :ivar provisioning_state: The provisioning state of the virtual WAN resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar type_properties_type: The type of the VirtualWAN.
    :vartype type_properties_type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "virtual_hubs": {"readonly": True},
        "vpn_sites": {"readonly": True},
        "office365_local_breakout_category": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "disable_vpn_encryption": {"key": "properties.disableVpnEncryption", "type": "bool"},
        "virtual_hubs": {"key": "properties.virtualHubs", "type": "[SubResource]"},
        "vpn_sites": {"key": "properties.vpnSites", "type": "[SubResource]"},
        "allow_branch_to_branch_traffic": {"key": "properties.allowBranchToBranchTraffic", "type": "bool"},
        "allow_vnet_to_vnet_traffic": {"key": "properties.allowVnetToVnetTraffic", "type": "bool"},
        "office365_local_breakout_category": {"key": "properties.office365LocalBreakoutCategory", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        disable_vpn_encryption: Optional[bool] = None,
        allow_branch_to_branch_traffic: Optional[bool] = None,
        allow_vnet_to_vnet_traffic: Optional[bool] = None,
        type_properties_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword disable_vpn_encryption: Vpn encryption to be disabled or not.
        :paramtype disable_vpn_encryption: bool
        :keyword allow_branch_to_branch_traffic: True if branch to branch traffic is allowed.
        :paramtype allow_branch_to_branch_traffic: bool
        :keyword allow_vnet_to_vnet_traffic: True if Vnet to Vnet traffic is allowed.
        :paramtype allow_vnet_to_vnet_traffic: bool
        :keyword type_properties_type: The type of the VirtualWAN.
        :paramtype type_properties_type: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.disable_vpn_encryption = disable_vpn_encryption
        self.virtual_hubs = None
        self.vpn_sites = None
        self.allow_branch_to_branch_traffic = allow_branch_to_branch_traffic
        self.allow_vnet_to_vnet_traffic = allow_vnet_to_vnet_traffic
        self.office365_local_breakout_category = None
        self.provisioning_state = None
        self.type_properties_type = type_properties_type

class VpnClientIPsecParameters(_serialization.Model):
    """An IPSec parameters for a virtual network gateway P2S connection.

    All required parameters must be populated in order to send to server.

    :ivar sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) lifetime in seconds for P2S client. Required.
    :vartype sa_life_time_seconds: int
    :ivar sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or Phase 2
     SA) payload size in KB for P2S client.. Required.
    :vartype sa_data_size_kilobytes: int
    :ivar ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
     are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
     "GCMAES256".
    :vartype ipsec_encryption: str or ~azure.mgmt.network.models.IpsecEncryption
    :ivar ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values are:
     "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
    :vartype ipsec_integrity: str or ~azure.mgmt.network.models.IpsecIntegrity
    :ivar ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values are:
     "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", and "GCMAES128".
    :vartype ike_encryption: str or ~azure.mgmt.network.models.IkeEncryption
    :ivar ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
     "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", and "GCMAES128".
    :vartype ike_integrity: str or ~azure.mgmt.network.models.IkeIntegrity
    :ivar dh_group: The DH Group used in IKE Phase 1 for initial SA. Required. Known values are:
     "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
     "DHGroup24".
    :vartype dh_group: str or ~azure.mgmt.network.models.DhGroup
    :ivar pfs_group: The Pfs Group used in IKE Phase 2 for new child SA. Required. Known values
     are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", and "PFSMM".
    :vartype pfs_group: str or ~azure.mgmt.network.models.PfsGroup
    """

    _validation = {
        "sa_life_time_seconds": {"required": True},
        "sa_data_size_kilobytes": {"required": True},
        "ipsec_encryption": {"required": True},
        "ipsec_integrity": {"required": True},
        "ike_encryption": {"required": True},
        "ike_integrity": {"required": True},
        "dh_group": {"required": True},
        "pfs_group": {"required": True},
    }

    _attribute_map = {
        "sa_life_time_seconds": {"key": "saLifeTimeSeconds", "type": "int"},
        "sa_data_size_kilobytes": {"key": "saDataSizeKilobytes", "type": "int"},
        "ipsec_encryption": {"key": "ipsecEncryption", "type": "str"},
        "ipsec_integrity": {"key": "ipsecIntegrity", "type": "str"},
        "ike_encryption": {"key": "ikeEncryption", "type": "str"},
        "ike_integrity": {"key": "ikeIntegrity", "type": "str"},
        "dh_group": {"key": "dhGroup", "type": "str"},
        "pfs_group": {"key": "pfsGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        sa_life_time_seconds: int,
        sa_data_size_kilobytes: int,
        ipsec_encryption: Union[str, "_models.IpsecEncryption"],
        ipsec_integrity: Union[str, "_models.IpsecIntegrity"],
        ike_encryption: Union[str, "_models.IkeEncryption"],
        ike_integrity: Union[str, "_models.IkeIntegrity"],
        dh_group: Union[str, "_models.DhGroup"],
        pfs_group: Union[str, "_models.PfsGroup"],
        **kwargs: Any
    ) -> None:
        """
        :keyword sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase
         2 SA) lifetime in seconds for P2S client. Required.
        :paramtype sa_life_time_seconds: int
        :keyword sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or
         Phase 2 SA) payload size in KB for P2S client.. Required.
        :paramtype sa_data_size_kilobytes: int
        :keyword ipsec_encryption: The IPSec encryption algorithm (IKE phase 1). Required. Known values
         are: "None", "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES128", "GCMAES192", and
         "GCMAES256".
        :paramtype ipsec_encryption: str or ~azure.mgmt.network.models.IpsecEncryption
        :keyword ipsec_integrity: The IPSec integrity algorithm (IKE phase 1). Required. Known values
         are: "MD5", "SHA1", "SHA256", "GCMAES128", "GCMAES192", and "GCMAES256".
        :paramtype ipsec_integrity: str or ~azure.mgmt.network.models.IpsecIntegrity
        :keyword ike_encryption: The IKE encryption algorithm (IKE phase 2). Required. Known values
         are: "DES", "DES3", "AES128", "AES192", "AES256", "GCMAES256", and "GCMAES128".
        :paramtype ike_encryption: str or ~azure.mgmt.network.models.IkeEncryption
        :keyword ike_integrity: The IKE integrity algorithm (IKE phase 2). Required. Known values are:
         "MD5", "SHA1", "SHA256", "SHA384", "GCMAES256", and "GCMAES128".
        :paramtype ike_integrity: str or ~azure.mgmt.network.models.IkeIntegrity
        :keyword dh_group: The DH Group used in IKE Phase 1 for initial SA. Required. Known values are:
         "None", "DHGroup1", "DHGroup2", "DHGroup14", "DHGroup2048", "ECP256", "ECP384", and
         "DHGroup24".
        :paramtype dh_group: str or ~azure.mgmt.network.models.DhGroup
        :keyword pfs_group: The Pfs Group used in IKE Phase 2 for new child SA. Required. Known values
         are: "None", "PFS1", "PFS2", "PFS2048", "ECP256", "ECP384", "PFS24", "PFS14", and "PFSMM".
        :paramtype pfs_group: str or ~azure.mgmt.network.models.PfsGroup
        """
        super().__init__(**kwargs)
        self.sa_life_time_seconds = sa_life_time_seconds
        self.sa_data_size_kilobytes = sa_data_size_kilobytes
        self.ipsec_encryption = ipsec_encryption
        self.ipsec_integrity = ipsec_integrity
        self.ike_encryption = ike_encryption
        self.ike_integrity = ike_integrity
        self.dh_group = dh_group
        self.pfs_group = pfs_group

class VpnConnection(SubResource):  # pylint: disable=too-many-instance-attributes
    """VpnConnection Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar remote_vpn_site: Id of the connected vpn site.
    :vartype remote_vpn_site: ~azure.mgmt.network.models.SubResource
    :ivar routing_weight: Routing weight for vpn connection.
    :vartype routing_weight: int
    :ivar dpd_timeout_seconds: DPD timeout in seconds for vpn connection.
    :vartype dpd_timeout_seconds: int
    :ivar connection_status: The connection status. Known values are: "Unknown", "Connecting",
     "Connected", and "NotConnected".
    :vartype connection_status: str or ~azure.mgmt.network.models.VpnConnectionStatus
    :ivar vpn_connection_protocol_type: Connection protocol used for this connection. Known values
     are: "IKEv2" and "IKEv1".
    :vartype vpn_connection_protocol_type: str or
     ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionProtocol
    :ivar ingress_bytes_transferred: Ingress bytes transferred.
    :vartype ingress_bytes_transferred: int
    :ivar egress_bytes_transferred: Egress bytes transferred.
    :vartype egress_bytes_transferred: int
    :ivar connection_bandwidth: Expected bandwidth in MBPS.
    :vartype connection_bandwidth: int
    :ivar shared_key: SharedKey for the vpn connection.
    :vartype shared_key: str
    :ivar enable_bgp: EnableBgp flag.
    :vartype enable_bgp: bool
    :ivar use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
    :vartype use_policy_based_traffic_selectors: bool
    :ivar ipsec_policies: The IPSec Policies to be considered by this connection.
    :vartype ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
    :ivar traffic_selector_policies: The Traffic Selector Policies to be considered by this
     connection.
    :vartype traffic_selector_policies:
     list[~azure.mgmt.network.models.TrafficSelectorPolicy]
    :ivar enable_rate_limiting: EnableBgp flag.
    :vartype enable_rate_limiting: bool
    :ivar enable_internet_security: Enable internet security.
    :vartype enable_internet_security: bool
    :ivar use_local_azure_ip_address: Use local azure ip to initiate connection.
    :vartype use_local_azure_ip_address: bool
    :ivar provisioning_state: The provisioning state of the VPN connection resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar vpn_link_connections: List of all vpn site link connections to the gateway.
    :vartype vpn_link_connections:
     list[~azure.mgmt.network.models.VpnSiteLinkConnection]
    :ivar routing_configuration: The Routing Configuration indicating the associated and propagated
     route tables on this connection.
    :vartype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
    """

    _validation = {
        "etag": {"readonly": True},
        "connection_status": {"readonly": True},
        "ingress_bytes_transferred": {"readonly": True},
        "egress_bytes_transferred": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "remote_vpn_site": {"key": "properties.remoteVpnSite", "type": "SubResource"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "dpd_timeout_seconds": {"key": "properties.dpdTimeoutSeconds", "type": "int"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "vpn_connection_protocol_type": {"key": "properties.vpnConnectionProtocolType", "type": "str"},
        "ingress_bytes_transferred": {"key": "properties.ingressBytesTransferred", "type": "int"},
        "egress_bytes_transferred": {"key": "properties.egressBytesTransferred", "type": "int"},
        "connection_bandwidth": {"key": "properties.connectionBandwidth", "type": "int"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "use_policy_based_traffic_selectors": {"key": "properties.usePolicyBasedTrafficSelectors", "type": "bool"},
        "ipsec_policies": {"key": "properties.ipsecPolicies", "type": "[IpsecPolicy]"},
        "traffic_selector_policies": {"key": "properties.trafficSelectorPolicies", "type": "[TrafficSelectorPolicy]"},
        "enable_rate_limiting": {"key": "properties.enableRateLimiting", "type": "bool"},
        "enable_internet_security": {"key": "properties.enableInternetSecurity", "type": "bool"},
        "use_local_azure_ip_address": {"key": "properties.useLocalAzureIpAddress", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "vpn_link_connections": {"key": "properties.vpnLinkConnections", "type": "[VpnSiteLinkConnection]"},
        "routing_configuration": {"key": "properties.routingConfiguration", "type": "RoutingConfiguration"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        remote_vpn_site: Optional["_models.SubResource"] = None,
        routing_weight: Optional[int] = None,
        dpd_timeout_seconds: Optional[int] = None,
        vpn_connection_protocol_type: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionProtocol"]] = None,
        connection_bandwidth: Optional[int] = None,
        shared_key: Optional[str] = None,
        enable_bgp: Optional[bool] = None,
        use_policy_based_traffic_selectors: Optional[bool] = None,
        ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        traffic_selector_policies: Optional[List["_models.TrafficSelectorPolicy"]] = None,
        enable_rate_limiting: Optional[bool] = None,
        enable_internet_security: Optional[bool] = None,
        use_local_azure_ip_address: Optional[bool] = None,
        vpn_link_connections: Optional[List["_models.VpnSiteLinkConnection"]] = None,
        routing_configuration: Optional["_models.RoutingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword remote_vpn_site: Id of the connected vpn site.
        :paramtype remote_vpn_site: ~azure.mgmt.network.models.SubResource
        :keyword routing_weight: Routing weight for vpn connection.
        :paramtype routing_weight: int
        :keyword dpd_timeout_seconds: DPD timeout in seconds for vpn connection.
        :paramtype dpd_timeout_seconds: int
        :keyword vpn_connection_protocol_type: Connection protocol used for this connection. Known
         values are: "IKEv2" and "IKEv1".
        :paramtype vpn_connection_protocol_type: str or
         ~azure.mgmt.network.models.VirtualNetworkGatewayConnectionProtocol
        :keyword connection_bandwidth: Expected bandwidth in MBPS.
        :paramtype connection_bandwidth: int
        :keyword shared_key: SharedKey for the vpn connection.
        :paramtype shared_key: str
        :keyword enable_bgp: EnableBgp flag.
        :paramtype enable_bgp: bool
        :keyword use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :paramtype use_policy_based_traffic_selectors: bool
        :keyword ipsec_policies: The IPSec Policies to be considered by this connection.
        :paramtype ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
        :keyword traffic_selector_policies: The Traffic Selector Policies to be considered by this
         connection.
        :paramtype traffic_selector_policies:
         list[~azure.mgmt.network.models.TrafficSelectorPolicy]
        :keyword enable_rate_limiting: EnableBgp flag.
        :paramtype enable_rate_limiting: bool
        :keyword enable_internet_security: Enable internet security.
        :paramtype enable_internet_security: bool
        :keyword use_local_azure_ip_address: Use local azure ip to initiate connection.
        :paramtype use_local_azure_ip_address: bool
        :keyword vpn_link_connections: List of all vpn site link connections to the gateway.
        :paramtype vpn_link_connections:
         list[~azure.mgmt.network.models.VpnSiteLinkConnection]
        :keyword routing_configuration: The Routing Configuration indicating the associated and
         propagated route tables on this connection.
        :paramtype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.remote_vpn_site = remote_vpn_site
        self.routing_weight = routing_weight
        self.dpd_timeout_seconds = dpd_timeout_seconds
        self.connection_status = None
        self.vpn_connection_protocol_type = vpn_connection_protocol_type
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.connection_bandwidth = connection_bandwidth
        self.shared_key = shared_key
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.traffic_selector_policies = traffic_selector_policies
        self.enable_rate_limiting = enable_rate_limiting
        self.enable_internet_security = enable_internet_security
        self.use_local_azure_ip_address = use_local_azure_ip_address
        self.provisioning_state = None
        self.vpn_link_connections = vpn_link_connections
        self.routing_configuration = routing_configuration

class VpnGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """VpnGateway Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_hub: The VirtualHub to which the gateway belongs.
    :vartype virtual_hub: ~azure.mgmt.network.models.SubResource
    :ivar connections: List of all vpn connections to the gateway.
    :vartype connections: list[~azure.mgmt.network.models.VpnConnection]
    :ivar bgp_settings: Local network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.models.BgpSettings
    :ivar provisioning_state: The provisioning state of the VPN gateway resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar vpn_gateway_scale_unit: The scale unit for this vpn gateway.
    :vartype vpn_gateway_scale_unit: int
    :ivar ip_configurations: List of all IPs configured on the gateway.
    :vartype ip_configurations:
     list[~azure.mgmt.network.models.VpnGatewayIpConfiguration]
    :ivar enable_bgp_route_translation_for_nat: Enable BGP routes translation for NAT on this
     VpnGateway.
    :vartype enable_bgp_route_translation_for_nat: bool
    :ivar is_routing_preference_internet: Enable Routing Preference property for the Public IP
     Interface of the VpnGateway.
    :vartype is_routing_preference_internet: bool
    :ivar nat_rules: List of all the nat Rules associated with the gateway.
    :vartype nat_rules: list[~azure.mgmt.network.models.VpnGatewayNatRule]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "ip_configurations": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "SubResource"},
        "connections": {"key": "properties.connections", "type": "[VpnConnection]"},
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "vpn_gateway_scale_unit": {"key": "properties.vpnGatewayScaleUnit", "type": "int"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VpnGatewayIpConfiguration]"},
        "enable_bgp_route_translation_for_nat": {"key": "properties.enableBgpRouteTranslationForNat", "type": "bool"},
        "is_routing_preference_internet": {"key": "properties.isRoutingPreferenceInternet", "type": "bool"},
        "nat_rules": {"key": "properties.natRules", "type": "[VpnGatewayNatRule]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_hub: Optional["_models.SubResource"] = None,
        connections: Optional[List["_models.VpnConnection"]] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        vpn_gateway_scale_unit: Optional[int] = None,
        enable_bgp_route_translation_for_nat: Optional[bool] = None,
        is_routing_preference_internet: Optional[bool] = None,
        nat_rules: Optional[List["_models.VpnGatewayNatRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_hub: The VirtualHub to which the gateway belongs.
        :paramtype virtual_hub: ~azure.mgmt.network.models.SubResource
        :keyword connections: List of all vpn connections to the gateway.
        :paramtype connections: list[~azure.mgmt.network.models.VpnConnection]
        :keyword bgp_settings: Local network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.models.BgpSettings
        :keyword vpn_gateway_scale_unit: The scale unit for this vpn gateway.
        :paramtype vpn_gateway_scale_unit: int
        :keyword enable_bgp_route_translation_for_nat: Enable BGP routes translation for NAT on this
         VpnGateway.
        :paramtype enable_bgp_route_translation_for_nat: bool
        :keyword is_routing_preference_internet: Enable Routing Preference property for the Public IP
         Interface of the VpnGateway.
        :paramtype is_routing_preference_internet: bool
        :keyword nat_rules: List of all the nat Rules associated with the gateway.
        :paramtype nat_rules: list[~azure.mgmt.network.models.VpnGatewayNatRule]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.virtual_hub = virtual_hub
        self.connections = connections
        self.bgp_settings = bgp_settings
        self.provisioning_state = None
        self.vpn_gateway_scale_unit = vpn_gateway_scale_unit
        self.ip_configurations = None
        self.enable_bgp_route_translation_for_nat = enable_bgp_route_translation_for_nat
        self.is_routing_preference_internet = is_routing_preference_internet
        self.nat_rules = nat_rules

class VpnSite(Resource):  # pylint: disable=too-many-instance-attributes
    """VpnSite Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_wan: The VirtualWAN to which the vpnSite belongs.
    :vartype virtual_wan: ~azure.mgmt.network.models.SubResource
    :ivar device_properties: The device properties.
    :vartype device_properties: ~azure.mgmt.network.models.DeviceProperties
    :ivar ip_address: The ip-address for the vpn-site.
    :vartype ip_address: str
    :ivar site_key: The key for vpn-site that can be used for connections.
    :vartype site_key: str
    :ivar address_space: The AddressSpace that contains an array of IP address ranges.
    :vartype address_space: ~azure.mgmt.network.models.AddressSpace
    :ivar bgp_properties: The set of bgp properties.
    :vartype bgp_properties: ~azure.mgmt.network.models.BgpSettings
    :ivar provisioning_state: The provisioning state of the VPN site resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar is_security_site: IsSecuritySite flag.
    :vartype is_security_site: bool
    :ivar vpn_site_links: List of all vpn site links.
    :vartype vpn_site_links: list[~azure.mgmt.network.models.VpnSiteLink]
    :ivar o365_policy: Office365 Policy.
    :vartype o365_policy: ~azure.mgmt.network.models.O365PolicyProperties
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_wan": {"key": "properties.virtualWan", "type": "SubResource"},
        "device_properties": {"key": "properties.deviceProperties", "type": "DeviceProperties"},
        "ip_address": {"key": "properties.ipAddress", "type": "str"},
        "site_key": {"key": "properties.siteKey", "type": "str"},
        "address_space": {"key": "properties.addressSpace", "type": "AddressSpace"},
        "bgp_properties": {"key": "properties.bgpProperties", "type": "BgpSettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "is_security_site": {"key": "properties.isSecuritySite", "type": "bool"},
        "vpn_site_links": {"key": "properties.vpnSiteLinks", "type": "[VpnSiteLink]"},
        "o365_policy": {"key": "properties.o365Policy", "type": "O365PolicyProperties"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_wan: Optional["_models.SubResource"] = None,
        device_properties: Optional["_models.DeviceProperties"] = None,
        ip_address: Optional[str] = None,
        site_key: Optional[str] = None,
        address_space: Optional["_models.AddressSpace"] = None,
        bgp_properties: Optional["_models.BgpSettings"] = None,
        is_security_site: Optional[bool] = None,
        vpn_site_links: Optional[List["_models.VpnSiteLink"]] = None,
        o365_policy: Optional["_models.O365PolicyProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_wan: The VirtualWAN to which the vpnSite belongs.
        :paramtype virtual_wan: ~azure.mgmt.network.models.SubResource
        :keyword device_properties: The device properties.
        :paramtype device_properties: ~azure.mgmt.network.models.DeviceProperties
        :keyword ip_address: The ip-address for the vpn-site.
        :paramtype ip_address: str
        :keyword site_key: The key for vpn-site that can be used for connections.
        :paramtype site_key: str
        :keyword address_space: The AddressSpace that contains an array of IP address ranges.
        :paramtype address_space: ~azure.mgmt.network.models.AddressSpace
        :keyword bgp_properties: The set of bgp properties.
        :paramtype bgp_properties: ~azure.mgmt.network.models.BgpSettings
        :keyword is_security_site: IsSecuritySite flag.
        :paramtype is_security_site: bool
        :keyword vpn_site_links: List of all vpn site links.
        :paramtype vpn_site_links: list[~azure.mgmt.network.models.VpnSiteLink]
        :keyword o365_policy: Office365 Policy.
        :paramtype o365_policy: ~azure.mgmt.network.models.O365PolicyProperties
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.virtual_wan = virtual_wan
        self.device_properties = device_properties
        self.ip_address = ip_address
        self.site_key = site_key
        self.address_space = address_space
        self.bgp_properties = bgp_properties
        self.provisioning_state = None
        self.is_security_site = is_security_site
        self.vpn_site_links = vpn_site_links
        self.o365_policy = o365_policy

class VpnSiteId(_serialization.Model):
    """VpnSite Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vpn_site: The resource-uri of the vpn-site for which config is to be fetched.
    :vartype vpn_site: str
    """

    _validation = {
        "vpn_site": {"readonly": True},
    }

    _attribute_map = {
        "vpn_site": {"key": "vpnSite", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.vpn_site = None

class ApplicationGatewayCustomError(_serialization.Model):
    """Custom error of an application gateway.

    :ivar status_code: Status code of the application gateway custom error. Known values are:
     "HttpStatus400", "HttpStatus403", "HttpStatus404", "HttpStatus405", "HttpStatus408",
     "HttpStatus500", "HttpStatus502", "HttpStatus503", and "HttpStatus504".
    :vartype status_code: str or
     ~azure.mgmt.network.models.ApplicationGatewayCustomErrorStatusCode
    :ivar custom_error_page_url: Error page URL of the application gateway custom error.
    :vartype custom_error_page_url: str
    """

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "str"},
        "custom_error_page_url": {"key": "customErrorPageUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        status_code: Optional[Union[str, "_models.ApplicationGatewayCustomErrorStatusCode"]] = None,
        custom_error_page_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status_code: Status code of the application gateway custom error. Known values are:
         "HttpStatus400", "HttpStatus403", "HttpStatus404", "HttpStatus405", "HttpStatus408",
         "HttpStatus500", "HttpStatus502", "HttpStatus503", and "HttpStatus504".
        :paramtype status_code: str or
         ~azure.mgmt.network.models.ApplicationGatewayCustomErrorStatusCode
        :keyword custom_error_page_url: Error page URL of the application gateway custom error.
        :paramtype custom_error_page_url: str
        """
        super().__init__(**kwargs)
        self.status_code = status_code
        self.custom_error_page_url = custom_error_page_url

class ApplicationGatewayFirewallExclusion(_serialization.Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to server.

    :ivar match_variable: The variable to be excluded. Required.
    :vartype match_variable: str
    :ivar selector_match_operator: When matchVariable is a collection, operate on the selector to
     specify which elements in the collection this exclusion applies to. Required.
    :vartype selector_match_operator: str
    :ivar selector: When matchVariable is a collection, operator used to specify which elements in
     the collection this exclusion applies to. Required.
    :vartype selector: str
    """

    _validation = {
        "match_variable": {"required": True},
        "selector_match_operator": {"required": True},
        "selector": {"required": True},
    }

    _attribute_map = {
        "match_variable": {"key": "matchVariable", "type": "str"},
        "selector_match_operator": {"key": "selectorMatchOperator", "type": "str"},
        "selector": {"key": "selector", "type": "str"},
    }

    def __init__(self, *, match_variable: str, selector_match_operator: str, selector: str, **kwargs: Any) -> None:
        """
        :keyword match_variable: The variable to be excluded. Required.
        :paramtype match_variable: str
        :keyword selector_match_operator: When matchVariable is a collection, operate on the selector
         to specify which elements in the collection this exclusion applies to. Required.
        :paramtype selector_match_operator: str
        :keyword selector: When matchVariable is a collection, operator used to specify which elements
         in the collection this exclusion applies to. Required.
        :paramtype selector: str
        """
        super().__init__(**kwargs)
        self.match_variable = match_variable
        self.selector_match_operator = selector_match_operator
        self.selector = selector

class ApplicationGatewayHeaderConfiguration(_serialization.Model):
    """Header configuration of the Actions set in Application Gateway.

    :ivar header_name: Header name of the header configuration.
    :vartype header_name: str
    :ivar header_value_matcher: An optional field under "Rewrite Action". It lets you capture and
     modify the value(s) of a specific header when multiple headers with the same name exist.
     Currently supported for Set-Cookie Response header only. For more details, visit
     https://aka.ms/appgwheadercrud.
    :vartype header_value_matcher: ~azure.mgmt.network.models.HeaderValueMatcher
    :ivar header_value: Header value of the header configuration.
    :vartype header_value: str
    """

    _attribute_map = {
        "header_name": {"key": "headerName", "type": "str"},
        "header_value_matcher": {"key": "headerValueMatcher", "type": "HeaderValueMatcher"},
        "header_value": {"key": "headerValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        header_name: Optional[str] = None,
        header_value_matcher: Optional["_models.HeaderValueMatcher"] = None,
        header_value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword header_name: Header name of the header configuration.
        :paramtype header_name: str
        :keyword header_value_matcher: An optional field under "Rewrite Action". It lets you capture
         and modify the value(s) of a specific header when multiple headers with the same name exist.
         Currently supported for Set-Cookie Response header only. For more details, visit
         https://aka.ms/appgwheadercrud.
        :paramtype header_value_matcher: ~azure.mgmt.network.models.HeaderValueMatcher
        :keyword header_value: Header value of the header configuration.
        :paramtype header_value: str
        """
        super().__init__(**kwargs)
        self.header_name = header_name
        self.header_value_matcher = header_value_matcher
        self.header_value = header_value

class ApplicationGatewayRewriteRule(_serialization.Model):
    """Rewrite rule of an application gateway.

    :ivar name: Name of the rewrite rule that is unique within an Application Gateway.
    :vartype name: str
    :ivar rule_sequence: Rule Sequence of the rewrite rule that determines the order of execution
     of a particular rule in a RewriteRuleSet.
    :vartype rule_sequence: int
    :ivar conditions: Conditions based on which the action set execution will be evaluated.
    :vartype conditions:
     list[~azure.mgmt.network.models.ApplicationGatewayRewriteRuleCondition]
    :ivar action_set: Set of actions to be done as part of the rewrite Rule.
    :vartype action_set:
     ~azure.mgmt.network.models.ApplicationGatewayRewriteRuleActionSet
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "rule_sequence": {"key": "ruleSequence", "type": "int"},
        "conditions": {"key": "conditions", "type": "[ApplicationGatewayRewriteRuleCondition]"},
        "action_set": {"key": "actionSet", "type": "ApplicationGatewayRewriteRuleActionSet"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        rule_sequence: Optional[int] = None,
        conditions: Optional[List["_models.ApplicationGatewayRewriteRuleCondition"]] = None,
        action_set: Optional["_models.ApplicationGatewayRewriteRuleActionSet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the rewrite rule that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rule_sequence: Rule Sequence of the rewrite rule that determines the order of
         execution of a particular rule in a RewriteRuleSet.
        :paramtype rule_sequence: int
        :keyword conditions: Conditions based on which the action set execution will be evaluated.
        :paramtype conditions:
         list[~azure.mgmt.network.models.ApplicationGatewayRewriteRuleCondition]
        :keyword action_set: Set of actions to be done as part of the rewrite Rule.
        :paramtype action_set:
         ~azure.mgmt.network.models.ApplicationGatewayRewriteRuleActionSet
        """
        super().__init__(**kwargs)
        self.name = name
        self.rule_sequence = rule_sequence
        self.conditions = conditions
        self.action_set = action_set

class ApplicationGatewayRewriteRuleActionSet(_serialization.Model):
    """Set of actions in the Rewrite Rule in Application Gateway.

    :ivar request_header_configurations: Request Header Actions in the Action Set.
    :vartype request_header_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayHeaderConfiguration]
    :ivar response_header_configurations: Response Header Actions in the Action Set.
    :vartype response_header_configurations:
     list[~azure.mgmt.network.models.ApplicationGatewayHeaderConfiguration]
    :ivar url_configuration: Url Configuration Action in the Action Set.
    :vartype url_configuration:
     ~azure.mgmt.network.models.ApplicationGatewayUrlConfiguration
    """

    _attribute_map = {
        "request_header_configurations": {
            "key": "requestHeaderConfigurations",
            "type": "[ApplicationGatewayHeaderConfiguration]",
        },
        "response_header_configurations": {
            "key": "responseHeaderConfigurations",
            "type": "[ApplicationGatewayHeaderConfiguration]",
        },
        "url_configuration": {"key": "urlConfiguration", "type": "ApplicationGatewayUrlConfiguration"},
    }

    def __init__(
        self,
        *,
        request_header_configurations: Optional[List["_models.ApplicationGatewayHeaderConfiguration"]] = None,
        response_header_configurations: Optional[List["_models.ApplicationGatewayHeaderConfiguration"]] = None,
        url_configuration: Optional["_models.ApplicationGatewayUrlConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword request_header_configurations: Request Header Actions in the Action Set.
        :paramtype request_header_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayHeaderConfiguration]
        :keyword response_header_configurations: Response Header Actions in the Action Set.
        :paramtype response_header_configurations:
         list[~azure.mgmt.network.models.ApplicationGatewayHeaderConfiguration]
        :keyword url_configuration: Url Configuration Action in the Action Set.
        :paramtype url_configuration:
         ~azure.mgmt.network.models.ApplicationGatewayUrlConfiguration
        """
        super().__init__(**kwargs)
        self.request_header_configurations = request_header_configurations
        self.response_header_configurations = response_header_configurations
        self.url_configuration = url_configuration

class ApplicationGatewayRewriteRuleSet(SubResource):
    """Rewrite rule set of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the rewrite rule set that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rewrite_rules: Rewrite rules in the rewrite rule set.
    :vartype rewrite_rules:
     list[~azure.mgmt.network.models.ApplicationGatewayRewriteRule]
    :ivar provisioning_state: The provisioning state of the rewrite rule set resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "rewrite_rules": {"key": "properties.rewriteRules", "type": "[ApplicationGatewayRewriteRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        rewrite_rules: Optional[List["_models.ApplicationGatewayRewriteRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the rewrite rule set that is unique within an Application Gateway.
        :paramtype name: str
        :keyword rewrite_rules: Rewrite rules in the rewrite rule set.
        :paramtype rewrite_rules:
         list[~azure.mgmt.network.models.ApplicationGatewayRewriteRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.rewrite_rules = rewrite_rules
        self.provisioning_state = None

class ApplicationGatewayTrustedRootCertificate(SubResource):
    """Trusted Root certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of the trusted root certificate that is unique within an Application Gateway.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar data: Certificate public data.
    :vartype data: str
    :ivar key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
     'Certificate' object stored in KeyVault.
    :vartype key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the trusted root certificate resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "key_vault_secret_id": {"key": "properties.keyVaultSecretId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        data: Optional[str] = None,
        key_vault_secret_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of the trusted root certificate that is unique within an Application
         Gateway.
        :paramtype name: str
        :keyword data: Certificate public data.
        :paramtype data: str
        :keyword key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or
         'Certificate' object stored in KeyVault.
        :paramtype key_vault_secret_id: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.data = data
        self.key_vault_secret_id = key_vault_secret_id
        self.provisioning_state = None

class AvailableDelegation(_serialization.Model):
    """The serviceName of an AvailableDelegation indicates a possible delegation for a subnet.

    :ivar name: The name of the AvailableDelegation resource.
    :vartype name: str
    :ivar id: A unique identifier of the AvailableDelegation resource.
    :vartype id: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_name: The name of the service and resource.
    :vartype service_name: str
    :ivar actions: The actions permitted to the service upon delegation.
    :vartype actions: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_name": {"key": "serviceName", "type": "str"},
        "actions": {"key": "actions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        service_name: Optional[str] = None,
        actions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the AvailableDelegation resource.
        :paramtype name: str
        :keyword id: A unique identifier of the AvailableDelegation resource.
        :paramtype id: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword service_name: The name of the service and resource.
        :paramtype service_name: str
        :keyword actions: The actions permitted to the service upon delegation.
        :paramtype actions: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.service_name = service_name
        self.actions = actions

class AvailableDelegationsResult(_serialization.Model):
    """An array of available delegations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of available delegations.
    :vartype value: list[~azure.mgmt.network.models.AvailableDelegation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableDelegation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AvailableDelegation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of available delegations.
        :paramtype value: list[~azure.mgmt.network.models.AvailableDelegation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class AzureFirewallFqdnTag(Resource):
    """Azure Firewall FQDN Tag Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the Azure firewall FQDN tag resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar fqdn_tag_name: The name of this FQDN Tag.
    :vartype fqdn_tag_name: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "fqdn_tag_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "fqdn_tag_name": {"key": "properties.fqdnTagName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.provisioning_state = None
        self.fqdn_tag_name = None

class AzureFirewallFqdnTagListResult(_serialization.Model):
    """Response for ListAzureFirewallFqdnTags API service call.

    :ivar value: List of Azure Firewall FQDN Tags in a resource group.
    :vartype value: list[~azure.mgmt.network.models.AzureFirewallFqdnTag]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureFirewallFqdnTag]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AzureFirewallFqdnTag"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Azure Firewall FQDN Tags in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.AzureFirewallFqdnTag]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class AzureFirewallNatRCAction(_serialization.Model):
    """AzureFirewall NAT Rule Collection Action.

    :ivar type: The type of action. Known values are: "Snat" and "Dnat".
    :vartype type: str or ~azure.mgmt.network.models.AzureFirewallNatRCActionType
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.AzureFirewallNatRCActionType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of action. Known values are: "Snat" and "Dnat".
        :paramtype type: str or ~azure.mgmt.network.models.AzureFirewallNatRCActionType
        """
        super().__init__(**kwargs)
        self.type = type

class AzureFirewallNatRule(_serialization.Model):
    """Properties of a NAT rule.

    :ivar name: Name of the NAT rule.
    :vartype name: str
    :ivar description: Description of the rule.
    :vartype description: str
    :ivar source_addresses: List of source IP addresses for this rule.
    :vartype source_addresses: list[str]
    :ivar destination_addresses: List of destination IP addresses for this rule. Supports IP
     ranges, prefixes, and service tags.
    :vartype destination_addresses: list[str]
    :ivar destination_ports: List of destination ports.
    :vartype destination_ports: list[str]
    :ivar protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
    :vartype protocols: list[str or
     ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol]
    :ivar translated_address: The translated address for this NAT rule.
    :vartype translated_address: str
    :ivar translated_port: The translated port for this NAT rule.
    :vartype translated_port: str
    :ivar translated_fqdn: The translated FQDN for this NAT rule.
    :vartype translated_fqdn: str
    :ivar source_ip_groups: List of source IpGroups for this rule.
    :vartype source_ip_groups: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_addresses": {"key": "sourceAddresses", "type": "[str]"},
        "destination_addresses": {"key": "destinationAddresses", "type": "[str]"},
        "destination_ports": {"key": "destinationPorts", "type": "[str]"},
        "protocols": {"key": "protocols", "type": "[str]"},
        "translated_address": {"key": "translatedAddress", "type": "str"},
        "translated_port": {"key": "translatedPort", "type": "str"},
        "translated_fqdn": {"key": "translatedFqdn", "type": "str"},
        "source_ip_groups": {"key": "sourceIpGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        source_addresses: Optional[List[str]] = None,
        destination_addresses: Optional[List[str]] = None,
        destination_ports: Optional[List[str]] = None,
        protocols: Optional[List[Union[str, "_models.AzureFirewallNetworkRuleProtocol"]]] = None,
        translated_address: Optional[str] = None,
        translated_port: Optional[str] = None,
        translated_fqdn: Optional[str] = None,
        source_ip_groups: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the NAT rule.
        :paramtype name: str
        :keyword description: Description of the rule.
        :paramtype description: str
        :keyword source_addresses: List of source IP addresses for this rule.
        :paramtype source_addresses: list[str]
        :keyword destination_addresses: List of destination IP addresses for this rule. Supports IP
         ranges, prefixes, and service tags.
        :paramtype destination_addresses: list[str]
        :keyword destination_ports: List of destination ports.
        :paramtype destination_ports: list[str]
        :keyword protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        :paramtype protocols: list[str or
         ~azure.mgmt.network.models.AzureFirewallNetworkRuleProtocol]
        :keyword translated_address: The translated address for this NAT rule.
        :paramtype translated_address: str
        :keyword translated_port: The translated port for this NAT rule.
        :paramtype translated_port: str
        :keyword translated_fqdn: The translated FQDN for this NAT rule.
        :paramtype translated_fqdn: str
        :keyword source_ip_groups: List of source IpGroups for this rule.
        :paramtype source_ip_groups: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.protocols = protocols
        self.translated_address = translated_address
        self.translated_port = translated_port
        self.translated_fqdn = translated_fqdn
        self.source_ip_groups = source_ip_groups

class AzureFirewallNatRuleCollection(SubResource):
    """NAT rule collection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the Azure firewall. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar priority: Priority of the NAT rule collection resource.
    :vartype priority: int
    :ivar action: The action type of a NAT rule collection.
    :vartype action: ~azure.mgmt.network.models.AzureFirewallNatRCAction
    :ivar rules: Collection of rules used by a NAT rule collection.
    :vartype rules: list[~azure.mgmt.network.models.AzureFirewallNatRule]
    :ivar provisioning_state: The provisioning state of the NAT rule collection resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "priority": {"maximum": 65000, "minimum": 100},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "action": {"key": "properties.action", "type": "AzureFirewallNatRCAction"},
        "rules": {"key": "properties.rules", "type": "[AzureFirewallNatRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        priority: Optional[int] = None,
        action: Optional["_models.AzureFirewallNatRCAction"] = None,
        rules: Optional[List["_models.AzureFirewallNatRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the Azure firewall. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword priority: Priority of the NAT rule collection resource.
        :paramtype priority: int
        :keyword action: The action type of a NAT rule collection.
        :paramtype action: ~azure.mgmt.network.models.AzureFirewallNatRCAction
        :keyword rules: Collection of rules used by a NAT rule collection.
        :paramtype rules: list[~azure.mgmt.network.models.AzureFirewallNatRule]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None

class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.network.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.network.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details

class Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None

class Container(SubResource):
    """Reference to container resource in remote resource provider.

    :ivar id: Resource ID.
    :vartype id: str
    """

class ContainerNetworkInterface(SubResource):
    """Container network interface child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar container_network_interface_configuration: Container network interface configuration from
     which this container network interface is created.
    :vartype container_network_interface_configuration:
     ~azure.mgmt.network.models.ContainerNetworkInterfaceConfiguration
    :ivar container: Reference to the container to which this container network interface is
     attached.
    :vartype container: ~azure.mgmt.network.models.Container
    :ivar ip_configurations: Reference to the ip configuration on this container nic.
    :vartype ip_configurations:
     list[~azure.mgmt.network.models.ContainerNetworkInterfaceIpConfiguration]
    :ivar provisioning_state: The provisioning state of the container network interface resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "container_network_interface_configuration": {"readonly": True},
        "ip_configurations": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "container_network_interface_configuration": {
            "key": "properties.containerNetworkInterfaceConfiguration",
            "type": "ContainerNetworkInterfaceConfiguration",
        },
        "container": {"key": "properties.container", "type": "Container"},
        "ip_configurations": {
            "key": "properties.ipConfigurations",
            "type": "[ContainerNetworkInterfaceIpConfiguration]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        container: Optional["_models.Container"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword container: Reference to the container to which this container network interface is
         attached.
        :paramtype container: ~azure.mgmt.network.models.Container
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type = None
        self.etag = None
        self.container_network_interface_configuration = None
        self.container = container
        self.ip_configurations = None
        self.provisioning_state = None

class ContainerNetworkInterfaceConfiguration(SubResource):
    """Container network interface configuration child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar ip_configurations: A list of ip configurations of the container network interface
     configuration.
    :vartype ip_configurations: list[~azure.mgmt.network.models.IPConfigurationProfile]
    :ivar container_network_interfaces: A list of container network interfaces created from this
     container network interface configuration.
    :vartype container_network_interfaces: list[~azure.mgmt.network.models.SubResource]
    :ivar provisioning_state: The provisioning state of the container network interface
     configuration resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[IPConfigurationProfile]"},
        "container_network_interfaces": {"key": "properties.containerNetworkInterfaces", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        ip_configurations: Optional[List["_models.IPConfigurationProfile"]] = None,
        container_network_interfaces: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword ip_configurations: A list of ip configurations of the container network interface
         configuration.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.models.IPConfigurationProfile]
        :keyword container_network_interfaces: A list of container network interfaces created from this
         container network interface configuration.
        :paramtype container_network_interfaces:
         list[~azure.mgmt.network.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type = None
        self.etag = None
        self.ip_configurations = ip_configurations
        self.container_network_interfaces = container_network_interfaces
        self.provisioning_state = None

class ContainerNetworkInterfaceIpConfiguration(_serialization.Model):
    """The ip configuration for a container network interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the container network interface IP
     configuration resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = None
        self.etag = None
        self.provisioning_state = None

class DdosCustomPolicy(Resource):
    """A DDoS custom policy in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar resource_guid: The resource GUID property of the DDoS custom policy resource. It uniquely
     identifies the resource, even if the user changes its name or migrate the resource across
     subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS custom policy resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.resource_guid = None
        self.provisioning_state = None

class DdosSettings(_serialization.Model):
    """Contains the DDoS protection settings of the public IP.

    :ivar protection_mode: The DDoS protection mode of the public IP. Known values are:
     "VirtualNetworkInherited", "Enabled", and "Disabled".
    :vartype protection_mode: str or
     ~azure.mgmt.network.models.DdosSettingsProtectionMode
    :ivar ddos_protection_plan: The DDoS protection plan associated with the public IP. Can only be
     set if ProtectionMode is Enabled.
    :vartype ddos_protection_plan: ~azure.mgmt.network.models.SubResource
    """

    _attribute_map = {
        "protection_mode": {"key": "protectionMode", "type": "str"},
        "ddos_protection_plan": {"key": "ddosProtectionPlan", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        protection_mode: Optional[Union[str, "_models.DdosSettingsProtectionMode"]] = None,
        ddos_protection_plan: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protection_mode: The DDoS protection mode of the public IP. Known values are:
         "VirtualNetworkInherited", "Enabled", and "Disabled".
        :paramtype protection_mode: str or
         ~azure.mgmt.network.models.DdosSettingsProtectionMode
        :keyword ddos_protection_plan: The DDoS protection plan associated with the public IP. Can only
         be set if ProtectionMode is Enabled.
        :paramtype ddos_protection_plan: ~azure.mgmt.network.models.SubResource
        """
        super().__init__(**kwargs)
        self.protection_mode = protection_mode
        self.ddos_protection_plan = ddos_protection_plan

class Delegation(SubResource):
    """Details the service to which the subnet is delegated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a subnet. This name can be used to
     access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_name: The name of the service to whom the subnet should be delegated (e.g.
     Microsoft.Sql/servers).
    :vartype service_name: str
    :ivar actions: The actions permitted to the service upon delegation.
    :vartype actions: list[str]
    :ivar provisioning_state: The provisioning state of the service delegation resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "actions": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_name": {"key": "properties.serviceName", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        service_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a subnet. This name can be used
         to access the resource.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword service_name: The name of the service to whom the subnet should be delegated (e.g.
         Microsoft.Sql/servers).
        :paramtype service_name: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = type
        self.service_name = service_name
        self.actions = None
        self.provisioning_state = None

class EndpointService(_serialization.Model):
    """Identifies the service being brought into the virtual network.

    :ivar id: A unique identifier of the service being referenced by the interface endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: A unique identifier of the service being referenced by the interface endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class ErrorResponse(_serialization.Model):
    """The error object.

    :ivar error: The error details object.
    :vartype error: ~azure.mgmt.network.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details object.
        :paramtype error: ~azure.mgmt.network.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error

class EvaluatedNetworkSecurityGroup(_serialization.Model):
    """Results of network security group evaluation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_security_group_id: Network security group ID.
    :vartype network_security_group_id: str
    :ivar applied_to: Resource ID of nic or subnet to which network security group is applied.
    :vartype applied_to: str
    :ivar matched_rule: Matched network security rule.
    :vartype matched_rule: ~azure.mgmt.network.models.MatchedRule
    :ivar rules_evaluation_result: List of network security rules evaluation results.
    :vartype rules_evaluation_result:
     list[~azure.mgmt.network.models.NetworkSecurityRulesEvaluationResult]
    """

    _validation = {
        "rules_evaluation_result": {"readonly": True},
    }

    _attribute_map = {
        "network_security_group_id": {"key": "networkSecurityGroupId", "type": "str"},
        "applied_to": {"key": "appliedTo", "type": "str"},
        "matched_rule": {"key": "matchedRule", "type": "MatchedRule"},
        "rules_evaluation_result": {"key": "rulesEvaluationResult", "type": "[NetworkSecurityRulesEvaluationResult]"},
    }

    def __init__(
        self,
        *,
        network_security_group_id: Optional[str] = None,
        applied_to: Optional[str] = None,
        matched_rule: Optional["_models.MatchedRule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_security_group_id: Network security group ID.
        :paramtype network_security_group_id: str
        :keyword applied_to: Resource ID of nic or subnet to which network security group is applied.
        :paramtype applied_to: str
        :keyword matched_rule: Matched network security rule.
        :paramtype matched_rule: ~azure.mgmt.network.models.MatchedRule
        """
        super().__init__(**kwargs)
        self.network_security_group_id = network_security_group_id
        self.applied_to = applied_to
        self.matched_rule = matched_rule
        self.rules_evaluation_result = None

class ExpressRouteCircuitConnectionListResult(_serialization.Model):
    """Response for ListConnections API service call retrieves all global reach connections that
    belongs to a Private Peering for an ExpressRouteCircuit.

    :ivar value: The global reach connection associated with Private Peering in an ExpressRoute
     Circuit.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteCircuitConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The global reach connection associated with Private Peering in an ExpressRoute
         Circuit.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteCircuitConnection]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRouteCircuitPeeringId(_serialization.Model):
    """ExpressRoute circuit peering identifier.

    :ivar id: The ID of the ExpressRoute circuit peering.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of the ExpressRoute circuit peering.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class ExpressRouteConnection(SubResource):
    """ExpressRouteConnection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar provisioning_state: The provisioning state of the express route connection resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar express_route_circuit_peering: The ExpressRoute circuit peering.
    :vartype express_route_circuit_peering:
     ~azure.mgmt.network.models.ExpressRouteCircuitPeeringId
    :ivar authorization_key: Authorization key to establish the connection.
    :vartype authorization_key: str
    :ivar routing_weight: The routing weight associated to the connection.
    :vartype routing_weight: int
    :ivar enable_internet_security: Enable internet security.
    :vartype enable_internet_security: bool
    :ivar express_route_gateway_bypass: Enable FastPath to vWan Firewall hub.
    :vartype express_route_gateway_bypass: bool
    :ivar enable_private_link_fast_path: Bypass the ExpressRoute gateway when accessing
     private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
    :vartype enable_private_link_fast_path: bool
    :ivar routing_configuration: The Routing Configuration indicating the associated and propagated
     route tables on this connection.
    :vartype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
    """

    _validation = {
        "name": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "express_route_circuit_peering": {
            "key": "properties.expressRouteCircuitPeering",
            "type": "ExpressRouteCircuitPeeringId",
        },
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "enable_internet_security": {"key": "properties.enableInternetSecurity", "type": "bool"},
        "express_route_gateway_bypass": {"key": "properties.expressRouteGatewayBypass", "type": "bool"},
        "enable_private_link_fast_path": {"key": "properties.enablePrivateLinkFastPath", "type": "bool"},
        "routing_configuration": {"key": "properties.routingConfiguration", "type": "RoutingConfiguration"},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        express_route_circuit_peering: Optional["_models.ExpressRouteCircuitPeeringId"] = None,
        authorization_key: Optional[str] = None,
        routing_weight: Optional[int] = None,
        enable_internet_security: Optional[bool] = None,
        express_route_gateway_bypass: Optional[bool] = None,
        enable_private_link_fast_path: Optional[bool] = None,
        routing_configuration: Optional["_models.RoutingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword express_route_circuit_peering: The ExpressRoute circuit peering.
        :paramtype express_route_circuit_peering:
         ~azure.mgmt.network.models.ExpressRouteCircuitPeeringId
        :keyword authorization_key: Authorization key to establish the connection.
        :paramtype authorization_key: str
        :keyword routing_weight: The routing weight associated to the connection.
        :paramtype routing_weight: int
        :keyword enable_internet_security: Enable internet security.
        :paramtype enable_internet_security: bool
        :keyword express_route_gateway_bypass: Enable FastPath to vWan Firewall hub.
        :paramtype express_route_gateway_bypass: bool
        :keyword enable_private_link_fast_path: Bypass the ExpressRoute gateway when accessing
         private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
        :paramtype enable_private_link_fast_path: bool
        :keyword routing_configuration: The Routing Configuration indicating the associated and
         propagated route tables on this connection.
        :paramtype routing_configuration: ~azure.mgmt.network.models.RoutingConfiguration
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.provisioning_state = None
        self.express_route_circuit_peering = express_route_circuit_peering
        self.authorization_key = authorization_key
        self.routing_weight = routing_weight
        self.enable_internet_security = enable_internet_security
        self.express_route_gateway_bypass = express_route_gateway_bypass
        self.enable_private_link_fast_path = enable_private_link_fast_path
        self.routing_configuration = routing_configuration

class ExpressRouteConnectionId(_serialization.Model):
    """The ID of the ExpressRouteConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the ExpressRouteConnection.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None

class ExpressRouteConnectionList(_serialization.Model):
    """ExpressRouteConnection list.

    :ivar value: The list of ExpressRoute connections.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.ExpressRouteConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of ExpressRoute connections.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteConnection]
        """
        super().__init__(**kwargs)
        self.value = value

class ExpressRouteGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRoute gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar auto_scale_configuration: Configuration for auto scaling.
    :vartype auto_scale_configuration:
     ~azure.mgmt.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration
    :ivar express_route_connections: List of ExpressRoute connections to the ExpressRoute gateway.
    :vartype express_route_connections:
     list[~azure.mgmt.network.models.ExpressRouteConnection]
    :ivar provisioning_state: The provisioning state of the express route gateway resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar virtual_hub: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
    :vartype virtual_hub: ~azure.mgmt.network.models.VirtualHubId
    :ivar allow_non_virtual_wan_traffic: Configures this gateway to accept traffic from non Virtual
     WAN networks.
    :vartype allow_non_virtual_wan_traffic: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "auto_scale_configuration": {
            "key": "properties.autoScaleConfiguration",
            "type": "ExpressRouteGatewayPropertiesAutoScaleConfiguration",
        },
        "express_route_connections": {"key": "properties.expressRouteConnections", "type": "[ExpressRouteConnection]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "VirtualHubId"},
        "allow_non_virtual_wan_traffic": {"key": "properties.allowNonVirtualWanTraffic", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        auto_scale_configuration: Optional["_models.ExpressRouteGatewayPropertiesAutoScaleConfiguration"] = None,
        express_route_connections: Optional[List["_models.ExpressRouteConnection"]] = None,
        virtual_hub: Optional["_models.VirtualHubId"] = None,
        allow_non_virtual_wan_traffic: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword auto_scale_configuration: Configuration for auto scaling.
        :paramtype auto_scale_configuration:
         ~azure.mgmt.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration
        :keyword express_route_connections: List of ExpressRoute connections to the ExpressRoute
         gateway.
        :paramtype express_route_connections:
         list[~azure.mgmt.network.models.ExpressRouteConnection]
        :keyword virtual_hub: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
        :paramtype virtual_hub: ~azure.mgmt.network.models.VirtualHubId
        :keyword allow_non_virtual_wan_traffic: Configures this gateway to accept traffic from non
         Virtual WAN networks.
        :paramtype allow_non_virtual_wan_traffic: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.auto_scale_configuration = auto_scale_configuration
        self.express_route_connections = express_route_connections
        self.provisioning_state = None
        self.virtual_hub = virtual_hub
        self.allow_non_virtual_wan_traffic = allow_non_virtual_wan_traffic

class ExpressRouteGatewayList(_serialization.Model):
    """List of ExpressRoute gateways.

    :ivar value: List of ExpressRoute gateways.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteGateway]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteGateway]"},
    }

    def __init__(self, *, value: Optional[List["_models.ExpressRouteGateway"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of ExpressRoute gateways.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteGateway]
        """
        super().__init__(**kwargs)
        self.value = value

class ExpressRouteGatewayPropertiesAutoScaleConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Configuration for auto scaling.

    :ivar bounds: Minimum and maximum number of scale units to deploy.
    :vartype bounds:
     ~azure.mgmt.network.models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
    """

    _attribute_map = {
        "bounds": {"key": "bounds", "type": "ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds"},
    }

    def __init__(
        self,
        *,
        bounds: Optional["_models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bounds: Minimum and maximum number of scale units to deploy.
        :paramtype bounds:
         ~azure.mgmt.network.models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
        """
        super().__init__(**kwargs)
        self.bounds = bounds

class ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds(_serialization.Model):  # pylint: disable=name-too-long
    """Minimum and maximum number of scale units to deploy.

    :ivar min: Minimum number of scale units deployed for ExpressRoute gateway.
    :vartype min: int
    :ivar max: Maximum number of scale units deployed for ExpressRoute gateway.
    :vartype max: int
    """

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,  # pylint: disable=redefined-builtin
        max: Optional[int] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword min: Minimum number of scale units deployed for ExpressRoute gateway.
        :paramtype min: int
        :keyword max: Maximum number of scale units deployed for ExpressRoute gateway.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max

class ExpressRouteLink(SubResource):  # pylint: disable=too-many-instance-attributes
    """ExpressRouteLink child resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Name of child port resource that is unique among child port resources of the
     parent.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar router_name: Name of Azure router associated with physical port.
    :vartype router_name: str
    :ivar interface_name: Name of Azure router interface.
    :vartype interface_name: str
    :ivar patch_panel_id: Mapping between physical port to patch panel port.
    :vartype patch_panel_id: str
    :ivar rack_id: Mapping of physical patch panel to rack.
    :vartype rack_id: str
    :ivar colo_location: Cololocation for ExpressRoute Hybrid Direct.
    :vartype colo_location: str
    :ivar connector_type: Physical fiber port type. Known values are: "LC" and "SC".
    :vartype connector_type: str or
     ~azure.mgmt.network.models.ExpressRouteLinkConnectorType
    :ivar admin_state: Administrative state of the physical port. Known values are: "Enabled" and
     "Disabled".
    :vartype admin_state: str or ~azure.mgmt.network.models.ExpressRouteLinkAdminState
    :ivar provisioning_state: The provisioning state of the express route link resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar mac_sec_config: MacSec configuration.
    :vartype mac_sec_config: ~azure.mgmt.network.models.ExpressRouteLinkMacSecConfig
    """

    _validation = {
        "etag": {"readonly": True},
        "router_name": {"readonly": True},
        "interface_name": {"readonly": True},
        "patch_panel_id": {"readonly": True},
        "rack_id": {"readonly": True},
        "colo_location": {"readonly": True},
        "connector_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "router_name": {"key": "properties.routerName", "type": "str"},
        "interface_name": {"key": "properties.interfaceName", "type": "str"},
        "patch_panel_id": {"key": "properties.patchPanelId", "type": "str"},
        "rack_id": {"key": "properties.rackId", "type": "str"},
        "colo_location": {"key": "properties.coloLocation", "type": "str"},
        "connector_type": {"key": "properties.connectorType", "type": "str"},
        "admin_state": {"key": "properties.adminState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "mac_sec_config": {"key": "properties.macSecConfig", "type": "ExpressRouteLinkMacSecConfig"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        admin_state: Optional[Union[str, "_models.ExpressRouteLinkAdminState"]] = None,
        mac_sec_config: Optional["_models.ExpressRouteLinkMacSecConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: Name of child port resource that is unique among child port resources of the
         parent.
        :paramtype name: str
        :keyword admin_state: Administrative state of the physical port. Known values are: "Enabled"
         and "Disabled".
        :paramtype admin_state: str or
         ~azure.mgmt.network.models.ExpressRouteLinkAdminState
        :keyword mac_sec_config: MacSec configuration.
        :paramtype mac_sec_config: ~azure.mgmt.network.models.ExpressRouteLinkMacSecConfig
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.router_name = None
        self.interface_name = None
        self.patch_panel_id = None
        self.rack_id = None
        self.colo_location = None
        self.connector_type = None
        self.admin_state = admin_state
        self.provisioning_state = None
        self.mac_sec_config = mac_sec_config

class ExpressRouteLinkListResult(_serialization.Model):
    """Response for ListExpressRouteLinks API service call.

    :ivar value: The list of ExpressRouteLink sub-resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRouteLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteLink"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of ExpressRouteLink sub-resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRouteLink]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRoutePort(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRoutePort resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar identity: The identity of ExpressRoutePort, if configured.
    :vartype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
    :ivar peering_location: The name of the peering location that the ExpressRoutePort is mapped to
     physically.
    :vartype peering_location: str
    :ivar bandwidth_in_gbps: Bandwidth of procured ports in Gbps.
    :vartype bandwidth_in_gbps: int
    :ivar provisioned_bandwidth_in_gbps: Aggregate Gbps of associated circuit bandwidths.
    :vartype provisioned_bandwidth_in_gbps: float
    :ivar mtu: Maximum transmission unit of the physical port pair(s).
    :vartype mtu: str
    :ivar encapsulation: Encapsulation method on physical ports. Known values are: "Dot1Q" and
     "QinQ".
    :vartype encapsulation: str or
     ~azure.mgmt.network.models.ExpressRoutePortsEncapsulation
    :ivar ether_type: Ether type of the physical port.
    :vartype ether_type: str
    :ivar allocation_date: Date of the physical port allocation to be used in Letter of
     Authorization.
    :vartype allocation_date: str
    :ivar links: The set of physical links of the ExpressRoutePort resource.
    :vartype links: list[~azure.mgmt.network.models.ExpressRouteLink]
    :ivar circuits: Reference the ExpressRoute circuit(s) that are provisioned on this
     ExpressRoutePort resource.
    :vartype circuits: list[~azure.mgmt.network.models.SubResource]
    :ivar provisioning_state: The provisioning state of the express route port resource. Known
     values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar resource_guid: The resource GUID property of the express route port resource.
    :vartype resource_guid: str
    :ivar billing_type: The billing type of the ExpressRoutePort resource. Known values are:
     "MeteredData" and "UnlimitedData".
    :vartype billing_type: str or
     ~azure.mgmt.network.models.ExpressRoutePortsBillingType
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioned_bandwidth_in_gbps": {"readonly": True},
        "mtu": {"readonly": True},
        "ether_type": {"readonly": True},
        "allocation_date": {"readonly": True},
        "circuits": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "peering_location": {"key": "properties.peeringLocation", "type": "str"},
        "bandwidth_in_gbps": {"key": "properties.bandwidthInGbps", "type": "int"},
        "provisioned_bandwidth_in_gbps": {"key": "properties.provisionedBandwidthInGbps", "type": "float"},
        "mtu": {"key": "properties.mtu", "type": "str"},
        "encapsulation": {"key": "properties.encapsulation", "type": "str"},
        "ether_type": {"key": "properties.etherType", "type": "str"},
        "allocation_date": {"key": "properties.allocationDate", "type": "str"},
        "links": {"key": "properties.links", "type": "[ExpressRouteLink]"},
        "circuits": {"key": "properties.circuits", "type": "[SubResource]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "billing_type": {"key": "properties.billingType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_gbps: Optional[int] = None,
        encapsulation: Optional[Union[str, "_models.ExpressRoutePortsEncapsulation"]] = None,
        links: Optional[List["_models.ExpressRouteLink"]] = None,
        billing_type: Optional[Union[str, "_models.ExpressRoutePortsBillingType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of ExpressRoutePort, if configured.
        :paramtype identity: ~azure.mgmt.network.models.ManagedServiceIdentity
        :keyword peering_location: The name of the peering location that the ExpressRoutePort is mapped
         to physically.
        :paramtype peering_location: str
        :keyword bandwidth_in_gbps: Bandwidth of procured ports in Gbps.
        :paramtype bandwidth_in_gbps: int
        :keyword encapsulation: Encapsulation method on physical ports. Known values are: "Dot1Q" and
         "QinQ".
        :paramtype encapsulation: str or
         ~azure.mgmt.network.models.ExpressRoutePortsEncapsulation
        :keyword links: The set of physical links of the ExpressRoutePort resource.
        :paramtype links: list[~azure.mgmt.network.models.ExpressRouteLink]
        :keyword billing_type: The billing type of the ExpressRoutePort resource. Known values are:
         "MeteredData" and "UnlimitedData".
        :paramtype billing_type: str or
         ~azure.mgmt.network.models.ExpressRoutePortsBillingType
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.identity = identity
        self.peering_location = peering_location
        self.bandwidth_in_gbps = bandwidth_in_gbps
        self.provisioned_bandwidth_in_gbps = None
        self.mtu = None
        self.encapsulation = encapsulation
        self.ether_type = None
        self.allocation_date = None
        self.links = links
        self.circuits = None
        self.provisioning_state = None
        self.resource_guid = None
        self.billing_type = billing_type

class ExpressRoutePortListResult(_serialization.Model):
    """Response for ListExpressRoutePorts API service call.

    :ivar value: A list of ExpressRoutePort resources.
    :vartype value: list[~azure.mgmt.network.models.ExpressRoutePort]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRoutePort]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRoutePort"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ExpressRoutePort resources.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRoutePort]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExpressRoutePortsLocation(Resource):
    """Definition of the ExpressRoutePorts peering location resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar address: Address of peering location.
    :vartype address: str
    :ivar contact: Contact details of peering locations.
    :vartype contact: str
    :ivar available_bandwidths: The inventory of available ExpressRoutePort bandwidths.
    :vartype available_bandwidths:
     list[~azure.mgmt.network.models.ExpressRoutePortsLocationBandwidths]
    :ivar provisioning_state: The provisioning state of the express route port location resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "address": {"readonly": True},
        "contact": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "address": {"key": "properties.address", "type": "str"},
        "contact": {"key": "properties.contact", "type": "str"},
        "available_bandwidths": {
            "key": "properties.availableBandwidths",
            "type": "[ExpressRoutePortsLocationBandwidths]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        available_bandwidths: Optional[List["_models.ExpressRoutePortsLocationBandwidths"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword available_bandwidths: The inventory of available ExpressRoutePort bandwidths.
        :paramtype available_bandwidths:
         list[~azure.mgmt.network.models.ExpressRoutePortsLocationBandwidths]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.address = None
        self.contact = None
        self.available_bandwidths = available_bandwidths
        self.provisioning_state = None

class ExpressRoutePortsLocationBandwidths(_serialization.Model):
    """Real-time inventory of available ExpressRoute port bandwidths.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar offer_name: Bandwidth descriptive name.
    :vartype offer_name: str
    :ivar value_in_gbps: Bandwidth value in Gbps.
    :vartype value_in_gbps: int
    """

    _validation = {
        "offer_name": {"readonly": True},
        "value_in_gbps": {"readonly": True},
    }

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_gbps": {"key": "valueInGbps", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offer_name = None
        self.value_in_gbps = None

class ExpressRoutePortsLocationListResult(_serialization.Model):
    """Response for ListExpressRoutePortsLocations API service call.

    :ivar value: The list of all ExpressRoutePort peering locations.
    :vartype value: list[~azure.mgmt.network.models.ExpressRoutePortsLocation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRoutePortsLocation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRoutePortsLocation"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of all ExpressRoutePort peering locations.
        :paramtype value: list[~azure.mgmt.network.models.ExpressRoutePortsLocation]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class FlowLogFormatParameters(_serialization.Model):
    """Parameters that define the flow log format.

    :ivar type: The file type of flow log. "JSON"
    :vartype type: str or ~azure.mgmt.network.models.FlowLogFormatType
    :ivar version: The version (revision) of the flow log.
    :vartype version: int
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "int"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.FlowLogFormatType"]] = None, version: int = 0, **kwargs: Any
    ) -> None:
        """
        :keyword type: The file type of flow log. "JSON"
        :paramtype type: str or ~azure.mgmt.network.models.FlowLogFormatType
        :keyword version: The version (revision) of the flow log.
        :paramtype version: int
        """
        super().__init__(**kwargs)
        self.type = type
        self.version = version

class IPConfigurationProfile(SubResource):
    """IP configuration profile child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource. This name can be used to access the resource.
    :vartype name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar subnet: The reference to the subnet resource to create a container network interface ip
     configuration.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar provisioning_state: The provisioning state of the IP configuration profile resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.Subnet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource. This name can be used to access the resource.
        :paramtype name: str
        :keyword subnet: The reference to the subnet resource to create a container network interface
         ip configuration.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.type = None
        self.etag = None
        self.subnet = subnet
        self.provisioning_state = None

class InterfaceEndpoint(Resource):  # pylint: disable=too-many-instance-attributes
    """Interface endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar fqdn: A first-party service's FQDN that is mapped to the private IP allocated via this
     interface endpoint.
    :vartype fqdn: str
    :ivar endpoint_service: A reference to the service being brought into the virtual network.
    :vartype endpoint_service: ~azure.mgmt.network.models.EndpointService
    :ivar subnet: The ID of the subnet from which the private IP will be allocated.
    :vartype subnet: ~azure.mgmt.network.models.Subnet
    :ivar network_interfaces: Gets an array of references to the network interfaces created for
     this interface endpoint.
    :vartype network_interfaces: list[~azure.mgmt.network.models.NetworkInterface]
    :ivar owner: A read-only property that identifies who created this interface endpoint.
    :vartype owner: str
    :ivar provisioning_state: The provisioning state of the interface endpoint. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "network_interfaces": {"readonly": True},
        "owner": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "endpoint_service": {"key": "properties.endpointService", "type": "EndpointService"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "owner": {"key": "properties.owner", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        fqdn: Optional[str] = None,
        endpoint_service: Optional["_models.EndpointService"] = None,
        subnet: Optional["_models.Subnet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword fqdn: A first-party service's FQDN that is mapped to the private IP allocated via this
         interface endpoint.
        :paramtype fqdn: str
        :keyword endpoint_service: A reference to the service being brought into the virtual network.
        :paramtype endpoint_service: ~azure.mgmt.network.models.EndpointService
        :keyword subnet: The ID of the subnet from which the private IP will be allocated.
        :paramtype subnet: ~azure.mgmt.network.models.Subnet
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.fqdn = fqdn
        self.endpoint_service = endpoint_service
        self.subnet = subnet
        self.network_interfaces = None
        self.owner = None
        self.provisioning_state = None

class InterfaceEndpointListResult(_serialization.Model):
    """Response for the ListInterfaceEndpoints API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a list of InterfaceEndpoint resources in a resource group.
    :vartype value: list[~azure.mgmt.network.models.InterfaceEndpoint]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InterfaceEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.InterfaceEndpoint"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Gets a list of InterfaceEndpoint resources in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.InterfaceEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class ListP2SVpnGatewaysResult(_serialization.Model):
    """Result of the request to list P2SVpnGateways. It contains a list of P2SVpnGateways and a URL
    nextLink to get the next set of results.

    :ivar value: List of P2SVpnGateways.
    :vartype value: list[~azure.mgmt.network.models.P2SVpnGateway]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[P2SVpnGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.P2SVpnGateway"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of P2SVpnGateways.
        :paramtype value: list[~azure.mgmt.network.models.P2SVpnGateway]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ListP2SVpnServerConfigurationsResult(_serialization.Model):
    """Result of the request to list all P2SVpnServerConfigurations associated to a VirtualWan. It
    contains a list of P2SVpnServerConfigurations and a URL nextLink to get the next set of
    results.

    :ivar value: List of P2SVpnServerConfigurations.
    :vartype value: list[~azure.mgmt.network.models.P2SVpnServerConfiguration]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[P2SVpnServerConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.P2SVpnServerConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of P2SVpnServerConfigurations.
        :paramtype value: list[~azure.mgmt.network.models.P2SVpnServerConfiguration]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class LoadBalancerOutboundRuleListResult(_serialization.Model):
    """Response for ListOutboundRule API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of outbound rules in a load balancer.
    :vartype value: list[~azure.mgmt.network.models.OutboundRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.OutboundRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of outbound rules in a load balancer.
        :paramtype value: list[~azure.mgmt.network.models.OutboundRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class ManagedServiceIdentity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity. This property will only
     be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned'
     includes both an implicitly created identity and a set of user assigned identities. The type
     'None' will remove any identities from the virtual machine. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.network.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with resource. The user
     identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.network.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]  # pylint: disable=line-too-long
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[
            Dict[
                str,
                "_models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties",
            ]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the resource. The type 'SystemAssigned,
         UserAssigned' includes both an implicitly created identity and a set of user assigned
         identities. The type 'None' will remove any identities from the virtual machine. Known values
         are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.network.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with resource. The
         user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.network.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]  # pylint: disable=line-too-long
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities

class MatchedRule(_serialization.Model):
    """Matched rule.

    :ivar rule_name: Name of the matched network security rule.
    :vartype rule_name: str
    :ivar action: The network traffic is allowed or denied. Possible values are 'Allow' and 'Deny'.
    :vartype action: str
    """

    _attribute_map = {
        "rule_name": {"key": "ruleName", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(self, *, rule_name: Optional[str] = None, action: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword rule_name: Name of the matched network security rule.
        :paramtype rule_name: str
        :keyword action: The network traffic is allowed or denied. Possible values are 'Allow' and
         'Deny'.
        :paramtype action: str
        """
        super().__init__(**kwargs)
        self.rule_name = rule_name
        self.action = action

class NetworkConfigurationDiagnosticParameters(_serialization.Model):
    """Parameters to get network configuration diagnostic.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_id: The ID of the target resource to perform network configuration
     diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application
     Gateway. Required.
    :vartype target_resource_id: str
    :ivar verbosity_level: Verbosity level. Known values are: "Normal", "Minimum", and "Full".
    :vartype verbosity_level: str or ~azure.mgmt.network.models.VerbosityLevel
    :ivar profiles: List of network configuration diagnostic profiles. Required.
    :vartype profiles:
     list[~azure.mgmt.network.models.NetworkConfigurationDiagnosticProfile]
    """

    _validation = {
        "target_resource_id": {"required": True},
        "profiles": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "verbosity_level": {"key": "verbosityLevel", "type": "str"},
        "profiles": {"key": "profiles", "type": "[NetworkConfigurationDiagnosticProfile]"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        profiles: List["_models.NetworkConfigurationDiagnosticProfile"],
        verbosity_level: Optional[Union[str, "_models.VerbosityLevel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_id: The ID of the target resource to perform network configuration
         diagnostic. Valid options are VM, NetworkInterface, VMSS/NetworkInterface and Application
         Gateway. Required.
        :paramtype target_resource_id: str
        :keyword verbosity_level: Verbosity level. Known values are: "Normal", "Minimum", and "Full".
        :paramtype verbosity_level: str or ~azure.mgmt.network.models.VerbosityLevel
        :keyword profiles: List of network configuration diagnostic profiles. Required.
        :paramtype profiles:
         list[~azure.mgmt.network.models.NetworkConfigurationDiagnosticProfile]
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.verbosity_level = verbosity_level
        self.profiles = profiles

class NetworkConfigurationDiagnosticProfile(_serialization.Model):
    """Parameters to compare with network configuration.

    All required parameters must be populated in order to send to server.

    :ivar direction: The direction of the traffic. Required. Known values are: "Inbound" and
     "Outbound".
    :vartype direction: str or ~azure.mgmt.network.models.Direction
    :ivar protocol: Protocol to be verified on. Accepted values are '*', TCP, UDP. Required.
    :vartype protocol: str
    :ivar source: Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag. Required.
    :vartype source: str
    :ivar destination: Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag.
     Required.
    :vartype destination: str
    :ivar destination_port: Traffic destination port. Accepted values are '*' and a single port in
     the range (0 - 65535). Required.
    :vartype destination_port: str
    """

    _validation = {
        "direction": {"required": True},
        "protocol": {"required": True},
        "source": {"required": True},
        "destination": {"required": True},
        "destination_port": {"required": True},
    }

    _attribute_map = {
        "direction": {"key": "direction", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "destination": {"key": "destination", "type": "str"},
        "destination_port": {"key": "destinationPort", "type": "str"},
    }

    def __init__(
        self,
        *,
        direction: Union[str, "_models.Direction"],
        protocol: str,
        source: str,
        destination: str,
        destination_port: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword direction: The direction of the traffic. Required. Known values are: "Inbound" and
         "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.models.Direction
        :keyword protocol: Protocol to be verified on. Accepted values are '*', TCP, UDP. Required.
        :paramtype protocol: str
        :keyword source: Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag.
         Required.
        :paramtype source: str
        :keyword destination: Traffic destination. Accepted values are: '*', IP Address/CIDR, Service
         Tag. Required.
        :paramtype destination: str
        :keyword destination_port: Traffic destination port. Accepted values are '*' and a single port
         in the range (0 - 65535). Required.
        :paramtype destination_port: str
        """
        super().__init__(**kwargs)
        self.direction = direction
        self.protocol = protocol
        self.source = source
        self.destination = destination
        self.destination_port = destination_port

class NetworkConfigurationDiagnosticResponse(_serialization.Model):
    """Results of network configuration diagnostic on the target resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar results: List of network configuration diagnostic results.
    :vartype results:
     list[~azure.mgmt.network.models.NetworkConfigurationDiagnosticResult]
    """

    _validation = {
        "results": {"readonly": True},
    }

    _attribute_map = {
        "results": {"key": "results", "type": "[NetworkConfigurationDiagnosticResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.results = None

class NetworkConfigurationDiagnosticResult(_serialization.Model):
    """Network configuration diagnostic result corresponded to provided traffic query.

    :ivar profile: Network configuration diagnostic profile.
    :vartype profile: ~azure.mgmt.network.models.NetworkConfigurationDiagnosticProfile
    :ivar network_security_group_result: Network security group result.
    :vartype network_security_group_result:
     ~azure.mgmt.network.models.NetworkSecurityGroupResult
    """

    _attribute_map = {
        "profile": {"key": "profile", "type": "NetworkConfigurationDiagnosticProfile"},
        "network_security_group_result": {"key": "networkSecurityGroupResult", "type": "NetworkSecurityGroupResult"},
    }

    def __init__(
        self,
        *,
        profile: Optional["_models.NetworkConfigurationDiagnosticProfile"] = None,
        network_security_group_result: Optional["_models.NetworkSecurityGroupResult"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword profile: Network configuration diagnostic profile.
        :paramtype profile:
         ~azure.mgmt.network.models.NetworkConfigurationDiagnosticProfile
        :keyword network_security_group_result: Network security group result.
        :paramtype network_security_group_result:
         ~azure.mgmt.network.models.NetworkSecurityGroupResult
        """
        super().__init__(**kwargs)
        self.profile = profile
        self.network_security_group_result = network_security_group_result

class NetworkInterfaceTapConfiguration(SubResource):
    """Tap configuration in a Network Interface.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar virtual_network_tap: The reference to the Virtual Network Tap resource.
    :vartype virtual_network_tap: ~azure.mgmt.network.models.VirtualNetworkTap
    :ivar provisioning_state: The provisioning state of the network interface tap configuration
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "virtual_network_tap": {"key": "properties.virtualNetworkTap", "type": "VirtualNetworkTap"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        virtual_network_tap: Optional["_models.VirtualNetworkTap"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword virtual_network_tap: The reference to the Virtual Network Tap resource.
        :paramtype virtual_network_tap: ~azure.mgmt.network.models.VirtualNetworkTap
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.virtual_network_tap = virtual_network_tap
        self.provisioning_state = None

class NetworkInterfaceTapConfigurationListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Response for list tap configurations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of tap configurations.
    :vartype value: list[~azure.mgmt.network.models.NetworkInterfaceTapConfiguration]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterfaceTapConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkInterfaceTapConfiguration"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of tap configurations.
        :paramtype value: list[~azure.mgmt.network.models.NetworkInterfaceTapConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None

class NetworkProfile(Resource):
    """Network profile resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar container_network_interfaces: List of child container network interfaces.
    :vartype container_network_interfaces:
     list[~azure.mgmt.network.models.ContainerNetworkInterface]
    :ivar container_network_interface_configurations: List of chid container network interface
     configurations.
    :vartype container_network_interface_configurations:
     list[~azure.mgmt.network.models.ContainerNetworkInterfaceConfiguration]
    :ivar resource_guid: The resource GUID property of the network profile resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network profile resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "container_network_interfaces": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "container_network_interfaces": {
            "key": "properties.containerNetworkInterfaces",
            "type": "[ContainerNetworkInterface]",
        },
        "container_network_interface_configurations": {
            "key": "properties.containerNetworkInterfaceConfigurations",
            "type": "[ContainerNetworkInterfaceConfiguration]",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        container_network_interface_configurations: Optional[
            List["_models.ContainerNetworkInterfaceConfiguration"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword container_network_interface_configurations: List of chid container network interface
         configurations.
        :paramtype container_network_interface_configurations:
         list[~azure.mgmt.network.models.ContainerNetworkInterfaceConfiguration]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.container_network_interfaces = None
        self.container_network_interface_configurations = container_network_interface_configurations
        self.resource_guid = None
        self.provisioning_state = None

class NetworkProfileListResult(_serialization.Model):
    """Response for ListNetworkProfiles API service call.

    :ivar value: A list of network profiles that exist in a resource group.
    :vartype value: list[~azure.mgmt.network.models.NetworkProfile]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkProfile"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of network profiles that exist in a resource group.
        :paramtype value: list[~azure.mgmt.network.models.NetworkProfile]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class NetworkSecurityGroupResult(_serialization.Model):
    """Network configuration diagnostic result corresponded provided traffic query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar security_rule_access_result: The network traffic is allowed or denied. Known values are:
     "Allow" and "Deny".
    :vartype security_rule_access_result: str or
     ~azure.mgmt.network.models.SecurityRuleAccess
    :ivar evaluated_network_security_groups: List of results network security groups diagnostic.
    :vartype evaluated_network_security_groups:
     list[~azure.mgmt.network.models.EvaluatedNetworkSecurityGroup]
    """

    _validation = {
        "evaluated_network_security_groups": {"readonly": True},
    }

    _attribute_map = {
        "security_rule_access_result": {"key": "securityRuleAccessResult", "type": "str"},
        "evaluated_network_security_groups": {
            "key": "evaluatedNetworkSecurityGroups",
            "type": "[EvaluatedNetworkSecurityGroup]",
        },
    }

    def __init__(
        self, *, security_rule_access_result: Optional[Union[str, "_models.SecurityRuleAccess"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword security_rule_access_result: The network traffic is allowed or denied. Known values
         are: "Allow" and "Deny".
        :paramtype security_rule_access_result: str or
         ~azure.mgmt.network.models.SecurityRuleAccess
        """
        super().__init__(**kwargs)
        self.security_rule_access_result = security_rule_access_result
        self.evaluated_network_security_groups = None

class NetworkSecurityRulesEvaluationResult(_serialization.Model):
    """Network security rules evaluation result.

    :ivar name: Name of the network security rule.
    :vartype name: str
    :ivar protocol_matched: Value indicating whether protocol is matched.
    :vartype protocol_matched: bool
    :ivar source_matched: Value indicating whether source is matched.
    :vartype source_matched: bool
    :ivar source_port_matched: Value indicating whether source port is matched.
    :vartype source_port_matched: bool
    :ivar destination_matched: Value indicating whether destination is matched.
    :vartype destination_matched: bool
    :ivar destination_port_matched: Value indicating whether destination port is matched.
    :vartype destination_port_matched: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "protocol_matched": {"key": "protocolMatched", "type": "bool"},
        "source_matched": {"key": "sourceMatched", "type": "bool"},
        "source_port_matched": {"key": "sourcePortMatched", "type": "bool"},
        "destination_matched": {"key": "destinationMatched", "type": "bool"},
        "destination_port_matched": {"key": "destinationPortMatched", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        protocol_matched: Optional[bool] = None,
        source_matched: Optional[bool] = None,
        source_port_matched: Optional[bool] = None,
        destination_matched: Optional[bool] = None,
        destination_port_matched: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the network security rule.
        :paramtype name: str
        :keyword protocol_matched: Value indicating whether protocol is matched.
        :paramtype protocol_matched: bool
        :keyword source_matched: Value indicating whether source is matched.
        :paramtype source_matched: bool
        :keyword source_port_matched: Value indicating whether source port is matched.
        :paramtype source_port_matched: bool
        :keyword destination_matched: Value indicating whether destination is matched.
        :paramtype destination_matched: bool
        :keyword destination_port_matched: Value indicating whether destination port is matched.
        :paramtype destination_port_matched: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.protocol_matched = protocol_matched
        self.source_matched = source_matched
        self.source_port_matched = source_port_matched
        self.destination_matched = destination_matched
        self.destination_port_matched = destination_port_matched

class OutboundRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Outbound rule of the load balancer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within the set of outbound rules used by
     the load balancer. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :vartype allocated_outbound_ports: int
    :ivar frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :vartype frontend_ip_configurations: list[~azure.mgmt.network.models.SubResource]
    :ivar backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.models.SubResource
    :ivar provisioning_state: The provisioning state of the outbound rule resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar protocol: The protocol for the outbound rule in load balancer. Known values are: "Tcp",
     "Udp", and "All".
    :vartype protocol: str or
     ~azure.mgmt.network.models.LoadBalancerOutboundRuleProtocol
    :ivar enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected
     connection termination. This element is only used when the protocol is set to TCP.
    :vartype enable_tcp_reset: bool
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection.
    :vartype idle_timeout_in_minutes: int
    """

    _validation = {
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "allocated_outbound_ports": {"key": "properties.allocatedOutboundPorts", "type": "int"},
        "frontend_ip_configurations": {"key": "properties.frontendIPConfigurations", "type": "[SubResource]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "enable_tcp_reset": {"key": "properties.enableTcpReset", "type": "bool"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        allocated_outbound_ports: Optional[int] = None,
        frontend_ip_configurations: Optional[List["_models.SubResource"]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.LoadBalancerOutboundRuleProtocol"]] = None,
        enable_tcp_reset: Optional[bool] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within the set of outbound rules used by
         the load balancer. This name can be used to access the resource.
        :paramtype name: str
        :keyword allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :paramtype allocated_outbound_ports: int
        :keyword frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :paramtype frontend_ip_configurations: list[~azure.mgmt.network.models.SubResource]
        :keyword backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.models.SubResource
        :keyword protocol: The protocol for the outbound rule in load balancer. Known values are:
         "Tcp", "Udp", and "All".
        :paramtype protocol: str or
         ~azure.mgmt.network.models.LoadBalancerOutboundRuleProtocol
        :keyword enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or
         unexpected connection termination. This element is only used when the protocol is set to TCP.
        :paramtype enable_tcp_reset: bool
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection.
        :paramtype idle_timeout_in_minutes: int
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.type = None
        self.allocated_outbound_ports = allocated_outbound_ports
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = None
        self.protocol = protocol
        self.enable_tcp_reset = enable_tcp_reset
        self.idle_timeout_in_minutes = idle_timeout_in_minutes

class P2SVpnGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """P2SVpnGateway Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_hub: The VirtualHub to which the gateway belongs.
    :vartype virtual_hub: ~azure.mgmt.network.models.SubResource
    :ivar p2_s_connection_configurations: List of all p2s connection configurations of the gateway.
    :vartype p2_s_connection_configurations:
     list[~azure.mgmt.network.models.P2SConnectionConfiguration]
    :ivar provisioning_state: The provisioning state of the P2S VPN gateway resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar vpn_gateway_scale_unit: The scale unit for this p2s vpn gateway.
    :vartype vpn_gateway_scale_unit: int
    :ivar vpn_server_configuration: The VpnServerConfiguration to which the p2sVpnGateway is
     attached to.
    :vartype vpn_server_configuration: ~azure.mgmt.network.models.SubResource
    :ivar vpn_client_connection_health: All P2S VPN clients' connection health status.
    :vartype vpn_client_connection_health:
     ~azure.mgmt.network.models.VpnClientConnectionHealth
    :ivar custom_dns_servers: List of all customer specified DNS servers IP addresses.
    :vartype custom_dns_servers: list[str]
    :ivar is_routing_preference_internet: Enable Routing Preference property for the Public IP
     Interface of the P2SVpnGateway.
    :vartype is_routing_preference_internet: bool
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "vpn_client_connection_health": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_hub": {"key": "properties.virtualHub", "type": "SubResource"},
        "p2_s_connection_configurations": {
            "key": "properties.p2SConnectionConfigurations",
            "type": "[P2SConnectionConfiguration]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "vpn_gateway_scale_unit": {"key": "properties.vpnGatewayScaleUnit", "type": "int"},
        "vpn_server_configuration": {"key": "properties.vpnServerConfiguration", "type": "SubResource"},
        "vpn_client_connection_health": {
            "key": "properties.vpnClientConnectionHealth",
            "type": "VpnClientConnectionHealth",
        },
        "custom_dns_servers": {"key": "properties.customDnsServers", "type": "[str]"},
        "is_routing_preference_internet": {"key": "properties.isRoutingPreferenceInternet", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_hub: Optional["_models.SubResource"] = None,
        p2_s_connection_configurations: Optional[List["_models.P2SConnectionConfiguration"]] = None,
        vpn_gateway_scale_unit: Optional[int] = None,
        vpn_server_configuration: Optional["_models.SubResource"] = None,
        custom_dns_servers: Optional[List[str]] = None,
        is_routing_preference_internet: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_hub: The VirtualHub to which the gateway belongs.
        :paramtype virtual_hub: ~azure.mgmt.network.models.SubResource
        :keyword p2_s_connection_configurations: List of all p2s connection configurations of the
         gateway.
        :paramtype p2_s_connection_configurations:
         list[~azure.mgmt.network.models.P2SConnectionConfiguration]
        :keyword vpn_gateway_scale_unit: The scale unit for this p2s vpn gateway.
        :paramtype vpn_gateway_scale_unit: int
        :keyword vpn_server_configuration: The VpnServerConfiguration to which the p2sVpnGateway is
         attached to.
        :paramtype vpn_server_configuration: ~azure.mgmt.network.models.SubResource
        :keyword custom_dns_servers: List of all customer specified DNS servers IP addresses.
        :paramtype custom_dns_servers: list[str]
        :keyword is_routing_preference_internet: Enable Routing Preference property for the Public IP
         Interface of the P2SVpnGateway.
        :paramtype is_routing_preference_internet: bool
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.virtual_hub = virtual_hub
        self.p2_s_connection_configurations = p2_s_connection_configurations
        self.provisioning_state = None
        self.vpn_gateway_scale_unit = vpn_gateway_scale_unit
        self.vpn_server_configuration = vpn_server_configuration
        self.vpn_client_connection_health = None
        self.custom_dns_servers = custom_dns_servers
        self.is_routing_preference_internet = is_routing_preference_internet

class P2SVpnProfileParameters(_serialization.Model):
    """Vpn Client Parameters for package generation.

    :ivar authentication_method: VPN client authentication method. Known values are: "EAPTLS" and
     "EAPMSCHAPv2".
    :vartype authentication_method: str or
     ~azure.mgmt.network.models.AuthenticationMethod
    """

    _attribute_map = {
        "authentication_method": {"key": "authenticationMethod", "type": "str"},
    }

    def __init__(
        self, *, authentication_method: Optional[Union[str, "_models.AuthenticationMethod"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword authentication_method: VPN client authentication method. Known values are: "EAPTLS"
         and "EAPMSCHAPv2".
        :paramtype authentication_method: str or
         ~azure.mgmt.network.models.AuthenticationMethod
        """
        super().__init__(**kwargs)
        self.authentication_method = authentication_method

class P2SVpnServerConfigRadiusClientRootCertificate(SubResource):  # pylint: disable=name-too-long
    """Radius client root certificate of P2SVpnServerConfiguration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar thumbprint: The Radius client root certificate thumbprint.
    :vartype thumbprint: str
    :ivar provisioning_state: The provisioning state of the radius client root certificate
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword thumbprint: The Radius client root certificate thumbprint.
        :paramtype thumbprint: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.thumbprint = thumbprint
        self.provisioning_state = None

class P2SVpnServerConfigRadiusServerRootCertificate(SubResource):  # pylint: disable=name-too-long
    """Radius Server root certificate of P2SVpnServerConfiguration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar public_cert_data: The certificate public data. Required.
    :vartype public_cert_data: str
    :ivar provisioning_state: The provisioning state of the radius server root certificate
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "public_cert_data": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_cert_data: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword public_cert_data: The certificate public data. Required.
        :paramtype public_cert_data: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.public_cert_data = public_cert_data
        self.provisioning_state = None

class P2SVpnServerConfigVpnClientRevokedCertificate(SubResource):  # pylint: disable=name-too-long
    """VPN client revoked certificate of P2SVpnServerConfiguration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar thumbprint: The revoked VPN client certificate thumbprint.
    :vartype thumbprint: str
    :ivar provisioning_state: The provisioning state of the VPN client revoked certificate
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword thumbprint: The revoked VPN client certificate thumbprint.
        :paramtype thumbprint: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.thumbprint = thumbprint
        self.provisioning_state = None

class P2SVpnServerConfigVpnClientRootCertificate(SubResource):  # pylint: disable=name-too-long
    """VPN client root certificate of P2SVpnServerConfiguration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar public_cert_data: The certificate public data. Required.
    :vartype public_cert_data: str
    :ivar provisioning_state: The provisioning state of the VPN client root certificate resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    """

    _validation = {
        "public_cert_data": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_cert_data: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword public_cert_data: The certificate public data. Required.
        :paramtype public_cert_data: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.public_cert_data = public_cert_data
        self.provisioning_state = None

class P2SVpnServerConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """P2SVpnServerConfiguration Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar name_properties_name: The name of the P2SVpnServerConfiguration that is unique within a
     VirtualWan in a resource group. This name can be used to access the resource along with Paren
     VirtualWan resource name.
    :vartype name_properties_name: str
    :ivar vpn_protocols: VPN protocols for the P2SVpnServerConfiguration.
    :vartype vpn_protocols: list[str or
     ~azure.mgmt.network.models.VpnGatewayTunnelingProtocol]
    :ivar p2_s_vpn_server_config_vpn_client_root_certificates: VPN client root certificate of
     P2SVpnServerConfiguration.
    :vartype p2_s_vpn_server_config_vpn_client_root_certificates:
     list[~azure.mgmt.network.models.P2SVpnServerConfigVpnClientRootCertificate]
    :ivar p2_s_vpn_server_config_vpn_client_revoked_certificates: VPN client revoked certificate of
     P2SVpnServerConfiguration.
    :vartype p2_s_vpn_server_config_vpn_client_revoked_certificates:
     list[~azure.mgmt.network.models.P2SVpnServerConfigVpnClientRevokedCertificate]
    :ivar p2_s_vpn_server_config_radius_server_root_certificates: Radius Server root certificate of
     P2SVpnServerConfiguration.
    :vartype p2_s_vpn_server_config_radius_server_root_certificates:
     list[~azure.mgmt.network.models.P2SVpnServerConfigRadiusServerRootCertificate]
    :ivar p2_s_vpn_server_config_radius_client_root_certificates: Radius client root certificate of
     P2SVpnServerConfiguration.
    :vartype p2_s_vpn_server_config_radius_client_root_certificates:
     list[~azure.mgmt.network.models.P2SVpnServerConfigRadiusClientRootCertificate]
    :ivar vpn_client_ipsec_policies: VpnClientIpsecPolicies for P2SVpnServerConfiguration.
    :vartype vpn_client_ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
    :ivar radius_server_address: The radius server address property of the
     P2SVpnServerConfiguration resource for point to site client connection.
    :vartype radius_server_address: str
    :ivar radius_server_secret: The radius secret property of the P2SVpnServerConfiguration
     resource for point to site client connection.
    :vartype radius_server_secret: str
    :ivar provisioning_state: The provisioning state of the P2S VPN server configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar p2_s_vpn_gateways: List of references to P2SVpnGateways.
    :vartype p2_s_vpn_gateways: list[~azure.mgmt.network.models.SubResource]
    :ivar etag_properties_etag: A unique read-only string that changes whenever the resource is
     updated.
    :vartype etag_properties_etag: str
    """

    _validation = {
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "p2_s_vpn_gateways": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "vpn_protocols": {"key": "properties.vpnProtocols", "type": "[str]"},
        "p2_s_vpn_server_config_vpn_client_root_certificates": {
            "key": "properties.p2SVpnServerConfigVpnClientRootCertificates",
            "type": "[P2SVpnServerConfigVpnClientRootCertificate]",
        },
        "p2_s_vpn_server_config_vpn_client_revoked_certificates": {
            "key": "properties.p2SVpnServerConfigVpnClientRevokedCertificates",
            "type": "[P2SVpnServerConfigVpnClientRevokedCertificate]",
        },
        "p2_s_vpn_server_config_radius_server_root_certificates": {
            "key": "properties.p2SVpnServerConfigRadiusServerRootCertificates",
            "type": "[P2SVpnServerConfigRadiusServerRootCertificate]",
        },
        "p2_s_vpn_server_config_radius_client_root_certificates": {
            "key": "properties.p2SVpnServerConfigRadiusClientRootCertificates",
            "type": "[P2SVpnServerConfigRadiusClientRootCertificate]",
        },
        "vpn_client_ipsec_policies": {"key": "properties.vpnClientIpsecPolicies", "type": "[IpsecPolicy]"},
        "radius_server_address": {"key": "properties.radiusServerAddress", "type": "str"},
        "radius_server_secret": {"key": "properties.radiusServerSecret", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "p2_s_vpn_gateways": {"key": "properties.p2SVpnGateways", "type": "[SubResource]"},
        "etag_properties_etag": {"key": "properties.etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        vpn_protocols: Optional[List[Union[str, "_models.VpnGatewayTunnelingProtocol"]]] = None,
        p2_s_vpn_server_config_vpn_client_root_certificates: Optional[
            List["_models.P2SVpnServerConfigVpnClientRootCertificate"]
        ] = None,
        p2_s_vpn_server_config_vpn_client_revoked_certificates: Optional[
            List["_models.P2SVpnServerConfigVpnClientRevokedCertificate"]
        ] = None,
        p2_s_vpn_server_config_radius_server_root_certificates: Optional[
            List["_models.P2SVpnServerConfigRadiusServerRootCertificate"]
        ] = None,
        p2_s_vpn_server_config_radius_client_root_certificates: Optional[
            List["_models.P2SVpnServerConfigRadiusClientRootCertificate"]
        ] = None,
        vpn_client_ipsec_policies: Optional[List["_models.IpsecPolicy"]] = None,
        radius_server_address: Optional[str] = None,
        radius_server_secret: Optional[str] = None,
        etag_properties_etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword name_properties_name: The name of the P2SVpnServerConfiguration that is unique within
         a VirtualWan in a resource group. This name can be used to access the resource along with Paren
         VirtualWan resource name.
        :paramtype name_properties_name: str
        :keyword vpn_protocols: VPN protocols for the P2SVpnServerConfiguration.
        :paramtype vpn_protocols: list[str or
         ~azure.mgmt.network.models.VpnGatewayTunnelingProtocol]
        :keyword p2_s_vpn_server_config_vpn_client_root_certificates: VPN client root certificate of
         P2SVpnServerConfiguration.
        :paramtype p2_s_vpn_server_config_vpn_client_root_certificates:
         list[~azure.mgmt.network.models.P2SVpnServerConfigVpnClientRootCertificate]
        :keyword p2_s_vpn_server_config_vpn_client_revoked_certificates: VPN client revoked certificate
         of P2SVpnServerConfiguration.
        :paramtype p2_s_vpn_server_config_vpn_client_revoked_certificates:
         list[~azure.mgmt.network.models.P2SVpnServerConfigVpnClientRevokedCertificate]
        :keyword p2_s_vpn_server_config_radius_server_root_certificates: Radius Server root certificate
         of P2SVpnServerConfiguration.
        :paramtype p2_s_vpn_server_config_radius_server_root_certificates:
         list[~azure.mgmt.network.models.P2SVpnServerConfigRadiusServerRootCertificate]
        :keyword p2_s_vpn_server_config_radius_client_root_certificates: Radius client root certificate
         of P2SVpnServerConfiguration.
        :paramtype p2_s_vpn_server_config_radius_client_root_certificates:
         list[~azure.mgmt.network.models.P2SVpnServerConfigRadiusClientRootCertificate]
        :keyword vpn_client_ipsec_policies: VpnClientIpsecPolicies for P2SVpnServerConfiguration.
        :paramtype vpn_client_ipsec_policies: list[~azure.mgmt.network.models.IpsecPolicy]
        :keyword radius_server_address: The radius server address property of the
         P2SVpnServerConfiguration resource for point to site client connection.
        :paramtype radius_server_address: str
        :keyword radius_server_secret: The radius secret property of the P2SVpnServerConfiguration
         resource for point to site client connection.
        :paramtype radius_server_secret: str
        :keyword etag_properties_etag: A unique read-only string that changes whenever the resource is
         updated.
        :paramtype etag_properties_etag: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = None
        self.name_properties_name = name_properties_name
        self.vpn_protocols = vpn_protocols
        self.p2_s_vpn_server_config_vpn_client_root_certificates = p2_s_vpn_server_config_vpn_client_root_certificates
        self.p2_s_vpn_server_config_vpn_client_revoked_certificates = (
            p2_s_vpn_server_config_vpn_client_revoked_certificates
        )
        self.p2_s_vpn_server_config_radius_server_root_certificates = (
            p2_s_vpn_server_config_radius_server_root_certificates
        )
        self.p2_s_vpn_server_config_radius_client_root_certificates = (
            p2_s_vpn_server_config_radius_client_root_certificates
        )
        self.vpn_client_ipsec_policies = vpn_client_ipsec_policies
        self.radius_server_address = radius_server_address
        self.radius_server_secret = radius_server_secret
        self.provisioning_state = None
        self.p2_s_vpn_gateways = None
        self.etag_properties_etag = etag_properties_etag

class ProtocolCustomSettingsFormat(_serialization.Model):
    """DDoS custom policy properties.

    :ivar protocol: The protocol for which the DDoS protection policy is being customized. Known
     values are: "Tcp", "Udp", and "Syn".
    :vartype protocol: str or ~azure.mgmt.network.models.DdosCustomPolicyProtocol
    :ivar trigger_rate_override: The customized DDoS protection trigger rate.
    :vartype trigger_rate_override: str
    :ivar source_rate_override: The customized DDoS protection source rate.
    :vartype source_rate_override: str
    :ivar trigger_sensitivity_override: The customized DDoS protection trigger rate sensitivity
     degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger
     rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less
     sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t.
     normal traffic. Known values are: "Relaxed", "Low", "Default", and "High".
    :vartype trigger_sensitivity_override: str or
     ~azure.mgmt.network.models.DdosCustomPolicyTriggerSensitivityOverride
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "trigger_rate_override": {"key": "triggerRateOverride", "type": "str"},
        "source_rate_override": {"key": "sourceRateOverride", "type": "str"},
        "trigger_sensitivity_override": {"key": "triggerSensitivityOverride", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.DdosCustomPolicyProtocol"]] = None,
        trigger_rate_override: Optional[str] = None,
        source_rate_override: Optional[str] = None,
        trigger_sensitivity_override: Optional[Union[str, "_models.DdosCustomPolicyTriggerSensitivityOverride"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol: The protocol for which the DDoS protection policy is being customized. Known
         values are: "Tcp", "Udp", and "Syn".
        :paramtype protocol: str or ~azure.mgmt.network.models.DdosCustomPolicyProtocol
        :keyword trigger_rate_override: The customized DDoS protection trigger rate.
        :paramtype trigger_rate_override: str
        :keyword source_rate_override: The customized DDoS protection source rate.
        :paramtype source_rate_override: str
        :keyword trigger_sensitivity_override: The customized DDoS protection trigger rate sensitivity
         degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger
         rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less
         sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t.
         normal traffic. Known values are: "Relaxed", "Low", "Default", and "High".
        :paramtype trigger_sensitivity_override: str or
         ~azure.mgmt.network.models.DdosCustomPolicyTriggerSensitivityOverride
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.trigger_rate_override = trigger_rate_override
        self.source_rate_override = source_rate_override
        self.trigger_sensitivity_override = trigger_sensitivity_override

class PublicIPPrefix(Resource):  # pylint: disable=too-many-instance-attributes
    """Public IP prefix resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the public ip address.
    :vartype extended_location: ~azure.mgmt.network.models.ExtendedLocation
    :ivar sku: The public IP prefix SKU.
    :vartype sku: ~azure.mgmt.network.models.PublicIPPrefixSku
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: A list of availability zones denoting the IP allocated for the resource needs to
     come from.
    :vartype zones: list[str]
    :ivar public_ip_address_version: The public IP address version. Known values are: "IPv4" and
     "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.network.models.IPVersion
    :ivar ip_tags: The list of tags associated with the public IP prefix.
    :vartype ip_tags: list[~azure.mgmt.network.models.IpTag]
    :ivar prefix_length: The Length of the Public IP Prefix.
    :vartype prefix_length: int
    :ivar ip_prefix: The allocated Prefix.
    :vartype ip_prefix: str
    :ivar public_ip_addresses: The list of all referenced PublicIPAddresses.
    :vartype public_ip_addresses:
     list[~azure.mgmt.network.models.ReferencedPublicIpAddress]
    :ivar load_balancer_frontend_ip_configuration: The reference to load balancer frontend IP
     configuration associated with the public IP prefix.
    :vartype load_balancer_frontend_ip_configuration:
     ~azure.mgmt.network.models.SubResource
    :ivar custom_ip_prefix: The customIpPrefix that this prefix is associated with.
    :vartype custom_ip_prefix: ~azure.mgmt.network.models.SubResource
    :ivar resource_guid: The resource GUID property of the public IP prefix resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP prefix resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.network.models.ProvisioningState
    :ivar nat_gateway: NatGateway of Public IP Prefix.
    :vartype nat_gateway: ~azure.mgmt.network.models.NatGateway
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "ip_prefix": {"readonly": True},
        "public_ip_addresses": {"readonly": True},
        "load_balancer_frontend_ip_configuration": {"readonly": True},
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": 