# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class DeidPropertiesUpdate(_model_base.Model):
    """The template for adding optional properties.

    :ivar public_network_access: Gets or sets allow or disallow public network access to resource.
     Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.healthdataaiservices.models.PublicNetworkAccess
    """

    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(name="publicNetworkAccess")
    """Gets or sets allow or disallow public network access to resource. Known values are: \"Enabled\"
     and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthdataaiservices.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthdataaiservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DeidService(TrackedResource):
    """A HealthDataAIServicesProviderHub resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthdataaiservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.healthdataaiservices.models.DeidServiceProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.healthdataaiservices.models.ManagedServiceIdentity
    """

    properties: Optional["_models.DeidServiceProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field()
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.DeidServiceProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DeidServiceProperties(_model_base.Model):
    """Details of the HealthDataAIServices DeidService.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.healthdataaiservices.models.ProvisioningState
    :ivar service_url: Deid service url.
    :vartype service_url: str
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.healthdataaiservices.models.PrivateEndpointConnection]
    :ivar public_network_access: Gets or sets allow or disallow public network access to resource.
     Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.healthdataaiservices.models.PublicNetworkAccess
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""
    service_url: Optional[str] = rest_field(name="serviceUrl", visibility=["read"])
    """Deid service url."""
    private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connections."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(name="publicNetworkAccess")
    """Gets or sets allow or disallow public network access to resource. Known values are: \"Enabled\"
     and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DeidUpdate(_model_base.Model):
    """Patch request body for DeidService.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Updatable managed service identity.
    :vartype identity: ~azure.mgmt.healthdataaiservices.models.ManagedServiceIdentityUpdate
    :ivar properties: RP-specific properties.
    :vartype properties: ~azure.mgmt.healthdataaiservices.models.DeidPropertiesUpdate
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    identity: Optional["_models.ManagedServiceIdentityUpdate"] = rest_field()
    """Updatable managed service identity."""
    properties: Optional["_models.DeidPropertiesUpdate"] = rest_field()
    """RP-specific properties."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentityUpdate"] = None,
        properties: Optional["_models.DeidPropertiesUpdate"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.healthdataaiservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.healthdataaiservices.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.healthdataaiservices.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_model_base.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.healthdataaiservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.healthdataaiservices.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field()
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities"
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ManagedServiceIdentityUpdate(_model_base.Model):
    """The template for adding optional properties.

    :ivar type: The type of managed identity assigned to this resource. Known values are: "None",
     "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.healthdataaiservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.healthdataaiservices.models.UserAssignedIdentity]
    """

    type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = rest_field()
    """The type of managed identity assigned to this resource. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities"
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.healthdataaiservices.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.healthdataaiservices.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.healthdataaiservices.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PrivateEndpoint(_model_base.Model):
    """The Private Endpoint resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier for private endpoint.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource identifier for private endpoint."""


class PrivateEndpointConnection(Resource):
    """The private endpoint connection resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthdataaiservices.models.SystemData
    :ivar properties: The private endpoint connection properties.
    :vartype properties:
     ~azure.mgmt.healthdataaiservices.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field()
    """The private endpoint connection properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionProperties(_model_base.Model):
    """Properties of the private endpoint connection.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.healthdataaiservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.healthdataaiservices.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.healthdataaiservices.models.PrivateEndpointConnectionProvisioningState
    """

    group_ids: Optional[List[str]] = rest_field(name="groupIds", visibility=["read"])
    """The group ids for the private endpoint resource."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(name="privateEndpoint")
    """The private endpoint resource."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState"
    )
    """A collection of information about the state of the connection between service consumer and
     provider. Required."""
    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the private endpoint connection resource. Known values are:
     \"Succeeded\", \"Creating\", \"Deleting\", and \"Failed\"."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthdataaiservices.models.SystemData
    """


class PrivateEndpointConnectionResource(ProxyResource):
    """Holder for private endpoint connections.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthdataaiservices.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.healthdataaiservices.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateLinkResource(ProxyResource):
    """Private Links for DeidService resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.healthdataaiservices.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.healthdataaiservices.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateLinkResourceProperties(_model_base.Model):
    """Properties of a private link resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The private link resource group id."""
    required_members: Optional[List[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The private link resource required member names."""
    required_zone_names: Optional[List[str]] = rest_field(name="requiredZoneNames")
    """The private link resource private link DNS zone name."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_model_base.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.healthdataaiservices.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field()
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
     service. Known values are: \"Pending\", \"Approved\", and \"Rejected\"."""
    description: Optional[str] = rest_field()
    """The reason for approval/rejection of the connection."""
    actions_required: Optional[str] = rest_field(name="actionsRequired")
    """A message indicating if changes on the service provider require any updates on the consumer."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.healthdataaiservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.healthdataaiservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_model_base.Model):
    """User assigned identity properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
