# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.deviceregistry.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.deviceregistry.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Asset(TrackedResource):
    """Asset definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.deviceregistry.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.deviceregistry.models.AssetProperties
    :ivar extended_location: The extended location. Required.
    :vartype extended_location: ~azure.mgmt.deviceregistry.models.ExtendedLocation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AssetProperties"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AssetProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.deviceregistry.models.AssetProperties
        :keyword extended_location: The extended location. Required.
        :paramtype extended_location: ~azure.mgmt.deviceregistry.models.ExtendedLocation
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.extended_location = extended_location


class AssetEndpointProfile(TrackedResource):
    """Asset Endpoint Profile definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.deviceregistry.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.deviceregistry.models.AssetEndpointProfileProperties
    :ivar extended_location: The extended location. Required.
    :vartype extended_location: ~azure.mgmt.deviceregistry.models.ExtendedLocation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "extended_location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AssetEndpointProfileProperties"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AssetEndpointProfileProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.deviceregistry.models.AssetEndpointProfileProperties
        :keyword extended_location: The extended location. Required.
        :paramtype extended_location: ~azure.mgmt.deviceregistry.models.ExtendedLocation
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.extended_location = extended_location


class AssetEndpointProfileListResult(_serialization.Model):
    """The response of a AssetEndpointProfile list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssetEndpointProfile items on this page. Required.
    :vartype value: list[~azure.mgmt.deviceregistry.models.AssetEndpointProfile]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssetEndpointProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssetEndpointProfile"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssetEndpointProfile items on this page. Required.
        :paramtype value: list[~azure.mgmt.deviceregistry.models.AssetEndpointProfile]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssetEndpointProfileProperties(_serialization.Model):
    """Defines the Asset Endpoint Profile properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar uuid: Globally unique, immutable, non-reusable id.
    :vartype uuid: str
    :ivar target_address: The local valid URI specifying the network address/DNS name of a
     southbound device. The scheme part of the targetAddress URI specifies the type of the device.
     The additionalConfiguration field holds further connector type specific configuration.
     Required.
    :vartype target_address: str
    :ivar user_authentication: Defines the client authentication mechanism to the server.
    :vartype user_authentication: ~azure.mgmt.deviceregistry.models.UserAuthentication
    :ivar transport_authentication: Defines the authentication mechanism for the southbound
     connector connecting to the shop floor/OT device.
    :vartype transport_authentication: ~azure.mgmt.deviceregistry.models.TransportAuthentication
    :ivar additional_configuration: Contains connectivity type specific further configuration (e.g.
     OPC UA, Modbus, ONVIF).
    :vartype additional_configuration: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.deviceregistry.models.ProvisioningState
    """

    _validation = {
        "uuid": {"readonly": True},
        "target_address": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "uuid": {"key": "uuid", "type": "str"},
        "target_address": {"key": "targetAddress", "type": "str"},
        "user_authentication": {"key": "userAuthentication", "type": "UserAuthentication"},
        "transport_authentication": {"key": "transportAuthentication", "type": "TransportAuthentication"},
        "additional_configuration": {"key": "additionalConfiguration", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_address: str,
        user_authentication: Optional["_models.UserAuthentication"] = None,
        transport_authentication: Optional["_models.TransportAuthentication"] = None,
        additional_configuration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_address: The local valid URI specifying the network address/DNS name of a
         southbound device. The scheme part of the targetAddress URI specifies the type of the device.
         The additionalConfiguration field holds further connector type specific configuration.
         Required.
        :paramtype target_address: str
        :keyword user_authentication: Defines the client authentication mechanism to the server.
        :paramtype user_authentication: ~azure.mgmt.deviceregistry.models.UserAuthentication
        :keyword transport_authentication: Defines the authentication mechanism for the southbound
         connector connecting to the shop floor/OT device.
        :paramtype transport_authentication: ~azure.mgmt.deviceregistry.models.TransportAuthentication
        :keyword additional_configuration: Contains connectivity type specific further configuration
         (e.g. OPC UA, Modbus, ONVIF).
        :paramtype additional_configuration: str
        """
        super().__init__(**kwargs)
        self.uuid = None
        self.target_address = target_address
        self.user_authentication = user_authentication
        self.transport_authentication = transport_authentication
        self.additional_configuration = additional_configuration
        self.provisioning_state = None


class AssetEndpointProfileUpdate(_serialization.Model):
    """The type used for update operations of the AssetEndpointProfile.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the AssetEndpointProfile.
    :vartype properties: ~azure.mgmt.deviceregistry.models.AssetEndpointProfileUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "AssetEndpointProfileUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AssetEndpointProfileUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the AssetEndpointProfile.
        :paramtype properties: ~azure.mgmt.deviceregistry.models.AssetEndpointProfileUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class AssetEndpointProfileUpdateProperties(_serialization.Model):
    """The updatable properties of the AssetEndpointProfile.

    :ivar target_address: The local valid URI specifying the network address/DNS name of a
     southbound device. The scheme part of the targetAddress URI specifies the type of the device.
     The additionalConfiguration field holds further connector type specific configuration.
    :vartype target_address: str
    :ivar user_authentication: Defines the client authentication mechanism to the server.
    :vartype user_authentication: ~azure.mgmt.deviceregistry.models.UserAuthenticationUpdate
    :ivar transport_authentication: Defines the authentication mechanism for the southbound
     connector connecting to the shop floor/OT device.
    :vartype transport_authentication:
     ~azure.mgmt.deviceregistry.models.TransportAuthenticationUpdate
    :ivar additional_configuration: Contains connectivity type specific further configuration (e.g.
     OPC UA, Modbus, ONVIF).
    :vartype additional_configuration: str
    """

    _attribute_map = {
        "target_address": {"key": "targetAddress", "type": "str"},
        "user_authentication": {"key": "userAuthentication", "type": "UserAuthenticationUpdate"},
        "transport_authentication": {"key": "transportAuthentication", "type": "TransportAuthenticationUpdate"},
        "additional_configuration": {"key": "additionalConfiguration", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_address: Optional[str] = None,
        user_authentication: Optional["_models.UserAuthenticationUpdate"] = None,
        transport_authentication: Optional["_models.TransportAuthenticationUpdate"] = None,
        additional_configuration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_address: The local valid URI specifying the network address/DNS name of a
         southbound device. The scheme part of the targetAddress URI specifies the type of the device.
         The additionalConfiguration field holds further connector type specific configuration.
        :paramtype target_address: str
        :keyword user_authentication: Defines the client authentication mechanism to the server.
        :paramtype user_authentication: ~azure.mgmt.deviceregistry.models.UserAuthenticationUpdate
        :keyword transport_authentication: Defines the authentication mechanism for the southbound
         connector connecting to the shop floor/OT device.
        :paramtype transport_authentication:
         ~azure.mgmt.deviceregistry.models.TransportAuthenticationUpdate
        :keyword additional_configuration: Contains connectivity type specific further configuration
         (e.g. OPC UA, Modbus, ONVIF).
        :paramtype additional_configuration: str
        """
        super().__init__(**kwargs)
        self.target_address = target_address
        self.user_authentication = user_authentication
        self.transport_authentication = transport_authentication
        self.additional_configuration = additional_configuration


class AssetListResult(_serialization.Model):
    """The response of a Asset list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Asset items on this page. Required.
    :vartype value: list[~azure.mgmt.deviceregistry.models.Asset]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Asset]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Asset"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Asset items on this page. Required.
        :paramtype value: list[~azure.mgmt.deviceregistry.models.Asset]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssetProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Defines the asset properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar uuid: Globally unique, immutable, non-reusable id.
    :vartype uuid: str
    :ivar asset_type: Resource path to asset type (model) definition.
    :vartype asset_type: str
    :ivar enabled: Enabled/Disabled status of the asset.
    :vartype enabled: bool
    :ivar external_asset_id: Asset id provided by the customer.
    :vartype external_asset_id: str
    :ivar display_name: Human-readable display name.
    :vartype display_name: str
    :ivar description: Human-readable description of the asset.
    :vartype description: str
    :ivar asset_endpoint_profile_uri: A reference to the asset endpoint profile (connection
     information) used by brokers to connect to an endpoint that provides data points for this
     asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>. Required.
    :vartype asset_endpoint_profile_uri: str
    :ivar version: An integer that is incremented each time the resource is modified.
    :vartype version: int
    :ivar manufacturer: Asset manufacturer name.
    :vartype manufacturer: str
    :ivar manufacturer_uri: Asset manufacturer URI.
    :vartype manufacturer_uri: str
    :ivar model: Asset model name.
    :vartype model: str
    :ivar product_code: Asset product code.
    :vartype product_code: str
    :ivar hardware_revision: Revision number of the hardware.
    :vartype hardware_revision: str
    :ivar software_revision: Revision number of the software.
    :vartype software_revision: str
    :ivar documentation_uri: Reference to the documentation.
    :vartype documentation_uri: str
    :ivar serial_number: Asset serial number.
    :vartype serial_number: str
    :ivar attributes: A set of key-value pairs that contain custom attributes set by the customer.
    :vartype attributes: dict[str, any]
    :ivar default_data_points_configuration: Protocol-specific default configuration for all data
     points. Each data point can have its own configuration that overrides the default settings
     here. This assumes that each asset instance has one protocol.
    :vartype default_data_points_configuration: str
    :ivar default_events_configuration: Protocol-specific default configuration for all events.
     Each event can have its own configuration that overrides the default settings here. This
     assumes that each asset instance has one protocol.
    :vartype default_events_configuration: str
    :ivar data_points: Array of data points that are part of the asset. Each data point can
     reference an asset type capability and have per-data point configuration. See below for more
     details for the definition of the dataPoints element.
    :vartype data_points: list[~azure.mgmt.deviceregistry.models.DataPoint]
    :ivar events: Array of events that are part of the asset. Each event can reference an asset
     type capability and have per-event configuration. See below for more details about the
     definition of the events element.
    :vartype events: list[~azure.mgmt.deviceregistry.models.Event]
    :ivar status: Read only object to reflect changes that have occurred on the Edge. Similar to
     Kubernetes status property for custom resources.
    :vartype status: ~azure.mgmt.deviceregistry.models.AssetStatus
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.deviceregistry.models.ProvisioningState
    """

    _validation = {
        "uuid": {"readonly": True},
        "asset_endpoint_profile_uri": {"required": True},
        "version": {"readonly": True},
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "uuid": {"key": "uuid", "type": "str"},
        "asset_type": {"key": "assetType", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "external_asset_id": {"key": "externalAssetId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "asset_endpoint_profile_uri": {"key": "assetEndpointProfileUri", "type": "str"},
        "version": {"key": "version", "type": "int"},
        "manufacturer": {"key": "manufacturer", "type": "str"},
        "manufacturer_uri": {"key": "manufacturerUri", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "product_code": {"key": "productCode", "type": "str"},
        "hardware_revision": {"key": "hardwareRevision", "type": "str"},
        "software_revision": {"key": "softwareRevision", "type": "str"},
        "documentation_uri": {"key": "documentationUri", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "attributes": {"key": "attributes", "type": "{object}"},
        "default_data_points_configuration": {"key": "defaultDataPointsConfiguration", "type": "str"},
        "default_events_configuration": {"key": "defaultEventsConfiguration", "type": "str"},
        "data_points": {"key": "dataPoints", "type": "[DataPoint]"},
        "events": {"key": "events", "type": "[Event]"},
        "status": {"key": "status", "type": "AssetStatus"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        asset_endpoint_profile_uri: str,
        asset_type: Optional[str] = None,
        enabled: Optional[bool] = None,
        external_asset_id: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        manufacturer: Optional[str] = None,
        manufacturer_uri: Optional[str] = None,
        model: Optional[str] = None,
        product_code: Optional[str] = None,
        hardware_revision: Optional[str] = None,
        software_revision: Optional[str] = None,
        documentation_uri: Optional[str] = None,
        serial_number: Optional[str] = None,
        attributes: Optional[Dict[str, Any]] = None,
        default_data_points_configuration: Optional[str] = None,
        default_events_configuration: Optional[str] = None,
        data_points: Optional[List["_models.DataPoint"]] = None,
        events: Optional[List["_models.Event"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword asset_type: Resource path to asset type (model) definition.
        :paramtype asset_type: str
        :keyword enabled: Enabled/Disabled status of the asset.
        :paramtype enabled: bool
        :keyword external_asset_id: Asset id provided by the customer.
        :paramtype external_asset_id: str
        :keyword display_name: Human-readable display name.
        :paramtype display_name: str
        :keyword description: Human-readable description of the asset.
        :paramtype description: str
        :keyword asset_endpoint_profile_uri: A reference to the asset endpoint profile (connection
         information) used by brokers to connect to an endpoint that provides data points for this
         asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>. Required.
        :paramtype asset_endpoint_profile_uri: str
        :keyword manufacturer: Asset manufacturer name.
        :paramtype manufacturer: str
        :keyword manufacturer_uri: Asset manufacturer URI.
        :paramtype manufacturer_uri: str
        :keyword model: Asset model name.
        :paramtype model: str
        :keyword product_code: Asset product code.
        :paramtype product_code: str
        :keyword hardware_revision: Revision number of the hardware.
        :paramtype hardware_revision: str
        :keyword software_revision: Revision number of the software.
        :paramtype software_revision: str
        :keyword documentation_uri: Reference to the documentation.
        :paramtype documentation_uri: str
        :keyword serial_number: Asset serial number.
        :paramtype serial_number: str
        :keyword attributes: A set of key-value pairs that contain custom attributes set by the
         customer.
        :paramtype attributes: dict[str, any]
        :keyword default_data_points_configuration: Protocol-specific default configuration for all
         data points. Each data point can have its own configuration that overrides the default settings
         here. This assumes that each asset instance has one protocol.
        :paramtype default_data_points_configuration: str
        :keyword default_events_configuration: Protocol-specific default configuration for all events.
         Each event can have its own configuration that overrides the default settings here. This
         assumes that each asset instance has one protocol.
        :paramtype default_events_configuration: str
        :keyword data_points: Array of data points that are part of the asset. Each data point can
         reference an asset type capability and have per-data point configuration. See below for more
         details for the definition of the dataPoints element.
        :paramtype data_points: list[~azure.mgmt.deviceregistry.models.DataPoint]
        :keyword events: Array of events that are part of the asset. Each event can reference an asset
         type capability and have per-event configuration. See below for more details about the
         definition of the events element.
        :paramtype events: list[~azure.mgmt.deviceregistry.models.Event]
        """
        super().__init__(**kwargs)
        self.uuid = None
        self.asset_type = asset_type
        self.enabled = enabled
        self.external_asset_id = external_asset_id
        self.display_name = display_name
        self.description = description
        self.asset_endpoint_profile_uri = asset_endpoint_profile_uri
        self.version = None
        self.manufacturer = manufacturer
        self.manufacturer_uri = manufacturer_uri
        self.model = model
        self.product_code = product_code
        self.hardware_revision = hardware_revision
        self.software_revision = software_revision
        self.documentation_uri = documentation_uri
        self.serial_number = serial_number
        self.attributes = attributes
        self.default_data_points_configuration = default_data_points_configuration
        self.default_events_configuration = default_events_configuration
        self.data_points = data_points
        self.events = events
        self.status = None
        self.provisioning_state = None


class AssetStatus(_serialization.Model):
    """Defines the asset status properties.

    :ivar errors: Array object to transfer and persist errors that originate from the Edge.
    :vartype errors: list[~azure.mgmt.deviceregistry.models.AssetStatusError]
    :ivar version: A read only incremental counter indicating the number of times the configuration
     has been modified from the perspective of the current actual (Edge) state of the Asset. Edge
     would be the only writer of this value and would sync back up to the cloud. In steady state,
     this should equal version.
    :vartype version: int
    """

    _attribute_map = {
        "errors": {"key": "errors", "type": "[AssetStatusError]"},
        "version": {"key": "version", "type": "int"},
    }

    def __init__(
        self, *, errors: Optional[List["_models.AssetStatusError"]] = None, version: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword errors: Array object to transfer and persist errors that originate from the Edge.
        :paramtype errors: list[~azure.mgmt.deviceregistry.models.AssetStatusError]
        :keyword version: A read only incremental counter indicating the number of times the
         configuration has been modified from the perspective of the current actual (Edge) state of the
         Asset. Edge would be the only writer of this value and would sync back up to the cloud. In
         steady state, this should equal version.
        :paramtype version: int
        """
        super().__init__(**kwargs)
        self.errors = errors
        self.version = version


class AssetStatusError(_serialization.Model):
    """Defines the asset status error properties.

    :ivar code: Error code for classification of errors (ex: 400, 404, 500, etc.).
    :vartype code: int
    :ivar message: Human readable helpful error message to provide additional context for error
     (ex: “capability Id 'foo' does not exist”).
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "int"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[int] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code for classification of errors (ex: 400, 404, 500, etc.).
        :paramtype code: int
        :keyword message: Human readable helpful error message to provide additional context for error
         (ex: “capability Id 'foo' does not exist”).
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class AssetUpdate(_serialization.Model):
    """The type used for update operations of the Asset.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the Asset.
    :vartype properties: ~azure.mgmt.deviceregistry.models.AssetUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "AssetUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AssetUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the Asset.
        :paramtype properties: ~azure.mgmt.deviceregistry.models.AssetUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class AssetUpdateProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The updatable properties of the Asset.

    :ivar asset_type: Resource path to asset type (model) definition.
    :vartype asset_type: str
    :ivar enabled: Enabled/Disabled status of the asset.
    :vartype enabled: bool
    :ivar display_name: Human-readable display name.
    :vartype display_name: str
    :ivar description: Human-readable description of the asset.
    :vartype description: str
    :ivar manufacturer: Asset manufacturer name.
    :vartype manufacturer: str
    :ivar manufacturer_uri: Asset manufacturer URI.
    :vartype manufacturer_uri: str
    :ivar model: Asset model name.
    :vartype model: str
    :ivar product_code: Asset product code.
    :vartype product_code: str
    :ivar hardware_revision: Revision number of the hardware.
    :vartype hardware_revision: str
    :ivar software_revision: Revision number of the software.
    :vartype software_revision: str
    :ivar documentation_uri: Reference to the documentation.
    :vartype documentation_uri: str
    :ivar serial_number: Asset serial number.
    :vartype serial_number: str
    :ivar attributes: A set of key-value pairs that contain custom attributes set by the customer.
    :vartype attributes: dict[str, any]
    :ivar default_data_points_configuration: Protocol-specific default configuration for all data
     points. Each data point can have its own configuration that overrides the default settings
     here. This assumes that each asset instance has one protocol.
    :vartype default_data_points_configuration: str
    :ivar default_events_configuration: Protocol-specific default configuration for all events.
     Each event can have its own configuration that overrides the default settings here. This
     assumes that each asset instance has one protocol.
    :vartype default_events_configuration: str
    :ivar data_points: Array of data points that are part of the asset. Each data point can
     reference an asset type capability and have per-data point configuration. See below for more
     details for the definition of the dataPoints element.
    :vartype data_points: list[~azure.mgmt.deviceregistry.models.DataPoint]
    :ivar events: Array of events that are part of the asset. Each event can reference an asset
     type capability and have per-event configuration. See below for more details about the
     definition of the events element.
    :vartype events: list[~azure.mgmt.deviceregistry.models.Event]
    """

    _attribute_map = {
        "asset_type": {"key": "assetType", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "manufacturer": {"key": "manufacturer", "type": "str"},
        "manufacturer_uri": {"key": "manufacturerUri", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "product_code": {"key": "productCode", "type": "str"},
        "hardware_revision": {"key": "hardwareRevision", "type": "str"},
        "software_revision": {"key": "softwareRevision", "type": "str"},
        "documentation_uri": {"key": "documentationUri", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "attributes": {"key": "attributes", "type": "{object}"},
        "default_data_points_configuration": {"key": "defaultDataPointsConfiguration", "type": "str"},
        "default_events_configuration": {"key": "defaultEventsConfiguration", "type": "str"},
        "data_points": {"key": "dataPoints", "type": "[DataPoint]"},
        "events": {"key": "events", "type": "[Event]"},
    }

    def __init__(
        self,
        *,
        asset_type: Optional[str] = None,
        enabled: Optional[bool] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        manufacturer: Optional[str] = None,
        manufacturer_uri: Optional[str] = None,
        model: Optional[str] = None,
        product_code: Optional[str] = None,
        hardware_revision: Optional[str] = None,
        software_revision: Optional[str] = None,
        documentation_uri: Optional[str] = None,
        serial_number: Optional[str] = None,
        attributes: Optional[Dict[str, Any]] = None,
        default_data_points_configuration: Optional[str] = None,
        default_events_configuration: Optional[str] = None,
        data_points: Optional[List["_models.DataPoint"]] = None,
        events: Optional[List["_models.Event"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword asset_type: Resource path to asset type (model) definition.
        :paramtype asset_type: str
        :keyword enabled: Enabled/Disabled status of the asset.
        :paramtype enabled: bool
        :keyword display_name: Human-readable display name.
        :paramtype display_name: str
        :keyword description: Human-readable description of the asset.
        :paramtype description: str
        :keyword manufacturer: Asset manufacturer name.
        :paramtype manufacturer: str
        :keyword manufacturer_uri: Asset manufacturer URI.
        :paramtype manufacturer_uri: str
        :keyword model: Asset model name.
        :paramtype model: str
        :keyword product_code: Asset product code.
        :paramtype product_code: str
        :keyword hardware_revision: Revision number of the hardware.
        :paramtype hardware_revision: str
        :keyword software_revision: Revision number of the software.
        :paramtype software_revision: str
        :keyword documentation_uri: Reference to the documentation.
        :paramtype documentation_uri: str
        :keyword serial_number: Asset serial number.
        :paramtype serial_number: str
        :keyword attributes: A set of key-value pairs that contain custom attributes set by the
         customer.
        :paramtype attributes: dict[str, any]
        :keyword default_data_points_configuration: Protocol-specific default configuration for all
         data points. Each data point can have its own configuration that overrides the default settings
         here. This assumes that each asset instance has one protocol.
        :paramtype default_data_points_configuration: str
        :keyword default_events_configuration: Protocol-specific default configuration for all events.
         Each event can have its own configuration that overrides the default settings here. This
         assumes that each asset instance has one protocol.
        :paramtype default_events_configuration: str
        :keyword data_points: Array of data points that are part of the asset. Each data point can
         reference an asset type capability and have per-data point configuration. See below for more
         details for the definition of the dataPoints element.
        :paramtype data_points: list[~azure.mgmt.deviceregistry.models.DataPoint]
        :keyword events: Array of events that are part of the asset. Each event can reference an asset
         type capability and have per-event configuration. See below for more details about the
         definition of the events element.
        :paramtype events: list[~azure.mgmt.deviceregistry.models.Event]
        """
        super().__init__(**kwargs)
        self.asset_type = asset_type
        self.enabled = enabled
        self.display_name = display_name
        self.description = description
        self.manufacturer = manufacturer
        self.manufacturer_uri = manufacturer_uri
        self.model = model
        self.product_code = product_code
        self.hardware_revision = hardware_revision
        self.software_revision = software_revision
        self.documentation_uri = documentation_uri
        self.serial_number = serial_number
        self.attributes = attributes
        self.default_data_points_configuration = default_data_points_configuration
        self.default_events_configuration = default_events_configuration
        self.data_points = data_points
        self.events = events


class DataPoint(_serialization.Model):
    """Defines the data point properties.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the data point.
    :vartype name: str
    :ivar data_source: The address of the source of the data in the asset (e.g. URL) so that a
     client can access the data source on the asset. Required.
    :vartype data_source: str
    :ivar capability_id: The path to the type definition of the capability (e.g. DTMI, OPC UA
     information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
    :vartype capability_id: str
    :ivar observability_mode: An indication of how the data point should be mapped to
     OpenTelemetry. Known values are: "none", "counter", "gauge", "histogram", and "log".
    :vartype observability_mode: str or
     ~azure.mgmt.deviceregistry.models.DataPointsObservabilityMode
    :ivar data_point_configuration: Protocol-specific configuration for the data point. For OPC UA,
     this could include configuration like, publishingInterval, samplingInterval, and queueSize.
    :vartype data_point_configuration: str
    """

    _validation = {
        "data_source": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "capability_id": {"key": "capabilityId", "type": "str"},
        "observability_mode": {"key": "observabilityMode", "type": "str"},
        "data_point_configuration": {"key": "dataPointConfiguration", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_source: str,
        name: Optional[str] = None,
        capability_id: Optional[str] = None,
        observability_mode: Union[str, "_models.DataPointsObservabilityMode"] = "none",
        data_point_configuration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the data point.
        :paramtype name: str
        :keyword data_source: The address of the source of the data in the asset (e.g. URL) so that a
         client can access the data source on the asset. Required.
        :paramtype data_source: str
        :keyword capability_id: The path to the type definition of the capability (e.g. DTMI, OPC UA
         information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
        :paramtype capability_id: str
        :keyword observability_mode: An indication of how the data point should be mapped to
         OpenTelemetry. Known values are: "none", "counter", "gauge", "histogram", and "log".
        :paramtype observability_mode: str or
         ~azure.mgmt.deviceregistry.models.DataPointsObservabilityMode
        :keyword data_point_configuration: Protocol-specific configuration for the data point. For OPC
         UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
        :paramtype data_point_configuration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.data_source = data_source
        self.capability_id = capability_id
        self.observability_mode = observability_mode
        self.data_point_configuration = data_point_configuration


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.deviceregistry.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.deviceregistry.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.deviceregistry.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.deviceregistry.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Event(_serialization.Model):
    """Defines the event properties.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the event.
    :vartype name: str
    :ivar event_notifier: The address of the notifier of the event in the asset (e.g. URL) so that
     a client can access the event on the asset. Required.
    :vartype event_notifier: str
    :ivar capability_id: The path to the type definition of the capability (e.g. DTMI, OPC UA
     information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
    :vartype capability_id: str
    :ivar observability_mode: An indication of how the event should be mapped to OpenTelemetry.
     Known values are: "none" and "log".
    :vartype observability_mode: str or ~azure.mgmt.deviceregistry.models.EventsObservabilityMode
    :ivar event_configuration: Protocol-specific configuration for the event. For OPC UA, this
     could include configuration like, publishingInterval, samplingInterval, and queueSize.
    :vartype event_configuration: str
    """

    _validation = {
        "event_notifier": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "event_notifier": {"key": "eventNotifier", "type": "str"},
        "capability_id": {"key": "capabilityId", "type": "str"},
        "observability_mode": {"key": "observabilityMode", "type": "str"},
        "event_configuration": {"key": "eventConfiguration", "type": "str"},
    }

    def __init__(
        self,
        *,
        event_notifier: str,
        name: Optional[str] = None,
        capability_id: Optional[str] = None,
        observability_mode: Union[str, "_models.EventsObservabilityMode"] = "none",
        event_configuration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the event.
        :paramtype name: str
        :keyword event_notifier: The address of the notifier of the event in the asset (e.g. URL) so
         that a client can access the event on the asset. Required.
        :paramtype event_notifier: str
        :keyword capability_id: The path to the type definition of the capability (e.g. DTMI, OPC UA
         information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
        :paramtype capability_id: str
        :keyword observability_mode: An indication of how the event should be mapped to OpenTelemetry.
         Known values are: "none" and "log".
        :paramtype observability_mode: str or ~azure.mgmt.deviceregistry.models.EventsObservabilityMode
        :keyword event_configuration: Protocol-specific configuration for the event. For OPC UA, this
         could include configuration like, publishingInterval, samplingInterval, and queueSize.
        :paramtype event_configuration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.event_notifier = event_notifier
        self.capability_id = capability_id
        self.observability_mode = observability_mode
        self.event_configuration = event_configuration


class ExtendedLocation(_serialization.Model):
    """The extended location.

    All required parameters must be populated in order to send to server.

    :ivar type: The extended location type. Required.
    :vartype type: str
    :ivar name: The extended location name. Required.
    :vartype name: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: str, name: str, **kwargs: Any) -> None:
        """
        :keyword type: The extended location type. Required.
        :paramtype type: str
        :keyword name: The extended location name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.deviceregistry.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.deviceregistry.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.deviceregistry.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.deviceregistry.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.deviceregistry.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.deviceregistry.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.deviceregistry.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.deviceregistry.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.deviceregistry.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class OwnCertificate(_serialization.Model):
    """Certificate or private key that can be used by the southbound connector connecting to the shop
    floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private
    keys.

    :ivar cert_thumbprint: Certificate thumbprint.
    :vartype cert_thumbprint: str
    :ivar cert_secret_reference: Secret Reference name (cert and private key).
    :vartype cert_secret_reference: str
    :ivar cert_password_reference: Secret Reference Name (Pfx or Pem password).
    :vartype cert_password_reference: str
    """

    _attribute_map = {
        "cert_thumbprint": {"key": "certThumbprint", "type": "str"},
        "cert_secret_reference": {"key": "certSecretReference", "type": "str"},
        "cert_password_reference": {"key": "certPasswordReference", "type": "str"},
    }

    def __init__(
        self,
        *,
        cert_thumbprint: Optional[str] = None,
        cert_secret_reference: Optional[str] = None,
        cert_password_reference: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cert_thumbprint: Certificate thumbprint.
        :paramtype cert_thumbprint: str
        :keyword cert_secret_reference: Secret Reference name (cert and private key).
        :paramtype cert_secret_reference: str
        :keyword cert_password_reference: Secret Reference Name (Pfx or Pem password).
        :paramtype cert_password_reference: str
        """
        super().__init__(**kwargs)
        self.cert_thumbprint = cert_thumbprint
        self.cert_secret_reference = cert_secret_reference
        self.cert_password_reference = cert_password_reference


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.deviceregistry.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.deviceregistry.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.deviceregistry.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.deviceregistry.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TransportAuthentication(_serialization.Model):
    """Definition of the authentication mechanism for the southbound connector.

    All required parameters must be populated in order to send to server.

    :ivar own_certificates: Defines a reference to a secret which contains all certificates and
     private keys that can be used by the southbound connector connecting to the shop floor/OT
     device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     Required.
    :vartype own_certificates: list[~azure.mgmt.deviceregistry.models.OwnCertificate]
    """

    _validation = {
        "own_certificates": {"required": True},
    }

    _attribute_map = {
        "own_certificates": {"key": "ownCertificates", "type": "[OwnCertificate]"},
    }

    def __init__(self, *, own_certificates: List["_models.OwnCertificate"], **kwargs: Any) -> None:
        """
        :keyword own_certificates: Defines a reference to a secret which contains all certificates and
         private keys that can be used by the southbound connector connecting to the shop floor/OT
         device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
         Required.
        :paramtype own_certificates: list[~azure.mgmt.deviceregistry.models.OwnCertificate]
        """
        super().__init__(**kwargs)
        self.own_certificates = own_certificates


class TransportAuthenticationUpdate(_serialization.Model):
    """Definition of the authentication mechanism for the southbound connector.

    :ivar own_certificates: Defines a reference to a secret which contains all certificates and
     private keys that can be used by the southbound connector connecting to the shop floor/OT
     device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
    :vartype own_certificates: list[~azure.mgmt.deviceregistry.models.OwnCertificate]
    """

    _attribute_map = {
        "own_certificates": {"key": "ownCertificates", "type": "[OwnCertificate]"},
    }

    def __init__(self, *, own_certificates: Optional[List["_models.OwnCertificate"]] = None, **kwargs: Any) -> None:
        """
        :keyword own_certificates: Defines a reference to a secret which contains all certificates and
         private keys that can be used by the southbound connector connecting to the shop floor/OT
         device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
        :paramtype own_certificates: list[~azure.mgmt.deviceregistry.models.OwnCertificate]
        """
        super().__init__(**kwargs)
        self.own_certificates = own_certificates


class UserAuthentication(_serialization.Model):
    """Definition of the client authentication mechanism to the server.

    All required parameters must be populated in order to send to server.

    :ivar mode: Defines the mode to authenticate the user of the client at the server. Required.
     Known values are: "Anonymous", "Certificate", and "UsernamePassword".
    :vartype mode: str or ~azure.mgmt.deviceregistry.models.UserAuthenticationMode
    :ivar username_password_credentials: Defines the username and password references when
     UsernamePassword user authentication mode is selected.
    :vartype username_password_credentials:
     ~azure.mgmt.deviceregistry.models.UsernamePasswordCredentials
    :ivar x509_credentials: Defines the certificate reference when Certificate user authentication
     mode is selected.
    :vartype x509_credentials: ~azure.mgmt.deviceregistry.models.X509Credentials
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "username_password_credentials": {"key": "usernamePasswordCredentials", "type": "UsernamePasswordCredentials"},
        "x509_credentials": {"key": "x509Credentials", "type": "X509Credentials"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.UserAuthenticationMode"],
        username_password_credentials: Optional["_models.UsernamePasswordCredentials"] = None,
        x509_credentials: Optional["_models.X509Credentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Defines the mode to authenticate the user of the client at the server. Required.
         Known values are: "Anonymous", "Certificate", and "UsernamePassword".
        :paramtype mode: str or ~azure.mgmt.deviceregistry.models.UserAuthenticationMode
        :keyword username_password_credentials: Defines the username and password references when
         UsernamePassword user authentication mode is selected.
        :paramtype username_password_credentials:
         ~azure.mgmt.deviceregistry.models.UsernamePasswordCredentials
        :keyword x509_credentials: Defines the certificate reference when Certificate user
         authentication mode is selected.
        :paramtype x509_credentials: ~azure.mgmt.deviceregistry.models.X509Credentials
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.username_password_credentials = username_password_credentials
        self.x509_credentials = x509_credentials


class UserAuthenticationUpdate(_serialization.Model):
    """Definition of the client authentication mechanism to the server.

    :ivar mode: Defines the mode to authenticate the user of the client at the server. Known values
     are: "Anonymous", "Certificate", and "UsernamePassword".
    :vartype mode: str or ~azure.mgmt.deviceregistry.models.UserAuthenticationMode
    :ivar username_password_credentials: Defines the username and password references when
     UsernamePassword user authentication mode is selected.
    :vartype username_password_credentials:
     ~azure.mgmt.deviceregistry.models.UsernamePasswordCredentialsUpdate
    :ivar x509_credentials: Defines the certificate reference when Certificate user authentication
     mode is selected.
    :vartype x509_credentials: ~azure.mgmt.deviceregistry.models.X509CredentialsUpdate
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "username_password_credentials": {
            "key": "usernamePasswordCredentials",
            "type": "UsernamePasswordCredentialsUpdate",
        },
        "x509_credentials": {"key": "x509Credentials", "type": "X509CredentialsUpdate"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.UserAuthenticationMode"]] = None,
        username_password_credentials: Optional["_models.UsernamePasswordCredentialsUpdate"] = None,
        x509_credentials: Optional["_models.X509CredentialsUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Defines the mode to authenticate the user of the client at the server. Known
         values are: "Anonymous", "Certificate", and "UsernamePassword".
        :paramtype mode: str or ~azure.mgmt.deviceregistry.models.UserAuthenticationMode
        :keyword username_password_credentials: Defines the username and password references when
         UsernamePassword user authentication mode is selected.
        :paramtype username_password_credentials:
         ~azure.mgmt.deviceregistry.models.UsernamePasswordCredentialsUpdate
        :keyword x509_credentials: Defines the certificate reference when Certificate user
         authentication mode is selected.
        :paramtype x509_credentials: ~azure.mgmt.deviceregistry.models.X509CredentialsUpdate
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.username_password_credentials = username_password_credentials
        self.x509_credentials = x509_credentials


class UsernamePasswordCredentials(_serialization.Model):
    """The credentials for authentication mode UsernamePassword.

    All required parameters must be populated in order to send to server.

    :ivar username_reference: A reference to secret containing the username. Required.
    :vartype username_reference: str
    :ivar password_reference: A reference to secret containing the password. Required.
    :vartype password_reference: str
    """

    _validation = {
        "username_reference": {"required": True},
        "password_reference": {"required": True},
    }

    _attribute_map = {
        "username_reference": {"key": "usernameReference", "type": "str"},
        "password_reference": {"key": "passwordReference", "type": "str"},
    }

    def __init__(self, *, username_reference: str, password_reference: str, **kwargs: Any) -> None:
        """
        :keyword username_reference: A reference to secret containing the username. Required.
        :paramtype username_reference: str
        :keyword password_reference: A reference to secret containing the password. Required.
        :paramtype password_reference: str
        """
        super().__init__(**kwargs)
        self.username_reference = username_reference
        self.password_reference = password_reference


class UsernamePasswordCredentialsUpdate(_serialization.Model):
    """The credentials for authentication mode UsernamePassword.

    :ivar username_reference: A reference to secret containing the username.
    :vartype username_reference: str
    :ivar password_reference: A reference to secret containing the password.
    :vartype password_reference: str
    """

    _attribute_map = {
        "username_reference": {"key": "usernameReference", "type": "str"},
        "password_reference": {"key": "passwordReference", "type": "str"},
    }

    def __init__(
        self, *, username_reference: Optional[str] = None, password_reference: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword username_reference: A reference to secret containing the username.
        :paramtype username_reference: str
        :keyword password_reference: A reference to secret containing the password.
        :paramtype password_reference: str
        """
        super().__init__(**kwargs)
        self.username_reference = username_reference
        self.password_reference = password_reference


class X509Credentials(_serialization.Model):
    """The x509 certificate for authentication mode Certificate.

    All required parameters must be populated in order to send to server.

    :ivar certificate_reference: A reference to secret containing the certificate and private key
     (e.g. stored as .der/.pem or .der/.pfx). Required.
    :vartype certificate_reference: str
    """

    _validation = {
        "certificate_reference": {"required": True},
    }

    _attribute_map = {
        "certificate_reference": {"key": "certificateReference", "type": "str"},
    }

    def __init__(self, *, certificate_reference: str, **kwargs: Any) -> None:
        """
        :keyword certificate_reference: A reference to secret containing the certificate and private
         key (e.g. stored as .der/.pem or .der/.pfx). Required.
        :paramtype certificate_reference: str
        """
        super().__init__(**kwargs)
        self.certificate_reference = certificate_reference


class X509CredentialsUpdate(_serialization.Model):
    """The x509 certificate for authentication mode Certificate.

    :ivar certificate_reference: A reference to secret containing the certificate and private key
     (e.g. stored as .der/.pem or .der/.pfx).
    :vartype certificate_reference: str
    """

    _attribute_map = {
        "certificate_reference": {"key": "certificateReference", "type": "str"},
    }

    def __init__(self, *, certificate_reference: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword certificate_reference: A reference to secret containing the certificate and private
         key (e.g. stored as .der/.pem or .der/.pfx).
        :paramtype certificate_reference: str
        """
        super().__init__(**kwargs)
        self.certificate_reference = certificate_reference
