# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cosmosdb.aio import CosmosDBManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCosmosDBManagementDataTransferJobsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CosmosDBManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_create(self, resource_group):
        response = await self.client.data_transfer_jobs.create(
            resource_group_name=resource_group.name,
            account_name="str",
            job_name="str",
            job_create_parameters={
                "properties": {
                    "destination": "data_transfer_data_source_sink",
                    "source": "data_transfer_data_source_sink",
                    "duration": "str",
                    "error": {"code": "str", "message": "str"},
                    "jobName": "str",
                    "lastUpdatedUtcTime": "2020-02-20 00:00:00",
                    "mode": "str",
                    "processedCount": 0,
                    "status": "str",
                    "totalCount": 0,
                    "workerCount": 0,
                },
                "id": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.data_transfer_jobs.get(
            resource_group_name=resource_group.name,
            account_name="str",
            job_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_pause(self, resource_group):
        response = await self.client.data_transfer_jobs.pause(
            resource_group_name=resource_group.name,
            account_name="str",
            job_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_resume(self, resource_group):
        response = await self.client.data_transfer_jobs.resume(
            resource_group_name=resource_group.name,
            account_name="str",
            job_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cancel(self, resource_group):
        response = await self.client.data_transfer_jobs.cancel(
            resource_group_name=resource_group.name,
            account_name="str",
            job_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_complete(self, resource_group):
        response = await self.client.data_transfer_jobs.complete(
            resource_group_name=resource_group.name,
            account_name="str",
            job_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_database_account(self, resource_group):
        response = self.client.data_transfer_jobs.list_by_database_account(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
