# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementSnapshotsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.snapshots.begin_create_or_update(
            resource_group_name=resource_group.name,
            snapshot_name="str",
            snapshot={
                "location": "str",
                "accountType": "str",
                "creationData": {
                    "createOption": "str",
                    "imageReference": {"id": "str", "lun": 0},
                    "sourceResourceId": "str",
                    "sourceUri": "str",
                    "storageAccountId": "str",
                },
                "diskSizeGB": 0,
                "encryptionSettings": {
                    "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                    "enabled": bool,
                    "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                },
                "id": "str",
                "name": "str",
                "osType": "str",
                "ownerId": "str",
                "provisioningState": "str",
                "tags": {"str": "str"},
                "timeCreated": "2020-02-20 00:00:00",
                "type": "str",
            },
            api_version="2016-04-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update(self, resource_group):
        response = self.client.snapshots.begin_update(
            resource_group_name=resource_group.name,
            snapshot_name="str",
            snapshot={
                "accountType": "str",
                "creationData": {
                    "createOption": "str",
                    "imageReference": {"id": "str", "lun": 0},
                    "sourceResourceId": "str",
                    "sourceUri": "str",
                    "storageAccountId": "str",
                },
                "diskSizeGB": 0,
                "encryptionSettings": {
                    "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                    "enabled": bool,
                    "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                },
                "osType": "str",
                "tags": {"str": "str"},
            },
            api_version="2016-04-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.snapshots.get(
            resource_group_name=resource_group.name,
            snapshot_name="str",
            api_version="2016-04-30-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.snapshots.begin_delete(
            resource_group_name=resource_group.name,
            snapshot_name="str",
            api_version="2016-04-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.snapshots.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2016-04-30-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.snapshots.list(
            api_version="2016-04-30-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_grant_access(self, resource_group):
        response = self.client.snapshots.begin_grant_access(
            resource_group_name=resource_group.name,
            snapshot_name="str",
            grant_access_data={"access": "str", "durationInSeconds": 0},
            api_version="2016-04-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_revoke_access(self, resource_group):
        response = self.client.snapshots.begin_revoke_access(
            resource_group_name=resource_group.name,
            snapshot_name="str",
            api_version="2016-04-30-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
