# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.web import WebSiteManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebSiteManagementAppServiceCertificateOrdersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebSiteManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.app_service_certificate_orders.list(
            api_version="2023-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_validate_purchase_information(self, resource_group):
        response = self.client.app_service_certificate_orders.validate_purchase_information(
            app_service_certificate_order={
                "location": "str",
                "appServiceCertificateNotRenewableReasons": ["str"],
                "autoRenew": True,
                "certificates": {"str": {"keyVaultId": "str", "keyVaultSecretName": "str", "provisioningState": "str"}},
                "contact": {"email": "str", "nameFirst": "str", "nameLast": "str", "phone": "str"},
                "csr": "str",
                "distinguishedName": "str",
                "domainVerificationToken": "str",
                "expirationTime": "2020-02-20 00:00:00",
                "id": "str",
                "intermediate": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "isPrivateKeyExternal": bool,
                "keySize": 2048,
                "kind": "str",
                "lastCertificateIssuanceTime": "2020-02-20 00:00:00",
                "name": "str",
                "nextAutoRenewalTimeStamp": "2020-02-20 00:00:00",
                "productType": "str",
                "provisioningState": "str",
                "root": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "serialNumber": "str",
                "signedCertificate": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "status": "str",
                "tags": {"str": "str"},
                "type": "str",
                "validityInYears": 1,
            },
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.app_service_certificate_orders.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.app_service_certificate_orders.get(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.app_service_certificate_orders.begin_create_or_update(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            certificate_distinguished_name={
                "location": "str",
                "appServiceCertificateNotRenewableReasons": ["str"],
                "autoRenew": True,
                "certificates": {"str": {"keyVaultId": "str", "keyVaultSecretName": "str", "provisioningState": "str"}},
                "contact": {"email": "str", "nameFirst": "str", "nameLast": "str", "phone": "str"},
                "csr": "str",
                "distinguishedName": "str",
                "domainVerificationToken": "str",
                "expirationTime": "2020-02-20 00:00:00",
                "id": "str",
                "intermediate": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "isPrivateKeyExternal": bool,
                "keySize": 2048,
                "kind": "str",
                "lastCertificateIssuanceTime": "2020-02-20 00:00:00",
                "name": "str",
                "nextAutoRenewalTimeStamp": "2020-02-20 00:00:00",
                "productType": "str",
                "provisioningState": "str",
                "root": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "serialNumber": "str",
                "signedCertificate": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "status": "str",
                "tags": {"str": "str"},
                "type": "str",
                "validityInYears": 1,
            },
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.app_service_certificate_orders.delete(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.app_service_certificate_orders.update(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            certificate_distinguished_name={
                "appServiceCertificateNotRenewableReasons": ["str"],
                "autoRenew": True,
                "certificates": {"str": {"keyVaultId": "str", "keyVaultSecretName": "str", "provisioningState": "str"}},
                "contact": {"email": "str", "nameFirst": "str", "nameLast": "str", "phone": "str"},
                "csr": "str",
                "distinguishedName": "str",
                "domainVerificationToken": "str",
                "expirationTime": "2020-02-20 00:00:00",
                "id": "str",
                "intermediate": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "isPrivateKeyExternal": bool,
                "keySize": 2048,
                "kind": "str",
                "lastCertificateIssuanceTime": "2020-02-20 00:00:00",
                "name": "str",
                "nextAutoRenewalTimeStamp": "2020-02-20 00:00:00",
                "productType": "str",
                "provisioningState": "str",
                "root": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "serialNumber": "str",
                "signedCertificate": {
                    "issuer": "str",
                    "notAfter": "2020-02-20 00:00:00",
                    "notBefore": "2020-02-20 00:00:00",
                    "rawData": "str",
                    "serialNumber": "str",
                    "signatureAlgorithm": "str",
                    "subject": "str",
                    "thumbprint": "str",
                    "version": 0,
                },
                "status": "str",
                "type": "str",
                "validityInYears": 1,
            },
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_certificates(self, resource_group):
        response = self.client.app_service_certificate_orders.list_certificates(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            api_version="2023-12-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_certificate(self, resource_group):
        response = self.client.app_service_certificate_orders.get_certificate(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update_certificate(self, resource_group):
        response = self.client.app_service_certificate_orders.begin_create_or_update_certificate(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            name="str",
            key_vault_certificate={
                "location": "str",
                "id": "str",
                "keyVaultId": "str",
                "keyVaultSecretName": "str",
                "kind": "str",
                "name": "str",
                "provisioningState": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2023-12-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete_certificate(self, resource_group):
        response = self.client.app_service_certificate_orders.delete_certificate(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update_certificate(self, resource_group):
        response = self.client.app_service_certificate_orders.update_certificate(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            name="str",
            key_vault_certificate={
                "id": "str",
                "keyVaultId": "str",
                "keyVaultSecretName": "str",
                "kind": "str",
                "name": "str",
                "provisioningState": "str",
                "type": "str",
            },
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reissue(self, resource_group):
        response = self.client.app_service_certificate_orders.reissue(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            reissue_certificate_order_request={
                "csr": "str",
                "delayExistingRevokeInHours": 0,
                "id": "str",
                "isPrivateKeyExternal": bool,
                "keySize": 0,
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_renew(self, resource_group):
        response = self.client.app_service_certificate_orders.renew(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            renew_certificate_order_request={
                "csr": "str",
                "id": "str",
                "isPrivateKeyExternal": bool,
                "keySize": 0,
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resend_email(self, resource_group):
        response = self.client.app_service_certificate_orders.resend_email(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resend_request_emails(self, resource_group):
        response = self.client.app_service_certificate_orders.resend_request_emails(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            name_identifier={"name": "str"},
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_retrieve_site_seal(self, resource_group):
        response = self.client.app_service_certificate_orders.retrieve_site_seal(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            site_seal_request={"lightTheme": bool, "locale": "str"},
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_verify_domain_ownership(self, resource_group):
        response = self.client.app_service_certificate_orders.verify_domain_ownership(
            resource_group_name=resource_group.name,
            certificate_order_name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_retrieve_certificate_actions(self, resource_group):
        response = self.client.app_service_certificate_orders.retrieve_certificate_actions(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_retrieve_certificate_email_history(self, resource_group):
        response = self.client.app_service_certificate_orders.retrieve_certificate_email_history(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2023-12-01",
        )

        # please add some check logic here by yourself
        # ...
