# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_create_or_update_request(management_group_id: str, group_quota_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01-preview"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url(
            "management_group_id", management_group_id, "str", max_length=63, min_length=3
        ),
        "groupQuotaName": _SERIALIZER.url(
            "group_quota_name", group_quota_name, "str", max_length=63, min_length=3, pattern=r"^[a-z][a-z0-9]*$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_request(management_group_id: str, group_quota_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01-preview"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url(
            "management_group_id", management_group_id, "str", max_length=63, min_length=3
        ),
        "groupQuotaName": _SERIALIZER.url(
            "group_quota_name", group_quota_name, "str", max_length=63, min_length=3, pattern=r"^[a-z][a-z0-9]*$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(management_group_id: str, group_quota_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url(
            "management_group_id", management_group_id, "str", max_length=63, min_length=3
        ),
        "groupQuotaName": _SERIALIZER.url(
            "group_quota_name", group_quota_name, "str", max_length=63, min_length=3, pattern=r"^[a-z][a-z0-9]*$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(management_group_id: str, group_quota_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url(
            "management_group_id", management_group_id, "str", max_length=63, min_length=3
        ),
        "groupQuotaName": _SERIALIZER.url(
            "group_quota_name", group_quota_name, "str", max_length=63, min_length=3, pattern=r"^[a-z][a-z0-9]*$"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_request(management_group_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupId": _SERIALIZER.url(
            "management_group_id", management_group_id, "str", max_length=63, min_length=3
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class GroupQuotasOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.quota.QuotaMgmtClient`'s
        :attr:`group_quotas` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    def _create_or_update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[Union[_models.GroupQuotasEntity, IO[bytes]]] = None,
        **kwargs: Any
    ) -> Union[_models.GroupQuotasEntity, _models.LROResponse]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Union[_models.GroupQuotasEntity, _models.LROResponse]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(group_quota_put_request_body, (IOBase, bytes)):
            _content = group_quota_put_request_body
        else:
            if group_quota_put_request_body is not None:
                _json = self._serialize.body(group_quota_put_request_body, "GroupQuotasEntity")
            else:
                _json = None

        _request = build_create_or_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize("GroupQuotasEntity", pipeline_response)

        if response.status_code == 201:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )

            deserialized = self._deserialize("LROResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[_models.GroupQuotasEntity] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Creates a new GroupQuota for the name passed.

        Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The
        status can be polled periodically. The status Async polling is using standards defined at -
        https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quota_put_request_body: The GroupQuota body details for creation or update of a
         GroupQuota entity. Default value is None.
        :type group_quota_put_request_body: ~azure.mgmt.quota.models.GroupQuotasEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns either GroupQuotasEntity or An instance of
         LROPoller that returns either LROResponse or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity] or
         ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.LROResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Creates a new GroupQuota for the name passed.

        Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The
        status can be polled periodically. The status Async polling is using standards defined at -
        https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quota_put_request_body: The GroupQuota body details for creation or update of a
         GroupQuota entity. Default value is None.
        :type group_quota_put_request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns either GroupQuotasEntity or An instance of
         LROPoller that returns either LROResponse or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity] or
         ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.LROResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_create_or_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quota_put_request_body: Optional[Union[_models.GroupQuotasEntity, IO[bytes]]] = None,
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Creates a new GroupQuota for the name passed.

        Creates a new GroupQuota for the name passed. A RequestId will be returned by the Service. The
        status can be polled periodically. The status Async polling is using standards defined at -
        https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quota_put_request_body: The GroupQuota body details for creation or update of a
         GroupQuota entity. Is either a GroupQuotasEntity type or a IO[bytes] type. Default value is
         None.
        :type group_quota_put_request_body: ~azure.mgmt.quota.models.GroupQuotasEntity or IO[bytes]
        :return: An instance of LROPoller that returns either GroupQuotasEntity or An instance of
         LROPoller that returns either LROResponse or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity] or
         ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.LROResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GroupQuotasEntity] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._create_or_update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                group_quota_put_request_body=group_quota_put_request_body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("GroupQuotasEntity", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotasEntity].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotasEntity](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    def _update_initial(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[Union[_models.GroupQuotasEntityPatch, IO[bytes]]] = None,
        **kwargs: Any
    ) -> Optional[_models.GroupQuotasEntity]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.GroupQuotasEntity]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(group_quotas_patch_request_body, (IOBase, bytes)):
            _content = group_quotas_patch_request_body
        else:
            if group_quotas_patch_request_body is not None:
                _json = self._serialize.body(group_quotas_patch_request_body, "GroupQuotasEntityPatch")
            else:
                _json = None

        _request = build_update_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize("GroupQuotasEntity", pipeline_response)

        if response.status_code == 202:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[_models.GroupQuotasEntityPatch] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Updates a new GroupQuotas for the name passed.

        Updates the GroupQuotas for the name passed. A GroupQuotas RequestId will be returned by the
        Service. The status can be polled periodically. The status Async polling is using standards
        defined at -
        https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.
         Any change in the filters will be applicable to the future quota assignments, existing quota
        allocated to subscriptions from the GroupQuotas remains unchanged.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quotas_patch_request_body: The  GroupQuotas Patch Request. Default value is None.
        :type group_quotas_patch_request_body: ~azure.mgmt.quota.models.GroupQuotasEntityPatch
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns either GroupQuotasEntity or the result of
         cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Updates a new GroupQuotas for the name passed.

        Updates the GroupQuotas for the name passed. A GroupQuotas RequestId will be returned by the
        Service. The status can be polled periodically. The status Async polling is using standards
        defined at -
        https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.
         Any change in the filters will be applicable to the future quota assignments, existing quota
        allocated to subscriptions from the GroupQuotas remains unchanged.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quotas_patch_request_body: The  GroupQuotas Patch Request. Default value is None.
        :type group_quotas_patch_request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns either GroupQuotasEntity or the result of
         cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_update(
        self,
        management_group_id: str,
        group_quota_name: str,
        group_quotas_patch_request_body: Optional[Union[_models.GroupQuotasEntityPatch, IO[bytes]]] = None,
        **kwargs: Any
    ) -> LROPoller[_models.GroupQuotasEntity]:
        """Updates a new GroupQuotas for the name passed.

        Updates the GroupQuotas for the name passed. A GroupQuotas RequestId will be returned by the
        Service. The status can be polled periodically. The status Async polling is using standards
        defined at -
        https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/async-api-reference.md#asynchronous-operations.
        Use the OperationsStatus URI provided in Azure-AsyncOperation header, the duration will be
        specified in retry-after header. Once the operation gets to terminal state - Succeeded |
        Failed, then the URI will change to Get URI and full details can be checked.
         Any change in the filters will be applicable to the future quota assignments, existing quota
        allocated to subscriptions from the GroupQuotas remains unchanged.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :param group_quotas_patch_request_body: The  GroupQuotas Patch Request. Is either a
         GroupQuotasEntityPatch type or a IO[bytes] type. Default value is None.
        :type group_quotas_patch_request_body: ~azure.mgmt.quota.models.GroupQuotasEntityPatch or
         IO[bytes]
        :return: An instance of LROPoller that returns either GroupQuotasEntity or the result of
         cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GroupQuotasEntity] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._update_initial(
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                group_quotas_patch_request_body=group_quotas_patch_request_body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("GroupQuotasEntity", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.GroupQuotasEntity].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.GroupQuotasEntity](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def get(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> _models.GroupQuotasEntity:
        """Gets GroupQuotas for the name passed.

        Gets the GroupQuotas for the name passed. It will return the GroupQuotas properties only. The
        details on group quota can be access from the group quota APIs.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: GroupQuotasEntity or the result of cls(response)
        :rtype: ~azure.mgmt.quota.models.GroupQuotasEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.GroupQuotasEntity] = kwargs.pop("cls", None)

        _request = build_get_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("GroupQuotasEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, management_group_id: str, group_quota_name: str, **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            management_group_id=management_group_id,
            group_quota_name=group_quota_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def begin_delete(self, management_group_id: str, group_quota_name: str, **kwargs: Any) -> LROPoller[None]:
        """Deletes GroupQuotas for the name passed.

        Deletes the GroupQuotas for the name passed. All the remaining shareQuota in the GroupQuotas
        will be lost.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :param group_quota_name: The GroupQuota name. The name should be unique for the provided
         context tenantId/MgId. Required.
        :type group_quota_name: str
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._delete_initial(  # type: ignore
                management_group_id=management_group_id,
                group_quota_name=group_quota_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list(self, management_group_id: str, **kwargs: Any) -> Iterable["_models.GroupQuotasEntity"]:
        """Lists GroupQuotas for the scope passed.

        Lists GroupQuotas for the scope passed. It will return the GroupQuotas QuotaEntity properties
        only.The details on group quota can be access from the group quota APIs.

        :param management_group_id: Management Group Id. Required.
        :type management_group_id: str
        :return: An iterator like instance of either GroupQuotasEntity or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.quota.models.GroupQuotasEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.GroupQuotaList] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    management_group_id=management_group_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("GroupQuotaList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
