# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementDedicatedHostGroupsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update(self, resource_group):
        response = self.client.dedicated_host_groups.create_or_update(
            resource_group_name=resource_group.name,
            host_group_name="str",
            parameters={
                "location": "str",
                "hosts": [{"id": "str"}],
                "id": "str",
                "name": "str",
                "platformFaultDomainCount": 0,
                "tags": {"str": "str"},
                "type": "str",
                "zones": ["str"],
            },
            api_version="2019-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.dedicated_host_groups.update(
            resource_group_name=resource_group.name,
            host_group_name="str",
            parameters={
                "hosts": [{"id": "str"}],
                "platformFaultDomainCount": 0,
                "tags": {"str": "str"},
                "zones": ["str"],
            },
            api_version="2019-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.dedicated_host_groups.delete(
            resource_group_name=resource_group.name,
            host_group_name="str",
            api_version="2019-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.dedicated_host_groups.get(
            resource_group_name=resource_group.name,
            host_group_name="str",
            api_version="2019-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.dedicated_host_groups.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2019-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription(self, resource_group):
        response = self.client.dedicated_host_groups.list_by_subscription(
            api_version="2019-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
