# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.web import WebSiteManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-web
# USAGE
    python update_site_config.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = WebSiteManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="34adfa4f-cedf-4dc0-ba29-b6d1a69ab345",
    )

    response = client.web_apps.create_or_update_configuration(
        resource_group_name="testrg123",
        name="sitef6141",
        site_config={
            "properties": {
                "acrUseManagedIdentityCreds": False,
                "alwaysOn": False,
                "appCommandLine": "",
                "autoHealEnabled": False,
                "azureStorageAccounts": {},
                "defaultDocuments": [
                    "Default.htm",
                    "Default.html",
                    "Default.asp",
                    "index.htm",
                    "index.html",
                    "iisstart.htm",
                    "default.aspx",
                    "index.php",
                    "hostingstart.html",
                ],
                "detailedErrorLoggingEnabled": False,
                "ftpsState": "AllAllowed",
                "functionAppScaleLimit": 0,
                "functionsRuntimeScaleMonitoringEnabled": False,
                "http20Enabled": False,
                "httpLoggingEnabled": False,
                "linuxFxVersion": "",
                "loadBalancing": "LeastRequests",
                "logsDirectorySizeLimit": 35,
                "managedPipelineMode": "Integrated",
                "minTlsVersion": "1.2",
                "minimumElasticInstanceCount": 0,
                "netFrameworkVersion": "v4.0",
                "nodeVersion": "",
                "numberOfWorkers": 1,
                "phpVersion": "5.6",
                "powerShellVersion": "",
                "pythonVersion": "",
                "remoteDebuggingEnabled": False,
                "requestTracingEnabled": False,
                "scmMinTlsVersion": "1.2",
                "use32BitWorkerProcess": True,
                "virtualApplications": [{"physicalPath": "site\\wwwroot", "preloadEnabled": False, "virtualPath": "/"}],
                "vnetName": "",
                "vnetPrivatePortsCount": 0,
                "vnetRouteAllEnabled": False,
                "webSocketsEnabled": False,
            }
        },
    )
    print(response)


# x-ms-original-file: specification/web/resource-manager/Microsoft.Web/stable/2023-12-01/examples/UpdateSiteConfig.json
if __name__ == "__main__":
    main()
