# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.datafactory import DataFactoryManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-datafactory
# USAGE
    python pipelines_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DataFactoryManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="12345678-1234-1234-1234-12345678abc",
    )

    response = client.pipelines.create_or_update(
        resource_group_name="exampleResourceGroup",
        factory_name="exampleFactoryName",
        pipeline_name="examplePipeline",
        pipeline={
            "properties": {
                "activities": [
                    {
                        "name": "ExampleForeachActivity",
                        "type": "ForEach",
                        "typeProperties": {
                            "activities": [
                                {
                                    "inputs": [
                                        {
                                            "parameters": {
                                                "MyFileName": "examplecontainer.csv",
                                                "MyFolderPath": "examplecontainer",
                                            },
                                            "referenceName": "exampleDataset",
                                            "type": "DatasetReference",
                                        }
                                    ],
                                    "name": "ExampleCopyActivity",
                                    "outputs": [
                                        {
                                            "parameters": {
                                                "MyFileName": {"type": "Expression", "value": "@item()"},
                                                "MyFolderPath": "examplecontainer",
                                            },
                                            "referenceName": "exampleDataset",
                                            "type": "DatasetReference",
                                        }
                                    ],
                                    "type": "Copy",
                                    "typeProperties": {
                                        "dataIntegrationUnits": 32,
                                        "sink": {"type": "BlobSink"},
                                        "source": {"type": "BlobSource"},
                                    },
                                }
                            ],
                            "isSequential": True,
                            "items": {"type": "Expression", "value": "@pipeline().parameters.OutputBlobNameList"},
                        },
                    }
                ],
                "parameters": {"JobId": {"type": "String"}, "OutputBlobNameList": {"type": "Array"}},
                "policy": {"elapsedTimeMetric": {"duration": "0.00:10:00"}},
                "runDimensions": {"JobId": {"type": "Expression", "value": "@pipeline().parameters.JobId"}},
                "variables": {"TestVariableArray": {"type": "Array"}},
            }
        },
    )
    print(response)


# x-ms-original-file: specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/Pipelines_Create.json
if __name__ == "__main__":
    main()
