# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementVirtualMachineScaleSetVMsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_reimage(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_set_vms.begin_reimage(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                instance_id="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_deallocate(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_set_vms.begin_deallocate(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                instance_id="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_set_vms.begin_delete(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                instance_id="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.virtual_machine_scale_set_vms.get(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            instance_id="str",
            api_version="2015-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_instance_view(self, resource_group):
        response = await self.client.virtual_machine_scale_set_vms.get_instance_view(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            instance_id="str",
            api_version="2015-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.virtual_machine_scale_set_vms.list(
            resource_group_name=resource_group.name,
            virtual_machine_scale_set_name="str",
            api_version="2015-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_power_off(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_set_vms.begin_power_off(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                instance_id="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_restart(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_set_vms.begin_restart(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                instance_id="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_start(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_set_vms.begin_start(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                instance_id="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
