<!--- Provide a general summary of your changes in the Title above -->
<!-- You can erase any parts of this template not applicable to your Pull Request. -->
<!-- Show that you have done a step, by checking the checkboxes and/or adding the requested information. -->

<!--- This project only accepts pull requests related to open issues -->
<!--- If suggesting a new feature or change, please discuss it in an issue first -->
<!--- If fixing a bug, there should be an issue describing it with steps to reproduce -->
<!--- Please link to the issue here: -->

*Any change needs to be discussed before proceeding. Failure to do so may result in the rejection of the pull request.*

<!-- You can skip this if you're fixing a typo. -->

Thanks for submitting a pull request! It's great, that you want contribute to pyDataverse. Please provide enough information so that others can review it.

First, start always by reading the [Contribution Guide](https://pydataverse.readthedocs.io/en/master/contributing/contributing.html). There you can find all information needed, to create good pull requests.

### All Submissions

**Describe your environment**

* [ ] OS: NAME, VERSION, 64/32bit <!-- (e. g. Linux, Ubuntu 18.04, 64bit) -->
* [ ] pyDataverse: VERSION <!-- (e. g. 0.2.1) -->
* [ ] Python: VERSION <!-- (e. g. 3.6.9) -->
* [ ] Dataverse: VERSION <!-- (optional, e. g. 4.18.1) -->

**Follow best practices**

* [ ] Have you checked to ensure there aren't other open [Pull Requests](https://github.com/gdcc/pyDataverse/pulls) for the same update/change?
* [ ] Have you followed the guidelines in our [Contribution Guide](https://pydataverse.readthedocs.io/en/master/contributing/contributing.html)?
* [ ] Have you read the [Code of Conduct](https://github.com/gdcc/pyDataverse/blob/master/CODE_OF_CONDUCT.md)?
* [ ] Do your changes in a seperate branch. Branches MUST have descriptive names.
* [ ] Have you merged the latest changes from upstream to your branch?

**Describe the PR**

* [ ] What kind of change does this PR introduce?
  * TEXT <!-- (Bug fix, feature, improvement, docs) -->
* [ ] Why is this change required? What problem does it solve?
  * TEXT
* [ ] Screenshots (if appropriate)
* [ ] Put `Closes #ISSUE_NUMBER` to the end of this pull request <!-- (e. g. Closes #1234) -->

**Testing**

* [ ] Have you used tox and/or pytest for testing the changes?
* [ ] Did the local testing ran successfully?
* [ ] Did the Continous Integration testing (Travis-CI) ran successfully?

**Commits**

* [ ] Have descriptive commit messages with a short title (first line).
* [ ] Use the [commit message template](https://github.com/gdcc/pyDataverse/blob/master/.github/.gitmessage.txt)
* [ ] Put `Closes #ISSUE_NUMBER` in your commit messages to auto-close the issue that it fixes (if such).

**Others**

* [ ] Is there anything you need from someone else?

### Documentation contribution

* [ ] Have you followed NumPy Docstring standard?

### Code contribution

* [ ] Have you used pre-commit?
* [ ] Have you formatted your code with black prior to submission (e. g. via pre-commit)?
* [ ] Have you written new tests for your changes?
* [ ] Have you ran mypy on your changes successfully?
* [ ] Have you documented your update (Docstrings and/or Docs)?
* [ ] Do your changes require additional changes to the documentation?


Closes #ISSUE_NUMBER
