# Using `nox`

Here are a few extra tips for using `nox`.

:::{seealso}
The [`nox` command line documentation](https://nox.thea.codes/en/stable/usage.html) has a lot of helpful tips for extra functionality you can enable with the CLI.
:::

## Re-install dependencies

To re-execute the installation commands, use this pattern:

```console
$ nox -s docs -- reinstall
```

Or to completely remove the environment generated by `nox` and start from scratch:

```console
$ rm -rf .nox/docs
```

## Use `nox` with your global environment

If you'd like to use `nox` with your **global** environment (the one from which you are calling `nox`), you can do so with:

```console
$ nox --force-venv-backend none

# alternatively:
$ nox --no-venv
```

Using `none` will re-use your current global environment.
See
[the nox documentation](https://nox.thea.codes/en/stable/usage.html#forcing-the-sessions-backend) for more details.
