# Compiler configuration
IF(WIN32)
    IF(MSVC)
        SET(PONYPROG_COMPILER_MSVC TRUE)
    ELSE(MSVC)
        SET(PONYPROG_COMPILER_GCC TRUE)
    ENDIF(MSVC)
ELSE(WIN32)
    SET(PONYPROG_COMPILER_GCC TRUE)
ENDIF(WIN32)

# Win32 API configuration
IF(WIN32)
    SET(PONYPROG_API_WIN32 TRUE)
ENDIF(WIN32)

# Darwin API configuration
IF(APPLE)
    SET(PONYPROG_API_DARWIN TRUE)

  EXECUTE_PROCESS(
    COMMAND sw_vers -productVersion
    OUTPUT_VARIABLE PONYPROG_OSX_VERSION
    )
  STRING(REGEX REPLACE "([0-9]*)[.]([0-9]*)[.]([0-9]*).*" "\\1" PONYPROG_OSX_MAJOR_VERSION "${PONYPROG_OSX_VERSION}")
  STRING(REGEX REPLACE "([0-9]*)[.]([0-9]*)[.]([0-9]*).*" "\\2" PONYPROG_OSX_MINOR_VERSION "${PONYPROG_OSX_VERSION}")

ENDIF(APPLE)

