------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--         P O L Y O R B . U T I L S . H F U N C T I O N S . M U L          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (C) 2003 Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                PolyORB is maintained by ACT Europe.                      --
--                    (email: sales@act-europe.fr)                          --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides a simple class of hashing functions for strings.

--  Hash_Mul computes for string S = (Si)i the sum of the elements
--     Hi (S) = (( K * Si ) mod Prime) mod Size

--  Note: this class of function is not universal.

package PolyORB.Utils.HFunctions.Mul is

   pragma Preelaborate;

   function Hash_Mul
     (S     : String;
      K     : Natural;
      Prime : Natural;
      Size  : Natural)
     return Natural;
   --  Hash function implemented by this package.
   --  S: key to hash,
   --  (K, Prime): Hash function parameters,
   --  Size: restrict results to range O .. Size - 1.

   type Hash_Mul_Parameters is new Hash_Parameters with private;

   function Hash
     (S     : String;
      Param : Hash_Mul_Parameters;
      Size  : Natural)
     return Natural;

   function Default_Hash_Parameters
     return Hash_Mul_Parameters;
   pragma Inline (Default_Hash_Parameters);

   function Next_Hash_Parameters
     (Param : Hash_Mul_Parameters)
     return Hash_Mul_Parameters;

private

   type Hash_Mul_Parameters is new Hash_Parameters with record
      K     : Natural;
      Prime : Natural;
   end record;

end PolyORB.Utils.HFunctions.Mul;
