/*
 *   Copyright 2009 - 2010 by Giulio Camuffo <giuliocamuffo@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef BUTTONS_H
#define BUTTONS_H

#include <QtGui/QGraphicsWidget>

class FlowLayout;

namespace Plasma
{
    class IconWidget;
};

class WolfButtons : public QGraphicsWidget
{
    Q_OBJECT
    public:
        WolfButtons(QGraphicsWidget *parent);
        ~WolfButtons();

        enum STATUS{
            PLAYING,
            PAUSED,
            STOPPED,
            CLOSED
        };

        void setIsAmarokButtonVisible(bool visible);
        bool isAmarokButtonVisible();

    protected:
        void resizeEvent(QGraphicsSceneResizeEvent *event);

    public slots:
        void setStatus(int status);

    signals:
        void playPausePressed();
        void stopPressed();
        void prevPressed();
        void nextPressed();
        void showAmarokPressed();

    private:
        void adjustLayoutSpacing();

        FlowLayout *m_layout;
        Plasma::IconWidget *m_playPause;
        Plasma::IconWidget *m_stop;
        Plasma::IconWidget *m_next;
        Plasma::IconWidget *m_prev;
        Plasma::IconWidget *m_showAmarok;
};
 
#endif
