/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __COMMANDEECHAPPEMENT__
#define __COMMANDEECHAPPEMENT__

#include <src/global/global.h>

typedef struct commandeechappement CONTENEUR(CommandeEchappement);

#include <src/donnees/flux/flux.h>
#include <src/donnees/flux/actionflux.h>
#include <src/donnees/commandes/localisationfichier.h>

struct commandeechappement
{
	STOCKAGE(LocalisationFichier) localisation;
	//Localisation du caractre d'echappement dans le source.
	STOCKAGE_SCALAIRE(Caractere) caractere;
	//Contient le caractre d'chappement.
	//Attention au cas du retour-chariot,
	//o la commande est limine.
};
/* Commande destine  recevoir les caractres chapps dans un flux de texte.
 */

Resultat commandeechappement_initialisation(TRAVAIL(CommandeEchappement) commandeechappement);
/* Cre une commande d'chappement de caractre vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandeechappement_definition_localisationfichier(TRAVAIL(CommandeEchappement) commandeechappement , TRAVAIL(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande d'echappement de caractre.
 * Renvoie RESULTAT_ERREUR si commandeechappement est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandeechappement_definition_caractere(TRAVAIL(CommandeEchappement) commandeechappement , TRAVAIL_SCALAIRE(Caractere) caractere);
/* Assigne un caractre d'chappement.
 * Renvoie RESULTAT_ERREUR si commandeechappement est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandeechappement_lecture_localisationfichier(TRAVAIL(CommandeEchappement) commandeechappement , REFERENCE(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande d'echappement de caractre.
 * Renvoie RESULTAT_ERREUR si commandeechappement est NULL.
 */

Resultat commandeechappement_lecture_caractere(TRAVAIL(CommandeEchappement) commandeechappement , REFERENCE_SCALAIRE(Caractere) caractere);
/* Lit un caractre d'chappement.
 * Renvoie RESULTAT_ERREUR si commandeechappement est NULL.
 */

Resultat commandeechappement_remplacement_texte(TRAVAIL(CommandeEchappement) commandeechappement , TRAVAIL_SCALAIRE(Booleen) danstexte , REFERENCE_SCALAIRE(Texte) texte);
/* Renvoie le texte quivalent d'une commande d'echappement.
 * Le boolen est utilis pour savoir si la commande d'echappement
 * de caractres est situe ou non au milieu d'un texte.
 * La chaine renvoye devra tre dsalloue  la main.
 * Renvoie RESULTAT_ERREUR si commandeechappement est NULL,
 * et RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandeechappement_parcours(TRAVAIL(CommandeEchappement) commandeechappement , TRAVAIL(ActionFlux) action , TRAVAIL(General) general);
/* Ralise un parcours des flux inclus dans la commande spcifie.
 * Renvoie les mmes erreurs que flux_parcours,
 * ainsi que RESULTAT_ERREUR si commande est NULL,
 * rien ne se passe si action est NULL.
 */

Resultat commandeechappement_copie(TRAVAIL(CommandeEchappement) commandeechappement , TRAVAIL(CommandeEchappement) copie);
/* Cre une copie de la commande d'chappement de caractre.
 * Renvoie RESULTAT_ERREUR si commandeechappement est NULL, et
 * RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * Si la copie est non vide, elle est au pralable supprime.
 */

Resultat commandeechappement_destruction(TRAVAIL(CommandeEchappement) commandeechappement);
/* Dtruit une commande d'chappement de caractre.
 */

#endif
