#!/usr/bin/perl

print "header {\n";
print "    title = \"Syslog picviz analysis\";\n";
print "}\n";
print "engine {\n";
print "    relative = \"1\";\n";
print "}\n";
print "axes {\n";
print "    timeline t [label=\"Time\"];\n"; # Time
print "    string   m [label=\"Machine\"];\n"; # Machine
print "    string   s [label=\"Service\"];\n"; # Service
print "    string   pam [label=\"Module\"];\n"; # PAM Module
print "    string   srcuser [label=\"Src user\"];\n"; # User
print "    string   dstuser [label=\"Dst user\"];\n"; # User
print "}\n";

print "data {\n";

while ($line = <>) {

        $line =~ s/\"/\\"/g; # We escape our quotes
        $line =~ s/&//g; # We escape our quotes
        $line =~ s/<//g; # We escape our quotes
        $line =~ s/>//g; # We escape our quotes

#Jul  1 22:39:02 quinificated CRON[3392]: pam_unix(cron:session): session opened for user root by (uid=0)
#Jul  1 22:44:33 quinificated su[3444]: pam_unix(su:session): session opened for user root by toady(uid=0)
#Jul  2 07:14:33 quinificated kdm: :0[3267]: pam_unix(kdm:session): session opened for user toady by (uid=0)
	if ($line =~ m/\w+  ?\d+ (\d+:\d+:\d+) ([\w-.]+) (\w+)[\[|:].*: (\S+)\(.*\): session opened for user (\w+) by(.*)\(.*/) {
        	$t=$1;
        	$m=$2;
        	$s=$3;
        	$pam=$4;
		$dstuser=$5;
		$srcuser=$6;

		if ($s !~ m/CRON/) { # I don't care of cron tasks (this is how you should attack me ;-) )
			$dstuser =~ s/^\s+//;
                        if ($dstuser =~ m/root/) {
			        print "    t=\"$t\",m=\"$m\",s=\"$s\",pam=\"$pam\",srcuser=\"$srcuser\",dstuser=\"$dstuser\" [color=\"red\"];\n";
                        } else {
			        print "    t=\"$t\",m=\"$m\",s=\"$s\",pam=\"$pam\",srcuser=\"$srcuser\",dstuser=\"$dstuser\";\n";
                        }
		}
	}
}

print "}\n";

