Author: Christian Hammers  <ch@debian.org>
   2 Subject: Executes /etc/init.d/mysql on signals
   3  Note if you check the bug report on mysql.com the patch is accepted
   4  as interesting but they were waiting on Christian Hammers to sign an SCA.
   5  Meanwhile this bug report fell off in the transition from 5.0 to 5.1.
   6 Bug: http://bugs.mysql.com/bug.php?id=31361
   7 Debian-Bug: http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=527623
   8 Last-Update: 2012-03-07
   9 Reviewed-by: Nicholas Bamber <nicholas@periapt.co.uk>

--- a/scripts/mysqld_safe.sh
+++ b/scripts/mysqld_safe.sh
@@ -40,9 +40,6 @@
 syslog_tag_mysqld_safe=mysqld_safe
 syslog_facility=daemon
 
-trap '' 1 2 3 15			# we shouldn't let anyone kill us
-trap '' 13                              # not even SIGPIPE
-
 # MySQL-specific environment variable. First off, it's not really a umask,
 # it's the desired mode. Second, it follows umask(2), not umask(3) in that
 # octal needs to be explicit. Our shell might be a proper sh without printf,
@@ -171,7 +168,7 @@
       else
         echo "$msg" >> "$err_log"
       fi
-      logger -t "$syslog_tag_mysqld_safe" -p "$priority" "$*"
+      logger -t "$syslog_tag_mysqld_safe" -p "$priority" "$*" & wait
       ;;
     *)
       echo "Internal program error (non-fatal):" \
@@ -1130,6 +1127,12 @@
   fi
 fi
 
+# From now on, we catch signals to do a proper shutdown of mysqld
+# when signalled to do so.
+#
+trap '/usr/bin/mysqladmin --defaults-extra-file=/etc/mysql/debian.cnf refresh & wait' 1 # HUP
+trap '/usr/bin/mysqladmin --defaults-extra-file=/etc/mysql/debian.cnf shutdown' 2 3 15 # INT QUIT and TERM
+
 #
 # Uncomment the following lines if you want all tables to be automatically
 # checked and repaired during startup. You should add sensible key_buffer
