/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                             avtSiloOptions.C                              //
// ************************************************************************* //

#include <avtSiloOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;
using namespace SiloDBOptions;

// ****************************************************************************
//  Function: GetSiloReadOptions
//
//  Purpose:
//      Creates the options for Silo readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 14:10:56 PST 2007
//
//    Mark C. Miller, Wed Dec 24 01:30:35 PST 2008
//    Added option for ANNOTATION_INT nodelists. Ordinarily, we'd just want
//    the database to tell us when these exist. However, there is no way to
//    do that without also taking a big performance hit of having to open all
//    the subfiles in a multi-file Silo file. So, we make it the user's 
//    responsibility to turn on this functionality via a read option.
//
//    Mark C. Miller, Wed Mar  4 08:56:57 PST 2009
//    Made controls for ignoring extents tri-state.
//
//    Mark C. Miller, Mon Mar 16 23:31:58 PDT 2009
//    Added logic for obsolete options.
//    Added const names of options to SiloDBOptions namespace
// ****************************************************************************

DBOptionsAttributes *
GetSiloReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    vector<string> ignoreOpts;
    ignoreOpts.push_back("Always"); // 0
    ignoreOpts.push_back("Auto");   // 1
    ignoreOpts.push_back("Never");  // 2
    ignoreOpts.push_back("Undef");  // 3
    rv->SetEnum(SILO_RDOPT_IGNORE_SEXTS, 3); // Undef 
    rv->SetEnumStrings(SILO_RDOPT_IGNORE_SEXTS, ignoreOpts);
    rv->SetEnum(SILO_RDOPT_IGNORE_DEXTS, 3); // Undef 
    rv->SetEnumStrings(SILO_RDOPT_IGNORE_DEXTS, ignoreOpts);
    rv->SetBool(SILO_RDOPT_FORCE_SINGLE, false);
    rv->SetBool(SILO_RDOPT_SEARCH_ANNOTINT, false);

    // Specify obsolete options and their default values
    rv->SetObsolete(SILO_RDOPT_IGNORE_SEXTS2);
    rv->SetObsolete(SILO_RDOPT_IGNORE_DEXTS2);

    return rv;
}


// ****************************************************************************
//  Function: GetSiloWriteOptions
//
//  Purpose:
//      Creates the options for Silo writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 14:10:56 PST 2007
//
//    Mark C. Miller, Thu Jul 31 18:06:08 PDT 2008
//    Added option to write all data to a single file 
//
//    Mark C. Miller, Tue Mar 17 18:13:22 PDT 2009
//    Use const char * option name symbols defined in avtSiloOptions.h

//    Mark C. Miller, Fri May  8 17:09:39 PDT 2009
//    Added compression/checksum options.
// ****************************************************************************

DBOptionsAttributes *
GetSiloWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    //
    // Driver type options
    //
    rv->SetEnum(SILO_WROPT_DRIVER, 0);
    vector<string> drivers;
    drivers.push_back("PDB");  // 0
    drivers.push_back("HDF5"); // 1
    rv->SetEnumStrings(SILO_WROPT_DRIVER, drivers);
    rv->SetBool(SILO_WROPT_SINGLE_FILE, false);
    rv->SetBool(SILO_WROPT_CKSUMS, false);
    rv->SetString(SILO_WROPT_COMPRESSION, "");

    return rv;
}
