# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-775-2 (quagga)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64199);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Ubuntu USN-775-2 (quagga)";
 script_name(name);

 desc = "The remote host is missing an update to quagga
announced via advisory USN-775-2.

Details follow:

USN-775-1 fixed vulnerabilities in Quagga.  The preventative fixes
introduced in Quagga prior to Ubuntu 9.04 could result in BGP service
failures.  This update fixes the problem.

We apologize for the inconvenience.

Original advisory details:

 It was discovered that the BGP service in Quagga did not correctly
 handle certain AS paths containing 4-byte ASNs.  An authenticated remote
 attacker could exploit this flaw to cause bgpd to abort, leading to a
 denial of service.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  quagga                          0.99.2-1ubuntu3.6

Ubuntu 8.04 LTS:
  quagga                          0.99.9-2ubuntu1.3

Ubuntu 8.10:
  quagga                          0.99.9-6ubuntu0.2

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-775-2

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-775-2 (quagga)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"quagga-doc", ver:"0.99.2-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga", ver:"0.99.2-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga-doc", ver:"0.99.9-2ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga", ver:"0.99.9-2ubuntu1.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga-doc", ver:"0.99.9-6ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"quagga", ver:"0.99.9-6ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
