###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_w3c_amaya_mult_bof_vuln_dec08_win.nasl 553 2008-12-03 11:40:16Z dec $
#
# W3C Amaya Multiple Buffer Overflow Vulnerabilities - Dec08 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800311);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5282");
  script_bugtraq_id(32442);
  script_name("W3C Amaya Multiple Buffer Overflow Vulnerabilities - Dec08 (Win)");
  desc = "

  Overview: This host is installed with W3C Amaya Web Browser and is prone to
  Multiple Stack based Buffer Overflow Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to boundary error when processing,
  - HTML <div> tag with a long id field.
  - link with a long HREF attribute.

  Impact:
  Successful exploitation could allow execution of arbitrary code or
  crash an affected browser.

  Impact Level: Application

  Affected Software/OS:
  W3C Amaya Web Browser Version 10.0.1 and prior on Windows

  Fix: Update to higher version.
  http://www.w3.org/Amaya/User/BinDist.html

  References:
  http://secunia.com/advisories/32848
  http://www.bmgsec.com.au/advisories/amaya-id.txt
  http://www.bmgsec.com.au/advisories/amaya-url.txt
  http://www.vupen.com/english/advisories/2008/3255

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of W3C Amaya Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
keys = registry_enum_keys(key:key);

foreach item (keys)
{
  if("Amaya" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    w3cVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(!w3cVer){
      exit(0);
    }

    if(version_is_less_equal(version:w3cVer, test_version:"10.0.1")){
      security_hole(0);
      exit(0);
    }
  }
}
