###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_windows_media_player_bof_vuln.nasl 7495 2010-03-01 13:48:24Z mar $
#
# Microsoft Windows Media Player '.mpg' Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800480);
  script_version("$Revision: 7613 $: 1.0");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2010-0718");
  script_name("Microsoft Windows Media Player '.mpg' Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is installed with Windows Media Player and is prone to
  Buffer Overflow vulnerability.

  Vulnerability Insight:
  This flaw is due to a boundary checking error while opening a specially-crafted
  '.mpg' audio files.

  Impact:
  Successful exploitation will lets attacker execute arbitrary codes in
  the context of the affected player.

  Impact Level: System/Application

  Affected Software/OS:
  Windows Media Player version 9.x and 11 to 11.0.5721.5145.

  Fix:
  No solution or patch is available as on 01st March, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/windowsmedia/default.mspx

  References:
  http://xforce.iss.net/xforce/xfdb/56435
  http://www.exploit-db.com/exploits/11531

  CVSS Score:
    CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Windows Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_ms_win_media_player_detect_900173.nasl");
  script_require_keys("Win/MediaPlayer/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

wmpVer = get_kb_item("Win/MediaPlayer/Ver");
if(!wmpVer){
  exit(0);
}

if( wmpVer =~ "^(9|11])\..*$")
{
  # Check for Windows Media Player version 9.x, 11 to 11.0.5721.5145
  if((wmpVer =~ "^9.*") ||
      version_in_range(version:wmpVer, tets_version:"11.0", test_version2:"11.0.5721.5145")){
    security_hole(0);
  }
}
