###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_cfnetwork_src_dos_vuln.nasl 7545 2010-03-04 11:20:26Z mar $
#
# Apple Safari 'SRC' Remote Denial Of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800486);
  script_version("$Revision: 7611 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2010-0925");
  script_name("Apple Safari 'SRC' Remote Denial Of Service Vulnerability");
  desc = "
  Overview: This host is installed with Apple Safari Web Browser and is prone to
  to Denial of Service vulnerabilities.

  Vulnerability Insight:
  The flaw exist due to error in 'cfnetwork.dll' file in CFNetwork when, processing
  'SRC' attribute of a 'IMG' or 'IFRAME' element via a long string.

  Impact:
  Successful exploitation will let the attacker crash the affected browser,
  resulting in a denial of service condition and can cause other attacks.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari version 4.0.4(5.31.21.10)

  Fix:
  No solution or patch is available as on as on 03rd March, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads

  References:
  http://en.securitylab.ru/nvd/391341.php
  http://nobytes.com/exploits/Safari_4.0.4_background_DoS_pl.txt

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 4.5
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Apple Safari and cfnetwork.dll");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

function find_version(filepath)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:filepath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:filepath);
  dllVer = GetVer(file:file, share:share);
  return dllVer;
}

safariVer = get_kb_item("AppleSafari/Version");
if(!safariVer){
  exit(0);
}

# Check for Apple Safari Version 4.0.4(5.31.21.10)
if(version_is_equal(version:safariVer, test_version:"5.31.21.10"))
{
  key = "SOFTWARE\Apple Computer, Inc.\Safari";
  asFile = registry_get_sz(item:"BrowserExe", key:key);
  if(asFile)
  {
    exeVer = find_version(filepath:asFile);
    if(!isnull(exeVer))
    {
      # Check for Safari.exe Version 5.31.21.10
      if(version_is_equal(version:exeVer, test_version:"5.31.21.10"))
      {
        dllVer = find_version(filepath: asFile -"Safari.exe" + "cfnetwork.dll");
        if(isnull(dllVer))
        {
          dllVer = find_version(filepath:asFile - "\Safari\Safari.exe" +
                   "\Common Files\Apple\Apple Application Support\cfnetwork.dll");
        }

        if(!isnull(dllVer))
        {
          # Check for cfnetwork.dll Version 1.450.5.0
          if(version_is_equal(version:dllVer, test_version:"1.450.5.0")){
            security_warning(0);
          }
        }
      }
    }
  }
}
