#
#VID 92fd40eb-c458-11da-9c79-00123ffe8333
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56522);
 script_bugtraq_id(17314);
 script_cve_id("CVE-2006-1059");
 script_version ("$");
 script_tag(name:"cvss_base", value:"1.2");
 script_tag(name:"risk_factor", value:"Low");
 name = "FreeBSD Ports: samba";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   samba
   ja-samba

CVE-2006-1059
The winbindd daemon in Samba 3.0.21 to 3.0.21c writes the machine
trust account password in cleartext in log files, which allows local
users to obtain the password and spoof the server in the domain.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://us1.samba.org/samba/security/CAN-2006-1059.html
http://secunia.com/advisories/19455/
http://www.vuxml.org/freebsd/92fd40eb-c458-11da-9c79-00123ffe8333.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: samba";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"samba");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.21a,1")>=0 && revcomp(a:bver, b:"3.0.22,1")<0) {
    security_note(0, data:"Package samba version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-samba");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.21a,1")>=0 && revcomp(a:bver, b:"3.0.22,1")<0) {
    security_note(0, data:"Package ja-samba version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
