# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 620-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53457);
 script_cve_id("CVE-2004-0452", "CVE-2004-0976");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 620-1 (perl)";
 script_name(name);

 desc = "The remote host is missing an update to perl
announced via advisory DSA 620-1.

Several vulnerabilities have been discovered in Perl, the popular
scripting language.  The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2004-0452

Jeroen van Wolffelaar discovered that the rmtree() function in the
File::Path module removes directory trees in an insecure manner
which could lead to the removal of arbitrary files and directories
through a symlink attack.

CVE-2004-0976

Trustix developers discovered several insecure uses of temporary
files in many modules which allow a local attacker to overwrite
files via a symlink attack.

For the stable distribution (woody) these problems have been fixed in
version 5.6.1-8.8.

For the unstable distribution (sid) these problems have been fixed in
version 5.8.4-5.

We recommend that you upgrade your perl packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20620-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 620-1 (perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.6", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.6.1-8.8", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
