# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1409-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(59637);
 script_cve_id("CVE-2007-4572", "CVE-2007-5398");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1409-2 (samba)";
 script_name(name);

 desc = "The remote host is missing an update to samba
announced via advisory DSA 1409-2.

The previous security update for samba introduced regressions in
the handling of the depreciated filesystem smbfs.  This update fixes
the regression(s) whilst still fixing the security problems.
The original text is reproduced below:

Several local/remote vulnerabilities have been discovered in samba,
a LanManager-like file and printer server for Unix. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-5398

Alin Rad Pop of Secunia Research discovered that nmbd did not properly
check the length of netbios packets. When samba is configured as a WINS
server, a remote attacker could send multiple crafted requests resulting
in the execution of arbitrary code with root privileges.

CVE-2007-4572
Samba developers discovered that nmbd could be made to overrun a buffer
during the processing of GETDC logon server requests.  When samba is
configured as a Primary or Backup Domain Controller, a remote attacker
could send malicious logon requests and possibly cause a denial of
service.

For the stable distribution (etch), these problems have been fixed in
version 3.0.24-6etch7.

For the old stable distribution (sarge), these problems have been fixed in
version 3.0.14a-3sarge9.

For the unstable distribution (sid), these problems have been fixed in
version 3.0.27-1.

We recommend that you upgrade your samba packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201409-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1409-2 (samba)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.14a-3sarge8", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-samba", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.0.14a-3sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.24-6etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-samba", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.24-6etch7", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
