# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 121-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53397);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 121-1 (xtell)";
 script_name(name);

 desc = "The remote host is missing an update to xtell
announced via advisory DSA 121-1.

Several security related problems have been found in the xtell
package, a simple messaging client and server.  In detail, these
problems contain several buffer overflows, a problem in connection
with symbolic links, unauthorized directory traversal when the path
contains ...  These problems could lead into an attacker being able
to execute arbitrary code on the server machine.  The server runs with
nobody privileges by default, so this would be the account to be
exploited.

They have been corrected by backporting changes from a newer upstream
version by the Debian maintainer for xtell.  These problems are fixed
in version 1.91.1 in the stable distribution of Debian and in version
2.7 for the testing and unstable distribution of Debian.

We recommend that you upgrade your xtell packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20121-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 121-1 (xtell)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xtell", ver:"1.91.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
