/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLFRAGMENT_PARSER_H_
#define _GTLFRAGMENT_PARSER_H_

#include "GTLCore/ParserBase_p.h"

namespace GTLCore {
  namespace AST {
    class Tree;
  }
}

namespace GTLFragment {
  class Compiler;
  class Lexer;
  /**
   * @internal
   * @ingroup GTLFragment
   *
   * This is the parser of shiva kernels and rijn sketches.
   */
  class Parser : public GTLCore::ParserBase {
    public:
      /**
       * Create a new parser using the @ref Compiler @p _compiler and the @ref Lexer
       * @p _lexer .
       */
      Parser( Compiler* _compiler, Lexer* _lexer);
      ~Parser();
      /**
       * Start parsing and return the resulting @ref GTLCore::AST::Tree or null if the parsing failed
       */
      GTLCore::AST::Tree* parse();
    protected:
      virtual GTLCore::AST::Tree* tree();
      virtual GTLCore::AST::Statement* parseStatement();
      virtual const GTLCore::Type* parseType();
    protected: // Events
      virtual GTLCore::AST::StatementsList* startParsingFunction( const GTLCore::String& _name );
      virtual void endParsingFunction( const GTLCore::String& _name );
      virtual bool validateFunctionParameters(const GTLCore::Function* function);
    private:
      void parseDependentDeclaration();
      void parseKernelBody();
    private:
      struct Private;
      Private* const d;
  };
}

#endif
