/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_METADATA_PARAMETER_ENTRY_H_
#define _GTLCORE_METADATA_PARAMETER_ENTRY_H_

#include <GTLCore/Metadata/Group.h>

namespace GTLCore {
  class Type;
  class Value;
  namespace Metadata {
    /**
     * @ingroup GTLCore_Metadata
     * @brief represent a parameter entry in a metadata
     * 
     * This metadata @ref Entry is a @ref Group countaining at least a name,
     * a default value and a widget type.
     */
    class GTLCORE_EXPORT ParameterEntry : public Group {
      friend class Factory;
        GTL_NO_COPY(ParameterEntry);
      private:
        ParameterEntry( const GTLCore::String& _name, const std::list< const Entry* >& _entries );
        virtual ~ParameterEntry();
      public:
      public:
        /**
         * @return the minimum value
         */
        Value minimumValue() const;
        /**
         * @return the maximum value
         */
        Value maximumValue() const;
        /**
         * @return the default value
         */
        Value defaultValue() const;
        /**
         * @return the type of the value
         */
        const Type* type() const;
        /**
         * @return a description of this parameter
         */
        GTLCore::String description() const;
      public:
        virtual const ParameterEntry* asParameterEntry() const;
      private:
        struct Private;
        Private* const d;
    };
  }
}

#endif
