// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Convert_CircleToBSplineCurve_HeaderFile
#define _Convert_CircleToBSplineCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Convert_ConicToBSplineCurve_HeaderFile
#include <Convert_ConicToBSplineCurve.hxx>
#endif
#ifndef _Convert_ParameterisationType_HeaderFile
#include <Convert_ParameterisationType.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class gp_Circ2d;



//!  This algorithm converts a circle into a rational B-spline curve. <br>
//!  The circle is a Circ2d from package gp and its parametrization is : <br>
//!  P (U) = Loc + R * (Cos(U) * Xdir + Sin(U) * YDir) where Loc is the <br>
//!  center of the circle Xdir and Ydir are the normalized directions <br>
//!  of the local cartesian coordinate system of the circle. <br>
//!  The parametrization range for the circle is U [0, 2Pi]. <br>
//! <br>
//! Warnings : <br>
//!  The parametrization range for the B-spline curve is not [0, 2Pi]. <br>
//! <br>
//! KeyWords : <br>
//!  Convert, Circle, BSplineCurve, 2D . <br>
class Convert_CircleToBSplineCurve  : public Convert_ConicToBSplineCurve {
public:

  DEFINE_STANDARD_ALLOC

  
//!  The equivalent B-spline curve has the same orientation <br>
//!  as the circle C. <br>
  Standard_EXPORT   Convert_CircleToBSplineCurve(const gp_Circ2d& C,const Convert_ParameterisationType Parameterisation = Convert_TgtThetaOver2);
  
//!  The circle C is limited between the parametric values U1, U2 <br>
//!  in radians. U1 and U2 [0.0, 2*Pi] . <br>
//!  The equivalent B-spline curve is oriented from U1 to U2 and has <br>
//!  the same orientation as the circle C. <br>
//!  Raised if U1 = U2 or U1 = U2 + 2.0 * Pi <br>
  Standard_EXPORT   Convert_CircleToBSplineCurve(const gp_Circ2d& C,const Standard_Real U1,const Standard_Real U2,const Convert_ParameterisationType Parameterisation = Convert_TgtThetaOver2);





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
