<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/integrations/disk_statistics.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/metadata.yaml"
sidebar_label: "Disk Statistics"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems/Disk"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Disk Statistics


<img src="https://netdata.cloud/img/hard-drive.svg" width="150"/>


Plugin: proc.plugin
Module: /proc/diskstats

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Detailed statistics for each of your system's disk devices and partitions.
The data is reported by the kernel and can be used to monitor disk activity on a Linux system.

Get valuable insight into how your disks are performing and where potential bottlenecks might be.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Disk Statistics instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.io | in, out | KiB/s |

### Per disk



Labels:

| Label      | Description     |
|:-----------|:----------------|
| device | TBD |
| mount_point | TBD |
| device_type | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| disk.io | reads, writes | KiB/s |
| disk_ext.io | discards | KiB/s |
| disk.ops | reads, writes | operations/s |
| disk_ext.ops | discards, flushes | operations/s |
| disk.qops | operations | operations |
| disk.backlog | backlog | milliseconds |
| disk.busy | busy | milliseconds |
| disk.util | utilization | % of time working |
| disk.mops | reads, writes | merged operations/s |
| disk_ext.mops | discards | merged operations/s |
| disk.iotime | reads, writes | milliseconds/s |
| disk_ext.iotime | discards, flushes | milliseconds/s |
| disk.await | reads, writes | milliseconds/operation |
| disk_ext.await | discards, flushes | milliseconds/operation |
| disk.avgsz | reads, writes | KiB/operation |
| disk_ext.avgsz | discards | KiB/operation |
| disk.svctm | svctm | milliseconds/operation |
| disk.bcache_cache_alloc | ununsed, dirty, clean, metadata, undefined | percentage |
| disk.bcache_hit_ratio | 5min, 1hour, 1day, ever | percentage |
| disk.bcache_rates | congested, writeback | KiB/s |
| disk.bcache_size | dirty | MiB |
| disk.bcache_usage | avail | percentage |
| disk.bcache_cache_read_races | races, errors | operations/s |
| disk.bcache | hits, misses, collisions, readaheads | operations/s |
| disk.bcache_bypass | hits, misses | operations/s |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ 10min_disk_backlog ](https://github.com/netdata/netdata/blob/master/health/health.d/disks.conf) | disk.backlog | average backlog size of the ${label:device} disk over the last 10 minutes |
| [ 10min_disk_utilization ](https://github.com/netdata/netdata/blob/master/health/health.d/disks.conf) | disk.util | average percentage of time ${label:device} disk was busy over the last 10 minutes |
| [ bcache_cache_dirty ](https://github.com/netdata/netdata/blob/master/health/health.d/bcache.conf) | disk.bcache_cache_alloc | percentage of cache space used for dirty data and metadata (this usually means your SSD cache is too small) |
| [ bcache_cache_errors ](https://github.com/netdata/netdata/blob/master/health/health.d/bcache.conf) | disk.bcache_cache_read_races | number of times data was read from the cache, the bucket was reused and invalidated in the last 10 minutes (when this occurs the data is reread from the backing device) |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


