/*
 * NASPRO - The NASPRO Architecture for Sound PROcessing
 * Core library
 *
 * Copyright (C) 2007-2013 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

/*
   Title: Unnamed semaphores

   Unnamed semaphores.
 */

#ifndef _NASPRO_CORE_SEM_H
#define _NASPRO_CORE_SEM_H

#ifndef _NASPRO_CORE_LIB_H
# error Only <NASPRO/core/lib.h> can be included directly.
#endif

NACORE_BEGIN_C_DECLS

/*
   Type: nacore_sem

   Semaphore.
 */
typedef struct _nacore_sem *nacore_sem;

/*
   Function: nacore_sem_new()

   Creates a new semaphore.

   Parameters:

     value	- Initial value.

   Returns:

     The newly created semaphore or NULL if some error occured, in which case
     errno is set to ENOMEM if there was not enough memory, EINVAL if value is
     too big or <NACORE_EUNKNOWN> if another kind of error happened.
 */
_NACORE_DEF nacore_sem
nacore_sem_new(unsigned int value);

/*
   Function: nacore_sem_free()

   Destroys a semaphore.

   Once this function is called, referring to mutex will cause undefined
   behavior.

   Parameters:

     sem	- The semaphore to be destroyed.
 */
_NACORE_DEF void
nacore_sem_free(nacore_sem sem);

/*
   Function: nacore_sem_wait()

   Locks a semaphore.

   Parameters:

     sem	- The sempahore to be locked.

   Returns:

     0 on success or EINTR if the call was interrupted by a signal.
 */
_NACORE_DEF int
nacore_sem_wait(nacore_sem sem);

/*
   Function: nacore_sem_trywait()

   Attempts to lock a semaphore.

   If the semaphore is already locked the call shall return immediately.

   Parameters:

     sem	- The semaphore to be locked.

   Returns:

     0 on success, EAGAIN if the semaphore was already locked or EINTR if the
     call was interrupted by a signal.
 */
_NACORE_DEF int
nacore_sem_trywait(nacore_sem sem);

/*
   Function: nacore_sem_post()

   Unlocks a semaphore.

   Parameters:

     sem	- The semaphore to be unlocked.

   Returns:

     0 on success or <NACORE_EUNKNOWN> if some error happened.
 */
_NACORE_DEF int
nacore_sem_post(nacore_sem sem);

NACORE_END_C_DECLS

#endif
