Contributing to mkdocs-macros
=============================

If you want to help, you've come to the right place.

## Code of Conduct
The vast majority of developers are good people, and this is a peaceful community.

If you have any uncertainty, **apply the Golden Rule**:

- What wouldn't you want other members of this community do to you? Don't do that to others.
- How would you like to be treated by other members of this community? Treat them in that way.

For broad guidelines, members of this community uphold
the [Universal Declaration of Human Rights](https://www.un.org/en/about-us/universal-declaration-of-human-rights):
the answer to an issue might be in the first lines of the preamble, or in any of the 30 articles.



## Discussions: Questions, usage problem, ideas for evolution?


If you have:
- 🙏 something you don't know how to make work, 
  or you don't know how to do it (after reading the [documentation](https://mkdocs-macros-plugin.readthedocs.io/en/latest/))
- 🙌 a hint on how to use Mkdocs-Macros,
- 💡 an idea for a new feature or a change
- 📣 something you want everyone to know


then open a **discussion** on the [project's forum](https://github.com/fralau/mkdocs_macros_plugin/discussions).

The author of this project will do his best to review them all.


!!! Tip "Your input and your ideas are valuable: tell about them!"

## Software issues

If you notice a bug, a problem with a new version, or the necessity
for maintenance, open an issue on the [project's forum](https://github.com/fralau/mkdocs_macros_plugin/discussions)

!!! Important "Do not use issues for questions or discussions"
    For that, open a discussion [project's forum](https://github.com/fralau/mkdocs_macros_plugin/discussions)





## Pull Requests

Contributions of [PRs (Pull Requests)](https://github.com/fralau/mkdocs_macros_plugin/pulls) are welcome (but only after an issue
has already been discussed).

Always indicate, in the pull request, the number of the issue (e.g. #15)
that refers to the problem you are seeking to solve.

Pull requests without an issue number will not be considered.

More information on how to make pull requests can be found on [GitHub's docs](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests).

!!! Note "Important rule: Open an issue first!"

    **But** there is a rule: **[Always open an issue first](https://github.com/fralau/mkdocs_macros_plugin/issues)**, and get a feedback.

    It's in everybody's interest to have a little discussion first:
    
    - Perhaps the issue has already been fixed? 
    - There is a different way to do things?
    - There is a pitfall to watch for? 
    - Perhaps your good idea could even be made better? 🙂

If you submit a PR on github without referring to existing issue,
you will likely be asked to open one, before anything else happens.

If you have several PRs on the same issue, continue to refer to that
issue.

## Want to correct or contribute documentation?

!!! Tip "Code is docs, and docs is code"
    There is no substantial difference between code and documentation:
    
    - Code is for machines.
    - Documentation is for humans.
    - Sometimes the division between the two is not even clear.

Apply the same principles for documentation as [for code](#want-to-contribute-code).
